/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.lcdp.modeldriven.config;

import com.digiwin.app.dao.DWQueryInfo;
import com.digiwin.app.data.DWDataSetOperationOption;
import com.digiwin.app.eai.DWEAIProperties;
import com.digiwin.app.persistconn.TokenProvider;
import com.digiwin.app.service.commons.config.DWServiceCommonsProvider;
import com.digiwin.app.service.eai.DWEAIHeader;
import com.digiwin.app.service.eai.DWEAIHeaderRepository;
import com.digiwin.app.service.eai.DWEAIServiceDefinitionParser;
import com.digiwin.app.service.eai.EAIService;
import com.digiwin.gateway.controller.EaiInfoUtils;
import com.digiwin.http.client.DWHttpClient;
import com.digiwin.http.client.DWRequestOption;
import com.digiwin.http.client.entity.DWJsonEntity;
import com.digiwin.lcdp.modeldriven.config.ModelDrivenCommonsAutoConfiguration;
import com.digiwin.lcdp.modeldriven.config.condition.ModelDrivenEaiRegProdSrvCondition;
import com.digiwin.lcdp.modeldriven.constants.ESPConstants;
import com.digiwin.lcdp.modeldriven.model.ModelDrivenEaiMethodRepository;
import com.digiwin.lcdp.modeldriven.pojo.DWServiceMappingProvider;
import com.digiwin.lcdp.modeldriven.pojo.MappingModelInfo;
import com.digiwin.lcdp.modeldriven.pojo.ModelDrivenEaiMethodDTO;
import com.digiwin.lcdp.modeldriven.service.impl.ModelDrivenEAIMappingService;
import com.digiwin.lcdp.modeldriven.utils.EaiHeaderUtil;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.commons.io.IOUtils;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Conditional;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.DependsOn;
import org.springframework.core.env.Environment;

@Configuration
@AutoConfigureAfter(value={ModelDrivenCommonsAutoConfiguration.class})
public class ModelDrivenEAIRestfulUrlRegisterAutoConfiguration {
    private static final Logger log = LoggerFactory.getLogger(ModelDrivenEAIRestfulUrlRegisterAutoConfiguration.class);
    @Autowired
    private DWEAIHeaderRepository eaiHeaderRepository;
    @Autowired
    private DWHttpClient dwHttpClient;
    @Autowired
    EaiHeaderUtil eaiHeaderUtil;

    @Bean(name={"dw-modeldriven-eai-repo"})
    public ModelDrivenEaiMethodRepository getModelDrivenEaiMethodRepository(@Qualifier(value="dw-service-commons-provider") DWServiceCommonsProvider serviceCommonsProvider) {
        Map commonsInterfaces = serviceCommonsProvider.getInterfaceServices();
        List interfList = (List)commonsInterfaces.get("commons");
        Optional<Class<?>> eaiClazz = interfList.stream().filter(p -> p.getTypeName().equals("com.digiwin.lcdp.modeldriven.service.IModelDrivenEAICrudService")).findFirst();
        Method[] commonsCrudEaiClazzMethods = eaiClazz.get().getMethods();
        List<String> dapStandardEaiPostFixNames = ESPConstants.EAI_SERVICE_POSTFIX;
        ModelDrivenEaiMethodRepository mdEaiMethodRepo = new ModelDrivenEaiMethodRepository();
        mdEaiMethodRepo.setEaiClazz(eaiClazz);
        Object listGetMethod = null;
        for (Method method : commonsCrudEaiClazzMethods) {
            if (!method.isAnnotationPresent(EAIService.class)) continue;
            EAIService methodAnnotation = method.getAnnotation(EAIService.class);
            String methodAnnotEaiId = methodAnnotation.id();
            if (listGetMethod == null && methodAnnotEaiId.endsWith(".eai.list.get")) {
                mdEaiMethodRepo.setListGetMethod(method);
            }
            for (String postFix : dapStandardEaiPostFixNames) {
                if (!methodAnnotEaiId.endsWith(postFix)) continue;
                String[] postFixToken = postFix.split("\\.");
                String eaiServicePostfix = postFixToken[2];
                if (postFixToken.length > 3) {
                    for (int i = 3; i < postFixToken.length; ++i) {
                        eaiServicePostfix = String.join((CharSequence)".", eaiServicePostfix, postFixToken[i]);
                    }
                }
                ModelDrivenEaiMethodDTO modelDrivenEaiMethodDTO = new ModelDrivenEaiMethodDTO();
                modelDrivenEaiMethodDTO.setEaiId(methodAnnotEaiId);
                modelDrivenEaiMethodDTO.setEaiServicePostfix(eaiServicePostfix);
                modelDrivenEaiMethodDTO.setMethod(method);
                log.debug("serviceMapping: eaiMethodRepo add eaiId({}), eaiServicePostfix({})", (Object)methodAnnotEaiId, (Object)eaiServicePostfix);
                mdEaiMethodRepo.add(methodAnnotEaiId, modelDrivenEaiMethodDTO);
            }
        }
        return mdEaiMethodRepo;
    }

    @Bean(name={"dw-modeldriven-service-commons-mapping-provider"})
    @DependsOn(value={"dw-service-commons-provider"})
    public DWServiceMappingProvider eaiMappingProvider(@Qualifier(value="dw-modeldriven-commons-eai-mapping-service") ModelDrivenEAIMappingService eaiMappingService, @Qualifier(value="DWEAIServiceParser") DWEAIServiceDefinitionParser dwEaiServiceDefinitionParser, @Qualifier(value="dw-service-commons-provider") DWServiceCommonsProvider serviceCommonsProvider, @Qualifier(value="DWEAIHeaderRepository") DWEAIHeaderRepository dwEAIHeaderRepository) throws Exception {
        DWDataSetOperationOption options = new DWDataSetOperationOption();
        options.setTenantEnabled(false);
        options.setManagementFieldEnabled(false);
        DWQueryInfo queryInfo = new DWQueryInfo();
        List serviceMappings = (List)eaiMappingService.getEAIList(queryInfo, options);
        log.info("serviceMapping: dw_service_mapping count:{} ", (Object)serviceMappings.size());
        DWServiceMappingProvider eaiMappingProvider = new DWServiceMappingProvider();
        ArrayList<MappingModelInfo> mappingModelInfos = new ArrayList();
        if (serviceMappings.size() > 0) {
            mappingModelInfos = (List)eaiMappingService.getChildrenTable();
        }
        List<DWEAIHeader> newHeaders = this.eaiHeaderUtil.updateAndGetModelDrivenEaiHeaders(serviceMappings, mappingModelInfos);
        log.info("serviceMapping: refreshed ModelDriven DWEAIHeader count:{} ", (Object)newHeaders.size());
        return eaiMappingProvider;
    }

    @DependsOn(value={"dw-json-config"})
    @Bean(name={"modeldriven-eai-auto-prod-srv-reg"})
    @Conditional(value={ModelDrivenEaiRegProdSrvCondition.class})
    public Object modeldrivenAutoRegister(DWEAIProperties properties, Environment environment) throws Exception {
        log.info("modeldrivenAutoRegister start auto-registering...");
        Map result = EaiInfoUtils.getSrvRegInfo(() -> ((DWEAIHeaderRepository)this.eaiHeaderRepository).getEaiServiceIdList(), (DWEAIProperties)properties);
        Map hostMap = (Map)result.get("host");
        hostMap.put("resturl", environment.getProperty("lcdp.modeldriven.eai.reg.prod.resturl"));
        String host = properties.getServerUrl();
        String regSrv = environment.getProperty("lcdp.modeldriven.eai.reg.prod.srv.path", "/CROSS/RESTful/regProdApSrv");
        HttpPost post = new HttpPost(host + regSrv);
        post.setEntity((HttpEntity)new DWJsonEntity((Object)result));
        EntityUtils.toString((HttpEntity)post.getEntity(), (Charset)StandardCharsets.UTF_8);
        post.addHeader("digi-action", "reg");
        post.addHeader("Content-Type", "application/json; charset=utf-8");
        String appToken = TokenProvider.getAppToken();
        post.addHeader("digi-middleware-auth-app", appToken);
        CloseableHttpResponse responseReturn = null;
        try (CloseableHttpResponse response = (CloseableHttpResponse)this.dwHttpClient.execute((HttpUriRequest)post, new DWRequestOption(false));){
            int statusCode;
            InputStream responseStream;
            responseReturn = response;
            String responseBody = "";
            HttpEntity httpEntity = response.getEntity();
            if (httpEntity != null && (responseStream = httpEntity.getContent()) != null) {
                responseBody = IOUtils.toString((InputStream)responseStream, (Charset)StandardCharsets.UTF_8);
            }
            if ((statusCode = response.getStatusLine().getStatusCode()) != 200) {
                log.error("Something wrong in the process of eai services auto-registration, httpCode:{}, response:{}", (Object)statusCode, (Object)responseBody);
            } else {
                log.info("ESP response ==> httpCode:{}, message:{}", (Object)statusCode, (Object)responseBody);
                log.info("EAI Services have registered automatically.");
            }
        }
        catch (Exception e) {
            log.error("eai auto register failed!", (Throwable)e);
        }
        return responseReturn;
    }
}

