/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.lcdp.modeldriven.dataview.impl;

import com.digiwin.app.dao.DWDao;
import com.digiwin.app.dao.DWOnColumn;
import com.digiwin.app.dao.DWPagableQueryInfo;
import com.digiwin.app.dao.DWPaginationQueryResult;
import com.digiwin.app.dao.DWQueryCondition;
import com.digiwin.app.dao.DWQueryField;
import com.digiwin.app.dao.DWQueryInfo;
import com.digiwin.app.dao.DWQueryJoinRelation;
import com.digiwin.app.dao.DWQueryJoinTable;
import com.digiwin.app.dao.DWQueryValueOperator;
import com.digiwin.app.dao.DWSqlInfo;
import com.digiwin.app.dao.DWSubQueryInfo;
import com.digiwin.app.data.DWDataRow;
import com.digiwin.app.data.DWDataSet;
import com.digiwin.app.data.DWDataSetOperationOption;
import com.digiwin.app.data.DWDataTable;
import com.digiwin.app.data.IDWSQLOptions;
import com.digiwin.app.ddl.util.MetadataSqlGenerator;
import com.digiwin.app.service.DWEAIResult;
import com.digiwin.app.service.DWServiceContext;
import com.digiwin.data.permission.DWRowPermissionBase;
import com.digiwin.data.permission.DWRowPermissionDefaultMatchOption;
import com.digiwin.data.permission.DWRowPermissionEmpty;
import com.digiwin.data.permission.DWRowPermissionMatchOption;
import com.digiwin.data.permission.DWUserPermission;
import com.digiwin.data.service.DWDataPermission;
import com.digiwin.lcdp.modeldriven.dataview.dto.DataViewDTO;
import com.digiwin.lcdp.modeldriven.dataview.dto.DataViewInfoDTO;
import com.digiwin.lcdp.modeldriven.dataview.dto.DataViewInfoOrderConditionDTO;
import com.digiwin.lcdp.modeldriven.dataview.dto.DataViewInfoQueryConditionDTO;
import com.digiwin.lcdp.modeldriven.dataview.dto.DataViewInfoReturnFieldDTO;
import com.digiwin.lcdp.modeldriven.dataview.dto.DataViewInfoReturnFieldsDTO;
import com.digiwin.lcdp.modeldriven.dataview.dto.DataViewInfoTableDTO;
import com.digiwin.lcdp.modeldriven.eoc.ModelDrivenEocService;
import com.digiwin.lcdp.modeldriven.eoc.pojo.EmpInfoData;
import com.digiwin.lcdp.modeldriven.model.ModelSchemaDTO;
import com.digiwin.lcdp.modeldriven.model.ModelSwitchCfg;
import com.digiwin.lcdp.modeldriven.model.SqlParam;
import com.digiwin.lcdp.modeldriven.service.impl.ModelDataEntryService;
import com.digiwin.lcdp.modeldriven.utils.DataEntryDataUtil;
import com.digiwin.lcdp.modeldriven.utils.ModelSchemaUtil;
import com.digiwin.lcdp.modeldriven.utils.ModelSqlGenerator;
import java.lang.reflect.Field;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import net.sf.jsqlparser.parser.CCJSqlParserUtil;
import net.sf.jsqlparser.statement.Statement;
import net.sf.jsqlparser.statement.select.PlainSelect;
import net.sf.jsqlparser.statement.select.Select;
import net.sf.jsqlparser.statement.select.SubSelect;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;
import org.springframework.util.ObjectUtils;

@Service
public class ModelDrivenDataViewService {
    private static final Logger log = LoggerFactory.getLogger(ModelDrivenDataViewService.class);
    @Autowired
    @Qualifier(value="dw-dao")
    private DWDao dao;
    @Autowired
    private ModelDataEntryService modelDataEntryService;
    @Autowired
    private ModelDrivenEocService modelDrivenEocService;

    public Object dataviewGet(DataViewDTO viewParams) throws Exception {
        String actionId;
        String moduleId;
        DWUserPermission dataPermData;
        DWQueryInfo queryInfo;
        HashMap<String, Object> returnValue = new HashMap<String, Object>();
        DWSubQueryInfo dwSubQueryInfo = new DWSubQueryInfo("", "dataviewAlias");
        DWDataSetOperationOption option = new DWDataSetOperationOption();
        DataViewInfoDTO viewInfo = viewParams.getView_info();
        List mainQueryInfoParams = viewParams.getSearch_info();
        List mainSortInfoParams = viewParams.getSort_info();
        Boolean useHasNext = viewParams.getUse_has_next() == null ? false : viewParams.getUse_has_next();
        DataViewInfoTableDTO mainTable = viewParams.getView_info().getTables().stream().filter(table -> table.getMain()).findFirst().orElseThrow(() -> new RuntimeException("main table of module is missing"));
        List<Map> customizedConditionValues = viewParams.getQueryConditionValues();
        ModelSchemaDTO modelSchema = this.getModelSchema(mainTable.getTable());
        if (useHasNext.booleanValue()) {
            int pageSize = viewParams.getPage_size();
            int pageNumber = viewParams.getPage_no();
            queryInfo = new DWPagableQueryInfo();
            ((DWPagableQueryInfo)queryInfo).setPageSize(pageSize);
            ((DWPagableQueryInfo)queryInfo).setPageNumber(pageNumber);
        } else {
            queryInfo = new DWQueryInfo();
        }
        if (!ObjectUtils.isEmpty((Object)viewInfo) && CollectionUtils.isNotEmpty(viewInfo.getTables())) {
            viewInfo.getTables().forEach(table -> this.dealDataViewTables((DWQueryInfo)dwSubQueryInfo, (DataViewInfoTableDTO)table));
        }
        if (!ObjectUtils.isEmpty((Object)viewInfo.getReturnFields())) {
            this.dealDataViewReturnFields((DWQueryInfo)dwSubQueryInfo, viewInfo.getReturnFields());
        }
        if (CollectionUtils.isNotEmpty(viewInfo.getQueryConditions())) {
            this.dealDataViewSearchInfo((DWQueryInfo)dwSubQueryInfo, viewInfo.getQueryConditions(), customizedConditionValues);
        }
        if (CollectionUtils.isNotEmpty(viewInfo.getOrderList())) {
            this.dealDataViewOrderInfo((DWQueryInfo)dwSubQueryInfo, viewInfo.getOrderList());
        }
        if (!ObjectUtils.isEmpty((Object)modelSchema) && this.enablePermission(modelSchema) && (dataPermData = (DWUserPermission)DWDataPermission.getDataPermission((String)(moduleId = "basicDataEntry"), (String)(actionId = Optional.ofNullable(viewParams.getActivityId()).orElseThrow(() -> new RuntimeException("actionId of view_info can not be null"))))) != null) {
            DWUserPermission userPermission = (DWUserPermission)DWDataPermission.getDataPermission((String)moduleId, (String)actionId);
            Field rowPermissionField = DWUserPermission.class.getDeclaredField("rowPermission");
            rowPermissionField.setAccessible(true);
            log.debug(String.format("[dataview permission] %s permission sql: {}", viewParams.getView_info().getCode()), (Object)((DWRowPermissionBase)rowPermissionField.get(userPermission)).getSQLContainValues((DWRowPermissionMatchOption)new DWRowPermissionDefaultMatchOption(true)));
            if (rowPermissionField.get(userPermission) instanceof DWRowPermissionEmpty) {
                returnValue.put(viewParams.getView_info().getCode(), new ArrayList());
                return returnValue;
            }
            DWRowPermissionDefaultMatchOption rowPermissionOption = new DWRowPermissionDefaultMatchOption();
            DWQueryCondition queryCondition = dataPermData.getRowPermission().getQueryCondition((DWRowPermissionMatchOption)rowPermissionOption);
            dwSubQueryInfo.setCondition(queryCondition);
        }
        queryInfo.from(dwSubQueryInfo);
        queryInfo.setTableName(dwSubQueryInfo.getTableName());
        if (CollectionUtils.isNotEmpty((Collection)mainQueryInfoParams)) {
            queryInfo.setCondition(this.modelDataEntryService.dealSearchInfo(mainQueryInfoParams));
        }
        if (CollectionUtils.isNotEmpty((Collection)mainSortInfoParams)) {
            this.modelDataEntryService.dealSortInfo(queryInfo, mainSortInfoParams);
        }
        if ("returnSql".equals(viewInfo.getExecuteType())) {
            PlainSelect selectBody;
            Statement selectSql;
            String sql = null;
            DWSqlInfo sqlInfo = this.dao.getDialect().parse(option, queryInfo, sql);
            sql = sqlInfo.getSql();
            if (StringUtils.isNotEmpty((CharSequence)sql) && (selectSql = CCJSqlParserUtil.parse((String)sql, null)) instanceof Select && (selectBody = (PlainSelect)((Select)selectSql).getSelectBody()).getFromItem() != null) {
                sql = ((SubSelect)selectBody.getFromItem()).getSelectBody().toString();
            }
            if (sql != null) {
                SqlParam sqlparam = new SqlParam();
                sqlparam.setSql(sql);
                sqlparam.setParams(sqlInfo.getParameters());
                sql = ModelSqlGenerator.getCombinedSql(sqlparam);
            }
            returnValue.put("returnSql", sql);
            return returnValue;
        }
        if (useHasNext.booleanValue()) {
            DWPaginationQueryResult queryResult = this.dao.selectWithPage((DWPagableQueryInfo)queryInfo, option);
            DWDataSet dataset = queryResult.getDataSet();
            long totalRowCount = queryResult.getRowCount();
            long totalPageCount = queryResult.getPageCount();
            returnValue.put("total_results", totalRowCount);
            returnValue.put("has_next", (long)((DWPagableQueryInfo)queryInfo).getPageNumber() < totalPageCount);
            List<Map<String, Object>> datas = DataEntryDataUtil.convertFromJson(dataset.getTable(dwSubQueryInfo.getTableName()));
            returnValue.put(viewParams.getView_info().getCode(), datas);
        } else {
            DWDataSet dataset = this.dao.select(queryInfo, option);
            List<Map<String, Object>> datas = DataEntryDataUtil.convertFromJson(dataset.getTable(dwSubQueryInfo.getTableName()));
            returnValue.put(viewParams.getView_info().getCode(), datas);
        }
        return returnValue;
    }

    private void dealDataViewTables(DWQueryInfo queryInfo, DataViewInfoTableDTO table) {
        if (!ObjectUtils.isEmpty((Object)table)) {
            if (table.getMain().booleanValue()) {
                queryInfo.setTableName(table.getTable());
                String tablePath = Optional.ofNullable(table.getPath()).orElseThrow(() -> new RuntimeException("'path' of table '%s' can not be null"));
                String tableName = Optional.ofNullable(table.getTable()).orElseThrow(() -> new RuntimeException("'table' of table '%s' can not be null"));
                try {
                    List<String> primaryKeys = this.getPrimaryKeys(this.dao, table.getTable());
                    if (CollectionUtils.isNotEmpty(primaryKeys)) {
                        ArrayList conditions = new ArrayList();
                        primaryKeys.forEach(primaryKey -> {
                            DWOnColumn onColumn = new DWOnColumn(tableName + "." + primaryKey, DWQueryValueOperator.Equals, tablePath + "." + primaryKey);
                            conditions.add(onColumn);
                        });
                        queryInfo.setJoinOnColumn(DWQueryJoinRelation.InnerJoin, new DWQueryJoinTable(tableName, tablePath), conditions.toArray(new DWOnColumn[conditions.size()]));
                    }
                }
                catch (Exception e) {
                    log.error("get primary key of table '%s' error", (Throwable)e);
                }
                if (CollectionUtils.isNotEmpty(table.getJoin())) {
                    table.getJoin().forEach(joinTable -> {
                        ArrayList conditions = new ArrayList();
                        if (CollectionUtils.isNotEmpty(joinTable.getAssociatedFields())) {
                            joinTable.getAssociatedFields().forEach(associatedFields -> {
                                DWOnColumn onColumn = new DWOnColumn(associatedFields.getRight(), DWQueryValueOperator.Equals, associatedFields.getLeft());
                                conditions.add(onColumn);
                            });
                            queryInfo.setJoinOnColumn(DWQueryJoinRelation.LeftJoin, new DWQueryJoinTable(joinTable.getTable(), joinTable.getPath()), conditions.toArray(new DWOnColumn[conditions.size()]));
                        }
                        if (CollectionUtils.isNotEmpty(joinTable.getJoin())) {
                            this.dealDataViewTables(queryInfo, (DataViewInfoTableDTO)joinTable);
                        }
                    });
                }
            } else if (CollectionUtils.isNotEmpty(table.getJoin())) {
                table.getJoin().forEach(joinTable -> {
                    ArrayList conditions = new ArrayList();
                    if (CollectionUtils.isNotEmpty(joinTable.getAssociatedFields())) {
                        joinTable.getAssociatedFields().forEach(associatedFields -> {
                            DWOnColumn onColumn = new DWOnColumn(associatedFields.getRight(), DWQueryValueOperator.Equals, associatedFields.getLeft());
                            conditions.add(onColumn);
                        });
                        queryInfo.setJoinOnColumn(DWQueryJoinRelation.LeftJoin, new DWQueryJoinTable(joinTable.getTable(), joinTable.getPath()), conditions.toArray(new DWOnColumn[conditions.size()]));
                    }
                    if (CollectionUtils.isNotEmpty(joinTable.getJoin())) {
                        this.dealDataViewTables(queryInfo, (DataViewInfoTableDTO)joinTable);
                    }
                });
            }
        }
    }

    private void dealDataViewReturnFields(DWQueryInfo queryInfo, DataViewInfoReturnFieldsDTO returnFields) {
        if (!ObjectUtils.isEmpty((Object)returnFields)) {
            String mainTableName = returnFields.getTable();
            List<DataViewInfoReturnFieldDTO> fields = returnFields.getFields();
            if (CollectionUtils.isNotEmpty(fields)) {
                List simpleFields = fields.stream().filter(field -> "SIMPLE".equals(Optional.ofNullable(field.getType()).orElseThrow(() -> new RuntimeException(String.format("the type of field '%s' can not be null", field.getFieldId()))))).collect(Collectors.toList());
                List quoteQueryFields = fields.stream().filter(field -> "QUOTE_QUERY".equals(Optional.ofNullable(field.getType()).orElseThrow(() -> new RuntimeException(String.format("the type of field '%s' can not be null", field.getFieldId()))))).collect(Collectors.toList());
                List collectionFields = fields.stream().filter(field -> "COLLECTION".equals(Optional.ofNullable(field.getType()).orElseThrow(() -> new RuntimeException(String.format("the type of field '%s' can not be null", field.getFieldId()))))).collect(Collectors.toList());
                simpleFields.stream().forEach(field -> queryInfo.addSelectField(new String[]{field.getShortPath() + " as `" + field.getFullPath() + "`"}));
                quoteQueryFields.stream().forEach(field -> {
                    List<DataViewInfoReturnFieldDTO> quoteFields = field.getFields();
                    if (CollectionUtils.isNotEmpty(quoteFields)) {
                        quoteFields.forEach(quoteField -> queryInfo.addSelectField(new String[]{quoteField.getShortPath() + " as `" + quoteField.getFullPath() + "`"}));
                    }
                });
                collectionFields.stream().forEach(field -> {
                    List<DataViewInfoReturnFieldDTO> quoteFields = field.getFields();
                    if (CollectionUtils.isNotEmpty(quoteFields)) {
                        quoteFields.forEach(quoteField -> queryInfo.addSelectField(new String[]{quoteField.getShortPath() + " as `" + quoteField.getFullPath() + "`"}));
                    }
                });
            }
        }
    }

    private void dealDataViewSearchInfo(DWQueryInfo queryInfo, List<DataViewInfoQueryConditionDTO> searchInfos, List<Map> customizedConditionValues) {
        if (CollectionUtils.isNotEmpty(searchInfos)) {
            Collections.sort(searchInfos, Comparator.comparingDouble(item -> Double.parseDouble(item.getOrder().toString())));
            DWQueryCondition condition = new DWQueryCondition();
            this.generateCondition(searchInfos.iterator(), condition, customizedConditionValues);
            queryInfo.setCondition(condition);
        }
    }

    private void dealDataViewOrderInfo(DWQueryInfo queryInfo, List<DataViewInfoOrderConditionDTO> orderInfos) {
        if (CollectionUtils.isNotEmpty(orderInfos)) {
            Collections.sort(orderInfos, Comparator.comparingDouble(item -> Double.parseDouble(item.getOrder())));
            orderInfos.forEach(orderInfo -> {
                String orderField = StringUtils.isNotEmpty((CharSequence)orderInfo.getTable_path()) ? orderInfo.getTable_path() + "." + orderInfo.getSchema() : orderInfo.getSchema();
                switch (orderInfo.getOrderType()) {
                    case "asc": {
                        queryInfo.addOrderBy(orderField, true);
                        break;
                    }
                    case "desc": {
                        queryInfo.addOrderBy(orderField, false);
                        break;
                    }
                }
            });
        }
    }

    private DWQueryCondition generateCondition(Iterator it, DWQueryCondition condition, List<Map> customizedConditionValues) {
        return this.generateCondition(it, condition, null, customizedConditionValues);
    }

    private DWQueryCondition generateCondition(Iterator it, DWQueryCondition condition, String logic, List<Map> customizedConditionValues) {
        while (it.hasNext()) {
            DataViewInfoQueryConditionDTO currentSearchInfo = (DataViewInfoQueryConditionDTO)it.next();
            if ("(".equals(currentSearchInfo.getBracket())) {
                DWQueryCondition childCondition = new DWQueryCondition();
                condition.addCondition(childCondition);
                this.dealVariables(childCondition, currentSearchInfo, logic, customizedConditionValues);
                this.generateCondition(it, childCondition, currentSearchInfo.getLogic(), customizedConditionValues);
                continue;
            }
            if (")".equals(currentSearchInfo.getBracket())) {
                if (!StringUtils.isEmpty((CharSequence)currentSearchInfo.getLogic())) {
                    this.dealVariables(condition, currentSearchInfo, logic, customizedConditionValues);
                    this.generateCondition(it, condition.getParentCondition(), currentSearchInfo.getLogic(), customizedConditionValues);
                    continue;
                }
                this.dealVariables(condition, currentSearchInfo, logic, customizedConditionValues);
                this.generateCondition(it, condition.getParentCondition(), currentSearchInfo.getLogic(), customizedConditionValues);
                continue;
            }
            this.dealVariables(condition, currentSearchInfo, logic, customizedConditionValues);
            this.generateCondition(it, condition, currentSearchInfo.getLogic(), customizedConditionValues);
        }
        return condition;
    }

    public void dealVariables(DWQueryCondition condition, DataViewInfoQueryConditionDTO searchInfo, String logic, List<Map> customizedConditionValues) {
        List<Object> result = new ArrayList<DWQueryField>();
        if ("equal".equals(searchInfo.getSearch_operator()) || "not_equal".equals(searchInfo.getSearch_operator())) {
            if (CollectionUtils.isNotEmpty((Collection)searchInfo.getSearch_value())) {
                result.addAll(this.dealSystemVariables(searchInfo));
                result.addAll(this.dealCustomVariables(searchInfo, customizedConditionValues));
            }
        } else {
            result = this.dealCustomVariables(searchInfo, customizedConditionValues);
        }
        result.forEach(item -> condition.addFieldInfo(item.getName(), item.getOperator(), item.getValues()));
        if ("OR".equals(logic)) {
            condition.ORJoin();
        } else {
            condition.ANDJoin();
        }
    }

    public List<DWQueryField> dealSystemVariables(DataViewInfoQueryConditionDTO searchInfo) {
        ArrayList<DWQueryField> result = new ArrayList<DWQueryField>();
        Iterator iterator = searchInfo.getSearch_value().iterator();
        while (iterator.hasNext()) {
            switch (iterator.next().toString()) {
                case "{@SYSTEM_DATE_TODAY}": {
                    DWQueryField notEqualQueryField;
                    switch (searchInfo.getSearch_operator()) {
                        case "equal": {
                            DWQueryField equalQueryField = new DWQueryField("DATE_FORMAT(" + searchInfo.getSearch_field() + ", '%Y-%m-%d')", DWQueryValueOperator.Equals, new Object[]{this.getCurrentDate()});
                            result.add(equalQueryField);
                            break;
                        }
                        case "not_equal": {
                            notEqualQueryField = new DWQueryField("DATE_FORMAT(" + searchInfo.getSearch_field() + ", '%Y-%m-%d')", DWQueryValueOperator.NotEquals, new Object[]{this.getCurrentDate()});
                            result.add(notEqualQueryField);
                            break;
                        }
                        default: {
                            throw new RuntimeException(String.format("%s only supprot 'equal' or 'not equal' operator", "{@SYSTEM_DATE_TODAY}"));
                        }
                    }
                    iterator.remove();
                    break;
                }
                case "{@SYSTEM_DATE_WEEK}": {
                    DWQueryField greaterQueryField;
                    DWQueryField lessQueryField;
                    switch (searchInfo.getSearch_operator()) {
                        case "equal": {
                            DWQueryField equalQueryField = new DWQueryField("DATE_FORMAT(" + searchInfo.getSearch_field() + ", '%Y-%m-%d')", DWQueryValueOperator.Between, this.getCurrentWeek().toArray(new Object[1]));
                            result.add(equalQueryField);
                            break;
                        }
                        case "not_equal": {
                            lessQueryField = new DWQueryField("DATE_FORMAT(" + searchInfo.getSearch_field() + ", '%Y-%m-%d')", DWQueryValueOperator.LessThan, new Object[]{this.getCurrentWeek().get(0)});
                            greaterQueryField = new DWQueryField("DATE_FORMAT(" + searchInfo.getSearch_field() + ", '%Y-%m-%d')", DWQueryValueOperator.GreaterThan, new Object[]{this.getCurrentWeek().get(1)});
                            result.add(lessQueryField);
                            result.add(greaterQueryField);
                            break;
                        }
                        default: {
                            throw new RuntimeException(String.format("%s only supprot 'equal' or 'not equal' operator", "{@SYSTEM_DATE_WEEK}"));
                        }
                    }
                    iterator.remove();
                    break;
                }
                case "{@SYSTEM_DATE_MONTH}": {
                    DWQueryField notEqualQueryField;
                    switch (searchInfo.getSearch_operator()) {
                        case "equal": {
                            DWQueryField equalQueryField = new DWQueryField("DATE_FORMAT(" + searchInfo.getSearch_field() + ", '%Y-%m')", DWQueryValueOperator.Equals, new Object[]{this.getCurrentMonth()});
                            result.add(equalQueryField);
                            break;
                        }
                        case "not_equal": {
                            notEqualQueryField = new DWQueryField("DATE_FORMAT(" + searchInfo.getSearch_field() + ", '%Y-%m')", DWQueryValueOperator.NotEquals, new Object[]{this.getCurrentMonth()});
                            result.add(notEqualQueryField);
                            break;
                        }
                        default: {
                            throw new RuntimeException(String.format("%s only supprot 'equal' or 'not equal' operator", "{@SYSTEM_DATE_MONTH}"));
                        }
                    }
                    iterator.remove();
                    break;
                }
                case "{@SYSTEM_DATE_IN_7}": {
                    DWQueryField greaterQueryField;
                    DWQueryField lessQueryField;
                    switch (searchInfo.getSearch_operator()) {
                        case "equal": {
                            DWQueryField equalQueryField = new DWQueryField(searchInfo.getSearch_field(), DWQueryValueOperator.Between, this.getLast7Days().toArray(new Object[1]));
                            result.add(equalQueryField);
                            break;
                        }
                        case "not_equal": {
                            lessQueryField = new DWQueryField(searchInfo.getSearch_field(), DWQueryValueOperator.LessThan, new Object[]{this.getLast7Days().get(0)});
                            greaterQueryField = new DWQueryField(searchInfo.getSearch_field(), DWQueryValueOperator.GreaterThan, new Object[]{this.getLast7Days().get(1)});
                            result.add(lessQueryField);
                            result.add(greaterQueryField);
                            break;
                        }
                        default: {
                            throw new RuntimeException(String.format("%s only supprot 'equal' or 'not equal' operator", "{@SYSTEM_DATE_IN_7}"));
                        }
                    }
                    iterator.remove();
                    break;
                }
                case "{@SYSTEM_USER_ID}": {
                    DWQueryField notEqualQueryField;
                    DWQueryField equalQueryField;
                    ArrayList users = new ArrayList();
                    users.add(DWServiceContext.getContext().getProfile().get("userId"));
                    searchInfo.setSearch_value(users);
                    switch (searchInfo.getSearch_operator()) {
                        case "equal": {
                            equalQueryField = new DWQueryField(searchInfo.getSearch_field(), DWQueryValueOperator.Equals, new Object[]{DWServiceContext.getContext().getProfile().get("userId")});
                            result.add(equalQueryField);
                            break;
                        }
                        case "not_equal": {
                            notEqualQueryField = new DWQueryField(searchInfo.getSearch_field(), DWQueryValueOperator.NotEquals, new Object[]{DWServiceContext.getContext().getProfile().get("userId")});
                            result.add(notEqualQueryField);
                            break;
                        }
                        default: {
                            throw new RuntimeException(String.format("%s only supprot 'equal' or 'not equal' operator", "{@SYSTEM_USER_ID}"));
                        }
                    }
                    iterator.remove();
                    break;
                }
                case "{@SYSTEM_EMPLOYEE_ID}": {
                    DWQueryField notEqualQueryField;
                    DWQueryField equalQueryField;
                    switch (searchInfo.getSearch_operator()) {
                        case "equal": {
                            equalQueryField = new DWQueryField(searchInfo.getSearch_field(), DWQueryValueOperator.Equals, new Object[]{this.getEmpId()});
                            result.add(equalQueryField);
                            break;
                        }
                        case "not_equal": {
                            notEqualQueryField = new DWQueryField(searchInfo.getSearch_field(), DWQueryValueOperator.NotEquals, new Object[]{this.getEmpId()});
                            result.add(notEqualQueryField);
                            break;
                        }
                        default: {
                            throw new RuntimeException(String.format("%s only supprot 'equal' or 'not equal' operator", "{@SYSTEM_EMPLOYEE_ID}"));
                        }
                    }
                    iterator.remove();
                    break;
                }
                case "{@SYSTEM_EMPLOYEE_DEPTID}": {
                    DWQueryField notEqualQueryField;
                    DWQueryField equalQueryField;
                    switch (searchInfo.getSearch_operator()) {
                        case "equal": {
                            equalQueryField = new DWQueryField(searchInfo.getSearch_field(), DWQueryValueOperator.In, new Object[]{this.getDeptId()});
                            result.add(equalQueryField);
                            break;
                        }
                        case "not_equal": {
                            notEqualQueryField = new DWQueryField(searchInfo.getSearch_field(), DWQueryValueOperator.NotIn, new Object[]{this.getDeptId()});
                            result.add(notEqualQueryField);
                            break;
                        }
                        default: {
                            throw new RuntimeException(String.format("%s only supprot 'equal' or 'not equal' operator", "{@SYSTEM_EMPLOYEE_DEPTID}"));
                        }
                    }
                    iterator.remove();
                    break;
                }
                case "{@SYSTEM_EMPLOYEE_DEPTID_ALL}": {
                    DWQueryField notEqualQueryField;
                    DWQueryField equalQueryField;
                    switch (searchInfo.getSearch_operator()) {
                        case "equal": {
                            equalQueryField = new DWQueryField(searchInfo.getSearch_field(), DWQueryValueOperator.In, new Object[]{this.getDeptIdAll()});
                            result.add(equalQueryField);
                            break;
                        }
                        case "not_equal": {
                            notEqualQueryField = new DWQueryField(searchInfo.getSearch_field(), DWQueryValueOperator.NotIn, new Object[]{this.getDeptIdAll()});
                            result.add(notEqualQueryField);
                            break;
                        }
                        default: {
                            throw new RuntimeException(String.format("%s only supprot 'equal' or 'not equal' operator", "{@SYSTEM_EMPLOYEE_DEPTID_ALL}"));
                        }
                    }
                    iterator.remove();
                    break;
                }
            }
        }
        return result;
    }

    public List<DWQueryField> dealCustomVariables(DataViewInfoQueryConditionDTO searchInfo, List<Map> customizedConditionValues) {
        if (CollectionUtils.isNotEmpty((Collection)searchInfo.getSearch_value())) {
            List searchValues = searchInfo.getSearch_value();
            if (CollectionUtils.isNotEmpty(customizedConditionValues)) {
                customizedConditionValues.get(0).forEach((key, val) -> {
                    if (searchValues.contains(key)) {
                        if (val instanceof List) {
                            searchInfo.setSearch_value((List)val);
                        } else {
                            searchInfo.setSearch_value(Arrays.asList(val));
                        }
                    }
                });
            }
        }
        return Arrays.asList(this.generateFiledInfo(searchInfo));
    }

    public DWQueryField generateFiledInfo(DataViewInfoQueryConditionDTO searchInfo) {
        DWQueryField dwQueryField = null;
        switch (searchInfo.getSearch_operator()) {
            case "equal": {
                dwQueryField = new DWQueryField(searchInfo.getSearch_field(), DWQueryValueOperator.Equals, new Object[]{CollectionUtils.get((Object)searchInfo.getSearch_value(), (int)0)});
                break;
            }
            case "not_equal": {
                dwQueryField = new DWQueryField(searchInfo.getSearch_field(), DWQueryValueOperator.NotEquals, new Object[]{CollectionUtils.get((Object)searchInfo.getSearch_value(), (int)0)});
                break;
            }
            case "greater_equal": {
                dwQueryField = new DWQueryField(searchInfo.getSearch_field(), DWQueryValueOperator.GreaterThanOrEqualTo, new Object[]{CollectionUtils.get((Object)searchInfo.getSearch_value(), (int)0)});
                break;
            }
            case "less_equal": {
                dwQueryField = new DWQueryField(searchInfo.getSearch_field(), DWQueryValueOperator.LessThanOrEqualTo, new Object[]{CollectionUtils.get((Object)searchInfo.getSearch_value(), (int)0)});
                break;
            }
            case "greater": {
                dwQueryField = new DWQueryField(searchInfo.getSearch_field(), DWQueryValueOperator.GreaterThan, new Object[]{CollectionUtils.get((Object)searchInfo.getSearch_value(), (int)0)});
                break;
            }
            case "less": {
                dwQueryField = new DWQueryField(searchInfo.getSearch_field(), DWQueryValueOperator.LessThan, new Object[]{CollectionUtils.get((Object)searchInfo.getSearch_value(), (int)0)});
                break;
            }
            case "like_r": {
                dwQueryField = new DWQueryField(searchInfo.getSearch_field(), DWQueryValueOperator.Like, new Object[]{CollectionUtils.get((Object)searchInfo.getSearch_value(), (int)0).toString().replaceAll("%", "\\\\%") + "%"});
                break;
            }
            case "like": {
                dwQueryField = new DWQueryField(searchInfo.getSearch_field(), DWQueryValueOperator.Like, new Object[]{"%" + CollectionUtils.get((Object)searchInfo.getSearch_value(), (int)0).toString().replaceAll("%", "\\\\%") + "%"});
                break;
            }
            case "l_like": {
                dwQueryField = new DWQueryField(searchInfo.getSearch_field(), DWQueryValueOperator.Like, new Object[]{"%" + CollectionUtils.get((Object)searchInfo.getSearch_value(), (int)0).toString().replaceAll("%", "\\\\%")});
                break;
            }
            case "not_like": {
                dwQueryField = new DWQueryField(searchInfo.getSearch_field(), DWQueryValueOperator.NotLike, new Object[]{"%" + CollectionUtils.get((Object)searchInfo.getSearch_value(), (int)0).toString().replaceAll("%", "\\\\%") + "%"});
                break;
            }
            case "exist": {
                dwQueryField = new DWQueryField(searchInfo.getSearch_field(), DWQueryValueOperator.In, searchInfo.getSearch_value().toArray(new Object[1]));
                break;
            }
            case "not exist": {
                String[] fields = searchInfo.getSearch_field().split("\\.");
                searchInfo.setSearch_field(fields[fields.length - 1]);
                dwQueryField = new DWQueryField(searchInfo.getSearch_field(), DWQueryValueOperator.NotIn, searchInfo.getSearch_value().toArray(new Object[1]));
                break;
            }
            case "between": {
                dwQueryField = new DWQueryField(searchInfo.getSearch_field(), DWQueryValueOperator.Between, searchInfo.getSearch_value().toArray(new Object[1]));
                break;
            }
            default: {
                throw new RuntimeException(String.format("operator '%s' is not supported", searchInfo.getSearch_operator()));
            }
        }
        return dwQueryField;
    }

    public List getCurrentDate() {
        Calendar calendar = Calendar.getInstance();
        Date date = calendar.getTime();
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd");
        ArrayList<String> result = new ArrayList<String>();
        result.add(format.format(date));
        return result;
    }

    public List getCurrentWeek() {
        Calendar calendar = Calendar.getInstance();
        calendar.set(7, 2);
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd");
        String monday = format.format(calendar.getTime());
        calendar.add(5, 6);
        String sunday = format.format(calendar.getTime());
        ArrayList<String> result = new ArrayList<String>();
        result.add(monday);
        result.add(sunday);
        return result;
    }

    public List getCurrentMonth() {
        Calendar calendar = Calendar.getInstance();
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM");
        String currentMonth = format.format(calendar.getTime());
        ArrayList<String> result = new ArrayList<String>();
        result.add(currentMonth);
        return result;
    }

    public List getLast7Days() {
        Calendar calendar = Calendar.getInstance();
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd");
        String lastDay = format.format(calendar.getTime()) + " 23:59:59";
        calendar.add(6, -6);
        String firstDay = format.format(calendar.getTime()) + " 00:00:00";
        ArrayList<String> result = new ArrayList<String>();
        result.add(firstDay);
        result.add(lastDay);
        return result;
    }

    public List getEmpId() {
        Object empInfoDataObject = null;
        String eocEmpId = null;
        try {
            empInfoDataObject = this.modelDrivenEocService.getEmpInfo();
            if (empInfoDataObject instanceof EmpInfoData) {
                EmpInfoData empInfoData = (EmpInfoData)empInfoDataObject;
                eocEmpId = empInfoData.getId();
            } else {
                DWEAIResult dweaiResult = (DWEAIResult)empInfoDataObject;
                log.debug("eoc error code({}), message({})", (Object)dweaiResult.getCode(), (Object)dweaiResult.getParameter());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        ArrayList<String> result = new ArrayList<String>();
        result.add(eocEmpId);
        return result;
    }

    public List getDeptId() {
        Object empInfoDataObject = null;
        String eocEmpDeptId = null;
        try {
            empInfoDataObject = this.modelDrivenEocService.getEmpInfo();
            if (empInfoDataObject instanceof EmpInfoData) {
                EmpInfoData empInfoData = (EmpInfoData)empInfoDataObject;
                eocEmpDeptId = empInfoData.getDepts().get(0).getId();
            } else {
                DWEAIResult dweaiResult = (DWEAIResult)empInfoDataObject;
                log.debug("eoc error code({}), message({})", (Object)dweaiResult.getCode(), (Object)dweaiResult.getParameter());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        ArrayList<String> result = new ArrayList<String>();
        result.add(eocEmpDeptId);
        return result;
    }

    public List getDeptIdAll() {
        Object deptIdsAllObject = null;
        try {
            deptIdsAllObject = this.modelDrivenEocService.getDeptIdAll();
            if (deptIdsAllObject instanceof List) {
                log.debug("eoc deptIds({}))", deptIdsAllObject);
            } else {
                DWEAIResult dweaiResult = (DWEAIResult)deptIdsAllObject;
                log.debug("eoc error code({}), message({})", (Object)dweaiResult.getCode(), (Object)dweaiResult.getParameter());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        ArrayList result = new ArrayList();
        result.addAll((List)deptIdsAllObject);
        return result;
    }

    List<String> getPrimaryKeys(DWDao dao, String tableName) throws Exception {
        String sql = MetadataSqlGenerator.getPrimaryKey((String)tableName);
        DWDataSetOperationOption option = new DWDataSetOperationOption();
        option.setTenantEnabled(false);
        ArrayList<String> pks = new ArrayList<String>();
        List result = dao.select((IDWSQLOptions)option, sql, new Object[0]);
        for (Map map : result) {
            Object pk = map.get("pk");
            if (!Objects.nonNull(pk)) continue;
            pks.add(Objects.toString(pk));
        }
        return pks;
    }

    private ModelSchemaDTO getModelSchema(String mainTableName) {
        if (StringUtils.isNotEmpty((CharSequence)mainTableName)) {
            String modelCode = mainTableName;
            DWQueryInfo queryInfo = new DWQueryInfo("dw_lcdp_model");
            queryInfo.addEqualInfo("code", (Object)modelCode);
            DWDataSetOperationOption option = new DWDataSetOperationOption();
            option.setTenantEnabled(false);
            option.setManagementFieldEnabled(false);
            DWDataSet modelTables = this.dao.select(queryInfo, option);
            DWDataTable table = modelTables.getTable("dw_lcdp_model");
            if (table.getRows().size() <= 0) {
                return null;
            }
            DWDataRow row = table.getRow(0);
            return ModelSchemaUtil.parseModelSchema(row);
        }
        throw new RuntimeException(String.format("tableName '%s' is missing", mainTableName));
    }

    private boolean enablePermission(ModelSchemaDTO model) {
        return "Y".equals(Optional.ofNullable(model.getSwitchCfg()).orElse(new ModelSwitchCfg()).getDataPermission());
    }
}

