/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.lcdp.modeldriven.service.impl;

import com.digiwin.app.dao.DWBatchCondition;
import com.digiwin.app.dao.DWDao;
import com.digiwin.app.dao.DWOnColumn;
import com.digiwin.app.dao.DWQueryCondition;
import com.digiwin.app.dao.DWQueryInfo;
import com.digiwin.app.dao.DWQueryInfoBuilder;
import com.digiwin.app.dao.DWQueryJoinRelation;
import com.digiwin.app.dao.DWQueryValueOperator;
import com.digiwin.app.dao.DWSQLExecutionResult;
import com.digiwin.app.dao.DWServiceResultBuilder;
import com.digiwin.app.data.DWDataRow;
import com.digiwin.app.data.DWDataRowCollection;
import com.digiwin.app.data.DWDataSet;
import com.digiwin.app.data.DWDataSetOperationOption;
import com.digiwin.app.data.DWDataTable;
import com.digiwin.app.data.IDWSQLOptions;
import com.digiwin.app.json.gson.DWGsonProvider;
import com.digiwin.app.service.DWEAIResult;
import com.digiwin.app.service.DWServiceContext;
import com.digiwin.app.service.DWServiceResult;
import com.digiwin.data.permission.DWUserPermission;
import com.digiwin.lcdp.modeldriven.context.ModelDrivenContext;
import com.digiwin.lcdp.modeldriven.dao.TableDao;
import com.digiwin.lcdp.modeldriven.dataview.dto.DataViewDTO;
import com.digiwin.lcdp.modeldriven.dataview.impl.ModelDrivenDataViewService;
import com.digiwin.lcdp.modeldriven.enums.ModelCreateTypeEnum;
import com.digiwin.lcdp.modeldriven.enums.ModelFieldRelationTypeEnum;
import com.digiwin.lcdp.modeldriven.eventcenter.EventCenterUtil;
import com.digiwin.lcdp.modeldriven.eventcenter.constant.EventCenterTriggerTypeEnum;
import com.digiwin.lcdp.modeldriven.model.ModelDTO;
import com.digiwin.lcdp.modeldriven.model.ModelFieldDTO;
import com.digiwin.lcdp.modeldriven.model.ModelIndexDTO;
import com.digiwin.lcdp.modeldriven.model.ModelOidDTO;
import com.digiwin.lcdp.modeldriven.model.ModelSchemaDTO;
import com.digiwin.lcdp.modeldriven.pojo.PublishModelResultDTO;
import com.digiwin.lcdp.modeldriven.pojo.PublishModelStatusDTO;
import com.digiwin.lcdp.modeldriven.report.ModelDrivenReportUtil;
import com.digiwin.lcdp.modeldriven.report.check.ReportCheckResult;
import com.digiwin.lcdp.modeldriven.report.model.SqlValueFields;
import com.digiwin.lcdp.modeldriven.report.model.ValueReference;
import com.digiwin.lcdp.modeldriven.report.pojo.Dictionary;
import com.digiwin.lcdp.modeldriven.service.IModelDrivenEAICrudService;
import com.digiwin.lcdp.modeldriven.service.impl.ModelDataEntryService;
import com.digiwin.lcdp.modeldriven.service.impl.ModelPublishService;
import com.digiwin.lcdp.modeldriven.utils.ApTokenUtil;
import com.digiwin.lcdp.modeldriven.utils.EaiRegisterUtil;
import com.digiwin.lcdp.modeldriven.utils.EaiResultUtil;
import com.digiwin.lcdp.modeldriven.utils.ModelDataUtil;
import com.digiwin.lcdp.modeldriven.utils.ModelSchemaUtil;
import com.digiwin.lcdp.modeldriven.utils.ModelSqlGenerator;
import com.digiwin.lcdp.modeldriven.utils.ModelTableHelperExpress;
import com.digiwin.utils.DWTenantUtils;
import com.google.gson.Gson;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Queue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.stream.Collectors;
import net.sf.jsqlparser.expression.Expression;
import net.sf.jsqlparser.expression.operators.conditional.AndExpression;
import net.sf.jsqlparser.parser.CCJSqlParserUtil;
import net.sf.jsqlparser.schema.Table;
import net.sf.jsqlparser.statement.Statement;
import net.sf.jsqlparser.statement.select.FromItem;
import net.sf.jsqlparser.statement.select.PlainSelect;
import net.sf.jsqlparser.statement.select.Select;
import net.sf.jsqlparser.statement.select.SubSelect;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.dbutils.QueryRunner;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.time.StopWatch;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;
import org.springframework.util.ObjectUtils;

@Service
public class ModelDrivenEAICrudService
implements IModelDrivenEAICrudService {
    @Autowired
    @Qualifier(value="dw-dao")
    private DWDao dao;
    @Autowired
    ModelDataEntryService modelDataEntryService;
    @Autowired
    ModelDrivenDataViewService modelDrivenDataViewService;
    @Autowired
    private ModelPublishService modelPublishService;
    @Autowired
    private ModelTableHelperExpress modelTableHelperExpress;
    @Autowired
    EventCenterUtil messageCenterUtil;
    private static final Logger log = LoggerFactory.getLogger(ModelDrivenEAICrudService.class);

    @Override
    public Object get(Map<String, Object> headers, Map<String, Object> messageBody) throws Exception {
        Map params = (Map)((Map)messageBody.get("std_data")).get("parameter");
        String digiService = (String)headers.get("digi-service");
        JSONObject digiServiceJo = new JSONObject(digiService);
        String prod = digiServiceJo.getString("prod");
        String modelDrivenProdPrefix = EaiRegisterUtil.getEaiServicePrefixOfProd(prod) + ".";
        String name = digiServiceJo.getString("name");
        String targetTableName = ModelDataUtil.replaceLast(name.replaceFirst(modelDrivenProdPrefix, ""), ".detail.get", "").replaceAll("\\.", "_");
        Object conditions = params.get(targetTableName);
        if (ObjectUtils.isEmpty(conditions)) {
            HashMap<String, Object> returnValue = new HashMap<String, Object>();
            returnValue.put(targetTableName, null);
            return returnValue;
        }
        HashMap dataEntryParams = new HashMap();
        HashMap queryInfoMap = new HashMap();
        if (MapUtils.isNotEmpty((Map)params)) {
            queryInfoMap.put("conditions", conditions);
            queryInfoMap.put("userTableName", targetTableName);
        }
        DWDataRow publishedDataRow = this.getModel(targetTableName);
        ModelSchemaDTO publishedModelSchema = ModelSchemaUtil.parseModelSchema(publishedDataRow);
        queryInfoMap.put("model", publishedModelSchema);
        params.put("query_info", queryInfoMap);
        dataEntryParams.putAll(params);
        return this.modelDataEntryService.get(dataEntryParams);
    }

    @Override
    public Object getList(Map<String, Object> headers, Map<String, Object> messageBody) throws Exception {
        Map params = (Map)((Map)messageBody.get("std_data")).get("parameter");
        String digiService = (String)headers.get("digi-service");
        JSONObject digiServiceJo = new JSONObject(digiService);
        String prod = digiServiceJo.getString("prod");
        String modelDrivenProdPrefix = EaiRegisterUtil.getEaiServicePrefixOfProd(prod) + ".";
        String name = digiServiceJo.getString("name");
        String targetTableName = ModelDataUtil.replaceLast(name.replaceFirst(modelDrivenProdPrefix, ""), ".list.get", "").replaceAll("\\.", "_");
        HashMap dataEntryParams = new HashMap();
        List searchInfoParams = (List)MapUtils.getObject((Map)params, (Object)"search_info", new ArrayList());
        List sortInfoParams = (List)MapUtils.getObject((Map)params, (Object)"sort_info", new ArrayList());
        DWDataRow publishedDataRow = this.getModel(targetTableName);
        ModelSchemaDTO publishedModelSchema = ModelSchemaUtil.parseModelSchema(publishedDataRow);
        params.put("model", publishedModelSchema);
        params.put("userTableName", targetTableName);
        params.put("search_info", searchInfoParams);
        params.put("sort_info", sortInfoParams);
        params.put("data_info", params.get(targetTableName));
        params.put("actionId", MapUtils.getObject((Map)params, (Object)"activityId"));
        params.put("moduleId", "basicDataEntry");
        dataEntryParams.putAll(params);
        return this.modelDataEntryService.getList(dataEntryParams);
    }

    @Override
    @Transactional(propagation=Propagation.REQUIRED, rollbackFor={Exception.class})
    public Object post(Map<String, Object> headers, Map<String, Object> messageBody) throws Exception {
        DWQueryInfo queryInfo;
        Map<String, Object> returnValue = new HashMap<String, Object>();
        Map params = (Map)((Map)messageBody.get("std_data")).get("parameter");
        String digiService = (String)headers.get("digi-service");
        JSONObject digiServiceJo = new JSONObject(digiService);
        String prod = digiServiceJo.getString("prod");
        String modelDrivenProdPrefix = EaiRegisterUtil.getEaiServicePrefixOfProd(prod) + ".";
        String name = digiServiceJo.getString("name");
        String targetTableName = ModelDataUtil.replaceLast(name.replaceFirst(modelDrivenProdPrefix, ""), ".create", "").replaceAll("\\.", "_");
        DWDataSetOperationOption serviceMappingOption = new DWDataSetOperationOption();
        serviceMappingOption.setTenantEnabled(false);
        serviceMappingOption.setManagementFieldEnabled(false);
        DWQueryInfo queryInfoServiceMapping = new DWQueryInfo(targetTableName);
        queryInfoServiceMapping.setTableName("dw_service_mapping");
        queryInfoServiceMapping.addEqualInfo("table_name", (Object)targetTableName);
        DWDataSet queryDataSet = this.dao.select(queryInfoServiceMapping, serviceMappingOption);
        if (queryDataSet == null || queryDataSet.getTables().getPrimaryTable().getRows().size() < 0) {
            return EaiResultUtil.getDWEAIFalseResult(returnValue);
        }
        DWDataRow publishedDataRow = this.getModel(targetTableName);
        ModelSchemaDTO masterModelSchema = ModelSchemaUtil.parseModelSchema(publishedDataRow);
        String masterTableName = masterModelSchema.getName();
        boolean single = true;
        ArrayList<Map<String, Object>> masterTableParamDatas = new ArrayList<Map>();
        if (params.get(masterTableName) instanceof List) {
            single = false;
            masterTableParamDatas = (List)params.get(masterTableName);
        } else {
            masterTableParamDatas.add((Map)params.get(masterTableName));
        }
        List<Map<String, Object>> businessKeys = this.modelDataEntryService.insertRows(masterModelSchema, masterTableParamDatas);
        if (single) {
            queryInfo = new DWQueryInfo();
            queryInfo.setTableName(targetTableName);
            DWQueryCondition queryCondition = new DWQueryCondition();
            queryCondition.ORJoin();
            queryInfo.setCondition(queryCondition);
            businessKeys.forEach(item -> {
                DWQueryCondition condition = new DWQueryCondition();
                item.forEach((key, val) -> {
                    if (DWTenantUtils.getTenantColumnName().equals(key)) {
                        condition.addEqualInfo(key, DWServiceContext.getContext().getProfile().get(DWTenantUtils.getIAMTenantSidKey()));
                    } else {
                        condition.addEqualInfo(key, val);
                    }
                });
                queryCondition.addCondition(condition);
            });
            returnValue = this.modelDataEntryService.getForInnerInvoke(queryInfo);
        } else if (CollectionUtils.isNotEmpty(masterTableParamDatas)) {
            queryInfo = new DWQueryInfo();
            queryInfo.setTableName(targetTableName);
            DWQueryCondition queryCondition = new DWQueryCondition();
            queryCondition.ORJoin();
            queryInfo.setCondition(queryCondition);
            businessKeys.forEach(item -> {
                DWQueryCondition condition = new DWQueryCondition();
                item.forEach((key, val) -> {
                    if (DWTenantUtils.getTenantColumnName().equals(key)) {
                        condition.addEqualInfo(key, DWServiceContext.getContext().getProfile().get(DWTenantUtils.getIAMTenantSidKey()));
                    } else {
                        condition.addEqualInfo(key, val);
                    }
                });
                queryCondition.addCondition(condition);
            });
            returnValue = this.modelDataEntryService.getListForInnerInvoke(queryInfo, new DWDataSetOperationOption(), false);
        }
        this.messageCenterUtil.handleEventCenter(publishedDataRow, EventCenterTriggerTypeEnum.CREATE, returnValue);
        DWEAIResult result = EaiResultUtil.getDWEAIResult(returnValue);
        return result;
    }

    @Override
    @Transactional(propagation=Propagation.REQUIRED, rollbackFor={Exception.class})
    public Object put(Map<String, Object> headers, Map<String, Object> messageBody) throws Exception {
        DWQueryInfo queryInfo;
        Map<String, Object> returnValue = new HashMap<String, Object>();
        Map params = (Map)((Map)messageBody.get("std_data")).get("parameter");
        String digiService = (String)headers.get("digi-service");
        JSONObject digiServiceJo = new JSONObject(digiService);
        String prod = digiServiceJo.getString("prod");
        String modelDrivenProdPrefix = EaiRegisterUtil.getEaiServicePrefixOfProd(prod) + ".";
        String name = digiServiceJo.getString("name");
        String targetTableName = ModelDataUtil.replaceLast(name.replaceFirst(modelDrivenProdPrefix, ""), ".update", "").replaceAll("\\.", "_");
        DWDataSetOperationOption serviceMappingOption = new DWDataSetOperationOption();
        serviceMappingOption.setTenantEnabled(false);
        serviceMappingOption.setManagementFieldEnabled(false);
        DWQueryInfo queryInfoServiceMapping = new DWQueryInfo(targetTableName);
        queryInfoServiceMapping.setTableName("dw_service_mapping");
        queryInfoServiceMapping.addEqualInfo("table_name", (Object)targetTableName);
        DWDataSet queryDataSet = this.dao.select(queryInfoServiceMapping, serviceMappingOption);
        if (queryDataSet == null || queryDataSet.getTables().getPrimaryTable().getRows().size() < 0) {
            return EaiResultUtil.getDWEAIFalseResult(returnValue);
        }
        DWDataRow publishedDataRow = this.getModel(targetTableName);
        ModelSchemaDTO masterModelSchema = ModelSchemaUtil.parseModelSchema(publishedDataRow);
        String masterTableName = masterModelSchema.getName();
        boolean single = true;
        List<Map<String, Object>> masterTableParamDatas = new ArrayList<Map>();
        if (params.get(masterTableName) instanceof List) {
            single = false;
            masterTableParamDatas = (List)params.get(masterTableName);
        } else {
            masterTableParamDatas.add((Map)params.get(masterTableName));
        }
        ModelIndexDTO uniqueIndex = this.modelDataEntryService.getUniqueIndex(masterModelSchema, masterTableName);
        ArrayList<Map<String, Object>> businessKeys = new ArrayList<Map<String, Object>>();
        masterTableParamDatas.forEach(masterTableRow -> {
            HashMap businessKey = new HashMap();
            uniqueIndex.getMember().forEach(bkField -> businessKey.put(bkField, masterTableRow.get(bkField)));
            businessKeys.add(businessKey);
        });
        Queue deleteSqls = this.modelDataEntryService.deleteRows(masterModelSchema, businessKeys, masterModelSchema.getName(), new LinkedBlockingQueue<String>());
        while (!deleteSqls.isEmpty()) {
            DWDataSetOperationOption option = new DWDataSetOperationOption();
            option.setManagementFieldEnabled(false);
            option.setTenantEnabled(false);
            this.dao.update((IDWSQLOptions)option, (String)deleteSqls.poll(), new Object[0]);
        }
        this.modelDataEntryService.updateRows(masterModelSchema, masterTableParamDatas, true);
        if (single) {
            queryInfo = new DWQueryInfo();
            queryInfo.setTableName(targetTableName);
            DWQueryCondition queryCondition = new DWQueryCondition();
            queryCondition.ORJoin();
            queryInfo.setCondition(queryCondition);
            businessKeys.forEach(item -> {
                DWQueryCondition condition = new DWQueryCondition();
                item.forEach((key, val) -> {
                    if (DWTenantUtils.getTenantColumnName().equals(key)) {
                        condition.addEqualInfo(key, DWServiceContext.getContext().getProfile().get(DWTenantUtils.getIAMTenantSidKey()));
                    } else {
                        condition.addEqualInfo(key, val);
                    }
                });
                queryCondition.addCondition(condition);
            });
            returnValue = this.modelDataEntryService.getForInnerInvoke(queryInfo);
        } else if (CollectionUtils.isNotEmpty(masterTableParamDatas)) {
            queryInfo = new DWQueryInfo();
            queryInfo.setTableName(targetTableName);
            DWQueryCondition queryCondition = new DWQueryCondition();
            queryCondition.ORJoin();
            queryInfo.setCondition(queryCondition);
            businessKeys.forEach(item -> {
                DWQueryCondition condition = new DWQueryCondition();
                item.forEach((key, val) -> {
                    if (DWTenantUtils.getTenantColumnName().equals(key)) {
                        condition.addEqualInfo(key, DWServiceContext.getContext().getProfile().get(DWTenantUtils.getIAMTenantSidKey()));
                    } else {
                        condition.addEqualInfo(key, val);
                    }
                });
                queryCondition.addCondition(condition);
            });
            returnValue = this.modelDataEntryService.getListForInnerInvoke(queryInfo, new DWDataSetOperationOption(), false);
        }
        this.messageCenterUtil.handleEventCenter(publishedDataRow, EventCenterTriggerTypeEnum.UPDATE, returnValue);
        DWEAIResult result = EaiResultUtil.getDWEAIResult(returnValue);
        return result;
    }

    @Override
    @Transactional(propagation=Propagation.REQUIRED, rollbackFor={Exception.class})
    public Object delete(Map<String, Object> headers, Map<String, Object> messageBody) throws Exception {
        HashMap<String, Object> returnValue = new HashMap<String, Object>();
        Map params = (Map)((Map)messageBody.get("std_data")).get("parameter");
        String digiService = (String)headers.get("digi-service");
        JSONObject digiServiceJo = new JSONObject(digiService);
        String prod = digiServiceJo.getString("prod");
        String modelDrivenProdPrefix = EaiRegisterUtil.getEaiServicePrefixOfProd(prod) + ".";
        String name = digiServiceJo.getString("name");
        String targetTableName = ModelDataUtil.replaceLast(name.replaceFirst(modelDrivenProdPrefix, ""), ".delete", "").replaceAll("\\.", "_");
        DWDataSetOperationOption serviceMappingOption = new DWDataSetOperationOption();
        serviceMappingOption.setTenantEnabled(false);
        serviceMappingOption.setManagementFieldEnabled(false);
        DWQueryInfo queryInfoServiceMapping = new DWQueryInfo(targetTableName);
        queryInfoServiceMapping.setTableName("dw_service_mapping");
        queryInfoServiceMapping.addEqualInfo("table_name", (Object)targetTableName);
        DWDataSet queryDataSet = this.dao.select(queryInfoServiceMapping, serviceMappingOption);
        if (queryDataSet == null || queryDataSet.getTables().getPrimaryTable().getRows().size() < 0) {
            return EaiResultUtil.getDWEAIFalseResult(returnValue);
        }
        DWDataRow publishedDataRow = this.getModel(targetTableName);
        ModelSchemaDTO masterModelSchema = ModelSchemaUtil.parseModelSchema(publishedDataRow);
        String masterTableName = masterModelSchema.getName();
        List inputData = (List)params.get(targetTableName);
        DWQueryInfo queryInfo = new DWQueryInfo();
        queryInfo.setTableName(masterTableName);
        DWQueryCondition condition = new DWQueryCondition();
        DWBatchCondition batchCondition = new DWBatchCondition();
        batchCondition.ORJoin();
        queryInfo.setCondition(condition);
        queryInfo.toOR();
        inputData.forEach(param -> {
            DWQueryCondition subCondition = new DWQueryCondition();
            param.forEach((key, val) -> subCondition.addEqualInfo(key, val));
            condition.addCondition(subCondition);
        });
        inputData.forEach(param -> {
            DWQueryCondition subCondition = new DWQueryCondition();
            param.forEach((key, val) -> subCondition.addEqualInfo(key, val));
            batchCondition.addCondition(subCondition);
        });
        Map<String, Object> influncedDatas = this.modelDataEntryService.getListForInnerInvoke(queryInfo, new DWDataSetOperationOption(), false);
        DWDataSetOperationOption option = new DWDataSetOperationOption();
        option.getDeleteOption().enableBatchCondition();
        option.setManagementFieldEnabled(false);
        DWDataSet dataSet = new DWDataSet();
        dataSet.newTable(masterTableName).delete(batchCondition);
        DWSQLExecutionResult daoResult = this.dao.execute(dataSet, option);
        List dataList = (List)influncedDatas.get(masterTableName);
        dataList.forEach(masterTableParamData -> masterModelSchema.getChildren().forEach(subTableModel -> this.deleteSubTableData((ModelSchemaDTO)subTableModel, (Map<String, Object>)masterTableParamData, masterTableName)));
        HashMap<String, Integer> createResult = new HashMap<String, Integer>();
        createResult.put("count", daoResult.getCountByTable(targetTableName));
        returnValue.put("return_data", createResult);
        this.messageCenterUtil.handleEventCenter(publishedDataRow, EventCenterTriggerTypeEnum.DELETE, influncedDatas);
        DWEAIResult result = EaiResultUtil.getDWEAIResult(returnValue);
        return result;
    }

    @Override
    public Object putValid(Map<String, Object> headers, Map<String, Object> messageBody) throws Exception {
        Map<String, Object> returnValue = new HashMap<String, Object>();
        Map params = (Map)((Map)messageBody.get("std_data")).get("parameter");
        String digiService = (String)headers.get("digi-service");
        JSONObject digiServiceJo = new JSONObject(digiService);
        String prod = digiServiceJo.getString("prod");
        String modelDrivenProdPrefix = EaiRegisterUtil.getEaiServicePrefixOfProd(prod) + ".";
        String name = digiServiceJo.getString("name");
        String targetTableName = ModelDataUtil.replaceLast(name.replaceFirst(modelDrivenProdPrefix, ""), ".valid", "").replaceAll("\\.", "_");
        DWDataSetOperationOption serviceMappingOption = new DWDataSetOperationOption();
        serviceMappingOption.setTenantEnabled(false);
        serviceMappingOption.setManagementFieldEnabled(false);
        DWQueryInfo queryInfoServiceMapping = new DWQueryInfo(targetTableName);
        queryInfoServiceMapping.setTableName("dw_service_mapping");
        queryInfoServiceMapping.addEqualInfo("table_name", (Object)targetTableName);
        DWDataSet queryDataSet = this.dao.select(queryInfoServiceMapping, serviceMappingOption);
        if (queryDataSet == null || queryDataSet.getTables().getPrimaryTable().getRows().size() < 0) {
            return EaiResultUtil.getDWEAIFalseResult(returnValue);
        }
        DWDataRow publishedDataRow = this.getModel(targetTableName);
        ModelSchemaDTO masterModelSchema = ModelSchemaUtil.parseModelSchema(publishedDataRow);
        String masterTableName = masterModelSchema.getName();
        boolean single = true;
        List masterTableParamDatas = new ArrayList<Map>();
        if (params.get(masterTableName) instanceof List) {
            single = false;
            masterTableParamDatas = (List)params.get(masterTableName);
        } else {
            masterTableParamDatas.add((Map)params.get(masterTableName));
        }
        HashMap<String, List<Map<String, Object>>> paramDatas = new HashMap<String, List<Map<String, Object>>>();
        paramDatas.put(masterTableName, masterTableParamDatas);
        ModelSchemaUtil.validateDatas(paramDatas, masterModelSchema);
        ArrayList<Map<String, Object>> triggerKeys = new ArrayList<Map<String, Object>>();
        ModelIndexDTO uniqueIndex = this.modelDataEntryService.getUniqueIndex(masterModelSchema, targetTableName);
        DWDataSet dataSet = new DWDataSet();
        DWDataSetOperationOption option = this.getDataOption(params);
        option.getUpdateOption().setEnableBatchCondition(true);
        DWDataTable dataTable = dataSet.newTable(masterTableName);
        masterTableParamDatas.forEach(rowdata -> {
            if (rowdata.get(DWTenantUtils.getTenantColumnName().toLowerCase()) != null) {
                rowdata.remove(DWTenantUtils.getTenantColumnName().toLowerCase());
            }
            DWQueryCondition condition = new DWQueryCondition();
            HashMap keys = new HashMap();
            uniqueIndex.getMember().forEach(item -> {
                if (DWTenantUtils.getTenantColumnName().equals(item)) {
                    condition.addEqualInfo(item, DWServiceContext.getContext().getProfile().get(DWTenantUtils.getIAMTenantSidKey()));
                    keys.put(item, DWServiceContext.getContext().getProfile().get(DWTenantUtils.getIAMTenantSidKey()));
                } else {
                    condition.addEqualInfo(item, rowdata.get(item));
                    keys.put(item, rowdata.get(item));
                }
            });
            if (MapUtils.getString((Map)rowdata, (Object)"manage_status", (String)"").equals("Y")) {
                triggerKeys.add(keys);
            }
            rowdata.putAll(ModelDataUtil.getUpdateMgmtFields());
            dataTable.newRow(rowdata).setState("U").setCondition(condition);
        });
        this.dao.execute(dataSet, option);
        HashMap dataEntryParams = new HashMap();
        HashMap<String, Object> queryInfoMap = new HashMap<String, Object>();
        if (single) {
            HashMap conditions = new HashMap();
            Map masterParamData = (Map)masterTableParamDatas.get(0);
            uniqueIndex.getMember().forEach(item -> conditions.put(item, masterParamData.get(item)));
            queryInfoMap.put("userTableName", masterTableName);
            queryInfoMap.put("conditions", conditions);
            queryInfoMap.put("model", masterModelSchema);
            params.put("query_info", queryInfoMap);
            dataEntryParams.putAll(params);
            Map result = (Map)this.modelDataEntryService.get(dataEntryParams);
            if (MapUtils.isNotEmpty((Map)result)) {
                returnValue.put(masterTableName, result.get(masterTableName));
            }
        } else if (CollectionUtils.isNotEmpty(masterTableParamDatas)) {
            DWQueryInfo queryInfo = new DWQueryInfo();
            queryInfo.setTableName(targetTableName);
            DWQueryCondition queryCondition = new DWQueryCondition();
            queryCondition.ORJoin();
            queryInfo.setCondition(queryCondition);
            masterTableParamDatas.forEach(item -> {
                DWQueryCondition condition = new DWQueryCondition();
                uniqueIndex.getMember().forEach(ite -> {
                    if (DWTenantUtils.getTenantColumnName().equals(ite)) {
                        condition.addEqualInfo(ite, DWServiceContext.getContext().getProfile().get(DWTenantUtils.getIAMTenantSidKey()));
                    } else {
                        condition.addEqualInfo(ite, item.get(ite));
                    }
                });
                queryCondition.addCondition(condition);
            });
            returnValue = this.modelDataEntryService.getListForInnerInvoke(queryInfo, new DWDataSetOperationOption(), false);
        }
        if (CollectionUtils.isNotEmpty(triggerKeys)) {
            this.messageCenterUtil.handleEventCenter(publishedDataRow, EventCenterTriggerTypeEnum.VALID, returnValue, triggerKeys);
        }
        DWEAIResult result = EaiResultUtil.getDWEAIResult(returnValue);
        return result;
    }

    @Override
    public Object putInvalid(Map<String, Object> headers, Map<String, Object> messageBody) throws Exception {
        Map<String, Object> returnValue = new HashMap<String, Object>();
        Map params = (Map)((Map)messageBody.get("std_data")).get("parameter");
        String digiService = (String)headers.get("digi-service");
        JSONObject digiServiceJo = new JSONObject(digiService);
        String prod = digiServiceJo.getString("prod");
        String modelDrivenProdPrefix = EaiRegisterUtil.getEaiServicePrefixOfProd(prod) + ".";
        String name = digiServiceJo.getString("name");
        String targetTableName = ModelDataUtil.replaceLast(name.replaceFirst(modelDrivenProdPrefix, ""), ".invalid", "").replaceAll("\\.", "_");
        DWDataSetOperationOption serviceMappingOption = new DWDataSetOperationOption();
        serviceMappingOption.setTenantEnabled(false);
        serviceMappingOption.setManagementFieldEnabled(false);
        DWQueryInfo queryInfoServiceMapping = new DWQueryInfo(targetTableName);
        queryInfoServiceMapping.setTableName("dw_service_mapping");
        queryInfoServiceMapping.addEqualInfo("table_name", (Object)targetTableName);
        DWDataSet queryDataSet = this.dao.select(queryInfoServiceMapping, serviceMappingOption);
        if (queryDataSet == null || queryDataSet.getTables().getPrimaryTable().getRows().size() < 0) {
            return EaiResultUtil.getDWEAIFalseResult(returnValue);
        }
        DWDataRow publishedDataRow = this.getModel(targetTableName);
        ModelSchemaDTO masterModelSchema = ModelSchemaUtil.parseModelSchema(publishedDataRow);
        String masterTableName = masterModelSchema.getName();
        boolean single = true;
        List masterTableParamDatas = new ArrayList<Map>();
        if (params.get(masterTableName) instanceof List) {
            single = false;
            masterTableParamDatas = (List)params.get(masterTableName);
        } else {
            masterTableParamDatas.add((Map)params.get(masterTableName));
        }
        HashMap<String, List<Map<String, Object>>> paramDatas = new HashMap<String, List<Map<String, Object>>>();
        paramDatas.put(masterTableName, masterTableParamDatas);
        ModelSchemaUtil.validateDatas(paramDatas, masterModelSchema);
        ArrayList<Map<String, Object>> triggerKeys = new ArrayList<Map<String, Object>>();
        ModelIndexDTO uniqueIndex = this.modelDataEntryService.getUniqueIndex(masterModelSchema, targetTableName);
        DWDataSet dataSet = new DWDataSet();
        DWDataSetOperationOption option = this.getDataOption(params);
        option.getUpdateOption().setEnableBatchCondition(true);
        DWDataTable dataTable = dataSet.newTable(masterTableName);
        masterTableParamDatas.forEach(rowdata -> {
            if (rowdata.get(DWTenantUtils.getTenantColumnName().toLowerCase()) != null) {
                rowdata.remove(DWTenantUtils.getTenantColumnName().toLowerCase());
            }
            DWQueryCondition condition = new DWQueryCondition();
            HashMap keys = new HashMap();
            uniqueIndex.getMember().forEach(item -> {
                if (DWTenantUtils.getTenantColumnName().equals(item)) {
                    condition.addEqualInfo(item, DWServiceContext.getContext().getProfile().get(DWTenantUtils.getIAMTenantSidKey()));
                    keys.put(item, DWServiceContext.getContext().getProfile().get(DWTenantUtils.getIAMTenantSidKey()));
                } else {
                    condition.addEqualInfo(item, rowdata.get(item));
                    keys.put(item, rowdata.get(item));
                }
            });
            if (MapUtils.getString((Map)rowdata, (Object)"manage_status", (String)"").equals("V")) {
                triggerKeys.add(keys);
            }
            rowdata.putAll(ModelDataUtil.getUpdateMgmtFields());
            dataTable.newRow(rowdata).setState("U").setCondition(condition);
        });
        this.dao.execute(dataSet, option);
        HashMap dataEntryParams = new HashMap();
        HashMap<String, Object> queryInfoMap = new HashMap<String, Object>();
        if (single) {
            HashMap conditions = new HashMap();
            Map masterParamData = (Map)masterTableParamDatas.get(0);
            uniqueIndex.getMember().forEach(item -> conditions.put(item, masterParamData.get(item)));
            queryInfoMap.put("userTableName", masterTableName);
            queryInfoMap.put("conditions", conditions);
            queryInfoMap.put("model", masterModelSchema);
            params.put("query_info", queryInfoMap);
            dataEntryParams.putAll(params);
            Map result = (Map)this.modelDataEntryService.get(dataEntryParams);
            if (MapUtils.isNotEmpty((Map)result)) {
                returnValue.put(masterTableName, result.get(masterTableName));
            }
        } else if (CollectionUtils.isNotEmpty(masterTableParamDatas)) {
            DWQueryInfo queryInfo = new DWQueryInfo();
            queryInfo.setTableName(targetTableName);
            DWQueryCondition queryCondition = new DWQueryCondition();
            queryCondition.ORJoin();
            queryInfo.setCondition(queryCondition);
            masterTableParamDatas.forEach(item -> {
                DWQueryCondition condition = new DWQueryCondition();
                uniqueIndex.getMember().forEach(ite -> {
                    if (DWTenantUtils.getTenantColumnName().equals(ite)) {
                        condition.addEqualInfo(ite, DWServiceContext.getContext().getProfile().get(DWTenantUtils.getIAMTenantSidKey()));
                    } else {
                        condition.addEqualInfo(ite, item.get(ite));
                    }
                });
                queryCondition.addCondition(condition);
            });
            returnValue = this.modelDataEntryService.getListForInnerInvoke(queryInfo, new DWDataSetOperationOption(), false);
        }
        if (CollectionUtils.isNotEmpty(triggerKeys)) {
            this.messageCenterUtil.handleEventCenter(publishedDataRow, EventCenterTriggerTypeEnum.INVALID, returnValue, triggerKeys);
        }
        DWEAIResult result = EaiResultUtil.getDWEAIResult(returnValue);
        return result;
    }

    @Override
    public Object getTableSchema(Map<String, Object> headers, Map<String, Object> messageBody) throws SQLException {
        HashMap<String, Object> returnValue = new HashMap<String, Object>();
        Map params = (Map)((Map)messageBody.get("std_data")).get("parameter");
        List codes = (List)MapUtils.getObject((Map)params, (Object)"code");
        List<String> targetTableNames = new ArrayList();
        HashMap<String, List<ModelFieldDTO>> allMetadataData = new HashMap<String, List<ModelFieldDTO>>();
        QueryRunner queryRunner = this.dao.getQueryRunner();
        try (Connection connection = queryRunner.getDataSource().getConnection();){
            String schema = connection.getSchema();
            DatabaseMetaData databaseMetadata = connection.getMetaData();
            if (CollectionUtils.isEmpty((Collection)codes)) {
                try (ResultSet rs = databaseMetadata.getTables(null, schema, "%", null);){
                    while (rs.next()) {
                        targetTableNames.add(rs.getString("TABLE_NAME"));
                    }
                }
            } else {
                targetTableNames = codes;
            }
            for (String tableName : targetTableNames) {
                List<ModelFieldDTO> columnMetadatas = TableDao.getColumns(connection, schema, tableName);
                allMetadataData.put(tableName, columnMetadatas);
            }
        }
        returnValue.put("return_data", allMetadataData);
        DWEAIResult result = EaiResultUtil.getDWEAIResult(returnValue);
        return result;
    }

    public DWEAIResult getMetadata(Map<String, Object> headers, Map<String, Object> messageBody) {
        Object result;
        Map params = (Map)((Map)messageBody.get("std_data")).get("parameter");
        List datas = (List)params.get("data");
        HashMap<String, Object> allMetadataData = new HashMap<String, Object>();
        DWDataSetOperationOption option = ModelDataUtil.getDisabledCommonDataSetOperationOption();
        String keyTableComment = "tableComment";
        if (CollectionUtils.isNotEmpty((Collection)datas)) {
            for (String tableName : datas) {
                List result2 = this.dao.select((IDWSQLOptions)option, "select dw_rdbms_tables.table_description as " + keyTableComment + " from dw_rdbms_tables " + " where dw_rdbms_tables.table_name = ?", new Object[]{tableName});
                if (CollectionUtils.isNotEmpty((Collection)result2)) {
                    ArrayList val = new ArrayList();
                    val.add(result2.get(0));
                    allMetadataData.put(tableName, val);
                    continue;
                }
                log.warn("tableName({}): No data in dw_rdbms_tables", (Object)tableName);
            }
        } else {
            result = this.dao.select((IDWSQLOptions)option, "select dw_rdbms_tables.table_name as tableName , dw_rdbms_tables.table_description as  " + keyTableComment + " from dw_rdbms_tables " + " order by dw_rdbms_tables.table_name asc", new Object[0]);
            if (CollectionUtils.isNotEmpty((Collection)result)) {
                result.stream().forEach(tableData -> {
                    HashMap rowMap = new HashMap();
                    rowMap.put(keyTableComment, tableData.get(keyTableComment));
                    ArrayList val = new ArrayList();
                    val.add(rowMap);
                    allMetadataData.put(tableData.get("tableName").toString(), val);
                });
            }
        }
        result = EaiResultUtil.getDWEAIResult(allMetadataData);
        return result;
    }

    public DWDataSetOperationOption getDataOption(Map<String, Object> params) {
        DWDataSetOperationOption option = new DWDataSetOperationOption();
        option.setManagementFieldEnabled(false);
        return option;
    }

    public DWDataRow getPublished(ModelOidDTO modelOid) {
        String appId = DWServiceContext.getContext().getRequestURI();
        List<Object> pkList = this.getDataEntryPkList(appId, modelOid);
        DWQueryInfo queryInfo = new DWQueryInfoBuilder().setOids(pkList).create();
        queryInfo.setTableName("dw_lcdp_model");
        DWDataSet dataSet = this.dao.select(queryInfo);
        if (dataSet != null && dataSet.getTable("dw_lcdp_model").getRows().size() > 0) {
            DWDataRow dataRow = dataSet.getTable("dw_lcdp_model").getRow(0);
            return dataRow;
        }
        return null;
    }

    public DWDataRow getModel(String tableName) {
        log.debug("starting get model from tableName {}", (Object)tableName);
        DWDataSetOperationOption option = new DWDataSetOperationOption();
        option.setTenantEnabled(false);
        option.setManagementFieldEnabled(false);
        DWQueryInfo queryInfo = new DWQueryInfo();
        queryInfo.setTableName("dw_lcdp_model_info");
        queryInfo.setJoinOnColumn(DWQueryJoinRelation.Join, "dw_lcdp_model", new DWOnColumn[]{new DWOnColumn("code", DWQueryValueOperator.Equals, "code")});
        queryInfo.addEqualInfo("table_name", (Object)tableName);
        queryInfo.addSelectField(new String[]{"dw_lcdp_model.*"});
        DWDataRow dataRow = this.dao.selectOne(queryInfo, option);
        return dataRow;
    }

    private List<Object> getDataEntryPkList(String appId, ModelOidDTO modelOid) {
        HashMap<String, String> pkMap = new HashMap<String, String>();
        pkMap.put("code", modelOid.getCode());
        return Collections.singletonList(pkMap);
    }

    @Override
    public Object getModelSql(Map<String, Object> headers, Map<String, Object> messageBody) throws Exception {
        HashMap<String, Object> returnValue = new HashMap<String, Object>();
        Map params = (Map)((Map)messageBody.get("std_data")).get("parameter");
        List codes = (List)params.get("codes");
        String digiService = (String)headers.get("digi-service");
        JSONObject digiServiceJo = new JSONObject(digiService);
        String prod = digiServiceJo.getString("prod");
        String modelDrivenProdPrefix = EaiRegisterUtil.getEaiServicePrefixOfProd(prod);
        ModelDrivenContext.getContext().getExtraMap().put("modelDrivenProdPrefix", modelDrivenProdPrefix);
        if (CollectionUtils.isEmpty((Collection)codes)) {
            Map modelData = (Map)params.get("model");
            String modelStr = DWGsonProvider.getGson().toJson((Object)modelData);
            ModelDTO model = (ModelDTO)DWGsonProvider.getGson().fromJson(modelStr, ModelDTO.class);
            if (model.getSchema() == null) {
                log.debug("code({}) input model_schema is null", (Object)model.getCode());
                String modelSchemaStr = (String)modelData.get("model_schema");
                ModelSchemaDTO modelSchema = ModelSchemaUtil.getModelSchema(modelSchemaStr);
                model.setSchema(modelSchema);
            }
            Map<String, Object> codeSqlList = ModelSqlGenerator.getModelSql(model);
            returnValue.putAll(codeSqlList);
        } else {
            ArrayList codesBindedSqls = new ArrayList();
            for (String currentCode : codes) {
                ModelOidDTO modelOidDTO = new ModelOidDTO(currentCode, null, null, null);
                DWDataRow publishedDataRow = this.getPublished(modelOidDTO);
                if (publishedDataRow == null) {
                    returnValue.put(currentCode, new HashMap());
                    continue;
                }
                ModelDTO currentModel = ModelSchemaUtil.getModel(publishedDataRow);
                Map<String, Object> codeSqlList = ModelSqlGenerator.getModelSql(currentModel);
                if (!codeSqlList.containsKey("bindedSql") || !CollectionUtils.isNotEmpty((Collection)((List)codeSqlList.get("bindedSql")))) continue;
                List currentCodeBindedSql = codeSqlList.getOrDefault("bindedSql", new ArrayList());
                codesBindedSqls.addAll(currentCodeBindedSql);
                returnValue.put(currentCode, codeSqlList.get(currentCode));
            }
            returnValue.put("bindedSql", codesBindedSqls);
        }
        DWEAIResult dwEaiResult = EaiResultUtil.getDWEAIResult(returnValue);
        return dwEaiResult;
    }

    @Override
    public Object putModelDesign(Map<String, Object> headers, Map<String, Object> messageBody) throws Exception {
        DWEAIResult dwEaiResult;
        String actualAppId = ApTokenUtil.getCurrentAppId();
        String digiService = (String)headers.get("digi-service");
        JSONObject digiServiceJo = new JSONObject(digiService);
        String prod = digiServiceJo.getString("prod");
        if (!messageBody.containsKey("std_data")) {
            HashMap<String, Object> errorMsg = new HashMap<String, Object>();
            errorMsg.put("cause", "missing key:std_data");
            return EaiResultUtil.getDWEAIFalseResult(errorMsg);
        }
        Map params = (Map)((Map)messageBody.get("std_data")).get("parameter");
        String modelDrivenProdPrefix = EaiRegisterUtil.getEaiServicePrefixOfProd(prod);
        ModelDrivenContext modelDrivenContext = ModelDrivenContext.getContext();
        modelDrivenContext.getExtraMap().put("modelDrivenProdPrefix", modelDrivenProdPrefix);
        Map modelData = (Map)params.get("model");
        String modelStr = DWGsonProvider.getGson().toJson((Object)modelData);
        ModelDTO draftModel = (ModelDTO)DWGsonProvider.getGson().fromJson(modelStr, ModelDTO.class);
        Assert.notNull((Object)draftModel, (String)"input model must not be null");
        draftModel.setUseExistedTable(ModelCreateTypeEnum.getTypeEnum((String)modelData.get("useExistedTable")));
        ModelSchemaDTO draftModelSchema = draftModel.getSchema();
        if (draftModelSchema == null) {
            log.debug("code({}) input model_schema is null", (Object)draftModel.getCode());
            String modelSchemaStr = (String)modelData.get("model_schema");
            draftModelSchema = ModelSchemaUtil.getModelSchema(modelSchemaStr);
            draftModel.setSchema(draftModelSchema);
        }
        Assert.notNull((Object)draftModelSchema, (String)"'draftModelSchema' must not be null");
        String code = draftModel.getCode();
        draftModel.setAppId(actualAppId);
        String tenantId = ApTokenUtil.getCurrentTenantId();
        draftModel.setTargetTenantId(tenantId);
        modelDrivenContext.setCode(draftModel.getCode());
        modelDrivenContext.setDraftModel(draftModel);
        modelDrivenContext.setModelSchemaDTO(draftModelSchema);
        PublishModelStatusDTO publishServiceResult = this.modelPublishService.publishDraft();
        PublishModelResultDTO publishResult = new PublishModelResultDTO();
        publishResult.add(publishServiceResult);
        DWServiceResult serviceResult = new DWServiceResult();
        serviceResult = publishResult.isSuccess() ? DWServiceResultBuilder.build((boolean)true, (String)"published_successfully", (Object)publishResult) : DWServiceResultBuilder.build((boolean)false, (String)"published_model_failed", (Object)publishResult);
        HashMap<String, Object> returnValue = new HashMap<String, Object>();
        returnValue.put("code", code);
        if (serviceResult.isSuccess()) {
            dwEaiResult = EaiResultUtil.getDWEAIResult(returnValue);
        } else if (serviceResult.getData() instanceof Map) {
            returnValue.putAll((Map)serviceResult.getData());
            dwEaiResult = EaiResultUtil.getDWEAIFalseResult(returnValue);
        } else {
            String message = serviceResult.getMessage();
            returnValue.put("message", message);
            dwEaiResult = EaiResultUtil.getDWEAIFalseResult(returnValue);
        }
        return dwEaiResult;
    }

    @Override
    public Object deleteModelDesign(Map<String, Object> headers, Map<String, Object> messageBody) throws Exception {
        DWEAIResult dwEaiResult;
        Map params = (Map)((Map)messageBody.get("std_data")).get("parameter");
        Map modelData = (Map)params.get("model");
        String modelStr = DWGsonProvider.getGson().toJson((Object)modelData);
        ModelDTO model = (ModelDTO)DWGsonProvider.getGson().fromJson(modelStr, ModelDTO.class);
        DWServiceResult serviceResult = this.modelPublishService.deleteModelSchema(model);
        HashMap<String, Object> returnValue = new HashMap<String, Object>();
        returnValue.put("code", model.getCode());
        if (serviceResult.isSuccess()) {
            dwEaiResult = EaiResultUtil.getDWEAIResult(returnValue);
        } else if (serviceResult.getData() instanceof Map) {
            returnValue.putAll((Map)serviceResult.getData());
            dwEaiResult = EaiResultUtil.getDWEAIFalseResult(returnValue);
        } else {
            String message = serviceResult.getMessage();
            returnValue.put("message", message);
            dwEaiResult = EaiResultUtil.getDWEAIFalseResult(returnValue);
        }
        return dwEaiResult;
    }

    @Override
    public Object getSqlReport(Map<String, Object> headers, Map<String, Object> messageBody) throws Exception {
        Statement statement;
        HashMap<String, Object> returnData = new HashMap<String, Object>();
        Map params = (Map)((Map)messageBody.get("std_data")).get("parameter");
        String sqlFieldsStr = DWGsonProvider.getGson().toJson((Object)params);
        SqlValueFields sqlValueFields = (SqlValueFields)DWGsonProvider.getGson().fromJson(sqlFieldsStr, SqlValueFields.class);
        DWDataSetOperationOption option = ModelDataUtil.getDisabledCommonDataSetOperationOption();
        String sql = sqlValueFields.getSql();
        ReportCheckResult checkResult = ModelDrivenReportUtil.checkSql(sqlValueFields, this.modelTableHelperExpress);
        if (!checkResult.isSuccess()) {
            returnData.put("error", checkResult.getMessages());
            return EaiResultUtil.getDWEAIFalseResult(returnData);
        }
        if (StringUtils.isNotEmpty((CharSequence)sqlValueFields.getActionId()) && StringUtils.isNotEmpty((CharSequence)sqlValueFields.getModuleId()) && StringUtils.isNotEmpty((CharSequence)sqlValueFields.getAppId()) && (statement = CCJSqlParserUtil.parse((String)sql)) instanceof Select) {
            String appId = Optional.ofNullable(sqlValueFields.getAppId()).orElseThrow(() -> new RuntimeException("appId of view_info can not be null"));
            String actionId = Optional.ofNullable(sqlValueFields.getActionId()).orElseThrow(() -> new RuntimeException("actionId of view_info can not be null"));
            String moduleId = Optional.ofNullable(sqlValueFields.getModuleId()).orElseThrow(() -> new RuntimeException("moduleId of view_info can not be null"));
            DWUserPermission dataPermData = (DWUserPermission)this.modelDataEntryService.getTBBDataPermission(appId, moduleId, actionId);
            PlainSelect select = (PlainSelect)((Select)statement).getSelectBody();
            FromItem fromItem = select.getFromItem();
            if (fromItem != null) {
                while (fromItem instanceof SubSelect && ((SubSelect)fromItem).getSelectBody() != null) {
                    SubSelect subSelect = (SubSelect)fromItem;
                    PlainSelect ssubSelect = (PlainSelect)subSelect.getSelectBody();
                    if (ssubSelect.getFromItem() instanceof Table) {
                        PlainSelect subPlanSelect = (PlainSelect)subSelect.getSelectBody();
                        String rowConditionSql = ModelSqlGenerator.getUserRowPermissionConditionSql(dataPermData, subPlanSelect);
                        if (StringUtils.isNotEmpty((CharSequence)rowConditionSql)) {
                            Expression conditions = CCJSqlParserUtil.parseCondExpression((String)rowConditionSql);
                            Expression where = subPlanSelect.getWhere();
                            if (conditions != null) {
                                if (where == null) {
                                    subPlanSelect.setWhere(conditions);
                                } else {
                                    AndExpression expression = new AndExpression(where, conditions);
                                    subPlanSelect.setWhere((Expression)expression);
                                }
                                sql = select.toString();
                            }
                        }
                        break;
                    }
                    if (!(ssubSelect.getFromItem() instanceof SubSelect)) continue;
                    fromItem = ssubSelect.getFromItem();
                }
            } else {
                String rowConditionSql = ModelSqlGenerator.getUserRowPermissionConditionSql(dataPermData, select);
                Expression conditions = CCJSqlParserUtil.parseCondExpression((String)rowConditionSql);
                Expression where = select.getWhere();
                if (conditions != null) {
                    AndExpression expression = new AndExpression(where, conditions);
                    select.setWhere((Expression)expression);
                    sql = select.toString();
                }
            }
        }
        StopWatch executeWatch = StopWatch.createStarted();
        List sqlQueryData = this.dao.select((IDWSQLOptions)option, sql, new Object[0]);
        int daoDataSize = sqlQueryData.size();
        returnData.put("daoSize", daoDataSize);
        if (daoDataSize > 0) {
            executeWatch.split();
            returnData.put("daoCost", executeWatch.getTime());
            List<String> sqlTableColumnNames = ((Map)sqlQueryData.get(0)).keySet().stream().collect(Collectors.toList());
            List<ValueReference> validValueReferences = ModelDrivenReportUtil.getValidValueReference(sqlValueFields.getFields(), sqlTableColumnNames);
            List keysDictionary = validValueReferences.stream().map(valueReference -> valueReference.getFullPath()).collect(Collectors.toList());
            keysDictionary.retainAll(sqlTableColumnNames);
            if (CollectionUtils.isNotEmpty(keysDictionary)) {
                for (Map rowData : sqlQueryData) {
                    for (String keyRowData : rowData.keySet()) {
                        if (!keysDictionary.contains(keyRowData)) continue;
                        Object valueRowData = rowData.get(keyRowData);
                        log.debug("process key({}) value({})", (Object)keyRowData, valueRowData);
                        for (ValueReference valueRef : validValueReferences) {
                            List<Dictionary> dicts;
                            if (!valueRef.getFullPath().equals(keyRowData) || !CollectionUtils.isNotEmpty(dicts = valueRef.getDictionary())) continue;
                            for (Dictionary dict : dicts) {
                                if (dict.getCode().equals(String.valueOf(valueRowData))) {
                                    rowData.replace(keyRowData, dict.getValue());
                                    log.debug("found key({}), {} -> {}", new Object[]{keyRowData, dict.getCode(), dict.getValue()});
                                    continue;
                                }
                                log.debug("not found key({})", (Object)dict.getCode());
                            }
                        }
                    }
                }
                executeWatch.split();
                returnData.put("replaceCost", executeWatch.getSplitTime());
            }
        }
        executeWatch.stop();
        returnData.put("data", sqlQueryData);
        DWEAIResult result = EaiResultUtil.getDWEAIResult(returnData);
        return result;
    }

    @Override
    public Object dataViewGet(Map<String, Object> headers, Map<String, Object> messageBody) throws Exception {
        Map params = (Map)((Map)messageBody.get("std_data")).get("parameter");
        Gson gson = DWGsonProvider.getGson();
        DataViewDTO viewInfo = (DataViewDTO)gson.fromJson(gson.toJson((Object)params, Map.class), DataViewDTO.class);
        return this.modelDrivenDataViewService.dataviewGet(viewInfo);
    }

    void deleteSubTableData(ModelSchemaDTO subTableModel, Map<String, Object> masterTableData, String masterTableName) {
        if (MapUtils.isNotEmpty(masterTableData)) {
            String subTableName = subTableModel.getName();
            List<ModelFieldDTO> quoteFields = subTableModel.getFields().stream().filter(field -> ModelFieldRelationTypeEnum.QUOTE.getValue().equals(field.getType()) && field.getAssociatedInfo().getTableName().equals(masterTableName)).collect(Collectors.toList());
            if (CollectionUtils.isNotEmpty(quoteFields)) {
                DWQueryInfo subTableQueryInfo = new DWQueryInfo();
                subTableQueryInfo.setTableName(subTableName);
                quoteFields.forEach(field -> {
                    String quoteField = field.getFieldId();
                    subTableQueryInfo.addEqualInfo(quoteField, masterTableData.get(quoteField));
                });
                DWDataSet subtableDataSet = this.dao.select(subTableQueryInfo);
                DWDataRowCollection subtableRows = subtableDataSet.getTable(subTableName).getRows();
                if (subtableRows != null && subtableRows.size() > 0) {
                    StringBuilder deleteSql = new StringBuilder("delete from " + subTableName + " where 1=1 ");
                    ArrayList deleteParams = new ArrayList();
                    quoteFields.forEach(field -> {
                        String quoteField = field.getFieldId();
                        deleteSql.append(" and ").append(quoteField).append(" = ? ");
                        deleteParams.add(masterTableData.get(quoteField));
                    });
                    if (DWTenantUtils.isTenantenabled()) {
                        deleteSql.append(DWTenantUtils.getTenantTagByColumnName());
                    }
                    DWDataSetOperationOption option = new DWDataSetOperationOption();
                    option.setManagementFieldEnabled(false);
                    this.dao.update((IDWSQLOptions)option, deleteSql.toString(), deleteParams.toArray(new Object[deleteParams.size()]));
                }
                subtableRows.forEach(subTableData -> {
                    List<ModelSchemaDTO> subsubTableModels = subTableModel.getChildren();
                    if (CollectionUtils.isNotEmpty(subsubTableModels)) {
                        subsubTableModels.forEach(subsubTableModel -> this.deleteSubTableData((ModelSchemaDTO)subsubTableModel, subTableData.getData(), subTableName));
                    }
                });
            }
        }
    }

    @Override
    public Object invoke(Map<String, Object> headers, Map<String, Object> messageBody) {
        Map params = (Map)((Map)messageBody.get("std_data")).get("parameter");
        String invokeId = Optional.ofNullable((String)params.get("invokeId")).orElseThrow(() -> new RuntimeException("invokeId can not be null"));
        String componentId = "";
        String methodId = "";
        if (invokeId.split("\\/").length != 2) {
            throw new RuntimeException("parameter 'invokeId' is illegal");
        }
        componentId = invokeId.split("\\/")[0];
        methodId = invokeId.split("\\/")[1];
        Map param = Optional.ofNullable((Map)params.get("request")).orElseThrow(() -> new RuntimeException("paramter 'request' can not be null"));
        try {
            Object object = Class.forName("com.digiwin.lcdp.modeldriven.extend.dap.decorator." + componentId).newInstance();
            Method method = object.getClass().getDeclaredMethod(methodId, Map.class);
            return method.invoke(object, param);
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }
}

