/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.lcdp.modeldriven.service.impl;

import com.digiwin.app.container.exceptions.DWBusinessException;
import com.digiwin.app.dao.DWBatchCondition;
import com.digiwin.app.dao.DWDao;
import com.digiwin.app.dao.DWQueryInfo;
import com.digiwin.app.dao.DWQueryInfoBuilder;
import com.digiwin.app.dao.DWQueryValueOperator;
import com.digiwin.app.dao.DWSQLExecutionResult;
import com.digiwin.app.dao.DWServiceResultBuilder;
import com.digiwin.app.data.DWDataRow;
import com.digiwin.app.data.DWDataSet;
import com.digiwin.app.data.DWDataSetBuilder;
import com.digiwin.app.data.DWDataSetOperationOption;
import com.digiwin.app.service.DWServiceContext;
import com.digiwin.app.service.DWServiceResult;
import com.digiwin.lcdp.modeldriven.context.ModelDrivenContext;
import com.digiwin.lcdp.modeldriven.enums.AlterColumnEnum;
import com.digiwin.lcdp.modeldriven.enums.AlterIndexEnum;
import com.digiwin.lcdp.modeldriven.enums.IndexTypeEnum;
import com.digiwin.lcdp.modeldriven.enums.ModelCreateTypeEnum;
import com.digiwin.lcdp.modeldriven.enums.ModelFieldRelationTypeEnum;
import com.digiwin.lcdp.modeldriven.enums.PublishStatusEnum;
import com.digiwin.lcdp.modeldriven.model.ModelDTO;
import com.digiwin.lcdp.modeldriven.model.ModelFieldDTO;
import com.digiwin.lcdp.modeldriven.model.ModelIndexDTO;
import com.digiwin.lcdp.modeldriven.model.ModelOidDTO;
import com.digiwin.lcdp.modeldriven.model.ModelPublishedEspResult;
import com.digiwin.lcdp.modeldriven.model.ModelSchemaDTO;
import com.digiwin.lcdp.modeldriven.model.ModelTable;
import com.digiwin.lcdp.modeldriven.model.SqlParam;
import com.digiwin.lcdp.modeldriven.model.TableColumn;
import com.digiwin.lcdp.modeldriven.model.TableIndex;
import com.digiwin.lcdp.modeldriven.pojo.PublishModelStatusDTO;
import com.digiwin.lcdp.modeldriven.utils.ApTokenUtil;
import com.digiwin.lcdp.modeldriven.utils.ModelDataUtil;
import com.digiwin.lcdp.modeldriven.utils.ModelDrivenMetadataUtil;
import com.digiwin.lcdp.modeldriven.utils.ModelSchemaUtil;
import com.digiwin.lcdp.modeldriven.utils.ModelSqlGenerator;
import com.digiwin.lcdp.modeldriven.utils.ModelTableHelperExpress;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import net.sf.jsqlparser.JSQLParserException;
import net.sf.jsqlparser.statement.create.table.CreateTable;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;

@Service
public class ModelPublishService {
    private static final Logger log = LoggerFactory.getLogger(ModelPublishService.class);
    @Autowired
    @Qualifier(value="dw-dao")
    private DWDao dao;
    @Autowired
    private ModelTableHelperExpress modelTableHelperExpress;
    @Autowired
    private ModelPublishService modelPublishService;

    public DWDataRow getPublished(ModelOidDTO modelOid) {
        String appId = ApTokenUtil.getCurrentAppId();
        List<Object> pkList = this.getPkList(modelOid);
        DWDataSetOperationOption option = ModelDataUtil.getDisabledCommonDataSetOperationOption();
        DWQueryInfo queryInfo = new DWQueryInfoBuilder().setOids(pkList).create();
        queryInfo.setTableName("dw_lcdp_model");
        DWDataSet dataSet = this.dao.select(queryInfo, option);
        if (dataSet != null && dataSet.getTable("dw_lcdp_model").getRows().size() > 0) {
            DWDataRow dataRow = dataSet.getTable("dw_lcdp_model").getRow(0);
            Assert.isTrue((boolean)ApTokenUtil.getCurrentAppId().equals(dataRow.get("app_id")), (String)String.format("the appid of model '%s' is wrong", modelOid.getCode()));
            return dataRow;
        }
        return null;
    }

    @Transactional(propagation=Propagation.REQUIRED, rollbackFor={Exception.class})
    public DWServiceResult deleteModelSchema(ModelDTO model) throws Exception {
        HashMap<String, Integer> returnData = new HashMap<String, Integer>();
        String appId = ApTokenUtil.getCurrentAppId();
        model.setAppId(appId);
        String code = model.getCode();
        log.debug("code({}) input model_schema", (Object)model.getCode());
        String tenantId = model.getTargetTenantId();
        ModelOidDTO modelOidDTO = new ModelOidDTO(code, null, tenantId);
        DWDataRow publishedDataRow = this.getPublished(modelOidDTO);
        if (publishedDataRow == null || publishedDataRow.getData().size() == 0) {
            log.warn("code({}) no publishedDataRow data", (Object)code);
        } else {
            model.setSchema(ModelSchemaUtil.getModelSchema((String)publishedDataRow.get("model_schema")));
        }
        Map<String, Object> dmlModelInfoDataSet = this.modelPublishService.deleteModelInfoForDeleteModel(model);
        DWSQLExecutionResult publishedDelete = this.modelPublishService.deletePublished(model, publishedDataRow, dmlModelInfoDataSet);
        returnData.put("model", publishedDelete.getDeleteCount());
        return DWServiceResultBuilder.build((String)"published deleted model", returnData);
    }

    @Transactional(propagation=Propagation.REQUIRED, rollbackFor={Exception.class})
    public Map<String, Object> deleteModelInfoForDeleteModel(ModelDTO model) {
        DWDataSetOperationOption optionDelete = ModelDataUtil.getDisabledCommonDataSetOperationOption();
        optionDelete.getDeleteOption().enableBatchCondition();
        DWBatchCondition batchCondition = new DWBatchCondition();
        String code = model.getCode();
        String appId = model.getAppId();
        batchCondition.addFieldInfo("code", DWQueryValueOperator.Equals, new Object[]{code});
        batchCondition.addFieldInfo("app_id", DWQueryValueOperator.Equals, new Object[]{appId});
        DWDataSet dataSetModelInfo = new DWDataSet();
        dataSetModelInfo.newTable("dw_lcdp_model_info").delete(batchCondition);
        DWSQLExecutionResult returnDaoValue = this.dao.execute(dataSetModelInfo, optionDelete);
        HashMap<String, Object> returnValue = new HashMap<String, Object>();
        if (log.isDebugEnabled()) {
            log.info("code({}) model_info deleted count({})", (Object)code, (Object)returnDaoValue.getDeleteCount());
        }
        return returnValue;
    }

    @Transactional(propagation=Propagation.REQUIRED, rollbackFor={Exception.class})
    public Object deleteModelAndDraft(ModelDTO model) {
        String code = model.getCode();
        String appId = model.getAppId();
        HashMap<String, Integer> returnValue = new HashMap<String, Integer>();
        DWDataSetOperationOption optionDelete = new DWDataSetOperationOption();
        optionDelete.setTenantEnabled(false);
        optionDelete.setManagementFieldEnabled(false);
        optionDelete.getDeleteOption().enableBatchCondition();
        DWBatchCondition batchCondition2 = new DWBatchCondition();
        batchCondition2.addFieldInfo("code", DWQueryValueOperator.Equals, new Object[]{code});
        batchCondition2.addFieldInfo("app_id", DWQueryValueOperator.Equals, new Object[]{appId});
        DWDataSet dataSetModel = new DWDataSet();
        dataSetModel.newTable("dw_lcdp_model").delete(batchCondition2);
        DWSQLExecutionResult deleteModelResult = this.dao.execute(dataSetModel, optionDelete);
        returnValue.put("dw_lcdp_model", deleteModelResult.getDeleteCount());
        if (log.isDebugEnabled()) {
            log.debug("code({}) deleted ({})", (Object)code, returnValue);
        }
        return returnValue;
    }

    public PublishModelStatusDTO publishDraft() throws Exception {
        ModelDTO draftModel = ModelDrivenContext.getContext().getDraftModel();
        ModelSchemaDTO draftModelSchema = draftModel.getSchema();
        String code = draftModel.getCode();
        String modelDescription = draftModel.getDescription();
        String modelTargetTenantId = draftModel.getTargetTenantId();
        PublishModelStatusDTO publishModelStatus = new PublishModelStatusDTO();
        publishModelStatus.setCode(code);
        publishModelStatus.setDescription(modelDescription);
        publishModelStatus.setTargetTenantId(modelTargetTenantId);
        Map<String, Object> draftDataRowMap = ModelDataUtil.buildModelData(draftModel);
        List<String> dirtyTableNames = ModelSchemaUtil.getTableNames(draftModelSchema);
        ModelOidDTO modelOidDTO = new ModelOidDTO(code, dirtyTableNames, modelTargetTenantId, null);
        DWDataRow publishedDataRow = this.getPublished(modelOidDTO);
        log.debug("publishDraft: publishing model (query published schema model db) , publishedModelDataRow = {}", (Object)publishedDataRow);
        Object userSid = DWServiceContext.getContext().getProfile().get("userSid");
        if (publishedDataRow != null) {
            log.debug("code({}) preparing alter schema", (Object)draftModel.getCode());
            draftDataRowMap.put("update_user_sid", userSid);
            ModelSchemaDTO publishedModelSchema = ModelSchemaUtil.parseModelSchema(publishedDataRow);
            List<String> publishedTableNames = ModelSchemaUtil.getTableNames(publishedModelSchema);
            publishedTableNames.stream().forEach(pTableName -> {
                if (!dirtyTableNames.contains(pTableName)) {
                    dirtyTableNames.add((String)pTableName);
                }
            });
            ModelPublishedEspResult modelPublishedEspResult = this.modelPublishService.alterTableExpress(draftModelSchema, publishedModelSchema, code);
            PublishStatusEnum publishStatus = modelPublishedEspResult.getPublishStatusEnum();
            publishModelStatus.setStatus(publishStatus);
        } else {
            log.debug("code({}) preparing create schema", (Object)code);
            draftDataRowMap.put("create_user_sid", userSid);
            ModelPublishedEspResult modelPublishedEspResult = draftModel.getUseExistedTable().equals((Object)ModelCreateTypeEnum.EXISTED_TABLE) ? this.modelPublishService.createOrAlterCustomizeTableExpress(draftModelSchema) : this.modelPublishService.createTableExpress(draftModelSchema);
            PublishStatusEnum publishStatus = modelPublishedEspResult.getPublishStatusEnum();
            publishModelStatus.setStatus(publishStatus);
        }
        ModelDrivenMetadataUtil.removeRdbmsMetadata(code, dirtyTableNames);
        return publishModelStatus;
    }

    private List<Object> getPkList(String appId, ModelOidDTO modelOid) {
        HashMap<String, String> pkMap = new HashMap<String, String>();
        pkMap.put("app_id", appId);
        pkMap.put("code", modelOid.getCode());
        return Collections.singletonList(pkMap);
    }

    private List<Object> getPkList(ModelOidDTO modelOid) {
        HashMap<String, String> pkMap = new HashMap<String, String>();
        pkMap.put("code", modelOid.getCode());
        return Collections.singletonList(pkMap);
    }

    @Transactional(propagation=Propagation.REQUIRED, rollbackFor={Exception.class})
    public ModelPublishedEspResult createTableExpress(ModelSchemaDTO draftModelSchema) throws Exception {
        ModelSchemaUtil.checkModelSchema(draftModelSchema, true);
        List<ModelTable> modelTables = ModelSchemaUtil.getModelTables(draftModelSchema, false);
        AtomicReference<PublishStatusEnum> createStatus = new AtomicReference<PublishStatusEnum>(PublishStatusEnum.UNCHANGED);
        DWServiceResult serviceResult = this.modelTableHelperExpress.createTableExpress(draftModelSchema.getName(), modelTables);
        boolean createRunStatus = serviceResult.getSuccess();
        if (log.isDebugEnabled()) {
            log.debug(String.format("create: expected(%b) actual(%b), description:(%s)", createStatus, createRunStatus, serviceResult.getMessage()));
        }
        if (createRunStatus) {
            createStatus.set(PublishStatusEnum.SUCCESS);
        } else {
            createStatus.set(PublishStatusEnum.FAILURE);
        }
        ModelPublishedEspResult publishedEspResult = new ModelPublishedEspResult();
        publishedEspResult.setPublishStatusEnum(createStatus.get());
        publishedEspResult.setServiceResult(serviceResult);
        return publishedEspResult;
    }

    @Transactional(propagation=Propagation.REQUIRED, rollbackFor={Exception.class})
    public ModelPublishedEspResult createOrAlterCustomizeTableExpress(ModelSchemaDTO draftModelSchema) throws Exception {
        ModelDTO draftModel = ModelDrivenContext.getContext().getDraftModel();
        log.debug("[ModelPublishService] code({}) alterCustomizeTableExpress", (Object)draftModel.getCode());
        ModelSchemaUtil.checkModelSchema(draftModelSchema, true);
        List<ModelTable> draftModelTables = ModelSchemaUtil.getModelTables(draftModelSchema, false);
        AtomicReference<PublishStatusEnum> createStatus = new AtomicReference<PublishStatusEnum>(PublishStatusEnum.UNCHANGED);
        DWServiceResult serviceResult = this.modelTableHelperExpress.createCustomizeTableExpress(draftModelSchema.getName(), draftModelTables);
        boolean createRunStatus = serviceResult.getSuccess();
        if (log.isDebugEnabled()) {
            log.debug(String.format("[createOrAlterCustomizeTableExpress] expected(%b) actual(%b), description:(%s)", createStatus, createRunStatus, serviceResult.getMessage()));
        }
        if (createRunStatus) {
            createStatus.set(PublishStatusEnum.SUCCESS);
        } else {
            createStatus.set(PublishStatusEnum.FAILURE);
        }
        ModelPublishedEspResult publishedEspResult = new ModelPublishedEspResult();
        publishedEspResult.setPublishStatusEnum(createStatus.get());
        publishedEspResult.setServiceResult(serviceResult);
        return publishedEspResult;
    }

    public ModelPublishedEspResult alterTableExpress(ModelSchemaDTO draftModelSchema, ModelSchemaDTO publishedModelSchema, String code) throws Exception {
        ModelSchemaUtil.checkModelSchema(draftModelSchema, false);
        ModelSchemaUtil.checkModelSchema(publishedModelSchema, false);
        String masterTableName = draftModelSchema.getName();
        log.debug("=============== express alterTable ====== {} =========", (Object)masterTableName);
        List<String> childrenTableNames = ModelDataUtil.getChildrenName(draftModelSchema);
        log.debug("alterTable starting....masterTableName({}) childrenTableNames({}) ", (Object)masterTableName, childrenTableNames);
        AtomicReference<PublishStatusEnum> alterStatus = new AtomicReference<PublishStatusEnum>(PublishStatusEnum.UNCHANGED);
        if (!Objects.equals(draftModelSchema.getName(), publishedModelSchema.getName())) {
            throw new DWBusinessException("published_notsupport_tablename_rename");
        }
        LinkedHashMap<String, LinkedHashMap<String, List<SqlParam>>> alterTableMap = new LinkedHashMap<String, LinkedHashMap<String, List<SqlParam>>>();
        LinkedHashMap alterMap = new LinkedHashMap();
        LinkedList<SqlParam> alterDMLSqlParam = new LinkedList<SqlParam>();
        LinkedList<SqlParam> alterDDLSqlParam = new LinkedList<SqlParam>();
        ModelTable masterDraftSimpleModelTable = ModelSchemaUtil.getCurrentLevelModelTable(draftModelSchema);
        ModelTable masterPublishedSimpleModelTable = ModelSchemaUtil.getCurrentLevelModelTable(publishedModelSchema);
        List<String> publishedRemainPks = ModelSchemaUtil.getPrimaryKeys(masterPublishedSimpleModelTable.getColumns());
        if (!Objects.equals(draftModelSchema.getComment(), publishedModelSchema.getComment())) {
            ModelTable modelTable = new ModelTable();
            modelTable.setName(draftModelSchema.getName());
            modelTable.setComment(draftModelSchema.getComment());
            LinkedHashMap<String, List<SqlParam>> alterComment = ModelTableHelperExpress.getAlterTableInfo(modelTable);
            alterDMLSqlParam.addAll((Collection)alterComment.get("dml"));
            alterDDLSqlParam.addAll((Collection)alterComment.get("ddl"));
            alterStatus.set(PublishStatusEnum.CHANGED);
        }
        Map<AlterIndexEnum, List<TableIndex>> alterIndexesMap = ModelSqlGenerator.getAlterIndexesMap(draftModelSchema, publishedModelSchema);
        Map<AlterColumnEnum, List<TableColumn>> alterColumnsMap = ModelSchemaUtil.getAlterColumnsMap(draftModelSchema, publishedModelSchema, masterDraftSimpleModelTable, masterPublishedSimpleModelTable);
        if (MapUtils.isNotEmpty(alterColumnsMap)) {
            List<TableColumn> dropTableColumns = alterColumnsMap.get((Object)AlterColumnEnum.DROP_COLUMN);
            List<TableColumn> dropPKTableColumns = dropTableColumns.stream().filter(dropTableColumn -> dropTableColumn.isPK()).collect(Collectors.toList());
            if (CollectionUtils.isNotEmpty(dropPKTableColumns)) {
                List<String> dropPks = ModelSchemaUtil.getPrimaryKeys(dropPKTableColumns);
                dropPks.stream().forEach(dropPk -> publishedRemainPks.remove(dropPk));
                alterDDLSqlParam.addAll(ModelSqlGenerator.genDropOrAddPrimaryKey(masterPublishedSimpleModelTable.getName(), publishedRemainPks, true));
            }
            List<ModelIndexDTO> publishedTableIndexes = publishedModelSchema.getIndex();
            for (ModelIndexDTO modelIndexDTO : publishedTableIndexes) {
                if (IndexTypeEnum.getIndexType(modelIndexDTO.getType()) != IndexTypeEnum.UNIQUE_INDEX || !CollectionUtils.isNotEmpty(modelIndexDTO.getMember()) || modelIndexDTO.getMember().size() <= 1) continue;
                log.debug("[ModelPublishService] process {} ({}) ", (Object)IndexTypeEnum.UNIQUE_INDEX.getIndexCommandChar(), (Object)modelIndexDTO.getId());
                ArrayList<String> droppedIndexMember = new ArrayList<String>();
                List<String> modelIndexMember = modelIndexDTO.getMember();
                for (TableColumn dropTableColumn2 : dropTableColumns) {
                    if (!modelIndexMember.contains(dropTableColumn2.getColumnName())) continue;
                    droppedIndexMember.add(dropTableColumn2.getColumnName());
                }
                if (!CollectionUtils.isNotEmpty(droppedIndexMember)) continue;
                modelIndexMember.removeAll(droppedIndexMember);
                SqlParam tempSqlParams = ModelSqlGenerator.genAlterTableUniqueIndex(masterPublishedSimpleModelTable, modelIndexMember, modelIndexDTO);
                alterDDLSqlParam.add(tempSqlParams);
            }
            alterColumnsMap.forEach((alterColumnEnum, tableColumns) -> {
                if (!CollectionUtils.isEmpty((Collection)tableColumns)) {
                    ModelSqlGenerator.updateAlterColumnsInfoOnly(publishedModelSchema.getName(), alterColumnEnum, tableColumns, alterDDLSqlParam, alterDMLSqlParam);
                    alterStatus.set(PublishStatusEnum.CHANGED);
                }
            });
        }
        List<SqlParam> insertOrUpdateRdbmsFieldsParam = ModelSqlGenerator.generateInsertOrUpdateRdbmsFieldSql(masterDraftSimpleModelTable);
        alterDMLSqlParam.addAll(insertOrUpdateRdbmsFieldsParam);
        if (MapUtils.isNotEmpty(alterIndexesMap)) {
            alterIndexesMap.forEach((alterIndexEnum, tableColumns) -> {
                if (!CollectionUtils.isEmpty((Collection)tableColumns)) {
                    ModelSqlGenerator.getAlterIndexesInfo(publishedModelSchema.getName(), alterIndexEnum, tableColumns, alterDDLSqlParam);
                    alterStatus.set(PublishStatusEnum.CHANGED);
                }
            });
        }
        List<String> draftPks = ModelSchemaUtil.getPrimaryKeys(masterDraftSimpleModelTable.getColumns());
        log.debug("[ModelPublishService] draftPks({}), publishedRemainPks({}) ", draftPks, publishedRemainPks);
        if (CollectionUtils.isNotEmpty(publishedRemainPks)) {
            if (!CollectionUtils.isEqualCollection(draftPks, publishedRemainPks)) {
                alterDDLSqlParam.addAll(ModelSqlGenerator.genDropOrAddPrimaryKey(masterPublishedSimpleModelTable.getName(), draftPks, true));
            }
            log.debug("[ModelPublishService] draftPks({}), publishedRemainPks({}) no changed. ", draftPks, publishedRemainPks);
        } else {
            alterDDLSqlParam.addAll(ModelSqlGenerator.genDropOrAddPrimaryKey(masterPublishedSimpleModelTable.getName(), draftPks, false));
        }
        if (alterStatus.get() == PublishStatusEnum.CHANGED) {
            alterDDLSqlParam.addAll(ModelSqlGenerator.getAlterAutoIncrementSql(masterDraftSimpleModelTable));
        }
        List<SqlParam> updateModelSqlParam = ModelSqlGenerator.generateUpdateModelSql(ModelDrivenContext.getContext().getDraftModel());
        alterDMLSqlParam.addAll(updateModelSqlParam);
        if (!CollectionUtils.isEmpty(alterDMLSqlParam) || !CollectionUtils.isEmpty(alterDDLSqlParam)) {
            alterMap.put("dml", alterDMLSqlParam);
            alterMap.put("ddl", alterDDLSqlParam);
            alterTableMap.put(publishedModelSchema.getName(), alterMap);
            alterStatus.set(PublishStatusEnum.CHANGED);
        }
        String tableName = publishedModelSchema.getName();
        Map<String, LinkedHashMap<String, List<SqlParam>>> alterChildrenTableMap = ModelSchemaUtil.getChildrenFullLevelAlterTableCommands(tableName, draftModelSchema.getChildren(), publishedModelSchema.getChildren());
        List<ModelTable> modelAllTables = ModelSchemaUtil.getModelTables(draftModelSchema);
        LinkedList<SqlParam> UpdateModelInfoParams = ModelSqlGenerator.generateUpdateModelInfoSql(modelAllTables, code);
        alterDMLSqlParam.addAll(UpdateModelInfoParams);
        alterTableMap.putAll(alterChildrenTableMap);
        if (MapUtils.isNotEmpty(alterChildrenTableMap)) {
            alterStatus.set(PublishStatusEnum.CHANGED);
        }
        ModelTable draftModelTable = new ModelTable();
        draftModelTable.setName(draftModelSchema.getName());
        draftModelTable.setComment(draftModelSchema.getComment());
        draftModelTable.setCategory(draftModelSchema.getCategory());
        draftModelTable.setSystem(draftModelSchema.getSystem());
        HashMap<String, Object> modelDataMap = new HashMap<String, Object>();
        DWServiceResult serviceResult = this.modelTableHelperExpress.alterTableExpress(masterTableName, alterTableMap, modelDataMap);
        boolean createRunStatus = serviceResult.getSuccess();
        if (log.isDebugEnabled()) {
            log.debug(String.format("create: expected(%b) actual(%b), description:(%s)", alterStatus, createRunStatus, serviceResult.getMessage()));
        }
        if (createRunStatus) {
            alterStatus.set(PublishStatusEnum.SUCCESS);
        } else {
            alterStatus.set(PublishStatusEnum.FAILURE);
        }
        ModelPublishedEspResult publishedEspResult = new ModelPublishedEspResult();
        publishedEspResult.setPublishStatusEnum(alterStatus.get());
        publishedEspResult.setServiceResult(serviceResult);
        return publishedEspResult;
    }

    @Deprecated
    private Map<AlterColumnEnum, List<TableColumn>> getAlterColumnsMap(ModelSchemaDTO draftModelSchema, ModelSchemaDTO publishedModelSchema, ModelTable masterDraftSimpleModelTable, ModelTable masterPublishedSimpleModelTable) throws JSQLParserException, DWBusinessException {
        if (draftModelSchema == null || CollectionUtils.isEmpty(draftModelSchema.getFields()) || publishedModelSchema == null || CollectionUtils.isEmpty(publishedModelSchema.getFields())) {
            return null;
        }
        List<ModelFieldDTO> draftModelFields = draftModelSchema.getFields();
        List<ModelFieldDTO> publishedModelFields = publishedModelSchema.getFields();
        log.debug("publishing model (comparing fields) -> draftModelSchema = {}, publishedModelSchema = {}", (Object)draftModelSchema, (Object)publishedModelSchema);
        List<TableColumn> addColumns = draftModelFields.stream().filter(draftModelField -> ModelSchemaUtil.checkRelatedType(draftModelField) && publishedModelFields.stream().noneMatch(publishedModelField -> Objects.equals(draftModelField.getFieldId(), publishedModelField.getFieldId()))).map(ModelSchemaUtil::convertToTableColumn).collect(Collectors.toList());
        List<TableColumn> modifyColumns = draftModelFields.stream().filter(draftModelField -> publishedModelFields.stream().anyMatch(publishedModelField -> Objects.equals(draftModelField.getFieldId(), publishedModelField.getFieldId()) && !Objects.equals(draftModelField, publishedModelField) && this.checkRelatedType((ModelFieldDTO)draftModelField))).map(ModelSchemaUtil::convertToTableColumn).collect(Collectors.toList());
        List dropColumns = publishedModelFields.stream().filter(publishedModelField -> this.checkRelatedType((ModelFieldDTO)publishedModelField) && draftModelFields.stream().noneMatch(draftModelField -> Objects.equals(publishedModelField.getFieldId(), draftModelField.getFieldId()))).map(ModelSchemaUtil::convertToTableColumn).collect(Collectors.toList());
        ModelSchemaUtil.changeColumnActionType(masterPublishedSimpleModelTable, addColumns, modifyColumns);
        HashMap<AlterColumnEnum, List<TableColumn>> alterTableColumnsMap = new HashMap<AlterColumnEnum, List<TableColumn>>();
        alterTableColumnsMap.put(AlterColumnEnum.ADD_COLUMN, addColumns);
        alterTableColumnsMap.put(AlterColumnEnum.MODIFY_COLUMN, modifyColumns);
        alterTableColumnsMap.put(AlterColumnEnum.DROP_COLUMN, dropColumns);
        return alterTableColumnsMap;
    }

    @Transactional(propagation=Propagation.REQUIRED, rollbackFor={Exception.class})
    public DWSQLExecutionResult deletePublished(ModelDTO model, DWDataRow publishedDataRow, Map<String, Object> modelDesignDataMap) throws Exception {
        Assert.hasText((String)model.getCode(), (String)"model code must not be null or empty");
        Assert.hasText((String)model.getAppId(), (String)"model appid must not be null or empty");
        String code = model.getCode();
        DWSQLExecutionResult returnResult = new DWSQLExecutionResult();
        if (publishedDataRow != null && MapUtils.isNotEmpty((Map)publishedDataRow.getData())) {
            ModelSchemaDTO modelSchema = ModelSchemaUtil.parseModelSchema(publishedDataRow);
            AtomicReference<PublishStatusEnum> dropStatus = new AtomicReference<PublishStatusEnum>(PublishStatusEnum.UNCHANGED);
            DWDataSet modelDataSet = new DWDataSetBuilder().addTable("dw_lcdp_model").addRowOrgDatas(Collections.singletonList(publishedDataRow.getData()), "D").createDataSet();
            HashMap<String, Object> modelDataMap = new HashMap<String, Object>();
            HashMap<String, Object> dmlModelDataSet = new HashMap<String, Object>();
            dmlModelDataSet.put("value", modelDataSet);
            dmlModelDataSet.put("model_action", "D");
            modelDataMap.put("dw_lcdp_model", dmlModelDataSet);
            modelDataMap.putAll(modelDesignDataMap);
            List<ModelTable> modelTables = ModelSchemaUtil.getModelTables(modelSchema);
            boolean dropRunStatus = this.modelTableHelperExpress.dropTableExpress(modelTables, modelDataMap, model);
            if (dropRunStatus) {
                dropStatus.set(PublishStatusEnum.SUCCESS);
            }
            if (log.isDebugEnabled()) {
                log.debug("code({}) drop status: expected({}) actual({})", new Object[]{code, dropStatus, dropRunStatus});
            }
            Map deleteResult = (Map)this.modelPublishService.deleteModelAndDraft(model);
            for (Map.Entry row : deleteResult.entrySet()) {
                returnResult.addDeleteCount((String)row.getKey(), ((Integer)row.getValue()).intValue());
            }
            List<String> dirtyTableNames = modelTables.stream().map(modelTable -> modelTable.getName()).collect(Collectors.toList());
            ModelDrivenMetadataUtil.removeRdbmsMetadata(code, dirtyTableNames);
        }
        return returnResult;
    }

    private void preProcessChildrenSchema(ModelDTO model) {
        ModelSchemaDTO modelSchema = model.getSchema();
        List<ModelSchemaDTO> childrenFormSchema = modelSchema.getChildren();
        boolean isExistedChildren = true;
        if (CollectionUtils.isEmpty(childrenFormSchema)) {
            isExistedChildren = false;
        } else if (!CollectionUtils.isEmpty(childrenFormSchema) && StringUtils.isEmpty((CharSequence)childrenFormSchema.get(0).getName())) {
            isExistedChildren = false;
        }
        if (!isExistedChildren) {
            modelSchema.setChildren(null);
        }
    }

    public boolean checkRelatedType(ModelFieldDTO modelField) {
        return !ModelFieldRelationTypeEnum.valueOf(modelField.getType()).equals((Object)ModelFieldRelationTypeEnum.COLLECTION);
    }

    @Deprecated
    public List<String> getNotModelingColumns(ModelTable masterDraftSimpleModelTable, ModelTable masterPublishedSimpleModelTable) throws JSQLParserException, DWBusinessException {
        String masterTableName = masterDraftSimpleModelTable.getName();
        CreateTable ccjCreateTable = this.modelTableHelperExpress.getCCJCreateTable(masterTableName);
        if (ccjCreateTable == null) {
            throw new DWBusinessException(String.format("[ModelPublishService][alterTableExpress] db table %s is not existed", new Object[0]), masterTableName);
        }
        List<String> existedTableColumnNames = ModelSchemaUtil.getExistedTableColumnNames(ccjCreateTable);
        List modelExistedColumnNames = masterPublishedSimpleModelTable.getColumns().stream().map(tableColumn -> tableColumn.getColumnName()).collect(Collectors.toList());
        List<String> notModelingColumns = existedTableColumnNames.stream().filter(existedColumnName -> modelExistedColumnNames.stream().noneMatch(publishedModelExistedName -> Objects.equals(existedColumnName, publishedModelExistedName))).collect(Collectors.toList());
        return notModelingColumns;
    }
}

