/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.lcdp.modeldriven.utils;

import com.digiwin.app.service.eai.DWEAIHeader;
import com.digiwin.app.service.eai.DWEAIHeaderRepository;
import com.digiwin.app.service.eai.DWEAIServiceDefinitionParser;
import com.digiwin.lcdp.modeldriven.model.ModelDrivenEaiMethodRepository;
import com.digiwin.lcdp.modeldriven.pojo.DWServiceMapping;
import com.digiwin.lcdp.modeldriven.pojo.MappingModelInfo;
import com.digiwin.lcdp.modeldriven.pojo.ModelDrivenEaiMethodDTO;
import com.digiwin.lcdp.modeldriven.utils.EaiServiceNameUtil;
import com.digiwin.lcdp.modeldriven.utils.ModelDrivenMethodHelper;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Component;

@Component
public class EaiHeaderUtil {
    private static final Logger log = LoggerFactory.getLogger(EaiHeaderUtil.class);
    @Autowired
    DWEAIHeaderRepository dwEAIHeaderRepository;
    @Autowired
    DWEAIServiceDefinitionParser dwEaiServiceDefinitionParser;
    @Autowired
    @Qualifier(value="dw-modeldriven-eai-repo")
    ModelDrivenEaiMethodRepository mdEaiMethodRepo;

    public List<DWEAIHeader> updateAndGetModelDrivenEaiHeaders(List<DWServiceMapping> serviceMappings, List<MappingModelInfo> mappingModelInfos) throws Exception {
        ArrayList<DWEAIHeader> newEaiHeaders = new ArrayList<DWEAIHeader>();
        Method setMappingMethod = ModelDrivenMethodHelper.getSetMappingMethodAccessibleOfDWEAIHeader();
        Map<String, ModelDrivenEaiMethodDTO> mdEaiMethods = this.mdEaiMethodRepo.getEaiMethodRepo();
        Optional<Class<?>> eaiClazz = this.mdEaiMethodRepo.getEaiClazz();
        for (DWServiceMapping eaiService : serviceMappings) {
            log.info("[EaiServiceUtil] enter md master eai service");
            String eaiTableName = eaiService.getTableName();
            String userExposePrefixEaiId = eaiService.getExposeEaiId();
            String eaiProd = EaiServiceNameUtil.getEaiProd(eaiTableName, userExposePrefixEaiId);
            log.debug("serviceMapping: prod({}) eaiService({}) process table_name({}) expose_ea_id({}})", new Object[]{eaiProd, eaiService.toString(), eaiTableName, userExposePrefixEaiId});
            for (Map.Entry<String, ModelDrivenEaiMethodDTO> mdEaiMethod : mdEaiMethods.entrySet()) {
                ModelDrivenEaiMethodDTO mdEaiMethodDTO = mdEaiMethod.getValue();
                String eaiServiceIdForServiceMapping = String.join((CharSequence)".", userExposePrefixEaiId, mdEaiMethodDTO.getEaiServicePostfix());
                DWEAIHeader headerV = new DWEAIHeader("commons", eaiServiceIdForServiceMapping, eaiClazz.get());
                setMappingMethod.invoke((Object)headerV, mdEaiMethodDTO.getMethod(), false);
                newEaiHeaders.add(headerV);
                log.debug("serviceMapping: add headerV expose_eai_id({})", (Object)headerV.getEAIServiceId());
            }
        }
        Method listGetMethod = this.mdEaiMethodRepo.getListGetMethod();
        if (mappingModelInfos.size() > 0 && listGetMethod != null) {
            log.info("[EaiServiceUtil] enter children .list.get");
            ArrayList<DWEAIHeader> childTableListGetHeaders = new ArrayList<DWEAIHeader>();
            int modelinfoCount = 1;
            for (MappingModelInfo mappingModelInfo : mappingModelInfos) {
                String childTableName = mappingModelInfo.getChildtbl();
                String eaiTableName = mappingModelInfo.getTablename();
                String userExposePrefixEaiId = mappingModelInfo.getEaiid();
                String eaiProd = EaiServiceNameUtil.getEaiProd(eaiTableName, userExposePrefixEaiId);
                if (log.isDebugEnabled()) {
                    log.debug("[{}] serviceMapping-child: prod({}), child table({}), tableName({}), code({})", new Object[]{modelinfoCount++, eaiProd, childTableName, eaiTableName, mappingModelInfo.getCode()});
                }
                if (!StringUtils.equals((CharSequence)childTableName, (CharSequence)eaiTableName)) {
                    String childEaiServiceIdForServiceMapping = EaiServiceNameUtil.getChildListGetEaiServiceId(eaiProd, childTableName);
                    DWEAIHeader headerV = new DWEAIHeader("commons", childEaiServiceIdForServiceMapping, eaiClazz.get());
                    setMappingMethod.invoke((Object)headerV, listGetMethod, false);
                    childTableListGetHeaders.add(headerV);
                    if (!log.isDebugEnabled()) continue;
                    log.debug("     --->> add eai service id:({}) by code [{}] ", (Object)headerV.getEAIServiceId(), (Object)mappingModelInfo.getCode());
                    continue;
                }
                log.debug("     --->> ignored add eai service id: cause childTableName({}) equals eaiTableName ({})", (Object)childTableName, (Object)eaiTableName);
            }
            newEaiHeaders.addAll(childTableListGetHeaders);
            log.info("serviceMapping: children table .list.get count:{}", (Object)childTableListGetHeaders.size());
        } else {
            log.warn("serviceMapping: ignored to generate children .list.get service(serviceMapping size({}), listGetMethod({})", (Object)serviceMappings.size(), (Object)listGetMethod);
        }
        if (CollectionUtils.isNotEmpty(newEaiHeaders)) {
            List orgDWHeaders = this.dwEAIHeaderRepository.getHeaders("commons");
            int mdHeaderCount = newEaiHeaders.size();
            int orgHeaderCount = orgDWHeaders.size();
            newEaiHeaders.stream().forEach(tempHeader -> orgDWHeaders.add(tempHeader));
            Method registerHeaderMethod = ModelDrivenMethodHelper.getRegisterHeaderAccessibleOfDWEAIServiceDefinitionParser();
            registerHeaderMethod.invoke((Object)this.dwEaiServiceDefinitionParser, "commons", orgDWHeaders);
            log.info("[{}] refresh DWEAIHeaderRepository size(total({})=org({})+modeldriven({}))", new Object[]{"dw-modeldriven-service-commons-mapping-provider", orgDWHeaders.size(), orgHeaderCount, mdHeaderCount});
        } else {
            log.info("[{}] ignored refresh DWEAIHeaderRepository ", (Object)"dw-modeldriven-service-commons-mapping-provider");
        }
        return newEaiHeaders;
    }
}

