/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.lcdp.modeldriven.utils;

import com.digiwin.app.eai.DWEAIProperties;
import com.digiwin.app.service.eai.DWEAIHeader;
import com.digiwin.gateway.controller.EaiInfoUtils;
import com.digiwin.http.client.DWHttpClient;
import com.digiwin.http.client.DWRequestOption;
import com.digiwin.http.client.entity.DWJsonEntity;
import com.digiwin.lcdp.modeldriven.event.EaiRegDataInfo;
import com.digiwin.lcdp.modeldriven.event.EaiRegisterEventProperties;
import com.digiwin.lcdp.modeldriven.event.EaiRegisterEventPublisher;
import com.digiwin.lcdp.modeldriven.event.EaiServiceRegisterEvent;
import com.digiwin.lcdp.modeldriven.model.ModelSchemaDTO;
import com.digiwin.lcdp.modeldriven.pojo.DWServiceMapping;
import com.digiwin.lcdp.modeldriven.pojo.MappingModelInfo;
import com.digiwin.lcdp.modeldriven.utils.EaiHeaderUtil;
import com.digiwin.lcdp.modeldriven.utils.EaiServiceNameUtil;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Component;

@Component
public class EaiRegisterUtil {
    private static final Logger log = LoggerFactory.getLogger(EaiRegisterUtil.class);
    @Autowired
    DWEAIProperties eaiProperties;
    @Autowired
    EaiHeaderUtil eaiHeaderUtil;
    @Autowired(required=false)
    @Qualifier(value="lcdp-eai-reg-event-properties")
    EaiRegisterEventProperties eaiRegisterEventProperties;
    @Autowired(required=false)
    @Qualifier(value="lcdp-eai-reg-event-publisher")
    EaiRegisterEventPublisher eaiRegisterEventPublisher;
    @Autowired
    private DWHttpClient dwHttpClient;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Object autoRegisterEAI(List<DWEAIHeader> newEaiHeaders, String code) throws Exception {
        Map resultValue = new HashMap();
        if (this.eaiRegisterEventPublisher != null && this.eaiRegisterEventProperties != null && this.eaiRegisterEventProperties.isAsync()) {
            log.debug("[autoRegisterEAI] using ASync... code({}) eaiRegisterEventPublisher ({}), eaiRegisterEventProperties({})", new Object[]{code, this.eaiRegisterEventPublisher, this.eaiRegisterEventProperties});
            EaiRegDataInfo eaiRegDataInfo = new EaiRegDataInfo();
            eaiRegDataInfo.setEaiHeaders(newEaiHeaders);
            eaiRegDataInfo.setModelCodeName(code);
            eaiRegDataInfo.setEaiProperties(this.eaiProperties);
            EaiServiceRegisterEvent dataEvent = new EaiServiceRegisterEvent(eaiRegDataInfo);
            log.debug("[autoRegisterEAI] starting call eaiRegisterEventPublisher in code({})", (Object)code);
            this.eaiRegisterEventPublisher.publishDataChangeEvent(dataEvent);
            log.debug("[autoRegisterEAI] finished call eaiRegisterEventPublisher in code({})", (Object)code);
            return resultValue;
        }
        log.debug("using Sync... code({}) eaiRegisterEventPublisher({}), eaiRegisterEventProperties({})", new Object[]{code, this.eaiRegisterEventPublisher, this.eaiRegisterEventProperties});
        List newEaiServiceIds = newEaiHeaders.stream().map(DWEAIHeader::getEAIServiceId).collect(Collectors.toList());
        log.info("EAI Services start auto-registering code({}), newEaiServiceIds({})...", (Object)code, newEaiServiceIds);
        resultValue = EaiInfoUtils.getSrvRegInfo(() -> newEaiServiceIds, (DWEAIProperties)this.eaiProperties);
        HttpPost post = new HttpPost(EaiInfoUtils.getEAIRegSrvURL());
        post.setEntity((HttpEntity)new DWJsonEntity(resultValue));
        EntityUtils.toString((HttpEntity)post.getEntity(), (Charset)StandardCharsets.UTF_8);
        post.addHeader("digi-action", "reg");
        CloseableHttpResponse responseReturn = null;
        try {
            block18: {
                CloseableHttpResponse response;
                block19: {
                    response = (CloseableHttpResponse)this.dwHttpClient.execute((HttpUriRequest)post, new DWRequestOption(false));
                    Throwable throwable = null;
                    try {
                        int statusCode;
                        InputStream responseStream;
                        responseReturn = response;
                        String responseBody = "";
                        HttpEntity httpEntity = response.getEntity();
                        if (httpEntity != null && (responseStream = httpEntity.getContent()) != null) {
                            responseBody = IOUtils.toString((InputStream)responseStream, (Charset)StandardCharsets.UTF_8);
                        }
                        if ((statusCode = response.getStatusLine().getStatusCode()) != 200) {
                            log.error("Something wrong in the process of eai services auto-registration...");
                            log.error(responseBody);
                        } else {
                            log.info("EAI Services have registered automatically.");
                        }
                        if (response == null) break block18;
                        if (throwable == null) break block19;
                    }
                    catch (Throwable throwable3) {
                        try {
                            throwable = throwable3;
                            throw throwable3;
                        }
                        catch (Throwable throwable4) {
                            if (response == null) throw throwable4;
                            if (throwable == null) {
                                response.close();
                                throw throwable4;
                            }
                            try {
                                response.close();
                                throw throwable4;
                            }
                            catch (Throwable throwable5) {
                                throwable.addSuppressed(throwable5);
                                throw throwable4;
                            }
                        }
                    }
                    try {
                        response.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                response.close();
            }
        }
        catch (Exception e) {
            log.error("eai auto register failed!", (Throwable)e);
        }
        finally {
            log.info("EAI Services finished auto-registering...");
            return responseReturn;
        }
    }

    public List<DWEAIHeader> refreshEaiService(String masterTableName, List<ModelSchemaDTO> allChildrenSchemas, String modelDrivenProdPrefix, String code) throws Exception {
        String userExposePrefixEaiId = EaiServiceNameUtil.getEaiPrefixName(modelDrivenProdPrefix, masterTableName);
        DWServiceMapping serviceMapping = new DWServiceMapping();
        serviceMapping.setTableName(masterTableName);
        serviceMapping.setExposeEaiId(userExposePrefixEaiId);
        ArrayList<DWServiceMapping> serviceMappings = new ArrayList<DWServiceMapping>();
        serviceMappings.add(serviceMapping);
        ArrayList<MappingModelInfo> mappingModelInfos = new ArrayList<MappingModelInfo>();
        if (CollectionUtils.isNotEmpty(allChildrenSchemas)) {
            for (ModelSchemaDTO childModelSchema : allChildrenSchemas) {
                String childTableName = childModelSchema.getName();
                if (StringUtils.equals((CharSequence)childTableName, (CharSequence)masterTableName)) continue;
                MappingModelInfo childMappingModelInfo = new MappingModelInfo();
                childMappingModelInfo.setTablename(masterTableName);
                childMappingModelInfo.setChildtbl(childTableName);
                childMappingModelInfo.setEaiid(userExposePrefixEaiId);
                childMappingModelInfo.setCode(code);
                mappingModelInfos.add(childMappingModelInfo);
            }
        }
        List<DWEAIHeader> newHeaders = this.eaiHeaderUtil.updateAndGetModelDrivenEaiHeaders(serviceMappings, mappingModelInfos);
        return newHeaders;
    }

    public static String getEaiServicePrefixOfProd(String prod) {
        String returnValue = prod.toLowerCase().replaceAll("-", "\\.");
        returnValue = returnValue.replaceAll("_", "\\.");
        return returnValue;
    }
}

