/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.lcdp.modeldriven.utils;

import com.digiwin.app.container.exceptions.DWBusinessException;
import com.digiwin.app.data.DWDataRow;
import com.digiwin.app.ddl.enums.DataTypeEnum;
import com.digiwin.app.ddl.model.Field;
import com.digiwin.app.json.gson.DWGsonProvider;
import com.digiwin.app.resource.DWApplicationMessageResourceBundleUtils;
import com.digiwin.lcdp.modeldriven.enums.AlterColumnEnum;
import com.digiwin.lcdp.modeldriven.enums.AlterIndexEnum;
import com.digiwin.lcdp.modeldriven.enums.IndexTypeEnum;
import com.digiwin.lcdp.modeldriven.enums.ModelFieldRelationTypeEnum;
import com.digiwin.lcdp.modeldriven.enums.PublishStatusEnum;
import com.digiwin.lcdp.modeldriven.model.ModelDTO;
import com.digiwin.lcdp.modeldriven.model.ModelFieldDTO;
import com.digiwin.lcdp.modeldriven.model.ModelIndexDTO;
import com.digiwin.lcdp.modeldriven.model.ModelSchemaDTO;
import com.digiwin.lcdp.modeldriven.model.ModelTable;
import com.digiwin.lcdp.modeldriven.model.SqlParam;
import com.digiwin.lcdp.modeldriven.model.TableColumn;
import com.digiwin.lcdp.modeldriven.model.TableIndex;
import com.digiwin.lcdp.modeldriven.utils.DBTableUtil;
import com.digiwin.lcdp.modeldriven.utils.ModelDataUtil;
import com.digiwin.lcdp.modeldriven.utils.ModelDrivenCCJParserUtil;
import com.digiwin.lcdp.modeldriven.utils.ModelSqlGenerator;
import com.digiwin.lcdp.modeldriven.utils.ModelTableHelperExpress;
import com.google.gson.Gson;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;
import java.util.stream.Collectors;
import net.sf.jsqlparser.JSQLParserException;
import net.sf.jsqlparser.statement.create.table.ColumnDefinition;
import net.sf.jsqlparser.statement.create.table.CreateTable;
import net.sf.jsqlparser.statement.create.table.Index;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class ModelSchemaUtil {
    private static final Logger log = LoggerFactory.getLogger(ModelSchemaUtil.class);
    private static ModelTableHelperExpress modelTableHelperExpress;
    private static final int maxLevel = 3;

    public static List<String> getChildrenName(List<ModelSchemaDTO> childrenSchemas) {
        ArrayList<String> childrenModelSchemaNames = new ArrayList<String>();
        if (!CollectionUtils.isEmpty(childrenSchemas)) {
            for (ModelSchemaDTO tempModelSchema : childrenSchemas) {
                List<ModelSchemaDTO> tempChildrenSchema = tempModelSchema.getChildren();
                List tempChildrenNames = tempChildrenSchema.stream().map(modelSchemaDTO -> modelSchemaDTO.getName()).collect(Collectors.toList());
                childrenModelSchemaNames.addAll(tempChildrenNames);
            }
        }
        return childrenModelSchemaNames;
    }

    public static Map<String, ModelSchemaDTO> getChildrenModelSchemaMap(List<ModelSchemaDTO> childrenSchemas) {
        HashMap<String, ModelSchemaDTO> returnValue = new HashMap<String, ModelSchemaDTO>();
        if (!CollectionUtils.isEmpty(childrenSchemas)) {
            for (ModelSchemaDTO tempModelSchema : childrenSchemas) {
                List<ModelSchemaDTO> childrenSchema = tempModelSchema.getChildren();
                Map tempChildrenSchemeMap = childrenSchema.stream().collect(Collectors.toMap(ModelSchemaDTO::getName, Function.identity()));
                returnValue.putAll(tempChildrenSchemeMap);
            }
        }
        return returnValue;
    }

    public static List<ModelSchemaDTO> getChildrenModelSchema(List<ModelSchemaDTO> childrenSchemas) {
        if (CollectionUtils.isEmpty(childrenSchemas)) {
            return new ArrayList<ModelSchemaDTO>();
        }
        return ModelSchemaUtil.getChildrenModelSchema(childrenSchemas, 1);
    }

    protected static List<ModelSchemaDTO> getChildrenModelSchema(List<ModelSchemaDTO> childrenSchemas, int level) {
        ArrayList<ModelSchemaDTO> childrenModelSchema = new ArrayList<ModelSchemaDTO>();
        List<Object> childrenModelSchemaNames = new ArrayList();
        if (level <= 3 && !CollectionUtils.isEmpty(childrenSchemas)) {
            childrenModelSchemaNames = childrenSchemas.stream().map(modelSchemaDTO -> modelSchemaDTO.getName()).collect(Collectors.toList());
            log.debug("process children at level {} , current childrenModelSchema {}", (Object)level, childrenModelSchemaNames);
            childrenModelSchema.addAll(childrenSchemas);
            for (ModelSchemaDTO childModelSchema : childrenSchemas) {
                List<ModelSchemaDTO> modelSchemaDTOList = ModelSchemaUtil.getChildrenModelSchema(childModelSchema.getChildren(), level + 1);
                childrenModelSchema.addAll(modelSchemaDTOList);
            }
        } else {
            log.debug("end: level {} over maxlevel or empty children({})", (Object)level, (Object)childrenSchemas.size());
        }
        return childrenModelSchema;
    }

    public static List<ModelTable> getModelTables(ModelSchemaDTO modelSchema, boolean includeCollection) {
        if (BooleanUtils.isTrue((Boolean)includeCollection)) {
            return ModelSchemaUtil.getModelTables(modelSchema);
        }
        Map<String, ModelSchemaDTO> modelSchemaMap = ModelSchemaUtil.getModelSchemaMap(modelSchema);
        ArrayList<ModelTable> modelTables = new ArrayList<ModelTable>();
        for (ModelSchemaDTO tempModelSchema : modelSchemaMap.values()) {
            ModelTable tempModelTable = ModelSchemaUtil.getCurrentLevelModelTable(tempModelSchema, includeCollection);
            modelTables.add(tempModelTable);
        }
        return modelTables;
    }

    public static ModelTable getCurrentLevelModelTable(ModelSchemaDTO modelSchema, boolean includeCollection) {
        if (modelSchema == null) {
            return null;
        }
        ModelTable modelTable = ModelSchemaUtil.convertToSimpleModelTable(modelSchema, includeCollection);
        List<ModelIndexDTO> modelIndexes = modelSchema.getIndex();
        if (modelIndexes != null && !CollectionUtils.isEmpty(modelIndexes)) {
            List<TableIndex> tableIndexes = modelIndexes.stream().map(ModelSchemaUtil::convertModelIndexToTable).collect(Collectors.toList());
            modelTable.setIndexes(tableIndexes);
        }
        return modelTable;
    }

    public static List<ModelTable> getModelTables(ModelSchemaDTO modelSchema) {
        List<ModelSchemaDTO> childrenModelSchema;
        ArrayList<ModelSchemaDTO> modelSchemas = new ArrayList<ModelSchemaDTO>();
        modelSchemas.add(modelSchema);
        ArrayList<ModelTable> modelTables = new ArrayList<ModelTable>();
        List<ModelSchemaDTO> childrenSchemas = modelSchema.getChildren();
        if (!CollectionUtils.isEmpty(childrenSchemas) && !CollectionUtils.isEmpty(childrenModelSchema = ModelSchemaUtil.getChildrenModelSchema(childrenSchemas))) {
            modelSchemas.addAll(childrenModelSchema);
        }
        for (ModelSchemaDTO tempModelSchema : modelSchemas) {
            ModelTable tempModelTable = ModelSchemaUtil.getCurrentLevelModelTable(tempModelSchema);
            modelTables.add(tempModelTable);
        }
        return modelTables;
    }

    public static ModelTable getCurrentLevelModelTable(ModelSchemaDTO modelSchema) {
        if (modelSchema == null) {
            return null;
        }
        ModelTable modelTable = ModelSchemaUtil.convertToSimpleModelTable(modelSchema, false);
        List<ModelIndexDTO> modelIndexes = modelSchema.getIndex();
        if (modelIndexes != null && !CollectionUtils.isEmpty(modelIndexes)) {
            List<TableIndex> tableIndexes = modelIndexes.stream().map(ModelSchemaUtil::convertModelIndexToTable).collect(Collectors.toList());
            modelTable.setIndexes(tableIndexes);
        }
        return modelTable;
    }

    public static TableIndex convertModelIndexToTable(ModelIndexDTO modelIndex) {
        if (modelIndex == null) {
            return null;
        }
        TableIndex tableIndex = new TableIndex();
        tableIndex.setName(modelIndex.getId());
        tableIndex.setMember(modelIndex.getMember());
        if (modelIndex.getType() != null) {
            tableIndex.setType(IndexTypeEnum.getIndexType(modelIndex.getType()));
        }
        return tableIndex;
    }

    public static TableIndex convertModelFieldToTableUniqueIndex(ModelFieldDTO modelField) {
        if (modelField == null) {
            return null;
        }
        ArrayList<String> members = new ArrayList<String>();
        members.add(modelField.getFieldId());
        TableIndex tableIndex = new TableIndex();
        tableIndex.setName(modelField.getFieldId());
        tableIndex.setMember(members);
        tableIndex.setType(IndexTypeEnum.UNIQUE_INDEX);
        return tableIndex;
    }

    public static TableIndex convertTableColumnToTableUniqueIndex(TableColumn tableColumn) {
        if (tableColumn == null) {
            return null;
        }
        String columnName = tableColumn.getColumnName();
        ArrayList<String> members = new ArrayList<String>();
        members.add(columnName);
        TableIndex tableIndex = new TableIndex();
        tableIndex.setName(columnName);
        tableIndex.setMember(members);
        tableIndex.setType(IndexTypeEnum.UNIQUE_INDEX);
        log.debug("[ModelSchemaUtil] found column unique index({})", (Object)columnName);
        return tableIndex;
    }

    public static TableColumn convertToTableColumn(ColumnDefinition columnDefinition, List<Index> indexes) {
        if (columnDefinition == null) {
            return null;
        }
        TableColumn tableColumn = new TableColumn();
        String ccjColumnName = columnDefinition.getColumnName();
        tableColumn.setColumnName(DBTableUtil.removeBackQuoteSymbol(ccjColumnName));
        tableColumn.setComment(ModelDrivenCCJParserUtil.getComment(columnDefinition));
        tableColumn.setDataType(DataTypeEnum.valueOf((String)columnDefinition.getColDataType().getDataType().toUpperCase()));
        if (columnDefinition.getColumnSpecs().contains("AUTO_INCREMENT")) {
            tableColumn.setAutoIncrement(true);
            tableColumn.setSize(Integer.valueOf((String)columnDefinition.getColDataType().getArgumentsStringList().get(0)));
        }
        indexes.stream().forEach(idx -> {
            String ccjIndexName = idx.getName();
            String ccjIndexType = idx.getType();
            if (StringUtils.isEmpty((CharSequence)ccjIndexName) && ccjIndexType.equals("PRIMARY KEY") && idx.getColumnsNames().contains(ccjColumnName)) {
                tableColumn.setPK(true);
            }
            if (ModelSchemaUtil.checkColumnUniqueIndex(idx, ccjColumnName)) {
                tableColumn.setUnique(true);
            }
        });
        return tableColumn;
    }

    public static boolean checkColumnUniqueIndex(Index index, String columnName) {
        String ccjIndexName = index.getName();
        String ccjIndexType = index.getType();
        if (StringUtils.isEmpty((CharSequence)ccjIndexName) || !ccjIndexType.equals("UNIQUE KEY")) {
            return false;
        }
        boolean isColumnIndex = ccjIndexName.equals(columnName);
        return isColumnIndex;
    }

    public static TableIndex convertToTableIndex(Index ccjIndex) {
        if (ccjIndex == null || ccjIndex.getType().equals("PRIMARY KEY")) {
            return null;
        }
        TableIndex tableIndex = new TableIndex();
        tableIndex.setName(DBTableUtil.removeBackQuoteSymbol(ccjIndex.getName()));
        tableIndex.setMember(ccjIndex.getColumnsNames());
        if (ccjIndex.getType().equals("UNIQUE KEY")) {
            tableIndex.setType(IndexTypeEnum.UNIQUE_INDEX);
        } else if (ccjIndex.getType().equals("KEY")) {
            tableIndex.setType(IndexTypeEnum.INDEX);
        }
        return tableIndex;
    }

    public static TableIndex convertModelIndexToTableIndex(ModelIndexDTO modelIndex) {
        TableIndex tableIndex = ModelSchemaUtil.convertModelIndexToTable(modelIndex);
        return tableIndex;
    }

    public static TableColumn convertModelFieldToTableColumn(ModelFieldDTO modelField) {
        if (modelField == null) {
            return null;
        }
        ModelFieldRelationTypeEnum relationTypeEnum = ModelFieldRelationTypeEnum.valueOf(modelField.getType());
        switch (relationTypeEnum) {
            case COLLECTION: {
                log.debug("should ignore: modelField '{}' is {}", (Object)modelField.getFieldId(), (Object)relationTypeEnum.getValue());
            }
        }
        TableColumn tableColumn = ModelSchemaUtil.getTableColumns(modelField);
        return tableColumn;
    }

    public static TableColumn convertToTableColumn(ModelFieldDTO modelField) {
        return ModelSchemaUtil.getTableColumns(modelField);
    }

    public static TableColumn getTableColumns(ModelFieldDTO modelField) {
        TableColumn tableColumn = new TableColumn();
        tableColumn.setColumnName(modelField.getFieldId());
        tableColumn.setComment(modelField.getFieldName());
        tableColumn.setDataType(DataTypeEnum.valueOf((String)modelField.getFieldType()));
        tableColumn.setNullable(Optional.ofNullable(modelField.getNotNull()).orElse(true) == false);
        tableColumn.setDefaultValue(modelField.getDefaultValue());
        tableColumn.setAutoIncrement(modelField.getAutoIncrement());
        tableColumn.setPK(modelField.isPk());
        if (!StringUtils.isEmpty((CharSequence)modelField.getSize())) {
            tableColumn.setSize(new Integer(modelField.getSize()));
        }
        if (!StringUtils.isEmpty((CharSequence)modelField.getScale())) {
            tableColumn.setScale(new Integer(modelField.getScale()));
        }
        tableColumn.setUnique(modelField.getUnique());
        tableColumn.setRelationTypeEnum(ModelFieldRelationTypeEnum.valueOf(modelField.getType()));
        return tableColumn;
    }

    public static List<String> getTableNames(ModelSchemaDTO modelSchemaDTO) {
        ArrayList<String> tableNames = new ArrayList<String>();
        tableNames.add(modelSchemaDTO.getName());
        List<ModelSchemaDTO> childrenSchemas = modelSchemaDTO.getChildren();
        if (CollectionUtils.isNotEmpty(childrenSchemas)) {
            List<ModelSchemaDTO> childrenModelSchema = ModelSchemaUtil.getChildrenModelSchema(childrenSchemas);
            childrenModelSchema.stream().forEach(cModelSchema -> tableNames.add(cModelSchema.getName()));
        }
        return tableNames;
    }

    public static Map<String, LinkedHashMap<String, List<SqlParam>>> getChildrenFullLevelAlterTableCommands(String tableName, List<ModelSchemaDTO> draftChildrenSchema, List<ModelSchemaDTO> publishedChildrenSchema) throws Exception {
        Map<String, LinkedHashMap<String, List<SqlParam>>> returnValue = ModelSchemaUtil.getRecursiveAlterChildTableCommand(tableName, draftChildrenSchema, publishedChildrenSchema, 1);
        return returnValue;
    }

    public static Map<String, LinkedHashMap<String, List<SqlParam>>> getRecursiveAlterChildTableCommand(String tableName, List<ModelSchemaDTO> draftChildrenSchema, List<ModelSchemaDTO> publishedChildrenSchema, int level) throws Exception {
        HashMap<String, LinkedHashMap<String, List<SqlParam>>> returnValue = new HashMap<String, LinkedHashMap<String, List<SqlParam>>>();
        log.debug("process level({}), draftChildren size({})", (Object)level, (Object)draftChildrenSchema.size());
        if (level <= 3) {
            log.debug("process childModelSchema({})", (Object)tableName);
            Map<String, LinkedHashMap<String, List<SqlParam>>> childrenAlterData = ModelSchemaUtil.compareAndGetChildrenAlterData(draftChildrenSchema, publishedChildrenSchema);
            returnValue.putAll(childrenAlterData);
            for (ModelSchemaDTO subDraftChildSchema : draftChildrenSchema) {
                Map<String, LinkedHashMap<String, List<SqlParam>>> modelSchemaDTOList;
                String draftChildSchemaName = subDraftChildSchema.getName();
                log.debug("process sub Model Schema of childModelSchema({})", (Object)draftChildSchemaName);
                List matchPublishSchemas = publishedChildrenSchema.stream().filter(modelSchemaDTO -> modelSchemaDTO.getName().equals(draftChildSchemaName)).collect(Collectors.toList());
                if (CollectionUtils.isNotEmpty(matchPublishSchemas)) {
                    modelSchemaDTOList = ModelSchemaUtil.getRecursiveAlterChildTableCommand(draftChildSchemaName, subDraftChildSchema.getChildren(), ((ModelSchemaDTO)matchPublishSchemas.get(0)).getChildren(), level + 1);
                    returnValue.putAll(modelSchemaDTOList);
                    continue;
                }
                modelSchemaDTOList = ModelSchemaUtil.getRecursiveAlterChildTableCommand(tableName, subDraftChildSchema.getChildren(), new ArrayList<ModelSchemaDTO>(), level + 1);
                returnValue.putAll(modelSchemaDTOList);
            }
        }
        return returnValue;
    }

    public static Map<String, LinkedHashMap<String, List<SqlParam>>> compareAndGetChildrenAlterData(List<ModelSchemaDTO> draftChildrenSchema, List<ModelSchemaDTO> publishedChildrenSchema) throws Exception {
        Map<String, LinkedHashMap<String, List<SqlParam>>> createChildrenTableCommandData;
        HashMap<String, LinkedHashMap<String, List<SqlParam>>> returnValue = new HashMap<String, LinkedHashMap<String, List<SqlParam>>>();
        if (CollectionUtils.isEmpty(draftChildrenSchema) && CollectionUtils.isEmpty(publishedChildrenSchema)) {
            return returnValue;
        }
        LinkedHashMap tempDDLDML = new LinkedHashMap();
        AtomicReference<PublishStatusEnum> alterStatus = new AtomicReference<PublishStatusEnum>(PublishStatusEnum.UNCHANGED);
        ArrayList dmlSqlParams = new ArrayList();
        ArrayList ddlSqlParams = new ArrayList();
        tempDDLDML.put("dml", dmlSqlParams);
        tempDDLDML.put("ddl", ddlSqlParams);
        boolean draftChildrenEmpty = CollectionUtils.isEmpty(draftChildrenSchema);
        boolean publishedChildrenEmpty = CollectionUtils.isEmpty(publishedChildrenSchema);
        if (draftChildrenEmpty && !publishedChildrenEmpty) {
            List<ModelTable> dropChildTableNames = publishedChildrenSchema.stream().map(modelSchemaDTO -> ModelSchemaUtil.convertToSimpleModelTable(modelSchemaDTO)).collect(Collectors.toList());
            Map<String, LinkedHashMap<String, List<SqlParam>>> dropChildTableCommandData = ModelSqlGenerator.getDropChildTables(dropChildTableNames);
            returnValue.putAll(dropChildTableCommandData);
            alterStatus.set(PublishStatusEnum.CHANGED);
        }
        if (!draftChildrenEmpty && publishedChildrenEmpty && MapUtils.isNotEmpty(createChildrenTableCommandData = ModelSchemaUtil.getCreateChildTables(draftChildrenSchema))) {
            returnValue.putAll(createChildrenTableCommandData);
            alterStatus.set(PublishStatusEnum.CHANGED);
        }
        if (!draftChildrenEmpty && !publishedChildrenEmpty) {
            List dropChildren;
            List<ModelSchemaDTO> newChildren = draftChildrenSchema.stream().filter(draftChildModelSchema -> publishedChildrenSchema.stream().noneMatch(publishedChildModelSchema -> Objects.equals(draftChildModelSchema.getName(), publishedChildModelSchema.getName()))).collect(Collectors.toList());
            if (CollectionUtils.isNotEmpty(newChildren)) {
                Map<String, LinkedHashMap<String, List<SqlParam>>> createChildrenTableCommandData2 = ModelSchemaUtil.getCreateChildTables(newChildren);
                returnValue.putAll(createChildrenTableCommandData2);
                alterStatus.set(PublishStatusEnum.CHANGED);
            }
            if (CollectionUtils.isNotEmpty(dropChildren = publishedChildrenSchema.stream().filter(draftChildFModelSchema -> draftChildrenSchema.stream().noneMatch(publishedChildFormSchema -> Objects.equals(draftChildFModelSchema.getName(), publishedChildFormSchema.getName()))).collect(Collectors.toList()))) {
                List<ModelTable> dropChildTableNames = dropChildren.stream().map(modelSchemaDTO -> ModelSchemaUtil.convertToSimpleModelTable(modelSchemaDTO)).collect(Collectors.toList());
                Map<String, LinkedHashMap<String, List<SqlParam>>> dropChildrenTableCommandData = ModelSqlGenerator.getDropChildTables(dropChildTableNames);
                returnValue.putAll(dropChildrenTableCommandData);
                alterStatus.set(PublishStatusEnum.CHANGED);
            }
        }
        draftChildrenSchema.forEach(draftChildModelSchema -> publishedChildrenSchema.stream().filter(publishedChildFormSchema -> Objects.equals(draftChildModelSchema.getName(), publishedChildFormSchema.getName())).findFirst().ifPresent(publishedChildFormSchema -> {
            try {
                Map<String, LinkedHashMap<String, List<SqlParam>>> childrenAlterData = ModelSchemaUtil.filterAlterTableCommand(draftChildModelSchema, publishedChildFormSchema);
                returnValue.putAll(childrenAlterData);
            }
            catch (Exception e) {
                String i18nMesg = DWApplicationMessageResourceBundleUtils.getString((String)"published_alter_table_detail_failed", (Object[])new Object[0]);
                log.error(i18nMesg + " -> draftChildModelSchema = {}, publishedChildModelSchema = {}", new Object[]{draftChildModelSchema, publishedChildFormSchema, e});
                throw new RuntimeException(i18nMesg, e);
            }
        }));
        return returnValue;
    }

    public static ModelTable convertToSimpleModelTable(ModelSchemaDTO modelSchema) {
        if (modelSchema == null) {
            return null;
        }
        ModelTable modelTable = new ModelTable();
        modelTable.setName(modelSchema.getName());
        modelTable.setComment(modelSchema.getComment());
        List<TableColumn> tableColumns = modelSchema.getFields().stream().map(ModelSchemaUtil::convertModelFieldToTableColumn).collect(Collectors.toList());
        modelTable.setColumns(tableColumns);
        return modelTable;
    }

    public static ModelTable convertToSimpleModelTable(ModelSchemaDTO modelSchema, boolean includeCollection) {
        if (modelSchema == null) {
            return null;
        }
        ModelTable modelTable = new ModelTable();
        modelTable.setName(modelSchema.getName());
        modelTable.setComment(modelSchema.getComment());
        List<TableColumn> allTableColumns = BooleanUtils.isTrue((Boolean)includeCollection) ? modelSchema.getFields().stream().map(ModelSchemaUtil::convertModelFieldToTableColumn).collect(Collectors.toList()) : modelSchema.getFields().stream().filter(tableColumn -> ModelSchemaUtil.checkRelatedType(tableColumn)).map(ModelSchemaUtil::convertToTableColumn).collect(Collectors.toList());
        modelTable.setColumns(allTableColumns);
        return modelTable;
    }

    public static Map<String, LinkedHashMap<String, List<SqlParam>>> getCreateChildTables(List<ModelSchemaDTO> childModelSchemas) throws Exception {
        Map<String, LinkedHashMap<String, List<SqlParam>>> returnValue = new LinkedHashMap<String, LinkedHashMap<String, List<SqlParam>>>();
        if (CollectionUtils.isEmpty(childModelSchemas)) {
            return returnValue;
        }
        List<ModelTable> childTables = childModelSchemas.stream().map(childModelSchema -> {
            ModelTable newModelTable = ModelSchemaUtil.getCurrentLevelModelTable(childModelSchema, false);
            return newModelTable;
        }).collect(Collectors.toList());
        returnValue = ModelSqlGenerator.getCreateChildTablesCommand(null, "code", childTables, null);
        return returnValue;
    }

    public static Map<String, LinkedHashMap<String, List<SqlParam>>> filterAlterTableCommand(ModelSchemaDTO draftModelSchema, ModelSchemaDTO publishedModelSchema) throws Exception {
        Map<AlterColumnEnum, List<TableColumn>> alterColumnsMap;
        ModelSchemaUtil.checkModelSchema(draftModelSchema, false);
        ModelSchemaUtil.checkModelSchema(publishedModelSchema, false);
        String masterTableName = draftModelSchema.getName();
        log.debug("=============== alterTable-filterAlterTableCommand ==== {} =========", (Object)masterTableName);
        List<String> draftChildrenTableNames = ModelDataUtil.getChildrenName(draftModelSchema);
        List<String> publishedChildrenTableNames = ModelDataUtil.getChildrenName(publishedModelSchema);
        log.debug("alterTable starting....masterTableName({}), draftChildrenTableNames({}), publishedChildrenTableNames({})", new Object[]{masterTableName, draftChildrenTableNames, publishedChildrenTableNames});
        AtomicReference<PublishStatusEnum> alterStatus = new AtomicReference<PublishStatusEnum>(PublishStatusEnum.UNCHANGED);
        if (!Objects.equals(draftModelSchema.getName(), publishedModelSchema.getName())) {
            throw new DWBusinessException(DWApplicationMessageResourceBundleUtils.getString((String)"published_notsupport_tablename_rename", (Object[])new Object[0]));
        }
        LinkedHashMap ddldmlValule = new LinkedHashMap();
        LinkedList<SqlParam> alterDDLSqlParam = new LinkedList<SqlParam>();
        LinkedList<SqlParam> alterDMLSqlParam = new LinkedList<SqlParam>();
        ddldmlValule.put("ddl", alterDDLSqlParam);
        ddldmlValule.put("dml", alterDMLSqlParam);
        ModelTable draftSimpleModelTable = ModelSchemaUtil.getCurrentLevelModelTable(draftModelSchema);
        ModelTable publishedSimpleModelTable = ModelSchemaUtil.getCurrentLevelModelTable(publishedModelSchema);
        HashMap<String, LinkedHashMap<String, List<SqlParam>>> returnValue = new HashMap<String, LinkedHashMap<String, List<SqlParam>>>();
        if (!Objects.equals(draftModelSchema.getComment(), publishedModelSchema.getComment())) {
            ModelTable modelTable = new ModelTable();
            modelTable.setName(draftModelSchema.getName());
            modelTable.setComment(draftModelSchema.getComment());
            LinkedHashMap<String, List<SqlParam>> alterComment = ModelSqlGenerator.getAlterTableInfo(modelTable);
            alterDMLSqlParam.addAll((Collection)alterComment.get("dml"));
            alterDDLSqlParam.addAll((Collection)alterComment.get("ddl"));
            alterStatus.set(PublishStatusEnum.CHANGED);
        }
        if ((alterColumnsMap = ModelSchemaUtil.getAlterColumnsMap(draftModelSchema, publishedModelSchema, draftSimpleModelTable, publishedSimpleModelTable)) != null) {
            alterColumnsMap.forEach((alterColumnEnum, tableColumns) -> {
                if (!CollectionUtils.isEmpty((Collection)tableColumns)) {
                    ModelSqlGenerator.updateAlterColumnsInfoOnly(publishedModelSchema.getName(), alterColumnEnum, tableColumns, alterDDLSqlParam, alterDMLSqlParam);
                    alterStatus.set(PublishStatusEnum.CHANGED);
                }
            });
        }
        List<SqlParam> insertOrUpdateRdbmsFieldsParam = ModelSqlGenerator.generateInsertOrUpdateRdbmsFieldSql(draftSimpleModelTable);
        alterDMLSqlParam.addAll(insertOrUpdateRdbmsFieldsParam);
        Map<AlterIndexEnum, List<TableIndex>> alterIndexesMap = ModelSqlGenerator.getAlterIndexesMap(draftModelSchema, publishedModelSchema);
        if (alterIndexesMap != null) {
            alterIndexesMap.forEach((alterIndexEnum, tableColumns) -> {
                if (!CollectionUtils.isEmpty((Collection)tableColumns)) {
                    Map<String, Object> alterIndexes = ModelSqlGenerator.getAlterIndexesInfo(publishedModelSchema.getName(), alterIndexEnum, tableColumns, alterDDLSqlParam);
                    alterStatus.set(PublishStatusEnum.CHANGED);
                }
            });
        }
        alterDDLSqlParam.addAll(ModelSqlGenerator.getAlterPrimaryKeySql(draftSimpleModelTable, publishedSimpleModelTable, alterColumnsMap));
        if (alterStatus.get() == PublishStatusEnum.CHANGED) {
            alterDDLSqlParam.addAll(ModelSqlGenerator.getAlterAutoIncrementSql(draftSimpleModelTable));
        }
        if (!CollectionUtils.isEmpty(alterDMLSqlParam) || !CollectionUtils.isEmpty(alterDDLSqlParam)) {
            ddldmlValule.put("ddl", alterDDLSqlParam);
            ddldmlValule.put("dml", alterDMLSqlParam);
            returnValue.put(publishedModelSchema.getName(), ddldmlValule);
        }
        return returnValue;
    }

    public static void checkModelSchema(ModelSchemaDTO modelSchema, boolean isCreate) {
        ModelDataUtil.preCheckSchema(modelSchema);
        List<ModelSchemaDTO> childrenModelSchema = modelSchema.getChildren();
        if (!CollectionUtils.isEmpty(childrenModelSchema)) {
            childrenModelSchema.forEach(childFormSchema -> ModelSchemaUtil.checkModelSchema(childFormSchema, isCreate));
        }
    }

    public static boolean checkRelatedType(ModelFieldDTO modelField) {
        return !ModelFieldRelationTypeEnum.valueOf(modelField.getType()).equals((Object)ModelFieldRelationTypeEnum.COLLECTION);
    }

    public static boolean checkRelatedType(TableColumn tableColumn) {
        return tableColumn.getRelationTypeEnum() != ModelFieldRelationTypeEnum.COLLECTION;
    }

    public static Map<AlterColumnEnum, List<TableColumn>> getAlterColumnsMap(ModelSchemaDTO draftModelSchema, ModelSchemaDTO publishedModelSchema, ModelTable draftSimpleModelTable, ModelTable publishedSimpleModelTable) throws JSQLParserException, DWBusinessException {
        if (draftModelSchema == null || CollectionUtils.isEmpty(draftModelSchema.getFields()) || publishedModelSchema == null || CollectionUtils.isEmpty(publishedModelSchema.getFields())) {
            return null;
        }
        List<ModelFieldDTO> draftModelFields = draftModelSchema.getFields();
        List<ModelFieldDTO> publishedModelFields = publishedModelSchema.getFields();
        if (log.isDebugEnabled()) {
            log.debug("publishing model (comparing fields) -> draftModelSchema = {}, publishedModelSchema = {}", (Object)draftModelSchema, (Object)publishedModelSchema);
        }
        List<TableColumn> addColumns = draftModelFields.stream().filter(draftModelField -> ModelSchemaUtil.checkRelatedType(draftModelField) && publishedModelFields.stream().noneMatch(publishedModelField -> Objects.equals(draftModelField.getFieldId(), publishedModelField.getFieldId()))).map(ModelSchemaUtil::convertToTableColumn).collect(Collectors.toList());
        List<TableColumn> modifyColumns = draftModelFields.stream().filter(draftModelField -> publishedModelFields.stream().anyMatch(publishedModelField -> Objects.equals(draftModelField.getFieldId(), publishedModelField.getFieldId()) && !Objects.equals(draftModelField, publishedModelField) && ModelSchemaUtil.checkRelatedType(draftModelField))).map(ModelSchemaUtil::convertToTableColumn).collect(Collectors.toList());
        List dropColumns = publishedModelFields.stream().filter(publishedModelField -> ModelSchemaUtil.checkRelatedType(publishedModelField) && draftModelFields.stream().noneMatch(draftModelField -> Objects.equals(publishedModelField.getFieldId(), draftModelField.getFieldId()))).map(ModelSchemaUtil::convertToTableColumn).collect(Collectors.toList());
        ModelSchemaUtil.changeColumnActionType(publishedSimpleModelTable, addColumns, modifyColumns);
        HashMap<AlterColumnEnum, List<TableColumn>> alterTableColumnsMap = new HashMap<AlterColumnEnum, List<TableColumn>>();
        alterTableColumnsMap.put(AlterColumnEnum.ADD_COLUMN, addColumns);
        alterTableColumnsMap.put(AlterColumnEnum.MODIFY_COLUMN, modifyColumns);
        alterTableColumnsMap.put(AlterColumnEnum.DROP_COLUMN, dropColumns);
        return alterTableColumnsMap;
    }

    public static void updateColumnsSqlParams(String pureTableName, List<TableColumn> draftTableColumns, List<TableColumn> existedTableColumns, LinkedList<SqlParam> ddlSqlParams, LinkedList<SqlParam> dmlSqlParams) {
        List<TableColumn> org_addColumns = draftTableColumns.stream().filter(draftTableColumn -> ModelSchemaUtil.checkRelatedType(draftTableColumn) && existedTableColumns.stream().noneMatch(existedColumn -> Objects.equals(draftTableColumn.getColumnName().replaceAll("`", ""), existedColumn.getColumnName().replaceAll("`", "")))).collect(Collectors.toList());
        ModelSqlGenerator.updateAlterColumnsInfoOnly(pureTableName, AlterColumnEnum.ADD_COLUMN, org_addColumns, ddlSqlParams, dmlSqlParams);
        List<TableColumn> org_modifyColumns = draftTableColumns.stream().filter(draftTableColumn -> existedTableColumns.stream().anyMatch(existedTableColumn -> Objects.equals(draftTableColumn.getColumnName().replaceAll("`", ""), existedTableColumn.getColumnName().replaceAll("`", "")) && !Objects.equals(draftTableColumn, existedTableColumn) && ModelSchemaUtil.checkRelatedType(draftTableColumn))).collect(Collectors.toList());
        ModelSqlGenerator.updateAlterColumnsInfoOnly(pureTableName, AlterColumnEnum.MODIFY_COLUMN, org_modifyColumns, ddlSqlParams, dmlSqlParams);
        List<TableColumn> simpleTableColumns = draftTableColumns.stream().filter(draftTableColumn -> ModelSchemaUtil.checkRelatedType(draftTableColumn)).collect(Collectors.toList());
        ModelSchemaUtil.updateColumnsRdbmsSqlParams(pureTableName, simpleTableColumns, dmlSqlParams);
    }

    public static void updateColumnsRdbmsSqlParams(String pureTableName, List<TableColumn> filteredTableColumns, LinkedList<SqlParam> targetDMLSqlParams) {
        filteredTableColumns.forEach(tableColumn -> {
            SqlParam insertOrUpdateRdbmsFieldSql = ModelSqlGenerator.generateInsertOrUpdateRdbmsFieldSql(pureTableName, tableColumn);
            targetDMLSqlParams.add(insertOrUpdateRdbmsFieldSql);
            if (log.isDebugEnabled()) {
                log.debug(">>>>> gen Insert on duplicate key Rdbms Fields SQL: sql = {}, params = {}", (Object)insertOrUpdateRdbmsFieldSql.getSql(), (Object)insertOrUpdateRdbmsFieldSql.getParams());
            }
        });
    }

    public static ModelSchemaDTO getModelSchema(String modelSchemaJsonStr) {
        ModelSchemaDTO modelSchema = (ModelSchemaDTO)DWGsonProvider.getGson().fromJson(modelSchemaJsonStr, ModelSchemaDTO.class);
        return modelSchema;
    }

    public static ModelDTO getModel(DWDataRow dataRow) {
        ModelDTO newModel = new ModelDTO();
        newModel.setTargetTenantId((String)dataRow.get("target_tenant_id"));
        newModel.setCode((String)dataRow.get("code"));
        newModel.setDescription((String)dataRow.get("description"));
        newModel.setAppId((String)dataRow.get("app_id"));
        ModelSchemaDTO modelSchemaDTO = ModelSchemaUtil.parseModelSchema(dataRow);
        newModel.setSchema(modelSchemaDTO);
        return newModel;
    }

    public static ModelSchemaDTO parseModelSchema(DWDataRow dataRow) {
        String code = (String)dataRow.get("code");
        String modelSchemaJsonStr = (String)dataRow.get("model_schema");
        if (StringUtils.isEmpty((CharSequence)modelSchemaJsonStr)) {
            throw new IllegalArgumentException(String.format("\u6a21\u578b %s \u7d00\u9304\u7684\u7d50\u69cb\u70ba\u7a7a", code));
        }
        Gson gson = DWGsonProvider.getGson();
        ModelSchemaDTO modelSchema = (ModelSchemaDTO)gson.fromJson(modelSchemaJsonStr, ModelSchemaDTO.class);
        return modelSchema;
    }

    @Deprecated
    public static ModelSchemaDTO parseModelSchema(Map modelMap) {
        String code = (String)modelMap.get("code");
        String modelSchemaJsonStr = (String)modelMap.get("model_schema");
        if (StringUtils.isEmpty((CharSequence)modelSchemaJsonStr)) {
            throw new IllegalArgumentException(String.format("\u6a21\u578b %s \u7d00\u9304\u7684\u7d50\u69cb\u70ba\u7a7a", code));
        }
        ModelSchemaDTO modelSchema = ModelSchemaUtil.getModelSchema(modelSchemaJsonStr);
        return modelSchema;
    }

    @Deprecated
    public static ModelDTO getModel(Map modelMap) {
        ModelDTO newModel = new ModelDTO();
        newModel.setCode((String)modelMap.get("code"));
        newModel.setDescription((String)modelMap.get("description"));
        newModel.setAppId((String)modelMap.get("app_id"));
        newModel.setTargetTenantId((String)modelMap.get("target_tenant_id"));
        String modelSchemaJsonStr = (String)modelMap.get("model_schema");
        ModelSchemaDTO modelSchema = (ModelSchemaDTO)DWGsonProvider.getGson().fromJson(modelSchemaJsonStr, ModelSchemaDTO.class);
        newModel.setSchema(modelSchema);
        return newModel;
    }

    public static Map<String, List<Map<String, Object>>> validateDatas(Map<String, List<Map<String, Object>>> paramDatas, ModelSchemaDTO masterModelSchema) {
        Map<String, ModelSchemaDTO> modelSchemaMap = ModelSchemaUtil.getModelSchemaMap(masterModelSchema);
        paramDatas.forEach((tableName, modelSchema) -> modelSchema.forEach(data -> {
            Iterator iterator = data.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry next = iterator.next();
                String field = (String)next.getKey();
                Object value = next.getValue();
                ModelFieldDTO modelFieldDTO = ((ModelSchemaDTO)modelSchemaMap.get(tableName)).getFields().stream().filter(modelSchemaField -> modelSchemaField.getFieldId().equals(field)).findFirst().orElse(null);
                if (modelFieldDTO != null && !StringUtils.isEmpty((CharSequence)modelFieldDTO.getFieldType()) && (modelFieldDTO.getFieldType().toUpperCase().equals("DATETIME") || modelFieldDTO.getFieldType().toUpperCase().equals("TIMESTAMP") || modelFieldDTO.getFieldType().toUpperCase().equals("DATE"))) {
                    data.put(field, "".equals(value) ? null : (Object)value);
                }
                if (modelFieldDTO != null) continue;
                iterator.remove();
            }
        }));
        return paramDatas;
    }

    public static void dealSpecialTypeDatas(Map<String, Object> rowData, ModelSchemaDTO modelSchema) {
        Iterator<Map.Entry<String, Object>> iterator = rowData.entrySet().iterator();
        Gson gson = DWGsonProvider.getGson();
        while (iterator.hasNext()) {
            Map.Entry<String, Object> next = iterator.next();
            String field = next.getKey();
            Object value = next.getValue();
            ModelFieldDTO modelFieldDTO = modelSchema.getFields().stream().filter(modelSchemaField -> modelSchemaField.getFieldId().equals(field)).findFirst().orElse(null);
            if (modelFieldDTO != null && !StringUtils.isEmpty((CharSequence)modelFieldDTO.getFieldType()) && (modelFieldDTO.getFieldType().toUpperCase().equals("DATETIME") || modelFieldDTO.getFieldType().toUpperCase().equals("TIMESTAMP") || modelFieldDTO.getFieldType().toUpperCase().equals("DATE"))) {
                rowData.put(field, "".equals(value) ? null : value);
            }
            if (modelFieldDTO != null && "JSON".equalsIgnoreCase(modelFieldDTO.getFieldType())) {
                rowData.put(field, gson.toJson(rowData.get(field)));
            }
            if (modelFieldDTO != null) continue;
            iterator.remove();
        }
    }

    public static Map<String, ModelSchemaDTO> getModelSchemaMap(ModelSchemaDTO masterModelSchema) {
        HashMap<String, ModelSchemaDTO> result = new HashMap<String, ModelSchemaDTO>();
        result.put(masterModelSchema.getName(), masterModelSchema);
        List<ModelSchemaDTO> childrenModelSchemas = masterModelSchema.getChildren();
        if (!CollectionUtils.isEmpty(childrenModelSchemas)) {
            childrenModelSchemas.forEach(childrenModelSchema -> result.putAll(ModelSchemaUtil.getModelSchemaMap(childrenModelSchema)));
        }
        return result;
    }

    public static List<String> getPrimaryKeys(List<TableColumn> customColumns) {
        List<String> pks = customColumns.stream().filter(Field::isPK).map(customColumn -> customColumn.getColumnName()).collect(Collectors.toList());
        return pks;
    }

    public static List<TableColumn> getTableColumns(List<ColumnDefinition> ccjColumnDefinitions, List<Index> ccjIndexes) {
        List<TableColumn> existedTableColumns = ccjColumnDefinitions.stream().map(ccjColumnDef -> ModelSchemaUtil.convertToTableColumn(ccjColumnDef, ccjIndexes)).collect(Collectors.toList());
        return existedTableColumns;
    }

    public static List<TableIndex> getTableIndexes(List<Index> ccjIndexes) {
        List<TableIndex> existedTableIndexes = ccjIndexes.stream().filter(ccjIndex -> ccjIndex != null && !ccjIndex.getType().equals("PRIMARY KEY")).map(ModelSchemaUtil::convertToTableIndex).collect(Collectors.toList());
        return existedTableIndexes;
    }

    public static List<String> getExistedTableColumnNames(CreateTable ccjCreateTable) {
        List ccjColumnDefinitions = ccjCreateTable.getColumnDefinitions();
        List ccjIndexes = Optional.ofNullable(ccjCreateTable.getIndexes()).orElse(new ArrayList());
        List<TableColumn> existedTableColumns = ModelSchemaUtil.getTableColumns(ccjColumnDefinitions, ccjIndexes);
        List<String> existedTableColumnNames = existedTableColumns.stream().map(tableColumn -> tableColumn.getColumnName()).collect(Collectors.toList());
        return existedTableColumnNames;
    }

    public static List<String> getNotModelingColumns(ModelTable publishedSimpleModelTable) throws JSQLParserException, DWBusinessException {
        String tableName = publishedSimpleModelTable.getName();
        CreateTable ccjCreateTable = modelTableHelperExpress.getCCJCreateTable(tableName);
        if (ccjCreateTable == null) {
            throw new DWBusinessException(String.format("[ModelSchemanUtil][getNotModelingColumns] db table (%s) is not existed", new Object[0]), tableName);
        }
        List<String> existedTableColumnNames = ModelSchemaUtil.getExistedTableColumnNames(ccjCreateTable);
        List modelExistedColumnNames = publishedSimpleModelTable.getColumns().stream().map(tableColumn -> tableColumn.getColumnName()).collect(Collectors.toList());
        List<String> notModelingColumns = existedTableColumnNames.stream().filter(existedColumnName -> modelExistedColumnNames.stream().noneMatch(publishedModelExistedName -> Objects.equals(existedColumnName, publishedModelExistedName))).collect(Collectors.toList());
        log.info("[ModelSchemaUtil][getNotModelingColumns] db table {} notModelingColumns ({})", (Object)publishedSimpleModelTable, notModelingColumns);
        return notModelingColumns;
    }

    public static void changeColumnActionType(ModelTable publishedSimpleModelTable, List<TableColumn> addColumns, List<TableColumn> modifyColumns) throws JSQLParserException, DWBusinessException {
        List<String> notModelingColumns = ModelSchemaUtil.getNotModelingColumns(publishedSimpleModelTable);
        if (CollectionUtils.isNotEmpty(notModelingColumns)) {
            ArrayList extraModeling = new ArrayList();
            addColumns.forEach(addColumn -> {
                if (notModelingColumns.contains(addColumn.getColumnName())) {
                    extraModeling.add(addColumn);
                }
            });
            modifyColumns.addAll(extraModeling);
            addColumns.removeAll(extraModeling);
            log.info("[ModelSchemaUtil][getAlterColumnsMap] db table {} column({}): ADD_COLUMN change to MODIFY_COLUMN", extraModeling.stream().map(tableColumn -> tableColumn.getColumnName()));
        }
    }

    public ModelTableHelperExpress getModelTableHelperExpress() {
        return modelTableHelperExpress;
    }

    public void setModelTableHelperExpress(ModelTableHelperExpress modelTableHelperExpress) {
        ModelSchemaUtil.modelTableHelperExpress = modelTableHelperExpress;
    }
}

