/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.lcdp.modeldriven.utils;

import com.digiwin.app.dao.DWDao;
import com.digiwin.app.dao.DWServiceResultBuilder;
import com.digiwin.app.ddl.model.Field;
import com.digiwin.app.service.DWEAIResult;
import com.digiwin.app.service.DWServiceResult;
import com.digiwin.lcdp.modeldriven.context.ModelDrivenContext;
import com.digiwin.lcdp.modeldriven.enums.AlterColumnEnum;
import com.digiwin.lcdp.modeldriven.enums.AlterIndexEnum;
import com.digiwin.lcdp.modeldriven.enums.PublishStatusEnum;
import com.digiwin.lcdp.modeldriven.model.ModelDTO;
import com.digiwin.lcdp.modeldriven.model.ModelPublishedEspResult;
import com.digiwin.lcdp.modeldriven.model.ModelTable;
import com.digiwin.lcdp.modeldriven.model.SqlParam;
import com.digiwin.lcdp.modeldriven.model.TableColumn;
import com.digiwin.lcdp.modeldriven.model.TableIndex;
import com.digiwin.lcdp.modeldriven.model.TableSqlParamDTO;
import com.digiwin.lcdp.modeldriven.report.model.DBTableNameCheckResult;
import com.digiwin.lcdp.modeldriven.utils.DBExecuteHandler;
import com.digiwin.lcdp.modeldriven.utils.DBTableUtil;
import com.digiwin.lcdp.modeldriven.utils.ModelSchemaUtil;
import com.digiwin.lcdp.modeldriven.utils.ModelSqlGenerator;
import com.digiwin.lcdp.modeldriven.utils.ModelSqlParserUtil;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicReference;
import net.sf.jsqlparser.JSQLParserException;
import net.sf.jsqlparser.schema.Table;
import net.sf.jsqlparser.statement.create.table.CreateTable;
import net.sf.jsqlparser.statement.create.table.Index;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.math.NumberUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

@Component
public class ModelTableHelperExpress {
    private static final Logger log = LoggerFactory.getLogger(ModelTableHelperExpress.class);
    @Autowired
    @Qualifier(value="dw-dao")
    private DWDao dao;
    @Autowired
    DBExecuteHandler dbExecuteService;

    @Transactional(propagation=Propagation.REQUIRED, rollbackFor={Exception.class})
    public DWServiceResult createTableExpress(String masterTableName, List<ModelTable> modelTables) throws Exception {
        ModelPublishedEspResult executeInsertResult;
        boolean createSuccess = false;
        ModelDrivenContext modelDrivenContext = ModelDrivenContext.getContext();
        ModelDTO draftModel = modelDrivenContext.getDraftModel();
        ArrayList<SqlParam> dmlSqlParams = new ArrayList<SqlParam>();
        ArrayList<SqlParam> ddlSqlParams = new ArrayList<SqlParam>();
        for (ModelTable modelTable : modelTables) {
            boolean hasPrimaryKey = modelTable.getColumns().stream().anyMatch(Field::isPK);
            if (!hasPrimaryKey) {
                throw new IllegalArgumentException("The table must include a primary key!");
            }
            TableSqlParamDTO tableSqlParamDTO = ModelSqlGenerator.getCreateTable(modelTable);
            dmlSqlParams.addAll(tableSqlParamDTO.getDmlSqlParams());
            ddlSqlParams.addAll(tableSqlParamDTO.getDdlSqlParams());
        }
        SqlParam insertModelTableParam = ModelSqlGenerator.generateInsertModelSql(draftModel);
        dmlSqlParams.add(insertModelTableParam);
        List<ModelTable> modelAllTables = ModelSchemaUtil.getModelTables(draftModel.getSchema());
        List<SqlParam> insertModelInfoTableParam = ModelSqlGenerator.generateInsertModelInfoSql(modelAllTables, draftModel.getCode());
        dmlSqlParams.addAll(insertModelInfoTableParam);
        ModelTable masterModelTable = ModelSchemaUtil.getCurrentLevelModelTable(draftModel.getSchema());
        SqlParam insertServiceMappingTableParam = ModelSqlGenerator.generateInsertServiceMappingSql(masterModelTable);
        dmlSqlParams.add(insertServiceMappingTableParam);
        ModelPublishedEspResult executeCreateTableResult = this.dbExecuteService.executeCreateTableOfCreateModelDriven(ddlSqlParams, draftModel);
        if (executeCreateTableResult.getPublishStatusEnum() == PublishStatusEnum.SUCCESS && (executeInsertResult = this.dbExecuteService.executeInsertOfCreateModelDriven(dmlSqlParams, draftModel)).getPublishStatusEnum() == PublishStatusEnum.SUCCESS) {
            createSuccess = true;
        }
        return DWServiceResultBuilder.build((boolean)createSuccess, (String)"", null);
    }

    public DWServiceResult alterTableExpress(String masterTableName, LinkedHashMap<String, LinkedHashMap<String, List<SqlParam>>> alterTableMap, Map<String, Object> modelDataMap) throws Exception {
        AtomicReference<PublishStatusEnum> alterRunStatus = new AtomicReference<PublishStatusEnum>(PublishStatusEnum.UNCHANGED);
        boolean alterSuccess = false;
        HashMap<String, Object> paramAll = new HashMap<String, Object>();
        LinkedList paramDML = new LinkedList();
        LinkedList paramDDL = new LinkedList();
        for (String tableName : alterTableMap.keySet()) {
            List<SqlParam> ddlSqlParams;
            LinkedHashMap<String, List<SqlParam>> tableAlterMap = alterTableMap.get(tableName);
            List<SqlParam> dmlSqlParams = tableAlterMap.get("dml");
            HashMap<String, List<SqlParam>> tempDMLMap = new HashMap<String, List<SqlParam>>();
            if (CollectionUtils.isNotEmpty(dmlSqlParams)) {
                tempDMLMap.put("sqlParamRdbms", dmlSqlParams);
                paramDML.add(tempDMLMap);
                paramAll.put("dml", paramDML);
            }
            if (!CollectionUtils.isNotEmpty(ddlSqlParams = tableAlterMap.get("ddl"))) continue;
            HashMap<String, List<SqlParam>> tempDDLMap = new HashMap<String, List<SqlParam>>();
            tempDDLMap.put("sqlParamTables", ddlSqlParams);
            paramDDL.add(tempDDLMap);
            paramAll.put("ddl", paramDDL);
        }
        alterRunStatus.set(PublishStatusEnum.CHANGED);
        HashMap<String, Object> modelInfo = new HashMap<String, Object>();
        modelInfo.put("entity_table_name", masterTableName);
        modelInfo.put("model_action", "U");
        modelInfo.put("model_design", modelDataMap);
        paramAll.put("model_data", modelInfo);
        ModelDrivenContext modelDrivenContext = ModelDrivenContext.getContext();
        DWEAIResult executeResult = this.dbExecuteService.executeAlterTable(paramAll, modelDrivenContext.getDraftModel(), modelDrivenContext.getExtraMap());
        boolean executeSuccess = false;
        String resultCode = executeResult.getCode();
        if (NumberUtils.isDigits((String)resultCode) && NumberUtils.compare((int)0, (int)NumberUtils.createInteger((String)resultCode)) == 0) {
            executeSuccess = true;
        }
        String description = executeResult.getDescription();
        if (!executeSuccess) {
            SQLException cause = new SQLException(description, executeResult.getSqlCode());
            throw new RuntimeException(cause);
        }
        return DWServiceResultBuilder.build((boolean)executeSuccess, (String)description, (Object)executeResult);
    }

    public static LinkedHashMap<String, List<SqlParam>> getAlterTableInfo(ModelTable modelTable) {
        LinkedHashMap<String, List<SqlParam>> returnValue = new LinkedHashMap<String, List<SqlParam>>();
        LinkedList<SqlParam> alterDDLSqlParam = new LinkedList<SqlParam>();
        LinkedList<SqlParam> alterDMLSqlParam = new LinkedList<SqlParam>();
        returnValue.put("dml", alterDMLSqlParam);
        returnValue.put("ddl", alterDDLSqlParam);
        String tableName = modelTable.getName();
        String tableComment = modelTable.getComment();
        SqlParam alterTableSqlParam = ModelSqlGenerator.generateAlterTableSql(tableName, tableComment);
        alterDDLSqlParam.add(alterTableSqlParam);
        SqlParam alterRdbmsSqlParam = ModelSqlGenerator.generateUpdateRdbmsTableSql(modelTable);
        alterDMLSqlParam.add(alterRdbmsSqlParam);
        if (log.isDebugEnabled()) {
            log.debug(">>>>> gen Alter Table Params: tableName = {}, tableComment = {} ", (Object)tableName, (Object)tableComment);
            log.debug(">>>>> gen Alter Table SQL: {}", (Object)alterTableSqlParam);
            log.debug(">>>>> gen Update Rdbms Tables Params: customTables = {}", (Object)modelTable);
            log.debug(">>>>> gen Update Rdbms Tables SQL: sql = {}, params = {}", (Object)alterRdbmsSqlParam.getSql(), (Object)alterRdbmsSqlParam.getParams());
        }
        return returnValue;
    }

    public Map<String, Object> getAlterCommentInfo(String tableName, String tableComment, LinkedList<SqlParam> sqlParams) {
        LinkedHashMap alertTableMap = new LinkedHashMap();
        SqlParam alterTableSqlParam = ModelSqlGenerator.generateAlterTableSql(tableName, tableComment);
        sqlParams.add(alterTableSqlParam);
        if (log.isDebugEnabled()) {
            log.debug(">>>>> gen Alter Table Params: tableName = {}, tableComment = {}", (Object)tableName, (Object)tableComment);
            log.debug(">>>>> gen Alter Table SQL: {}", (Object)alterTableSqlParam);
        }
        HashMap<String, Object> returnValue = new HashMap<String, Object>();
        returnValue.put("success", true);
        returnValue.put("sqlParams", alertTableMap);
        return returnValue;
    }

    public static Map<String, Object> getAlterExistedPrimaryKey(String tableName, List<Index> ccjIndexes, LinkedList<SqlParam> alterDDLSqlParam, LinkedList<SqlParam> alterDMLSqlParam) {
        HashMap<String, Object> returnValue = new HashMap<String, Object>();
        ccjIndexes.stream().filter(index -> index.getType().equals("PRIMARY KEY")).forEach(Index2 -> {
            SqlParam alterTableSqlParam = ModelSqlGenerator.getDropPrimaryKeySql(tableName);
            SqlParam alterRdbmsSqlParam = ModelSqlGenerator.generateUpdateRdbmsFieldRemovePrimarySql(tableName);
            alterDDLSqlParam.add(alterTableSqlParam);
            alterDMLSqlParam.add(alterRdbmsSqlParam);
            if (log.isDebugEnabled()) {
                log.debug(">>>>> gen Alter Columns Params: tableName = {}", (Object)tableName);
                log.debug(">>>>> gen Alter Columns SQL: {}", (Object)alterTableSqlParam);
                log.debug(">>>>> gen Alter Rdbms Fields SQL: sql = {}, params = {}", (Object)alterRdbmsSqlParam.getSql(), (Object)alterRdbmsSqlParam.getParams());
            }
        });
        return returnValue;
    }

    public static Map<String, Object> getAlterExistedColumnsInfo(String tableName, AlterColumnEnum alterColumnEnum, TableColumn existedColumnWithAutoIncrement, List<Index> ccjIndexes, LinkedList<SqlParam> alterDDLSqlParam, LinkedList<SqlParam> alterDMLSqlParam) {
        HashMap<String, Object> returnValue = new HashMap<String, Object>();
        boolean existedTableHasPK = ccjIndexes.stream().anyMatch(index -> index.getType().equals("PRIMARY KEY"));
        log.info("[ModelTableHelperExpress] getAlterExistedColumnsInfo autoincrementCoumn({}), existedTableHasPK({})", (Object)existedColumnWithAutoIncrement, (Object)existedTableHasPK);
        if (Objects.nonNull((Object)existedColumnWithAutoIncrement)) {
            SqlParam alterTableSqlParam = ModelSqlGenerator.generateAlterColumnRemoveAutoIncreAndPkSql(tableName, alterColumnEnum, existedColumnWithAutoIncrement);
            SqlParam alterRdbmsSqlParam = ModelSqlGenerator.generateInsertOrUpdateRdbmsFieldWithRemoveAutoIncrementSql(tableName, existedColumnWithAutoIncrement);
            if (log.isDebugEnabled()) {
                log.debug(">>>>> gen Alter Columns Params: tableName = {}, alterColumnEnum = {}, customColumn = {}", new Object[]{tableName, alterColumnEnum, existedColumnWithAutoIncrement});
                log.debug(">>>>> gen Alter Columns SQL: {}", (Object)alterTableSqlParam);
                log.debug(">>>>> gen Alter Rdbms Fields SQL: sql = {}, params = {}", (Object)alterRdbmsSqlParam.getSql(), (Object)alterRdbmsSqlParam.getParams());
            }
            alterDDLSqlParam.add(alterTableSqlParam);
            alterDMLSqlParam.add(alterRdbmsSqlParam);
        } else if (existedTableHasPK) {
            SqlParam alterTableSqlParam = ModelSqlGenerator.getDropPrimaryKeySql(tableName);
            SqlParam alterRdbmsSqlParam = ModelSqlGenerator.generateUpdateRdbmsFieldRemovePrimarySql(tableName);
            alterDDLSqlParam.add(alterTableSqlParam);
            alterDMLSqlParam.add(alterRdbmsSqlParam);
            if (log.isDebugEnabled()) {
                log.debug(">>>>> gen Alter Columns Params: tableName = {}, alterColumnEnum = {}, existedTableHasPK = {}", new Object[]{tableName, alterColumnEnum, existedTableHasPK});
                log.debug(">>>>> gen Alter Columns SQL: {}", (Object)alterTableSqlParam);
                log.debug(">>>>> gen Alter Rdbms Fields SQL: sql = {}, params = {}", (Object)alterRdbmsSqlParam.getSql(), (Object)alterRdbmsSqlParam.getParams());
            }
        }
        return returnValue;
    }

    public static Map<String, Object> getAlterIndexesInfo(String tableName, AlterIndexEnum alterIndexEnum, List<TableIndex> tableIndexes, LinkedList<SqlParam> alterDDLSqlParam) {
        HashMap<String, Object> returnValue = new HashMap<String, Object>();
        tableIndexes.forEach(tableIndex -> {
            LinkedList<SqlParam> alterIndexSqlParams = null;
            alterIndexSqlParams = ModelSqlGenerator.generateAlterIndexSql(tableName, alterIndexEnum, tableIndex);
            alterDDLSqlParam.addAll(alterIndexSqlParams);
            if (log.isDebugEnabled()) {
                log.debug(">>>>> gen Alter Index Params: tableName = {}, alterIndexEnum = {}, customIndex = {}", new Object[]{tableName, alterIndexEnum, tableIndex});
                log.debug(">>>>> gen Alter Columns SQL: {}", alterIndexSqlParams);
            }
        });
        return returnValue;
    }

    @Transactional(propagation=Propagation.REQUIRED, rollbackFor={Exception.class})
    public boolean dropTableExpress(List<ModelTable> modelTables, Map<String, Object> modelDataMap, ModelDTO model) throws Exception {
        String masterTableName = model.getSchema().getName();
        HashMap<String, Object> paramAll = new HashMap<String, Object>();
        HashMap<String, Object> modelInfo = new HashMap<String, Object>();
        modelInfo.put("entity_table_name", masterTableName);
        modelInfo.put("model_action", "D");
        modelInfo.put("model_design", modelDataMap);
        paramAll.put("model_data", modelInfo);
        LinkedList paramDML = new LinkedList();
        LinkedList paramDDL = new LinkedList();
        for (ModelTable modelTable : modelTables) {
            String targetTableName = modelTable.getName();
            ArrayList<SqlParam> dmlSqlParams = new ArrayList<SqlParam>();
            HashMap<String, ArrayList<SqlParam>> tempDMLMap = new HashMap<String, ArrayList<SqlParam>>();
            SqlParam deleteRdbmsTableParam = ModelSqlGenerator.generateDeleteRdbmsTableSql(targetTableName);
            dmlSqlParams.add(deleteRdbmsTableParam);
            SqlParam deleteRdbmsFieldsParam = ModelSqlGenerator.generateDeleteRdbmsFieldSql(modelTable);
            dmlSqlParams.add(deleteRdbmsFieldsParam);
            if (log.isDebugEnabled()) {
                log.debug(">>>>> gen Delete Rdbms Table Params: modelTable = {}", (Object)targetTableName);
                log.debug(">>>>> gen Delete Rdbms Table SQL: {}", (Object)deleteRdbmsTableParam);
                log.debug(">>>>> gen Delete Rdbms Fields Params: modelTable = {}", (Object)modelTable.getName());
                log.debug(">>>>> gen Delete Rdbms Fields SQL: {}", dmlSqlParams);
            }
            tempDMLMap.put("sqlParamRdbms", dmlSqlParams);
            paramDML.add(tempDMLMap);
            ArrayList<SqlParam> ddlSqlParams = new ArrayList<SqlParam>();
            HashMap<String, ArrayList<SqlParam>> tempDDLMap = new HashMap<String, ArrayList<SqlParam>>();
            SqlParam dropTableSqlParam = ModelSqlGenerator.generateRenameTableSql(targetTableName);
            ddlSqlParams.add(dropTableSqlParam);
            tempDDLMap.put("sqlParamTables", ddlSqlParams);
            paramDDL.add(tempDDLMap);
        }
        paramAll.put("dml", paramDML);
        paramAll.put("ddl", paramDDL);
        DWEAIResult executeResult = this.dbExecuteService.executeDeleteTable(paramAll, model);
        boolean executeDeleteSuccess = false;
        String resultCode = executeResult.getCode();
        if (NumberUtils.isDigits((String)resultCode) && NumberUtils.compare((int)0, (int)NumberUtils.createInteger((String)resultCode)) == 0) {
            executeDeleteSuccess = true;
        }
        String description = executeResult.getDescription();
        if (!executeDeleteSuccess) {
            SQLException cause = new SQLException(description, executeResult.getSqlCode());
            throw new RuntimeException(cause);
        }
        return executeDeleteSuccess;
    }

    @Transactional(propagation=Propagation.REQUIRED, rollbackFor={Exception.class})
    public DWServiceResult createCustomizeTableExpress(String masterTableName, List<ModelTable> draftModelTables) throws Exception {
        ModelPublishedEspResult executeInsertResult;
        ArrayList<String> existedTableNames = new ArrayList<String>();
        ModelDrivenContext modelDrivenContext = ModelDrivenContext.getContext();
        Map<String, Object> extraMap = modelDrivenContext.getExtraMap();
        extraMap.put("existedTables", existedTableNames);
        LinkedList<SqlParam> dmlSqlParams = new LinkedList<SqlParam>();
        LinkedList<SqlParam> ddlSqlParams = new LinkedList<SqlParam>();
        for (ModelTable draftModelTable : draftModelTables) {
            String tableName = draftModelTable.getName();
            log.info("[ModelTableHelperExpress][createCustomizeTableExpress] ----- process table({}) ----", (Object)tableName);
            List<TableColumn> draftTableColumns = draftModelTable.getColumns();
            boolean hasPrimaryKey = draftTableColumns.stream().anyMatch(Field::isPK);
            if (!hasPrimaryKey) {
                throw new IllegalArgumentException(String.format("The table(%s) must include a primary key!", tableName));
            }
            SqlParam insertRdbmsTableSqlParam = ModelSqlGenerator.generateInsertRdbmsTableSql(draftModelTable);
            dmlSqlParams.add(insertRdbmsTableSqlParam);
            List data = this.dbExecuteService.getCreateTableSqlByDBFunc(tableName);
            if (CollectionUtils.isNotEmpty((Collection)data)) {
                log.info("[ModelTableHelperExpress][createCustomizeTableExpress] --> table({}) is existed", (Object)tableName);
                existedTableNames.add(tableName);
                List<TableIndex> draftTableIndexes = draftModelTable.getIndexes();
                CreateTable ccjCreateTable = ModelSqlParserUtil.fetchCCJCreateTable(data);
                Table ccjTable = ccjCreateTable.getTable();
                String pureTableName = DBTableUtil.removeBackQuoteSymbol(ccjTable.getName());
                this.getAlterCommentInfo(pureTableName, draftModelTable.getComment(), ddlSqlParams);
                ddlSqlParams.add(ModelSqlGenerator.generateAlterTableCollationSql(pureTableName));
                List ccjColumnDefinitions = ccjCreateTable.getColumnDefinitions();
                List ccjIndexes = Optional.ofNullable(ccjCreateTable.getIndexes()).orElse(new ArrayList());
                List<TableColumn> existedTableColumns = ModelSchemaUtil.getTableColumns(ccjColumnDefinitions, ccjIndexes);
                List<TableIndex> existedTableIndexes = ModelSchemaUtil.getTableIndexes(ccjIndexes);
                TableColumn existedColumnWithAutoIncrement = existedTableColumns.stream().filter(existedColumn -> existedColumn.getAutoIncrement()).findFirst().orElse(null);
                ModelTableHelperExpress.getAlterExistedColumnsInfo(pureTableName, AlterColumnEnum.MODIFY_COLUMN, existedColumnWithAutoIncrement, ccjIndexes, ddlSqlParams, dmlSqlParams);
                ModelSchemaUtil.updateColumnsSqlParams(pureTableName, draftTableColumns, existedTableColumns, ddlSqlParams, dmlSqlParams);
                Map<AlterIndexEnum, List<TableIndex>> alterIndexesMap = ModelSqlGenerator.getExistedTableAlterIndexesMap(draftTableIndexes, existedTableIndexes, draftTableColumns, existedTableColumns);
                if (alterIndexesMap != null) {
                    alterIndexesMap.forEach((alterIndexEnum, tableColumns) -> {
                        if (!CollectionUtils.isEmpty((Collection)tableColumns)) {
                            Map<String, Object> map = ModelSqlGenerator.getAlterIndexesInfo(tableName, alterIndexEnum, tableColumns, ddlSqlParams);
                        }
                    });
                }
                ddlSqlParams.add(ModelSqlGenerator.getAddPrimaryKeyOnly(draftModelTable));
                ddlSqlParams.addAll(ModelSqlGenerator.getAlterAutoIncrementSql(draftModelTable));
                continue;
            }
            log.info("[ModelTableHelperExpress][createCustomizeTableExpress] table({}) is not existed", (Object)tableName);
            TableSqlParamDTO tableSqlParamDTO = ModelSqlGenerator.getCreateTable(draftModelTable);
            dmlSqlParams.addAll(tableSqlParamDTO.getDmlSqlParams());
            ddlSqlParams.addAll(tableSqlParamDTO.getDdlSqlParams());
        }
        boolean createSuccess = false;
        ModelDTO draftModel = modelDrivenContext.getDraftModel();
        SqlParam insertModelTableParam = ModelSqlGenerator.generateInsertModelSql(draftModel);
        dmlSqlParams.add(insertModelTableParam);
        List<SqlParam> insertModelInfoTableParam = ModelSqlGenerator.generateInsertModelInfoSql(draftModelTables, draftModel.getCode());
        dmlSqlParams.addAll(insertModelInfoTableParam);
        ModelPublishedEspResult executeCreateTableResult = this.dbExecuteService.executeCreateTableOfCreateModelDriven(ddlSqlParams, draftModel);
        if (executeCreateTableResult.getPublishStatusEnum() == PublishStatusEnum.SUCCESS && (executeInsertResult = this.dbExecuteService.executeInsertOfCreateModelDriven(dmlSqlParams, draftModel)).getPublishStatusEnum() == PublishStatusEnum.SUCCESS) {
            createSuccess = true;
        }
        return DWServiceResultBuilder.build((boolean)createSuccess, (String)"", null);
    }

    public DBTableNameCheckResult getTableNamesGeneratedByModelDriven(String sql) throws JSQLParserException {
        List<String> queryTableNames = ModelSqlParserUtil.getTables(sql);
        List<String> distinctTableNames = this.dbExecuteService.getTableNamesGeneratedByModelDriven(queryTableNames);
        DBTableNameCheckResult checkResult = new DBTableNameCheckResult();
        if (queryTableNames.size() != distinctTableNames.size()) {
            checkResult.setSqlTableNames(queryTableNames);
            checkResult.setModelTableNames(distinctTableNames);
            checkResult.setPassed(false);
        }
        return checkResult;
    }

    public CreateTable getCCJCreateTable(String tableName) throws JSQLParserException {
        CreateTable ccjCreateTable = null;
        List data = this.dbExecuteService.getCreateTableSqlByDBFunc(tableName);
        if (CollectionUtils.isNotEmpty((Collection)data)) {
            log.info("[ModelTableHelperExpress][getExistedTable] --> table({}) is existed", (Object)tableName);
            ccjCreateTable = ModelSqlParserUtil.fetchCCJCreateTable(data);
        }
        return ccjCreateTable;
    }
}

