/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.lcdp.modeldriven.utils;

import com.digiwin.lcdp.modeldriven.aop.DWEAICommonCrudInterceptor;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.FileCopyUtils;

public class SqlParserUtil {
    private static Logger logger = LoggerFactory.getLogger(DWEAICommonCrudInterceptor.class);

    public static List<String> getSql(String sqlFilePath) {
        List<String> sqlArr = new ArrayList<String>();
        try {
            InputStreamReader isr = new InputStreamReader(SqlParserUtil.class.getClassLoader().getResourceAsStream(sqlFilePath), "UTF-8");
            String sqlStr = FileCopyUtils.copyToString((Reader)isr);
            sqlArr = Arrays.asList(sqlStr.split(";\r\n"));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return sqlArr;
    }

    public static void initalSqlExecute(String dbConnectionString, String account, String password, String sqlFilePath) throws Exception {
        Connection connection = DriverManager.getConnection(dbConnectionString, account, password);
        Statement statement = connection.createStatement();
        List<String> sqls = SqlParserUtil.getSql(sqlFilePath);
        logger.debug("sqlPath:{} sqlContents:{}", (Object)sqlFilePath, sqls);
        sqls.forEach(sql -> {
            try {
                statement.addBatch((String)sql);
            }
            catch (SQLException e) {
                throw new RuntimeException(e);
            }
        });
        statement.executeBatch();
        statement.close();
    }
}

