/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.lcdp.modeldriven.service.impl;

import com.ctrip.framework.apollo.core.utils.StringUtils;
import com.digiwin.app.container.exceptions.DWException;
import com.digiwin.app.dao.DWBatchCondition;
import com.digiwin.app.dao.DWDao;
import com.digiwin.app.dao.DWOnColumn;
import com.digiwin.app.dao.DWPagableQueryInfo;
import com.digiwin.app.dao.DWPaginationQueryResult;
import com.digiwin.app.dao.DWQueryCondition;
import com.digiwin.app.dao.DWQueryInfo;
import com.digiwin.app.dao.DWQueryJoinRelation;
import com.digiwin.app.dao.DWQueryJoinTable;
import com.digiwin.app.dao.DWQueryValueOperator;
import com.digiwin.app.dao.DWSQLExecutionResult;
import com.digiwin.app.data.DWDataPermissionOption;
import com.digiwin.app.data.DWDataRow;
import com.digiwin.app.data.DWDataSet;
import com.digiwin.app.data.DWDataSetOperationOption;
import com.digiwin.app.data.DWDataTable;
import com.digiwin.app.json.gson.DWGsonProvider;
import com.digiwin.app.service.DWServiceContext;
import com.digiwin.data.permission.DWRowPermissionDefaultMatchOption;
import com.digiwin.data.permission.DWRowPermissionElement;
import com.digiwin.data.permission.DWRowPermissionEmpty;
import com.digiwin.data.permission.DWRowPermissionMatchOption;
import com.digiwin.data.permission.DWUserPermission;
import com.digiwin.data.service.DWDataPermission;
import com.digiwin.iam.HttpResponseModel;
import com.digiwin.iam.IAMService;
import com.digiwin.iam.ServiceModel;
import com.digiwin.lcdp.modeldriven.enums.ModelFieldRelationTypeEnum;
import com.digiwin.lcdp.modeldriven.model.ModelAssociatedInfo;
import com.digiwin.lcdp.modeldriven.model.ModelDTO;
import com.digiwin.lcdp.modeldriven.model.ModelFieldDTO;
import com.digiwin.lcdp.modeldriven.model.ModelIndexDTO;
import com.digiwin.lcdp.modeldriven.model.ModelSchemaDTO;
import com.digiwin.lcdp.modeldriven.model.ModelSwitchCfg;
import com.digiwin.lcdp.modeldriven.permission.ModelDrivenDataPermission;
import com.digiwin.lcdp.modeldriven.pojo.QueryConditionDTO;
import com.digiwin.lcdp.modeldriven.utils.DataEntryDataUtil;
import com.digiwin.lcdp.modeldriven.utils.ModelDataUtil;
import com.digiwin.lcdp.modeldriven.utils.ModelSchemaUtil;
import com.digiwin.lcdp.modeldriven.utils.QueryConditionUtils;
import com.digiwin.utils.DWTenantUtils;
import com.google.gson.Gson;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Queue;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;

@Service
public class ModelDataEntryService {
    private static final Logger _log = LoggerFactory.getLogger(ModelDataEntryService.class);
    private static final String _log_prefix = "[DataEntryService] ";
    private static final String _internal_dbSubName = "dbSubName";
    private static final String _internal_userSubName = "userSubName";
    private static final String _internal_dataInfo = "tableDataInfo";
    private static final String _sql_table_existed = "select count(*) from %s where 1=2";
    private static final String INTEGRATION_ACCOUNT = "integration";
    private static final String PASSWORD_HASH = "6826CC688C4AF1BD0A8DDA2DBDF8897B";
    @Autowired
    @Qualifier(value="dw-dao")
    private DWDao dao;
    @Autowired
    QueryConditionUtils queryConditionUtils;

    public Object get(Map params) {
        DWDataTable dataTable;
        List<Map<String, Object>> dataList;
        Map paramMap = params;
        HashMap<String, Map<String, Object>> returnValue = new HashMap<String, Map<String, Object>>();
        Map queryInfoMap = MapUtils.getMap((Map)paramMap, (Object)"query_info", new HashMap());
        Map masterTableConditions = (Map)queryInfoMap.get("conditions");
        ModelSchemaDTO modelSchemaDTO = (ModelSchemaDTO)MapUtils.getObject((Map)queryInfoMap, (Object)"model", (Object)new ModelSchemaDTO());
        String masterTableName = modelSchemaDTO.getName();
        List<ModelFieldDTO> modelFieldDTOs = modelSchemaDTO.getFields();
        ArrayList<String> masterCollectionSubTables = new ArrayList<String>();
        Map<String, Object> collectionQuoteRelations = this.generateCollectionQuoteRelations(modelSchemaDTO);
        HashMap<String, Map> quoteRelations = new HashMap<String, Map>();
        for (ModelFieldDTO modelFieldDTO : modelFieldDTOs) {
            ModelFieldRelationTypeEnum fieldRelationType = ModelFieldRelationTypeEnum.valueOf(modelFieldDTO.getType());
            String fieldId = modelFieldDTO.getFieldId();
            ModelAssociatedInfo modelAssociatedInfo = modelFieldDTO.getAssociatedInfo();
            if (ModelFieldRelationTypeEnum.valueOf(modelFieldDTO.getType()) == ModelFieldRelationTypeEnum.QUOTE) {
                if (quoteRelations.containsKey(modelAssociatedInfo.getTableName())) {
                    ((Map)quoteRelations.get(modelAssociatedInfo.getTableName())).put(fieldId, modelAssociatedInfo.getAssociatedFields().stream().map(ModelFieldDTO::getFieldId).collect(Collectors.toList()));
                } else {
                    HashMap relation = new HashMap();
                    relation.put(fieldId, modelAssociatedInfo.getAssociatedFields().stream().map(ModelFieldDTO::getFieldId).collect(Collectors.toList()));
                    quoteRelations.put(modelAssociatedInfo.getTableName(), relation);
                }
            }
            if (fieldRelationType != ModelFieldRelationTypeEnum.COLLECTION) continue;
            String associatedTableName = modelAssociatedInfo.getTableName();
            masterCollectionSubTables.add(associatedTableName);
        }
        DWQueryInfo queryInfo = new DWQueryInfo();
        queryInfo.setTableName(masterTableName);
        queryInfo.addSelectField(new String[]{masterTableName + ".*"});
        quoteRelations.forEach((quoteTable, relations) -> {
            ArrayList conditions = new ArrayList();
            ArrayList quoteTableAssociatedFields = new ArrayList();
            relations.forEach((quoteFiled, asssociateFilds) -> {
                conditions.add(new DWOnColumn(quoteFiled, DWQueryValueOperator.Equals, quoteFiled));
                if (CollectionUtils.isNotEmpty((Collection)asssociateFilds)) {
                    quoteTableAssociatedFields.addAll(asssociateFilds);
                }
            });
            if (CollectionUtils.isNotEmpty(quoteTableAssociatedFields)) {
                queryInfo.addJoinTableSelectField(quoteTable, quoteTableAssociatedFields.toArray(new String[quoteTableAssociatedFields.size()]));
            }
            queryInfo.setJoinOnColumn(DWQueryJoinRelation.LeftJoin, new DWQueryJoinTable(quoteTable), conditions.toArray(new DWOnColumn[1]));
        });
        if (MapUtils.isNotEmpty((Map)masterTableConditions)) {
            masterTableConditions.forEach((key, val) -> queryInfo.addEqualInfo(key, val));
        }
        this.dealQuoteRelation(queryInfo, modelSchemaDTO);
        DWDataSetOperationOption option = new DWDataSetOperationOption();
        option.setManagementFieldEnabled(false);
        DWDataSet queryDataSet = this.dao.select(queryInfo, option);
        if (queryDataSet != null && CollectionUtils.isNotEmpty(dataList = DataEntryDataUtil.convertFromJson(dataTable = queryDataSet.getTable(masterTableName)))) {
            Map<String, Object> masterTableRow = dataList.get(0);
            returnValue.put(masterTableName, masterTableRow);
            this.generateChildernQueryByCollectionQuoteRelation(masterTableName, masterTableRow, collectionQuoteRelations, modelSchemaDTO);
        }
        DWServiceContext context = DWServiceContext.getContext();
        context.setStandardResult(false);
        return returnValue;
    }

    public Object getList(Map params) throws Exception {
        DWQueryInfo queryInfo;
        Map paramMap = params;
        Map<String, Object> returnValue = new HashMap();
        List searchInfos = (List)MapUtils.getObject((Map)paramMap, (Object)"search_info", new ArrayList());
        List sortInfos = (List)MapUtils.getObject((Map)paramMap, (Object)"sort_info", new ArrayList());
        List dataInfos = (List)MapUtils.getObject((Map)paramMap, (Object)"data_info", new ArrayList());
        String targetTableName = MapUtils.getString((Map)paramMap, (Object)"userTableName", (String)"");
        ModelDTO model = (ModelDTO)MapUtils.getObject((Map)paramMap, (Object)"model");
        ModelSchemaDTO modelSchema = model.getSchema();
        DWDataSetOperationOption option = new DWDataSetOperationOption();
        if ("Y".equals(Optional.ofNullable(modelSchema.getSwitchCfg()).orElse(new ModelSwitchCfg()).getDataPermission())) {
            String actionId = Optional.ofNullable(MapUtils.getString((Map)params, (Object)"actionId")).orElseThrow(() -> new RuntimeException("actionId of view_info can not be null"));
            String moduleId = Optional.ofNullable(MapUtils.getString((Map)params, (Object)"moduleId")).orElseThrow(() -> new RuntimeException("moduleId of view_info can not be null"));
            DWUserPermission userPermission = (DWUserPermission)ModelDrivenDataPermission.getDataPermission(moduleId, actionId, model.getAppId());
            Field rowPermissionField = DWUserPermission.class.getDeclaredField("rowPermission");
            rowPermissionField.setAccessible(true);
            DWRowPermissionElement rowPermission = (DWRowPermissionElement)rowPermissionField.get(userPermission);
            if (!userPermission.isSuperadmin() && (rowPermission instanceof DWRowPermissionEmpty || rowPermission == null)) {
                returnValue.put(targetTableName, new ArrayList());
                return returnValue;
            }
            _log.debug(String.format("[getlist permission] %s permission sql: {}", targetTableName), rowPermissionField.get(userPermission));
            option = new DWDataPermissionOption(actionId, moduleId);
            ((DWDataPermissionOption)option).setRowPermissionOption((DWRowPermissionMatchOption)new DWRowPermissionDefaultMatchOption(true));
        }
        boolean useHasNext = MapUtils.getBooleanValue((Map)paramMap, (Object)"use_has_next", (boolean)false);
        ModelDTO modelDTO = (ModelDTO)MapUtils.getObject((Map)paramMap, (Object)"model", (Object)new ModelDTO());
        ModelSchemaDTO modelSchemaDTO = modelDTO.getSchema();
        if ("tree".equals((modelSchemaDTO = this.getTargetModelSchemaDTO(targetTableName, modelSchemaDTO)).getModelType())) {
            queryInfo = new DWQueryInfo();
            queryInfo.setTableName(targetTableName);
            queryInfo.addSelectField(new String[]{targetTableName + ".*"});
            DWQueryCondition allConditions = new DWQueryCondition();
            allConditions.ANDJoin();
            queryInfo.setCondition(allConditions);
            ArrayList allInfos = new ArrayList();
            allInfos.addAll(searchInfos);
            allInfos.addAll(dataInfos);
            if (CollectionUtils.isNotEmpty(allInfos)) {
                if (allInfos.stream().anyMatch(searchInfo -> "".equals(searchInfo.get("node_no")))) {
                    allConditions.addEqualInfo("parent_node_id", (Object)"-1");
                } else {
                    DWQueryCondition searchInfoCondition = this.dealSearchInfo(searchInfos);
                    DWQueryCondition dataInfoCondition = this.dealDataInfo(dataInfos);
                    if (searchInfoCondition != null) {
                        allConditions.addCondition(searchInfoCondition);
                    }
                    if (dataInfoCondition != null) {
                        allConditions.addCondition(dataInfoCondition);
                    }
                }
            } else {
                allConditions.addEqualInfo("parent_node_id", (Object)"-1");
            }
            this.dealQuoteRelation(queryInfo, modelSchemaDTO);
            this.dealSortInfo(queryInfo, sortInfos);
            returnValue = this.getTreeListForInnerInvoke(queryInfo, option, 10);
        } else if (useHasNext) {
            int pageSize = MapUtils.getIntValue((Map)paramMap, (Object)"page_size", (int)10);
            int pageNumber = MapUtils.getIntValue((Map)paramMap, (Object)"page_no", (int)1);
            DWPagableQueryInfo queryInfo2 = new DWPagableQueryInfo();
            queryInfo2.setTableName(targetTableName);
            queryInfo2.addSelectField(new String[]{targetTableName + ".*"});
            DWQueryCondition searchInfoCondition = this.dealSearchInfo(searchInfos);
            DWQueryCondition dataInfoCondition = this.dealDataInfo(dataInfos);
            DWQueryCondition allConditions = new DWQueryCondition();
            allConditions.ANDJoin();
            if (searchInfoCondition != null) {
                allConditions.addCondition(searchInfoCondition);
            }
            if (dataInfoCondition != null) {
                allConditions.addCondition(dataInfoCondition);
            }
            queryInfo2.setCondition(allConditions);
            this.dealQuoteRelation((DWQueryInfo)queryInfo2, modelSchemaDTO);
            this.dealSortInfo((DWQueryInfo)queryInfo2, sortInfos);
            queryInfo2.setPageNumber(pageNumber);
            queryInfo2.setPageSize(pageSize);
            String pk = modelSchemaDTO.getFields().stream().filter(field -> field.isPk()).findFirst().orElseThrow(() -> new RuntimeException(String.format("%s has no PK field", targetTableName))).getFieldId();
            queryInfo2.addOrderBy(pk, false);
            returnValue = this.getListForInnerInvoke((DWQueryInfo)queryInfo2, option, true);
        } else {
            queryInfo = new DWQueryInfo();
            queryInfo.setTableName(targetTableName);
            queryInfo.addSelectField(new String[]{targetTableName + ".*"});
            DWQueryCondition searchInfoCondition = this.dealSearchInfo(searchInfos);
            DWQueryCondition dataInfoCondition = this.dealDataInfo(dataInfos);
            DWQueryCondition allConditions = new DWQueryCondition();
            allConditions.ANDJoin();
            if (searchInfoCondition != null) {
                allConditions.addCondition(searchInfoCondition);
            }
            if (dataInfoCondition != null) {
                allConditions.addCondition(dataInfoCondition);
            }
            queryInfo.setCondition(allConditions);
            this.dealQuoteRelation(queryInfo, modelSchemaDTO);
            this.dealSortInfo(queryInfo, sortInfos);
            returnValue = this.getListForInnerInvoke(queryInfo, option, false);
        }
        return returnValue;
    }

    public Map<String, Object> getListForInnerInvoke(DWQueryInfo queryInfo, DWDataSetOperationOption option, boolean page) {
        String targetTableName = queryInfo.getTableName();
        DWDataRow publishedDataRow = this.getModel(targetTableName);
        ModelSchemaDTO masterModelSchema = ModelSchemaUtil.parseModelSchema(publishedDataRow);
        ModelSchemaDTO modelSchemaDTO = this.getTargetModelSchemaDTO(targetTableName, masterModelSchema);
        Map<String, Object> collectionQuoteRelations = this.generateCollectionQuoteRelations(modelSchemaDTO);
        HashMap<String, Object> returnValue = new HashMap<String, Object>();
        if (page) {
            DWPagableQueryInfo pageQueryInfo = (DWPagableQueryInfo)queryInfo;
            int pageNumber = pageQueryInfo.getPageNumber();
            DWPaginationQueryResult queryResult = this.dao.selectWithPage(pageQueryInfo, option);
            DWDataTable dataTable = queryResult.getDataSet().getTable(targetTableName);
            List<Map<String, Object>> masterRows = DataEntryDataUtil.convertFromJson(dataTable);
            if (queryResult.getRowCount() > 0L) {
                masterRows.forEach(row -> this.generateChildernQueryByCollectionQuoteRelation(targetTableName, (Map<String, Object>)row, collectionQuoteRelations, modelSchemaDTO));
            }
            long totalRowCount = queryResult.getRowCount();
            long totalPageCount = queryResult.getPageCount();
            returnValue.put("total_results", totalRowCount);
            returnValue.put("has_next", (long)pageNumber < totalPageCount);
            returnValue.put(targetTableName, masterRows);
        } else {
            DWDataSet queryDataSet = this.dao.select(queryInfo, option);
            List<Object> dataList = new ArrayList();
            if (queryDataSet != null) {
                DWDataTable dataTable = queryDataSet.getTable(targetTableName);
                dataList = DataEntryDataUtil.convertFromJson(dataTable);
                dataList.forEach(row -> this.generateChildernQueryByCollectionQuoteRelation(targetTableName, (Map<String, Object>)row, collectionQuoteRelations, modelSchemaDTO));
            }
            returnValue.put(targetTableName, dataList);
        }
        return returnValue;
    }

    public Map<String, Object> getForInnerInvoke(DWQueryInfo queryInfo) {
        String targetTableName = queryInfo.getTableName();
        DWDataRow publishedDataRow = this.getModel(targetTableName);
        ModelSchemaDTO masterModelSchema = ModelSchemaUtil.parseModelSchema(publishedDataRow);
        Map<String, Object> collectionQuoteRelations = this.generateCollectionQuoteRelations(masterModelSchema);
        this.dealQuoteRelation(queryInfo, masterModelSchema);
        HashMap<String, Object> returnValue = new HashMap<String, Object>();
        List<Object> dataList = new ArrayList();
        DWDataSet queryDataSet = this.dao.select(queryInfo);
        if (queryDataSet.getTable(masterModelSchema.getName()).getRows().size() > 0) {
            DWDataTable dataTable = queryDataSet.getTable(targetTableName);
            dataList = DataEntryDataUtil.convertFromJson(dataTable);
            dataList.forEach(row -> this.generateChildernQueryByCollectionQuoteRelation(targetTableName, (Map<String, Object>)row, collectionQuoteRelations, masterModelSchema));
            returnValue.put(targetTableName, dataList.get(0));
        } else {
            returnValue.put(targetTableName, null);
        }
        return returnValue;
    }

    public Map<String, Object> getTreeListForInnerInvoke(DWQueryInfo queryInfo, DWDataSetOperationOption option, int maxLevel) {
        String targetTableName = queryInfo.getTableName();
        HashMap<String, Object> returnValue = new HashMap<String, Object>();
        option.setTenantEnabled(false);
        DWDataSet dataset = this.dao.select(queryInfo, option);
        List codes = dataset.getTables().getPrimaryTable().getRows().stream().map(dataRow -> dataRow.get("node_id")).collect(Collectors.toList());
        this.attachMenuChildRows(dataset, 1, maxLevel, codes.toArray(), option);
        dataset.getTable(targetTableName).getRows().forEach(row -> row.set(targetTableName, null));
        returnValue.put(targetTableName, DataEntryDataUtil.convertFromJson(dataset.getTable(targetTableName)));
        return returnValue;
    }

    public DWDataRow getModel(String tableName) {
        DWDataSetOperationOption option = new DWDataSetOperationOption();
        option.setTenantEnabled(false);
        option.setManagementFieldEnabled(false);
        DWQueryInfo queryInfo = new DWQueryInfo();
        queryInfo.setTableName("dw_lcdp_model_info");
        queryInfo.setJoinOnColumn(DWQueryJoinRelation.Join, "dw_lcdp_model", new DWOnColumn[]{new DWOnColumn("code", DWQueryValueOperator.Equals, "code")});
        queryInfo.addEqualInfo("table_name", (Object)tableName);
        queryInfo.addSelectField(new String[]{"dw_lcdp_model.*"});
        DWDataRow dataRow = this.dao.selectOne(queryInfo, option);
        return dataRow;
    }

    public void dealSortInfo(DWQueryInfo queryInfo, List<Map<String, Object>> sortInfos) {
        if (CollectionUtils.isNotEmpty(sortInfos)) {
            Collections.sort(sortInfos, Comparator.comparingDouble(item -> Double.parseDouble(item.get("sort_seq").toString())));
            sortInfos.forEach(sortInfo -> {
                switch (sortInfo.get("sort_type").toString()) {
                    case "asc": {
                        queryInfo.addOrderBy(sortInfo.get("sort_field").toString(), true);
                        break;
                    }
                    case "desc": {
                        queryInfo.addOrderBy(sortInfo.get("sort_field").toString(), false);
                        break;
                    }
                }
            });
        }
    }

    public DWQueryCondition dealSearchInfo(List<Map<String, Object>> searchInfos) {
        if (CollectionUtils.isNotEmpty(searchInfos)) {
            Collections.sort(searchInfos, Comparator.comparingDouble(item -> Double.parseDouble(item.get("order").toString())));
            DWQueryCondition condition = new DWQueryCondition();
            this.generateCondition(searchInfos.iterator(), condition);
            return condition;
        }
        return null;
    }

    public DWQueryCondition dealDataInfo(List<Map<String, Object>> dataInfos) {
        if (CollectionUtils.isNotEmpty(dataInfos)) {
            DWQueryCondition condition = new DWQueryCondition();
            condition.ORJoin();
            dataInfos.forEach(dataInfo -> {
                DWQueryCondition rowCondition = new DWQueryCondition();
                dataInfo.forEach((key, val) -> rowCondition.addEqualInfo(key, val));
                condition.addCondition(rowCondition);
            });
            return condition;
        }
        return null;
    }

    private DWQueryCondition generateCondition(Iterator it, DWQueryCondition condition) {
        return this.generateCondition(it, condition, null);
    }

    private DWQueryCondition generateCondition(Iterator it, DWQueryCondition condition, String logic) {
        while (it.hasNext()) {
            Map currentSearchInfo = (Map)it.next();
            if ("(".equals(currentSearchInfo.get("bracket"))) {
                DWQueryCondition childCondition = new DWQueryCondition();
                condition.addCondition(childCondition);
                this.dealSearchInfoCondition(childCondition, currentSearchInfo, logic);
                this.generateCondition(it, childCondition, (String)currentSearchInfo.get("logic"));
                continue;
            }
            if (")".equals(currentSearchInfo.get("bracket"))) {
                if (!StringUtils.isEmpty((String)((String)currentSearchInfo.get("logic")))) {
                    this.dealSearchInfoCondition(condition, currentSearchInfo, logic);
                    this.generateCondition(it, condition.getParentCondition(), (String)currentSearchInfo.get("logic"));
                    continue;
                }
                this.dealSearchInfoCondition(condition, currentSearchInfo, logic);
                this.generateCondition(it, condition.getParentCondition(), (String)currentSearchInfo.get("logic"));
                continue;
            }
            this.dealSearchInfoCondition(condition, currentSearchInfo, logic);
            this.generateCondition(it, condition, (String)currentSearchInfo.get("logic"));
        }
        return condition;
    }

    private DWQueryCondition dealSearchInfoCondition(DWQueryCondition condition, Map<String, Object> searchInfo, String logic) {
        if (CollectionUtils.isNotEmpty((Collection)((List)searchInfo.get("search_value")))) {
            switch (searchInfo.get("search_operator").toString()) {
                case "equal": {
                    condition.addFieldInfo(searchInfo.get("search_field").toString(), DWQueryValueOperator.Equals, new Object[]{CollectionUtils.get((Object)searchInfo.get("search_value"), (int)0)});
                    break;
                }
                case "greater_equal": {
                    condition.addFieldInfo(searchInfo.get("search_field").toString(), DWQueryValueOperator.GreaterThanOrEqualTo, new Object[]{CollectionUtils.get((Object)searchInfo.get("search_value"), (int)0)});
                    break;
                }
                case "less_equal": {
                    condition.addFieldInfo(searchInfo.get("search_field").toString(), DWQueryValueOperator.LessThanOrEqualTo, new Object[]{CollectionUtils.get((Object)searchInfo.get("search_value"), (int)0)});
                    break;
                }
                case "greater": {
                    condition.addFieldInfo(searchInfo.get("search_field").toString(), DWQueryValueOperator.GreaterThan, new Object[]{CollectionUtils.get((Object)searchInfo.get("search_value"), (int)0)});
                    break;
                }
                case "less": {
                    condition.addFieldInfo(searchInfo.get("search_field").toString(), DWQueryValueOperator.LessThan, new Object[]{CollectionUtils.get((Object)searchInfo.get("search_value"), (int)0)});
                    break;
                }
                case "not_equal": {
                    condition.addFieldInfo(searchInfo.get("search_field").toString(), DWQueryValueOperator.NotEquals, new Object[]{CollectionUtils.get((Object)searchInfo.get("search_value"), (int)0)});
                    break;
                }
                case "like_r": {
                    condition.addFieldInfo(searchInfo.get("search_field").toString(), DWQueryValueOperator.Like, new Object[]{CollectionUtils.get((Object)searchInfo.get("search_value").toString().replaceAll("%", "\\\\%"), (int)0) + "%"});
                    break;
                }
                case "like": {
                    condition.addFieldInfo(searchInfo.get("search_field").toString(), DWQueryValueOperator.Like, new Object[]{"%" + CollectionUtils.get((Object)searchInfo.get("search_value"), (int)0).toString().replaceAll("%", "\\\\%") + "%"});
                    break;
                }
                case "l_like": {
                    condition.addFieldInfo(searchInfo.get("search_field").toString(), DWQueryValueOperator.Like, new Object[]{"%" + CollectionUtils.get((Object)searchInfo.get("search_value"), (int)0).toString().replaceAll("%", "\\\\%")});
                    break;
                }
                case "not_like": {
                    condition.addFieldInfo(searchInfo.get("search_field").toString(), DWQueryValueOperator.NotLike, new Object[]{"%" + CollectionUtils.get((Object)searchInfo.get("search_value"), (int)0).toString().replaceAll("%", "\\\\%") + "%"});
                    break;
                }
                case "exist": {
                    condition.addFieldInfo(searchInfo.get("search_field").toString(), DWQueryValueOperator.In, ((List)searchInfo.get("search_value")).toArray(new Object[1]));
                    break;
                }
                case "not exist": {
                    condition.addFieldInfo(searchInfo.get("search_field").toString(), DWQueryValueOperator.NotIn, ((List)searchInfo.get("search_value")).toArray(new Object[1]));
                    break;
                }
                case "between": {
                    condition.addFieldInfo(searchInfo.get("search_field").toString(), DWQueryValueOperator.Between, ((List)searchInfo.get("search_value")).toArray(new Object[1]));
                    break;
                }
            }
        }
        if ("OR".equals(logic)) {
            condition.ORJoin();
        } else {
            condition.ANDJoin();
        }
        return condition;
    }

    private void dealQuoteRelation(DWQueryInfo queryInfo, ModelSchemaDTO modelSchemaDTO) {
        List quoteQueryFields;
        List<ModelFieldDTO> modelFieldDTOs = modelSchemaDTO.getFields();
        if (CollectionUtils.isNotEmpty(modelFieldDTOs) && CollectionUtils.isNotEmpty(quoteQueryFields = modelFieldDTOs.stream().filter(modelField -> ModelFieldRelationTypeEnum.valueOf(modelField.getType()) == ModelFieldRelationTypeEnum.QUOTE_QUERY).collect(Collectors.toList()))) {
            for (int i = 0; i < quoteQueryFields.size(); ++i) {
                ModelFieldDTO quoteQueryField = (ModelFieldDTO)quoteQueryFields.get(i);
                String fieldId = quoteQueryField.getFieldId();
                String quoteFieldId = quoteQueryField.getAssociatedInfo().getJoinField().getFieldId();
                String quoteTableName = quoteQueryField.getAssociatedInfo().getTableName();
                String quoteTableAlias = this.generateTableAlias(i);
                List<ModelFieldDTO> fieldAssociatedFields = quoteQueryField.getAssociatedInfo().getAssociatedFields();
                ArrayList<DWOnColumn> conditions = new ArrayList<DWOnColumn>();
                conditions.add(new DWOnColumn(quoteFieldId, DWQueryValueOperator.Equals, fieldId));
                ArrayList selectFields = new ArrayList();
                fieldAssociatedFields.forEach(associatedField -> {
                    String selectField = quoteTableAlias + "." + associatedField.getFieldId() + " AS " + associatedField.getAlias().getFieldId();
                    selectFields.add(selectField);
                });
                queryInfo.addSelectField(selectFields.toArray(new String[selectFields.size()]));
                queryInfo.setJoinOnColumn(DWQueryJoinRelation.LeftJoin, new DWQueryJoinTable(quoteTableName, quoteTableAlias), conditions.toArray(new DWOnColumn[conditions.size()]));
            }
        }
    }

    public Map<String, Object> generateCollectionQuoteRelations(ModelSchemaDTO modelSchemaDTO) {
        LinkedHashMap<String, Object> collectionQuoteRelations = new LinkedHashMap<String, Object>();
        ArrayList<String> masterCollectionSubTables = new ArrayList<String>();
        String masterTableName = modelSchemaDTO.getName();
        for (ModelFieldDTO modelFieldDTO : modelSchemaDTO.getFields()) {
            ModelFieldRelationTypeEnum fieldRelationType = ModelFieldRelationTypeEnum.valueOf(modelFieldDTO.getType());
            ModelAssociatedInfo modelAssociatedInfo = modelFieldDTO.getAssociatedInfo();
            if (fieldRelationType != ModelFieldRelationTypeEnum.COLLECTION) continue;
            if (modelAssociatedInfo == null) {
                throw new RuntimeException(String.format("collection field '%s' miss attribute 'associatedInfo'", modelFieldDTO.getFieldName()));
            }
            String associatedTableName = modelAssociatedInfo.getTableName();
            masterCollectionSubTables.add(associatedTableName);
        }
        List<ModelSchemaDTO> subTables = modelSchemaDTO.getChildren();
        subTables.stream().filter(subTable -> masterCollectionSubTables.contains(subTable.getName())).forEach(subTable -> {
            LinkedHashMap<String, Map<String, Object>> quateRelations = new LinkedHashMap<String, Map<String, Object>>();
            subTable.getFields().stream().filter(field -> ModelFieldRelationTypeEnum.QUOTE.getValue().equals(field.getType()) && masterTableName.equals(field.getAssociatedInfo().getTableName())).forEach(field -> {
                if (field.getAssociatedInfo().getAssociatedFields() != null) {
                    List associatedFields = field.getAssociatedInfo().getAssociatedFields().stream().map(ModelFieldDTO::getFieldId).collect(Collectors.toList());
                    quateRelations.put(field.getFieldId(), (Map<String, Object>)((Object)associatedFields));
                } else {
                    quateRelations.put(field.getFieldId(), (Map<String, Object>)((Object)new ArrayList()));
                }
            });
            collectionQuoteRelations.put(subTable.getName(), quateRelations);
            Map<String, Object> subsubRelation = this.generateCollectionQuoteRelations((ModelSchemaDTO)subTable);
            if (MapUtils.isNotEmpty(subsubRelation)) {
                quateRelations.put("#subRelation", subsubRelation);
            }
        });
        return collectionQuoteRelations;
    }

    private Map<String, Object> generateChildernQueryByCollectionQuoteRelation(String masterTableName, Map<String, Object> masterTableRow, Map<String, Object> collectionQuoteRelations, ModelSchemaDTO modelSchemaDTO) {
        collectionQuoteRelations.forEach((subTableName, relations) -> {
            DWQueryInfo queryinfo = new DWQueryInfo();
            queryinfo.setTableName(subTableName);
            queryinfo.addSelectField(new String[]{subTableName + ".*"});
            DWQueryCondition subTableQueryCondition = new DWQueryCondition();
            ArrayList tableAssociatedFields = new ArrayList();
            ArrayList conditions = new ArrayList();
            ((Map)collectionQuoteRelations.get(subTableName)).forEach((masterField, associatedFields) -> {
                if (!"#subRelation".equals(masterField)) {
                    subTableQueryCondition.addEqualInfo(masterField, masterTableRow.get(masterField));
                    tableAssociatedFields.addAll((List)associatedFields);
                    conditions.add(new DWOnColumn(masterField, DWQueryValueOperator.Equals, masterField));
                }
            });
            if (CollectionUtils.isNotEmpty(tableAssociatedFields)) {
                queryinfo.addJoinTableSelectField(masterTableName, tableAssociatedFields.toArray(new String[1]));
            }
            ModelSchemaDTO subModelSchemaDTO = modelSchemaDTO.getChildren().stream().filter(schema -> schema.getName().equals(subTableName)).findFirst().get();
            this.dealQuoteRelation(queryinfo, subModelSchemaDTO);
            queryinfo.setJoinOnColumn(DWQueryJoinRelation.LeftJoin, new DWQueryJoinTable(masterTableName), conditions.toArray(new DWOnColumn[1]));
            queryinfo.setCondition(subTableQueryCondition);
            DWDataTable childrenResult = this.dao.select(queryinfo).getTable(subTableName);
            List<Map<String, Object>> dataList = DataEntryDataUtil.convertFromJson(childrenResult);
            masterTableRow.put((String)subTableName, dataList);
            Map subRelation = (Map)((Map)collectionQuoteRelations.get(subTableName)).get("#subRelation");
            if (subRelation != null) {
                dataList.forEach(childData -> this.generateChildernQueryByCollectionQuoteRelation((String)subTableName, (Map<String, Object>)childData, subRelation, subModelSchemaDTO));
            }
        });
        return masterTableRow;
    }

    public void departSubTableFields(ModelSchemaDTO modelSchema, List<Map<String, Object>> masterTableParams, Map<String, List<Map<String, Object>>> result) {
        Map<String, Object> collectionQuoteRelations = this.generateCollectionQuoteRelations(modelSchema);
        DataEntryDataUtil.convertToJson(masterTableParams, modelSchema.getName());
        if (result.get(modelSchema.getName()) != null) {
            result.get(modelSchema.getName()).addAll(masterTableParams);
        } else {
            result.put(modelSchema.getName(), masterTableParams);
        }
        masterTableParams.forEach(masterTableParam -> {
            List<ModelSchemaDTO> childrenModelSchema = modelSchema.getChildren();
            if (CollectionUtils.isNotEmpty(childrenModelSchema)) {
                for (ModelSchemaDTO childModelFieldDTO : childrenModelSchema) {
                    String subTableName = childModelFieldDTO.getName();
                    List subTableParams = (List)masterTableParam.get(subTableName);
                    if (CollectionUtils.isNotEmpty((Collection)subTableParams)) {
                        Map quoteRelations = (Map)collectionQuoteRelations.get(subTableName);
                        if (MapUtils.isEmpty((Map)quoteRelations)) {
                            throw new RuntimeException(String.format("can't find collection associatedInfo of subtable '%s' ", subTableName));
                        }
                        quoteRelations.keySet().forEach(field -> subTableParams.forEach(subTableRow -> subTableRow.put(field, masterTableParam.get(field))));
                        this.departSubTableFields(childModelFieldDTO, subTableParams, result);
                    }
                    masterTableParam.remove(subTableName);
                }
            }
        });
    }

    private boolean checkTableExist(String dbTableName) {
        boolean tableExisted = true;
        try {
            DWDataSetOperationOption option = new DWDataSetOperationOption();
            option.setTenantEnabled(false);
            DWQueryInfo queryInfo = new DWQueryInfo();
            queryInfo.setTableName(dbTableName);
            String checkSql = String.format(_sql_table_existed, dbTableName);
            this.dao.select(queryInfo, checkSql, option);
        }
        catch (Exception e) {
            tableExisted = false;
            _log.warn(String.format("%s realTableName(%s) is not valid", _log_prefix, dbTableName));
        }
        return tableExisted;
    }

    public Map getRowInfo(DWQueryInfo queryInfo) {
        DWDataSetOperationOption option = new DWDataSetOperationOption();
        DWDataRow dataRow = this.dao.selectOne(queryInfo, option);
        Map rowMap = dataRow.getData();
        return rowMap;
    }

    public ModelSchemaDTO getTargetModelSchemaDTO(String targetTableName, ModelSchemaDTO masterModelDTO) {
        if (masterModelDTO.getName().equals(targetTableName)) {
            return masterModelDTO;
        }
        List<ModelSchemaDTO> childrenModelSchemaDTOs = masterModelDTO.getChildren();
        if (CollectionUtils.isNotEmpty(childrenModelSchemaDTOs)) {
            for (ModelSchemaDTO childrenModelSchemaDTO : childrenModelSchemaDTOs) {
                if (childrenModelSchemaDTO.getName().equals(targetTableName)) {
                    return childrenModelSchemaDTO;
                }
                List<ModelSchemaDTO> cchildrenModelSchemaDTOs = childrenModelSchemaDTO.getChildren();
                if (!CollectionUtils.isNotEmpty(cchildrenModelSchemaDTOs)) continue;
                return this.getTargetModelSchemaDTO(targetTableName, childrenModelSchemaDTO);
            }
            return null;
        }
        return null;
    }

    public ModelIndexDTO getUniqueIndex(ModelSchemaDTO masterModelSchema, String targetTableName) {
        List indexLst = masterModelSchema.getIndex().stream().filter(index -> index.getType().toLowerCase().equals("unique")).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(indexLst)) {
            throw new RuntimeException(String.format("table '%s' unique index is null", targetTableName));
        }
        return (ModelIndexDTO)indexLst.get(0);
    }

    public String generateTableAlias(int num) {
        if (num > 702) {
            throw new RuntimeException("too many join tables,please contact lcdp developers");
        }
        int hignNum = num / 26;
        if (hignNum >= 1) {
            char[] code = new char[]{(char)((char)hignNum + 96), (char)((char)(num - hignNum * 26) + 97)};
            return new String(code);
        }
        char[] code = new char[]{(char)((char)num + 97)};
        return new String(code);
    }

    private void attachMenuChildRows(DWDataSet dataset, int currentLevel, int maxLevel, Object[] codeFieldInfo, DWDataSetOperationOption option) {
        if (++currentLevel > maxLevel) {
            return;
        }
        String tableName = dataset.getTables().getPrimaryTable().getName();
        ArrayList masterRows = new ArrayList();
        masterRows.addAll(dataset.getTables().getPrimaryTable().getRows().stream().collect(Collectors.toList()));
        for (DWDataRow row : masterRows) {
            DWQueryInfo queryInfo = new DWQueryInfo(tableName);
            queryInfo.addEqualInfo("parent_node_id", row.get("node_id"));
            DWDataSet childMenuDataset = option == null ? this.dao.select(queryInfo) : this.dao.select(queryInfo, option);
            this.attachMenuChildRows(childMenuDataset, currentLevel, maxLevel, codeFieldInfo, option);
            row.set(tableName, (Object)childMenuDataset);
        }
    }

    public Object getTBBDataPermission(String appId, String moduleId, String actionId, String tenantId, String userId) throws Exception {
        String integrationToken = null;
        HashMap<String, String> integrationTokenParams = new HashMap<String, String>();
        integrationTokenParams.put("tenantId", tenantId);
        integrationTokenParams.put("userId", INTEGRATION_ACCOUNT);
        integrationTokenParams.put("passwordHash", PASSWORD_HASH);
        ServiceModel integrationTokenModel = new ServiceModel();
        integrationTokenModel.setInvokeURL("/api/iam/v2/identity/login/internal");
        integrationTokenModel.setParams(integrationTokenParams);
        HttpResponseModel integrationTokenResponseModel = (HttpResponseModel)IAMService.invoke((ServiceModel)integrationTokenModel);
        String integrationTokenResponseBody = integrationTokenResponseModel.getResponseBody();
        if (integrationTokenResponseModel.getHttpStatusCode() != 200) {
            String errorMessage = "<<< get IAM integrationToken failed ,response code:'%s', message:'%s'";
            throw new DWException(String.format(errorMessage, integrationTokenResponseModel.getHttpStatusCode(), integrationTokenResponseBody));
        }
        Map result = (Map)DWGsonProvider.getGson().fromJson(integrationTokenResponseBody, Map.class);
        integrationToken = MapUtils.getString((Map)result, (Object)"token");
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("userId", userId);
        params.put("sysId", appId);
        params.put("moduleId", moduleId);
        params.put("actionId", actionId);
        params.put("self", true);
        ServiceModel serviceModel = new ServiceModel();
        serviceModel.setInvokeURL("/api/iam/v2/permission/data");
        serviceModel.setParams(params);
        serviceModel.setToken(integrationToken);
        HttpResponseModel iamResponseModel = (HttpResponseModel)IAMService.invoke((ServiceModel)serviceModel);
        String iamResponseBody = iamResponseModel.getResponseBody();
        int iamResponseStatusCode = iamResponseModel.getHttpStatusCode();
        if (iamResponseStatusCode != 200) {
            String errorMessage = "<<< get IAM permission data failed response code:'%s', message:'%s'";
            throw new DWException(String.format(errorMessage, iamResponseStatusCode, errorMessage));
        }
        Method getCustomGsonMethod = DWDataPermission.class.getDeclaredMethod("getCustomGson", new Class[0]);
        getCustomGsonMethod.setAccessible(true);
        Gson gson = (Gson)getCustomGsonMethod.invoke(DWDataPermission.class, new Object[0]);
        return gson.fromJson(iamResponseBody, DWUserPermission.class);
    }

    public List<Map<String, Object>> insertRows(ModelSchemaDTO parentModelSchema, List<Map<String, Object>> parentTableRows) {
        ArrayList<Map<String, Object>> businessKeys = new ArrayList<Map<String, Object>>();
        parentTableRows.forEach(masterTableRow -> {
            List<String> childTableNames = parentModelSchema.getChildren().stream().map(ModelSchemaDTO::getName).collect(Collectors.toList());
            HashMap<String, List> childTableRowMap = new HashMap<String, List>();
            childTableNames.forEach(childTableName -> {
                if (masterTableRow.keySet().contains(childTableName)) {
                    childTableRowMap.put((String)childTableName, (List)masterTableRow.get(childTableName));
                    masterTableRow.remove(childTableName);
                }
            });
            ModelSchemaUtil.dealSpecialTypeDatas(masterTableRow, parentModelSchema);
            masterTableRow.putAll(ModelDataUtil.getInsertMgmtFields());
            DWDataSet dataSet = new DWDataSet();
            String parentTableName = parentModelSchema.getName();
            DWDataTable dataTable = dataSet.newTable(parentTableName);
            dataTable.newRow(masterTableRow).setState("C");
            DWDataSetOperationOption option = new DWDataSetOperationOption();
            option.setManagementFieldEnabled(false);
            DWSQLExecutionResult execute = null;
            execute = this.dao.execute(dataSet, option);
            Optional<ModelFieldDTO> pkField = parentModelSchema.getFields().stream().filter(field -> field.getAutoIncrement() && field.isPk()).findFirst();
            if (pkField.isPresent()) {
                Object autoIncrementKey = ((List)execute.getGeneratedKeys().get(parentTableName)).get(0);
                masterTableRow.put(pkField.get().getFieldId(), autoIncrementKey);
            }
            ModelIndexDTO uniqueIndex = this.getUniqueIndex(parentModelSchema, parentModelSchema.getName());
            HashMap businessKey = new HashMap();
            uniqueIndex.getMember().forEach(bkField -> businessKey.put(bkField, masterTableRow.get(bkField)));
            businessKeys.add(businessKey);
            Map<String, Object> collectionQuoteRelations = this.generateCollectionQuoteRelations(parentModelSchema);
            childTableRowMap.forEach((subTableName, subTableRows) -> {
                if (CollectionUtils.isNotEmpty((Collection)subTableRows)) {
                    Map quoteRelations = (Map)collectionQuoteRelations.get(subTableName);
                    if (MapUtils.isEmpty((Map)quoteRelations)) {
                        throw new RuntimeException(String.format("can't find collection associatedInfo of subtable '%s' ", subTableName));
                    }
                    quoteRelations.keySet().forEach(field -> subTableRows.forEach(subTableRow -> subTableRow.put(field, masterTableRow.get(field))));
                }
            });
            childTableRowMap.forEach((subTableName, subTableRows) -> {
                Optional<ModelSchemaDTO> childModelSchema = parentModelSchema.getChildren().stream().filter(model -> model.getName().equals(subTableName)).findFirst();
                if (!childModelSchema.isPresent()) {
                    throw new RuntimeException(String.format("can not find subModelSchema %s in parentModelSchema %s", subTableName, parentTableName));
                }
                this.insertRows(childModelSchema.get(), (List<Map<String, Object>>)subTableRows);
            });
        });
        return businessKeys;
    }

    public List<Map<String, Object>> updateRows(ModelSchemaDTO modelSchema, List<Map<String, Object>> tableRows, boolean isParent) {
        ArrayList<Map<String, Object>> businessKeys = new ArrayList<Map<String, Object>>();
        if (isParent) {
            tableRows.forEach(masterTableRow -> {
                List<String> childTableNames = modelSchema.getChildren().stream().map(ModelSchemaDTO::getName).collect(Collectors.toList());
                HashMap<String, List> childTableRowMap = new HashMap<String, List>();
                childTableNames.forEach(childTableName -> {
                    if (masterTableRow.keySet().contains(childTableName)) {
                        childTableRowMap.put((String)childTableName, (List)masterTableRow.get(childTableName));
                        masterTableRow.remove(childTableName);
                    }
                });
                ModelSchemaUtil.dealSpecialTypeDatas(masterTableRow, modelSchema);
                masterTableRow.putAll(ModelDataUtil.getUpdateMgmtFields());
                DWDataSet dataSet = new DWDataSet();
                String parentTableName = modelSchema.getName();
                DWDataTable dataTable = dataSet.newTable(parentTableName);
                dataTable.newRow(masterTableRow).setState("U");
                DWDataSetOperationOption option = new DWDataSetOperationOption();
                option.setManagementFieldEnabled(false);
                this.dao.execute(dataSet, option);
                ModelIndexDTO uniqueIndex = this.getUniqueIndex(modelSchema, modelSchema.getName());
                HashMap businessKey = new HashMap();
                uniqueIndex.getMember().forEach(bkField -> businessKey.put(bkField, masterTableRow.get(bkField)));
                businessKeys.add(businessKey);
                Map<String, Object> collectionQuoteRelations = this.generateCollectionQuoteRelations(modelSchema);
                childTableRowMap.forEach((subTableName, subTableRows) -> {
                    if (CollectionUtils.isNotEmpty((Collection)subTableRows)) {
                        Map quoteRelations = (Map)collectionQuoteRelations.get(subTableName);
                        if (MapUtils.isEmpty((Map)quoteRelations)) {
                            throw new RuntimeException(String.format("can't find collection associatedInfo of subtable '%s' ", subTableName));
                        }
                        quoteRelations.keySet().forEach(field -> subTableRows.forEach(subTableRow -> subTableRow.put(field, masterTableRow.get(field))));
                    }
                });
                childTableRowMap.forEach((subTableName, subTableRows) -> {
                    Optional<ModelSchemaDTO> childModelSchema = modelSchema.getChildren().stream().filter(model -> model.getName().equals(subTableName)).findFirst();
                    if (!childModelSchema.isPresent()) {
                        throw new RuntimeException(String.format("can not find subModelSchema %s in parentModelSchema %s", subTableName, parentTableName));
                    }
                    this.updateRows(childModelSchema.get(), (List<Map<String, Object>>)subTableRows, false);
                });
            });
        } else {
            this.insertRows(modelSchema, tableRows);
        }
        return businessKeys;
    }

    public List<Map<String, Object>> batchUpdateRows(ModelSchemaDTO modelSchema, List<Map<String, Object>> tableRows, boolean isParent) {
        ArrayList<Map<String, Object>> businessKeys = new ArrayList<Map<String, Object>>();
        if (isParent) {
            tableRows.forEach(masterTableRow -> {
                List<String> childTableNames = modelSchema.getChildren().stream().map(ModelSchemaDTO::getName).collect(Collectors.toList());
                HashMap<String, List> childTableRowMap = new HashMap<String, List>();
                childTableNames.forEach(childTableName -> {
                    if (masterTableRow.keySet().contains(childTableName)) {
                        childTableRowMap.put((String)childTableName, (List)masterTableRow.get(childTableName));
                        masterTableRow.remove(childTableName);
                    }
                });
                ModelSchemaUtil.dealSpecialTypeDatas(masterTableRow, modelSchema);
                masterTableRow.putAll(ModelDataUtil.getUpdateMgmtFields());
                DWDataSet dataSet = new DWDataSet();
                String parentTableName = modelSchema.getName();
                DWDataTable dataTable = dataSet.newTable(parentTableName);
                dataTable.newRow(masterTableRow).setState("U");
                DWDataSetOperationOption option = new DWDataSetOperationOption();
                option.setManagementFieldEnabled(false);
                this.dao.execute(dataSet, option);
                ModelIndexDTO uniqueIndex = this.getUniqueIndex(modelSchema, modelSchema.getName());
                HashMap businessKey = new HashMap();
                uniqueIndex.getMember().forEach(bkField -> businessKey.put(bkField, masterTableRow.get(bkField)));
                businessKeys.add(businessKey);
                Map<String, Object> collectionQuoteRelations = this.generateCollectionQuoteRelations(modelSchema);
                childTableRowMap.forEach((subTableName, subTableRows) -> {
                    if (CollectionUtils.isNotEmpty((Collection)subTableRows)) {
                        Map quoteRelations = (Map)collectionQuoteRelations.get(subTableName);
                        if (MapUtils.isEmpty((Map)quoteRelations)) {
                            throw new RuntimeException(String.format("can't find collection associatedInfo of subtable '%s' ", subTableName));
                        }
                        quoteRelations.keySet().forEach(field -> subTableRows.forEach(subTableRow -> subTableRow.put(field, masterTableRow.get(field))));
                    }
                });
                childTableRowMap.forEach((subTableName, subTableRows) -> {
                    Optional<ModelSchemaDTO> childModelSchema = modelSchema.getChildren().stream().filter(model -> model.getName().equals(subTableName)).findFirst();
                    if (!childModelSchema.isPresent()) {
                        throw new RuntimeException(String.format("can not find subModelSchema %s in parentModelSchema %s", subTableName, parentTableName));
                    }
                    this.updateRows(childModelSchema.get(), (List<Map<String, Object>>)subTableRows, false);
                });
            });
        } else {
            this.insertRows(modelSchema, tableRows);
        }
        return businessKeys;
    }

    public Queue deleteRows(ModelSchemaDTO modelSchema, List<Map<String, Object>> businessKeys, String rootTableName, Queue<String> queue) {
        return this.deleteRows("delete @targetTable@ from @targetTable@ @joinTable@", modelSchema, businessKeys, queue);
    }

    public Queue deleteRows(String sql, ModelSchemaDTO modelSchema, List<Map<String, Object>> businessKeys, Queue<String> queue) {
        Map<String, Object> collectionQuoteRelations = this.generateCollectionQuoteRelations(modelSchema);
        if (MapUtils.isNotEmpty(collectionQuoteRelations)) {
            Set<String> tableNames = collectionQuoteRelations.keySet();
            String parentTableName = modelSchema.getName();
            for (String tableName : tableNames) {
                Map quoteField = (Map)collectionQuoteRelations.get(tableName);
                String deleteSql = sql;
                ArrayList conditions = new ArrayList();
                quoteField.forEach((key, val) -> {
                    if (!key.equals("#subRelation")) {
                        conditions.add(String.format("%s.%s = %s.%s", modelSchema.getName(), key, tableName, key));
                    }
                });
                String tmp = String.format(" @joinTable@ left join %s on ", parentTableName) + String.join((CharSequence)" and ", conditions);
                deleteSql = deleteSql.replace("@joinTable@", tmp);
                Set keys = quoteField.keySet();
                for (String key2 : keys) {
                    if (!key2.equals("#subRelation")) continue;
                    ModelSchemaDTO subModelSchema = modelSchema.getChildren().stream().filter(model -> model.getName().equals(tableName)).findFirst().get();
                    this.deleteRows(deleteSql, subModelSchema, businessKeys, queue);
                }
                deleteSql = deleteSql + " where ";
                conditions.clear();
                businessKeys.forEach(businessKey -> businessKey.forEach((key, val) -> conditions.add(String.format("%s.%s = %s", parentTableName, key, val instanceof String ? "'" + val + "'" : val))));
                deleteSql = deleteSql + String.join((CharSequence)" and ", conditions);
                if (DWTenantUtils.isTenantenabled()) {
                    deleteSql = deleteSql + String.format(" and %s.%s = %s", tableName, DWTenantUtils.getTenantColumnName(), DWServiceContext.getContext().getProfile().get(DWTenantUtils.getIAMTenantSidKey()));
                }
                queue.add(deleteSql.replace("@targetTable@", tableName).replace("@joinTable@", ""));
            }
        }
        return queue;
    }

    public Map<String, Object> updateMainRowsByQueryConditions(List<QueryConditionDTO> queryConditions, ModelSchemaDTO modelSchema, List<Map<String, Object>> mainTableRows) {
        DWQueryCondition dwQueryCondition = new DWQueryCondition();
        DWBatchCondition dwBatchCondition = new DWBatchCondition();
        this.queryConditionUtils.generateCondition(queryConditions.iterator(), dwQueryCondition, "");
        this.queryConditionUtils.generateCondition(queryConditions.iterator(), (DWQueryCondition)dwBatchCondition, "");
        DWDataSet dataset = new DWDataSet();
        DWDataTable dwDataTable = dataset.newTable(modelSchema.getName());
        mainTableRows.forEach(masterRow -> dwDataTable.newRow(masterRow).setState("U").setCondition((DWQueryCondition)dwBatchCondition));
        DWDataSetOperationOption option = new DWDataSetOperationOption();
        option.setManagementFieldEnabled(false);
        option.getUpdateOption().setEnableBatchCondition(true);
        this.dao.execute(dataset, option);
        DWQueryInfo info = new DWQueryInfo(modelSchema.getName());
        info.setCondition(dwQueryCondition);
        Map<String, Object> resultValue = this.getListForInnerInvoke(info, new DWDataSetOperationOption(), false);
        return resultValue;
    }
}

