/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.lcdp.modeldriven.service.impl;

import com.digiwin.app.dao.DWBatchCondition;
import com.digiwin.app.dao.DWDao;
import com.digiwin.app.dao.DWQueryInfo;
import com.digiwin.app.dao.DWQueryInfoBuilder;
import com.digiwin.app.dao.DWQueryValueOperator;
import com.digiwin.app.dao.DWSQLExecutionResult;
import com.digiwin.app.dao.DWServiceResultBuilder;
import com.digiwin.app.data.DWDataRow;
import com.digiwin.app.data.DWDataSet;
import com.digiwin.app.data.DWDataSetBuilder;
import com.digiwin.app.data.DWDataSetOperationOption;
import com.digiwin.app.service.DWServiceContext;
import com.digiwin.app.service.DWServiceResult;
import com.digiwin.lcdp.modeldriven.context.ModelDrivenContext;
import com.digiwin.lcdp.modeldriven.enums.PublishStatusEnum;
import com.digiwin.lcdp.modeldriven.model.ModelDTO;
import com.digiwin.lcdp.modeldriven.model.ModelOidDTO;
import com.digiwin.lcdp.modeldriven.model.ModelPublishedEspResult;
import com.digiwin.lcdp.modeldriven.model.ModelSchemaDTO;
import com.digiwin.lcdp.modeldriven.model.ModelTable;
import com.digiwin.lcdp.modeldriven.model.SqlParam;
import com.digiwin.lcdp.modeldriven.pojo.PublishModelStatusDTO;
import com.digiwin.lcdp.modeldriven.utils.ApTokenUtil;
import com.digiwin.lcdp.modeldriven.utils.ModelDataUtil;
import com.digiwin.lcdp.modeldriven.utils.ModelDrivenMetadataUtil;
import com.digiwin.lcdp.modeldriven.utils.ModelSchemaUtil;
import com.digiwin.lcdp.modeldriven.utils.ModelSqlKingbaseGenerator;
import com.digiwin.lcdp.modeldriven.utils.ModelTableHelperKingbaseExpress;
import com.digiwin.lcdp.modeldriven.utils.ModelTableSqlKingbaseGenerator;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;

@Service
public class ModelPublishService {
    private static final Logger log = LoggerFactory.getLogger(ModelPublishService.class);
    @Autowired
    @Qualifier(value="dw-dao")
    private DWDao dao;
    @Autowired
    private ModelTableHelperKingbaseExpress modelTableHelperExpress;
    @Autowired
    private ModelPublishService modelPublishService;

    public DWDataRow getPublished(ModelOidDTO modelOid) {
        String appId = ApTokenUtil.getCurrentAppId();
        List<Object> pkList = this.getPkList(modelOid);
        DWDataSetOperationOption option = ModelDataUtil.getDisabledCommonDataSetOperationOption();
        DWQueryInfo queryInfo = new DWQueryInfoBuilder().setOids(pkList).create();
        queryInfo.setTableName("dw_lcdp_model");
        DWDataSet dataSet = this.dao.select(queryInfo, option);
        if (dataSet != null && dataSet.getTable("dw_lcdp_model").getRows().size() > 0) {
            DWDataRow dataRow = dataSet.getTable("dw_lcdp_model").getRow(0);
            Assert.isTrue((boolean)ApTokenUtil.getCurrentAppId().equals(dataRow.get("app_id")), (String)String.format("the appid of model '%s' is wrong", modelOid.getCode()));
            return dataRow;
        }
        return null;
    }

    @Transactional(propagation=Propagation.REQUIRED, rollbackFor={Exception.class})
    public DWServiceResult deleteModelSchema(ModelDTO model) throws Exception {
        HashMap<String, Integer> returnData = new HashMap<String, Integer>();
        String appId = ApTokenUtil.getCurrentAppId();
        model.setAppId(appId);
        String code = model.getCode();
        log.debug("code({}) input model_schema", (Object)model.getCode());
        String tenantId = model.getTargetTenantId();
        ModelOidDTO modelOidDTO = new ModelOidDTO(code, null, tenantId);
        DWDataRow publishedDataRow = this.getPublished(modelOidDTO);
        if (publishedDataRow == null || publishedDataRow.getData().size() == 0) {
            log.warn("code({}) no publishedDataRow data", (Object)code);
        } else {
            model.setSchema(ModelSchemaUtil.getModelSchema((String)publishedDataRow.get("model_schema")));
        }
        Map<String, Object> dmlModelInfoDataSet = this.modelPublishService.deleteModelInfoForDeleteModel(model);
        DWSQLExecutionResult publishedDelete = this.modelPublishService.deletePublished(model, publishedDataRow, dmlModelInfoDataSet);
        returnData.put("model", publishedDelete.getDeleteCount());
        return DWServiceResultBuilder.build((String)"published deleted model", returnData);
    }

    @Transactional(propagation=Propagation.REQUIRED, rollbackFor={Exception.class})
    public Map<String, Object> deleteModelInfoForDeleteModel(ModelDTO model) {
        DWDataSetOperationOption optionDelete = ModelDataUtil.getDisabledCommonDataSetOperationOption();
        optionDelete.getDeleteOption().enableBatchCondition();
        DWBatchCondition batchCondition = new DWBatchCondition();
        String code = model.getCode();
        String appId = model.getAppId();
        batchCondition.addFieldInfo("code", DWQueryValueOperator.Equals, new Object[]{code});
        batchCondition.addFieldInfo("app_id", DWQueryValueOperator.Equals, new Object[]{appId});
        DWDataSet dataSetModelInfo = new DWDataSet();
        dataSetModelInfo.newTable("dw_lcdp_model_info").delete(batchCondition);
        DWSQLExecutionResult returnDaoValue = this.dao.execute(dataSetModelInfo, optionDelete);
        HashMap<String, Object> returnValue = new HashMap<String, Object>();
        if (log.isDebugEnabled()) {
            log.info("code({}) model_info deleted count({})", (Object)code, (Object)returnDaoValue.getDeleteCount());
        }
        return returnValue;
    }

    @Transactional(propagation=Propagation.REQUIRED, rollbackFor={Exception.class})
    public Object deleteModelAndDraft(ModelDTO model) {
        String code = model.getCode();
        String appId = model.getAppId();
        HashMap<String, Integer> returnValue = new HashMap<String, Integer>();
        DWDataSetOperationOption optionDelete = new DWDataSetOperationOption();
        optionDelete.setTenantEnabled(false);
        optionDelete.setManagementFieldEnabled(false);
        optionDelete.getDeleteOption().enableBatchCondition();
        DWBatchCondition batchCondition2 = new DWBatchCondition();
        batchCondition2.addFieldInfo("code", DWQueryValueOperator.Equals, new Object[]{code});
        batchCondition2.addFieldInfo("app_id", DWQueryValueOperator.Equals, new Object[]{appId});
        DWDataSet dataSetModel = new DWDataSet();
        dataSetModel.newTable("dw_lcdp_model").delete(batchCondition2);
        DWSQLExecutionResult deleteModelResult = this.dao.execute(dataSetModel, optionDelete);
        returnValue.put("dw_lcdp_model", deleteModelResult.getDeleteCount());
        if (log.isDebugEnabled()) {
            log.debug("code({}) deleted ({})", (Object)code, returnValue);
        }
        return returnValue;
    }

    public PublishModelStatusDTO publishDraft() throws Exception {
        ModelDTO draftModel = ModelDrivenContext.getContext().getDraftModel();
        ModelSchemaDTO draftModelSchema = draftModel.getSchema();
        String code = draftModel.getCode();
        String modelDescription = draftModel.getDescription();
        String modelTargetTenantId = draftModel.getTargetTenantId();
        PublishModelStatusDTO publishModelStatus = new PublishModelStatusDTO();
        publishModelStatus.setCode(code);
        publishModelStatus.setDescription(modelDescription);
        publishModelStatus.setTargetTenantId(modelTargetTenantId);
        Map<String, Object> draftDataRowMap = ModelDataUtil.buildModelData(draftModel);
        List<String> dirtyTableNames = ModelSchemaUtil.getTableNames(draftModelSchema);
        ModelOidDTO modelOidDTO = new ModelOidDTO(code, dirtyTableNames, modelTargetTenantId, null);
        DWDataRow publishedDataRow = this.getPublished(modelOidDTO);
        log.debug("publishDraft: publishing model (query published schema model db) , publishedModelDataRow = {}", (Object)publishedDataRow);
        Map<String, Object> modelTablesOfDb = this.modelTableHelperExpress.getModelTableFromDatabase(dirtyTableNames);
        ModelDrivenContext.getContext().getExtraMap().put("actualModelTablesFromDB", modelTablesOfDb);
        Object userSid = DWServiceContext.getContext().getProfile().get("userSid");
        if (publishedDataRow != null) {
            ModelDrivenContext.getContext().setNewModelPublish(false);
            log.debug("code({}) preparing alter schema", (Object)draftModel.getCode());
            draftDataRowMap.put("update_user_sid", userSid);
            ModelSchemaDTO publishedModelSchema = ModelSchemaUtil.parseModelSchema(publishedDataRow);
            List<String> publishedTableNames = ModelSchemaUtil.getTableNames(publishedModelSchema);
            publishedTableNames.stream().forEach(pTableName -> {
                if (!dirtyTableNames.contains(pTableName)) {
                    dirtyTableNames.add((String)pTableName);
                }
            });
            ModelPublishedEspResult modelPublishedEspResult = this.modelPublishService.alterTableExpress(draftModelSchema, publishedModelSchema, code);
            PublishStatusEnum publishStatus = modelPublishedEspResult.getPublishStatusEnum();
            publishModelStatus.setStatus(publishStatus);
        } else {
            log.debug("code({}) preparing create schema", (Object)code);
            draftDataRowMap.put("create_user_sid", userSid);
            ModelPublishedEspResult modelPublishedEspResult = this.modelPublishService.createOrAlterCustomizeTableExpress();
            PublishStatusEnum publishStatus = modelPublishedEspResult.getPublishStatusEnum();
            publishModelStatus.setStatus(publishStatus);
        }
        ModelDrivenMetadataUtil.removeRdbmsMetadata(code, dirtyTableNames);
        return publishModelStatus;
    }

    private List<Object> getPkList(String appId, ModelOidDTO modelOid) {
        HashMap<String, String> pkMap = new HashMap<String, String>();
        pkMap.put("app_id", appId);
        pkMap.put("code", modelOid.getCode());
        return Collections.singletonList(pkMap);
    }

    private List<Object> getPkList(ModelOidDTO modelOid) {
        HashMap<String, String> pkMap = new HashMap<String, String>();
        pkMap.put("code", modelOid.getCode());
        return Collections.singletonList(pkMap);
    }

    @Transactional(propagation=Propagation.REQUIRED, rollbackFor={Exception.class})
    public ModelPublishedEspResult createTableExpress(ModelSchemaDTO draftModelSchema) throws Exception {
        ModelSchemaUtil.checkModelSchema(draftModelSchema, true);
        List<ModelTable> modelTables = ModelSchemaUtil.getModelTables(draftModelSchema, false);
        AtomicReference<PublishStatusEnum> createStatus = new AtomicReference<PublishStatusEnum>(PublishStatusEnum.UNCHANGED);
        DWServiceResult serviceResult = this.modelTableHelperExpress.createTableExpress(draftModelSchema.getName(), modelTables);
        boolean createRunStatus = serviceResult.getSuccess();
        if (log.isDebugEnabled()) {
            log.debug(String.format("create: expected(%b) actual(%b), description:(%s)", createStatus, createRunStatus, serviceResult.getMessage()));
        }
        if (createRunStatus) {
            createStatus.set(PublishStatusEnum.SUCCESS);
        } else {
            createStatus.set(PublishStatusEnum.FAILURE);
        }
        ModelPublishedEspResult publishedEspResult = new ModelPublishedEspResult();
        publishedEspResult.setPublishStatusEnum(createStatus.get());
        publishedEspResult.setServiceResult(serviceResult);
        return publishedEspResult;
    }

    public ModelPublishedEspResult createOrAlterCustomizeTableExpress() throws Exception {
        ModelDTO draftModel = ModelDrivenContext.getContext().getDraftModel();
        log.debug("[ModelPublishService][createOrAlterCustomizeTableExpress] code({}) useExistedTable={}", (Object)draftModel.getCode(), (Object)draftModel.getUseExistedTable().getTypeChar());
        ModelSchemaDTO draftModelSchema = draftModel.getSchema();
        ModelSchemaUtil.checkModelSchema(draftModelSchema, true);
        List<ModelTable> draftModelTables = ModelSchemaUtil.getModelTables(draftModelSchema, false);
        AtomicReference<PublishStatusEnum> createStatus = new AtomicReference<PublishStatusEnum>(PublishStatusEnum.UNCHANGED);
        DWServiceResult serviceResult = this.modelTableHelperExpress.createCustomizeTableExpress(draftModelSchema.getName(), draftModelTables);
        boolean createRunStatus = serviceResult.getSuccess();
        if (log.isDebugEnabled()) {
            log.debug(String.format("[createOrAlterCustomizeTableExpress] expected(%b) actual(%b), description:(%s)", createStatus, createRunStatus, serviceResult.getMessage()));
        }
        if (createRunStatus) {
            createStatus.set(PublishStatusEnum.SUCCESS);
        } else {
            createStatus.set(PublishStatusEnum.FAILURE);
        }
        ModelPublishedEspResult publishedEspResult = new ModelPublishedEspResult();
        publishedEspResult.setPublishStatusEnum(createStatus.get());
        publishedEspResult.setServiceResult(serviceResult);
        return publishedEspResult;
    }

    public ModelPublishedEspResult alterTableExpress(ModelSchemaDTO draftModelSchema, ModelSchemaDTO publishedModelSchema, String code) throws Exception {
        String masterTableName = draftModelSchema.getName();
        log.debug("=============== express alterTable ====== {} =========", (Object)masterTableName);
        AtomicReference<PublishStatusEnum> alterStatus = new AtomicReference<PublishStatusEnum>(PublishStatusEnum.UNCHANGED);
        Map<String, LinkedHashMap<String, List<SqlParam>>> alterMasterTableMap = ModelTableSqlKingbaseGenerator.filterAlterTableCommand(draftModelSchema, publishedModelSchema);
        LinkedHashMap<String, List<SqlParam>> alterMap = alterMasterTableMap.get(publishedModelSchema.getName());
        LinkedList alterDDLSqlParam = (LinkedList)alterMap.get("ddl");
        LinkedList alterDMLSqlParam = (LinkedList)alterMap.get("dml");
        alterStatus.set(PublishStatusEnum.CHANGED);
        LinkedHashMap<String, LinkedHashMap<String, List<SqlParam>>> alterTableMap = new LinkedHashMap<String, LinkedHashMap<String, List<SqlParam>>>();
        String tableName = publishedModelSchema.getName();
        Map<String, LinkedHashMap<String, List<SqlParam>>> alterChildrenTableMap = ModelTableSqlKingbaseGenerator.getChildrenFullLevelAlterTableCommands(tableName, draftModelSchema.getChildren(), publishedModelSchema.getChildren());
        List<SqlParam> updateModelSqlParam = ModelSqlKingbaseGenerator.generateUpdateModelSql(ModelDrivenContext.getContext().getDraftModel());
        alterDMLSqlParam.addAll(updateModelSqlParam);
        if (!CollectionUtils.isEmpty((Collection)alterDMLSqlParam) || !CollectionUtils.isEmpty((Collection)alterDDLSqlParam)) {
            alterMap.put("dml", alterDMLSqlParam);
            alterMap.put("ddl", alterDDLSqlParam);
            alterTableMap.put(publishedModelSchema.getName(), alterMap);
            alterStatus.set(PublishStatusEnum.CHANGED);
        }
        List<ModelTable> modelAllTables = ModelSchemaUtil.getModelTables(draftModelSchema);
        LinkedList<SqlParam> UpdateModelInfoParams = ModelSqlKingbaseGenerator.generateUpdateModelInfoSql(modelAllTables, code);
        alterDMLSqlParam.addAll(UpdateModelInfoParams);
        alterTableMap.putAll(alterChildrenTableMap);
        if (MapUtils.isNotEmpty(alterChildrenTableMap)) {
            alterStatus.set(PublishStatusEnum.CHANGED);
        }
        ModelTable draftModelTable = new ModelTable();
        draftModelTable.setName(draftModelSchema.getName());
        draftModelTable.setComment(draftModelSchema.getComment());
        draftModelTable.setCategory(draftModelSchema.getCategory());
        draftModelTable.setSystem(draftModelSchema.getSystem());
        HashMap<String, Object> modelDataMap = new HashMap<String, Object>();
        DWServiceResult serviceResult = this.modelTableHelperExpress.alterTableExpress(masterTableName, alterTableMap, modelDataMap);
        boolean createRunStatus = serviceResult.getSuccess();
        if (log.isDebugEnabled()) {
            log.debug(String.format("create: expected(%b) actual(%b), description:(%s)", alterStatus, createRunStatus, serviceResult.getMessage()));
        }
        if (createRunStatus) {
            alterStatus.set(PublishStatusEnum.SUCCESS);
        } else {
            alterStatus.set(PublishStatusEnum.FAILURE);
        }
        ModelPublishedEspResult publishedEspResult = new ModelPublishedEspResult();
        publishedEspResult.setPublishStatusEnum(alterStatus.get());
        publishedEspResult.setServiceResult(serviceResult);
        return publishedEspResult;
    }

    @Transactional(propagation=Propagation.REQUIRED, rollbackFor={Exception.class})
    public DWSQLExecutionResult deletePublished(ModelDTO model, DWDataRow publishedDataRow, Map<String, Object> modelDesignDataMap) throws Exception {
        Assert.hasText((String)model.getCode(), (String)"model code must not be null or empty");
        Assert.hasText((String)model.getAppId(), (String)"model appid must not be null or empty");
        String code = model.getCode();
        DWSQLExecutionResult returnResult = new DWSQLExecutionResult();
        if (publishedDataRow != null && MapUtils.isNotEmpty((Map)publishedDataRow.getData())) {
            ModelSchemaDTO modelSchema = ModelSchemaUtil.parseModelSchema(publishedDataRow);
            AtomicReference<PublishStatusEnum> dropStatus = new AtomicReference<PublishStatusEnum>(PublishStatusEnum.UNCHANGED);
            DWDataSet modelDataSet = new DWDataSetBuilder().addTable("dw_lcdp_model").addRowOrgDatas(Collections.singletonList(publishedDataRow.getData()), "D").createDataSet();
            HashMap<String, Object> modelDataMap = new HashMap<String, Object>();
            HashMap<String, Object> dmlModelDataSet = new HashMap<String, Object>();
            dmlModelDataSet.put("value", modelDataSet);
            dmlModelDataSet.put("model_action", "D");
            modelDataMap.put("dw_lcdp_model", dmlModelDataSet);
            modelDataMap.putAll(modelDesignDataMap);
            List<ModelTable> modelTables = ModelSchemaUtil.getModelTables(modelSchema);
            boolean dropRunStatus = this.modelTableHelperExpress.dropTableExpress(modelTables, modelDataMap, model);
            if (dropRunStatus) {
                dropStatus.set(PublishStatusEnum.SUCCESS);
            }
            if (log.isDebugEnabled()) {
                log.debug("code({}) drop status: expected({}) actual({})", new Object[]{code, dropStatus, dropRunStatus});
            }
            Map deleteResult = (Map)this.modelPublishService.deleteModelAndDraft(model);
            for (Map.Entry row : deleteResult.entrySet()) {
                returnResult.addDeleteCount((String)row.getKey(), ((Integer)row.getValue()).intValue());
            }
            List<String> dirtyTableNames = modelTables.stream().map(modelTable -> modelTable.getName()).collect(Collectors.toList());
            ModelDrivenMetadataUtil.removeRdbmsMetadata(code, dirtyTableNames);
        }
        return returnResult;
    }
}

