/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.lcdp.modeldriven.utils;

import com.digiwin.app.data.DWDataRow;
import com.digiwin.app.data.DWDataSet;
import com.digiwin.app.data.DWDataTable;
import com.digiwin.app.json.gson.DWGsonProvider;
import com.digiwin.app.metadata.DWMetadata;
import com.digiwin.app.metadata.DWValueAttribute;
import com.digiwin.app.metadata.rdbms.DWRdbmsAttributes;
import com.digiwin.app.metadata.rdbms.DWRdbmsField;
import com.digiwin.lcdp.modeldriven.utils.DataEntryDBTableUtil;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class DataEntryDataUtil {
    private static Log log = LogFactory.getLog(DataEntryDataUtil.class);

    public static DWDataSet convertUserTableName(DWDataSet queryResult, String masterDatabaseTableName, List detailDatabaseTableNameList) {
        boolean hasDetailTable = false;
        if (CollectionUtils.isNotEmpty((Collection)detailDatabaseTableNameList)) {
            hasDetailTable = true;
        }
        DWDataTable masterTable = queryResult.getTable(masterDatabaseTableName);
        masterTable.setName(masterDatabaseTableName);
        if (hasDetailTable) {
            List finalDetailTableNameList = detailDatabaseTableNameList;
            masterTable.getRows().forEach(r -> {
                Iterator iterator = finalDetailTableNameList.iterator();
                while (iterator.hasNext()) {
                    String tempDatabaseDetailTableName;
                    String tempUserTable = tempDatabaseDetailTableName = (String)iterator.next();
                    Map rowMap = r.getData();
                    if (!rowMap.containsKey(tempDatabaseDetailTableName)) continue;
                    r.set(tempUserTable, r.get(tempDatabaseDetailTableName));
                    rowMap.remove(tempDatabaseDetailTableName);
                }
            });
        }
        DWDataSet dataSet = new DWDataSet();
        dataSet.getTables().add(masterTable);
        return dataSet;
    }

    public static Object getReflectionData(Object target, String fieldName) throws Exception {
        Field field = target.getClass().getDeclaredField(fieldName);
        field.setAccessible(true);
        return field.get(target);
    }

    public static void setReflectionData(Object target, String fieldName, Object value) throws Exception {
        Field field = target.getClass().getDeclaredField(fieldName);
        field.setAccessible(true);
        field.set(target, value);
    }

    public static Map<String, Object> convertToJson(String databaseTableName, Map<String, Object> dataInfo) {
        DWMetadata<?> masterTableRdbmsMetadata = DataEntryDBTableUtil.loadRdbmsMetadata(databaseTableName);
        for (String columnName : dataInfo.keySet()) {
            DWValueAttribute fieldValueAttr;
            Object fieldValueObject = dataInfo.get(columnName);
            if (!masterTableRdbmsMetadata.hasField(columnName) || fieldValueObject == null || !(fieldValueAttr = (DWValueAttribute)masterTableRdbmsMetadata.getField(columnName).getAttribute(DWRdbmsAttributes.RDBMS_VALUE_TYPE)).getValue().equals("JSON")) continue;
            String fieldJsonObj = DWGsonProvider.getGson().toJson(fieldValueObject, Object.class);
            dataInfo.replace(columnName, fieldJsonObj);
        }
        return dataInfo;
    }

    public static List<Map<String, Object>> convertFromJson(DWDataTable dataTable) {
        ArrayList<Map<String, Object>> dataList = new ArrayList<Map<String, Object>>();
        DWMetadata<?> tempTableRdbmsMetadata = DataEntryDBTableUtil.loadRdbmsMetadata(dataTable.getName());
        Iterator rowIt = dataTable.getRows().iterator();
        boolean isFirstTime = true;
        HashSet<String> checkedSpecialField = new HashSet<String>();
        while (rowIt.hasNext()) {
            Map rowMap = ((DWDataRow)rowIt.next()).getData();
            for (String columnName : rowMap.keySet()) {
                DWValueAttribute fieldValueAttr;
                Object fieldValueObject = rowMap.get(columnName);
                if (!isFirstTime && checkedSpecialField.contains(columnName)) {
                    if (fieldValueObject == null) continue;
                    Object fieldJsonObj = fieldValueObject instanceof byte[] ? DWGsonProvider.getGson().fromJson(new String((byte[])fieldValueObject), Object.class) : DWGsonProvider.getGson().fromJson((String)fieldValueObject, Object.class);
                    rowMap.replace(columnName, fieldJsonObj);
                    continue;
                }
                if (!isFirstTime || !tempTableRdbmsMetadata.hasField(columnName) || !(fieldValueAttr = (DWValueAttribute)tempTableRdbmsMetadata.getField(columnName).getAttribute(DWRdbmsAttributes.RDBMS_VALUE_TYPE)).getValue().equals("JSON")) continue;
                checkedSpecialField.add(columnName);
                if (fieldValueObject == null) continue;
                Object fieldJsonObj = fieldValueObject instanceof byte[] ? DWGsonProvider.getGson().fromJson(new String((byte[])fieldValueObject), Object.class) : DWGsonProvider.getGson().fromJson((String)fieldValueObject, Object.class);
                rowMap.replace(columnName, fieldJsonObj);
            }
            isFirstTime = false;
            dataList.add(rowMap);
        }
        return dataList;
    }

    public static List<Map<String, Object>> convertToJson(List<Map<String, Object>> params, String targetTableName) {
        ArrayList<Map<String, Object>> dataList = new ArrayList<Map<String, Object>>();
        DWMetadata<?> tempTableRdbmsMetadata = DataEntryDBTableUtil.loadRdbmsMetadata(targetTableName);
        ArrayList fields = new ArrayList();
        tempTableRdbmsMetadata.getFields().forEach(item -> {
            if (item instanceof DWRdbmsField) {
                fields.add(((DWRdbmsField)item).getName());
            }
        });
        log.info((Object)("=====================" + targetTableName + " getRdbmsFields:" + String.join((CharSequence)",", fields)));
        boolean isFirstTime = true;
        HashSet<String> checkedSpecialField = new HashSet<String>();
        for (Map<String, Object> rowMap : params) {
            for (String columnName : rowMap.keySet()) {
                DWValueAttribute fieldValueAttr;
                Object fieldValueObject = rowMap.get(columnName);
                if (!isFirstTime && checkedSpecialField.contains(columnName)) {
                    if (fieldValueObject == null) continue;
                    String fieldJsonObj = DWGsonProvider.getGson().toJson(fieldValueObject, Object.class);
                    rowMap.replace(columnName, fieldJsonObj);
                    continue;
                }
                if (!isFirstTime || !tempTableRdbmsMetadata.hasField(columnName) || !(fieldValueAttr = (DWValueAttribute)tempTableRdbmsMetadata.getField(columnName).getAttribute(DWRdbmsAttributes.RDBMS_VALUE_TYPE)).getValue().equals("JSON")) continue;
                checkedSpecialField.add(columnName);
                if (fieldValueObject == null) continue;
                String fieldJsonObj = DWGsonProvider.getGson().toJson(fieldValueObject, Object.class);
                rowMap.replace(columnName, fieldJsonObj);
            }
            isFirstTime = false;
            dataList.add(rowMap);
        }
        return dataList;
    }

    public static Map<String, Object> convertMapFromJson(DWDataTable dataTable, Map<String, Object> dataInfo) {
        DWMetadata<?> masterTableRdbmsMetadata = DataEntryDBTableUtil.loadRdbmsMetadata(dataTable.getName());
        for (String columnName : dataInfo.keySet()) {
            DWValueAttribute fieldValueAttr;
            Object fieldValueObject = dataInfo.get(columnName);
            if (!masterTableRdbmsMetadata.hasField(columnName) || fieldValueObject == null || !(fieldValueAttr = (DWValueAttribute)masterTableRdbmsMetadata.getField(columnName).getAttribute(DWRdbmsAttributes.RDBMS_VALUE_TYPE)).getValue().equals("JSON")) continue;
            Object fieldJsonObj = DWGsonProvider.getGson().fromJson((String)fieldValueObject, Object.class);
            dataInfo.replace(columnName, fieldJsonObj);
        }
        return dataInfo;
    }
}

