/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.lcdp.modeldriven.utils;

import com.digiwin.app.container.exceptions.DWRuntimeException;
import com.digiwin.app.ddl.enums.DataTypeEnum;
import com.digiwin.app.metadata.DWMetadata;
import com.digiwin.app.metadata.exceptions.DWMetadataNotFoundException;
import com.digiwin.app.metadata.rdbms.DWRdbmsField;
import com.digiwin.app.service.DWServiceContext;
import com.digiwin.data.permission.DWRowPermissionBase;
import com.digiwin.data.permission.DWRowPermissionDefaultMatchOption;
import com.digiwin.data.permission.DWRowPermissionEmpty;
import com.digiwin.data.permission.DWRowPermissionGroup;
import com.digiwin.data.permission.DWRowPermissionMatchOption;
import com.digiwin.data.permission.DWUserPermission;
import com.digiwin.lcdp.modeldriven.constants.ModelDBConstants;
import com.digiwin.lcdp.modeldriven.context.ModelDrivenContext;
import com.digiwin.lcdp.modeldriven.enums.AlterAutoIncrementEnum;
import com.digiwin.lcdp.modeldriven.enums.AlterColumnEnum;
import com.digiwin.lcdp.modeldriven.enums.AlterIndexEnum;
import com.digiwin.lcdp.modeldriven.enums.ColumnNullableEnum;
import com.digiwin.lcdp.modeldriven.enums.IndexTypeEnum;
import com.digiwin.lcdp.modeldriven.model.ModelDTO;
import com.digiwin.lcdp.modeldriven.model.ModelFieldDTO;
import com.digiwin.lcdp.modeldriven.model.ModelIndexDTO;
import com.digiwin.lcdp.modeldriven.model.ModelSchemaDTO;
import com.digiwin.lcdp.modeldriven.model.ModelTable;
import com.digiwin.lcdp.modeldriven.model.ModelTableSchemaCache;
import com.digiwin.lcdp.modeldriven.model.SqlParam;
import com.digiwin.lcdp.modeldriven.model.TableColumn;
import com.digiwin.lcdp.modeldriven.model.TableIndex;
import com.digiwin.lcdp.modeldriven.model.TableSqlParamDTO;
import com.digiwin.lcdp.modeldriven.utils.ApTokenUtil;
import com.digiwin.lcdp.modeldriven.utils.EaiServiceNameUtil;
import com.digiwin.lcdp.modeldriven.utils.ModelDataUtil;
import com.digiwin.lcdp.modeldriven.utils.ModelDrivenMetadataUtil;
import com.digiwin.lcdp.modeldriven.utils.ModelSchemaUtil;
import com.digiwin.lcdp.modeldriven.utils.compare.IndexCompareKingbaseUtil;
import com.digiwin.lcdp.modeldriven.utils.compare.IndexCompareUtil;
import com.digiwin.utils.DWTenantUtils;
import java.lang.reflect.Field;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;
import net.sf.jsqlparser.JSQLParserException;
import net.sf.jsqlparser.expression.Expression;
import net.sf.jsqlparser.expression.JdbcParameter;
import net.sf.jsqlparser.expression.NullValue;
import net.sf.jsqlparser.expression.StringValue;
import net.sf.jsqlparser.expression.operators.relational.ExpressionList;
import net.sf.jsqlparser.expression.operators.relational.ItemsList;
import net.sf.jsqlparser.parser.CCJSqlParserUtil;
import net.sf.jsqlparser.parser.SimpleNode;
import net.sf.jsqlparser.schema.Table;
import net.sf.jsqlparser.statement.Statement;
import net.sf.jsqlparser.statement.alter.Alter;
import net.sf.jsqlparser.statement.alter.AlterExpression;
import net.sf.jsqlparser.statement.alter.AlterOperation;
import net.sf.jsqlparser.statement.drop.Drop;
import net.sf.jsqlparser.statement.insert.Insert;
import net.sf.jsqlparser.statement.select.PlainSelect;
import net.sf.jsqlparser.statement.select.Select;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ModelSqlKingbaseGenerator {
    private static final Logger log = LoggerFactory.getLogger(ModelSqlKingbaseGenerator.class);
    private static final String _CLASSTAG = "[" + ModelSqlKingbaseGenerator.class.getSimpleName() + "]";
    private static final SimpleDateFormat bindedSqlDateTimeFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");

    public static List<SqlParam> generateCreateTableSql(ModelTable modelTable) {
        String indexSql;
        String pkCondtionSql;
        ArrayList<SqlParam> result = new ArrayList<SqlParam>();
        ArrayList commentSqlParam = new ArrayList();
        ArrayList params = new ArrayList();
        String tableName = modelTable.getName();
        String tableComment = modelTable.getComment();
        String columnsSql = modelTable.getColumns().stream().map(column -> String.format("`%s` %s %s %s %s %s '%s' ", column.getColumnName(), ModelSqlKingbaseGenerator.getTypeDDL(column), ModelSqlKingbaseGenerator.getNullableEnum(column.nullable()).getSqlChar(), ModelSqlKingbaseGenerator.columnUniqueValue(column.getUnique()), ModelSqlKingbaseGenerator.getSqlByAutoIncrementOrDefaultValue(column), "COMMENT", column.getComment())).collect(Collectors.joining(" , "));
        ArrayList<String> constraints = new ArrayList<String>();
        TableIndex draftPkTableColumn = modelTable.getIndexes().stream().filter(index -> index.getType() == IndexTypeEnum.PRIMARY_KEY).findFirst().orElse(null);
        if (draftPkTableColumn != null && StringUtils.isNotBlank((CharSequence)(pkCondtionSql = ModelSqlKingbaseGenerator.generatePrimaryKeySql(modelTable.getName(), draftPkTableColumn.getMember())))) {
            constraints.add(pkCondtionSql);
        }
        if (StringUtils.isNotBlank((CharSequence)(indexSql = ModelSqlKingbaseGenerator.generateIndexes(modelTable.getIndexes(), tableName)))) {
            constraints.add(indexSql);
        }
        String constraintsSql = String.join((CharSequence)", ", constraints);
        String createTableSql = String.format("CREATE TABLE IF NOT EXISTS `%s` ( %s , %s ) ", tableName, columnsSql, constraintsSql, tableComment);
        SqlParam sqlParam = new SqlParam();
        sqlParam.setSql(createTableSql);
        sqlParam.setParams(params.toArray());
        result.add(sqlParam);
        result.addAll(commentSqlParam);
        return result;
    }

    public static SqlParam generateAlterTableSql(String tableName, String tableComment) {
        String modifyTableCommentSql = String.format("ALTER TABLE `%s` %s '%s' ", tableName, "COMMENT", tableComment);
        return new SqlParam(modifyTableCommentSql, new Object[0]);
    }

    public static SqlParam generateAlterTableCollationSql(String tableName, String collation) {
        String modifyTableCommentSql = String.format("ALTER TABLE `%s` COLLATE '%s' ", tableName, collation);
        return new SqlParam(modifyTableCommentSql, new Object[0]);
    }

    public static LinkedList<SqlParam> generateAlterIndexSql(String tableName, AlterIndexEnum alterIndexEnum, TableIndex tableIndex) {
        LinkedList<SqlParam> sqlParams = new LinkedList<SqlParam>();
        String targetIndexId = tableIndex.getName();
        ModelIndexDTO targetModelIndex = ModelSchemaUtil.convertTableIndexToModelIndex(tableIndex);
        Map<String, ModelTableSchemaCache> publishedTableCache = ModelDrivenContext.getContext().getPublishedTableCache();
        ModelTableSchemaCache modelTableSchemaCache = publishedTableCache.getOrDefault(tableName, new ModelTableSchemaCache());
        Map<String, Object> publishedRemainIndexes = modelTableSchemaCache.getPublishedRemainIndexes();
        switch (alterIndexEnum) {
            case ADD: {
                String indexAddSpecification = ModelSqlKingbaseGenerator.generateIndexes(tableIndex, tableName);
                String indexAddSql = String.format("ALTER TABLE `%s` %s %s", tableName, alterIndexEnum.getSqlChar(), indexAddSpecification);
                sqlParams.add(new SqlParam(indexAddSql, new Object[0]));
                publishedRemainIndexes.put(targetIndexId, targetModelIndex);
                log.info("publishedRemainIndexes add {}({})", (Object)targetIndexId, (Object)targetModelIndex);
                break;
            }
            case MODIFY: {
                String alterSpecification = ModelSqlKingbaseGenerator.generateIndexes(tableIndex, tableName);
                if (targetIndexId.equals("PRIMARY KEY")) break;
                if (publishedRemainIndexes.containsKey(targetIndexId)) {
                    log.info("flag1");
                    String indexDropByModifySql = String.format("ALTER TABLE `%s` DROP INDEX `%s`", tableName, targetIndexId);
                    String indexAddByModifySql = String.format("ALTER TABLE `%s` ADD %s", tableName, alterSpecification);
                    sqlParams.add(new SqlParam(indexDropByModifySql, new Object[0]));
                    sqlParams.add(new SqlParam(indexAddByModifySql, new Object[0]));
                    publishedRemainIndexes.put(targetIndexId, targetModelIndex);
                    log.info("publishedRemainIndexes modify {} ({})", (Object)targetIndexId, (Object)targetModelIndex);
                    break;
                }
                String indexAddByModifySql = String.format("ALTER TABLE `%s` ADD %s", tableName, alterSpecification);
                sqlParams.add(new SqlParam(indexAddByModifySql, new Object[0]));
                publishedRemainIndexes.put(targetIndexId, targetModelIndex);
                log.info("publishedRemainIndexes add {} when modify", (Object)targetIndexId);
                break;
            }
            case DROP: {
                if (publishedRemainIndexes.containsKey(targetIndexId) && !targetIndexId.equals("PRIMARY KEY")) {
                    log.info("flag2");
                    String dropColumnSql = String.format("ALTER TABLE `%s` DROP INDEX `%s` ", tableName, targetIndexId);
                    sqlParams.add(new SqlParam(dropColumnSql, null));
                    publishedRemainIndexes.remove(targetIndexId);
                    log.info("publishedRemainIndexes: remove {}", (Object)targetIndexId);
                    break;
                }
                log.warn("publishedRemainIndexes: ignored to drop {}", (Object)targetIndexId);
                break;
            }
            default: {
                throw new DWRuntimeException("\u4e0d\u652f\u6301\u8be5\u64cd\u4f5c");
            }
        }
        return sqlParams;
    }

    public static LinkedList<SqlParam> generateAlterColumnsSql(String tableName, AlterColumnEnum alterColumnEnum, TableColumn draftTableColumn) {
        ModelTable actualModelTable = ModelDrivenContext.getActualModelTable(tableName);
        boolean isExistedTable = false;
        if (actualModelTable != null) {
            isExistedTable = true;
        }
        LinkedList<SqlParam> sqlParams = new LinkedList<SqlParam>();
        switch (alterColumnEnum) {
            case ADD_COLUMN: {
                String addColumnSql = String.format("ALTER TABLE `%s` %s `%s` %s %s %s %s %s '%s' ", tableName, alterColumnEnum.getSqlChar(), draftTableColumn.getColumnName(), ModelSqlKingbaseGenerator.getTypeDDL(draftTableColumn), ModelSqlKingbaseGenerator.getNullableEnum(draftTableColumn.nullable()).getSqlChar(), ModelSqlKingbaseGenerator.columnUniqueValue(draftTableColumn.getUnique()), ModelSqlKingbaseGenerator.getDefaultValue(draftTableColumn, isExistedTable), "COMMENT", draftTableColumn.getComment());
                sqlParams.add(new SqlParam(addColumnSql, new Object[0]));
                break;
            }
            case MODIFY_COLUMN: {
                String pkCondtion;
                String autoIncrementOrDefaultValue = ModelSqlKingbaseGenerator.getSqlByAutoIncrementOrDefaultValue(draftTableColumn, false);
                String modifyColumnSql = String.format("ALTER TABLE `%s` %s `%s` %s %s %s %s '%s' %s ", tableName, alterColumnEnum.getSqlChar(), draftTableColumn.getColumnName(), ModelSqlKingbaseGenerator.getTypeDDL(draftTableColumn), ModelSqlKingbaseGenerator.getNullableEnum(draftTableColumn.nullable()).getSqlChar(), autoIncrementOrDefaultValue, "COMMENT", draftTableColumn.getComment(), ModelSqlKingbaseGenerator.getCollation(draftTableColumn.getDataType(), isExistedTable, alterColumnEnum));
                if (autoIncrementOrDefaultValue.toUpperCase().contains("AUTO_INCREMENT") && StringUtils.isNotBlank((CharSequence)(pkCondtion = ModelSqlKingbaseGenerator.getPrimaryKeyCondition(tableName, autoIncrementOrDefaultValue, draftTableColumn)))) {
                    modifyColumnSql = String.join((CharSequence)",", modifyColumnSql, pkCondtion);
                }
                sqlParams.add(new SqlParam(modifyColumnSql, new Object[0]));
                break;
            }
            case DROP_COLUMN: {
                String dropColumnSql = String.format("ALTER TABLE `%s` %s `%s` ", tableName, alterColumnEnum.getSqlChar(), draftTableColumn.getColumnName());
                sqlParams.add(new SqlParam(dropColumnSql, new Object[0]));
                break;
            }
            default: {
                throw new DWRuntimeException("\u4e0d\u652f\u6301\u8be5\u64cd\u4f5c");
            }
        }
        return sqlParams;
    }

    public static SqlParam generateAlterColumnRemoveAutoIncreAndPkSql(String tableName, AlterColumnEnum alterColumnEnum, TableColumn tableColumn) {
        switch (alterColumnEnum) {
            case MODIFY_COLUMN: {
                String modifyColumnSql = String.format("ALTER TABLE `%s` %s `%s` %s NULL %s '%s' , DROP %s", tableName, alterColumnEnum.getSqlChar(), tableColumn.getColumnName(), ModelSqlKingbaseGenerator.getTypeDDL(tableColumn), "COMMENT", tableColumn.getComment(), "PRIMARY KEY");
                return new SqlParam(modifyColumnSql, new Object[0]);
            }
        }
        throw new DWRuntimeException("\u4e0d\u652f\u6301\u8be5\u64cd\u4f5c");
    }

    public static SqlParam generateDropTableSql(String tableName) {
        Drop dropScript = new Drop();
        Table dropTable = new Table(tableName);
        dropScript.setName(dropTable);
        dropScript.setType("TABLE");
        dropScript.setIfExists(true);
        String sql = dropScript.toString();
        SqlParam sqlParam = new SqlParam();
        sqlParam.setSql(sql);
        return sqlParam;
    }

    public static SqlParam generateRenameTableSql(String tableName) {
        Table alterTable = new Table(tableName);
        Alter alterScript = new Alter();
        alterScript.setTable(alterTable);
        AlterExpression renameTableNameExpression = new AlterExpression();
        renameTableNameExpression.setOperation(AlterOperation.RENAME_TABLE);
        Long timeStamp = new Timestamp(System.currentTimeMillis() / 1000L).getTime();
        renameTableNameExpression.setNewTableName(String.join((CharSequence)"_", "md", timeStamp.toString(), tableName));
        alterScript.addAlterExpression(renameTableNameExpression);
        String sql = alterScript.toString();
        SqlParam sqlParam = new SqlParam();
        sqlParam.setSql(sql);
        return sqlParam;
    }

    public static SqlParam generateInsertRdbmsTableSql(ModelTable modelTable) {
        return new SqlParam("insert into dw_rdbms_tables  (table_name, table_display_name, table_description, delete_constraint) values(?, ?, ?, 'N') ON DUPLICATE KEY UPDATE table_name=?, table_display_name=?, table_description=?", new Object[]{modelTable.getName(), modelTable.getComment(), modelTable.getComment(), modelTable.getName(), modelTable.getComment(), modelTable.getComment()});
    }

    public static List<SqlParam> generateInsertOrUpdateRdbmsFieldSql(ModelTable modelTable) {
        ArrayList<SqlParam> returnValue = new ArrayList<SqlParam>();
        for (TableColumn tableColumn : modelTable.getColumns()) {
            SqlParam sqlParam = ModelSqlKingbaseGenerator.generateInsertOrUpdateRdbmsFieldSql(modelTable.getName(), tableColumn);
            returnValue.add(sqlParam);
        }
        return returnValue;
    }

    public static SqlParam generateInsertOrUpdateRdbmsFieldSql(String tableName, TableColumn tableColumn) {
        String isPk = ModelSqlKingbaseGenerator.booleanToYN(tableColumn.isPK());
        String defaultValue = tableColumn.getDefaultValue() != null ? tableColumn.getDefaultValue() : "null";
        Integer size = ModelSqlKingbaseGenerator.getUpdateSize(tableColumn.getSize(), tableColumn.getDataType().getDefaultSize());
        Integer scale = ModelSqlKingbaseGenerator.getUpdateSize(tableColumn.getScale(), tableColumn.getDataType().getDefaultScale());
        String nullable = ModelSqlKingbaseGenerator.booleanToYN(tableColumn.nullable());
        String autoIncrement = ModelSqlKingbaseGenerator.booleanToYN(tableColumn.getAutoIncrement() != false || tableColumn.getAutoIncrement() != false);
        Object[] sqlParamParams = new Object[]{tableName, tableColumn.getSeq(), tableColumn.getColumnName(), isPk, tableColumn.getDataType().getName(), tableColumn.getComment(), defaultValue, nullable, size, scale, autoIncrement, tableName, tableColumn.getSeq(), tableColumn.getColumnName(), isPk, tableColumn.getDataType().getName(), tableColumn.getComment(), defaultValue, nullable, size, scale, autoIncrement};
        return new SqlParam("insert into dw_rdbms_fields  (table_name, seq, field_name, is_key, field_type, status_code, field_display_name, default_value, nullable, is_version, size, scale, is_auto_increment)  values (?, ?, ?, ?, ?, 'Y', ?, ?, ?, 'N', ?, ?, ?)  ON DUPLICATE KEY UPDATE table_name=?, seq=?, field_name=?, is_key=?, field_type=?, status_code='N', field_display_name=?, default_value=?, nullable=?, is_version='N', size=?, scale=?, is_auto_increment=? ", sqlParamParams);
    }

    public static SqlParam generateInsertServiceMappingSql(ModelTable modelTable) {
        String modelDrivenProdPrefix = (String)ModelDrivenContext.getContext().getExtraMap().getOrDefault("modelDrivenProdPrefix", "");
        String tableName = modelTable.getName();
        String prefixEaiId = EaiServiceNameUtil.getEaiPrefixName(modelDrivenProdPrefix, tableName);
        String insertServiceMappingSql = "insert into dw_service_mapping(table_name, expose_eai_id) values(?, ?) ON DUPLICATE KEY UPDATE table_name=? ,expose_eai_id=? ";
        return new SqlParam(insertServiceMappingSql, new Object[]{tableName, prefixEaiId, tableName, prefixEaiId});
    }

    public static SqlParam generateDeleteServiceMappingSql(ModelTable modelTable) {
        String tableName = modelTable.getName();
        String deleteRdbmsTableSql = String.format("delete from %s where table_name = ?", "dw_service_mapping");
        return new SqlParam(deleteRdbmsTableSql, new Object[]{tableName});
    }

    public static SqlParam generateInsertModelSql(ModelDTO model) {
        String code = model.getCode();
        String modelSchemaStr = ModelDataUtil.getModelSchemaJsonData();
        String tenantSidColumnName = DWTenantUtils.getTenantColumnName();
        Object tenantSid = DWServiceContext.getContext().getProfile().get(DWTenantUtils.getIAMTenantSidKey());
        Object tenantUserSid = DWServiceContext.getContext().getProfile().get("userSid");
        String insertServiceMappingSql = String.format("insert into dw_lcdp_model (code, description, model_schema, target_tenant_id, app_id, %s , create_user_sid , create_time ) values(?, ?, ?, ?, ?, ?, ? ,?)", tenantSidColumnName);
        return new SqlParam(insertServiceMappingSql, new Object[]{code, model.getDescription(), modelSchemaStr, model.getTargetTenantId(), model.getAppId(), tenantSid, tenantUserSid, new Date()});
    }

    public static LinkedList<SqlParam> generateUpdateModelInfoSql(List<ModelTable> modelTables, String code) {
        LinkedList<SqlParam> updateSqlParams = ModelSqlKingbaseGenerator.generateDeleteModelInfoSql(code);
        updateSqlParams.addAll(ModelSqlKingbaseGenerator.generateInsertModelInfoSql(modelTables, code));
        return updateSqlParams;
    }

    public static LinkedList<SqlParam> generateDeleteModelInfoSql(String code) {
        String tenantSidColumnName = DWTenantUtils.getTenantColumnName();
        Object tenantSid = DWServiceContext.getContext().getProfile().get(DWTenantUtils.getIAMTenantSidKey());
        String appId = ApTokenUtil.getCurrentAppId();
        String insertModelInfoSql = String.format("delete from dw_lcdp_model_info where code=? and app_id=? and %s=?", tenantSidColumnName);
        Object[] sqlParamParams = new Object[]{code, appId, tenantSid};
        SqlParam sqlParam = new SqlParam(insertModelInfoSql, sqlParamParams);
        LinkedList<SqlParam> sqlParams = new LinkedList<SqlParam>();
        sqlParams.add(sqlParam);
        return sqlParams;
    }

    public static List<SqlParam> generateInsertModelInfoSql(List<ModelTable> modelTables, String code) {
        ArrayList<SqlParam> sqlParams = new ArrayList<SqlParam>();
        for (ModelTable modelTable : modelTables) {
            SqlParam sqlParam = ModelSqlKingbaseGenerator.generateInsertModelInfoSql(modelTable, code);
            sqlParams.add(sqlParam);
        }
        return sqlParams;
    }

    public static SqlParam generateInsertModelInfoSql(ModelTable modelTable, String code) {
        String tenantSidColumnName = DWTenantUtils.getTenantColumnName();
        Object tenantSid = DWServiceContext.getContext().getProfile().get(DWTenantUtils.getIAMTenantSidKey());
        String tenantId = ApTokenUtil.getCurrentTenantId();
        Object tenantUserSid = DWServiceContext.getContext().getProfile().get("userSid");
        String appId = ApTokenUtil.getCurrentAppId();
        String tableName = modelTable.getName();
        String insertModelInfoSql = String.format("insert into dw_lcdp_model_info (code, table_name, app_id, tenant_id, create_user_sid, create_time, %s ) values( ?, ?, ?, ?, ?, ?, ? ) ON DUPLICATE KEY UPDATE app_id=?, tenant_id=?, update_user_sid=?, %s =? ", tenantSidColumnName, tenantSidColumnName);
        Object[] sqlParamParams = new Object[]{code, tableName, appId, tenantId, tenantUserSid, new Date(), tenantSid, appId, tenantId, tenantUserSid, tenantSid};
        SqlParam sqlParam = new SqlParam(insertModelInfoSql, sqlParamParams);
        return sqlParam;
    }

    public static List<SqlParam> generateUpdateModelSql(ModelDTO model) {
        String code = model.getCode();
        String modelSchemaStr = ModelDataUtil.getModelSchemaJsonData();
        Object tenantUserSid = DWServiceContext.getContext().getProfile().get("userSid");
        Object[] params = new Object[]{model.getDescription(), modelSchemaStr, tenantUserSid, code, model.getAppId()};
        String updateModelSql = "update dw_lcdp_model set description=?, model_schema=? , update_user_sid=? where code=? and app_id=? ";
        SqlParam modelSqlParam = new SqlParam(updateModelSql, params);
        ArrayList<SqlParam> returnValue = new ArrayList<SqlParam>();
        returnValue.add(modelSqlParam);
        return returnValue;
    }

    public static SqlParam generateUpdateRdbmsTableSql(ModelTable modelTable) {
        String updateRdbmsTableSql = "update dw_rdbms_tables  set table_display_name = ? , table_description = ? where table_name = ?";
        return new SqlParam(updateRdbmsTableSql, new Object[]{modelTable.getComment(), modelTable.getComment(), modelTable.getName()});
    }

    public static SqlParam generateUpdateRdbmsFieldSql(String tableName, TableColumn tableColumn) {
        String isPk = ModelSqlKingbaseGenerator.booleanToYN(tableColumn.isPK());
        String defaultValue = tableColumn.getDefaultValue() != null ? tableColumn.getDefaultValue() : "null";
        Integer size = ModelSqlKingbaseGenerator.getUpdateSize(tableColumn.getSize(), tableColumn.getDataType().getDefaultSize());
        Integer scale = ModelSqlKingbaseGenerator.getUpdateSize(tableColumn.getScale(), tableColumn.getDataType().getDefaultScale());
        String nullable = ModelSqlKingbaseGenerator.booleanToYN(tableColumn.nullable());
        String autoIncrement = ModelSqlKingbaseGenerator.booleanToYN(tableColumn.getAutoIncrement() != false || tableColumn.getAutoIncrement() != false);
        String updateRdbmsFieldSql = "update dw_rdbms_fields  set field_name = ?, is_key = ?, field_type = ? , field_display_name = ?, default_value = ?, nullable = ?, size = ? , scale = ? , is_auto_increment = ? where table_name = ? and field_name = ?";
        return new SqlParam(updateRdbmsFieldSql, new Object[]{tableColumn.getColumnName(), isPk, tableColumn.getDataType().getName(), tableColumn.getComment(), defaultValue, nullable, size, scale, autoIncrement, tableName, tableColumn.getColumnName()});
    }

    public static SqlParam generateUpdateRdbmsFieldRemovePrimarySql(String tableName) {
        String updateRdbmsFieldSql = "update dw_rdbms_fields set is_key = ? where table_name = ?";
        return new SqlParam(updateRdbmsFieldSql, new Object[]{"N", tableName});
    }

    public static SqlParam generateInsertOrUpdateRdbmsFieldWithRemoveAutoIncrementSql(String tableName, TableColumn tableColumn) {
        String insertRdbmsFieldSql = "insert into dw_rdbms_fields (table_name, seq, field_name, field_display_name, nullable, is_auto_increment)  values (?, ?, ?, ?, ?, ?) ON DUPLICATE KEY UPDATE table_name=?, default_value=?, nullable=?, is_auto_increment=?";
        Object[] sqlParamParams = new Object[]{tableName, 0, tableColumn.getColumnName(), tableColumn.getColumnName(), "N", "N", tableName, null, "N", "N"};
        return new SqlParam(insertRdbmsFieldSql, sqlParamParams);
    }

    public static SqlParam generateDeleteRdbmsTableSql(String tableName) {
        String deleteRdbmsTableSql = "delete from dw_rdbms_tables where table_name = ?";
        return new SqlParam(deleteRdbmsTableSql, new Object[]{tableName});
    }

    public static SqlParam generateDeleteRdbmsFieldSql(ModelTable modelTable) {
        String tableName = modelTable.getName();
        String deleteRdbmsFieldSql = "delete from dw_rdbms_fields where table_name = ?";
        return new SqlParam(deleteRdbmsFieldSql, new Object[]{tableName});
    }

    public static SqlParam generateDeleteRdbmsFieldSql(String tableName, String columnName) {
        if (columnName == null || columnName.isEmpty()) {
            String deleteRdbmsTableSql = "delete from dw_rdbms_fields where table_name = ?";
            return new SqlParam(deleteRdbmsTableSql, new Object[]{tableName});
        }
        String deleteRdbmsTableSql = "delete from dw_rdbms_fields where table_name = ? and field_name = ?";
        return new SqlParam(deleteRdbmsTableSql, new Object[]{tableName, columnName});
    }

    public static SqlParam generateDeleteRdbmsRelationForChildTableSql(String primaryTableName, String childTableName) {
        String sql = "delete from dw_rdbms_relations where primary_table_no = ? and reference_table_no = ?";
        return new SqlParam(sql, new Object[]{primaryTableName, childTableName});
    }

    public static String generatePrimaryKeys(String tableName, List<TableColumn> customColumns) {
        List<String> pks = ModelSchemaUtil.getPrimaryKeys(customColumns);
        return ModelSqlKingbaseGenerator.generatePrimaryKeySql(tableName, pks);
    }

    public static String generatePrimaryKeySql(String tableName, List<String> pkMembers) {
        String sql = "CONSTRAINT " + tableName + "_pkey" + " " + "PRIMARY KEY" + " (%s)";
        return String.format(sql, pkMembers.stream().map(pkColumnName -> "`" + pkColumnName + "`").collect(Collectors.joining(",")));
    }

    public static String generateConstrainChainValue(List<String> tablePks) {
        String returnValue = tablePks.stream().map(customColumn -> "`" + customColumn + "`").collect(Collectors.joining(","));
        return returnValue;
    }

    public static String generateIndexes(List<TableIndex> indexes, String tableName) {
        String indexSql = indexes.stream().filter(index -> index.getType() != IndexTypeEnum.PRIMARY_KEY).map(tableIndex -> ModelSqlKingbaseGenerator.generateIndexes(tableIndex, tableName)).collect(Collectors.joining(","));
        return indexSql;
    }

    public static String generateIndexes(TableIndex tableIndex, String tableName) {
        String indexCommand = tableIndex.getType().getIndexCommandChar();
        String indexName = tableIndex.getType() == IndexTypeEnum.PRIMARY_KEY ? tableName + "_pkey" : tableIndex.getName();
        String memberStr = tableIndex.getMember().stream().map(member -> "`" + member + "`").collect(Collectors.joining(","));
        String conditionSql = String.format("%s `%s` %s ( %s )", "CONSTRAINT ", indexName, indexCommand, memberStr);
        return conditionSql;
    }

    public static String booleanToYN(boolean bool) {
        return bool ? "Y" : "N";
    }

    public static String columnUniqueValue(boolean bool) {
        return bool ? "UNIQUE" : "";
    }

    public static ColumnNullableEnum getNullableEnum(boolean bool) {
        return bool ? ColumnNullableEnum.NULL : ColumnNullableEnum.NOT_NULL;
    }

    public static Integer getUpdateSize(Integer updatedInteger, Integer defaultInteger) {
        if (Objects.isNull(updatedInteger)) {
            if (Objects.isNull(defaultInteger)) {
                return 0;
            }
            return defaultInteger;
        }
        return updatedInteger;
    }

    public static String getTypeDDL(TableColumn field) {
        DataTypeEnum dataType = field.getDataType();
        String type = dataType.getType();
        String name = dataType.getName();
        Integer size = field.getSize();
        if (Objects.isNull(size)) {
            size = dataType.getDefaultSize();
        }
        String[] dataTypeNameWithoutSize = new String[]{"JSON", "LONGTEXT", "TEXT"};
        if ("TEXT".equals(type)) {
            if (Arrays.stream(dataTypeNameWithoutSize).anyMatch(name::equals)) {
                return name + " ";
            }
        }
        String[] timeTypeNameWithSize = new String[]{"DATETIME", "TIME", "TIMESTAMP"};
        if ("TIME".equals(type) && Arrays.stream(timeTypeNameWithSize).anyMatch(timeType -> name.equals(timeType) && field.getSize() != null)) {
            return String.format("%s(%s) ", name, size);
        }
        if ("TIME".equals(type)) {
            return name + " ";
        }
        if ("REAL".equals(type)) {
            Integer scale = field.getScale();
            if (Objects.isNull(scale)) {
                scale = dataType.getDefaultScale();
            }
            return String.format("%s(%s,%s) ", name, size, scale);
        }
        return String.format("%s(%s) ", name, size);
    }

    public static String getCombinedSql(SqlParam sqlParam) throws JSQLParserException {
        String sql = sqlParam.getSql();
        Object[] params = sqlParam.getParams();
        Statement statement = CCJSqlParserUtil.parse((String)sql, null);
        if (statement instanceof Insert) {
            Insert insert = (Insert)statement;
            ItemsList itemsList = insert.getItemsList();
            List duplicateUpdateExpressionList = insert.getDuplicateUpdateExpressionList();
            if (itemsList instanceof ExpressionList) {
                Object value;
                int i;
                ExpressionList list = (ExpressionList)itemsList;
                List listExp = list.getExpressions();
                int paramIndex = 0;
                for (Expression expression : listExp) {
                    if (expression instanceof JdbcParameter) {
                        i = ((JdbcParameter)expression).getIndex();
                        value = params[i - 1];
                        sql = sql.replaceFirst("\\?", value == null ? "null" : (value instanceof String ? "'" + value + "'" : (value instanceof Date ? "'" + bindedSqlDateTimeFormat.format(value) + "'" : value.toString())));
                        log.debug("process paramIndex({}) org({}) , new({}), new sql({})", new Object[]{paramIndex, "?", value == null ? "null" : "'" + value.toString() + "'", sql});
                    } else if (expression instanceof StringValue) {
                        SimpleNode node = expression.getASTNode();
                        log.debug("process paramIndex({}) node({})", (Object)paramIndex, node.jjtGetValue());
                    } else if (expression instanceof NullValue) {
                        log.debug("process paramIndex({}) node({})", (Object)paramIndex, (Object)"NULL/null");
                    }
                    ++paramIndex;
                }
                if (CollectionUtils.isNotEmpty((Collection)duplicateUpdateExpressionList)) {
                    int paramLength = list.getExpressions().stream().filter(item -> item.toString().equals("?")).toArray().length;
                    int duplicateUpdateLenthg = duplicateUpdateExpressionList.stream().filter(item -> item.toString().equals("?")).toArray().length;
                    for (i = 0; i < duplicateUpdateLenthg; ++i) {
                        value = params[paramLength + i];
                        sql = sql.replaceFirst("\\?", value == null ? "null" : (value instanceof String ? "'" + value + "'" : (value instanceof Date ? "'" + bindedSqlDateTimeFormat.format(value) + "'" : value.toString())));
                    }
                }
            }
        }
        if (statement instanceof Select) {
            int i = 0;
            while (sql.indexOf("?") != -1) {
                Object value = params[i];
                ++i;
                sql = sql.replaceFirst("\\?", value == null ? "null" : (value instanceof String ? "'" + value + "'" : (value instanceof Date ? "'" + bindedSqlDateTimeFormat.format(value) + "'" : value.toString())));
            }
        }
        return sql;
    }

    public static Map<String, Object> getModelSql(ModelDTO model) throws Exception {
        List<ModelSchemaDTO> childrenModelSchema;
        List<ModelSchemaDTO> childrenSchemas;
        HashMap<String, Object> returnValue = new HashMap<String, Object>();
        ModelSchemaDTO modelSchema = model.getSchema();
        String code = model.getCode();
        ArrayList sqlList = new ArrayList();
        ArrayList<String> bindedSql = new ArrayList<String>();
        SqlParam createModelSqlParam = ModelSqlKingbaseGenerator.generateInsertModelSql(model);
        bindedSql.add(ModelSqlKingbaseGenerator.getCombinedSql(createModelSqlParam));
        ModelTable mainModelTable = ModelSchemaUtil.getCurrentLevelModelTable(modelSchema);
        SqlParam createMainModelInfoSqlParam = ModelSqlKingbaseGenerator.generateInsertModelInfoSql(mainModelTable, model.getCode());
        bindedSql.add(ModelSqlKingbaseGenerator.getCombinedSql(createMainModelInfoSqlParam));
        SqlParam createServiceMappingSqlParam = ModelSqlKingbaseGenerator.generateInsertServiceMappingSql(mainModelTable);
        bindedSql.add(ModelSqlKingbaseGenerator.getCombinedSql(createServiceMappingSqlParam));
        List<SqlParam> createTableSqlParam = ModelSqlKingbaseGenerator.generateCreateTableSql(mainModelTable);
        if (CollectionUtils.isNotEmpty(createTableSqlParam)) {
            createTableSqlParam.forEach(sqlParam -> {
                try {
                    bindedSql.add(ModelSqlKingbaseGenerator.getCombinedSql(sqlParam));
                }
                catch (JSQLParserException e) {
                    throw new RuntimeException(e);
                }
            });
        }
        SqlParam insertRdbmsTableSqlParam = ModelSqlKingbaseGenerator.generateInsertRdbmsTableSql(mainModelTable);
        bindedSql.add(ModelSqlKingbaseGenerator.getCombinedSql(insertRdbmsTableSqlParam));
        List<SqlParam> insertRdbmsFieldSqlParam = ModelSqlKingbaseGenerator.generateInsertOrUpdateRdbmsFieldSql(mainModelTable);
        if (CollectionUtils.isNotEmpty(insertRdbmsFieldSqlParam)) {
            insertRdbmsFieldSqlParam.forEach(sqlParam -> {
                try {
                    bindedSql.add(ModelSqlKingbaseGenerator.getCombinedSql(sqlParam));
                }
                catch (JSQLParserException e) {
                    throw new RuntimeException(e);
                }
            });
        }
        if (CollectionUtils.isNotEmpty(childrenSchemas = modelSchema.getChildren()) && CollectionUtils.isNotEmpty(childrenModelSchema = ModelSchemaUtil.getChildrenModelSchema(childrenSchemas))) {
            for (ModelSchemaDTO childModelSchemaDTO : childrenModelSchema) {
                ModelTable childModelTable = ModelSchemaUtil.getCurrentLevelModelTable(childModelSchemaDTO);
                List<SqlParam> createClildTableSqlParam = ModelSqlKingbaseGenerator.generateCreateTableSql(childModelTable);
                if (CollectionUtils.isNotEmpty(createClildTableSqlParam)) {
                    createClildTableSqlParam.forEach(sqlParam -> {
                        try {
                            bindedSql.add(ModelSqlKingbaseGenerator.getCombinedSql(sqlParam));
                        }
                        catch (JSQLParserException e) {
                            throw new RuntimeException(e);
                        }
                    });
                }
                SqlParam insertClildModelInfoSqlParam = ModelSqlKingbaseGenerator.generateInsertModelInfoSql(childModelTable, code);
                bindedSql.add(ModelSqlKingbaseGenerator.getCombinedSql(insertClildModelInfoSqlParam));
                SqlParam insertChildRdbmsTableSqlParam = ModelSqlKingbaseGenerator.generateInsertRdbmsTableSql(childModelTable);
                bindedSql.add(ModelSqlKingbaseGenerator.getCombinedSql(insertChildRdbmsTableSqlParam));
                List<SqlParam> insertChildRdbmsFieldSqlParam = ModelSqlKingbaseGenerator.generateInsertOrUpdateRdbmsFieldSql(childModelTable);
                if (!CollectionUtils.isNotEmpty(insertRdbmsFieldSqlParam)) continue;
                insertChildRdbmsFieldSqlParam.forEach(sqlParam -> {
                    try {
                        bindedSql.add(ModelSqlKingbaseGenerator.getCombinedSql(sqlParam));
                    }
                    catch (JSQLParserException e) {
                        throw new RuntimeException(e);
                    }
                });
            }
        }
        returnValue.put(code, sqlList);
        returnValue.put("bindedSql", bindedSql);
        return returnValue;
    }

    public static String getSqlByAutoIncrementOrDefaultValue(TableColumn tableColumn) {
        String autoIncrementString = ModelSqlKingbaseGenerator.getSqlByAutoIncrementOrDefaultValue(tableColumn, false);
        return autoIncrementString;
    }

    public static String getSqlByAutoIncrementOrDefaultValue(TableColumn tableColumn, boolean combinePk) {
        String autoIncrementString = tableColumn.getAutoIncrement() != false ? ModelSqlKingbaseGenerator.getAutoIncrement(combinePk) : ModelSqlKingbaseGenerator.getDefaultValue(tableColumn);
        return autoIncrementString;
    }

    public static String getAutoIncrement(boolean combinePk) {
        String autoIncrementCmd = "AUTO_INCREMENT";
        if (combinePk) {
            autoIncrementCmd = autoIncrementCmd + " " + "PRIMARY KEY";
        }
        return autoIncrementCmd;
    }

    public static String getDefaultValue(TableColumn tableColumn) {
        return tableColumn.getDataType() == DataTypeEnum.BIT ? (tableColumn.getDefaultValue() != null ? (tableColumn.getDefaultValue().toUpperCase().equals("1") ? "DEFAULT TRUE" : "DEFAULT FALSE") : "") : (tableColumn.getDefaultValue() != null ? "DEFAULT '" + (tableColumn.getDefaultValue().equals("\"\"") ? "" : tableColumn.getDefaultValue()) + "'" : "");
    }

    public static String getCollation(DataTypeEnum dataType, boolean existedTable, AlterColumnEnum alterColumnEnum) {
        String returnValue = "";
        String name = dataType.getName();
        String type = dataType.getType();
        if (existedTable && alterColumnEnum == AlterColumnEnum.MODIFY_COLUMN) {
            if (!Arrays.stream(ModelDBConstants.MYSQL_SQL_COLLATE_IGNORE_DATA_NAME).anyMatch(name::equals)) {
                if (!Arrays.stream(ModelDBConstants.MYSQL_SQL_COLLATE_IGNORE_DATA_TYPE).anyMatch(type::equals)) {
                    returnValue = String.format(" COLLATE '%s' ", "utf8mb4_bin");
                }
            }
        }
        return returnValue;
    }

    public static String getDefaultValue(TableColumn tableColumn, boolean existedTable) {
        if (existedTable) {
            String columnName = tableColumn.getColumnName();
            if (columnName.equals("create_date")) {
                return "DEFAULT current_timestamp()";
            }
            if (columnName.equals("modified_date")) {
                return "DEFAULT NULL ON UPDATE current_timestamp()";
            }
        }
        return ModelSqlKingbaseGenerator.getDefaultValue(tableColumn);
    }

    public static TableSqlParamDTO getCreateTable(ModelTable modelTable) {
        TableSqlParamDTO tableSqlParamDTO = new TableSqlParamDTO();
        SqlParam createRdbmsTableParam = ModelSqlKingbaseGenerator.generateInsertRdbmsTableSql(modelTable);
        tableSqlParamDTO.getDmlSqlParams().add(createRdbmsTableParam);
        List<SqlParam> createRdbmsFieldsParam = ModelSqlKingbaseGenerator.generateInsertOrUpdateRdbmsFieldSql(modelTable);
        tableSqlParamDTO.getDmlSqlParams().addAll(createRdbmsFieldsParam);
        List<SqlParam> createTableSqlParam = ModelSqlKingbaseGenerator.generateCreateTableSql(modelTable);
        tableSqlParamDTO.getDdlSqlParams().addAll(createTableSqlParam);
        if (log.isDebugEnabled()) {
            log.debug(">>>>> gen Insert Rdbms SQL: {}", (Object)modelTable.getName(), (Object)tableSqlParamDTO.toString());
            log.debug(">>>>> gen Create Table SQL: {}", (Object)modelTable.getName(), createTableSqlParam);
        }
        return tableSqlParamDTO;
    }

    public static Map<String, LinkedHashMap<String, List<SqlParam>>> getDropChildTables(List<ModelTable> childTableNames) {
        LinkedHashMap<String, LinkedHashMap<String, List<SqlParam>>> returnValue = new LinkedHashMap<String, LinkedHashMap<String, List<SqlParam>>>();
        for (ModelTable modelTable : childTableNames) {
            ArrayList<SqlParam> dmlSqlParams = new ArrayList<SqlParam>();
            ArrayList<SqlParam> ddlSqlParams = new ArrayList<SqlParam>();
            LinkedHashMap<String, ArrayList<SqlParam>> childDDMLValue = new LinkedHashMap<String, ArrayList<SqlParam>>();
            String childTableName = modelTable.getName();
            SqlParam deleteRdbmsTableParam = ModelSqlKingbaseGenerator.generateDeleteRdbmsTableSql(childTableName);
            dmlSqlParams.add(deleteRdbmsTableParam);
            SqlParam deleteRdbmsFieldsParam = ModelSqlKingbaseGenerator.generateDeleteRdbmsFieldSql(modelTable);
            dmlSqlParams.add(deleteRdbmsFieldsParam);
            childDDMLValue.put("dml", dmlSqlParams);
            if (log.isDebugEnabled()) {
                log.debug(">>>>> gen Delete Rdbms Table Params: modelTable = {}", (Object)childTableName);
                log.debug(">>>>> gen Delete Rdbms Table SQL: {}", (Object)deleteRdbmsTableParam);
                log.debug(">>>>> gen Delete Rdbms Fields Params: modelTable = {}", (Object)modelTable.getName());
                log.debug(">>>>> gen Delete Rdbms Fields SQL: {}", dmlSqlParams);
            }
            SqlParam dropTableSqlParam = ModelSqlKingbaseGenerator.generateDropTableSql(childTableName);
            ddlSqlParams.add(dropTableSqlParam);
            childDDMLValue.put("ddl", ddlSqlParams);
            returnValue.put(childTableName, childDDMLValue);
        }
        return returnValue;
    }

    public static Map<String, LinkedHashMap<String, List<SqlParam>>> getCreateChildTablesCommand(String primaryTableName, String primaryKeyName, List<ModelTable> childrenTables, String foreignKeyName) {
        LinkedHashMap<String, LinkedHashMap<String, List<SqlParam>>> returnValue = new LinkedHashMap<String, LinkedHashMap<String, List<SqlParam>>>();
        for (ModelTable modelTable : childrenTables) {
            LinkedHashMap childDDMLValue = new LinkedHashMap();
            String childTableName = modelTable.getName();
            ArrayList<SqlParam> dmlSqlParams = new ArrayList<SqlParam>();
            ArrayList<SqlParam> ddlSqlParams = new ArrayList<SqlParam>();
            SqlParam insertRdbmsTableParam = ModelSqlKingbaseGenerator.generateInsertRdbmsTableSql(modelTable);
            dmlSqlParams.add(insertRdbmsTableParam);
            List<SqlParam> insertOrUpdateRdbmsFieldsParam = ModelSqlKingbaseGenerator.generateInsertOrUpdateRdbmsFieldSql(modelTable);
            dmlSqlParams.addAll(insertOrUpdateRdbmsFieldsParam);
            childDDMLValue.put("dml", dmlSqlParams);
            if (log.isDebugEnabled()) {
                log.debug(">>>>> gen Insert Rdbms Table Params: modelTable = {}", (Object)modelTable.getName());
                log.debug(">>>>> gen Insert Rdbms Table SQL: {}", (Object)insertRdbmsTableParam);
                log.debug(">>>>> gen Insert Rdbms Fields Params: modelTable = {}", (Object)modelTable);
                log.debug(">>>>> gen Insert Rdbms Fields SQL: {}", dmlSqlParams);
            }
            List<SqlParam> createTableSqlParam = ModelSqlKingbaseGenerator.generateCreateTableSql(modelTable);
            ddlSqlParams.addAll(createTableSqlParam);
            childDDMLValue.put("ddl", ddlSqlParams);
            returnValue.put(childTableName, childDDMLValue);
        }
        return returnValue;
    }

    public static Map<String, Object> getAlterIndexesInfo(String tableName, AlterIndexEnum alterIndexEnum, List<TableIndex> tableIndexes, LinkedList<SqlParam> alterDDLSqlParam) {
        HashMap<String, Object> returnValue = new HashMap<String, Object>();
        tableIndexes.forEach(tableIndex -> {
            LinkedList<Object> alterTableSqlParams = new LinkedList();
            alterTableSqlParams = ModelSqlKingbaseGenerator.generateAlterIndexSql(tableName, alterIndexEnum, tableIndex);
            alterDDLSqlParam.addAll(alterTableSqlParams);
            if (log.isDebugEnabled()) {
                log.debug(">>>>> gen Alter indexes Params: tableName = {}, alterIndexEnum = {}, tableIndex = {}", new Object[]{tableName, alterIndexEnum, tableIndex});
                log.debug(">>>>> gen Alter indexes SQL: {}", alterTableSqlParams);
            }
        });
        return returnValue;
    }

    public static LinkedHashMap<String, List<SqlParam>> getAlterTableInfo(ModelTable modelTable) {
        LinkedHashMap<String, List<SqlParam>> returnValue = new LinkedHashMap<String, List<SqlParam>>();
        LinkedList<SqlParam> alterDDLSqlParam = new LinkedList<SqlParam>();
        LinkedList<SqlParam> alterDMLSqlParam = new LinkedList<SqlParam>();
        returnValue.put("dml", alterDMLSqlParam);
        returnValue.put("ddl", alterDDLSqlParam);
        String tableName = modelTable.getName();
        String tableComment = modelTable.getComment();
        SqlParam alterTableSqlParam = ModelSqlKingbaseGenerator.generateAlterTableSql(tableName, tableComment);
        alterDDLSqlParam.add(alterTableSqlParam);
        SqlParam alterRdbmsSqlParam = ModelSqlKingbaseGenerator.generateUpdateRdbmsTableSql(modelTable);
        alterDMLSqlParam.add(alterRdbmsSqlParam);
        if (log.isDebugEnabled()) {
            log.debug(">>>>> gen Alter Table Params: tableName = {}, tableComment = {} ", (Object)tableName, (Object)tableComment);
            log.debug(">>>>> gen Alter Table SQL: {}", (Object)alterTableSqlParam);
            log.debug(">>>>> gen Update Rdbms Tables Params: customTables = {}", (Object)modelTable);
            log.debug(">>>>> gen Update Rdbms Tables SQL: sql = {}, params = {}", (Object)alterRdbmsSqlParam.getSql(), (Object)alterRdbmsSqlParam.getParams());
        }
        return returnValue;
    }

    public static Map<AlterIndexEnum, List<TableIndex>> getAlterColumnUniqueIndexesWhenModifyModel(List<ModelFieldDTO> draftModelFields, List<ModelFieldDTO> publishedModelFields, List<TableIndex> actualTableIndexes) {
        log.debug("[ModelSqlKingbaseGenerator][getAlterColumnUniqueIndexes]");
        List modifyColumnsOfDraft = draftModelFields.stream().filter(draftModelField -> ModelSchemaUtil.checkRelatedType(draftModelField) && !draftModelField.getAutoIncrement() && !ModelDBConstants.UNIQUE_INDEX_EXCLUDED_DATATYPE.contains(draftModelField.getFieldType()) && publishedModelFields.stream().anyMatch(publishedModelField -> Objects.equals(draftModelField.getFieldId(), publishedModelField.getFieldId()) && !Objects.equals(draftModelField.getUnique(), publishedModelField.getUnique()))).collect(Collectors.toList());
        log.info("[ModelSqlKingbaseGenerator]comparing column-unique -> compare modify({}), actual({})", modifyColumnsOfDraft.stream().map(idx -> idx.getFieldId()).collect(Collectors.toList()), actualTableIndexes.stream().map(idx -> idx.getName()).collect(Collectors.toList()));
        List validAddColumnUniqueIndexes = modifyColumnsOfDraft.stream().filter(modelField -> modelField.getUnique() && actualTableIndexes.stream().noneMatch(actualTableIndex -> Objects.equals(actualTableIndex.getName(), modelField.getFieldId()))).map(ModelSchemaUtil::convertModelFieldToTableUniqueIndex).collect(Collectors.toList());
        log.info(_CLASSTAG + " column-unique -> validAddColumnUniqueIndexes({})", validAddColumnUniqueIndexes.stream().map(idx -> idx.getName()).collect(Collectors.toList()));
        List validDropColumnUniqueIndexes = modifyColumnsOfDraft.stream().filter(modelField -> !modelField.getUnique() && actualTableIndexes.stream().anyMatch(actualTableIndex -> Objects.equals(actualTableIndex.getName(), modelField.getFieldId()))).map(ModelSchemaUtil::convertModelFieldToTableUniqueIndex).collect(Collectors.toList());
        log.info(_CLASSTAG + " comparing column-unique -> validDropColumnUniqueIndexes({})", validDropColumnUniqueIndexes.stream().map(idx -> idx.getName()).collect(Collectors.toList()));
        HashMap<AlterIndexEnum, List<TableIndex>> alterColumnUniqueIndexes = new HashMap<AlterIndexEnum, List<TableIndex>>();
        alterColumnUniqueIndexes.put(AlterIndexEnum.ADD, validAddColumnUniqueIndexes);
        alterColumnUniqueIndexes.put(AlterIndexEnum.DROP, validDropColumnUniqueIndexes);
        return alterColumnUniqueIndexes;
    }

    public static Map<AlterIndexEnum, List<TableIndex>> getAlterIndexesMapWithActualModelTable(ModelTable draftModelTable, ModelTable publishedModelTable, ModelTable actualModelTable) {
        List<TableIndex> dropColumnUniqueIndexes;
        List<TableIndex> modifyUniqueIndexesFromColumn;
        List<TableIndex> draftTableIndexes = draftModelTable.getIndexes();
        List<TableIndex> publishedTableIndexes = null;
        if (publishedModelTable != null) {
            publishedTableIndexes = publishedModelTable.getIndexes();
        }
        List<TableIndex> actualTableIndexes = actualModelTable.getIndexes();
        log.debug(_CLASSTAG + "[getAlterIndexesMap] comparing indexes -> 1.[draftTableIndexes]{}, 2.[publishedTableIndexes]{}, 3.[actualIndexes]{}", new Object[]{draftTableIndexes, publishedTableIndexes, actualTableIndexes});
        List<TableIndex> addIndexes = IndexCompareKingbaseUtil.getAddIndexes(draftTableIndexes, actualTableIndexes);
        List<TableIndex> modifyIndexes = IndexCompareKingbaseUtil.getModifyIndexes(draftTableIndexes, actualTableIndexes);
        List<TableIndex> dropIndexes = IndexCompareUtil.getDropIndexes(draftTableIndexes, actualTableIndexes, publishedTableIndexes);
        Map<AlterIndexEnum, List<TableIndex>> alterColumnsUniqueMap = IndexCompareUtil.getAlterColumnUniqueIndexesWhenCompareExistedTable(draftModelTable.getColumns(), actualModelTable.getColumns(), publishedModelTable.getColumns());
        List<TableIndex> addColumnUniqueIndexes = alterColumnsUniqueMap.get((Object)AlterIndexEnum.ADD);
        if (CollectionUtils.isNotEmpty(addColumnUniqueIndexes)) {
            addIndexes.addAll(addColumnUniqueIndexes);
        }
        if (CollectionUtils.isNotEmpty(modifyUniqueIndexesFromColumn = alterColumnsUniqueMap.get((Object)AlterIndexEnum.MODIFY))) {
            modifyIndexes.addAll(modifyUniqueIndexesFromColumn);
        }
        if (CollectionUtils.isNotEmpty(dropColumnUniqueIndexes = alterColumnsUniqueMap.get((Object)AlterIndexEnum.DROP))) {
            dropIndexes.addAll(dropColumnUniqueIndexes);
        }
        HashMap<AlterIndexEnum, List<TableIndex>> alterTableIndexesMap = new HashMap<AlterIndexEnum, List<TableIndex>>();
        if (CollectionUtils.isNotEmpty(addIndexes)) {
            alterTableIndexesMap.put(AlterIndexEnum.ADD, addIndexes);
        }
        if (CollectionUtils.isNotEmpty(modifyIndexes)) {
            alterTableIndexesMap.put(AlterIndexEnum.MODIFY, modifyIndexes);
        }
        if (CollectionUtils.isNotEmpty(dropIndexes)) {
            alterTableIndexesMap.put(AlterIndexEnum.DROP, dropIndexes);
        }
        if (log.isDebugEnabled()) {
            log.debug("publishing model table({}) (comparing indexes) -> addIndexes = {}, modifyIndexes = {}, dropIndexes = {}", new Object[]{draftModelTable.getName(), addIndexes.stream().map(idx -> idx.getName()).collect(Collectors.toList()), modifyIndexes.stream().map(idx -> idx.getName()).collect(Collectors.toList()), dropIndexes.stream().map(idx -> idx.getName()).collect(Collectors.toList())});
        }
        return alterTableIndexesMap;
    }

    public static SqlParam getDropPrimaryKeySql(String tableName) {
        String dropPrimaryKeySql = String.format("ALTER TABLE `%s` DROP PRIMARY KEY", tableName);
        if (log.isDebugEnabled()) {
            log.debug(">>>>> gen Alter Columns Params: tableName = {}, sql = {}", (Object)tableName, (Object)dropPrimaryKeySql);
        }
        SqlParam sqlParam = new SqlParam();
        sqlParam.setSql(dropPrimaryKeySql);
        sqlParam.setParams(new Object[0]);
        return sqlParam;
    }

    public static void getAddPrimaryKeyOnly(ModelTable modelTable, LinkedList<SqlParam> ddlSqlParams, LinkedList<SqlParam> dmlSqlParams) {
        List<String> remainPks;
        String primaryKeysSql = ModelSqlKingbaseGenerator.generatePrimaryKeys(modelTable.getName(), modelTable.getColumns());
        TableIndex modelTablePk = modelTable.getIndexes().stream().filter(tableIndex -> tableIndex.getType() == IndexTypeEnum.PRIMARY_KEY).findFirst().orElse(null);
        ModelTableSchemaCache target = ModelDrivenContext.getPublishedTableCache(modelTable.getName());
        Map<String, Object> indexes = target.getPublishedRemainIndexes();
        TableIndex pkTableIndex = (TableIndex)indexes.get("PRIMARY KEY");
        if (modelTablePk == null || (remainPks = pkTableIndex.getMember()).size() != 1 || remainPks.get(0).equals(modelTablePk.getMember().get(0))) {
            // empty if block
        }
        String alterTableAddPrimarySql = String.format("ALTER TABLE `%s` ADD %s ", modelTable.getName(), primaryKeysSql);
        if (log.isDebugEnabled()) {
            log.debug(">>>>> gen Alter Columns Params: tableName = {}, sql = {}", (Object)modelTable.getName(), (Object)alterTableAddPrimarySql);
        }
        SqlParam sqlParam = new SqlParam();
        sqlParam.setSql(alterTableAddPrimarySql);
        sqlParam.setParams(new Object[0]);
        ddlSqlParams.add(sqlParam);
    }

    public static SqlParam getAlterPrimaryKeySql(ModelTable modelTable) {
        String primaryKeysSql = ModelSqlKingbaseGenerator.generatePrimaryKeys(modelTable.getName(), modelTable.getColumns());
        String dropAndAddTablePrimarySql = String.format("ALTER TABLE `%s` DROP PRIMARY KEY, ADD %s ", modelTable.getName(), primaryKeysSql);
        if (log.isDebugEnabled()) {
            log.debug(">>>>> gen Alter Columns Params: tableName = {}, sql = {}", (Object)modelTable.getName(), (Object)dropAndAddTablePrimarySql);
        }
        SqlParam sqlParam = new SqlParam();
        sqlParam.setSql(dropAndAddTablePrimarySql);
        sqlParam.setParams(new Object[0]);
        return sqlParam;
    }

    public static List<SqlParam> getAlterPrimaryKeySql(ModelTable draftSimpleModelTable, ModelTable publishedSimpleModelTable, Map<AlterColumnEnum, List<TableColumn>> alterColumnsMap) {
        List<String> draftModelPks = ModelSchemaUtil.getPrimaryKeys(draftSimpleModelTable.getColumns());
        List<String> publishedModelPks = ModelSchemaUtil.getPrimaryKeys(publishedSimpleModelTable.getColumns());
        List<TableColumn> dropTableColumns = alterColumnsMap.get((Object)AlterColumnEnum.MODIFY_COLUMN);
        List dropPKTableColumns = dropTableColumns.stream().filter(dropTableColumn -> dropTableColumn.isPK()).collect(Collectors.toList());
        AtomicBoolean isChangePk = new AtomicBoolean(false);
        alterColumnsMap.forEach((alterColumnEnum, tableColumns) -> {
            if (!isChangePk.get() && !CollectionUtils.isEmpty((Collection)tableColumns)) {
                tableColumns.stream().forEach(tableColumn -> {
                    if (tableColumn.isPK().booleanValue()) {
                        isChangePk.set(true);
                    }
                });
            }
        });
        ArrayList<SqlParam> sqlParams = new ArrayList<SqlParam>();
        if (isChangePk.get()) {
            String dropAndAddTablePrimarySql = String.format("ALTER TABLE `%s` DROP %s ", draftSimpleModelTable.getName(), "PRIMARY KEY");
            List<TableColumn> draftColumns = draftSimpleModelTable.getColumns();
            if (CollectionUtils.isNotEmpty(draftColumns)) {
                String primaryKeysSql = ModelSqlKingbaseGenerator.generatePrimaryKeys(draftSimpleModelTable.getName(), draftColumns);
                dropAndAddTablePrimarySql = String.format(dropAndAddTablePrimarySql + " , ADD %s ", primaryKeysSql);
            }
            if (log.isDebugEnabled()) {
                log.debug(">>>>> gen Alter Columns Params: tableName = {}, sql = {}", (Object)draftSimpleModelTable.getName(), (Object)dropAndAddTablePrimarySql);
            }
            SqlParam sqlParam = new SqlParam();
            sqlParam.setSql(dropAndAddTablePrimarySql);
            sqlParam.setParams(new Object[0]);
            sqlParams.add(sqlParam);
        }
        return sqlParams;
    }

    public static void getAlterAutoIncrementSql(ModelTable modelTable, LinkedList<SqlParam> ddlSqlParams, LinkedList<SqlParam> dmlSqlParams) {
        TableColumn tableColumn = modelTable.getColumns().stream().filter(currentTableColumn -> currentTableColumn.getAutoIncrement()).findFirst().get();
        if (Objects.nonNull((Object)tableColumn)) {
            String modifyColumnSql = String.format("ALTER TABLE `%s` %s `%s`  %s %s %s %s '%s'", modelTable.getName(), AlterColumnEnum.MODIFY_COLUMN.getSqlChar(), tableColumn.getColumnName(), ModelSqlKingbaseGenerator.getTypeDDL(tableColumn), ModelSqlKingbaseGenerator.getNullableEnum(tableColumn.nullable()).getSqlChar(), "AUTO_INCREMENT", "COMMENT", tableColumn.getComment());
            if (log.isDebugEnabled()) {
                log.debug(">>>>> gen Alter Columns Params: tableName = {}, sql = {}", (Object)modelTable.getName(), (Object)modifyColumnSql);
            }
            SqlParam sqlParam = new SqlParam();
            sqlParam.setSql(modifyColumnSql);
            sqlParam.setParams(new Object[0]);
            ddlSqlParams.add(sqlParam);
        }
    }

    public static void removePk(List<String> pks, String dropPk) {
        pks.remove(dropPk);
    }

    public static List<SqlParam> genDropOrAddPrimaryKey(String tableName, List<String> remainPks, boolean isDropFirst) {
        if (log.isDebugEnabled()) {
            log.debug("[genDropOrAddPrimaryKey] tableName({}), remainPks({}), isDropFirst({})", new Object[]{tableName, remainPks, isDropFirst});
        }
        List sqlPks = remainPks.stream().map(pk -> "`" + pk + "`").collect(Collectors.toList());
        Table alterTable = new Table("`" + tableName + "`");
        Alter alterPkScript = new Alter();
        alterPkScript.setTable(alterTable);
        ArrayList<AlterExpression> alterExpressions = new ArrayList<AlterExpression>();
        if (isDropFirst) {
            AlterExpression dropPkNameExpression = new AlterExpression();
            dropPkNameExpression.setOperation(AlterOperation.DROP_PRIMARY_KEY);
            alterExpressions.add(dropPkNameExpression);
            if (log.isDebugEnabled()) {
                log.debug("[genDropOrAddPrimaryKey] tableName = {}, after drop pk", (Object)tableName);
            }
        }
        if (CollectionUtils.isNotEmpty(sqlPks)) {
            AlterExpression addPkNameExpression = new AlterExpression();
            addPkNameExpression.setOperation(AlterOperation.ADD);
            addPkNameExpression.addPkColumns(sqlPks);
            alterExpressions.add(addPkNameExpression);
            if (log.isDebugEnabled()) {
                log.debug("[genDropOrAddPrimaryKey] tableName = {}, add Pks = {}", (Object)tableName, sqlPks);
            }
        }
        alterPkScript.setAlterExpressions(alterExpressions);
        String dropAndAddTablePrimarySql = alterPkScript.toString();
        SqlParam sqlParam = new SqlParam();
        sqlParam.setSql(dropAndAddTablePrimarySql);
        sqlParam.setParams(new Object[0]);
        ArrayList<SqlParam> returnValue = new ArrayList<SqlParam>();
        returnValue.add(sqlParam);
        return returnValue;
    }

    public static List<SqlParam> genDropAndAddPrimaryKeyByDropColumnsSql(ModelTable publishedModelTable, List<TableColumn> draftHavePkOfDropTableColumns) {
        String tableName = publishedModelTable.getName();
        List<String> publishedPks = ModelSchemaUtil.getPrimaryKeys(publishedModelTable.getColumns());
        List<String> dropPks = ModelSchemaUtil.getPrimaryKeys(draftHavePkOfDropTableColumns);
        if (log.isDebugEnabled()) {
            log.debug("[genDropAndAddPrimaryKeyByDropColumnsSql] tableName = {}, draft dropPks = {}, publishedPks = {}", new Object[]{tableName, dropPks, publishedPks});
        }
        dropPks.stream().forEach(dropPk -> publishedPks.remove(dropPk));
        List sqlPks = publishedPks.stream().map(pk -> "`" + pk + "`").collect(Collectors.toList());
        Table alterTable = new Table("`" + tableName + "`");
        Alter alterPkScript = new Alter();
        alterPkScript.setTable(alterTable);
        ArrayList<AlterExpression> alterExpressions = new ArrayList<AlterExpression>();
        AlterExpression dropPkNameExpression = new AlterExpression();
        dropPkNameExpression.setOperation(AlterOperation.DROP_PRIMARY_KEY);
        alterExpressions.add(dropPkNameExpression);
        if (CollectionUtils.isNotEmpty(sqlPks)) {
            AlterExpression addPkNameExpression = new AlterExpression();
            addPkNameExpression.setOperation(AlterOperation.ADD);
            addPkNameExpression.addPkColumns(sqlPks);
            alterExpressions.add(addPkNameExpression);
            if (log.isDebugEnabled()) {
                log.debug("[genDropAndAddPrimaryKeyByDropColumnsSql] tableName = {}, after drop pk, add Pks = {}", (Object)tableName, sqlPks);
            }
        }
        alterPkScript.setAlterExpressions(alterExpressions);
        String dropAndAddTablePrimarySql = alterPkScript.toString();
        SqlParam sqlParam = new SqlParam();
        sqlParam.setSql(dropAndAddTablePrimarySql);
        sqlParam.setParams(new Object[0]);
        ArrayList<SqlParam> returnValue = new ArrayList<SqlParam>();
        returnValue.add(sqlParam);
        return returnValue;
    }

    public static LinkedList<SqlParam> genAlterTableUniqueIndex(ModelTable modelTable, List<String> newIndexMember, ModelIndexDTO publishedModelIndexDTO) {
        String uniqueId;
        LinkedList<SqlParam> returnValue = new LinkedList<SqlParam>();
        String tableName = modelTable.getName();
        Map<String, ModelTableSchemaCache> publishedTableCache = ModelDrivenContext.getContext().getPublishedTableCache();
        ModelTableSchemaCache modelTableSchemaCache = publishedTableCache.get(tableName);
        Map<String, Object> publishedRemainIndexes = modelTableSchemaCache.getPublishedRemainIndexes();
        if (publishedRemainIndexes.containsKey(uniqueId = publishedModelIndexDTO.getId()) && !uniqueId.equals("PRIMARY KEY")) {
            log.info("flag3");
            String dropAndAddModelIndexSql = String.format("ALTER TABLE `%s` DROP INDEX `%s` ", tableName, uniqueId);
            SqlParam sqlParam = new SqlParam();
            sqlParam.setSql(dropAndAddModelIndexSql);
            sqlParam.setParams(new Object[0]);
            returnValue.add(sqlParam);
            publishedRemainIndexes.remove(uniqueId);
            if (log.isDebugEnabled()) {
                log.debug(">>>>> gen Alter unique index: tableName:{}, sql:{}, dropped index:({})", new Object[]{tableName, dropAndAddModelIndexSql, publishedModelIndexDTO});
            }
        } else {
            log.warn(">>>>> ignored to gen Alter unique index: tableName = {}, unique id = {}, cause remain({})", new Object[]{tableName, uniqueId, publishedRemainIndexes});
        }
        return returnValue;
    }

    public static void updateAlterColumnsInfoOnly(String tableName, AlterColumnEnum alterColumnEnum, List<TableColumn> modelColumns, LinkedHashMap<AlterAutoIncrementEnum, TableColumn> changedAutoIncrmt, LinkedList<SqlParam> targetDDLSqlParam, LinkedList<SqlParam> targetDMLSqlParam) {
        modelColumns.forEach(modelColumn -> {
            LinkedList<SqlParam> alterTableSqlParam = ModelSqlKingbaseGenerator.generateAlterColumnsSql(tableName, alterColumnEnum, modelColumn);
            targetDDLSqlParam.addAll(alterTableSqlParam);
            if (alterColumnEnum == AlterColumnEnum.DROP_COLUMN) {
                SqlParam deleteRdbmsFieldSql = ModelSqlKingbaseGenerator.generateDeleteRdbmsFieldSql(tableName, modelColumn.getColumnName());
                targetDMLSqlParam.add(deleteRdbmsFieldSql);
            }
            if (log.isDebugEnabled()) {
                log.debug(">>>>> gen Alter Columns Params: tableName = {}, alterColumnEnum = {}, customColumn = {}", new Object[]{tableName, alterColumnEnum, modelColumn});
                log.debug(">>>>> gen Alter Columns SQL: {}", alterTableSqlParam);
            }
        });
    }

    public static String getUserRowPermissionConditionSql(DWUserPermission userPermission, PlainSelect select) throws Exception {
        String sql = null;
        Field rowPermissionField = DWUserPermission.class.getDeclaredField("rowPermission");
        rowPermissionField.setAccessible(true);
        Object userRowPermission = rowPermissionField.get(userPermission);
        if (userPermission.isSuperadmin()) {
            log.debug(String.format("[report permission] superadmin", new Object[0]));
            return "";
        }
        if (userRowPermission != null) {
            if (userRowPermission instanceof DWRowPermissionGroup) {
                ModelSqlKingbaseGenerator.dealDWRowPermissionGroup(userRowPermission, select);
            } else if (userRowPermission instanceof DWRowPermissionEmpty) {
                sql = " 1 <> 1";
            } else {
                DWRowPermissionBase dwRowPermissionSingleFieldValue = (DWRowPermissionBase)userRowPermission;
                dwRowPermissionSingleFieldValue.setFilterField(select.getFromItem().getAlias() == null ? select.getFromItem().toString() + "." + dwRowPermissionSingleFieldValue.getFilterField() : select.getFromItem().getAlias().toString() + "." + dwRowPermissionSingleFieldValue.getFilterField());
            }
            log.debug(String.format("[report permission] row permission sql: {} permission type is :{}", new Object[0]), (Object)((DWRowPermissionBase)userRowPermission).getSQLContainValues((DWRowPermissionMatchOption)new DWRowPermissionDefaultMatchOption(true)), rowPermissionField.get(userPermission));
        } else {
            log.debug(String.format("[report permission] has no row permission", new Object[0]));
        }
        if (sql == null && "".equals(sql = userPermission.getRowPermission().getSQLContainValues((DWRowPermissionMatchOption)new DWRowPermissionDefaultMatchOption(true)))) {
            sql = " 1 <> 1";
        }
        return sql;
    }

    private static void dealDWRowPermissionGroup(Object rowPermission, PlainSelect select) {
        DWRowPermissionGroup rowPermissionGroup = (DWRowPermissionGroup)rowPermission;
        List dwRowPermissions = rowPermissionGroup.getFilterValue();
        Iterator it = dwRowPermissions.iterator();
        while (it.hasNext()) {
            Object filterVaule = it.next();
            if (filterVaule instanceof DWRowPermissionGroup) {
                ModelSqlKingbaseGenerator.dealDWRowPermissionGroup(filterVaule, select);
                continue;
            }
            DWRowPermissionBase dwRowPermissionFilterValue = (DWRowPermissionBase)filterVaule;
            if (!ModelSqlKingbaseGenerator.verifyRowPermission(dwRowPermissionFilterValue)) {
                it.remove();
                continue;
            }
            dwRowPermissionFilterValue.setFilterField(select.getFromItem().getAlias() == null ? select.getFromItem().toString() + "." + dwRowPermissionFilterValue.getFilterField() : select.getFromItem().getAlias().toString() + "." + dwRowPermissionFilterValue.getFilterField());
        }
    }

    private static boolean verifyRowPermission(DWRowPermissionBase rowPermission) {
        String filterTable = rowPermission.getFilterTable();
        String filterField = rowPermission.getFilterField();
        try {
            DWMetadata<?> masterTableRdbmsMetadata = ModelDrivenMetadataUtil.loadRdbmsMetadata(filterTable);
            return masterTableRdbmsMetadata.getFields().stream().anyMatch(field -> ((DWRdbmsField)field).getName().equals(filterField));
        }
        catch (DWMetadataNotFoundException e) {
            return false;
        }
    }

    public static String getPrimaryKeyCondition(String tableName, String autoIncrementOrDefaultValue, TableColumn TableColumn2) {
        String primaryKeyCondition = "";
        String targetColumnName = TableColumn2.getColumnName();
        ArrayList<String> draftPks = new ArrayList<String>();
        draftPks.add(targetColumnName);
        if (autoIncrementOrDefaultValue.toUpperCase().contains("AUTO_INCREMENT")) {
            ModelTableSchemaCache target = ModelDrivenContext.getPublishedTableCache(tableName);
            Map<String, Object> remainIndexes = target.getPublishedRemainIndexes();
            if (remainIndexes.containsKey("PRIMARY KEY")) {
                TableIndex actualPKTableIndex = (TableIndex)remainIndexes.get("PRIMARY KEY");
                List<String> remainPks = actualPKTableIndex.getMember();
                if (remainPks.size() == 1 && remainPks.get(0).equals(targetColumnName)) {
                    log.debug(_CLASSTAG + "[getPrimaryKeyCondition] no changed({})", remainPks);
                } else if (!remainPks.equals(draftPks)) {
                    log.info(_CLASSTAG + "[getPrimaryKeyCondition] 1.remainPks({}) size>1,", remainPks);
                    primaryKeyCondition = String.format(" DROP %s , ADD %s (`%s`) ", "PRIMARY KEY", "CONSTRAINT  " + tableName + "_pkey" + " " + "PRIMARY KEY", targetColumnName);
                    remainPks.clear();
                    remainPks.add(targetColumnName);
                    log.info(_CLASSTAG + "[getPrimaryKeyCondition] 2.primaryCondition({}), ", (Object)primaryKeyCondition);
                }
            } else {
                primaryKeyCondition = String.format(" ADD %s (`%s`)", "CONSTRAINT  " + tableName + "_pkey" + " " + "PRIMARY KEY", targetColumnName);
                ArrayList<String> members = new ArrayList<String>();
                members.add(targetColumnName);
                TableIndex tableIndex = new TableIndex();
                tableIndex.setMember(members);
                tableIndex.setType(IndexTypeEnum.PRIMARY_KEY);
                remainIndexes.put("PRIMARY KEY", tableIndex);
                log.info(_CLASSTAG + "[getPrimaryKeyCondition] primaryCondition({}), new pk index()", (Object)primaryKeyCondition, (Object)tableIndex);
            }
        }
        log.info(_CLASSTAG + " tableColumn({}) add pkCondtion({})", (Object)TableColumn2.getColumnName(), (Object)primaryKeyCondition);
        return primaryKeyCondition;
    }
}

