/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.lcdp.modeldriven.utils;

import com.digiwin.app.ddl.enums.DataTypeEnum;
import com.digiwin.lcdp.modeldriven.enums.IndexTypeEnum;
import com.digiwin.lcdp.modeldriven.model.TableColumn;
import com.digiwin.lcdp.modeldriven.model.TableIndex;
import com.digiwin.lcdp.modeldriven.utils.DBTableUtil;
import com.digiwin.lcdp.modeldriven.utils.ModelDrivenCCJParserUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import net.sf.jsqlparser.JSQLParserException;
import net.sf.jsqlparser.parser.CCJSqlParserUtil;
import net.sf.jsqlparser.statement.Statement;
import net.sf.jsqlparser.statement.create.table.ColDataType;
import net.sf.jsqlparser.statement.create.table.ColumnDefinition;
import net.sf.jsqlparser.statement.create.table.CreateTable;
import net.sf.jsqlparser.statement.create.table.Index;
import net.sf.jsqlparser.statement.select.Select;
import net.sf.jsqlparser.util.TablesNamesFinder;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ModelSqlParserKingbaseUtil {
    private static final Logger log = LoggerFactory.getLogger(ModelSqlParserKingbaseUtil.class);
    private static final String _CLASSTAG = "[" + ModelSqlParserKingbaseUtil.class.getSimpleName() + "]";

    public static boolean checkColumnUniqueIndex(Index index, String columnName) {
        String ccjIndexName = index.getName();
        String ccjIndexType = index.getType();
        if (!ccjIndexType.equals("UNIQUE") || index.getColumnsNames().size() > 1) {
            return false;
        }
        boolean isColumnIndex = ccjIndexName.equals(columnName);
        return isColumnIndex;
    }

    public static TableColumn convertToTableColumn(ColumnDefinition columnDefinition, List<Index> indexes) {
        if (columnDefinition == null) {
            return null;
        }
        TableColumn tableColumn = new TableColumn();
        String ccjColumnName = columnDefinition.getColumnName();
        List cjColumnDefSpecs = columnDefinition.getColumnSpecs();
        tableColumn.setColumnName(DBTableUtil.removeBackQuoteSymbol(ccjColumnName));
        tableColumn.setComment(ModelDrivenCCJParserUtil.getComment(columnDefinition));
        ColDataType colDataType = columnDefinition.getColDataType();
        tableColumn.setDataType(ModelSqlParserKingbaseUtil.kingbaseToMysqlTypeMapper(colDataType));
        List dataTypeArgs = colDataType.getArgumentsStringList();
        if (CollectionUtils.isNotEmpty((Collection)cjColumnDefSpecs)) {
            ModelSqlParserKingbaseUtil.setDefaultValue(cjColumnDefSpecs, tableColumn);
        }
        if (cjColumnDefSpecs.contains("AUTO_INCREMENT")) {
            tableColumn.setAutoIncrement(true);
            tableColumn.setNullable(false);
        } else {
            boolean columnNullable = ModelSqlParserKingbaseUtil.fetchCCJNullable(cjColumnDefSpecs);
            tableColumn.setNullable(columnNullable);
            ModelSqlParserKingbaseUtil.processSizeScale(columnDefinition, tableColumn);
        }
        indexes.stream().forEach(idx -> {
            String ccjIndexName = idx.getName();
            String ccjIndexType = idx.getType();
            if (ccjIndexType.equals("PRIMARY KEY") && idx.getColumnsNames().contains(ccjColumnName)) {
                tableColumn.setPK(true);
            }
            if (ModelSqlParserKingbaseUtil.checkColumnUniqueIndex(idx, ccjColumnName)) {
                tableColumn.setUnique(true);
            }
        });
        return tableColumn;
    }

    public static DataTypeEnum kingbaseToMysqlTypeMapper(ColDataType colDataType) {
        String kingbaseType = colDataType.getDataType().toUpperCase().replaceAll("\"", "");
        DataTypeEnum mysqlType = null;
        switch (kingbaseType) {
            case "CHARACTER VARYING": {
                mysqlType = DataTypeEnum.VARCHAR;
                break;
            }
            case "CHAR VARYING": {
                mysqlType = DataTypeEnum.VARCHAR;
                break;
            }
            case "VARCHAR2": {
                mysqlType = DataTypeEnum.VARCHAR;
                break;
            }
            case "NVARCHAR2": {
                mysqlType = DataTypeEnum.VARCHAR;
                break;
            }
            case "NVARCHAR": {
                mysqlType = DataTypeEnum.VARCHAR;
                break;
            }
            case "CHARACTER": {
                mysqlType = DataTypeEnum.CHAR;
                break;
            }
            case "CLOB": {
                mysqlType = DataTypeEnum.TEXT;
                break;
            }
            case "NCLOB": {
                mysqlType = DataTypeEnum.TEXT;
                break;
            }
            case "DOUBLE PRECISION": {
                mysqlType = DataTypeEnum.DOUBLE;
                break;
            }
            case "NUMERIC": {
                mysqlType = DataTypeEnum.DECIMAL;
                break;
            }
            case "INTEGER": {
                mysqlType = DataTypeEnum.INT;
                break;
            }
            case "NUMBER": {
                mysqlType = DataTypeEnum.DECIMAL;
                break;
            }
            case "SMALLSERIAL": {
                mysqlType = DataTypeEnum.SMALLINT;
                break;
            }
            case "SERIAL": {
                mysqlType = DataTypeEnum.INT;
                break;
            }
            case "BIGSERIAL": {
                mysqlType = DataTypeEnum.BIGINT;
                break;
            }
            case "MONEY": {
                mysqlType = DataTypeEnum.DECIMAL;
                break;
            }
            case "BIT VAYRING": {
                mysqlType = DataTypeEnum.VARBINARY;
                break;
            }
            case "BYTEA": {
                mysqlType = DataTypeEnum.BLOB;
                break;
            }
        }
        if (mysqlType == null) {
            mysqlType = DataTypeEnum.valueOf((String)kingbaseType);
        }
        return mysqlType;
    }

    public static void setDefaultValue(List<String> cjColumnDefSpecs, TableColumn tableColumn) {
        String targetKey = "DEFAULT";
        if (cjColumnDefSpecs.contains(targetKey)) {
            int defaultPosition = cjColumnDefSpecs.indexOf(targetKey);
            String defaultValue = DBTableUtil.removeApostropheSymbol(cjColumnDefSpecs.get(defaultPosition + 1));
            if ("NULL".equalsIgnoreCase(defaultValue)) {
                defaultValue = null;
            }
            tableColumn.setDefaultValue(defaultValue);
            log.debug(_CLASSTAG + "{}={}", (Object)targetKey, (Object)defaultValue);
        }
    }

    public static List<TableColumn> getTableColumns(List<ColumnDefinition> ccjColumnDefinitions, List<Index> ccjIndexes) {
        List<TableColumn> existedTableColumns = ccjColumnDefinitions.stream().map(ccjColumnDef -> ModelSqlParserKingbaseUtil.convertToTableColumn(ccjColumnDef, ccjIndexes)).collect(Collectors.toList());
        return existedTableColumns;
    }

    public static TableIndex convertToTableIndex(Index ccjIndex) {
        String indexTypeName;
        TableIndex tableIndex = new TableIndex();
        String indexName = StringUtils.isNotBlank((CharSequence)ccjIndex.getName()) ? DBTableUtil.removeBackQuoteSymbol(ccjIndex.getName()) : IndexTypeEnum.PRIMARY_KEY.getIndexCommandChar();
        tableIndex.setName(indexName);
        List<String> members = ccjIndex.getColumnsNames().stream().map(member -> DBTableUtil.removeBackQuoteSymbol(member)).collect(Collectors.toList());
        tableIndex.setMember(members);
        switch (indexTypeName = ccjIndex.getType()) {
            case "UNIQUE": {
                tableIndex.setType(IndexTypeEnum.UNIQUE_INDEX);
                break;
            }
            case "KEY": {
                tableIndex.setType(IndexTypeEnum.INDEX);
                break;
            }
            case "PRIMARY KEY": {
                tableIndex.setType(IndexTypeEnum.PRIMARY_KEY);
                break;
            }
        }
        return tableIndex;
    }

    public static List<TableIndex> getTableIndexes(List<Index> ccjIndexes) {
        List<TableIndex> existedTableIndexes = ccjIndexes.stream().map(ModelSqlParserKingbaseUtil::convertToTableIndex).collect(Collectors.toList());
        return existedTableIndexes;
    }

    public static List<String> getTables(String sql) throws JSQLParserException {
        Statement ccjStatement = CCJSqlParserUtil.parse((String)sql);
        Select selectStatement = (Select)ccjStatement;
        TablesNamesFinder tableFinder = new TablesNamesFinder();
        List tables = tableFinder.getTableList((Statement)selectStatement);
        return tables;
    }

    public static CreateTable fetchCCJCreateTable(List data) throws JSQLParserException {
        Map rowMap = (Map)data.get(0);
        String createTableSql = (String)rowMap.get("Create Table");
        Statement statement = CCJSqlParserUtil.parse((String)createTableSql);
        CreateTable ccjCreateTable = (CreateTable)statement;
        return ccjCreateTable;
    }

    public static boolean fetchCCJNullable(List<String> cjColumnDefSpecs) {
        String columnSpecsString = "";
        if (CollectionUtils.isNotEmpty(cjColumnDefSpecs)) {
            columnSpecsString = cjColumnDefSpecs.stream().collect(Collectors.joining(" "));
        }
        return !StringUtils.containsIgnoreCase((CharSequence)columnSpecsString, (CharSequence)"not null");
    }

    public static void processSizeScale(ColumnDefinition columnDefinition, TableColumn tableColumn) {
        List argumentsStringList = columnDefinition.getColDataType().getArgumentsStringList();
        if (CollectionUtils.isNotEmpty((Collection)argumentsStringList)) {
            if (argumentsStringList.size() == 1 && NumberUtils.isDigits((String)((String)argumentsStringList.get(0)).split(" ")[0])) {
                tableColumn.setSize(Integer.valueOf(((String)argumentsStringList.get(0)).split(" ")[0]));
            }
            if (argumentsStringList.size() == 2) {
                if (NumberUtils.isDigits((String)((String)argumentsStringList.get(0)).split(" ")[0])) {
                    tableColumn.setSize(Integer.valueOf(((String)argumentsStringList.get(0)).split(" ")[0]));
                }
                if (NumberUtils.isDigits((String)((String)argumentsStringList.get(1)).split(" ")[0])) {
                    tableColumn.setScale(Integer.valueOf(((String)argumentsStringList.get(1)).split(" ")[0]));
                }
            }
        }
    }

    public static String getComment(CreateTable ccjCreateTable) {
        List createOptStrs = ccjCreateTable.getTableOptionsStrings();
        String commentKey = "COMMENT";
        String comment = "";
        if (createOptStrs.contains(commentKey)) {
            int commentPosition = createOptStrs.indexOf(commentKey);
            comment = DBTableUtil.removeApostropheSymbol((String)createOptStrs.get(commentPosition + 2));
            log.debug(_CLASSTAG + "comment={}", (Object)comment);
        }
        return comment;
    }

    public static List<String> getTableColumnNames(CreateTable ccjCreateTable) {
        List ccjColumnDefinitions = ccjCreateTable.getColumnDefinitions();
        List ccjIndexes = Optional.ofNullable(ccjCreateTable.getIndexes()).orElse(new ArrayList());
        List<TableColumn> existedTableColumns = ModelSqlParserKingbaseUtil.getTableColumns(ccjColumnDefinitions, ccjIndexes);
        List<String> existedTableColumnNames = existedTableColumns.stream().map(tableColumn -> tableColumn.getColumnName()).collect(Collectors.toList());
        return existedTableColumnNames;
    }
}

