/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.lcdp.modeldriven.utils;

import com.digiwin.app.dao.DWDao;
import com.digiwin.app.dao.DWServiceResultBuilder;
import com.digiwin.app.ddl.model.Field;
import com.digiwin.app.service.DWEAIResult;
import com.digiwin.app.service.DWServiceResult;
import com.digiwin.app.service.eai.DWEAIHeader;
import com.digiwin.lcdp.modeldriven.context.ModelDrivenContext;
import com.digiwin.lcdp.modeldriven.enums.AlterAutoIncrementEnum;
import com.digiwin.lcdp.modeldriven.enums.AlterColumnEnum;
import com.digiwin.lcdp.modeldriven.enums.AlterIndexEnum;
import com.digiwin.lcdp.modeldriven.enums.IndexTypeEnum;
import com.digiwin.lcdp.modeldriven.enums.ModelCreateTypeEnum;
import com.digiwin.lcdp.modeldriven.enums.PublishStatusEnum;
import com.digiwin.lcdp.modeldriven.model.ModelDTO;
import com.digiwin.lcdp.modeldriven.model.ModelPublishedEspResult;
import com.digiwin.lcdp.modeldriven.model.ModelSchemaDTO;
import com.digiwin.lcdp.modeldriven.model.ModelTable;
import com.digiwin.lcdp.modeldriven.model.ModelTableSchemaCache;
import com.digiwin.lcdp.modeldriven.model.SqlParam;
import com.digiwin.lcdp.modeldriven.model.TableColumn;
import com.digiwin.lcdp.modeldriven.model.TableIndex;
import com.digiwin.lcdp.modeldriven.model.TableSqlParamDTO;
import com.digiwin.lcdp.modeldriven.report.model.DBTableNameCheckResult;
import com.digiwin.lcdp.modeldriven.utils.DBColumnUtil;
import com.digiwin.lcdp.modeldriven.utils.DBExecuteHandler;
import com.digiwin.lcdp.modeldriven.utils.DBTableUtil;
import com.digiwin.lcdp.modeldriven.utils.EaiRegisterUtil;
import com.digiwin.lcdp.modeldriven.utils.ModelIndexUtil;
import com.digiwin.lcdp.modeldriven.utils.ModelSchemaUtil;
import com.digiwin.lcdp.modeldriven.utils.ModelSqlGenerator;
import com.digiwin.lcdp.modeldriven.utils.ModelSqlParserUtil;
import com.digiwin.lcdp.modeldriven.utils.ModelTablePartialSqlGenerator;
import com.digiwin.lcdp.modeldriven.utils.ModelTableSqlGenerator;
import com.digiwin.lcdp.modeldriven.utils.compare.ColumnCompareUtil;
import com.digiwin.lcdp.modeldriven.utils.compare.IndexCompareUtil;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import net.sf.jsqlparser.JSQLParserException;
import net.sf.jsqlparser.schema.Table;
import net.sf.jsqlparser.statement.create.table.CreateTable;
import net.sf.jsqlparser.statement.create.table.Index;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.math.NumberUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

@Component
public class ModelTableHelperExpress {
    private static final Logger log = LoggerFactory.getLogger(ModelTableHelperExpress.class);
    private static final String _CLASSTAG = "[" + ModelTableHelperExpress.class.getSimpleName() + "]";
    @Autowired
    @Qualifier(value="dw-dao")
    private DWDao dao;
    @Autowired
    DBExecuteHandler dbExecuteService;
    @Autowired
    private EaiRegisterUtil eaiRegisterUtil;

    @Transactional(propagation=Propagation.REQUIRED, rollbackFor={Exception.class})
    public DWServiceResult createTableExpress(String masterTableName, List<ModelTable> modelTables) throws Exception {
        ModelPublishedEspResult executeInsertResult;
        boolean createSuccess = false;
        ModelDrivenContext modelDrivenContext = ModelDrivenContext.getContext();
        ModelDTO draftModel = modelDrivenContext.getDraftModel();
        ArrayList<SqlParam> dmlSqlParams = new ArrayList<SqlParam>();
        ArrayList<SqlParam> ddlSqlParams = new ArrayList<SqlParam>();
        for (ModelTable modelTable : modelTables) {
            boolean hasPrimaryKey = modelTable.getColumns().stream().anyMatch(Field::isPK);
            if (!hasPrimaryKey) {
                throw new IllegalArgumentException("The table must include a primary key!");
            }
            TableSqlParamDTO tableSqlParamDTO = ModelSqlGenerator.getCreateTable(modelTable);
            dmlSqlParams.addAll(tableSqlParamDTO.getDmlSqlParams());
            ddlSqlParams.addAll(tableSqlParamDTO.getDdlSqlParams());
        }
        SqlParam insertModelTableParam = ModelSqlGenerator.generateInsertModelSql(draftModel);
        dmlSqlParams.add(insertModelTableParam);
        List<ModelTable> modelAllTables = ModelSchemaUtil.getModelTables(draftModel.getSchema());
        List<SqlParam> insertModelInfoTableParam = ModelSqlGenerator.generateInsertModelInfoSql(modelAllTables, draftModel.getCode());
        dmlSqlParams.addAll(insertModelInfoTableParam);
        ModelTable masterModelTable = ModelSchemaUtil.getCurrentLevelModelTable(draftModel.getSchema());
        SqlParam insertServiceMappingTableParam = ModelSqlGenerator.generateInsertServiceMappingSql(masterModelTable);
        dmlSqlParams.add(insertServiceMappingTableParam);
        ModelPublishedEspResult executeCreateTableResult = this.dbExecuteService.executeCreateTableOfCreateModelDriven(ddlSqlParams, draftModel);
        if (executeCreateTableResult.getPublishStatusEnum() == PublishStatusEnum.SUCCESS && (executeInsertResult = this.dbExecuteService.executeInsertOfCreateModelDrivenWithRegistryEspService(dmlSqlParams, draftModel)).getPublishStatusEnum() == PublishStatusEnum.SUCCESS) {
            createSuccess = true;
        }
        return DWServiceResultBuilder.build((boolean)createSuccess, (String)"", null);
    }

    public DWServiceResult alterTableExpress(String masterTableName, LinkedHashMap<String, LinkedHashMap<String, List<SqlParam>>> alterTableMap, Map<String, Object> modelDataMap) throws Exception {
        AtomicReference<PublishStatusEnum> alterRunStatus = new AtomicReference<PublishStatusEnum>(PublishStatusEnum.UNCHANGED);
        boolean alterSuccess = false;
        HashMap<String, Object> paramAll = new HashMap<String, Object>();
        LinkedList paramDML = new LinkedList();
        LinkedList paramDDL = new LinkedList();
        for (String tableName : alterTableMap.keySet()) {
            List<SqlParam> ddlSqlParams;
            LinkedHashMap<String, List<SqlParam>> tableAlterMap = alterTableMap.get(tableName);
            List<SqlParam> dmlSqlParams = tableAlterMap.get("dml");
            HashMap<String, List<SqlParam>> tempDMLMap = new HashMap<String, List<SqlParam>>();
            if (CollectionUtils.isNotEmpty(dmlSqlParams)) {
                tempDMLMap.put("sqlParamRdbms", dmlSqlParams);
                paramDML.add(tempDMLMap);
                paramAll.put("dml", paramDML);
            }
            if (!CollectionUtils.isNotEmpty(ddlSqlParams = tableAlterMap.get("ddl"))) continue;
            HashMap<String, List<SqlParam>> tempDDLMap = new HashMap<String, List<SqlParam>>();
            tempDDLMap.put("sqlParamTables", ddlSqlParams);
            paramDDL.add(tempDDLMap);
            paramAll.put("ddl", paramDDL);
        }
        alterRunStatus.set(PublishStatusEnum.CHANGED);
        HashMap<String, Object> modelInfo = new HashMap<String, Object>();
        modelInfo.put("entity_table_name", masterTableName);
        modelInfo.put("model_action", "U");
        modelInfo.put("model_design", modelDataMap);
        paramAll.put("model_data", modelInfo);
        ModelDrivenContext modelDrivenContext = ModelDrivenContext.getContext();
        DWEAIResult executeResult = this.dbExecuteService.executeAlterTable(paramAll, modelDrivenContext.getDraftModel(), modelDrivenContext.getExtraMap());
        boolean executeSuccess = false;
        String resultCode = executeResult.getCode();
        if (NumberUtils.isDigits((String)resultCode) && NumberUtils.compare((int)0, (int)NumberUtils.createInteger((String)resultCode)) == 0) {
            executeSuccess = true;
        }
        String description = executeResult.getDescription();
        if (!executeSuccess) {
            SQLException cause = new SQLException(description, executeResult.getSqlCode());
            throw new RuntimeException(cause);
        }
        return DWServiceResultBuilder.build((boolean)executeSuccess, (String)description, (Object)executeResult);
    }

    public Map<String, Object> getAlterCommentInfo(String tableName, String tableComment, LinkedList<SqlParam> sqlParams) {
        LinkedHashMap alertTableMap = new LinkedHashMap();
        SqlParam alterTableSqlParam = ModelSqlGenerator.generateAlterTableSql(tableName, tableComment);
        sqlParams.add(alterTableSqlParam);
        if (log.isDebugEnabled()) {
            log.debug(">>>>> gen Alter Table Params: tableName = {}, tableComment = {}", (Object)tableName, (Object)tableComment);
            log.debug(">>>>> gen Alter Table SQL: {}", (Object)alterTableSqlParam);
        }
        HashMap<String, Object> returnValue = new HashMap<String, Object>();
        returnValue.put("success", true);
        returnValue.put("sqlParams", alertTableMap);
        return returnValue;
    }

    public static Map<String, Object> getAlterExistedPrimaryKey(String tableName, List<Index> ccjIndexes, LinkedList<SqlParam> alterDDLSqlParam, LinkedList<SqlParam> alterDMLSqlParam) {
        HashMap<String, Object> returnValue = new HashMap<String, Object>();
        ccjIndexes.stream().filter(index -> index.getType().equals("PRIMARY KEY")).forEach(Index2 -> {
            SqlParam alterTableSqlParam = ModelSqlGenerator.getDropPrimaryKeySql(tableName);
            SqlParam alterRdbmsSqlParam = ModelSqlGenerator.generateUpdateRdbmsFieldRemovePrimarySql(tableName);
            alterDDLSqlParam.add(alterTableSqlParam);
            alterDMLSqlParam.add(alterRdbmsSqlParam);
            if (log.isDebugEnabled()) {
                log.debug(">>>>> gen Alter Columns Params: tableName = {}", (Object)tableName);
                log.debug(">>>>> gen Alter Columns SQL: {}", (Object)alterTableSqlParam);
                log.debug(">>>>> gen Alter Rdbms Fields SQL: sql = {}, params = {}", (Object)alterRdbmsSqlParam.getSql(), (Object)alterRdbmsSqlParam.getParams());
            }
        });
        return returnValue;
    }

    public static Map<String, Object> preAlterExistedPkIndexesInfo(String tableName, ModelTable draftModelTable, ModelTable existedModelTable, AlterColumnEnum alterColumnEnum, LinkedHashMap<AlterAutoIncrementEnum, TableColumn> changedAutoIncrmtMap, List<TableIndex> existedAllIndexes, LinkedHashMap<AlterIndexEnum, TableIndex> changedPkMap, LinkedList<SqlParam> alterDDLSqlParam, LinkedList<SqlParam> alterDMLSqlParam) {
        HashMap<String, Object> returnValue = new HashMap<String, Object>();
        boolean existedTableHasPK = existedModelTable.getIndexes().stream().anyMatch(index -> index.getType() == IndexTypeEnum.PRIMARY_KEY);
        boolean isChangePk = MapUtils.isNotEmpty(changedPkMap);
        log.info(_CLASSTAG + "[getAlterExistedColumnsInfo] isChangePk({}), changedPkMap({})", (Object)isChangePk, changedPkMap);
        Map<String, ModelTableSchemaCache> publishedTableCache = ModelDrivenContext.getContext().getPublishedTableCache();
        ModelTableSchemaCache publishedTableSchemaCache = publishedTableCache.get(tableName);
        Map<String, Object> actualRemainIndexes = publishedTableSchemaCache.getPublishedRemainIndexes();
        boolean isChangeAutoIncrement = MapUtils.isNotEmpty(changedAutoIncrmtMap);
        log.info(_CLASSTAG + "[getAlterExistedColumnsInfo] autoincrementCoumn({})= alterAutoIncrmtMap({})", (Object)isChangeAutoIncrement, changedAutoIncrmtMap);
        if (isChangeAutoIncrement && changedAutoIncrmtMap.containsKey((Object)AlterAutoIncrementEnum.DROP)) {
            TableColumn existedColumnWithAutoIncrement = changedAutoIncrmtMap.get((Object)AlterAutoIncrementEnum.DROP);
            SqlParam alterTableSqlParam = ModelSqlGenerator.generateAlterColumnRemoveAutoIncreAndPkSql(tableName, alterColumnEnum, existedColumnWithAutoIncrement);
            SqlParam alterRdbmsSqlParam = ModelSqlGenerator.generateInsertOrUpdateRdbmsFieldWithRemoveAutoIncrementSql(tableName, existedColumnWithAutoIncrement);
            if (log.isDebugEnabled()) {
                log.debug(">>>>> gen Alter Columns Params: tableName = {}, alterColumnEnum = {}, customColumn = {}", new Object[]{tableName, alterColumnEnum, existedColumnWithAutoIncrement});
                log.debug(">>>>> gen Alter Columns SQL: {}", (Object)alterTableSqlParam);
                log.debug(">>>>> gen Alter Rdbms Fields SQL: sql = {}, params = {}", (Object)alterRdbmsSqlParam.getSql(), (Object)alterRdbmsSqlParam.getParams());
            }
            alterDDLSqlParam.add(alterTableSqlParam);
            alterDMLSqlParam.add(alterRdbmsSqlParam);
        } else if (!isChangeAutoIncrement && isChangePk && changedPkMap.containsKey((Object)AlterIndexEnum.DROP)) {
            SqlParam alterTableSqlParam = ModelSqlGenerator.getDropPrimaryKeySql(tableName);
            SqlParam alterRdbmsSqlParam = ModelSqlGenerator.generateUpdateRdbmsFieldRemovePrimarySql(tableName);
            alterDDLSqlParam.add(alterTableSqlParam);
            alterDMLSqlParam.add(alterRdbmsSqlParam);
            actualRemainIndexes.remove("PRIMARY KEY");
            if (log.isDebugEnabled()) {
                log.debug(">>>>> gen Alter Columns Params: tableName = {}, alterColumnEnum = {}, existedTableHasPK = {}", new Object[]{tableName, alterColumnEnum, existedTableHasPK});
                log.debug(">>>>> gen Alter Columns SQL: {}", (Object)alterTableSqlParam);
                log.debug(">>>>> gen Alter Rdbms Fields SQL: sql = {}, params = {}", (Object)alterRdbmsSqlParam.getSql(), (Object)alterRdbmsSqlParam.getParams());
            }
        }
        LinkedList tableUniqueIndexes = ModelTableSqlGenerator.getAlterTableUniqueIndex(tableName, draftModelTable, existedModelTable);
        alterDDLSqlParam.addAll(tableUniqueIndexes);
        return returnValue;
    }

    @Transactional(propagation=Propagation.REQUIRED, rollbackFor={Exception.class})
    public boolean dropTableExpress(List<ModelTable> modelTables, Map<String, Object> modelDataMap, ModelDTO model) throws Exception {
        String masterTableName = model.getSchema().getName();
        HashMap<String, Object> paramAll = new HashMap<String, Object>();
        HashMap<String, Object> modelInfo = new HashMap<String, Object>();
        modelInfo.put("entity_table_name", masterTableName);
        modelInfo.put("model_action", "D");
        modelInfo.put("model_design", modelDataMap);
        paramAll.put("model_data", modelInfo);
        LinkedList paramDML = new LinkedList();
        LinkedList paramDDL = new LinkedList();
        for (ModelTable modelTable : modelTables) {
            String targetTableName = modelTable.getName();
            ArrayList<SqlParam> dmlSqlParams = new ArrayList<SqlParam>();
            HashMap<String, ArrayList<SqlParam>> tempDMLMap = new HashMap<String, ArrayList<SqlParam>>();
            SqlParam deleteRdbmsTableParam = ModelSqlGenerator.generateDeleteRdbmsTableSql(targetTableName);
            dmlSqlParams.add(deleteRdbmsTableParam);
            SqlParam deleteRdbmsFieldsParam = ModelSqlGenerator.generateDeleteRdbmsFieldSql(modelTable);
            dmlSqlParams.add(deleteRdbmsFieldsParam);
            if (log.isDebugEnabled()) {
                log.debug(">>>>> gen Delete Rdbms Table Params: modelTable = {}", (Object)targetTableName);
                log.debug(">>>>> gen Delete Rdbms Table SQL: {}", (Object)deleteRdbmsTableParam);
                log.debug(">>>>> gen Delete Rdbms Fields Params: modelTable = {}", (Object)modelTable.getName());
                log.debug(">>>>> gen Delete Rdbms Fields SQL: {}", dmlSqlParams);
            }
            tempDMLMap.put("sqlParamRdbms", dmlSqlParams);
            paramDML.add(tempDMLMap);
            ArrayList<SqlParam> ddlSqlParams = new ArrayList<SqlParam>();
            HashMap<String, ArrayList<SqlParam>> tempDDLMap = new HashMap<String, ArrayList<SqlParam>>();
            SqlParam dropTableSqlParam = ModelSqlGenerator.generateRenameTableSql(targetTableName);
            ddlSqlParams.add(dropTableSqlParam);
            tempDDLMap.put("sqlParamTables", ddlSqlParams);
            paramDDL.add(tempDDLMap);
        }
        paramAll.put("dml", paramDML);
        paramAll.put("ddl", paramDDL);
        DWEAIResult executeResult = this.dbExecuteService.executeDeleteTable(paramAll, model);
        boolean executeDeleteSuccess = false;
        String resultCode = executeResult.getCode();
        if (NumberUtils.isDigits((String)resultCode) && NumberUtils.compare((int)0, (int)NumberUtils.createInteger((String)resultCode)) == 0) {
            executeDeleteSuccess = true;
        }
        String description = executeResult.getDescription();
        if (!executeDeleteSuccess) {
            SQLException cause = new SQLException(description, executeResult.getSqlCode());
            throw new RuntimeException(cause);
        }
        return executeDeleteSuccess;
    }

    public DWServiceResult createCustomizeTableExpress(String masterTableName, List<ModelTable> draftModelTables) throws Exception {
        ModelPublishedEspResult executeInsertResult;
        ModelPublishedEspResult executeCreateTableResult;
        ArrayList<String> existedTableNames = new ArrayList<String>();
        ModelDrivenContext modelDrivenContext = ModelDrivenContext.getContext();
        Map<String, Object> extraMap = modelDrivenContext.getExtraMap();
        extraMap.put("existedTables", existedTableNames);
        LinkedList<SqlParam> dmlSqlParams = new LinkedList<SqlParam>();
        LinkedList<SqlParam> ddlSqlParams = new LinkedList<SqlParam>();
        Map dbModelTables = (Map)extraMap.get("actualModelTablesFromDB");
        for (ModelTable draftModelTable : draftModelTables) {
            String currentTableName = draftModelTable.getName();
            log.info(_CLASSTAG + "[createCustomizeTableExpress] ----- process table({}) ----", (Object)currentTableName);
            List<TableColumn> draftTableColumns = draftModelTable.getColumns();
            boolean hasPrimaryKey = draftTableColumns.stream().anyMatch(Field::isPK);
            if (!hasPrimaryKey) {
                throw new IllegalArgumentException(String.format("The table(%s) must include a primary key!", currentTableName));
            }
            SqlParam insertRdbmsTableSqlParam = ModelSqlGenerator.generateInsertRdbmsTableSql(draftModelTable);
            dmlSqlParams.add(insertRdbmsTableSqlParam);
            if (dbModelTables.containsKey(currentTableName)) {
                log.info(_CLASSTAG + "[createCustomizeTableExpress] --> table({}) is existed", (Object)currentTableName);
                LinkedList<String> ddlTablePartialSqlParams = new LinkedList<String>();
                existedTableNames.add(currentTableName);
                ModelTable actualModelTable = (ModelTable)dbModelTables.get(currentTableName);
                List<TableColumn> actualTableColumns = actualModelTable.getColumns();
                Map<String, Object> actualRemainTableIndexeMap = ModelIndexUtil.getAllTableIndexes(actualModelTable);
                ModelTableSchemaCache publishedTableSchemaCache = new ModelTableSchemaCache();
                publishedTableSchemaCache.setPublishedRemainIndexes(actualRemainTableIndexeMap);
                TableColumn actualAutoIncrmtColumn = DBColumnUtil.getAutoIncrementColumn(actualTableColumns);
                if (actualAutoIncrmtColumn != null) {
                    publishedTableSchemaCache.setAutoIncrementColumn(actualAutoIncrmtColumn);
                }
                publishedTableSchemaCache.setTableName(currentTableName);
                Map<String, ModelTableSchemaCache> publishedTableCache = modelDrivenContext.getPublishedTableCache();
                publishedTableCache.put(currentTableName, publishedTableSchemaCache);
                List<String> partialTableAttributes = ModelTablePartialSqlGenerator.getAlterTableOptionsWhenNewPublish(draftModelTable.getComment());
                ddlTablePartialSqlParams.addAll(partialTableAttributes);
                LinkedHashMap<AlterAutoIncrementEnum, TableColumn> changedAutoIncrmtMap = ColumnCompareUtil.getChangeAutoIncrementColumn(draftTableColumns, actualTableColumns);
                boolean isChangeAutoIncrement = MapUtils.isNotEmpty(changedAutoIncrmtMap);
                LinkedHashMap<AlterIndexEnum, TableIndex> changedPkMap = IndexCompareUtil.getChangePkIndex(draftModelTable, actualModelTable);
                boolean isChangePk = MapUtils.isNotEmpty(changedPkMap);
                log.info(_CLASSTAG + "[createCustomizeTableExpress] table({}), isChangeAutoIncrement({}), isChangePk({})", new Object[]{currentTableName, isChangeAutoIncrement, isChangePk});
                List<String> partialTableColumns = ModelTablePartialSqlGenerator.updateColumnsSqlParamsWhenNewPublishWithNoApi(draftModelTable, actualModelTable, changedAutoIncrmtMap, ddlSqlParams, dmlSqlParams);
                ddlTablePartialSqlParams.addAll(partialTableColumns);
                List<SqlParam> alterTableDDL = ModelTableSqlGenerator.getCombinedSqls(currentTableName, ddlTablePartialSqlParams);
                ddlSqlParams.addAll(alterTableDDL);
                List<SqlParam> insertOrUpdateRdbmsFieldsParam = ModelSqlGenerator.generateInsertOrUpdateRdbmsFieldSql(draftModelTable);
                dmlSqlParams.addAll(insertOrUpdateRdbmsFieldsParam);
                continue;
            }
            log.info(_CLASSTAG + "[createCustomizeTableExpress] table({}) is not existed", (Object)currentTableName);
            TableSqlParamDTO tableSqlParamDTO = ModelSqlGenerator.getCreateTable(draftModelTable);
            dmlSqlParams.addAll(tableSqlParamDTO.getDmlSqlParams());
            ddlSqlParams.addAll(tableSqlParamDTO.getDdlSqlParams());
        }
        boolean createSuccess = false;
        ModelDTO draftModel = modelDrivenContext.getDraftModel();
        ModelSchemaDTO draftModelSchema = draftModel.getSchema();
        String code = draftModel.getCode();
        SqlParam insertModelTableParam = ModelSqlGenerator.generateInsertModelSql(draftModel);
        dmlSqlParams.add(insertModelTableParam);
        List<SqlParam> insertModelInfoTableParam = ModelSqlGenerator.generateInsertModelInfoSql(draftModelTables, code);
        dmlSqlParams.addAll(insertModelInfoTableParam);
        ModelCreateTypeEnum useExistedTable = draftModel.getUseExistedTable();
        if (useExistedTable != ModelCreateTypeEnum.EXISTED_TABLE) {
            ModelTable masterModelTable = ModelSchemaUtil.getCurrentLevelModelTable(draftModelSchema);
            SqlParam insertServiceMappingTableParam = ModelSqlGenerator.generateInsertServiceMappingSql(masterModelTable);
            dmlSqlParams.add(insertServiceMappingTableParam);
        }
        if ((executeCreateTableResult = this.dbExecuteService.executeCreateTableOfCreateModelDriven(ddlSqlParams, draftModel)).getPublishStatusEnum() == PublishStatusEnum.SUCCESS && (executeInsertResult = this.dbExecuteService.executeInsertOfCreateModelDriven(dmlSqlParams, draftModel)).getPublishStatusEnum() == PublishStatusEnum.SUCCESS) {
            if (!useExistedTable.equals((Object)ModelCreateTypeEnum.EXISTED_TABLE)) {
                String modelDrivenProdPrefix = (String)extraMap.getOrDefault("modelDrivenProdPrefix", "");
                List<ModelSchemaDTO> allChildrenSchemas = ModelSchemaUtil.getChildrenModelSchema(draftModelSchema.getChildren());
                List<DWEAIHeader> newEAIHeaders = this.eaiRegisterUtil.refreshEaiService(masterTableName, allChildrenSchemas, modelDrivenProdPrefix, code);
                log.info("code({}) isUseExistedTable({}), starting call register esp service", (Object)code, (Object)useExistedTable);
                Object regResult = this.eaiRegisterUtil.autoRegisterEAI(newEAIHeaders, code);
                log.info("code({}) isUseExistedTable({}), finished call register esp service result({})", new Object[]{code, useExistedTable, regResult});
            } else {
                log.debug("code({}) isUseExistedTable({})", (Object)code, (Object)useExistedTable);
            }
            createSuccess = true;
        }
        return DWServiceResultBuilder.build((boolean)createSuccess, (String)"", null);
    }

    public DBTableNameCheckResult getTableNamesGeneratedByModelDriven(String sql) throws JSQLParserException {
        List<String> queryTableNames = ModelSqlParserUtil.getTables(sql);
        List<String> distinctTableNames = this.dbExecuteService.getTableNamesGeneratedByModelDriven(queryTableNames);
        DBTableNameCheckResult checkResult = new DBTableNameCheckResult();
        if (queryTableNames.size() != distinctTableNames.size()) {
            checkResult.setSqlTableNames(queryTableNames);
            checkResult.setModelTableNames(distinctTableNames);
            checkResult.setPassed(false);
        }
        return checkResult;
    }

    public ModelTable getModelTableFromDB(String tableName) throws JSQLParserException {
        List data = this.dbExecuteService.getCreateTableSqlByDBFunc(tableName);
        ModelTable actualModelTable = null;
        if (CollectionUtils.isNotEmpty((Collection)data)) {
            log.info("[ModelTableHelperExpress][getModelTableFromDB] --> table({}) is existed", (Object)tableName);
            actualModelTable = new ModelTable();
            CreateTable ccjCreateTable = ModelSqlParserUtil.fetchCCJCreateTable(data);
            List createOptStrs = ccjCreateTable.getTableOptionsStrings();
            Table ccjTable = ccjCreateTable.getTable();
            String pureTableName = DBTableUtil.removeBackQuoteSymbol(ccjTable.getName());
            actualModelTable.setName(pureTableName);
            actualModelTable.setComment(ModelSqlParserUtil.getComment(ccjCreateTable));
            List ccjColumnDefinitions = ccjCreateTable.getColumnDefinitions();
            List ccjIndexes = Optional.ofNullable(ccjCreateTable.getIndexes()).orElse(new ArrayList());
            List<TableColumn> actualTableColumns = ModelSqlParserUtil.getTableColumns(ccjColumnDefinitions, ccjIndexes);
            actualModelTable.setColumns(actualTableColumns);
            List<TableIndex> existedTableIndexes = ModelSqlParserUtil.getTableIndexes(ccjIndexes);
            actualModelTable.setIndexes(existedTableIndexes);
            TableIndex pkTableIndex = existedTableIndexes.stream().filter(tableIndex -> tableIndex.getName().equals("PRIMARY KEY")).findFirst().orElse(null);
            if (pkTableIndex != null) {
                actualModelTable.setPk(pkTableIndex.getMember().stream().collect(Collectors.joining(",")));
            }
        }
        return actualModelTable;
    }

    public Map<String, Object> getModelTableFromDatabase(List<String> tableNames) throws JSQLParserException {
        HashMap<String, Object> actualModelTables = new HashMap<String, Object>();
        for (String tableName : tableNames) {
            ModelTable actualModelTable = this.getModelTableFromDB(tableName);
            if (actualModelTable == null) continue;
            actualModelTables.put(tableName, actualModelTable);
        }
        return actualModelTables;
    }
}

