/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.lcdp.modeldriven.utils;

import com.digiwin.app.container.exceptions.DWRuntimeException;
import com.digiwin.lcdp.modeldriven.context.ModelDrivenContext;
import com.digiwin.lcdp.modeldriven.enums.AlterAutoIncrementEnum;
import com.digiwin.lcdp.modeldriven.enums.AlterColumnEnum;
import com.digiwin.lcdp.modeldriven.enums.AlterIndexEnum;
import com.digiwin.lcdp.modeldriven.model.ModelIndexDTO;
import com.digiwin.lcdp.modeldriven.model.ModelTable;
import com.digiwin.lcdp.modeldriven.model.ModelTableSchemaCache;
import com.digiwin.lcdp.modeldriven.model.SqlParam;
import com.digiwin.lcdp.modeldriven.model.TableColumn;
import com.digiwin.lcdp.modeldriven.model.TableIndex;
import com.digiwin.lcdp.modeldriven.utils.ModelSchemaUtil;
import com.digiwin.lcdp.modeldriven.utils.ModelSqlGenerator;
import com.digiwin.lcdp.modeldriven.utils.compare.ColumnCompareUtil;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ModelTablePartialSqlGenerator {
    private static final Logger log = LoggerFactory.getLogger(ModelTablePartialSqlGenerator.class);
    private static final String _CLASSTAG = "[" + ModelTablePartialSqlGenerator.class.getSimpleName() + "]";

    public static List<String> getAlterTableOptionsWhenNewPublish(String tableComment) {
        String alterTableOptComment = String.format("COMMENT='%s' ", tableComment);
        String alterTableOptCharsetCollation = String.format("CONVERT TO CHARACTER SET '%s' COLLATE '%s'", "utf8mb4", "utf8mb4_bin");
        if (log.isDebugEnabled()) {
            log.debug(_CLASSTAG + "getAlterTableOptionsWhenNewPublish >>>>> gen Table partial sql: {}", (Object)alterTableOptComment);
            log.debug(_CLASSTAG + "getAlterTableOptionsWhenNewPublish >>>>> gen Table partial sql: {}", (Object)alterTableOptCharsetCollation);
        }
        ArrayList<String> returnValue = new ArrayList<String>();
        returnValue.add(alterTableOptComment);
        returnValue.add(alterTableOptCharsetCollation);
        return returnValue;
    }

    public static List<String> updateColumnsSqlParamsWhenNewPublishWithNoApi(ModelTable draftModelTable, ModelTable actualModelTable, LinkedHashMap<AlterAutoIncrementEnum, TableColumn> changedAutoIncrmt, LinkedList<SqlParam> ddlSqlParams, LinkedList<SqlParam> dmlSqlParams) {
        ArrayList<String> returnValue = new ArrayList<String>();
        String tableName = draftModelTable.getName();
        List<TableColumn> draftTableColumns = draftModelTable.getColumns();
        List<TableColumn> actualTableColumns = actualModelTable.getColumns();
        List<TableColumn> org_addColumns = ColumnCompareUtil.getAddColumns(draftTableColumns, actualTableColumns);
        List<String> addColumnSqls = ModelTablePartialSqlGenerator.updateAlterColumnsInfoOnly(tableName, AlterColumnEnum.ADD_COLUMN, org_addColumns, changedAutoIncrmt, dmlSqlParams);
        returnValue.addAll(addColumnSqls);
        List<TableColumn> org_modifyColumns = ColumnCompareUtil.getModifyColumns(draftTableColumns, actualTableColumns);
        List<String> modifyColumnSqls = ModelTablePartialSqlGenerator.updateAlterColumnsInfoOnly(tableName, AlterColumnEnum.MODIFY_COLUMN, org_modifyColumns, changedAutoIncrmt, dmlSqlParams);
        returnValue.addAll(modifyColumnSqls);
        return returnValue;
    }

    public static List<String> updateAlterColumnsInfoOnly(String tableName, AlterColumnEnum alterColumnEnum, List<TableColumn> modelColumns, LinkedHashMap<AlterAutoIncrementEnum, TableColumn> changedAutoIncrmt, LinkedList<SqlParam> targetDMLSqlParam) {
        LinkedList<String> columnPartialDDLSqlParam = new LinkedList<String>();
        modelColumns.forEach(modelColumn -> {
            LinkedList<String> alterTableSqlParam = ModelTablePartialSqlGenerator.generateAlterColumnsSql(tableName, alterColumnEnum, modelColumn);
            columnPartialDDLSqlParam.addAll(alterTableSqlParam);
            if (alterColumnEnum == AlterColumnEnum.DROP_COLUMN) {
                SqlParam deleteRdbmsFieldSql = ModelSqlGenerator.generateDeleteRdbmsFieldSql(tableName, modelColumn.getColumnName());
                targetDMLSqlParam.add(deleteRdbmsFieldSql);
            }
            if (log.isDebugEnabled()) {
                log.debug(">>>>> gen Alter Columns Params: tableName = {}, alterColumnEnum = {}, customColumn = {}", new Object[]{tableName, alterColumnEnum, modelColumn});
                log.debug(">>>>> gen Alter Columns SQL: {}", alterTableSqlParam);
            }
        });
        return columnPartialDDLSqlParam;
    }

    public static LinkedList<String> generateAlterColumnsSql(String tableName, AlterColumnEnum alterColumnEnum, TableColumn draftTableColumn) {
        ModelTable actualModelTable = ModelDrivenContext.getActualModelTable(tableName);
        boolean isExistedTable = false;
        if (actualModelTable != null) {
            isExistedTable = true;
        }
        LinkedList<String> sqlPartials = new LinkedList<String>();
        switch (alterColumnEnum) {
            case ADD_COLUMN: {
                String addColumnSql = String.format(" %s `%s` %s %s %s %s %s '%s' ", alterColumnEnum.getSqlChar(), draftTableColumn.getColumnName(), ModelSqlGenerator.getTypeDDL(draftTableColumn), ModelSqlGenerator.getNullableEnum(draftTableColumn.nullable()).getSqlChar(), ModelSqlGenerator.columnUniqueValue(draftTableColumn.getUnique()), ModelSqlGenerator.getDefaultValue(draftTableColumn, isExistedTable), "COMMENT", draftTableColumn.getComment());
                sqlPartials.add(addColumnSql);
                break;
            }
            case MODIFY_COLUMN: {
                String autoIncrementOrDefaultValue = ModelSqlGenerator.getSqlByAutoIncrementOrDefaultValue(draftTableColumn, false);
                String modifyColumnSql = ModelTablePartialSqlGenerator.getAutoPartialSql(tableName, alterColumnEnum, draftTableColumn, autoIncrementOrDefaultValue);
                if (autoIncrementOrDefaultValue.toUpperCase().contains("AUTO_INCREMENT")) {
                    Map<String, ModelTableSchemaCache> publishedTableCache;
                    ModelTableSchemaCache publishedTableSchemaCache;
                    TableColumn remainAutoIncrementColumn;
                    String pkCondtion = ModelSqlGenerator.getPrimaryKeyCondition(tableName, autoIncrementOrDefaultValue, draftTableColumn);
                    if (StringUtils.isNotBlank((CharSequence)pkCondtion)) {
                        modifyColumnSql = String.join((CharSequence)",", modifyColumnSql, pkCondtion);
                    }
                    if ((remainAutoIncrementColumn = (publishedTableSchemaCache = (publishedTableCache = ModelDrivenContext.getContext().getPublishedTableCache()).get(tableName)).getAutoIncrementColumn()) != null) {
                        remainAutoIncrementColumn.setAutoIncrement(false);
                        remainAutoIncrementColumn.setPK(false);
                        String remainAutoIncrementOrDefaultValue = ModelSqlGenerator.getSqlByAutoIncrementOrDefaultValue(remainAutoIncrementColumn, false);
                        String removeRemainAutoIncrmtSqls = ModelTablePartialSqlGenerator.getAutoPartialSql(tableName, AlterColumnEnum.MODIFY_COLUMN, remainAutoIncrementColumn, remainAutoIncrementOrDefaultValue);
                        sqlPartials.add(removeRemainAutoIncrmtSqls);
                    }
                }
                sqlPartials.add(modifyColumnSql);
                break;
            }
            case DROP_COLUMN: {
                String dropColumnSql = String.format(" %s `%s` ", alterColumnEnum.getSqlChar(), draftTableColumn.getColumnName());
                sqlPartials.add(dropColumnSql);
                break;
            }
            default: {
                throw new DWRuntimeException("\u4e0d\u652f\u6301\u8be5\u64cd\u4f5c");
            }
        }
        return sqlPartials;
    }

    public static List<String> getAlterTableInfoWhenExistedModel(ModelTable modelTable) {
        String alterTableOptComment = String.format("%s '%s' ", "COMMENT", modelTable.getComment());
        if (log.isDebugEnabled()) {
            log.debug(_CLASSTAG + "[getAlterTableInfoWhenExistedModel] gen Table partial sql: {}", (Object)alterTableOptComment);
        }
        ArrayList<String> returnValue = new ArrayList<String>();
        returnValue.add(alterTableOptComment);
        return returnValue;
    }

    public static List<String> getAlterIndexesInfo(String tableName, AlterIndexEnum alterIndexEnum, List<TableIndex> tableIndexes) {
        ArrayList<String> returnValue = new ArrayList<String>();
        tableIndexes.forEach(tableIndex -> {
            List<String> alterTableSqlParams = ModelTablePartialSqlGenerator.generateAlterIndexSql(tableName, alterIndexEnum, tableIndex);
            returnValue.addAll(alterTableSqlParams);
            if (log.isDebugEnabled()) {
                log.debug(">>>>> gen Alter indexes Params: tableName = {}, alterIndexEnum = {}, tableIndex = {}", new Object[]{tableName, alterIndexEnum, tableIndex});
                log.debug(">>>>> gen Alter indexes SQL: {}", alterTableSqlParams);
            }
        });
        return returnValue;
    }

    public static List<String> generateAlterIndexSql(String tableName, AlterIndexEnum alterIndexEnum, TableIndex tableIndex) {
        LinkedList<String> indexPartialSqls = new LinkedList<String>();
        String targetIndexId = tableIndex.getName();
        ModelIndexDTO targetModelIndex = ModelSchemaUtil.convertTableIndexToModelIndex(tableIndex);
        Map<String, ModelTableSchemaCache> publishedTableCache = ModelDrivenContext.getContext().getPublishedTableCache();
        ModelTableSchemaCache modelTableSchemaCache = publishedTableCache.getOrDefault(tableName, new ModelTableSchemaCache());
        Map<String, Object> publishedRemainIndexes = modelTableSchemaCache.getPublishedRemainIndexes();
        switch (alterIndexEnum) {
            case ADD: {
                String indexAddSpecification = ModelSqlGenerator.generateIndexes(tableIndex);
                String indexAddSql = String.format(" %s %s", alterIndexEnum.getSqlChar(), indexAddSpecification);
                indexPartialSqls.add(indexAddSql);
                publishedRemainIndexes.put(targetIndexId, targetModelIndex);
                log.info("publishedRemainIndexes add {}({})", (Object)targetIndexId, (Object)targetModelIndex);
                break;
            }
            case MODIFY: {
                String alterSpecification = ModelSqlGenerator.generateIndexes(tableIndex);
                if (targetIndexId.equals("PRIMARY KEY")) break;
                if (publishedRemainIndexes.containsKey(targetIndexId)) {
                    log.info("flag1");
                    String indexDropByModifySql = String.format(" DROP INDEX `%s`", targetIndexId);
                    String indexAddByModifySql = String.format(" ADD %s", alterSpecification);
                    indexPartialSqls.add(indexDropByModifySql);
                    indexPartialSqls.add(indexAddByModifySql);
                    publishedRemainIndexes.put(targetIndexId, targetModelIndex);
                    log.info("publishedRemainIndexes modify {}, sql({})", (Object)targetIndexId, indexPartialSqls);
                    break;
                }
                String indexAddByModifySql = String.format(" ADD %s", alterSpecification);
                indexPartialSqls.add(indexAddByModifySql);
                publishedRemainIndexes.put(targetIndexId, targetModelIndex);
                log.info("publishedRemainIndexes add {} when modify", (Object)targetIndexId);
                break;
            }
            case DROP: {
                if (publishedRemainIndexes.containsKey(targetIndexId) && !targetIndexId.equals("PRIMARY KEY")) {
                    log.info("flag2");
                    String dropColumnSql = String.format(" DROP INDEX `%s`", targetIndexId);
                    indexPartialSqls.add(dropColumnSql);
                    publishedRemainIndexes.remove(targetIndexId);
                    log.info("publishedRemainIndexes: remove {}", (Object)targetIndexId);
                    break;
                }
                log.warn("publishedRemainIndexes: ignored to drop {}", (Object)targetIndexId);
                break;
            }
            default: {
                throw new DWRuntimeException("\u4e0d\u652f\u6301\u8be5\u64cd\u4f5c");
            }
        }
        return indexPartialSqls;
    }

    public static String getAutoPartialSql(String tableName, AlterColumnEnum alterColumnEnum, TableColumn draftTableColumn, String autoIncrementOrDefaultValue) {
        String modifyColumnSql = String.format(" %s `%s` %s %s %s %s '%s' ", alterColumnEnum.getSqlChar(), draftTableColumn.getColumnName(), ModelSqlGenerator.getTypeDDL(draftTableColumn), ModelSqlGenerator.getNullableEnum(draftTableColumn.nullable()).getSqlChar(), autoIncrementOrDefaultValue, "COMMENT", draftTableColumn.getComment());
        return modifyColumnSql;
    }
}

