/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.lcdp.modeldriven.utils.compare;

import com.digiwin.lcdp.modeldriven.enums.AlterAutoIncrementEnum;
import com.digiwin.lcdp.modeldriven.model.TableColumn;
import com.digiwin.lcdp.modeldriven.utils.ModelSchemaUtil;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ColumnCompareUtil {
    private static final Logger log = LoggerFactory.getLogger(ColumnCompareUtil.class);
    private static final String _CLASSTAG = "[" + ColumnCompareUtil.class.getSimpleName() + "]";

    public static List<TableColumn> getAddColumns(List<TableColumn> draftTableColumns, List<TableColumn> adcutalTableColumns) {
        List<TableColumn> addColumns = draftTableColumns.stream().filter(draftTableColumn -> ModelSchemaUtil.checkRelatedType(draftTableColumn) && adcutalTableColumns.stream().noneMatch(actualColumn -> Objects.equals(draftTableColumn.getColumnName(), actualColumn.getColumnName()))).collect(Collectors.toList());
        return addColumns;
    }

    public static List<TableColumn> getModifyColumns(List<TableColumn> draftTableColumns, List<TableColumn> actualTableColumns) {
        List<TableColumn> modifyColumns = draftTableColumns.stream().filter(draftTableColumn -> ModelSchemaUtil.checkRelatedType(draftTableColumn) && actualTableColumns.stream().anyMatch(actualColumn -> draftTableColumn.getColumnName().equals(actualColumn.getColumnName()) && !draftTableColumn.equalsIgnoredUnique(actualColumn))).collect(Collectors.toList());
        return modifyColumns;
    }

    public static List<TableColumn> getDropColumns(List<TableColumn> draftTableColumns, List<TableColumn> actualTableColumns, List<TableColumn> publishTableColumns) {
        List dropColumnsByComparedModel = publishTableColumns.stream().filter(publishedColumn -> ModelSchemaUtil.checkRelatedType(publishedColumn) && draftTableColumns.stream().noneMatch(draftModelField -> Objects.equals(publishedColumn.getColumnName(), draftModelField.getColumnName()))).collect(Collectors.toList());
        List<TableColumn> validDropColumns = dropColumnsByComparedModel.stream().filter(dropColumn -> actualTableColumns.stream().anyMatch(actualTableColumn -> Objects.equals(dropColumn.getColumnName(), actualTableColumn.getColumnName()))).collect(Collectors.toList());
        log.info(_CLASSTAG + " validDropColumns({}) = dropColumnsByComparedModel({}) anyMatch in actualTableColumns:({})", new Object[]{validDropColumns.stream().map(vCol -> vCol.getColumnName()).collect(Collectors.toList()), dropColumnsByComparedModel.stream().map(dropCol -> dropCol.getColumnName()).collect(Collectors.toList()), actualTableColumns.stream().map(eCol -> eCol.getColumnName()).collect(Collectors.toList())});
        return validDropColumns;
    }

    public static LinkedHashMap<AlterAutoIncrementEnum, TableColumn> getChangeAutoIncrementColumn(List<TableColumn> draftTableColumns, List<TableColumn> actualTableColumns) {
        LinkedHashMap<AlterAutoIncrementEnum, TableColumn> changeMap = new LinkedHashMap<AlterAutoIncrementEnum, TableColumn>();
        TableColumn actualColumnWithAutoIncrement = actualTableColumns.stream().filter(existedColumn -> existedColumn.getAutoIncrement()).findFirst().orElse(null);
        TableColumn draftColumnWithAutoIncrement = draftTableColumns.stream().filter(draftColumn -> draftColumn.getAutoIncrement()).findFirst().orElse(null);
        log.debug(_CLASSTAG + "autoIncrement ignore change, draft({}),actual({})", (Object)draftColumnWithAutoIncrement, (Object)actualColumnWithAutoIncrement);
        if (actualColumnWithAutoIncrement != null && draftColumnWithAutoIncrement != null) {
            if (!StringUtils.equals((CharSequence)actualColumnWithAutoIncrement.getColumnName(), (CharSequence)draftColumnWithAutoIncrement.getColumnName())) {
                changeMap.put(AlterAutoIncrementEnum.DROP, actualColumnWithAutoIncrement);
                changeMap.put(AlterAutoIncrementEnum.ADD, draftColumnWithAutoIncrement);
                log.info(_CLASSTAG + " autoIncrement drop actual({}),add draft({})", (Object)actualColumnWithAutoIncrement.getColumnName(), (Object)draftColumnWithAutoIncrement.getColumnName());
            } else {
                log.info(_CLASSTAG + " autoIncrement ignore change(same columnName)");
            }
        } else if (actualColumnWithAutoIncrement == null && draftColumnWithAutoIncrement != null) {
            changeMap.put(AlterAutoIncrementEnum.ADD, draftColumnWithAutoIncrement);
        } else if (actualColumnWithAutoIncrement != null && draftColumnWithAutoIncrement == null) {
            changeMap.put(AlterAutoIncrementEnum.DROP, actualColumnWithAutoIncrement);
        }
        log.debug(_CLASSTAG + "[getChangeAutoIncrementColumn] changeMap ({})", changeMap);
        return changeMap;
    }
}

