/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.lcdp.modeldriven.utils.compare;

import com.digiwin.lcdp.modeldriven.constants.ModelDBConstants;
import com.digiwin.lcdp.modeldriven.enums.AlterIndexEnum;
import com.digiwin.lcdp.modeldriven.enums.IndexTypeEnum;
import com.digiwin.lcdp.modeldriven.model.ModelFieldDTO;
import com.digiwin.lcdp.modeldriven.model.ModelTable;
import com.digiwin.lcdp.modeldriven.model.TableColumn;
import com.digiwin.lcdp.modeldriven.model.TableIndex;
import com.digiwin.lcdp.modeldriven.utils.ModelSchemaUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IndexCompareKingbaseUtil {
    private static final Logger log = LoggerFactory.getLogger(IndexCompareKingbaseUtil.class);
    private static final String _CLASSTAG = "[" + IndexCompareKingbaseUtil.class.getSimpleName() + "]";

    public static List<TableIndex> getAddIndexes(List<TableIndex> draftTableIndexes, List<TableIndex> actualTableIndexes) {
        List<TableIndex> addIndexes = draftTableIndexes.stream().filter(draftTableIndex -> actualTableIndexes.stream().noneMatch(actulTableIndex -> Objects.equals(draftTableIndex.getName(), actulTableIndex.getName()))).collect(Collectors.toList());
        return addIndexes;
    }

    public static List<TableIndex> getModifyIndexes(List<TableIndex> draftTableIndexes, List<TableIndex> actualTableIndexes) {
        List<TableIndex> modifyIndexes = draftTableIndexes.stream().filter(draftIndex -> actualTableIndexes.stream().anyMatch(actualIndex -> Objects.equals(draftIndex.getName(), actualIndex.getName()) && !draftIndex.equals(actualIndex))).collect(Collectors.toList());
        return modifyIndexes;
    }

    public static List<TableIndex> getDropIndexes(List<TableIndex> draftTableIndexes, List<TableIndex> actualTableIndexes, List<TableIndex> publishedTableIndexes) {
        List<Object> validDropIndexes = new ArrayList();
        if (CollectionUtils.isNotEmpty(publishedTableIndexes)) {
            List dropIndexesByComparedModel = publishedTableIndexes.stream().filter(publishedIndex -> draftTableIndexes.stream().noneMatch(draftIndex -> Objects.equals(publishedIndex.getName(), draftIndex.getName()))).collect(Collectors.toList());
            validDropIndexes = dropIndexesByComparedModel.stream().filter(dropColumn -> actualTableIndexes.stream().anyMatch(actualIndex -> Objects.equals(dropColumn.getName(), actualIndex.getName()))).collect(Collectors.toList());
            log.info(_CLASSTAG + " validDropIndexes({}) = dropIndexesByComparedModel({}) anyMatch in actualTableIndexes:({})", new Object[]{validDropIndexes.stream().map(vCol -> vCol.getName()).collect(Collectors.toList()), dropIndexesByComparedModel.stream().map(dropCol -> dropCol.getName()).collect(Collectors.toList()), actualTableIndexes.stream().map(eCol -> eCol.getName()).collect(Collectors.toList())});
        } else {
            validDropIndexes = actualTableIndexes.stream().filter(actualIndex -> draftTableIndexes.stream().noneMatch(draftIndex -> Objects.equals(actualIndex.getName(), draftIndex.getName()))).collect(Collectors.toList());
        }
        return validDropIndexes;
    }

    public static Map<AlterIndexEnum, List<TableIndex>> getAlterColumnUniqueIndexesWhenCompareExistedTable(List<TableColumn> draftTableColumns, List<TableColumn> actualTableColumns, List<TableColumn> publishedTableColumns) {
        List diffUniqueTableColumns = draftTableColumns.stream().filter(drfColumn -> ModelSchemaUtil.checkRelatedType(drfColumn) && drfColumn.getAutoIncrement() == false && !ModelDBConstants.UNIQUE_INDEX_EXCLUDED_DATATYPE.contains(drfColumn.getDataType().getName()) && actualTableColumns.stream().anyMatch(actColumn -> Objects.equals(drfColumn.getColumnName(), actColumn.getColumnName()) && !Objects.equals(drfColumn.getUnique(), actColumn.getUnique()))).collect(Collectors.toList());
        log.info(_CLASSTAG + "[getAlterColumnUniqueIndexesWhenCompareExistedTable] compared column-unique -> diffUniqueTableColumns({}) of draftTableColumns", diffUniqueTableColumns);
        List validAddColumnUniqueIndexes = diffUniqueTableColumns.stream().filter(diffUnqTableColumn -> diffUnqTableColumn.getUnique()).map(ModelSchemaUtil::convertTableColumnToTableUniqueIndex).collect(Collectors.toList());
        log.info(_CLASSTAG + "[getAlterColumnUniqueIndexesWhenCompareExistedTable] compared column-unique -> validAddColumnUniqueIndexes({})", validAddColumnUniqueIndexes.stream().map(idx -> idx.getName()).collect(Collectors.toList()));
        List validDropColumnUniqueIndexes = diffUniqueTableColumns.stream().filter(diffUnqTableColumn -> diffUnqTableColumn.getUnique() == false).map(ModelSchemaUtil::convertTableColumnToTableUniqueIndex).collect(Collectors.toList());
        log.info(_CLASSTAG + "[getAlterColumnUniqueIndexesWhenCompareExistedTable] compared column-unique -> validDropColumnUniqueIndexes({})", validDropColumnUniqueIndexes.stream().map(idx -> idx.getName()).collect(Collectors.toList()));
        HashMap<AlterIndexEnum, List<TableIndex>> alterColumnUniqueIndexes = new HashMap<AlterIndexEnum, List<TableIndex>>();
        if (CollectionUtils.isNotEmpty(validAddColumnUniqueIndexes)) {
            alterColumnUniqueIndexes.put(AlterIndexEnum.ADD, validAddColumnUniqueIndexes);
        }
        if (CollectionUtils.isNotEmpty(validDropColumnUniqueIndexes)) {
            alterColumnUniqueIndexes.put(AlterIndexEnum.DROP, validDropColumnUniqueIndexes);
        }
        log.info(_CLASSTAG + "[getAlterColumnUniqueIndexesWhenCompareExistedTable] compared column-unique -> alterColumnUniqueIndexes({})", alterColumnUniqueIndexes);
        return alterColumnUniqueIndexes;
    }

    public static Map<AlterIndexEnum, List<TableIndex>> getAlterColumnUniqueIndexesWhenModifyModel(List<ModelFieldDTO> draftModelFields, List<ModelFieldDTO> publishedModelFields, List<TableIndex> actualTableIndexes) {
        log.debug("[ModelSqlGenerator][getAlterColumnUniqueIndexes]");
        List modifyColumnsOfDraft = draftModelFields.stream().filter(draftModelField -> ModelSchemaUtil.checkRelatedType(draftModelField) && !draftModelField.getAutoIncrement() && !ModelDBConstants.UNIQUE_INDEX_EXCLUDED_DATATYPE.contains(draftModelField.getFieldType()) && publishedModelFields.stream().anyMatch(publishedModelField -> Objects.equals(draftModelField.getFieldId(), publishedModelField.getFieldId()) && !Objects.equals(draftModelField.getUnique(), publishedModelField.getUnique()))).collect(Collectors.toList());
        log.info("[ModelSqlGenerator]comparing column-unique -> compare modify({}), actual({})", modifyColumnsOfDraft.stream().map(idx -> idx.getFieldId()).collect(Collectors.toList()), actualTableIndexes.stream().map(idx -> idx.getName()).collect(Collectors.toList()));
        List validAddColumnUniqueIndexes = modifyColumnsOfDraft.stream().filter(modelField -> modelField.getUnique() && actualTableIndexes.stream().noneMatch(actualTableIndex -> Objects.equals(actualTableIndex.getName(), modelField.getFieldId()))).map(ModelSchemaUtil::convertModelFieldToTableUniqueIndex).collect(Collectors.toList());
        log.info("[ModelSqlGenerator]comparing column-unique -> validAddColumnUniqueIndexes({})", validAddColumnUniqueIndexes.stream().map(idx -> idx.getName()).collect(Collectors.toList()));
        List validDropColumnUniqueIndexes = modifyColumnsOfDraft.stream().filter(modelField -> !modelField.getUnique() && actualTableIndexes.stream().anyMatch(actualTableIndex -> Objects.equals(actualTableIndex.getName(), modelField.getFieldId()))).map(ModelSchemaUtil::convertModelFieldToTableUniqueIndex).collect(Collectors.toList());
        log.info("[ModelSqlGenerator]comparing column-unique -> validDropColumnUniqueIndexes({})", validDropColumnUniqueIndexes.stream().map(idx -> idx.getName()).collect(Collectors.toList()));
        HashMap<AlterIndexEnum, List<TableIndex>> alterColumnUniqueIndexes = new HashMap<AlterIndexEnum, List<TableIndex>>();
        alterColumnUniqueIndexes.put(AlterIndexEnum.ADD, validAddColumnUniqueIndexes);
        alterColumnUniqueIndexes.put(AlterIndexEnum.DROP, validDropColumnUniqueIndexes);
        return alterColumnUniqueIndexes;
    }

    public static LinkedHashMap<AlterIndexEnum, TableIndex> getChangePkIndex(ModelTable draftModelTable, ModelTable actualModelTable) {
        LinkedHashMap<AlterIndexEnum, TableIndex> changeMap = new LinkedHashMap<AlterIndexEnum, TableIndex>();
        TableIndex draftPk = draftModelTable.getIndexes().stream().filter(index -> index.getType() == IndexTypeEnum.PRIMARY_KEY).findFirst().orElse(null);
        TableIndex actualPk = actualModelTable.getIndexes().stream().filter(index -> index.getType() == IndexTypeEnum.PRIMARY_KEY).findFirst().orElse(null);
        log.debug(_CLASSTAG + " pk ignore change, draft({}),actual({})", (Object)draftPk, (Object)actualPk);
        if (actualPk != null && draftPk != null) {
            if (!actualPk.equals(draftPk)) {
                changeMap.put(AlterIndexEnum.DROP, actualPk);
                changeMap.put(AlterIndexEnum.ADD, draftPk);
                log.info(_CLASSTAG + " autoIncrement drop actual({}),add draft({})", (Object)actualPk, (Object)draftPk);
            } else {
                log.info(_CLASSTAG + " autoIncrement ignore change(same pk)");
            }
        } else if (actualPk == null && draftPk != null) {
            changeMap.put(AlterIndexEnum.ADD, draftPk);
        } else if (actualPk != null && draftPk == null) {
            changeMap.put(AlterIndexEnum.DROP, actualPk);
        }
        log.debug(_CLASSTAG + "[isPkChange] {} = compare actualPks({}) ({})", new Object[]{changeMap, actualPk, draftPk});
        return changeMap;
    }
}

