/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.lcdp.modeldriven.utils;

import com.digiwin.lcdp.modeldriven.enums.AlterAutoIncrementEnum;
import com.digiwin.lcdp.modeldriven.enums.AlterIndexEnum;
import com.digiwin.lcdp.modeldriven.model.ModelTable;
import com.digiwin.lcdp.modeldriven.model.TableColumn;
import com.digiwin.lcdp.modeldriven.model.TableIndex;
import com.digiwin.lcdp.modeldriven.utils.compare.ColumnCompareUtil;
import com.digiwin.lcdp.modeldriven.utils.compare.IndexCompareUtil;
import io.jsonwebtoken.lang.Assert;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class DaMengDBTableUtil {
    private static Log _logger = LogFactory.getLog(DaMengDBTableUtil.class);

    public static String removeBackQuoteSymbol(String name) {
        String returnValue = name.replaceAll("`", "");
        return returnValue;
    }

    public static String removeApostropheSymbol(String name) {
        if (name == null) {
            return name;
        }
        String returnValue = name.replaceAll("'", "");
        return returnValue;
    }

    public static boolean checkChangePkAndAutoIncrement(Map<String, ModelTable> draftModelTableMap, Map<String, Object> modelTablesOfDb) {
        boolean isChangePkAndAutoIncrement = false;
        String checkResultReturnMessage = "dummy";
        for (String tableName : modelTablesOfDb.keySet()) {
            ModelTable draftModelTable = draftModelTableMap.get(tableName);
            ModelTable actualModelTable = (ModelTable)modelTablesOfDb.get(tableName);
            LinkedHashMap<AlterAutoIncrementEnum, TableColumn> changedAutoIncrmtMap = ColumnCompareUtil.getChangeAutoIncrementColumn(draftModelTable.getColumns(), actualModelTable.getColumns());
            boolean isChangeAutoIncrement = MapUtils.isNotEmpty(changedAutoIncrmtMap);
            if (isChangeAutoIncrement) {
                isChangePkAndAutoIncrement = true;
                checkResultReturnMessage = String.format("no changed. modelTable(%s) isChangeAutoIncrement(%b)", tableName, isChangeAutoIncrement);
                _logger.info((Object)checkResultReturnMessage);
                break;
            }
            LinkedHashMap<AlterIndexEnum, TableIndex> changedPkMap = IndexCompareUtil.getChangePkIndex(draftModelTable, actualModelTable);
            boolean isChangePk = MapUtils.isNotEmpty(changedPkMap);
            if (!isChangePk) continue;
            isChangePkAndAutoIncrement = true;
            checkResultReturnMessage = String.format("no changed. modelTable(%s)  isChangePk(%b)", tableName, isChangePk);
            _logger.info((Object)checkResultReturnMessage);
            break;
        }
        return isChangePkAndAutoIncrement;
    }

    public static String genPrimaryKey(String tableName) {
        Assert.notNull((Object)tableName, (String)" genPrimaryKey: tableName can't be null");
        String pkName = String.join((CharSequence)"_", tableName, "pkey");
        return pkName;
    }

    public static String genUniqueKey(String tableName, String indexName) {
        Assert.notNull((Object)tableName, (String)" genUniqueKey: tableName can't be null");
        String ukName = String.join((CharSequence)"_", tableName, indexName, "ukey");
        return ukName;
    }

    public static String genGenericKey(String tableName, String indexName) {
        Assert.notNull((Object)tableName, (String)" genGenericKey: tableName can't be null");
        String ukName = String.join((CharSequence)"_", tableName, indexName, "ikey");
        return ukName;
    }
}

