/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.lcdp.modeldriven.utils;

import com.digiwin.app.dao.DWDao;
import com.digiwin.app.dao.DWQueryInfo;
import com.digiwin.app.data.DWDataRow;
import com.digiwin.app.data.DWDataSetOperationOption;
import com.digiwin.lcdp.modeldriven.utils.DataEntryTokenUtil;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.collections.MapUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DataEntryTableUtil {
    private static final Logger _log = LoggerFactory.getLogger(DataEntryTableUtil.class);

    public static Map<String, Object> getHashVersionByAppId(DWDao dao, String appId, String userTableName) {
        String tenantId = DataEntryTokenUtil.getCurrentTenantId();
        Map<String, Object> returnValue = DataEntryTableUtil.getUserTableNameHashData(dao, tenantId, appId, userTableName);
        return returnValue;
    }

    public static Map<String, Object> getHashVersionByTenantId(DWDao dao, String tenantId, String userTableName) {
        String appId = DataEntryTokenUtil.getCurrentAppId();
        Map<String, Object> returnValue = DataEntryTableUtil.getUserTableNameHashData(dao, tenantId, appId, userTableName);
        return returnValue;
    }

    public static Map<String, Object> getUserTableNameHashData(DWDao dao, String tenantId, String appId, String userTableName) {
        DWDataSetOperationOption option = new DWDataSetOperationOption();
        option.setTenantEnabled(false);
        DWQueryInfo queryInfo = new DWQueryInfo();
        queryInfo.addSelectField(new String[]{"hash_version", "table_name"}).addEqualInfo("tenant_id", (Object)tenantId).addEqualInfo("app_id", (Object)appId).addEqualInfo("user_table_name", (Object)userTableName);
        queryInfo.setTableName("dw_lcdp_form_info");
        DWDataRow dataRow = dao.selectOne(queryInfo, option);
        Map<String, Object> returnValue = new HashMap<String, Object>();
        if (dataRow != null && MapUtils.isNotEmpty((Map)dataRow.getData())) {
            returnValue = dataRow.getData();
        }
        if (_log.isDebugEnabled()) {
            _log.debug(String.format("[LcdpTableUtil] form_info query result:%s", returnValue.toString()));
        }
        return returnValue;
    }
}

