/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.lcdp.modeldriven.utils;

import com.digiwin.app.metadata.DWMetadata;
import com.digiwin.app.metadata.DWMetadataContainer;
import com.digiwin.app.metadata.exceptions.DWMetadataNotFoundException;
import com.digiwin.app.metadata.rdbms.DWRdbmsMetadata;
import com.digiwin.lcdp.modeldriven.utils.DBTableUtil;
import java.util.List;
import net.sf.jsqlparser.JSQLParserException;
import net.sf.jsqlparser.parser.CCJSqlParserUtil;
import net.sf.jsqlparser.schema.Table;
import net.sf.jsqlparser.statement.Statement;
import net.sf.jsqlparser.statement.alter.Alter;
import net.sf.jsqlparser.statement.drop.Drop;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ModelDrivenMetadataUtil {
    private static final Logger log = LoggerFactory.getLogger(ModelDrivenMetadataUtil.class);

    @Deprecated
    public static int removeMetadataIfPresentDropTable(String sql) throws JSQLParserException {
        int tableExecuteCount = 0;
        Statement statement = CCJSqlParserUtil.parse((String)sql);
        if (statement instanceof Drop) {
            Drop dropScript = (Drop)statement;
            Table table = dropScript.getName();
            String sqlTableName = table.getName();
            String realTableName = DBTableUtil.removeSchemaSymbol(sqlTableName);
            DWMetadata removedMetadata = DWMetadataContainer.remove((String)realTableName);
            ++tableExecuteCount;
            log.debug("DWMetadata removed table:{} ({})", (Object)realTableName, (Object)sql);
        } else if (statement instanceof Alter) {
            Alter alterScript = (Alter)statement;
            Table table = alterScript.getTable();
            String sqlTableName = table.getName();
            String realTableName = DBTableUtil.removeSchemaSymbol(sqlTableName);
            DWMetadata removedMetadata = DWMetadataContainer.remove((String)realTableName);
            ++tableExecuteCount;
            log.debug("DWMetadata removed table:{} ({})", (Object)realTableName, (Object)sql);
        } else {
            log.debug("DWMetadata didn't remove table by sql({})", (Object)sql);
        }
        return tableExecuteCount;
    }

    public static boolean isExistInRdbmsMetadata(String tableName) {
        try {
            DWMetadata rdbmsMetadata = DWMetadataContainer.get((String)tableName, DWRdbmsMetadata.class);
            return rdbmsMetadata != null;
        }
        catch (DWMetadataNotFoundException e) {
            return false;
        }
    }

    public static DWMetadata<?> loadRdbmsMetadata(String tableName) {
        DWMetadata rdbmsMetadata = DWMetadataContainer.get((String)tableName, DWRdbmsMetadata.class);
        return rdbmsMetadata;
    }

    public static void removeRdbmsMetadata(String code, List<String> tableNames) {
        tableNames.stream().forEach(tableName -> DWMetadataContainer.remove((String)tableName));
        log.info("[ModelDrivenMetadataUtil][removeRdbmsMetadata] code({}) removed metadata ({})", (Object)code, tableNames);
    }
}

