/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.lcdp.modeldriven.utils;

import com.digiwin.lcdp.modeldriven.enums.IndexTypeEnum;
import com.digiwin.lcdp.modeldriven.model.TableIndex;
import com.digiwin.lcdp.modeldriven.utils.DBTableUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ModelIndexDMUtil {
    private static final Logger log = LoggerFactory.getLogger(ModelIndexDMUtil.class);
    private static final String _CLASSTAG = "[" + ModelIndexDMUtil.class.getSimpleName() + "]";

    public static List<TableIndex> convertToTableIndex(Map<String, Object> indexCreateSqls, String tableName) {
        ArrayList<TableIndex> tableIndexes = new ArrayList<TableIndex>();
        String indexToken = "  " + IndexTypeEnum.INDEX.getIndexCommandChar();
        for (String indexName : indexCreateSqls.keySet()) {
            String createIndexSqlCommand = (String)indexCreateSqls.get(indexName);
            TableIndex tempIndex = new TableIndex();
            tempIndex.setName(indexName);
            tempIndex.setTableName(tableName);
            if (createIndexSqlCommand.contains("CREATE OR REPLACE UNIQUE" + indexToken)) {
                tempIndex.setType(IndexTypeEnum.UNIQUE_INDEX);
            } else if (createIndexSqlCommand.contains("CREATE OR REPLACE" + indexToken)) {
                tempIndex.setType(IndexTypeEnum.INDEX);
            }
            int memberStart = createIndexSqlCommand.indexOf("(");
            int memberEnd = createIndexSqlCommand.indexOf(")");
            String memberStr = createIndexSqlCommand.substring(memberStart + 1, memberEnd);
            ArrayList<String> members = new ArrayList<String>();
            String[] memberToken = memberStr.split(",");
            Arrays.stream(memberToken).forEach(row -> {
                row = row.replaceAll(" ASC", "").replaceAll(" DESC", "");
                row = DBTableUtil.removeSchemaSymbol(row.trim());
                members.add((String)row);
            });
            tempIndex.setMember(members);
            tableIndexes.add(tempIndex);
        }
        log.debug(_CLASSTAG + " index:{}", tableIndexes);
        return tableIndexes;
    }
}

