/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.lcdp.modeldriven.utils;

import com.digiwin.app.data.DWDataRow;
import com.digiwin.app.ddl.model.Field;
import com.digiwin.app.json.gson.DWGsonProvider;
import com.digiwin.lcdp.modeldriven.context.ModelDrivenContext;
import com.digiwin.lcdp.modeldriven.enums.AlterAutoIncrementEnum;
import com.digiwin.lcdp.modeldriven.enums.AlterColumnEnum;
import com.digiwin.lcdp.modeldriven.enums.IndexTypeEnum;
import com.digiwin.lcdp.modeldriven.enums.ModelFieldRelationTypeEnum;
import com.digiwin.lcdp.modeldriven.model.ModelDTO;
import com.digiwin.lcdp.modeldriven.model.ModelFieldDTO;
import com.digiwin.lcdp.modeldriven.model.ModelIndexDTO;
import com.digiwin.lcdp.modeldriven.model.ModelSchemaDTO;
import com.digiwin.lcdp.modeldriven.model.ModelTable;
import com.digiwin.lcdp.modeldriven.model.ModelTableSchemaCache;
import com.digiwin.lcdp.modeldriven.model.SqlParam;
import com.digiwin.lcdp.modeldriven.model.TableColumn;
import com.digiwin.lcdp.modeldriven.model.TableIndex;
import com.digiwin.lcdp.modeldriven.utils.DBColumnUtil;
import com.digiwin.lcdp.modeldriven.utils.DaMengDBTableUtil;
import com.digiwin.lcdp.modeldriven.utils.ModelDataUtil;
import com.digiwin.lcdp.modeldriven.utils.ModelIndexUtil;
import com.digiwin.lcdp.modeldriven.utils.ModelSqlGenerator;
import com.digiwin.lcdp.modeldriven.utils.ModelTableHelperExpress;
import com.digiwin.lcdp.modeldriven.utils.compare.ColumnCompareUtil;
import com.google.gson.Gson;
import io.jsonwebtoken.lang.Assert;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class ModelSchemaUtil {
    private static final Logger log = LoggerFactory.getLogger(ModelSchemaUtil.class);
    private static String logTag = "[" + ModelSchemaUtil.class.getSimpleName() + "]";
    private static ModelTableHelperExpress modelTableHelperExpress;

    public static List<String> getChildrenName(List<ModelSchemaDTO> childrenSchemas) {
        ArrayList<String> childrenModelSchemaNames = new ArrayList<String>();
        if (!CollectionUtils.isEmpty(childrenSchemas)) {
            for (ModelSchemaDTO tempModelSchema : childrenSchemas) {
                List<ModelSchemaDTO> tempChildrenSchema = tempModelSchema.getChildren();
                List tempChildrenNames = tempChildrenSchema.stream().map(modelSchemaDTO -> modelSchemaDTO.getName()).collect(Collectors.toList());
                childrenModelSchemaNames.addAll(tempChildrenNames);
            }
        }
        return childrenModelSchemaNames;
    }

    public static Map<String, ModelSchemaDTO> getChildrenModelSchemaMap(List<ModelSchemaDTO> childrenSchemas) {
        HashMap<String, ModelSchemaDTO> returnValue = new HashMap<String, ModelSchemaDTO>();
        if (!CollectionUtils.isEmpty(childrenSchemas)) {
            for (ModelSchemaDTO tempModelSchema : childrenSchemas) {
                List<ModelSchemaDTO> childrenSchema = tempModelSchema.getChildren();
                Map tempChildrenSchemeMap = childrenSchema.stream().collect(Collectors.toMap(ModelSchemaDTO::getName, Function.identity()));
                returnValue.putAll(tempChildrenSchemeMap);
            }
        }
        return returnValue;
    }

    public static List<ModelSchemaDTO> getChildrenModelSchema(List<ModelSchemaDTO> childrenSchemas) {
        if (CollectionUtils.isEmpty(childrenSchemas)) {
            return new ArrayList<ModelSchemaDTO>();
        }
        return ModelSchemaUtil.getChildrenModelSchema(childrenSchemas, 1);
    }

    protected static List<ModelSchemaDTO> getChildrenModelSchema(List<ModelSchemaDTO> childrenSchemas, int level) {
        ArrayList<ModelSchemaDTO> childrenModelSchema = new ArrayList<ModelSchemaDTO>();
        List<Object> childrenModelSchemaNames = new ArrayList();
        if (level <= 3 && !CollectionUtils.isEmpty(childrenSchemas)) {
            childrenModelSchemaNames = childrenSchemas.stream().map(modelSchemaDTO -> modelSchemaDTO.getName()).collect(Collectors.toList());
            log.debug("process children at level {} , current childrenModelSchema {}", (Object)level, childrenModelSchemaNames);
            childrenModelSchema.addAll(childrenSchemas);
            for (ModelSchemaDTO childModelSchema : childrenSchemas) {
                List<ModelSchemaDTO> modelSchemaDTOList = ModelSchemaUtil.getChildrenModelSchema(childModelSchema.getChildren(), level + 1);
                childrenModelSchema.addAll(modelSchemaDTOList);
            }
        } else {
            log.debug("end: level {} over maxlevel or empty children({})", (Object)level, (Object)childrenSchemas.size());
        }
        return childrenModelSchema;
    }

    public static List<ModelTable> getModelTables(ModelSchemaDTO modelSchema, boolean includeCollection) {
        if (BooleanUtils.isTrue((Boolean)includeCollection)) {
            return ModelSchemaUtil.getModelTables(modelSchema);
        }
        Map<String, ModelSchemaDTO> modelSchemaMap = ModelSchemaUtil.getModelSchemaMap(modelSchema);
        ArrayList<ModelTable> modelTables = new ArrayList<ModelTable>();
        for (ModelSchemaDTO tempModelSchema : modelSchemaMap.values()) {
            ModelTable tempModelTable = ModelSchemaUtil.getCurrentLevelModelTable(tempModelSchema, includeCollection);
            modelTables.add(tempModelTable);
        }
        return modelTables;
    }

    public static ModelTable getCurrentLevelModelTable(ModelSchemaDTO modelSchema, boolean includeCollection) {
        if (modelSchema == null) {
            return null;
        }
        ModelTable modelTable = ModelSchemaUtil.convertToSimpleModelTable(modelSchema, includeCollection);
        return modelTable;
    }

    public static List<ModelTable> getModelTables(ModelSchemaDTO modelSchema) {
        List<ModelSchemaDTO> childrenModelSchema;
        ArrayList<ModelSchemaDTO> modelSchemas = new ArrayList<ModelSchemaDTO>();
        modelSchemas.add(modelSchema);
        ArrayList<ModelTable> modelTables = new ArrayList<ModelTable>();
        List<ModelSchemaDTO> childrenSchemas = modelSchema.getChildren();
        if (!CollectionUtils.isEmpty(childrenSchemas) && !CollectionUtils.isEmpty(childrenModelSchema = ModelSchemaUtil.getChildrenModelSchema(childrenSchemas))) {
            modelSchemas.addAll(childrenModelSchema);
        }
        for (ModelSchemaDTO tempModelSchema : modelSchemas) {
            ModelTable tempModelTable = ModelSchemaUtil.getCurrentLevelModelTable(tempModelSchema);
            modelTables.add(tempModelTable);
        }
        return modelTables;
    }

    public static ModelTable getCurrentLevelModelTable(ModelSchemaDTO modelSchema) {
        if (modelSchema == null) {
            return null;
        }
        ModelTable modelTable = ModelSchemaUtil.getCurrentLevelModelTable(modelSchema, false);
        return modelTable;
    }

    public static TableIndex convertModelIndexToTable(ModelIndexDTO modelIndex) {
        if (modelIndex == null) {
            return null;
        }
        TableIndex tableIndex = new TableIndex();
        tableIndex.setTableName(modelIndex.getTableName());
        tableIndex.setMember(modelIndex.getMember());
        if (modelIndex.getType() != null) {
            tableIndex.setType(IndexTypeEnum.getIndexType(modelIndex.getType()));
        }
        tableIndex.setName(modelIndex.getId());
        return tableIndex;
    }

    public static TableIndex convertModelIndexToTable(ModelIndexDTO modelIndex, String tableName) {
        if (modelIndex == null) {
            return null;
        }
        modelIndex.setTableName(tableName);
        TableIndex tableIndex = ModelSchemaUtil.convertModelIndexToTable(modelIndex);
        return tableIndex;
    }

    public static TableIndex convertModelFieldToTableUniqueIndex(ModelFieldDTO modelField) {
        if (modelField == null) {
            return null;
        }
        ArrayList<String> members = new ArrayList<String>();
        members.add(modelField.getFieldId());
        TableIndex tableIndex = new TableIndex();
        tableIndex.setName(modelField.getFieldId());
        tableIndex.setMember(members);
        tableIndex.setType(IndexTypeEnum.UNIQUE_INDEX);
        return tableIndex;
    }

    public static TableIndex convertTableColumnToTableColumnUniqueIndex(TableColumn tableColumn, String tableName) {
        if (tableColumn == null) {
            return null;
        }
        TableIndex tableIndex = ModelSchemaUtil.convertTableColumnToTableColumnUniqueIndex(tableColumn);
        tableIndex.setTableName(tableName);
        return tableIndex;
    }

    public static TableIndex convertTableColumnToTableColumnUniqueIndex(TableColumn tableColumn) {
        if (tableColumn == null) {
            return null;
        }
        String columnName = tableColumn.getColumnName();
        ArrayList<String> members = new ArrayList<String>();
        members.add(columnName);
        TableIndex tableIndex = new TableIndex();
        tableIndex.setName(columnName + "_idx");
        tableIndex.setMember(members);
        tableIndex.setType(IndexTypeEnum.UNIQUE_INDEX);
        log.debug("[ModelSchemaUtil] found column unique index({})", (Object)columnName);
        return tableIndex;
    }

    public static TableIndex convertModelIndexToTableIndex(ModelIndexDTO modelIndex) {
        TableIndex tableIndex = ModelSchemaUtil.convertModelIndexToTable(modelIndex);
        return tableIndex;
    }

    public static ModelIndexDTO convertTableIndexToModelIndex(TableIndex tableIndex) {
        if (tableIndex == null) {
            return null;
        }
        ModelIndexDTO modelIndexDTO = new ModelIndexDTO();
        modelIndexDTO.setId(tableIndex.getName());
        modelIndexDTO.setMember(tableIndex.getMember());
        if (tableIndex.getType() != null) {
            modelIndexDTO.setType(tableIndex.getType().getIndexChar());
        }
        return modelIndexDTO;
    }

    public static TableColumn convertModelFieldToTableColumn(ModelFieldDTO modelField) {
        if (modelField == null) {
            return null;
        }
        ModelFieldRelationTypeEnum relationTypeEnum = ModelFieldRelationTypeEnum.valueOf(modelField.getType());
        switch (relationTypeEnum) {
            case COLLECTION: {
                log.debug("should ignore: modelField '{}' is {}", (Object)modelField.getFieldId(), (Object)relationTypeEnum.getValue());
            }
        }
        TableColumn tableColumn = DBColumnUtil.convertToTableColumn(modelField);
        return tableColumn;
    }

    public static List<String> getTableNames(ModelSchemaDTO modelSchemaDTO) {
        ArrayList<String> tableNames = new ArrayList<String>();
        tableNames.add(modelSchemaDTO.getName());
        List<ModelSchemaDTO> childrenSchemas = modelSchemaDTO.getChildren();
        if (CollectionUtils.isNotEmpty(childrenSchemas)) {
            List<ModelSchemaDTO> childrenModelSchema = ModelSchemaUtil.getChildrenModelSchema(childrenSchemas);
            childrenModelSchema.stream().forEach(cModelSchema -> tableNames.add(cModelSchema.getName()));
        }
        return tableNames;
    }

    public static ModelTable convertToSimpleModelTable(ModelSchemaDTO modelSchema) {
        if (modelSchema == null) {
            return null;
        }
        ModelTable modelTable = new ModelTable();
        modelTable.setName(modelSchema.getName());
        modelTable.setComment(modelSchema.getComment());
        List<TableColumn> tableColumns = modelSchema.getFields().stream().map(ModelSchemaUtil::convertModelFieldToTableColumn).collect(Collectors.toList());
        modelTable.setColumns(tableColumns);
        return modelTable;
    }

    public static ModelTable convertToSimpleModelTable(ModelSchemaDTO modelSchema, boolean includeCollection) {
        String msPk;
        if (modelSchema == null) {
            return null;
        }
        String tableName = modelSchema.getName();
        ModelTable modelTable = new ModelTable();
        modelTable.setName(tableName);
        modelTable.setComment(modelSchema.getComment());
        List<TableColumn> allTableColumns = BooleanUtils.isTrue((Boolean)includeCollection) ? modelSchema.getFields().stream().map(ModelSchemaUtil::convertModelFieldToTableColumn).collect(Collectors.toList()) : modelSchema.getFields().stream().filter(tableColumn -> ModelSchemaUtil.checkRelatedType(tableColumn)).map(DBColumnUtil::convertToTableColumn).collect(Collectors.toList());
        modelTable.setColumns(allTableColumns);
        List<TableIndex> tableIndexes = new ArrayList<TableIndex>();
        List<ModelIndexDTO> modelIndexes = modelSchema.getIndex();
        if (modelIndexes != null && !CollectionUtils.isEmpty(modelIndexes)) {
            tableIndexes = modelIndexes.stream().map(modelIndex -> ModelSchemaUtil.convertModelIndexToTable(modelIndex, tableName)).collect(Collectors.toList());
        }
        if (StringUtils.isNotBlank((CharSequence)(msPk = modelSchema.getPk()))) {
            modelTable.setPk(msPk);
            List<String> pks = Arrays.stream(msPk.split(",")).map(String::trim).collect(Collectors.toList());
            TableIndex pkTableIndex = new TableIndex();
            pkTableIndex.setTableName(tableName);
            pkTableIndex.setName(DaMengDBTableUtil.genPrimaryKey(tableName));
            pkTableIndex.setMember(pks);
            pkTableIndex.setType(IndexTypeEnum.PRIMARY_KEY);
            tableIndexes.add(pkTableIndex);
        }
        modelTable.setIndexes(tableIndexes);
        return modelTable;
    }

    public static Map<String, LinkedHashMap<String, List<SqlParam>>> getCreateChildTables(List<ModelSchemaDTO> childModelSchemas) throws Exception {
        Map<String, LinkedHashMap<String, List<SqlParam>>> returnValue = new LinkedHashMap<String, LinkedHashMap<String, List<SqlParam>>>();
        if (CollectionUtils.isEmpty(childModelSchemas)) {
            return returnValue;
        }
        List<ModelTable> childTables = childModelSchemas.stream().map(childModelSchema -> {
            ModelTable newModelTable = ModelSchemaUtil.getCurrentLevelModelTable(childModelSchema);
            return newModelTable;
        }).collect(Collectors.toList());
        returnValue = ModelSqlGenerator.getCreateChildTablesCommand(null, "code", childTables, null);
        return returnValue;
    }

    public static void checkModelSchema(ModelSchemaDTO modelSchema, boolean isCreate) {
        ModelDataUtil.preCheckSchema(modelSchema);
        List<ModelSchemaDTO> childrenModelSchema = modelSchema.getChildren();
        if (!CollectionUtils.isEmpty(childrenModelSchema)) {
            childrenModelSchema.forEach(childFormSchema -> ModelSchemaUtil.checkModelSchema(childFormSchema, isCreate));
        }
    }

    public static boolean checkRelatedType(ModelFieldDTO modelField) {
        return !ModelFieldRelationTypeEnum.valueOf(modelField.getType()).equals((Object)ModelFieldRelationTypeEnum.COLLECTION);
    }

    public static boolean checkRelatedType(TableColumn tableColumn) {
        return tableColumn.getRelationTypeEnum() != ModelFieldRelationTypeEnum.COLLECTION;
    }

    public static Map<AlterColumnEnum, List<TableColumn>> getAlterColumnsMapWithoutDrop(ModelTable draftModelTable, ModelTable actualModelTable) {
        List<TableColumn> draftTableColumns = draftModelTable.getColumns();
        List<TableColumn> actualTableColumns = actualModelTable.getColumns();
        HashMap<AlterColumnEnum, List<TableColumn>> alterTableColumnsMap = new HashMap<AlterColumnEnum, List<TableColumn>>();
        List<TableColumn> addColumns = ColumnCompareUtil.getAddColumns(draftTableColumns, actualTableColumns);
        List<TableColumn> modifyColumns = ColumnCompareUtil.getModifyColumns(draftTableColumns, actualTableColumns);
        if (CollectionUtils.isNotEmpty(addColumns)) {
            alterTableColumnsMap.put(AlterColumnEnum.ADD_COLUMN, addColumns);
        }
        if (CollectionUtils.isNotEmpty(modifyColumns)) {
            alterTableColumnsMap.put(AlterColumnEnum.MODIFY_COLUMN, modifyColumns);
        }
        return alterTableColumnsMap;
    }

    public static Map<AlterColumnEnum, List<TableColumn>> getAlterColumnsMap(ModelTable draftSimpleModelTable, ModelTable publishedSimpleModelTable) {
        List<TableColumn> draftTableColumns = draftSimpleModelTable.getColumns();
        List<TableColumn> publishTableColumns = publishedSimpleModelTable.getColumns();
        Map dbModelTables = (Map)ModelDrivenContext.getContext().getExtraMap().get("actualModelTablesFromDB");
        ModelTable actualModelTable = (ModelTable)MapUtils.getObject((Map)dbModelTables, (Object)draftSimpleModelTable.getName());
        Assert.notNull((Object)actualModelTable, (String)"master table is not existed in database(get from cache of actualModelTablesFromDB");
        List<TableColumn> actualTableColumns = actualModelTable.getColumns();
        List<TableColumn> addColumns = ColumnCompareUtil.getAddColumns(draftTableColumns, actualTableColumns);
        List<TableColumn> modifyColumns = ColumnCompareUtil.getModifyColumns(draftTableColumns, actualTableColumns);
        List<TableColumn> dropColumns = ColumnCompareUtil.getDropColumns(draftTableColumns, actualTableColumns, publishTableColumns);
        HashMap<AlterColumnEnum, List<TableColumn>> alterTableColumnsMap = new HashMap<AlterColumnEnum, List<TableColumn>>();
        alterTableColumnsMap.put(AlterColumnEnum.DROP_COLUMN, dropColumns);
        alterTableColumnsMap.put(AlterColumnEnum.ADD_COLUMN, addColumns);
        alterTableColumnsMap.put(AlterColumnEnum.MODIFY_COLUMN, modifyColumns);
        return alterTableColumnsMap;
    }

    public static void updateColumnsSqlParamsWhenNewPublishWithNoApi(String pureTableName, ModelTable draftModelTable, ModelTable actualModelTable, LinkedHashMap<AlterAutoIncrementEnum, TableColumn> changedAutoIncrmt, LinkedList<SqlParam> ddlSqlParams, LinkedList<SqlParam> dmlSqlParams) {
        List<TableColumn> draftTableColumns = draftModelTable.getColumns();
        List<TableColumn> actualTableColumns = actualModelTable.getColumns();
        List<TableColumn> org_addColumns = ColumnCompareUtil.getAddColumns(draftTableColumns, actualTableColumns);
        ModelSqlGenerator.updateAlterColumnsInfoOnly(pureTableName, AlterColumnEnum.ADD_COLUMN, org_addColumns, changedAutoIncrmt, ddlSqlParams, dmlSqlParams);
        List<TableColumn> org_modifyColumns = ColumnCompareUtil.getModifyColumns(draftTableColumns, actualTableColumns);
        ModelSqlGenerator.updateAlterColumnsInfoOnly(pureTableName, AlterColumnEnum.MODIFY_COLUMN, org_modifyColumns, changedAutoIncrmt, ddlSqlParams, dmlSqlParams);
    }

    public static void updateColumnsRdbmsSqlParams(String pureTableName, List<TableColumn> filteredTableColumns, LinkedList<SqlParam> targetDMLSqlParams) {
        filteredTableColumns.forEach(tableColumn -> {
            SqlParam insertOrUpdateRdbmsFieldSql = ModelSqlGenerator.generateInsertOrUpdateRdbmsFieldSql(pureTableName, tableColumn);
            targetDMLSqlParams.add(insertOrUpdateRdbmsFieldSql);
            if (log.isDebugEnabled()) {
                log.debug(">>>>> gen Insert on duplicate key Rdbms Fields SQL: sql = {}, params = {}", (Object)insertOrUpdateRdbmsFieldSql.getSql(), (Object)insertOrUpdateRdbmsFieldSql.getParams());
            }
        });
    }

    public static ModelSchemaDTO getModelSchema(String modelSchemaJsonStr) {
        ModelSchemaDTO modelSchema = (ModelSchemaDTO)DWGsonProvider.getGson().fromJson(modelSchemaJsonStr, ModelSchemaDTO.class);
        return modelSchema;
    }

    public static ModelDTO getModel(DWDataRow dataRow) {
        ModelDTO newModel = new ModelDTO();
        newModel.setTargetTenantId((String)dataRow.get("target_tenant_id"));
        newModel.setCode((String)dataRow.get("code"));
        newModel.setDescription((String)dataRow.get("description"));
        newModel.setAppId((String)dataRow.get("app_id"));
        ModelSchemaDTO modelSchemaDTO = ModelSchemaUtil.parseModelSchema(dataRow);
        newModel.setSchema(modelSchemaDTO);
        return newModel;
    }

    public static ModelSchemaDTO parseModelSchema(DWDataRow dataRow) {
        String code = (String)dataRow.get("code");
        String modelSchemaJsonStr = (String)dataRow.get("model_schema");
        if (StringUtils.isEmpty((CharSequence)modelSchemaJsonStr)) {
            throw new IllegalArgumentException(String.format("\u6a21\u578b %s \u7d00\u9304\u7684\u7d50\u69cb\u70ba\u7a7a", code));
        }
        Gson gson = DWGsonProvider.getGson();
        ModelSchemaDTO modelSchema = (ModelSchemaDTO)gson.fromJson(modelSchemaJsonStr, ModelSchemaDTO.class);
        return modelSchema;
    }

    @Deprecated
    public static ModelSchemaDTO parseModelSchema(Map modelMap) {
        String code = (String)modelMap.get("code");
        String modelSchemaJsonStr = (String)modelMap.get("model_schema");
        if (StringUtils.isEmpty((CharSequence)modelSchemaJsonStr)) {
            throw new IllegalArgumentException(String.format("\u6a21\u578b %s \u7d00\u9304\u7684\u7d50\u69cb\u70ba\u7a7a", code));
        }
        ModelSchemaDTO modelSchema = ModelSchemaUtil.getModelSchema(modelSchemaJsonStr);
        return modelSchema;
    }

    @Deprecated
    public static ModelDTO getModel(Map modelMap) {
        ModelDTO newModel = new ModelDTO();
        newModel.setCode((String)modelMap.get("code"));
        newModel.setDescription((String)modelMap.get("description"));
        newModel.setAppId((String)modelMap.get("app_id"));
        newModel.setTargetTenantId((String)modelMap.get("target_tenant_id"));
        String modelSchemaJsonStr = (String)modelMap.get("model_schema");
        ModelSchemaDTO modelSchema = (ModelSchemaDTO)DWGsonProvider.getGson().fromJson(modelSchemaJsonStr, ModelSchemaDTO.class);
        newModel.setSchema(modelSchema);
        return newModel;
    }

    public static Map<String, List<Map<String, Object>>> validateDatas(Map<String, List<Map<String, Object>>> paramDatas, ModelSchemaDTO masterModelSchema) {
        Map<String, ModelSchemaDTO> modelSchemaMap = ModelSchemaUtil.getModelSchemaMap(masterModelSchema);
        paramDatas.forEach((tableName, modelSchema) -> {
            if (modelSchema != null) {
                modelSchema.forEach(data -> {
                    Iterator iterator = data.entrySet().iterator();
                    while (iterator.hasNext()) {
                        Map.Entry next = iterator.next();
                        String field = (String)next.getKey();
                        Object value = next.getValue();
                        ModelFieldDTO modelFieldDTO = ((ModelSchemaDTO)modelSchemaMap.get(tableName)).getFields().stream().filter(modelSchemaField -> modelSchemaField.getFieldId().equals(field)).findFirst().orElse(null);
                        if (modelFieldDTO != null && !StringUtils.isEmpty((CharSequence)modelFieldDTO.getFieldType()) && (modelFieldDTO.getFieldType().toUpperCase().equals("DATETIME") || modelFieldDTO.getFieldType().toUpperCase().equals("TIMESTAMP") || modelFieldDTO.getFieldType().toUpperCase().equals("DATE"))) {
                            data.put(field, "".equals(value) ? null : (Object)value);
                        }
                        if (modelFieldDTO != null) continue;
                        iterator.remove();
                    }
                });
            }
        });
        return paramDatas;
    }

    public static void dealSpecialTypeDatas(Map<String, Object> rowData, ModelSchemaDTO modelSchema) {
        Iterator<Map.Entry<String, Object>> iterator = rowData.entrySet().iterator();
        Gson gson = DWGsonProvider.getGson();
        while (iterator.hasNext()) {
            Map.Entry<String, Object> next = iterator.next();
            String field = next.getKey();
            Object value = next.getValue();
            ModelFieldDTO modelFieldDTO = modelSchema.getFields().stream().filter(modelSchemaField -> modelSchemaField.getFieldId().equals(field)).findFirst().orElse(null);
            if (modelFieldDTO != null && !StringUtils.isEmpty((CharSequence)modelFieldDTO.getFieldType()) && (modelFieldDTO.getFieldType().toUpperCase().equals("DATETIME") || modelFieldDTO.getFieldType().toUpperCase().equals("TIMESTAMP") || modelFieldDTO.getFieldType().toUpperCase().equals("DATE"))) {
                rowData.put(field, "".equals(value) ? null : value);
            }
            if (modelFieldDTO != null && "JSON".equalsIgnoreCase(modelFieldDTO.getFieldType())) {
                rowData.put(field, gson.toJson(rowData.get(field)));
            }
            if (modelFieldDTO != null) continue;
            iterator.remove();
        }
    }

    public static Map<String, ModelSchemaDTO> getModelSchemaMap(ModelSchemaDTO masterModelSchema) {
        HashMap<String, ModelSchemaDTO> result = new HashMap<String, ModelSchemaDTO>();
        result.put(masterModelSchema.getName(), masterModelSchema);
        List<ModelSchemaDTO> childrenModelSchemas = masterModelSchema.getChildren();
        if (!CollectionUtils.isEmpty(childrenModelSchemas)) {
            childrenModelSchemas.forEach(childrenModelSchema -> result.putAll(ModelSchemaUtil.getModelSchemaMap(childrenModelSchema)));
        }
        return result;
    }

    public static Map<String, ModelTable> getModelTableMap(List<ModelTable> modelTables) {
        HashMap<String, ModelTable> returnValue = new HashMap<String, ModelTable>();
        if (!CollectionUtils.isEmpty(modelTables)) {
            modelTables.forEach(modelTable -> returnValue.put(modelTable.getName(), (ModelTable)modelTable));
        }
        return returnValue;
    }

    public static List<String> getPrimaryKeys(List<TableColumn> customColumns) {
        List<String> pks = customColumns.stream().filter(Field::isPK).map(customColumn -> customColumn.getColumnName()).collect(Collectors.toList());
        return pks;
    }

    public static ModelTableSchemaCache getModelTableSchemaCache(ModelTable actualModelTable) {
        List<TableColumn> actualTableColumns = actualModelTable.getColumns();
        Map<String, Object> actualRemainTableIndexeMap = ModelIndexUtil.getAllTableIndexes(actualModelTable);
        ModelTableSchemaCache publishedTableSchemaCache = new ModelTableSchemaCache();
        publishedTableSchemaCache.setPublishedRemainIndexes(actualRemainTableIndexeMap);
        TableColumn actualAutoIncrmtColumn = DBColumnUtil.getAutoIncrementColumn(actualTableColumns);
        if (actualAutoIncrmtColumn != null) {
            publishedTableSchemaCache.setAutoIncrementColumn(actualAutoIncrmtColumn);
        }
        publishedTableSchemaCache.setTableName(actualModelTable.getName());
        return publishedTableSchemaCache;
    }

    public ModelTableHelperExpress getModelTableHelperExpress() {
        return modelTableHelperExpress;
    }

    public void setModelTableHelperExpress(ModelTableHelperExpress modelTableHelperExpress) {
        ModelSchemaUtil.modelTableHelperExpress = modelTableHelperExpress;
    }
}

