/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.lcdp.modeldriven.utils;

import com.digiwin.app.ddl.enums.DataTypeEnum;
import com.digiwin.lcdp.modeldriven.enums.IndexTypeEnum;
import com.digiwin.lcdp.modeldriven.enums.ModelFieldRelationTypeEnum;
import com.digiwin.lcdp.modeldriven.model.ModelTable;
import com.digiwin.lcdp.modeldriven.model.TableColumn;
import com.digiwin.lcdp.modeldriven.model.TableIndex;
import com.digiwin.lcdp.modeldriven.utils.DBTableUtil;
import com.digiwin.lcdp.modeldriven.utils.ModelSqlParserUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import net.sf.jsqlparser.JSQLParserException;
import net.sf.jsqlparser.parser.CCJSqlParserUtil;
import net.sf.jsqlparser.statement.Statement;
import net.sf.jsqlparser.statement.create.table.ColDataType;
import net.sf.jsqlparser.statement.create.table.ColumnDefinition;
import net.sf.jsqlparser.statement.create.table.CreateTable;
import net.sf.jsqlparser.statement.create.table.Index;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class ModelSqlParserDMUtil {
    private static final Logger log = LoggerFactory.getLogger(ModelSqlParserDMUtil.class);
    private static final String _CLASSTAG = "[" + ModelSqlParserDMUtil.class.getSimpleName() + "]";

    public static List<TableColumn> getTableColumns(List<ColumnDefinition> ccjColumnDefinitions, List<Index> ccjIndexes, Map<String, Object> columnMapFromDb) {
        List<TableColumn> existedTableColumns = ccjColumnDefinitions.stream().map(ccjColumnDef -> ModelSqlParserDMUtil.convertToTableColumn(ccjColumnDef, ccjIndexes, columnMapFromDb)).collect(Collectors.toList());
        return existedTableColumns;
    }

    public static TableColumn convertToTableColumn(ColumnDefinition columnDefinition, List<Index> indexes, Map<String, Object> columnMapFromDb) {
        if (columnDefinition == null) {
            return null;
        }
        TableColumn tableColumn = new TableColumn();
        String ccjColumnName = columnDefinition.getColumnName();
        List cjColumnDefSpecs = columnDefinition.getColumnSpecs();
        tableColumn.setColumnName(DBTableUtil.removeSchemaSymbol(ccjColumnName));
        tableColumn.setComment((String)columnMapFromDb.get(tableColumn.getColumnName()));
        ColDataType colDataType = columnDefinition.getColDataType();
        tableColumn.setDataType(DataTypeEnum.valueOf((String)colDataType.getDataType().toUpperCase()));
        List dataTypeArgs = colDataType.getArgumentsStringList();
        if (CollectionUtils.isNotEmpty((Collection)cjColumnDefSpecs)) {
            ModelSqlParserUtil.setDefaultValue(cjColumnDefSpecs, tableColumn);
        }
        if (CollectionUtils.isNotEmpty((Collection)cjColumnDefSpecs) && cjColumnDefSpecs.contains("AUTO_INCREMENT")) {
            tableColumn.setAutoIncrement(true);
            if (dataTypeArgs != null) {
                tableColumn.setSize(Integer.valueOf((String)dataTypeArgs.get(0)));
            }
            tableColumn.setNullable(false);
        } else {
            boolean columnNullable = ModelSqlParserUtil.fetchCCJNullable(cjColumnDefSpecs);
            tableColumn.setNullable(columnNullable);
            ModelSqlParserUtil.processSizeScale(columnDefinition, tableColumn);
        }
        indexes.stream().forEach(idx -> {
            String ccjIndexName = idx.getName();
            String ccjIndexType = idx.getType();
            if (StringUtils.isEmpty((CharSequence)ccjIndexName) && ccjIndexType.equals("PRIMARY KEY") && idx.getColumnsNames().contains(ccjColumnName)) {
                tableColumn.setPK(true);
            }
            if (ModelSqlParserUtil.checkColumnUniqueIndex(idx, ccjColumnName)) {
                tableColumn.setUnique(true);
            }
        });
        tableColumn.setRelationTypeEnum(ModelFieldRelationTypeEnum.SIMPLE);
        return tableColumn;
    }

    public static void updateComment(ModelTable actualModelTable, Map<String, Object> commentOfTableAndColumn) {
        List columnCommentDBData;
        List tableCommentData = (List)MapUtils.getObject(commentOfTableAndColumn, (Object)"tableComment", new ArrayList());
        if (CollectionUtils.isNotEmpty((Collection)tableCommentData)) {
            String tableComment = (String)((Map)tableCommentData.get(0)).get("COMMENT$");
            actualModelTable.setComment(tableComment);
        }
        if (CollectionUtils.isNotEmpty((Collection)(columnCommentDBData = (List)MapUtils.getObject(commentOfTableAndColumn, (Object)"columnComment", new ArrayList())))) {
            // empty if block
        }
    }

    public static List<TableIndex> getTableIndexes(List<Index> ccjIndexes, String tableName, String pkName) {
        List<TableIndex> existedTableIndexes = ccjIndexes.stream().map(ccjIndex -> ModelSqlParserDMUtil.convertToTableIndex(ccjIndex, tableName, pkName)).collect(Collectors.toList());
        return existedTableIndexes;
    }

    public static TableIndex convertToTableIndex(Index ccjIndex, String tableName, String pkName) {
        String indexTypeName;
        String indexName = ccjIndex.getName();
        if (IndexTypeEnum.PRIMARY_KEY.getIndexCommandChar().equals(ccjIndex.getType())) {
            indexName = pkName;
        }
        List<String> members = ccjIndex.getColumnsNames().stream().map(member -> DBTableUtil.removeSchemaSymbol(member)).collect(Collectors.toList());
        TableIndex tableIndex = new TableIndex();
        tableIndex.setTableName(tableName);
        tableIndex.setName(indexName);
        tableIndex.setMember(members);
        switch (indexTypeName = ccjIndex.getType()) {
            case "UNIQUE KEY": {
                tableIndex.setType(IndexTypeEnum.UNIQUE_INDEX);
                break;
            }
            case "KEY": {
                tableIndex.setType(IndexTypeEnum.INDEX);
                break;
            }
            case "PRIMARY KEY": {
                tableIndex.setType(IndexTypeEnum.PRIMARY_KEY);
                break;
            }
        }
        return tableIndex;
    }

    public static CreateTable fetchCCJCreateTable(List data) throws JSQLParserException {
        Map rowMap = (Map)data.get(0);
        String createTableSql = (String)rowMap.get("Create Table");
        int ignoreStrIndStart = createTableSql.indexOf("STORAGE(ON");
        createTableSql = createTableSql.substring(0, ignoreStrIndStart - 1);
        createTableSql = createTableSql.replaceAll("IDENTITY\\(1,\\ 1\\)", "AUTO_INCREMENT");
        LinkedList<String> okPartialSql = new LinkedList<String>();
        String primaryKeyPartialSql = "";
        ArrayList indexPartialSqls = new ArrayList();
        String[] createTableArray = createTableSql.split(",");
        for (int createTokenIndex = 0; createTokenIndex < createTableArray.length; ++createTokenIndex) {
            String createRowStr = createTableArray[createTokenIndex];
            if (createRowStr.contains(IndexTypeEnum.PRIMARY_KEY.getIndexCommandChar())) {
                String pkStr;
                int pkInt = createRowStr.indexOf(IndexTypeEnum.PRIMARY_KEY.getIndexCommandChar());
                int pkIntEnd = createRowStr.indexOf("))", pkInt);
                if (pkIntEnd < 0) {
                    pkIntEnd = createRowStr.indexOf(")", pkInt);
                }
                primaryKeyPartialSql = pkStr = createRowStr.substring(pkInt, pkIntEnd + 1);
                okPartialSql.add(primaryKeyPartialSql);
                continue;
            }
            if (createRowStr.contains("CONSTRAINT") && createRowStr.contains(IndexTypeEnum.CONSTRAINT_UNIQUE.getIndexCommandChar() + "(")) continue;
            okPartialSql.add(createRowStr);
        }
        String okCreateTableSql = String.join((CharSequence)",", okPartialSql) + ")";
        log.info("[ModelSqlParserDMUtil.fetchCCJCreateTable] okCreateTableSql:{}", (Object)okCreateTableSql);
        Statement statement = CCJSqlParserUtil.parse((String)okCreateTableSql);
        CreateTable ccjCreateTable = (CreateTable)statement;
        return ccjCreateTable;
    }
}

