/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.lcdp.modeldriven.utils;

import com.digiwin.lcdp.modeldriven.enums.AlterAutoIncrementEnum;
import com.digiwin.lcdp.modeldriven.enums.AlterColumnEnum;
import com.digiwin.lcdp.modeldriven.enums.AlterIndexEnum;
import com.digiwin.lcdp.modeldriven.enums.PublishStatusEnum;
import com.digiwin.lcdp.modeldriven.model.ModelTable;
import com.digiwin.lcdp.modeldriven.model.SqlParam;
import com.digiwin.lcdp.modeldriven.model.TableColumn;
import com.digiwin.lcdp.modeldriven.model.TableIndex;
import com.digiwin.lcdp.modeldriven.utils.ModelSchemaUtil;
import com.digiwin.lcdp.modeldriven.utils.ModelSqlDMGenerator;
import com.digiwin.lcdp.modeldriven.utils.compare.ColumnCompareUtil;
import com.digiwin.lcdp.modeldriven.utils.compare.IndexCompareUtil;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ModelTableDMSqlGenerator {
    private static final Logger log = LoggerFactory.getLogger(ModelTableDMSqlGenerator.class);
    private static final String _CLASSTAG = "[" + ModelTableDMSqlGenerator.class.getSimpleName() + "]";

    public static void updateColumnsSqlParamsWhenNewPublishWithNoApi(String pureTableName, ModelTable draftModelTable, ModelTable actualModelTable, LinkedList<SqlParam> ddlSqlParams, LinkedList<SqlParam> dmlSqlParams) {
        TableIndex addPkTableIndex;
        Map<AlterColumnEnum, List<TableColumn>> alterColumnsMap;
        TableIndex dropPkTableIndex;
        TableColumn dropAutoIncrementTableColumn;
        AtomicReference<PublishStatusEnum> alterStatus = new AtomicReference<PublishStatusEnum>(PublishStatusEnum.UNCHANGED);
        List<TableColumn> draftTableColumns = draftModelTable.getColumns();
        List<TableColumn> actualTableColumns = actualModelTable.getColumns();
        Map<AlterIndexEnum, List<TableIndex>> alterIndexesMap = ModelSqlDMGenerator.getAlterIndexesMapWithActualModelTable(draftModelTable, null, actualModelTable);
        LinkedHashMap<AlterAutoIncrementEnum, TableColumn> changedAutoIncrmtMap = ColumnCompareUtil.getChangeAutoIncrementColumn(draftTableColumns, actualTableColumns);
        LinkedHashMap<AlterIndexEnum, TableIndex> changedPkMap = IndexCompareUtil.getChangePkIndex(draftModelTable, actualModelTable);
        boolean isChangePk = MapUtils.isNotEmpty(changedPkMap);
        boolean isChangeAutoIncrement = MapUtils.isNotEmpty(changedAutoIncrmtMap);
        if (isChangeAutoIncrement && changedAutoIncrmtMap.containsKey((Object)AlterAutoIncrementEnum.DROP) && (dropAutoIncrementTableColumn = changedAutoIncrmtMap.get((Object)AlterAutoIncrementEnum.DROP)) != null) {
            List<SqlParam> dropSqlParams = ModelSqlDMGenerator.getDropAutoIncrementSql(dropAutoIncrementTableColumn, pureTableName);
            ddlSqlParams.addAll(dropSqlParams);
        }
        if (isChangePk && changedPkMap.containsKey((Object)AlterIndexEnum.DROP) && (dropPkTableIndex = changedPkMap.get((Object)AlterIndexEnum.DROP)) != null) {
            List<SqlParam> dropPkSqlParams = ModelSqlDMGenerator.getDropPrimaryKeySql(dropPkTableIndex);
            ddlSqlParams.addAll(dropPkSqlParams);
        }
        if (MapUtils.isNotEmpty(alterColumnsMap = ModelSchemaUtil.getAlterColumnsMapWithoutDrop(draftModelTable, actualModelTable))) {
            alterColumnsMap.forEach((alterColumnEnum, tableColumns) -> {
                if (!CollectionUtils.isEmpty((Collection)tableColumns)) {
                    ModelSqlDMGenerator.updateAlterColumnsInfoOnly(pureTableName, alterColumnEnum, tableColumns, changedAutoIncrmtMap, ddlSqlParams, dmlSqlParams);
                    alterStatus.set(PublishStatusEnum.CHANGED);
                }
            });
        }
        if (MapUtils.isNotEmpty(alterIndexesMap)) {
            alterIndexesMap.forEach((alterIndexEnum, tableColumns) -> {
                if (!CollectionUtils.isEmpty((Collection)tableColumns)) {
                    ModelSqlDMGenerator.getAlterIndexesInfo(pureTableName, alterIndexEnum, tableColumns, ddlSqlParams);
                    alterStatus.set(PublishStatusEnum.CHANGED);
                }
            });
        }
        if (isChangePk && changedPkMap.containsKey((Object)AlterIndexEnum.ADD) && (addPkTableIndex = changedPkMap.get((Object)AlterIndexEnum.ADD)) != null) {
            List<SqlParam> addPkSqlParams = ModelSqlDMGenerator.getAddPrimaryKeyOnly(addPkTableIndex);
            ddlSqlParams.addAll(addPkSqlParams);
        }
        if (isChangeAutoIncrement && changedAutoIncrmtMap.containsKey((Object)AlterAutoIncrementEnum.ADD)) {
            TableColumn addAutoIncrementTableColumn = changedAutoIncrmtMap.get((Object)AlterAutoIncrementEnum.ADD);
            if (addAutoIncrementTableColumn != null) {
                List<SqlParam> addSqlParams = ModelSqlDMGenerator.getAddAutoIncrementSql(addAutoIncrementTableColumn, pureTableName);
                ddlSqlParams.addAll(addSqlParams);
            }
            log.info(_CLASSTAG + "[createCustomizeTableExpress] table({}), isChangeAutoIncrement({}), isChangePk({})", new Object[]{pureTableName, isChangeAutoIncrement, isChangePk});
        }
    }
}

