CREATE TABLE `dw_lcdp_model` (
	`code` VARCHAR(100) NOT NULL COMMENT '模型code' COLLATE 'utf8mb4_bin',
	`description` VARCHAR(255) NOT NULL COMMENT '模型名稱' COLLATE 'utf8mb4_bin',
	`model_type` VARCHAR(10) NOT NULL DEFAULT 'cus' COMMENT '模型类型：std-标准，cus-客制' COLLATE 'utf8mb4_bin',
	`model_schema` LONGTEXT NULL DEFAULT NULL COMMENT '模型数据结构' COLLATE 'utf8mb4_bin',
	`target_tenant_id` VARCHAR(32) NULL DEFAULT NULL COMMENT '目标租户ID' COLLATE 'utf8mb4_bin',
	`app_id` VARCHAR(100) NOT NULL COMMENT '應用ID' COLLATE 'utf8mb4_bin',
	`tenantsid` BIGINT(20) NOT NULL COMMENT '租户SID',
	`create_time` DATETIME NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
	`create_user_sid` BIGINT(20) NULL DEFAULT NULL COMMENT '创建人SID',
	`update_time` DATETIME NULL DEFAULT NULL ON UPDATE CURRENT_TIMESTAMP COMMENT '更新时间',
	`update_user_sid` BIGINT(20) NULL DEFAULT NULL COMMENT '更新人SID',
	PRIMARY KEY (`code`, `tenantsid`, `app_id`) USING BTREE
)
COMMENT='模型設計表'
COLLATE='utf8mb4_bin'
ENGINE=InnoDB
ROW_FORMAT=DYNAMIC
;

INSERT INTO `dw_rdbms_tables` (`table_name`, `table_display_name`, `table_description`, `delete_constraint`, `hint_field`, `insert_default_value`, `update_default_value`) VALUES ('dw_lcdp_model', '模型設計表', '模型設計表', 'N', NULL, NULL, NULL);

INSERT INTO `dw_rdbms_fields` (`TABLE_NAME`, `SEQ`, `FIELD_NAME`, `IS_KEY`, `FIELD_TYPE`, `STATUS_CODE`, `FIELD_DISPLAY_NAME`, `SCALE`, `DEFAULT_VALUE`, `NULLABLE`, `IS_VERSION`, `SIZE`, `IS_AUTO_INCREMENT`) VALUES ('dw_lcdp_model', 1, 'code', 'Y', 'VARCHAR', 'Y', '模型code', '0', NULL, 'N', 'N', '100', 'N');
INSERT INTO `dw_rdbms_fields` (`TABLE_NAME`, `SEQ`, `FIELD_NAME`, `IS_KEY`, `FIELD_TYPE`, `STATUS_CODE`, `FIELD_DISPLAY_NAME`, `SCALE`, `DEFAULT_VALUE`, `NULLABLE`, `IS_VERSION`, `SIZE`, `IS_AUTO_INCREMENT`) VALUES ('dw_lcdp_model', 2, 'description', 'N', 'VARCHAR', 'Y', '模型名称', '0', NULL, 'N', 'N', '255', 'N');
INSERT INTO `dw_rdbms_fields` (`TABLE_NAME`, `SEQ`, `FIELD_NAME`, `IS_KEY`, `FIELD_TYPE`, `STATUS_CODE`, `FIELD_DISPLAY_NAME`, `SCALE`, `DEFAULT_VALUE`, `NULLABLE`, `IS_VERSION`, `SIZE`, `IS_AUTO_INCREMENT`) VALUES ('dw_lcdp_model', 3, 'model_schema', 'N', 'JSON', 'Y', '模型数据结构', '0', NULL, 'Y', 'N', '65535', 'N');
INSERT INTO `dw_rdbms_fields` (`TABLE_NAME`, `SEQ`, `FIELD_NAME`, `IS_KEY`, `FIELD_TYPE`, `STATUS_CODE`, `FIELD_DISPLAY_NAME`, `SCALE`, `DEFAULT_VALUE`, `NULLABLE`, `IS_VERSION`, `SIZE`, `IS_AUTO_INCREMENT`) VALUES ('dw_lcdp_model', 4, 'target_tenant_id', 'N', 'VARCHAR', 'Y', '目标租户ID', '0', NULL, 'N', 'N', '32', 'N');
INSERT INTO `dw_rdbms_fields` (`TABLE_NAME`, `SEQ`, `FIELD_NAME`, `IS_KEY`, `FIELD_TYPE`, `STATUS_CODE`, `FIELD_DISPLAY_NAME`, `SCALE`, `DEFAULT_VALUE`, `NULLABLE`, `IS_VERSION`, `SIZE`, `IS_AUTO_INCREMENT`) VALUES ('dw_lcdp_model', 5, 'app_id', 'Y', 'VARCHAR', 'Y', '应用ID', '0', NULL, 'N', 'N', '100', 'N');
INSERT INTO `dw_rdbms_fields` (`TABLE_NAME`, `SEQ`, `FIELD_NAME`, `IS_KEY`, `FIELD_TYPE`, `STATUS_CODE`, `FIELD_DISPLAY_NAME`, `SCALE`, `DEFAULT_VALUE`, `NULLABLE`, `IS_VERSION`, `SIZE`, `IS_AUTO_INCREMENT`) VALUES ('dw_lcdp_model', 6, 'tenantsid', 'Y', 'BIGINT', 'Y', '租户SID', '0', NULL, 'N', 'N', '20', 'N');
INSERT INTO `dw_rdbms_fields` (`TABLE_NAME`, `SEQ`, `FIELD_NAME`, `IS_KEY`, `FIELD_TYPE`, `STATUS_CODE`, `FIELD_DISPLAY_NAME`, `SCALE`, `DEFAULT_VALUE`, `NULLABLE`, `IS_VERSION`, `SIZE`, `IS_AUTO_INCREMENT`) VALUES ('dw_lcdp_model', 7, 'create_time', 'N', 'DATETIME', 'Y', '创建时间', '0', NULL, 'N', 'N', '19', 'N');
INSERT INTO `dw_rdbms_fields` (`TABLE_NAME`, `SEQ`, `FIELD_NAME`, `IS_KEY`, `FIELD_TYPE`, `STATUS_CODE`, `FIELD_DISPLAY_NAME`, `SCALE`, `DEFAULT_VALUE`, `NULLABLE`, `IS_VERSION`, `SIZE`, `IS_AUTO_INCREMENT`) VALUES ('dw_lcdp_model', 8, 'create_user_sid', 'N', 'BIGINT', 'Y', '创建人SID', '0', NULL, 'N', 'N', '20', 'N');
INSERT INTO `dw_rdbms_fields` (`TABLE_NAME`, `SEQ`, `FIELD_NAME`, `IS_KEY`, `FIELD_TYPE`, `STATUS_CODE`, `FIELD_DISPLAY_NAME`, `SCALE`, `DEFAULT_VALUE`, `NULLABLE`, `IS_VERSION`, `SIZE`, `IS_AUTO_INCREMENT`) VALUES ('dw_lcdp_model', 9, 'update_time', 'N', 'DATETIME', 'Y', '更新时间', '0', NULL, 'Y', 'N', '19', 'N');
INSERT INTO `dw_rdbms_fields` (`TABLE_NAME`, `SEQ`, `FIELD_NAME`, `IS_KEY`, `FIELD_TYPE`, `STATUS_CODE`, `FIELD_DISPLAY_NAME`, `SCALE`, `DEFAULT_VALUE`, `NULLABLE`, `IS_VERSION`, `SIZE`, `IS_AUTO_INCREMENT`) VALUES ('dw_lcdp_model', 10, 'update_user_sid', 'N', 'BIGINT', 'Y', '更新人SID', '0', NULL, 'Y', 'N', '20', 'N');

--
CREATE TABLE `dw_lcdp_model_info` (
	`code` VARCHAR(100) NOT NULL COMMENT '模型code' COLLATE 'utf8mb4_bin',
	`table_name` VARCHAR(128) NOT NULL COMMENT '表名' COLLATE 'utf8mb4_bin',
	`tenant_id` VARCHAR(32) NOT NULL COMMENT '目标租户ID' COLLATE 'utf8mb4_bin',
	`app_id` VARCHAR(100) NOT NULL COMMENT '应用ID' COLLATE 'utf8mb4_bin',
	`tenantsid` BIGINT(20) NOT NULL COMMENT '租户SID',
	`create_time` DATETIME NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
	`create_user_sid` BIGINT(20) NOT NULL COMMENT '创建人SID',
	`update_time` DATETIME NULL DEFAULT NULL ON UPDATE CURRENT_TIMESTAMP COMMENT '更新时间',
	`update_user_sid` BIGINT(20) NULL DEFAULT NULL COMMENT '更新人SID',
	PRIMARY KEY (`code`, `table_name`, `app_id`, `tenantsid`) USING BTREE,
	UNIQUE INDEX `modelinfo_unqidx2` (`code`, `table_name`) USING BTREE
)
COMMENT='模型驅動資訊'
COLLATE='utf8mb4_bin'
ENGINE=InnoDB
ROW_FORMAT=DYNAMIC
;

INSERT INTO `dw_rdbms_tables` (`table_name`, `table_display_name`, `table_description`, `delete_constraint`, `hint_field`, `insert_default_value`, `update_default_value`) VALUES ('dw_lcdp_model_info', '模型驅動資訊', '模型驅動資訊', 'N', NULL, NULL, NULL);

INSERT INTO `dw_rdbms_fields` (`TABLE_NAME`, `SEQ`, `FIELD_NAME`, `IS_KEY`, `FIELD_TYPE`, `STATUS_CODE`, `FIELD_DISPLAY_NAME`, `SCALE`, `DEFAULT_VALUE`, `NULLABLE`, `IS_VERSION`, `SIZE`, `IS_AUTO_INCREMENT`) VALUES ('dw_lcdp_model_info', 1, 'code', 'Y', 'VARCHAR', 'Y', '模型code', '0', NULL, 'N', 'N', '100', 'N');
INSERT INTO `dw_rdbms_fields` (`TABLE_NAME`, `SEQ`, `FIELD_NAME`, `IS_KEY`, `FIELD_TYPE`, `STATUS_CODE`, `FIELD_DISPLAY_NAME`, `SCALE`, `DEFAULT_VALUE`, `NULLABLE`, `IS_VERSION`, `SIZE`, `IS_AUTO_INCREMENT`) VALUES ('dw_lcdp_model_info', 2, 'table_name', 'Y', 'VARCHAR', 'Y', '表名', '0', 'cus', 'N', 'N', '10', 'N');
INSERT INTO `dw_rdbms_fields` (`TABLE_NAME`, `SEQ`, `FIELD_NAME`, `IS_KEY`, `FIELD_TYPE`, `STATUS_CODE`, `FIELD_DISPLAY_NAME`, `SCALE`, `DEFAULT_VALUE`, `NULLABLE`, `IS_VERSION`, `SIZE`, `IS_AUTO_INCREMENT`) VALUES ('dw_lcdp_model_info', 3, 'tenant_id', 'N', 'VARCHAR', 'Y', '目标租户ID', '0', NULL, 'N', 'N', '32', 'N');
INSERT INTO `dw_rdbms_fields` (`TABLE_NAME`, `SEQ`, `FIELD_NAME`, `IS_KEY`, `FIELD_TYPE`, `STATUS_CODE`, `FIELD_DISPLAY_NAME`, `SCALE`, `DEFAULT_VALUE`, `NULLABLE`, `IS_VERSION`, `SIZE`, `IS_AUTO_INCREMENT`) VALUES ('dw_lcdp_model_info', 4, 'app_id', 'Y', 'VARCHAR', 'Y', '应用ID', '0', NULL, 'N', 'N', '100', 'N');
INSERT INTO `dw_rdbms_fields` (`TABLE_NAME`, `SEQ`, `FIELD_NAME`, `IS_KEY`, `FIELD_TYPE`, `STATUS_CODE`, `FIELD_DISPLAY_NAME`, `SCALE`, `DEFAULT_VALUE`, `NULLABLE`, `IS_VERSION`, `SIZE`, `IS_AUTO_INCREMENT`) VALUES ('dw_lcdp_model_info', 5, 'tenantsid', 'Y', 'BIGINT', 'Y', '租户SID', '0', NULL, 'N', 'N', '20', 'N');
INSERT INTO `dw_rdbms_fields` (`TABLE_NAME`, `SEQ`, `FIELD_NAME`, `IS_KEY`, `FIELD_TYPE`, `STATUS_CODE`, `FIELD_DISPLAY_NAME`, `SCALE`, `DEFAULT_VALUE`, `NULLABLE`, `IS_VERSION`, `SIZE`, `IS_AUTO_INCREMENT`) VALUES ('dw_lcdp_model_info', 6, 'create_time', 'N', 'DATETIME', 'Y', '创建时间', '0', NULL, 'N', 'N', '19', 'N');
INSERT INTO `dw_rdbms_fields` (`TABLE_NAME`, `SEQ`, `FIELD_NAME`, `IS_KEY`, `FIELD_TYPE`, `STATUS_CODE`, `FIELD_DISPLAY_NAME`, `SCALE`, `DEFAULT_VALUE`, `NULLABLE`, `IS_VERSION`, `SIZE`, `IS_AUTO_INCREMENT`) VALUES ('dw_lcdp_model_info', 7, 'create_user_sid', 'N', 'BIGINT', 'Y', '创建人SID', '0', NULL, 'N', 'N', '20', 'N');
INSERT INTO `dw_rdbms_fields` (`TABLE_NAME`, `SEQ`, `FIELD_NAME`, `IS_KEY`, `FIELD_TYPE`, `STATUS_CODE`, `FIELD_DISPLAY_NAME`, `SCALE`, `DEFAULT_VALUE`, `NULLABLE`, `IS_VERSION`, `SIZE`, `IS_AUTO_INCREMENT`) VALUES ('dw_lcdp_model_info', 8, 'update_time', 'N', 'DATETIME', 'Y', '更新时间', '0', NULL, 'Y', 'N', '19', 'N');
INSERT INTO `dw_rdbms_fields` (`TABLE_NAME`, `SEQ`, `FIELD_NAME`, `IS_KEY`, `FIELD_TYPE`, `STATUS_CODE`, `FIELD_DISPLAY_NAME`, `SCALE`, `DEFAULT_VALUE`, `NULLABLE`, `IS_VERSION`, `SIZE`, `IS_AUTO_INCREMENT`) VALUES ('dw_lcdp_model_info', 9, 'update_user_sid', 'N', 'BIGINT', 'Y', '更新人SID', '0', NULL, 'Y', 'N', '20', 'N');

-- dw_service_mapping

CREATE TABLE `dw_service_mapping` (
	`mapping_id` BIGINT(20) NOT NULL AUTO_INCREMENT,
	`table_name` VARCHAR(64) NULL DEFAULT NULL COLLATE 'utf8mb4_bin',
	`expose_eai_id` VARCHAR(256) NULL DEFAULT NULL COMMENT '暴露接口前綴' COLLATE 'utf8mb4_bin',
	`expose_callback_eai_id` VARCHAR(256) NULL DEFAULT NULL COMMENT '暴露接口callback前綴' COLLATE 'utf8mb4_bin',
	PRIMARY KEY (`mapping_id`) USING BTREE,
	UNIQUE INDEX `table_name_expose_eai_id` (`table_name`, `expose_eai_id`) USING BTREE
)
COLLATE='utf8mb4_bin'
ENGINE=InnoDB
ROW_FORMAT=DYNAMIC
;

INSERT INTO `dw_rdbms_tables` (`table_name`, `table_display_name`, `table_description`, `delete_constraint`, `hint_field`, `insert_default_value`, `update_default_value`) VALUES ('dw_service_mapping', '服務轉導對應', '服務轉導對應', 'N', NULL, NULL, NULL);

INSERT INTO `dw_rdbms_fields` (`TABLE_NAME`, `SEQ`, `FIELD_NAME`, `IS_KEY`, `FIELD_TYPE`, `STATUS_CODE`, `FIELD_DISPLAY_NAME`, `SCALE`, `DEFAULT_VALUE`, `NULLABLE`, `IS_VERSION`, `SIZE`, `IS_AUTO_INCREMENT`) VALUES ('dw_service_mapping', 1, 'mapping_id', 'Y', 'int', 'N', 'mapping_id', '0', '', 'N', 'N', '20', 'Y');
INSERT INTO `dw_rdbms_fields` (`TABLE_NAME`, `SEQ`, `FIELD_NAME`, `IS_KEY`, `FIELD_TYPE`, `STATUS_CODE`, `FIELD_DISPLAY_NAME`, `SCALE`, `DEFAULT_VALUE`, `NULLABLE`, `IS_VERSION`, `SIZE`, `IS_AUTO_INCREMENT`) VALUES ('dw_service_mapping', 2, 'table_name', 'N', 'varchar', 'N', 'table_name', '0', '', 'N', 'N', '64', 'N');
INSERT INTO `dw_rdbms_fields` (`TABLE_NAME`, `SEQ`, `FIELD_NAME`, `IS_KEY`, `FIELD_TYPE`, `STATUS_CODE`, `FIELD_DISPLAY_NAME`, `SCALE`, `DEFAULT_VALUE`, `NULLABLE`, `IS_VERSION`, `SIZE`, `IS_AUTO_INCREMENT`) VALUES ('dw_service_mapping', 3, 'expose_eai_id', 'Y', 'varchar', 'N', 'expose_eai_id', '0', '', 'N', 'N', '256', 'N');
INSERT INTO `dw_rdbms_fields` (`TABLE_NAME`, `SEQ`, `FIELD_NAME`, `IS_KEY`, `FIELD_TYPE`, `STATUS_CODE`, `FIELD_DISPLAY_NAME`, `SCALE`, `DEFAULT_VALUE`, `NULLABLE`, `IS_VERSION`, `SIZE`, `IS_AUTO_INCREMENT`) VALUES ('dw_service_mapping', 4, 'expose_callback_eai_id', 'N', 'varchar', 'N', 'target_eai_id', '0', '', 'N', 'N', '256', 'N');
