-- CREATE SCHEMA "dpbas";

CREATE TABLE "DW_RDBMS_TABLES"
(
 "TABLE_NAME" VARCHAR(45) NOT NULL,
 "TABLE_DISPLAY_NAME" VARCHAR(45) NULL,
 "TABLE_DESCRIPTION" VARCHAR(200) NULL,
 "DELETE_CONSTRAINT" VARCHAR(1) DEFAULT 'N'
 NOT NULL,
 "HINT_FIELD" VARCHAR(50) NULL,
 "INSERT_DEFAULT_VALUE" VARCHAR(1) NULL,
 "UPDATE_DEFAULT_VALUE" VARCHAR(1) NULL
);

CREATE TABLE "DW_RDBMS_RELATIONS"
(
 "PRIMARY_TABLE_NO" VARCHAR(80) DEFAULT ''
 NOT NULL,
 "REFERENCE_TABLE_NO" VARCHAR(80) DEFAULT ''
 NOT NULL,
 "PRIMARY_TABLE_PK" VARCHAR(45) DEFAULT ''
 NOT NULL,
 "REFERENCE_TABLE_PK" VARCHAR(45) DEFAULT ''
 NOT NULL,
 "TYPE" CHAR(10) NULL
);

CREATE TABLE "DW_RDBMS_FIELDS"
(
 "TABLE_NAME" VARCHAR(80) DEFAULT ''
 NOT NULL,
 "SEQ" INT NOT NULL,
 "FIELD_NAME" VARCHAR(80) DEFAULT ''
 NOT NULL,
 "IS_KEY" VARCHAR(1) DEFAULT 'N'
 NOT NULL,
 "FIELD_TYPE" VARCHAR(20) DEFAULT ''
 NULL,
 "STATUS_CODE" VARCHAR(1) DEFAULT 'Y'
 NOT NULL,
 "FIELD_DISPLAY_NAME" VARCHAR(80) DEFAULT ''
 NULL,
 "SCALE" VARCHAR(20) DEFAULT ''
 NULL,
 "DEFAULT_VALUE" VARCHAR(50) DEFAULT ''
 NULL,
 "NULLABLE" VARCHAR(1) DEFAULT 'N'
 NOT NULL,
 "IS_VERSION" VARCHAR(1) DEFAULT 'N'
 NOT NULL,
 "SIZE" VARCHAR(20) NULL,
 "IS_AUTO_INCREMENT" VARCHAR(1) DEFAULT 'N'
 NOT NULL
);

CREATE TABLE "DW_QUERY_INFO"
(
 "QUERY_ID" VARCHAR(45) NOT NULL,
 "QUERY_TYPE" VARCHAR(45) NULL,
 "SQL_STATEMENT" VARCHAR(450) NULL,
 "PUBLISH" VARCHAR(45) NULL,
 "OWNER" VARCHAR(45) NULL
);

CREATE TABLE "DW_PLATFORM_INFO"
(
 "VERSION" VARCHAR(45) NULL,
 "ISTENANT" VARCHAR(10) NULL,
 "VERSIONDATE" VARCHAR(10) NULL,
 "UPDATEDATE" VARCHAR(10) NULL
);

CREATE TABLE "DW_MYHOME_PARAMETER"
(
 "TENANTSID" BIGINT NOT NULL,
 "LEVEL" VARCHAR(255) NOT NULL,
 "USERID" VARCHAR(100) NOT NULL,
 "NAME" VARCHAR(200) NOT NULL,
 "VALUE" VARCHAR(200) NULL
);

CREATE TABLE "DW_MYHOME"
(
 "TENANTSID" BIGINT NOT NULL,
 "LEVEL" VARCHAR(255) NOT NULL,
 "USERID" VARCHAR(40) NOT NULL,
 "VERSION" INT DEFAULT 1
 NOT NULL,
 "TYPE" VARCHAR(20) NULL,
 "PATH" VARCHAR(2000) NULL
);

CREATE TABLE "DW_MENU_PARAMETER"
(
 "MENU_ID" VARCHAR(100) NOT NULL,
 "NAME" VARCHAR(200) NOT NULL,
 "VALUE" VARCHAR(200) NULL
);

CREATE TABLE "DW_MENU_LANGUAGE"
(
 "MENU_ID" VARCHAR(100) NOT NULL,
 "LANGUAGE" VARCHAR(50) NOT NULL,
 "NAME" VARCHAR(200) NULL
);

CREATE TABLE "DW_MENU"
(
 "ID" VARCHAR(100) NOT NULL,
 "TYPE" VARCHAR(50) NOT NULL,
 "PARENT_ID" VARCHAR(100) NULL,
 "CODE" VARCHAR(200) NULL,
 "SEQUENCE" INT DEFAULT 1
 NOT NULL,
 "ICON_CLASS" VARCHAR(200) NULL,
 "DEFAULT_EXPAND" BIT DEFAULT '0'
 NULL,
 "URL" VARCHAR(2000) NULL,
 "OPEN_MODE" VARCHAR(50) NULL,
 "VERSION" INT DEFAULT 1
 NOT NULL
);

CREATE TABLE "DW_LOG_OPERATION_SQL"
(
 "LOG_ID" VARCHAR(50) NOT NULL,
 "OPERATION_LOG_ID" VARCHAR(50) NULL,
 "LOG_TYPE" TINYINT DEFAULT 1
 NULL,
 "CMD_TABLE" VARCHAR(100) NULL,
 "CMD_STATEMENT" CLOB NULL,
 "CMD_PARAMETERS" CLOB NULL,
 "CMD_SEQ" INT NULL,
 "CREATE_TIME" TIMESTAMP(0) DEFAULT current_timestamp()
 NULL,
 "TENANTSID" BIGINT NOT NULL
);

CREATE TABLE "DW_LOG_OPERATION_ERROR"
(
 "LOG_ID" VARCHAR(50) NOT NULL,
 "OPERATE_NO" VARCHAR(50) NULL,
 "OPERATE_TYPE" VARCHAR(20) NULL,
 "OPERATE_DESC" VARCHAR(50) NULL,
 "ERROR_TYPE" VARCHAR(100) NULL,
 "ERROR_MESSAGE" VARCHAR(2000) NULL,
 "MENU" VARCHAR(50) NULL,
 "MODULE" VARCHAR(50) NULL,
 "URL" VARCHAR(256) NULL,
 "INPUT_VALUE" VARCHAR(5000) NULL,
 "CLIENT_IP" VARCHAR(50) NULL,
 "TIME_CONSUME" BIGINT NULL,
 "CREATE_NAME" VARCHAR(50) NULL,
 "CREATE_TIME" TIMESTAMP(0) DEFAULT current_timestamp()
 NULL,
 "UPDATE_NAME" VARCHAR(50) NULL,
 "UPDATE_TIME" TIMESTAMP(0) NULL,
 "TRACEID" VARCHAR(50) NULL,
 "PROG_IMPL" VARCHAR(200) NULL,
 "TENANTSID" BIGINT NOT NULL,
  CLUSTER PRIMARY KEY("LOG_ID","TENANTSID") ENABLE
);

CREATE TABLE "DW_LOG_OPERATION"
(
 "LOG_ID" VARCHAR(50) NOT NULL,
 "OPERATE_NO" VARCHAR(50) NULL,
 "OPERATE_TYPE" VARCHAR(20) NULL,
 "OPERATE_DESC" VARCHAR(50) NULL,
 "MENU" VARCHAR(50) NULL,
 "MODULE" VARCHAR(50) NULL,
 "URL" VARCHAR(256) NULL,
 "INPUT_VALUE" TEXT NULL,
 "RETURN_VALUE" TEXT NULL,
 "CLIENT_IP" VARCHAR(50) NULL,
 "TIME_CONSUME" BIGINT NULL,
 "STATUS" TINYINT NULL,
 "REMARK" TEXT NULL,
 "CREATE_NAME" VARCHAR(50) NULL,
 "CREATE_TIME" TIMESTAMP(0) DEFAULT current_timestamp()
 NULL,
 "UPDATE_NAME" VARCHAR(50) NULL,
 "UPDATE_TIME" TIMESTAMP(0) NULL,
 "TRACEID" VARCHAR(50) NULL,
 "TENANTSID" BIGINT NOT NULL
);

CREATE TABLE "DW_CUSTOM_COLUMN"
(
 "TENANTSID" BIGINT NOT NULL,
 "TABLE_ID" VARCHAR(50) NOT NULL,
 "USERID" VARCHAR(50) DEFAULT ''
 NOT NULL,
 "CONFIG" TEXT NULL
);

CREATE TABLE "DW_APP_UPDATE"
(
 "APP_CODE" VARCHAR(20) NOT NULL,
 "VERSION" VARCHAR(20) NOT NULL,
 "ALLOW_UPD_VERSION" VARCHAR(2000) NOT NULL,
 "ALLOW_UPD_EXPR" VARCHAR(20) NOT NULL
);

CREATE TABLE "DW_APP_RELEASE"
(
 "APP_CODE" VARCHAR(20) NOT NULL,
 "VERSION" VARCHAR(20) NOT NULL,
 "FILE_SEQ" INT NOT NULL,
 "FILE_ID" VARCHAR(200) NOT NULL,
 "PUBLISHED" VARCHAR(1) NOT NULL,
 "FILE_NAME" VARCHAR(200) NOT NULL
);

CREATE TABLE "DW_APP_PROD"
(
 "APP_CODE" VARCHAR(20) NOT NULL,
 "DESCRIPTION" VARCHAR(200) NOT NULL
);

INSERT INTO "DW_PLATFORM_INFO"("VERSION","ISTENANT","VERSIONDATE","UPDATEDATE") VALUES('5.2.0.5','Y','2023-03-15','2023-05-05');

INSERT INTO "DW_RDBMS_FIELDS"("TABLE_NAME","SEQ","FIELD_NAME","IS_KEY","FIELD_TYPE","STATUS_CODE","FIELD_DISPLAY_NAME","SCALE","DEFAULT_VALUE","NULLABLE","IS_VERSION","SIZE","IS_AUTO_INCREMENT") VALUES('dw_app_update',4,'allow_upd_expr','N','varchar','Y','allow_upd_expr','0','','N','N','20','N');
INSERT INTO "DW_RDBMS_FIELDS"("TABLE_NAME","SEQ","FIELD_NAME","IS_KEY","FIELD_TYPE","STATUS_CODE","FIELD_DISPLAY_NAME","SCALE","DEFAULT_VALUE","NULLABLE","IS_VERSION","SIZE","IS_AUTO_INCREMENT") VALUES('dw_app_update',3,'allow_upd_version','N','varchar','Y','allow_upd_version','0','','N','N','2000','N');
INSERT INTO "DW_RDBMS_FIELDS"("TABLE_NAME","SEQ","FIELD_NAME","IS_KEY","FIELD_TYPE","STATUS_CODE","FIELD_DISPLAY_NAME","SCALE","DEFAULT_VALUE","NULLABLE","IS_VERSION","SIZE","IS_AUTO_INCREMENT") VALUES('dw_app_prod',1,'app_code','Y','varchar','Y','app_code','0','','N','N','20','N');
INSERT INTO "DW_RDBMS_FIELDS"("TABLE_NAME","SEQ","FIELD_NAME","IS_KEY","FIELD_TYPE","STATUS_CODE","FIELD_DISPLAY_NAME","SCALE","DEFAULT_VALUE","NULLABLE","IS_VERSION","SIZE","IS_AUTO_INCREMENT") VALUES('dw_app_release',1,'app_code','Y','varchar','Y','app_code','0','','N','N','20','N');
INSERT INTO "DW_RDBMS_FIELDS"("TABLE_NAME","SEQ","FIELD_NAME","IS_KEY","FIELD_TYPE","STATUS_CODE","FIELD_DISPLAY_NAME","SCALE","DEFAULT_VALUE","NULLABLE","IS_VERSION","SIZE","IS_AUTO_INCREMENT") VALUES('dw_app_update',1,'app_code','Y','varchar','Y','app_code','0','','N','N','20','N');
INSERT INTO "DW_RDBMS_FIELDS"("TABLE_NAME","SEQ","FIELD_NAME","IS_KEY","FIELD_TYPE","STATUS_CODE","FIELD_DISPLAY_NAME","SCALE","DEFAULT_VALUE","NULLABLE","IS_VERSION","SIZE","IS_AUTO_INCREMENT") VALUES('dw_schedule_time',6,'assign_time','N','varchar','Y','assign_time','0','','Y','N','255','N');
INSERT INTO "DW_RDBMS_FIELDS"("TABLE_NAME","SEQ","FIELD_NAME","IS_KEY","FIELD_TYPE","STATUS_CODE","FIELD_DISPLAY_NAME","SCALE","DEFAULT_VALUE","NULLABLE","IS_VERSION","SIZE","IS_AUTO_INCREMENT") VALUES('dw_schedule_time',26,'byday','N','varchar','Y','byday','0','','Y','N','5','N');
INSERT INTO "DW_RDBMS_FIELDS"("TABLE_NAME","SEQ","FIELD_NAME","IS_KEY","FIELD_TYPE","STATUS_CODE","FIELD_DISPLAY_NAME","SCALE","DEFAULT_VALUE","NULLABLE","IS_VERSION","SIZE","IS_AUTO_INCREMENT") VALUES('dw_schedule_time',28,'bymonthday','N','INT','Y','bymonthday','0','','Y','N','255','N');
INSERT INTO "DW_RDBMS_FIELDS"("TABLE_NAME","SEQ","FIELD_NAME","IS_KEY","FIELD_TYPE","STATUS_CODE","FIELD_DISPLAY_NAME","SCALE","DEFAULT_VALUE","NULLABLE","IS_VERSION","SIZE","IS_AUTO_INCREMENT") VALUES('dw_schedule_time',29,'byweeklyday','N','varchar','Y','byweeklyday','0','','Y','N','255','N');
INSERT INTO "DW_RDBMS_FIELDS"("TABLE_NAME","SEQ","FIELD_NAME","IS_KEY","FIELD_TYPE","STATUS_CODE","FIELD_DISPLAY_NAME","SCALE","DEFAULT_VALUE","NULLABLE","IS_VERSION","SIZE","IS_AUTO_INCREMENT") VALUES('dw_log_operation',7,'client_ip','N','varchar','N','client_ip','0','','N','N','50','N');
INSERT INTO "DW_RDBMS_FIELDS"("TABLE_NAME","SEQ","FIELD_NAME","IS_KEY","FIELD_TYPE","STATUS_CODE","FIELD_DISPLAY_NAME","SCALE","DEFAULT_VALUE","NULLABLE","IS_VERSION","SIZE","IS_AUTO_INCREMENT") VALUES('dw_log_operation_error',10,'client_ip','N','varchar','N','client_ip','0','','N','N','50','N');
INSERT INTO "DW_RDBMS_FIELDS"("TABLE_NAME","SEQ","FIELD_NAME","IS_KEY","FIELD_TYPE","STATUS_CODE","FIELD_DISPLAY_NAME","SCALE","DEFAULT_VALUE","NULLABLE","IS_VERSION","SIZE","IS_AUTO_INCREMENT") VALUES('dw_log_operation_sql',6,'cmd_parameters','N','text','N','cmd_parameters','0','','Y','N','1000','N');
INSERT INTO "DW_RDBMS_FIELDS"("TABLE_NAME","SEQ","FIELD_NAME","IS_KEY","FIELD_TYPE","STATUS_CODE","FIELD_DISPLAY_NAME","SCALE","DEFAULT_VALUE","NULLABLE","IS_VERSION","SIZE","IS_AUTO_INCREMENT") VALUES('dw_log_operation_sql',7,'cmd_seq','N','INT','N','cmd_seq','0','','Y','N','11','N');
INSERT INTO "DW_RDBMS_FIELDS"("TABLE_NAME","SEQ","FIELD_NAME","IS_KEY","FIELD_TYPE","STATUS_CODE","FIELD_DISPLAY_NAME","SCALE","DEFAULT_VALUE","NULLABLE","IS_VERSION","SIZE","IS_AUTO_INCREMENT") VALUES('dw_log_operation_sql',5,'cmd_statement','N','text','N','cmd_statement','0','','Y','N','1000','N');
INSERT INTO "DW_RDBMS_FIELDS"("TABLE_NAME","SEQ","FIELD_NAME","IS_KEY","FIELD_TYPE","STATUS_CODE","FIELD_DISPLAY_NAME","SCALE","DEFAULT_VALUE","NULLABLE","IS_VERSION","SIZE","IS_AUTO_INCREMENT") VALUES('dw_log_operation_sql',4,'cmd_table','N','varchar','N','cmd_table','0','','Y','N','50','N');
INSERT INTO "DW_RDBMS_FIELDS"("TABLE_NAME","SEQ","FIELD_NAME","IS_KEY","FIELD_TYPE","STATUS_CODE","FIELD_DISPLAY_NAME","SCALE","DEFAULT_VALUE","NULLABLE","IS_VERSION","SIZE","IS_AUTO_INCREMENT") VALUES('dw_menu',4,'code','N','varchar','Y','code','0','','Y','N','200','N');
INSERT INTO "DW_RDBMS_FIELDS"("TABLE_NAME","SEQ","FIELD_NAME","IS_KEY","FIELD_TYPE","STATUS_CODE","FIELD_DISPLAY_NAME","SCALE","DEFAULT_VALUE","NULLABLE","IS_VERSION","SIZE","IS_AUTO_INCREMENT") VALUES('dw_custom_column',4,'config','N','varchar','Y','config','0','','Y','N','500','N');
INSERT INTO "DW_RDBMS_FIELDS"("TABLE_NAME","SEQ","FIELD_NAME","IS_KEY","FIELD_TYPE","STATUS_CODE","FIELD_DISPLAY_NAME","SCALE","DEFAULT_VALUE","NULLABLE","IS_VERSION","SIZE","IS_AUTO_INCREMENT") VALUES('dw_log_operation',13,'create_name','N','varchar','N','create_name','0','','N','N','50','N');
INSERT INTO "DW_RDBMS_FIELDS"("TABLE_NAME","SEQ","FIELD_NAME","IS_KEY","FIELD_TYPE","STATUS_CODE","FIELD_DISPLAY_NAME","SCALE","DEFAULT_VALUE","NULLABLE","IS_VERSION","SIZE","IS_AUTO_INCREMENT") VALUES('dw_log_operation_error',16,'create_name','N','varchar','N','create_name','0','','N','N','50','N');
INSERT INTO "DW_RDBMS_FIELDS"("TABLE_NAME","SEQ","FIELD_NAME","IS_KEY","FIELD_TYPE","STATUS_CODE","FIELD_DISPLAY_NAME","SCALE","DEFAULT_VALUE","NULLABLE","IS_VERSION","SIZE","IS_AUTO_INCREMENT") VALUES('dw_log_operation_sql',8,'create_name','N','varchar','N','create_name','0','','Y','N','50','N');
INSERT INTO "DW_RDBMS_FIELDS"("TABLE_NAME","SEQ","FIELD_NAME","IS_KEY","FIELD_TYPE","STATUS_CODE","FIELD_DISPLAY_NAME","SCALE","DEFAULT_VALUE","NULLABLE","IS_VERSION","SIZE","IS_AUTO_INCREMENT") VALUES('dw_log_operation',15,'create_time','N','datetime','N','create_time','0','','N','N',null,'N');
INSERT INTO "DW_RDBMS_FIELDS"("TABLE_NAME","SEQ","FIELD_NAME","IS_KEY","FIELD_TYPE","STATUS_CODE","FIELD_DISPLAY_NAME","SCALE","DEFAULT_VALUE","NULLABLE","IS_VERSION","SIZE","IS_AUTO_INCREMENT") VALUES('dw_log_operation_error',15,'create_time','N','datetime','N','create_time','0','','N','N',null,'N');
INSERT INTO "DW_RDBMS_FIELDS"("TABLE_NAME","SEQ","FIELD_NAME","IS_KEY","FIELD_TYPE","STATUS_CODE","FIELD_DISPLAY_NAME","SCALE","DEFAULT_VALUE","NULLABLE","IS_VERSION","SIZE","IS_AUTO_INCREMENT") VALUES('dw_theme_filelog',2,'create_time','N','timestamp','Y','create_time','0','','N','N','0','N');
INSERT INTO "DW_RDBMS_FIELDS"("TABLE_NAME","SEQ","FIELD_NAME","IS_KEY","FIELD_TYPE","STATUS_CODE","FIELD_DISPLAY_NAME","SCALE","DEFAULT_VALUE","NULLABLE","IS_VERSION","SIZE","IS_AUTO_INCREMENT") VALUES('dw_schedule_time',24,'daily','N','INT','Y','daily','0','','Y','N','10','N');
INSERT INTO "DW_RDBMS_FIELDS"("TABLE_NAME","SEQ","FIELD_NAME","IS_KEY","FIELD_TYPE","STATUS_CODE","FIELD_DISPLAY_NAME","SCALE","DEFAULT_VALUE","NULLABLE","IS_VERSION","SIZE","IS_AUTO_INCREMENT") VALUES('dw_schedule_time',5,'day_of_month','N','varchar','Y','day_of_month','0','','Y','N','255','N');
INSERT INTO "DW_RDBMS_FIELDS"("TABLE_NAME","SEQ","FIELD_NAME","IS_KEY","FIELD_TYPE","STATUS_CODE","FIELD_DISPLAY_NAME","SCALE","DEFAULT_VALUE","NULLABLE","IS_VERSION","SIZE","IS_AUTO_INCREMENT") VALUES('dw_schedule_time',13,'day_radio','N','varchar','Y','day_radio','0','','Y','N','1','N');
INSERT INTO "DW_RDBMS_FIELDS"("TABLE_NAME","SEQ","FIELD_NAME","IS_KEY","FIELD_TYPE","STATUS_CODE","FIELD_DISPLAY_NAME","SCALE","DEFAULT_VALUE","NULLABLE","IS_VERSION","SIZE","IS_AUTO_INCREMENT") VALUES('dw_menu',7,'default_expand','N','number','Y','default_expand','0','0','Y','N','1','N');
INSERT INTO "DW_RDBMS_FIELDS"("TABLE_NAME","SEQ","FIELD_NAME","IS_KEY","FIELD_TYPE","STATUS_CODE","FIELD_DISPLAY_NAME","SCALE","DEFAULT_VALUE","NULLABLE","IS_VERSION","SIZE","IS_AUTO_INCREMENT") VALUES('dw_app_prod',2,'description','N','varchar','Y','description','0','','N','N','200','N');
INSERT INTO "DW_RDBMS_FIELDS"("TABLE_NAME","SEQ","FIELD_NAME","IS_KEY","FIELD_TYPE","STATUS_CODE","FIELD_DISPLAY_NAME","SCALE","DEFAULT_VALUE","NULLABLE","IS_VERSION","SIZE","IS_AUTO_INCREMENT") VALUES('dw_schedule',6,'description','N','varchar','Y','description','0','','Y','N','100','N');
INSERT INTO "DW_RDBMS_FIELDS"("TABLE_NAME","SEQ","FIELD_NAME","IS_KEY","FIELD_TYPE","STATUS_CODE","FIELD_DISPLAY_NAME","SCALE","DEFAULT_VALUE","NULLABLE","IS_VERSION","SIZE","IS_AUTO_INCREMENT") VALUES('dw_schedule',7,'effective_time','N','datetime','Y','effective_time','0','','Y','N','20','N');
INSERT INTO "DW_RDBMS_FIELDS"("TABLE_NAME","SEQ","FIELD_NAME","IS_KEY","FIELD_TYPE","STATUS_CODE","FIELD_DISPLAY_NAME","SCALE","DEFAULT_VALUE","NULLABLE","IS_VERSION","SIZE","IS_AUTO_INCREMENT") VALUES('dw_schedule',5,'enable_status','N','varchar','Y','enable_status','0','','Y','N','1','N');
INSERT INTO "DW_RDBMS_FIELDS"("TABLE_NAME","SEQ","FIELD_NAME","IS_KEY","FIELD_TYPE","STATUS_CODE","FIELD_DISPLAY_NAME","SCALE","DEFAULT_VALUE","NULLABLE","IS_VERSION","SIZE","IS_AUTO_INCREMENT") VALUES('dw_schedule_record',8,'end_time','N','datetime','Y','end_time','0','','Y','N','20','N');
INSERT INTO "DW_RDBMS_FIELDS"("TABLE_NAME","SEQ","FIELD_NAME","IS_KEY","FIELD_TYPE","STATUS_CODE","FIELD_DISPLAY_NAME","SCALE","DEFAULT_VALUE","NULLABLE","IS_VERSION","SIZE","IS_AUTO_INCREMENT") VALUES('dw_schedule_time',21,'end_time','N','datetime','Y','end_time','0','','Y','N','20','N');
INSERT INTO "DW_RDBMS_FIELDS"("TABLE_NAME","SEQ","FIELD_NAME","IS_KEY","FIELD_TYPE","STATUS_CODE","FIELD_DISPLAY_NAME","SCALE","DEFAULT_VALUE","NULLABLE","IS_VERSION","SIZE","IS_AUTO_INCREMENT") VALUES('dw_log_operation_error',6,'error_message','N','varchar','N','error_message','0','','N','N','2000','N');
INSERT INTO "DW_RDBMS_FIELDS"("TABLE_NAME","SEQ","FIELD_NAME","IS_KEY","FIELD_TYPE","STATUS_CODE","FIELD_DISPLAY_NAME","SCALE","DEFAULT_VALUE","NULLABLE","IS_VERSION","SIZE","IS_AUTO_INCREMENT") VALUES('dw_log_operation_error',5,'error_type','N','varchar','N','error_type','0','','N','N','20','N');
INSERT INTO "DW_RDBMS_FIELDS"("TABLE_NAME","SEQ","FIELD_NAME","IS_KEY","FIELD_TYPE","STATUS_CODE","FIELD_DISPLAY_NAME","SCALE","DEFAULT_VALUE","NULLABLE","IS_VERSION","SIZE","IS_AUTO_INCREMENT") VALUES('dw_schedule_time',31,'exclude_date','N','varchar','Y','exclude_date','0','','Y','N','255','N');
INSERT INTO "DW_RDBMS_FIELDS"("TABLE_NAME","SEQ","FIELD_NAME","IS_KEY","FIELD_TYPE","STATUS_CODE","FIELD_DISPLAY_NAME","SCALE","DEFAULT_VALUE","NULLABLE","IS_VERSION","SIZE","IS_AUTO_INCREMENT") VALUES('dw_schedule_time',32,'exclude_time','N','varchar','Y','exclude_time','0','','Y','N','255','N');
INSERT INTO "DW_RDBMS_FIELDS"("TABLE_NAME","SEQ","FIELD_NAME","IS_KEY","FIELD_TYPE","STATUS_CODE","FIELD_DISPLAY_NAME","SCALE","DEFAULT_VALUE","NULLABLE","IS_VERSION","SIZE","IS_AUTO_INCREMENT") VALUES('dw_schedule_record',1,'execute_id','Y','varchar','Y','execute_id','0','','N','N','128','N');
INSERT INTO "DW_RDBMS_FIELDS"("TABLE_NAME","SEQ","FIELD_NAME","IS_KEY","FIELD_TYPE","STATUS_CODE","FIELD_DISPLAY_NAME","SCALE","DEFAULT_VALUE","NULLABLE","IS_VERSION","SIZE","IS_AUTO_INCREMENT") VALUES('dw_schedule_record',4,'execute_status','N','varchar','Y','execute_status','0','','Y','N','10','N');
INSERT INTO "DW_RDBMS_FIELDS"("TABLE_NAME","SEQ","FIELD_NAME","IS_KEY","FIELD_TYPE","STATUS_CODE","FIELD_DISPLAY_NAME","SCALE","DEFAULT_VALUE","NULLABLE","IS_VERSION","SIZE","IS_AUTO_INCREMENT") VALUES('dw_schedule_record',14,'executor','N','varchar','Y','executor','0','','Y','N','50','N');
INSERT INTO "DW_RDBMS_FIELDS"("TABLE_NAME","SEQ","FIELD_NAME","IS_KEY","FIELD_TYPE","STATUS_CODE","FIELD_DISPLAY_NAME","SCALE","DEFAULT_VALUE","NULLABLE","IS_VERSION","SIZE","IS_AUTO_INCREMENT") VALUES('dw_schedule',8,'expire_time','N','datetime','Y','expire_time','0','','Y','N','20','N');
INSERT INTO "DW_RDBMS_FIELDS"("TABLE_NAME","SEQ","FIELD_NAME","IS_KEY","FIELD_TYPE","STATUS_CODE","FIELD_DISPLAY_NAME","SCALE","DEFAULT_VALUE","NULLABLE","IS_VERSION","SIZE","IS_AUTO_INCREMENT") VALUES('dw_app_release',4,'file_id','N','varchar','Y','file_id','0','','N','N','200','N');
INSERT INTO "DW_RDBMS_FIELDS"("TABLE_NAME","SEQ","FIELD_NAME","IS_KEY","FIELD_TYPE","STATUS_CODE","FIELD_DISPLAY_NAME","SCALE","DEFAULT_VALUE","NULLABLE","IS_VERSION","SIZE","IS_AUTO_INCREMENT") VALUES('dw_app_release',6,'file_name','N','varchar','Y','file_name','0','','N','N','200','N');
INSERT INTO "DW_RDBMS_FIELDS"("TABLE_NAME","SEQ","FIELD_NAME","IS_KEY","FIELD_TYPE","STATUS_CODE","FIELD_DISPLAY_NAME","SCALE","DEFAULT_VALUE","NULLABLE","IS_VERSION","SIZE","IS_AUTO_INCREMENT") VALUES('dw_app_release',3,'file_seq','Y','number','Y','file_seq','0','','N','N','10','N');
INSERT INTO "DW_RDBMS_FIELDS"("TABLE_NAME","SEQ","FIELD_NAME","IS_KEY","FIELD_TYPE","STATUS_CODE","FIELD_DISPLAY_NAME","SCALE","DEFAULT_VALUE","NULLABLE","IS_VERSION","SIZE","IS_AUTO_INCREMENT") VALUES('dw_theme_filelog',1,'fileid','Y','varchar','Y','fileid','0','','N','N','50','N');
INSERT INTO "DW_RDBMS_FIELDS"("TABLE_NAME","SEQ","FIELD_NAME","IS_KEY","FIELD_TYPE","STATUS_CODE","FIELD_DISPLAY_NAME","SCALE","DEFAULT_VALUE","NULLABLE","IS_VERSION","SIZE","IS_AUTO_INCREMENT") VALUES('dw_schedule_time',17,'frequency','N','varchar','Y','frequency','0','','Y','N','10','N');
INSERT INTO "DW_RDBMS_FIELDS"("TABLE_NAME","SEQ","FIELD_NAME","IS_KEY","FIELD_TYPE","STATUS_CODE","FIELD_DISPLAY_NAME","SCALE","DEFAULT_VALUE","NULLABLE","IS_VERSION","SIZE","IS_AUTO_INCREMENT") VALUES('dw_schedule_time',8,'holiday','N','varchar','Y','holiday','0','','Y','N','255','N');
INSERT INTO "DW_RDBMS_FIELDS"("TABLE_NAME","SEQ","FIELD_NAME","IS_KEY","FIELD_TYPE","STATUS_CODE","FIELD_DISPLAY_NAME","SCALE","DEFAULT_VALUE","NULLABLE","IS_VERSION","SIZE","IS_AUTO_INCREMENT") VALUES('dw_schedule_time',23,'hourly','N','INT','Y','hourly','0','','Y','N','10','N');
INSERT INTO "DW_RDBMS_FIELDS"("TABLE_NAME","SEQ","FIELD_NAME","IS_KEY","FIELD_TYPE","STATUS_CODE","FIELD_DISPLAY_NAME","SCALE","DEFAULT_VALUE","NULLABLE","IS_VERSION","SIZE","IS_AUTO_INCREMENT") VALUES('dw_menu',6,'icon_class','N','varchar','Y','icon_class','0','','Y','N','200','N');
INSERT INTO "DW_RDBMS_FIELDS"("TABLE_NAME","SEQ","FIELD_NAME","IS_KEY","FIELD_TYPE","STATUS_CODE","FIELD_DISPLAY_NAME","SCALE","DEFAULT_VALUE","NULLABLE","IS_VERSION","SIZE","IS_AUTO_INCREMENT") VALUES('dw_menu',1,'id','Y','varchar','Y','id','0','','N','N','100','N');
INSERT INTO "DW_RDBMS_FIELDS"("TABLE_NAME","SEQ","FIELD_NAME","IS_KEY","FIELD_TYPE","STATUS_CODE","FIELD_DISPLAY_NAME","SCALE","DEFAULT_VALUE","NULLABLE","IS_VERSION","SIZE","IS_AUTO_INCREMENT") VALUES('dw_schedule_contact',1,'id','Y','number','Y','id','0','','N','N','10','N');
INSERT INTO "DW_RDBMS_FIELDS"("TABLE_NAME","SEQ","FIELD_NAME","IS_KEY","FIELD_TYPE","STATUS_CODE","FIELD_DISPLAY_NAME","SCALE","DEFAULT_VALUE","NULLABLE","IS_VERSION","SIZE","IS_AUTO_INCREMENT") VALUES('dw_log_operation',9,'input_value','N','text','N','input_value','0','','N','N','4000','N');
INSERT INTO "DW_RDBMS_FIELDS"("TABLE_NAME","SEQ","FIELD_NAME","IS_KEY","FIELD_TYPE","STATUS_CODE","FIELD_DISPLAY_NAME","SCALE","DEFAULT_VALUE","NULLABLE","IS_VERSION","SIZE","IS_AUTO_INCREMENT") VALUES('dw_log_operation_error',12,'input_value','N','text','N','input_value','0','','N','N','4000','N');
INSERT INTO "DW_RDBMS_FIELDS"("TABLE_NAME","SEQ","FIELD_NAME","IS_KEY","FIELD_TYPE","STATUS_CODE","FIELD_DISPLAY_NAME","SCALE","DEFAULT_VALUE","NULLABLE","IS_VERSION","SIZE","IS_AUTO_INCREMENT") VALUES('dw_schedule_time',12,'is_allow_concurrent','N','varchar','Y','is_allow_concurrent','0','','Y','N','1','N');
INSERT INTO "DW_RDBMS_FIELDS"("TABLE_NAME","SEQ","FIELD_NAME","IS_KEY","FIELD_TYPE","STATUS_CODE","FIELD_DISPLAY_NAME","SCALE","DEFAULT_VALUE","NULLABLE","IS_VERSION","SIZE","IS_AUTO_INCREMENT") VALUES('dw_schedule_record',12,'is_misfire','N','varchar','Y','is_misfire','0','N','N','N','1','N');
INSERT INTO "DW_RDBMS_FIELDS"("TABLE_NAME","SEQ","FIELD_NAME","IS_KEY","FIELD_TYPE","STATUS_CODE","FIELD_DISPLAY_NAME","SCALE","DEFAULT_VALUE","NULLABLE","IS_VERSION","SIZE","IS_AUTO_INCREMENT") VALUES('dw_schedule_time',34,'is_retry','N','varchar','Y','is_retry','0','','N','N','1','N');
INSERT INTO "DW_RDBMS_FIELDS"("TABLE_NAME","SEQ","FIELD_NAME","IS_KEY","FIELD_TYPE","STATUS_CODE","FIELD_DISPLAY_NAME","SCALE","DEFAULT_VALUE","NULLABLE","IS_VERSION","SIZE","IS_AUTO_INCREMENT") VALUES('dw_schedule',3,'job_name','N','varchar','Y','job_name','0','','Y','N','50','N');
INSERT INTO "DW_RDBMS_FIELDS"("TABLE_NAME","SEQ","FIELD_NAME","IS_KEY","FIELD_TYPE","STATUS_CODE","FIELD_DISPLAY_NAME","SCALE","DEFAULT_VALUE","NULLABLE","IS_VERSION","SIZE","IS_AUTO_INCREMENT") VALUES('dw_schedule_record',3,'job_name','N','varchar','Y','job_name','0','','N','N','50','N');
INSERT INTO "DW_RDBMS_FIELDS"("TABLE_NAME","SEQ","FIELD_NAME","IS_KEY","FIELD_TYPE","STATUS_CODE","FIELD_DISPLAY_NAME","SCALE","DEFAULT_VALUE","NULLABLE","IS_VERSION","SIZE","IS_AUTO_INCREMENT") VALUES('dw_menu_language',2,'language','Y','varchar','Y','language','0','','N','N','50','N');
INSERT INTO "DW_RDBMS_FIELDS"("TABLE_NAME","SEQ","FIELD_NAME","IS_KEY","FIELD_TYPE","STATUS_CODE","FIELD_DISPLAY_NAME","SCALE","DEFAULT_VALUE","NULLABLE","IS_VERSION","SIZE","IS_AUTO_INCREMENT") VALUES('dw_schedule',13,'last_period_time','N','number','Y','last_period_time','0','','Y','N','10','N');
INSERT INTO "DW_RDBMS_FIELDS"("TABLE_NAME","SEQ","FIELD_NAME","IS_KEY","FIELD_TYPE","STATUS_CODE","FIELD_DISPLAY_NAME","SCALE","DEFAULT_VALUE","NULLABLE","IS_VERSION","SIZE","IS_AUTO_INCREMENT") VALUES('dw_schedule',12,'last_success_time','N','datetime','Y','last_success_time','0','','Y','N',null,'N');
INSERT INTO "DW_RDBMS_FIELDS"("TABLE_NAME","SEQ","FIELD_NAME","IS_KEY","FIELD_TYPE","STATUS_CODE","FIELD_DISPLAY_NAME","SCALE","DEFAULT_VALUE","NULLABLE","IS_VERSION","SIZE","IS_AUTO_INCREMENT") VALUES('dw_myhome',2,'level','Y','varchar','N','level','','','N','N','255','N');
INSERT INTO "DW_RDBMS_FIELDS"("TABLE_NAME","SEQ","FIELD_NAME","IS_KEY","FIELD_TYPE","STATUS_CODE","FIELD_DISPLAY_NAME","SCALE","DEFAULT_VALUE","NULLABLE","IS_VERSION","SIZE","IS_AUTO_INCREMENT") VALUES('dw_myhome_parameter',2,'level','Y','varchar','N','level','','','N','N','255','N');
INSERT INTO "DW_RDBMS_FIELDS"("TABLE_NAME","SEQ","FIELD_NAME","IS_KEY","FIELD_TYPE","STATUS_CODE","FIELD_DISPLAY_NAME","SCALE","DEFAULT_VALUE","NULLABLE","IS_VERSION","SIZE","IS_AUTO_INCREMENT") VALUES('dw_log_operation',1,'log_id','Y','varchar','N','id','0','','N','N','50','N');
INSERT INTO "DW_RDBMS_FIELDS"("TABLE_NAME","SEQ","FIELD_NAME","IS_KEY","FIELD_TYPE","STATUS_CODE","FIELD_DISPLAY_NAME","SCALE","DEFAULT_VALUE","NULLABLE","IS_VERSION","SIZE","IS_AUTO_INCREMENT") VALUES('dw_log_operation_error',1,'log_id','Y','varchar','N','id','0','','N','N','50','N');
INSERT INTO "DW_RDBMS_FIELDS"("TABLE_NAME","SEQ","FIELD_NAME","IS_KEY","FIELD_TYPE","STATUS_CODE","FIELD_DISPLAY_NAME","SCALE","DEFAULT_VALUE","NULLABLE","IS_VERSION","SIZE","IS_AUTO_INCREMENT") VALUES('dw_log_operation_sql',1,'log_id','Y','varchar','N','log_id','0','','N','N','50','N');
INSERT INTO "DW_RDBMS_FIELDS"("TABLE_NAME","SEQ","FIELD_NAME","IS_KEY","FIELD_TYPE","STATUS_CODE","FIELD_DISPLAY_NAME","SCALE","DEFAULT_VALUE","NULLABLE","IS_VERSION","SIZE","IS_AUTO_INCREMENT") VALUES('dw_log_operation_sql',3,'log_type','N','INT','N','log_type','0','','Y','N','4','N');
INSERT INTO "DW_RDBMS_FIELDS"("TABLE_NAME","SEQ","FIELD_NAME","IS_KEY","FIELD_TYPE","STATUS_CODE","FIELD_DISPLAY_NAME","SCALE","DEFAULT_VALUE","NULLABLE","IS_VERSION","SIZE","IS_AUTO_INCREMENT") VALUES('dw_schedule_contact',5,'mail_content','N','number','Y','mail_content','0','','Y','N','255','N');
INSERT INTO "DW_RDBMS_FIELDS"("TABLE_NAME","SEQ","FIELD_NAME","IS_KEY","FIELD_TYPE","STATUS_CODE","FIELD_DISPLAY_NAME","SCALE","DEFAULT_VALUE","NULLABLE","IS_VERSION","SIZE","IS_AUTO_INCREMENT") VALUES('dw_schedule_contact',4,'mail_subject','N','number','Y','mail_subject','0','','Y','N','255','N');
INSERT INTO "DW_RDBMS_FIELDS"("TABLE_NAME","SEQ","FIELD_NAME","IS_KEY","FIELD_TYPE","STATUS_CODE","FIELD_DISPLAY_NAME","SCALE","DEFAULT_VALUE","NULLABLE","IS_VERSION","SIZE","IS_AUTO_INCREMENT") VALUES('dw_schedule_contact',3,'mail_type','N','number','Y','mail_type','0','','Y','N','10','N');
INSERT INTO "DW_RDBMS_FIELDS"("TABLE_NAME","SEQ","FIELD_NAME","IS_KEY","FIELD_TYPE","STATUS_CODE","FIELD_DISPLAY_NAME","SCALE","DEFAULT_VALUE","NULLABLE","IS_VERSION","SIZE","IS_AUTO_INCREMENT") VALUES('dw_schedule',9,'max_runtime','N','number','Y','max_runtime','0','','Y','N','10','N');
INSERT INTO "DW_RDBMS_FIELDS"("TABLE_NAME","SEQ","FIELD_NAME","IS_KEY","FIELD_TYPE","STATUS_CODE","FIELD_DISPLAY_NAME","SCALE","DEFAULT_VALUE","NULLABLE","IS_VERSION","SIZE","IS_AUTO_INCREMENT") VALUES('dw_log_operation',5,'menu','N','varchar','N','menu','0','','N','N','50','N');
INSERT INTO "DW_RDBMS_FIELDS"("TABLE_NAME","SEQ","FIELD_NAME","IS_KEY","FIELD_TYPE","STATUS_CODE","FIELD_DISPLAY_NAME","SCALE","DEFAULT_VALUE","NULLABLE","IS_VERSION","SIZE","IS_AUTO_INCREMENT") VALUES('dw_log_operation_error',8,'menu','N','varchar','N','operate_type','0','','N','N','50','N');
INSERT INTO "DW_RDBMS_FIELDS"("TABLE_NAME","SEQ","FIELD_NAME","IS_KEY","FIELD_TYPE","STATUS_CODE","FIELD_DISPLAY_NAME","SCALE","DEFAULT_VALUE","NULLABLE","IS_VERSION","SIZE","IS_AUTO_INCREMENT") VALUES('dw_menu_language',1,'menu_id','Y','varchar','Y','menu_id','0','','N','N','100','N');
INSERT INTO "DW_RDBMS_FIELDS"("TABLE_NAME","SEQ","FIELD_NAME","IS_KEY","FIELD_TYPE","STATUS_CODE","FIELD_DISPLAY_NAME","SCALE","DEFAULT_VALUE","NULLABLE","IS_VERSION","SIZE","IS_AUTO_INCREMENT") VALUES('dw_menu_parameter',1,'menu_id','Y','varchar','Y','menu_id','0','','N','N','100','N');
INSERT INTO "DW_RDBMS_FIELDS"("TABLE_NAME","SEQ","FIELD_NAME","IS_KEY","FIELD_TYPE","STATUS_CODE","FIELD_DISPLAY_NAME","SCALE","DEFAULT_VALUE","NULLABLE","IS_VERSION","SIZE","IS_AUTO_INCREMENT") VALUES('dw_schedule_record',5,'message','N','TEXT','Y','message','0','','Y','N',null,'N');
INSERT INTO "DW_RDBMS_FIELDS"("TABLE_NAME","SEQ","FIELD_NAME","IS_KEY","FIELD_TYPE","STATUS_CODE","FIELD_DISPLAY_NAME","SCALE","DEFAULT_VALUE","NULLABLE","IS_VERSION","SIZE","IS_AUTO_INCREMENT") VALUES('dw_schedule_record',6,'message_detail','N','varchar','Y','message_detail','0','','Y','N','255','N');
INSERT INTO "DW_RDBMS_FIELDS"("TABLE_NAME","SEQ","FIELD_NAME","IS_KEY","FIELD_TYPE","STATUS_CODE","FIELD_DISPLAY_NAME","SCALE","DEFAULT_VALUE","NULLABLE","IS_VERSION","SIZE","IS_AUTO_INCREMENT") VALUES('dw_theme_filelog',3,'messege','N','varchar','Y','messege','0','','Y','N','500','N');
INSERT INTO "DW_RDBMS_FIELDS"("TABLE_NAME","SEQ","FIELD_NAME","IS_KEY","FIELD_TYPE","STATUS_CODE","FIELD_DISPLAY_NAME","SCALE","DEFAULT_VALUE","NULLABLE","IS_VERSION","SIZE","IS_AUTO_INCREMENT") VALUES('dw_schedule_time',22,'minutely','N','INT','Y','minutely','0','','Y','N','10','N');
INSERT INTO "DW_RDBMS_FIELDS"("TABLE_NAME","SEQ","FIELD_NAME","IS_KEY","FIELD_TYPE","STATUS_CODE","FIELD_DISPLAY_NAME","SCALE","DEFAULT_VALUE","NULLABLE","IS_VERSION","SIZE","IS_AUTO_INCREMENT") VALUES('dw_log_operation',6,'module','N','varchar','N','module','0','','N','N','50','N');
INSERT INTO "DW_RDBMS_FIELDS"("TABLE_NAME","SEQ","FIELD_NAME","IS_KEY","FIELD_TYPE","STATUS_CODE","FIELD_DISPLAY_NAME","SCALE","DEFAULT_VALUE","NULLABLE","IS_VERSION","SIZE","IS_AUTO_INCREMENT") VALUES('dw_log_operation_error',9,'module','N','varchar','N','module','0','','N','N','50','N');
INSERT INTO "DW_RDBMS_FIELDS"("TABLE_NAME","SEQ","FIELD_NAME","IS_KEY","FIELD_TYPE","STATUS_CODE","FIELD_DISPLAY_NAME","SCALE","DEFAULT_VALUE","NULLABLE","IS_VERSION","SIZE","IS_AUTO_INCREMENT") VALUES('dw_schedule',17,'module_name','N','varchar','Y','module_name','0','','Y','N','50','N');
INSERT INTO "DW_RDBMS_FIELDS"("TABLE_NAME","SEQ","FIELD_NAME","IS_KEY","FIELD_TYPE","STATUS_CODE","FIELD_DISPLAY_NAME","SCALE","DEFAULT_VALUE","NULLABLE","IS_VERSION","SIZE","IS_AUTO_INCREMENT") VALUES('dw_schedule_time',2,'month','N','varchar','Y','month','0','','Y','N','255','N');
INSERT INTO "DW_RDBMS_FIELDS"("TABLE_NAME","SEQ","FIELD_NAME","IS_KEY","FIELD_TYPE","STATUS_CODE","FIELD_DISPLAY_NAME","SCALE","DEFAULT_VALUE","NULLABLE","IS_VERSION","SIZE","IS_AUTO_INCREMENT") VALUES('dw_schedule_time',14,'month_radio','N','varchar','Y','month_radio','0','','Y','N','1','N');
INSERT INTO "DW_RDBMS_FIELDS"("TABLE_NAME","SEQ","FIELD_NAME","IS_KEY","FIELD_TYPE","STATUS_CODE","FIELD_DISPLAY_NAME","SCALE","DEFAULT_VALUE","NULLABLE","IS_VERSION","SIZE","IS_AUTO_INCREMENT") VALUES('dw_schedule_time',27,'monthly','N','INT','Y','monthly','0','','Y','N','10','N');
INSERT INTO "DW_RDBMS_FIELDS"("TABLE_NAME","SEQ","FIELD_NAME","IS_KEY","FIELD_TYPE","STATUS_CODE","FIELD_DISPLAY_NAME","SCALE","DEFAULT_VALUE","NULLABLE","IS_VERSION","SIZE","IS_AUTO_INCREMENT") VALUES('dw_menu_language',3,'name','N','varchar','Y','name','0','','Y','N','200','N');
INSERT INTO "DW_RDBMS_FIELDS"("TABLE_NAME","SEQ","FIELD_NAME","IS_KEY","FIELD_TYPE","STATUS_CODE","FIELD_DISPLAY_NAME","SCALE","DEFAULT_VALUE","NULLABLE","IS_VERSION","SIZE","IS_AUTO_INCREMENT") VALUES('dw_menu_parameter',2,'name','Y','varchar','Y','name','0','','N','N','200','N');
INSERT INTO "DW_RDBMS_FIELDS"("TABLE_NAME","SEQ","FIELD_NAME","IS_KEY","FIELD_TYPE","STATUS_CODE","FIELD_DISPLAY_NAME","SCALE","DEFAULT_VALUE","NULLABLE","IS_VERSION","SIZE","IS_AUTO_INCREMENT") VALUES('dw_myhome_parameter',3,'name','Y','varchar','N','name','','','N','N','200','N');
INSERT INTO "DW_RDBMS_FIELDS"("TABLE_NAME","SEQ","FIELD_NAME","IS_KEY","FIELD_TYPE","STATUS_CODE","FIELD_DISPLAY_NAME","SCALE","DEFAULT_VALUE","NULLABLE","IS_VERSION","SIZE","IS_AUTO_INCREMENT") VALUES('dw_schedule',14,'next_execute_time','N','datetime','Y','next_execute_time','0','','Y','N',null,'N');
INSERT INTO "DW_RDBMS_FIELDS"("TABLE_NAME","SEQ","FIELD_NAME","IS_KEY","FIELD_TYPE","STATUS_CODE","FIELD_DISPLAY_NAME","SCALE","DEFAULT_VALUE","NULLABLE","IS_VERSION","SIZE","IS_AUTO_INCREMENT") VALUES('dw_menu',9,'open_mode','N','varchar','Y','open_mode','0','','Y','N','50','N');
INSERT INTO "DW_RDBMS_FIELDS"("TABLE_NAME","SEQ","FIELD_NAME","IS_KEY","FIELD_TYPE","STATUS_CODE","FIELD_DISPLAY_NAME","SCALE","DEFAULT_VALUE","NULLABLE","IS_VERSION","SIZE","IS_AUTO_INCREMENT") VALUES('dw_log_operation',4,'operate_desc','N','varchar','N','operate_desc','0','','N','N','50','N');
INSERT INTO "DW_RDBMS_FIELDS"("TABLE_NAME","SEQ","FIELD_NAME","IS_KEY","FIELD_TYPE","STATUS_CODE","FIELD_DISPLAY_NAME","SCALE","DEFAULT_VALUE","NULLABLE","IS_VERSION","SIZE","IS_AUTO_INCREMENT") VALUES('dw_log_operation_error',4,'operate_desc','N','varchar','N','operate_desc','0','','N','N','50','N');
INSERT INTO "DW_RDBMS_FIELDS"("TABLE_NAME","SEQ","FIELD_NAME","IS_KEY","FIELD_TYPE","STATUS_CODE","FIELD_DISPLAY_NAME","SCALE","DEFAULT_VALUE","NULLABLE","IS_VERSION","SIZE","IS_AUTO_INCREMENT") VALUES('dw_log_operation',2,'operate_no','N','varchar','N','operate_no','0','','N','N','50','N');
INSERT INTO "DW_RDBMS_FIELDS"("TABLE_NAME","SEQ","FIELD_NAME","IS_KEY","FIELD_TYPE","STATUS_CODE","FIELD_DISPLAY_NAME","SCALE","DEFAULT_VALUE","NULLABLE","IS_VERSION","SIZE","IS_AUTO_INCREMENT") VALUES('dw_log_operation_error',2,'operate_no','N','varchar','N','operate_no','0','','N','N','50','N');
INSERT INTO "DW_RDBMS_FIELDS"("TABLE_NAME","SEQ","FIELD_NAME","IS_KEY","FIELD_TYPE","STATUS_CODE","FIELD_DISPLAY_NAME","SCALE","DEFAULT_VALUE","NULLABLE","IS_VERSION","SIZE","IS_AUTO_INCREMENT") VALUES('dw_log_operation',3,'operate_type','N','varchar','N','operate_type','0','','N','N','20','N');
INSERT INTO "DW_RDBMS_FIELDS"("TABLE_NAME","SEQ","FIELD_NAME","IS_KEY","FIELD_TYPE","STATUS_CODE","FIELD_DISPLAY_NAME","SCALE","DEFAULT_VALUE","NULLABLE","IS_VERSION","SIZE","IS_AUTO_INCREMENT") VALUES('dw_log_operation_error',3,'operate_type','N','varchar','N','operate_type','0','','N','N','20','N');
INSERT INTO "DW_RDBMS_FIELDS"("TABLE_NAME","SEQ","FIELD_NAME","IS_KEY","FIELD_TYPE","STATUS_CODE","FIELD_DISPLAY_NAME","SCALE","DEFAULT_VALUE","NULLABLE","IS_VERSION","SIZE","IS_AUTO_INCREMENT") VALUES('dw_log_operation_sql',2,'operation_log_id','Y','varchar','N','operation_log_id','0','','N','N','50','N');
INSERT INTO "DW_RDBMS_FIELDS"("TABLE_NAME","SEQ","FIELD_NAME","IS_KEY","FIELD_TYPE","STATUS_CODE","FIELD_DISPLAY_NAME","SCALE","DEFAULT_VALUE","NULLABLE","IS_VERSION","SIZE","IS_AUTO_INCREMENT") VALUES('dw_query_info',5,'owner','N','varchar','Y','owner','0','','Y','N','45','N');
INSERT INTO "DW_RDBMS_FIELDS"("TABLE_NAME","SEQ","FIELD_NAME","IS_KEY","FIELD_TYPE","STATUS_CODE","FIELD_DISPLAY_NAME","SCALE","DEFAULT_VALUE","NULLABLE","IS_VERSION","SIZE","IS_AUTO_INCREMENT") VALUES('dw_menu',3,'parent_id','N','varchar','Y','parent_id','0','','Y','N','100','N');
INSERT INTO "DW_RDBMS_FIELDS"("TABLE_NAME","SEQ","FIELD_NAME","IS_KEY","FIELD_TYPE","STATUS_CODE","FIELD_DISPLAY_NAME","SCALE","DEFAULT_VALUE","NULLABLE","IS_VERSION","SIZE","IS_AUTO_INCREMENT") VALUES('dw_myhome',4,'path','N','varchar','N','path','','','Y','N','2000','N');
INSERT INTO "DW_RDBMS_FIELDS"("TABLE_NAME","SEQ","FIELD_NAME","IS_KEY","FIELD_TYPE","STATUS_CODE","FIELD_DISPLAY_NAME","SCALE","DEFAULT_VALUE","NULLABLE","IS_VERSION","SIZE","IS_AUTO_INCREMENT") VALUES('dw_log_operation_error',18,'prog_impl','N','varchar','N','function','0','','N','N','200','N');
INSERT INTO "DW_RDBMS_FIELDS"("TABLE_NAME","SEQ","FIELD_NAME","IS_KEY","FIELD_TYPE","STATUS_CODE","FIELD_DISPLAY_NAME","SCALE","DEFAULT_VALUE","NULLABLE","IS_VERSION","SIZE","IS_AUTO_INCREMENT") VALUES('dw_schedule',16,'program_code','N','varchar','Y','program_code','0','','Y','N','50','N');
INSERT INTO "DW_RDBMS_FIELDS"("TABLE_NAME","SEQ","FIELD_NAME","IS_KEY","FIELD_TYPE","STATUS_CODE","FIELD_DISPLAY_NAME","SCALE","DEFAULT_VALUE","NULLABLE","IS_VERSION","SIZE","IS_AUTO_INCREMENT") VALUES('dw_schedule_record',12,'program_code','N','varchar','Y','program_code','0','','Y','N','50','N');
INSERT INTO "DW_RDBMS_FIELDS"("TABLE_NAME","SEQ","FIELD_NAME","IS_KEY","FIELD_TYPE","STATUS_CODE","FIELD_DISPLAY_NAME","SCALE","DEFAULT_VALUE","NULLABLE","IS_VERSION","SIZE","IS_AUTO_INCREMENT") VALUES('dw_theme',2,'prop','Y','varchar','Y','prop','0','','N','N','50','N');
INSERT INTO "DW_RDBMS_FIELDS"("TABLE_NAME","SEQ","FIELD_NAME","IS_KEY","FIELD_TYPE","STATUS_CODE","FIELD_DISPLAY_NAME","SCALE","DEFAULT_VALUE","NULLABLE","IS_VERSION","SIZE","IS_AUTO_INCREMENT") VALUES('dw_query_info',4,'publish','N','varchar','Y','publish','0','','Y','N','45','N');
INSERT INTO "DW_RDBMS_FIELDS"("TABLE_NAME","SEQ","FIELD_NAME","IS_KEY","FIELD_TYPE","STATUS_CODE","FIELD_DISPLAY_NAME","SCALE","DEFAULT_VALUE","NULLABLE","IS_VERSION","SIZE","IS_AUTO_INCREMENT") VALUES('dw_app_release',5,'published','N','varchar','Y','published','0','','N','N','1','N');
INSERT INTO "DW_RDBMS_FIELDS"("TABLE_NAME","SEQ","FIELD_NAME","IS_KEY","FIELD_TYPE","STATUS_CODE","FIELD_DISPLAY_NAME","SCALE","DEFAULT_VALUE","NULLABLE","IS_VERSION","SIZE","IS_AUTO_INCREMENT") VALUES('dw_query_info',1,'query_id','Y','varchar','Y','query_id','0','','N','N','45','N');
INSERT INTO "DW_RDBMS_FIELDS"("TABLE_NAME","SEQ","FIELD_NAME","IS_KEY","FIELD_TYPE","STATUS_CODE","FIELD_DISPLAY_NAME","SCALE","DEFAULT_VALUE","NULLABLE","IS_VERSION","SIZE","IS_AUTO_INCREMENT") VALUES('dw_query_info',2,'query_type','N','varchar','Y','query_type','0','','N','N','45','N');
INSERT INTO "DW_RDBMS_FIELDS"("TABLE_NAME","SEQ","FIELD_NAME","IS_KEY","FIELD_TYPE","STATUS_CODE","FIELD_DISPLAY_NAME","SCALE","DEFAULT_VALUE","NULLABLE","IS_VERSION","SIZE","IS_AUTO_INCREMENT") VALUES('dw_schedule_contact',6,'receiver_email','N','number','Y','receiver_email','0','','Y','N','255','N');
INSERT INTO "DW_RDBMS_FIELDS"("TABLE_NAME","SEQ","FIELD_NAME","IS_KEY","FIELD_TYPE","STATUS_CODE","FIELD_DISPLAY_NAME","SCALE","DEFAULT_VALUE","NULLABLE","IS_VERSION","SIZE","IS_AUTO_INCREMENT") VALUES('dw_schedule',11,'recent_status','N','varchar','Y','recent_status','0','','Y','N','255','N');
INSERT INTO "DW_RDBMS_FIELDS"("TABLE_NAME","SEQ","FIELD_NAME","IS_KEY","FIELD_TYPE","STATUS_CODE","FIELD_DISPLAY_NAME","SCALE","DEFAULT_VALUE","NULLABLE","IS_VERSION","SIZE","IS_AUTO_INCREMENT") VALUES('dw_log_operation',14,'remark','N','varchar','N','remark','0','','N','N','1000','N');
INSERT INTO "DW_RDBMS_FIELDS"("TABLE_NAME","SEQ","FIELD_NAME","IS_KEY","FIELD_TYPE","STATUS_CODE","FIELD_DISPLAY_NAME","SCALE","DEFAULT_VALUE","NULLABLE","IS_VERSION","SIZE","IS_AUTO_INCREMENT") VALUES('dw_schedule_time',18,'repeat_count','N','number','Y','repeat_count','0','','Y','N','65','N');
INSERT INTO "DW_RDBMS_FIELDS"("TABLE_NAME","SEQ","FIELD_NAME","IS_KEY","FIELD_TYPE","STATUS_CODE","FIELD_DISPLAY_NAME","SCALE","DEFAULT_VALUE","NULLABLE","IS_VERSION","SIZE","IS_AUTO_INCREMENT") VALUES('dw_schedule_time',19,'repeat_type','N','varchar','Y','repeat_type','0','','Y','N','1','N');
INSERT INTO "DW_RDBMS_FIELDS"("TABLE_NAME","SEQ","FIELD_NAME","IS_KEY","FIELD_TYPE","STATUS_CODE","FIELD_DISPLAY_NAME","SCALE","DEFAULT_VALUE","NULLABLE","IS_VERSION","SIZE","IS_AUTO_INCREMENT") VALUES('dw_schedule_time',33,'retry_after_misfire_sec','N','INT','Y','retry_after_misfire_sec','0','','Y','N','10','N');
INSERT INTO "DW_RDBMS_FIELDS"("TABLE_NAME","SEQ","FIELD_NAME","IS_KEY","FIELD_TYPE","STATUS_CODE","FIELD_DISPLAY_NAME","SCALE","DEFAULT_VALUE","NULLABLE","IS_VERSION","SIZE","IS_AUTO_INCREMENT") VALUES('dw_log_operation',10,'return_value','N','text','N','return_value','0','','N','N','4000','N');
INSERT INTO "DW_RDBMS_FIELDS"("TABLE_NAME","SEQ","FIELD_NAME","IS_KEY","FIELD_TYPE","STATUS_CODE","FIELD_DISPLAY_NAME","SCALE","DEFAULT_VALUE","NULLABLE","IS_VERSION","SIZE","IS_AUTO_INCREMENT") VALUES('dw_log_operation_error',13,'return_value','N','text','N','return_value','0','','N','N','4000','N');
INSERT INTO "DW_RDBMS_FIELDS"("TABLE_NAME","SEQ","FIELD_NAME","IS_KEY","FIELD_TYPE","STATUS_CODE","FIELD_DISPLAY_NAME","SCALE","DEFAULT_VALUE","NULLABLE","IS_VERSION","SIZE","IS_AUTO_INCREMENT") VALUES('dw_schedule',1,'schedule_id','Y','varchar','Y','schedule_id','0','','N','N','50','N');
INSERT INTO "DW_RDBMS_FIELDS"("TABLE_NAME","SEQ","FIELD_NAME","IS_KEY","FIELD_TYPE","STATUS_CODE","FIELD_DISPLAY_NAME","SCALE","DEFAULT_VALUE","NULLABLE","IS_VERSION","SIZE","IS_AUTO_INCREMENT") VALUES('dw_schedule_contact',2,'schedule_id','N','number','Y','schedule_id','0','','N','N','50','N');
INSERT INTO "DW_RDBMS_FIELDS"("TABLE_NAME","SEQ","FIELD_NAME","IS_KEY","FIELD_TYPE","STATUS_CODE","FIELD_DISPLAY_NAME","SCALE","DEFAULT_VALUE","NULLABLE","IS_VERSION","SIZE","IS_AUTO_INCREMENT") VALUES('dw_schedule_record',2,'schedule_id','N','varchar','Y','schedule_id','0','','N','N','50','N');
INSERT INTO "DW_RDBMS_FIELDS"("TABLE_NAME","SEQ","FIELD_NAME","IS_KEY","FIELD_TYPE","STATUS_CODE","FIELD_DISPLAY_NAME","SCALE","DEFAULT_VALUE","NULLABLE","IS_VERSION","SIZE","IS_AUTO_INCREMENT") VALUES('dw_schedule_time',1,'schedule_id','Y','varchar','Y','schedule_id','0','','N','N','50','N');
INSERT INTO "DW_RDBMS_FIELDS"("TABLE_NAME","SEQ","FIELD_NAME","IS_KEY","FIELD_TYPE","STATUS_CODE","FIELD_DISPLAY_NAME","SCALE","DEFAULT_VALUE","NULLABLE","IS_VERSION","SIZE","IS_AUTO_INCREMENT") VALUES('dw_schedule',2,'schedule_name','N','varchar','Y','schedule_name','0','','Y','N','50','N');
INSERT INTO "DW_RDBMS_FIELDS"("TABLE_NAME","SEQ","FIELD_NAME","IS_KEY","FIELD_TYPE","STATUS_CODE","FIELD_DISPLAY_NAME","SCALE","DEFAULT_VALUE","NULLABLE","IS_VERSION","SIZE","IS_AUTO_INCREMENT") VALUES('dw_schedule_record',13,'schedule_name','N','varchar','Y','schedule_name','0','','Y','N','50','N');
INSERT INTO "DW_RDBMS_FIELDS"("TABLE_NAME","SEQ","FIELD_NAME","IS_KEY","FIELD_TYPE","STATUS_CODE","FIELD_DISPLAY_NAME","SCALE","DEFAULT_VALUE","NULLABLE","IS_VERSION","SIZE","IS_AUTO_INCREMENT") VALUES('dw_schedule',10,'schedule_param','N','TEXT','Y','schedule_param','0','','Y','N',null,'N');
INSERT INTO "DW_RDBMS_FIELDS"("TABLE_NAME","SEQ","FIELD_NAME","IS_KEY","FIELD_TYPE","STATUS_CODE","FIELD_DISPLAY_NAME","SCALE","DEFAULT_VALUE","NULLABLE","IS_VERSION","SIZE","IS_AUTO_INCREMENT") VALUES('dw_schedule_record',9,'schedule_param','N','TEXT','Y','schedule_param','0','','Y','N',null,'N');
INSERT INTO "DW_RDBMS_FIELDS"("TABLE_NAME","SEQ","FIELD_NAME","IS_KEY","FIELD_TYPE","STATUS_CODE","FIELD_DISPLAY_NAME","SCALE","DEFAULT_VALUE","NULLABLE","IS_VERSION","SIZE","IS_AUTO_INCREMENT") VALUES('dw_schedule',4,'schedule_type','N','varchar','Y','schedule_type','0','','Y','N','1','N');
INSERT INTO "DW_RDBMS_FIELDS"("TABLE_NAME","SEQ","FIELD_NAME","IS_KEY","FIELD_TYPE","STATUS_CODE","FIELD_DISPLAY_NAME","SCALE","DEFAULT_VALUE","NULLABLE","IS_VERSION","SIZE","IS_AUTO_INCREMENT") VALUES('dw_schedule_record',10,'schedule_type','N','varchar','Y','schedule_type','0','','Y','N','1','N');
INSERT INTO "DW_RDBMS_FIELDS"("TABLE_NAME","SEQ","FIELD_NAME","IS_KEY","FIELD_TYPE","STATUS_CODE","FIELD_DISPLAY_NAME","SCALE","DEFAULT_VALUE","NULLABLE","IS_VERSION","SIZE","IS_AUTO_INCREMENT") VALUES('dw_schedule_contact',7,'send_condition','N','number','Y','send_condition','0','','Y','N','50','N');
INSERT INTO "DW_RDBMS_FIELDS"("TABLE_NAME","SEQ","FIELD_NAME","IS_KEY","FIELD_TYPE","STATUS_CODE","FIELD_DISPLAY_NAME","SCALE","DEFAULT_VALUE","NULLABLE","IS_VERSION","SIZE","IS_AUTO_INCREMENT") VALUES('dw_menu',5,'sequence','N','number','Y','sequence','0','','N','N','20','N');
INSERT INTO "DW_RDBMS_FIELDS"("TABLE_NAME","SEQ","FIELD_NAME","IS_KEY","FIELD_TYPE","STATUS_CODE","FIELD_DISPLAY_NAME","SCALE","DEFAULT_VALUE","NULLABLE","IS_VERSION","SIZE","IS_AUTO_INCREMENT") VALUES('dw_query_info',3,'sql_statement','N','varchar','Y','sql_statement','0','','N','N','450','N');
INSERT INTO "DW_RDBMS_FIELDS"("TABLE_NAME","SEQ","FIELD_NAME","IS_KEY","FIELD_TYPE","STATUS_CODE","FIELD_DISPLAY_NAME","SCALE","DEFAULT_VALUE","NULLABLE","IS_VERSION","SIZE","IS_AUTO_INCREMENT") VALUES('dw_schedule_record',7,'start_time','N','datetime','Y','start_time','0','','Y','N','20','N');
INSERT INTO "DW_RDBMS_FIELDS"("TABLE_NAME","SEQ","FIELD_NAME","IS_KEY","FIELD_TYPE","STATUS_CODE","FIELD_DISPLAY_NAME","SCALE","DEFAULT_VALUE","NULLABLE","IS_VERSION","SIZE","IS_AUTO_INCREMENT") VALUES('dw_schedule_time',20,'start_time','N','datetime','Y','start_time','0','','Y','N','20','N');
INSERT INTO "DW_RDBMS_FIELDS"("TABLE_NAME","SEQ","FIELD_NAME","IS_KEY","FIELD_TYPE","STATUS_CODE","FIELD_DISPLAY_NAME","SCALE","DEFAULT_VALUE","NULLABLE","IS_VERSION","SIZE","IS_AUTO_INCREMENT") VALUES('dw_log_operation',12,'status','N','INT','Y','status','0','','N','N','4','N');
INSERT INTO "DW_RDBMS_FIELDS"("TABLE_NAME","SEQ","FIELD_NAME","IS_KEY","FIELD_TYPE","STATUS_CODE","FIELD_DISPLAY_NAME","SCALE","DEFAULT_VALUE","NULLABLE","IS_VERSION","SIZE","IS_AUTO_INCREMENT") VALUES('dw_custom_column',2,'table_id','Y','varchar','Y','table_id','0','','N','N','50','N');
INSERT INTO "DW_RDBMS_FIELDS"("TABLE_NAME","SEQ","FIELD_NAME","IS_KEY","FIELD_TYPE","STATUS_CODE","FIELD_DISPLAY_NAME","SCALE","DEFAULT_VALUE","NULLABLE","IS_VERSION","SIZE","IS_AUTO_INCREMENT") VALUES('dw_custom_column',1,'tenantsid','Y','bigint','Y','tenantsid','0','','N','N','20','N');
INSERT INTO "DW_RDBMS_FIELDS"("TABLE_NAME","SEQ","FIELD_NAME","IS_KEY","FIELD_TYPE","STATUS_CODE","FIELD_DISPLAY_NAME","SCALE","DEFAULT_VALUE","NULLABLE","IS_VERSION","SIZE","IS_AUTO_INCREMENT") VALUES('dw_log_operation',19,'tenantsid','Y','bigint','N','tenantsid','0','','N','N','20','N');
INSERT INTO "DW_RDBMS_FIELDS"("TABLE_NAME","SEQ","FIELD_NAME","IS_KEY","FIELD_TYPE","STATUS_CODE","FIELD_DISPLAY_NAME","SCALE","DEFAULT_VALUE","NULLABLE","IS_VERSION","SIZE","IS_AUTO_INCREMENT") VALUES('dw_log_operation_error',19,'tenantsid','Y','bigint','N','tenantsid','0','','N','N','20','N');
INSERT INTO "DW_RDBMS_FIELDS"("TABLE_NAME","SEQ","FIELD_NAME","IS_KEY","FIELD_TYPE","STATUS_CODE","FIELD_DISPLAY_NAME","SCALE","DEFAULT_VALUE","NULLABLE","IS_VERSION","SIZE","IS_AUTO_INCREMENT") VALUES('dw_log_operation_sql',9,'tenantsid','Y','bigint','N','tenantsid','0','','N','N','20','N');
INSERT INTO "DW_RDBMS_FIELDS"("TABLE_NAME","SEQ","FIELD_NAME","IS_KEY","FIELD_TYPE","STATUS_CODE","FIELD_DISPLAY_NAME","SCALE","DEFAULT_VALUE","NULLABLE","IS_VERSION","SIZE","IS_AUTO_INCREMENT") VALUES('dw_myhome',6,'tenantsid','Y','bigint','N','tenantsid','','','N','N','20','N');
INSERT INTO "DW_RDBMS_FIELDS"("TABLE_NAME","SEQ","FIELD_NAME","IS_KEY","FIELD_TYPE","STATUS_CODE","FIELD_DISPLAY_NAME","SCALE","DEFAULT_VALUE","NULLABLE","IS_VERSION","SIZE","IS_AUTO_INCREMENT") VALUES('dw_myhome_parameter',5,'tenantsid','Y','bigint','N','tenantsid','','','N','N','20','N');
INSERT INTO "DW_RDBMS_FIELDS"("TABLE_NAME","SEQ","FIELD_NAME","IS_KEY","FIELD_TYPE","STATUS_CODE","FIELD_DISPLAY_NAME","SCALE","DEFAULT_VALUE","NULLABLE","IS_VERSION","SIZE","IS_AUTO_INCREMENT") VALUES('dw_schedule',15,'tenantsid','Y','bigint','N','tenantsid','0','','N','N','20','N');
INSERT INTO "DW_RDBMS_FIELDS"("TABLE_NAME","SEQ","FIELD_NAME","IS_KEY","FIELD_TYPE","STATUS_CODE","FIELD_DISPLAY_NAME","SCALE","DEFAULT_VALUE","NULLABLE","IS_VERSION","SIZE","IS_AUTO_INCREMENT") VALUES('dw_schedule_contact',8,'tenantsid','Y','bigint','N','tenantsid','0','','N','N','20','N');
INSERT INTO "DW_RDBMS_FIELDS"("TABLE_NAME","SEQ","FIELD_NAME","IS_KEY","FIELD_TYPE","STATUS_CODE","FIELD_DISPLAY_NAME","SCALE","DEFAULT_VALUE","NULLABLE","IS_VERSION","SIZE","IS_AUTO_INCREMENT") VALUES('dw_schedule_record',11,'tenantsid','Y','bigint','N','tenantsid','0','','N','N','20','N');
INSERT INTO "DW_RDBMS_FIELDS"("TABLE_NAME","SEQ","FIELD_NAME","IS_KEY","FIELD_TYPE","STATUS_CODE","FIELD_DISPLAY_NAME","SCALE","DEFAULT_VALUE","NULLABLE","IS_VERSION","SIZE","IS_AUTO_INCREMENT") VALUES('dw_schedule_time',30,'tenantsid','Y','bigint','N','tenantsid','0','','N','N','20','N');
INSERT INTO "DW_RDBMS_FIELDS"("TABLE_NAME","SEQ","FIELD_NAME","IS_KEY","FIELD_TYPE","STATUS_CODE","FIELD_DISPLAY_NAME","SCALE","DEFAULT_VALUE","NULLABLE","IS_VERSION","SIZE","IS_AUTO_INCREMENT") VALUES('dw_theme',1,'tenantsid','Y','bigint','Y','tenantsid','0','','N','N','20','N');
INSERT INTO "DW_RDBMS_FIELDS"("TABLE_NAME","SEQ","FIELD_NAME","IS_KEY","FIELD_TYPE","STATUS_CODE","FIELD_DISPLAY_NAME","SCALE","DEFAULT_VALUE","NULLABLE","IS_VERSION","SIZE","IS_AUTO_INCREMENT") VALUES('dw_schedule_time',7,'time','N','varchar','Y','time','0','','Y','N','255','N');
INSERT INTO "DW_RDBMS_FIELDS"("TABLE_NAME","SEQ","FIELD_NAME","IS_KEY","FIELD_TYPE","STATUS_CODE","FIELD_DISPLAY_NAME","SCALE","DEFAULT_VALUE","NULLABLE","IS_VERSION","SIZE","IS_AUTO_INCREMENT") VALUES('dw_schedule_time',9,'time1','N','varchar','Y','time1','0','','Y','N','255','N');
INSERT INTO "DW_RDBMS_FIELDS"("TABLE_NAME","SEQ","FIELD_NAME","IS_KEY","FIELD_TYPE","STATUS_CODE","FIELD_DISPLAY_NAME","SCALE","DEFAULT_VALUE","NULLABLE","IS_VERSION","SIZE","IS_AUTO_INCREMENT") VALUES('dw_schedule_time',10,'time2','N','varchar','Y','time2','0','','Y','N','255','N');
INSERT INTO "DW_RDBMS_FIELDS"("TABLE_NAME","SEQ","FIELD_NAME","IS_KEY","FIELD_TYPE","STATUS_CODE","FIELD_DISPLAY_NAME","SCALE","DEFAULT_VALUE","NULLABLE","IS_VERSION","SIZE","IS_AUTO_INCREMENT") VALUES('dw_schedule_time',11,'time3','N','varchar','Y','time3','0','','Y','N','255','N');
INSERT INTO "DW_RDBMS_FIELDS"("TABLE_NAME","SEQ","FIELD_NAME","IS_KEY","FIELD_TYPE","STATUS_CODE","FIELD_DISPLAY_NAME","SCALE","DEFAULT_VALUE","NULLABLE","IS_VERSION","SIZE","IS_AUTO_INCREMENT") VALUES('dw_log_operation',11,'time_consume','N','bigint','N','time_consume','0','','N','N','20','N');
INSERT INTO "DW_RDBMS_FIELDS"("TABLE_NAME","SEQ","FIELD_NAME","IS_KEY","FIELD_TYPE","STATUS_CODE","FIELD_DISPLAY_NAME","SCALE","DEFAULT_VALUE","NULLABLE","IS_VERSION","SIZE","IS_AUTO_INCREMENT") VALUES('dw_log_operation_error',14,'time_consume','N','bigint','N','time_consume','0','','N','N','20','N');
INSERT INTO "DW_RDBMS_FIELDS"("TABLE_NAME","SEQ","FIELD_NAME","IS_KEY","FIELD_TYPE","STATUS_CODE","FIELD_DISPLAY_NAME","SCALE","DEFAULT_VALUE","NULLABLE","IS_VERSION","SIZE","IS_AUTO_INCREMENT") VALUES('dw_schedule_time',15,'time_radio','N','varchar','Y','time_radio','0','','Y','N','1','N');
INSERT INTO "DW_RDBMS_FIELDS"("TABLE_NAME","SEQ","FIELD_NAME","IS_KEY","FIELD_TYPE","STATUS_CODE","FIELD_DISPLAY_NAME","SCALE","DEFAULT_VALUE","NULLABLE","IS_VERSION","SIZE","IS_AUTO_INCREMENT") VALUES('dw_log_operation',18,'traceid','N','varchar','N','traceid','0','','N','N','50','N');
INSERT INTO "DW_RDBMS_FIELDS"("TABLE_NAME","SEQ","FIELD_NAME","IS_KEY","FIELD_TYPE","STATUS_CODE","FIELD_DISPLAY_NAME","SCALE","DEFAULT_VALUE","NULLABLE","IS_VERSION","SIZE","IS_AUTO_INCREMENT") VALUES('dw_log_operation_error',17,'traceid','N','varchar','N','traceid','0','','N','N','50','N');
INSERT INTO "DW_RDBMS_FIELDS"("TABLE_NAME","SEQ","FIELD_NAME","IS_KEY","FIELD_TYPE","STATUS_CODE","FIELD_DISPLAY_NAME","SCALE","DEFAULT_VALUE","NULLABLE","IS_VERSION","SIZE","IS_AUTO_INCREMENT") VALUES('dw_menu',2,'type','N','varchar','Y','type','0','','N','N','50','N');
INSERT INTO "DW_RDBMS_FIELDS"("TABLE_NAME","SEQ","FIELD_NAME","IS_KEY","FIELD_TYPE","STATUS_CODE","FIELD_DISPLAY_NAME","SCALE","DEFAULT_VALUE","NULLABLE","IS_VERSION","SIZE","IS_AUTO_INCREMENT") VALUES('dw_myhome',3,'type','N','varchar','N','type','','','Y','N','20','N');
INSERT INTO "DW_RDBMS_FIELDS"("TABLE_NAME","SEQ","FIELD_NAME","IS_KEY","FIELD_TYPE","STATUS_CODE","FIELD_DISPLAY_NAME","SCALE","DEFAULT_VALUE","NULLABLE","IS_VERSION","SIZE","IS_AUTO_INCREMENT") VALUES('dw_log_operation',16,'update_name','N','varchar','N','update_name','0','','N','N','50','N');
INSERT INTO "DW_RDBMS_FIELDS"("TABLE_NAME","SEQ","FIELD_NAME","IS_KEY","FIELD_TYPE","STATUS_CODE","FIELD_DISPLAY_NAME","SCALE","DEFAULT_VALUE","NULLABLE","IS_VERSION","SIZE","IS_AUTO_INCREMENT") VALUES('dw_log_operation',17,'update_time','N','datetime','N','update_time','0','','N','N',null,'N');
INSERT INTO "DW_RDBMS_FIELDS"("TABLE_NAME","SEQ","FIELD_NAME","IS_KEY","FIELD_TYPE","STATUS_CODE","FIELD_DISPLAY_NAME","SCALE","DEFAULT_VALUE","NULLABLE","IS_VERSION","SIZE","IS_AUTO_INCREMENT") VALUES('dw_log_operation',8,'url','N','varchar','N','url','0','','N','N','1000','N');
INSERT INTO "DW_RDBMS_FIELDS"("TABLE_NAME","SEQ","FIELD_NAME","IS_KEY","FIELD_TYPE","STATUS_CODE","FIELD_DISPLAY_NAME","SCALE","DEFAULT_VALUE","NULLABLE","IS_VERSION","SIZE","IS_AUTO_INCREMENT") VALUES('dw_log_operation_error',11,'url','N','varchar','N','url','0','','N','N','1000','N');
INSERT INTO "DW_RDBMS_FIELDS"("TABLE_NAME","SEQ","FIELD_NAME","IS_KEY","FIELD_TYPE","STATUS_CODE","FIELD_DISPLAY_NAME","SCALE","DEFAULT_VALUE","NULLABLE","IS_VERSION","SIZE","IS_AUTO_INCREMENT") VALUES('dw_menu',8,'url','N','varchar','Y','url','0','','Y','N','2000','N');
INSERT INTO "DW_RDBMS_FIELDS"("TABLE_NAME","SEQ","FIELD_NAME","IS_KEY","FIELD_TYPE","STATUS_CODE","FIELD_DISPLAY_NAME","SCALE","DEFAULT_VALUE","NULLABLE","IS_VERSION","SIZE","IS_AUTO_INCREMENT") VALUES('dw_custom_column',3,'userid','Y','varchar','Y','userid','0','','N','N','50','N');
INSERT INTO "DW_RDBMS_FIELDS"("TABLE_NAME","SEQ","FIELD_NAME","IS_KEY","FIELD_TYPE","STATUS_CODE","FIELD_DISPLAY_NAME","SCALE","DEFAULT_VALUE","NULLABLE","IS_VERSION","SIZE","IS_AUTO_INCREMENT") VALUES('dw_myhome',1,'userid','Y','varchar','N','userid','','','N','N','40','N');
INSERT INTO "DW_RDBMS_FIELDS"("TABLE_NAME","SEQ","FIELD_NAME","IS_KEY","FIELD_TYPE","STATUS_CODE","FIELD_DISPLAY_NAME","SCALE","DEFAULT_VALUE","NULLABLE","IS_VERSION","SIZE","IS_AUTO_INCREMENT") VALUES('dw_myhome_parameter',1,'userid','Y','varchar','N','userid','','','N','N','40','N');
INSERT INTO "DW_RDBMS_FIELDS"("TABLE_NAME","SEQ","FIELD_NAME","IS_KEY","FIELD_TYPE","STATUS_CODE","FIELD_DISPLAY_NAME","SCALE","DEFAULT_VALUE","NULLABLE","IS_VERSION","SIZE","IS_AUTO_INCREMENT") VALUES('dw_theme',4,'userid','N','varchar','Y','userid','0','','Y','N','50','N');
INSERT INTO "DW_RDBMS_FIELDS"("TABLE_NAME","SEQ","FIELD_NAME","IS_KEY","FIELD_TYPE","STATUS_CODE","FIELD_DISPLAY_NAME","SCALE","DEFAULT_VALUE","NULLABLE","IS_VERSION","SIZE","IS_AUTO_INCREMENT") VALUES('dw_menu_parameter',3,'value','N','varchar','Y','value','0','','Y','N','200','N');
INSERT INTO "DW_RDBMS_FIELDS"("TABLE_NAME","SEQ","FIELD_NAME","IS_KEY","FIELD_TYPE","STATUS_CODE","FIELD_DISPLAY_NAME","SCALE","DEFAULT_VALUE","NULLABLE","IS_VERSION","SIZE","IS_AUTO_INCREMENT") VALUES('dw_myhome_parameter',4,'value','N','varchar','N','value','','','Y','N','200','N');
INSERT INTO "DW_RDBMS_FIELDS"("TABLE_NAME","SEQ","FIELD_NAME","IS_KEY","FIELD_TYPE","STATUS_CODE","FIELD_DISPLAY_NAME","SCALE","DEFAULT_VALUE","NULLABLE","IS_VERSION","SIZE","IS_AUTO_INCREMENT") VALUES('dw_theme',3,'value','N','varchar','Y','value','0','','Y','N','500','N');
INSERT INTO "DW_RDBMS_FIELDS"("TABLE_NAME","SEQ","FIELD_NAME","IS_KEY","FIELD_TYPE","STATUS_CODE","FIELD_DISPLAY_NAME","SCALE","DEFAULT_VALUE","NULLABLE","IS_VERSION","SIZE","IS_AUTO_INCREMENT") VALUES('dw_app_release',2,'version','Y','varchar','Y','version','0','','N','N','20','N');
INSERT INTO "DW_RDBMS_FIELDS"("TABLE_NAME","SEQ","FIELD_NAME","IS_KEY","FIELD_TYPE","STATUS_CODE","FIELD_DISPLAY_NAME","SCALE","DEFAULT_VALUE","NULLABLE","IS_VERSION","SIZE","IS_AUTO_INCREMENT") VALUES('dw_app_update',2,'version','Y','varchar','Y','version','0','','N','N','20','N');
INSERT INTO "DW_RDBMS_FIELDS"("TABLE_NAME","SEQ","FIELD_NAME","IS_KEY","FIELD_TYPE","STATUS_CODE","FIELD_DISPLAY_NAME","SCALE","DEFAULT_VALUE","NULLABLE","IS_VERSION","SIZE","IS_AUTO_INCREMENT") VALUES('dw_menu',10,'version','N','number','Y','version','0','','N','Y','20','N');
INSERT INTO "DW_RDBMS_FIELDS"("TABLE_NAME","SEQ","FIELD_NAME","IS_KEY","FIELD_TYPE","STATUS_CODE","FIELD_DISPLAY_NAME","SCALE","DEFAULT_VALUE","NULLABLE","IS_VERSION","SIZE","IS_AUTO_INCREMENT") VALUES('dw_myhome',5,'version','N','int','N','version','','','Y','Y','11','N');
INSERT INTO "DW_RDBMS_FIELDS"("TABLE_NAME","SEQ","FIELD_NAME","IS_KEY","FIELD_TYPE","STATUS_CODE","FIELD_DISPLAY_NAME","SCALE","DEFAULT_VALUE","NULLABLE","IS_VERSION","SIZE","IS_AUTO_INCREMENT") VALUES('dw_schedule_time',4,'week','N','varchar','Y','week','0','','Y','N','255','N');
INSERT INTO "DW_RDBMS_FIELDS"("TABLE_NAME","SEQ","FIELD_NAME","IS_KEY","FIELD_TYPE","STATUS_CODE","FIELD_DISPLAY_NAME","SCALE","DEFAULT_VALUE","NULLABLE","IS_VERSION","SIZE","IS_AUTO_INCREMENT") VALUES('dw_schedule_time',3,'week_of_month','N','varchar','Y','week_of_month','0','','Y','N','255','N');
INSERT INTO "DW_RDBMS_FIELDS"("TABLE_NAME","SEQ","FIELD_NAME","IS_KEY","FIELD_TYPE","STATUS_CODE","FIELD_DISPLAY_NAME","SCALE","DEFAULT_VALUE","NULLABLE","IS_VERSION","SIZE","IS_AUTO_INCREMENT") VALUES('dw_schedule_time',16,'week_radio','N','varchar','Y','week_radio','0','','N','N','1','N');
INSERT INTO "DW_RDBMS_FIELDS"("TABLE_NAME","SEQ","FIELD_NAME","IS_KEY","FIELD_TYPE","STATUS_CODE","FIELD_DISPLAY_NAME","SCALE","DEFAULT_VALUE","NULLABLE","IS_VERSION","SIZE","IS_AUTO_INCREMENT") VALUES('dw_schedule_time',25,'weekly','N','INT','Y','weekly','0','','Y','N','10','N');

INSERT INTO "DW_RDBMS_RELATIONS"("PRIMARY_TABLE_NO","REFERENCE_TABLE_NO","PRIMARY_TABLE_PK","REFERENCE_TABLE_PK","TYPE") VALUES('dw_app_prod','dw_app_release','app_code','app_code',null);
INSERT INTO "DW_RDBMS_RELATIONS"("PRIMARY_TABLE_NO","REFERENCE_TABLE_NO","PRIMARY_TABLE_PK","REFERENCE_TABLE_PK","TYPE") VALUES('dw_app_prod','dw_app_update','app_code','app_code',null);
INSERT INTO "DW_RDBMS_RELATIONS"("PRIMARY_TABLE_NO","REFERENCE_TABLE_NO","PRIMARY_TABLE_PK","REFERENCE_TABLE_PK","TYPE") VALUES('dw_log_operation','dw_log_operation_sql','log_id','operation_log_id',null);
INSERT INTO "DW_RDBMS_RELATIONS"("PRIMARY_TABLE_NO","REFERENCE_TABLE_NO","PRIMARY_TABLE_PK","REFERENCE_TABLE_PK","TYPE") VALUES('dw_menu','dw_menu_language','id','menu_id',null);
INSERT INTO "DW_RDBMS_RELATIONS"("PRIMARY_TABLE_NO","REFERENCE_TABLE_NO","PRIMARY_TABLE_PK","REFERENCE_TABLE_PK","TYPE") VALUES('dw_menu','dw_menu_parameter','id','menu_id',null);
INSERT INTO "DW_RDBMS_RELATIONS"("PRIMARY_TABLE_NO","REFERENCE_TABLE_NO","PRIMARY_TABLE_PK","REFERENCE_TABLE_PK","TYPE") VALUES('dw_myhome','dw_myhome_parameter','tenantsid,userid,level','tenantsid,userid,level',null);

INSERT INTO "DW_RDBMS_TABLES"("TABLE_NAME","TABLE_DISPLAY_NAME","TABLE_DESCRIPTION","DELETE_CONSTRAINT","HINT_FIELD","INSERT_DEFAULT_VALUE","UPDATE_DEFAULT_VALUE") VALUES('dw_app_prod','dw_app_prod','應用產品線','N',null,'N','N');
INSERT INTO "DW_RDBMS_TABLES"("TABLE_NAME","TABLE_DISPLAY_NAME","TABLE_DESCRIPTION","DELETE_CONSTRAINT","HINT_FIELD","INSERT_DEFAULT_VALUE","UPDATE_DEFAULT_VALUE") VALUES('dw_app_release','dw_app_release','應用版本發布與釋出','N',null,'N','N');
INSERT INTO "DW_RDBMS_TABLES"("TABLE_NAME","TABLE_DISPLAY_NAME","TABLE_DESCRIPTION","DELETE_CONSTRAINT","HINT_FIELD","INSERT_DEFAULT_VALUE","UPDATE_DEFAULT_VALUE") VALUES('dw_app_update','dw_app_update','應用更新版本對應','N',null,'N','N');
INSERT INTO "DW_RDBMS_TABLES"("TABLE_NAME","TABLE_DISPLAY_NAME","TABLE_DESCRIPTION","DELETE_CONSTRAINT","HINT_FIELD","INSERT_DEFAULT_VALUE","UPDATE_DEFAULT_VALUE") VALUES('dw_custom_column','個性化欄位表','個性化欄位表','N',null,'N','N');
INSERT INTO "DW_RDBMS_TABLES"("TABLE_NAME","TABLE_DISPLAY_NAME","TABLE_DESCRIPTION","DELETE_CONSTRAINT","HINT_FIELD","INSERT_DEFAULT_VALUE","UPDATE_DEFAULT_VALUE") VALUES('dw_log_operation','dw_log_operation','操作日誌','N',null,'N','N');
INSERT INTO "DW_RDBMS_TABLES"("TABLE_NAME","TABLE_DISPLAY_NAME","TABLE_DESCRIPTION","DELETE_CONSTRAINT","HINT_FIELD","INSERT_DEFAULT_VALUE","UPDATE_DEFAULT_VALUE") VALUES('dw_log_operation_error','dw_log_operation_error','操作異常日誌','N',null,'N','N');
INSERT INTO "DW_RDBMS_TABLES"("TABLE_NAME","TABLE_DISPLAY_NAME","TABLE_DESCRIPTION","DELETE_CONSTRAINT","HINT_FIELD","INSERT_DEFAULT_VALUE","UPDATE_DEFAULT_VALUE") VALUES('dw_log_operation_sql','dw_log_operation_sql','操作日誌SQL','N',null,'N','N');
INSERT INTO "DW_RDBMS_TABLES"("TABLE_NAME","TABLE_DISPLAY_NAME","TABLE_DESCRIPTION","DELETE_CONSTRAINT","HINT_FIELD","INSERT_DEFAULT_VALUE","UPDATE_DEFAULT_VALUE") VALUES('dw_menu','dw_menu','菜单','N',null,'N','N');
INSERT INTO "DW_RDBMS_TABLES"("TABLE_NAME","TABLE_DISPLAY_NAME","TABLE_DESCRIPTION","DELETE_CONSTRAINT","HINT_FIELD","INSERT_DEFAULT_VALUE","UPDATE_DEFAULT_VALUE") VALUES('dw_menu_language','dw_menu_language','菜单多语言','N',null,'N','N');
INSERT INTO "DW_RDBMS_TABLES"("TABLE_NAME","TABLE_DISPLAY_NAME","TABLE_DESCRIPTION","DELETE_CONSTRAINT","HINT_FIELD","INSERT_DEFAULT_VALUE","UPDATE_DEFAULT_VALUE") VALUES('dw_menu_parameter','dw_menu_parameter','菜单参数','N',null,'N','N');
INSERT INTO "DW_RDBMS_TABLES"("TABLE_NAME","TABLE_DISPLAY_NAME","TABLE_DESCRIPTION","DELETE_CONSTRAINT","HINT_FIELD","INSERT_DEFAULT_VALUE","UPDATE_DEFAULT_VALUE") VALUES('dw_myhome','dw_myhome','自定義首頁主表','N',null,'N','N');
INSERT INTO "DW_RDBMS_TABLES"("TABLE_NAME","TABLE_DISPLAY_NAME","TABLE_DESCRIPTION","DELETE_CONSTRAINT","HINT_FIELD","INSERT_DEFAULT_VALUE","UPDATE_DEFAULT_VALUE") VALUES('dw_myhome_parameter','dw_myhomedw_parameter','自定義首頁參數表','N',null,'N','N');
INSERT INTO "DW_RDBMS_TABLES"("TABLE_NAME","TABLE_DISPLAY_NAME","TABLE_DESCRIPTION","DELETE_CONSTRAINT","HINT_FIELD","INSERT_DEFAULT_VALUE","UPDATE_DEFAULT_VALUE") VALUES('dw_schedule','排程表','排程表','N',null,'N','N');
INSERT INTO "DW_RDBMS_TABLES"("TABLE_NAME","TABLE_DISPLAY_NAME","TABLE_DESCRIPTION","DELETE_CONSTRAINT","HINT_FIELD","INSERT_DEFAULT_VALUE","UPDATE_DEFAULT_VALUE") VALUES('dw_schedule_contact','排程寄信通知表','排程寄信通知表','N',null,'N','N');
INSERT INTO "DW_RDBMS_TABLES"("TABLE_NAME","TABLE_DISPLAY_NAME","TABLE_DESCRIPTION","DELETE_CONSTRAINT","HINT_FIELD","INSERT_DEFAULT_VALUE","UPDATE_DEFAULT_VALUE") VALUES('dw_schedule_record','排程執行記錄','排程執行記錄','N',null,'N','N');
INSERT INTO "DW_RDBMS_TABLES"("TABLE_NAME","TABLE_DISPLAY_NAME","TABLE_DESCRIPTION","DELETE_CONSTRAINT","HINT_FIELD","INSERT_DEFAULT_VALUE","UPDATE_DEFAULT_VALUE") VALUES('dw_schedule_time','排程執行時間設定檔','排程執行時間設定檔','N',null,'N','N');
INSERT INTO "DW_RDBMS_TABLES"("TABLE_NAME","TABLE_DISPLAY_NAME","TABLE_DESCRIPTION","DELETE_CONSTRAINT","HINT_FIELD","INSERT_DEFAULT_VALUE","UPDATE_DEFAULT_VALUE") VALUES('dw_theme','企業主題主表','企業主題主表','N',null,'N','N');
INSERT INTO "DW_RDBMS_TABLES"("TABLE_NAME","TABLE_DISPLAY_NAME","TABLE_DESCRIPTION","DELETE_CONSTRAINT","HINT_FIELD","INSERT_DEFAULT_VALUE","UPDATE_DEFAULT_VALUE") VALUES('dw_theme_filelog','企業主題文件上傳日誌','企業主題文件上傳日誌','N',null,'N','N');

ALTER TABLE "DW_RDBMS_TABLES" ADD CONSTRAINT  PRIMARY KEY("TABLE_NAME") ;

ALTER TABLE "DW_RDBMS_RELATIONS" ADD CONSTRAINT  PRIMARY KEY("PRIMARY_TABLE_NO","REFERENCE_TABLE_NO","PRIMARY_TABLE_PK","REFERENCE_TABLE_PK") ;

ALTER TABLE "DW_RDBMS_FIELDS" ADD CONSTRAINT  PRIMARY KEY("FIELD_NAME","TABLE_NAME") ;

ALTER TABLE "DW_QUERY_INFO" ADD CONSTRAINT  PRIMARY KEY("QUERY_ID") ;

ALTER TABLE "DW_MYHOME_PARAMETER" ADD CONSTRAINT  PRIMARY KEY("TENANTSID","USERID","LEVEL","NAME") ;

ALTER TABLE "DW_MYHOME" ADD CONSTRAINT  PRIMARY KEY("TENANTSID","USERID","LEVEL") ;

ALTER TABLE "DW_MENU_PARAMETER" ADD CONSTRAINT  PRIMARY KEY("MENU_ID","NAME") ;

ALTER TABLE "DW_MENU_LANGUAGE" ADD CONSTRAINT  PRIMARY KEY("MENU_ID","LANGUAGE") ;

ALTER TABLE "DW_MENU" ADD CONSTRAINT  PRIMARY KEY("ID") ;

ALTER TABLE "DW_CUSTOM_COLUMN" ADD CONSTRAINT  PRIMARY KEY("TENANTSID","TABLE_ID","USERID") ;

ALTER TABLE "DW_APP_UPDATE" ADD CONSTRAINT  PRIMARY KEY("APP_CODE","VERSION") ;

ALTER TABLE "DW_APP_RELEASE" ADD CONSTRAINT  PRIMARY KEY("APP_CODE","VERSION","FILE_SEQ") ;

ALTER TABLE "DW_APP_PROD" ADD CONSTRAINT  PRIMARY KEY("APP_CODE") ;

CREATE UNIQUE INDEX "INDEX2121875544015700"
ON "DW_RDBMS_TABLES"("TABLE_NAME");

COMMENT ON TABLE "DW_RDBMS_TABLES" IS '数据库资料表描述表';

COMMENT ON COLUMN "DW_RDBMS_TABLES"."TABLE_NAME" IS '资料表名';

COMMENT ON COLUMN "DW_RDBMS_TABLES"."TABLE_DISPLAY_NAME" IS '资料表外显名称';

COMMENT ON COLUMN "DW_RDBMS_TABLES"."TABLE_DESCRIPTION" IS '资料表描述';

COMMENT ON COLUMN "DW_RDBMS_TABLES"."DELETE_CONSTRAINT" IS '資料表刪除約束';

COMMENT ON COLUMN "DW_RDBMS_TABLES"."HINT_FIELD" IS '資料表刪除提示字段';

COMMENT ON COLUMN "DW_RDBMS_TABLES"."INSERT_DEFAULT_VALUE" IS '新增帶默認值選項';

COMMENT ON COLUMN "DW_RDBMS_TABLES"."UPDATE_DEFAULT_VALUE" IS '修改帶默認值選項';

CREATE UNIQUE INDEX "INDEX2121875626897799"
ON "DW_RDBMS_RELATIONS"("PRIMARY_TABLE_NO","REFERENCE_TABLE_NO","PRIMARY_TABLE_PK","REFERENCE_TABLE_PK");

COMMENT ON TABLE "DW_RDBMS_RELATIONS" IS '资料表关系表';

COMMENT ON COLUMN "DW_RDBMS_RELATIONS"."PRIMARY_TABLE_NO" IS '来源表号';

COMMENT ON COLUMN "DW_RDBMS_RELATIONS"."REFERENCE_TABLE_NO" IS '参照表号';

COMMENT ON COLUMN "DW_RDBMS_RELATIONS"."PRIMARY_TABLE_PK" IS '来源表PK';

COMMENT ON COLUMN "DW_RDBMS_RELATIONS"."REFERENCE_TABLE_PK" IS '参照表PK';

COMMENT ON COLUMN "DW_RDBMS_RELATIONS"."TYPE" IS '關聯類型';

ALTER TABLE "DW_RDBMS_FIELDS" ADD CHECK ("SEQ" >= 0) ENABLE ;

CREATE UNIQUE INDEX "INDEX2121875647061000"
ON "DW_RDBMS_FIELDS"("FIELD_NAME","TABLE_NAME");

COMMENT ON TABLE "DW_RDBMS_FIELDS" IS '数据结构资料表';

COMMENT ON COLUMN "DW_RDBMS_FIELDS"."TABLE_NAME" IS '数据表名称';

COMMENT ON COLUMN "DW_RDBMS_FIELDS"."SEQ" IS '项次';

COMMENT ON COLUMN "DW_RDBMS_FIELDS"."FIELD_NAME" IS '字段编号';

COMMENT ON COLUMN "DW_RDBMS_FIELDS"."IS_KEY" IS '主键否';

COMMENT ON COLUMN "DW_RDBMS_FIELDS"."FIELD_TYPE" IS '字段型态，备注：1.varchar;2.number;3.date;4.datetime';

COMMENT ON COLUMN "DW_RDBMS_FIELDS"."STATUS_CODE" IS '状态码:Y.有效；N.无效；';

COMMENT ON COLUMN "DW_RDBMS_FIELDS"."FIELD_DISPLAY_NAME" IS '字段名称';

COMMENT ON COLUMN "DW_RDBMS_FIELDS"."SCALE" IS '字段长度';

COMMENT ON COLUMN "DW_RDBMS_FIELDS"."DEFAULT_VALUE" IS '默认值';

COMMENT ON COLUMN "DW_RDBMS_FIELDS"."NULLABLE" IS '可否為空';

COMMENT ON COLUMN "DW_RDBMS_FIELDS"."IS_VERSION" IS '是否需要依version進行樂觀鎖';

COMMENT ON COLUMN "DW_RDBMS_FIELDS"."SIZE" IS '長度';

COMMENT ON COLUMN "DW_RDBMS_FIELDS"."IS_AUTO_INCREMENT" IS '是否為自動產生流水號';

CREATE UNIQUE INDEX "INDEX2121875672294200"
ON "DW_QUERY_INFO"("QUERY_ID");

COMMENT ON TABLE "DW_QUERY_INFO" IS '開窗信息主表';

COMMENT ON COLUMN "DW_QUERY_INFO"."QUERY_ID" IS '查詢編號';

COMMENT ON COLUMN "DW_QUERY_INFO"."QUERY_TYPE" IS '類型';

COMMENT ON COLUMN "DW_QUERY_INFO"."SQL_STATEMENT" IS 'sql';

COMMENT ON COLUMN "DW_QUERY_INFO"."PUBLISH" IS '發佈者';

COMMENT ON COLUMN "DW_QUERY_INFO"."OWNER" IS '擁有者';

COMMENT ON TABLE "DW_PLATFORM_INFO" IS '微服務平台版本資訊';

COMMENT ON COLUMN "DW_PLATFORM_INFO"."VERSION" IS '版號';

COMMENT ON COLUMN "DW_PLATFORM_INFO"."ISTENANT" IS '是否為多租戶';

COMMENT ON COLUMN "DW_PLATFORM_INFO"."VERSIONDATE" IS '版本日期';

COMMENT ON COLUMN "DW_PLATFORM_INFO"."UPDATEDATE" IS '更新日期';

CREATE UNIQUE INDEX "INDEX2121875692832199"
ON "DW_MYHOME_PARAMETER"("TENANTSID","USERID","LEVEL","NAME");

COMMENT ON TABLE "DW_MYHOME_PARAMETER" IS '自定義首頁參數表';

COMMENT ON COLUMN "DW_MYHOME_PARAMETER"."TENANTSID" IS '租戶sid';

COMMENT ON COLUMN "DW_MYHOME_PARAMETER"."LEVEL" IS '首頁層級,common/user';

COMMENT ON COLUMN "DW_MYHOME_PARAMETER"."USERID" IS '用戶id';

COMMENT ON COLUMN "DW_MYHOME_PARAMETER"."NAME" IS '參數名稱';

COMMENT ON COLUMN "DW_MYHOME_PARAMETER"."VALUE" IS '參數值';

CREATE UNIQUE INDEX "INDEX2121875762504300"
ON "DW_MYHOME"("TENANTSID","USERID","LEVEL");

COMMENT ON TABLE "DW_MYHOME" IS '自定義首頁主表';

COMMENT ON COLUMN "DW_MYHOME"."TENANTSID" IS '租戶sid';

COMMENT ON COLUMN "DW_MYHOME"."LEVEL" IS '首頁層級,common/user';

COMMENT ON COLUMN "DW_MYHOME"."USERID" IS '用戶id';

COMMENT ON COLUMN "DW_MYHOME"."VERSION" IS '版本';

COMMENT ON COLUMN "DW_MYHOME"."TYPE" IS '首頁型態,作業/報表/外部連接';

COMMENT ON COLUMN "DW_MYHOME"."PATH" IS '作業/報表/外部連接路徑';

CREATE UNIQUE INDEX "INDEX2121875777294400"
ON "DW_MENU_PARAMETER"("MENU_ID","NAME");

COMMENT ON TABLE "DW_MENU_PARAMETER" IS '菜單參數表';

COMMENT ON COLUMN "DW_MENU_PARAMETER"."MENU_ID" IS '菜單編號';

COMMENT ON COLUMN "DW_MENU_PARAMETER"."NAME" IS '參數名稱';

COMMENT ON COLUMN "DW_MENU_PARAMETER"."VALUE" IS '值';

CREATE UNIQUE INDEX "INDEX2121875788729600"
ON "DW_MENU_LANGUAGE"("MENU_ID","LANGUAGE");

COMMENT ON TABLE "DW_MENU_LANGUAGE" IS '菜單多語言信息表';

COMMENT ON COLUMN "DW_MENU_LANGUAGE"."MENU_ID" IS '菜單編號';

COMMENT ON COLUMN "DW_MENU_LANGUAGE"."LANGUAGE" IS '語言別';

COMMENT ON COLUMN "DW_MENU_LANGUAGE"."NAME" IS '名稱';

CREATE UNIQUE INDEX "INDEX2121875801106100"
ON "DW_MENU"("ID");

COMMENT ON TABLE "DW_MENU" IS '菜單主表';

COMMENT ON COLUMN "DW_MENU"."ID" IS '編號';

COMMENT ON COLUMN "DW_MENU"."TYPE" IS '型態';

COMMENT ON COLUMN "DW_MENU"."PARENT_ID" IS '父層編號';

COMMENT ON COLUMN "DW_MENU"."CODE" IS '代碼';

COMMENT ON COLUMN "DW_MENU"."SEQUENCE" IS '順序';

COMMENT ON COLUMN "DW_MENU"."ICON_CLASS" IS '圖示class';

COMMENT ON COLUMN "DW_MENU"."DEFAULT_EXPAND" IS '默認展開';

COMMENT ON COLUMN "DW_MENU"."URL" IS 'URL';

COMMENT ON COLUMN "DW_MENU"."OPEN_MODE" IS 'open 模式';

COMMENT ON COLUMN "DW_MENU"."VERSION" IS '版本';

CREATE INDEX "SEL_INDEX01"
ON "DW_LOG_OPERATION_SQL"("OPERATION_LOG_ID","TENANTSID");

CREATE UNIQUE INDEX "INDEX2121876125903899"
ON "DW_LOG_OPERATION_SQL"("LOG_ID","TENANTSID");

COMMENT ON TABLE "DW_LOG_OPERATION_SQL" IS 'sql日誌';

COMMENT ON COLUMN "DW_LOG_OPERATION_SQL"."LOG_ID" IS '主键';

COMMENT ON COLUMN "DW_LOG_OPERATION_SQL"."OPERATION_LOG_ID" IS '關聯日誌表id';

COMMENT ON COLUMN "DW_LOG_OPERATION_SQL"."LOG_TYPE" IS '日誌類型(1.操作日誌  2.調度日誌)';

COMMENT ON COLUMN "DW_LOG_OPERATION_SQL"."CMD_TABLE" IS '執行表名(预留，還可以加操作)';

COMMENT ON COLUMN "DW_LOG_OPERATION_SQL"."CMD_STATEMENT" IS '執行語句';

COMMENT ON COLUMN "DW_LOG_OPERATION_SQL"."CMD_PARAMETERS" IS '執行參數';

COMMENT ON COLUMN "DW_LOG_OPERATION_SQL"."CMD_SEQ" IS '執行顺序';

COMMENT ON COLUMN "DW_LOG_OPERATION_SQL"."CREATE_TIME" IS '創建時間';

COMMENT ON COLUMN "DW_LOG_OPERATION_SQL"."TENANTSID" IS '租戶sid';

CREATE UNIQUE INDEX "INDEX2121876169416600"
ON "DW_LOG_OPERATION_ERROR"("LOG_ID","TENANTSID");

COMMENT ON TABLE "DW_LOG_OPERATION_ERROR" IS '操作異常日誌';

COMMENT ON COLUMN "DW_LOG_OPERATION_ERROR"."LOG_ID" IS '主键';

COMMENT ON COLUMN "DW_LOG_OPERATION_ERROR"."OPERATE_NO" IS '操作流水號';

COMMENT ON COLUMN "DW_LOG_OPERATION_ERROR"."OPERATE_TYPE" IS '操作類型(1:pc 2：pda)';

COMMENT ON COLUMN "DW_LOG_OPERATION_ERROR"."OPERATE_DESC" IS '操作名稱';

COMMENT ON COLUMN "DW_LOG_OPERATION_ERROR"."ERROR_TYPE" IS '異常类型(1:系统異常 2:操作異常 3:集成異常)';

COMMENT ON COLUMN "DW_LOG_OPERATION_ERROR"."ERROR_MESSAGE" IS '異常資訊';

COMMENT ON COLUMN "DW_LOG_OPERATION_ERROR"."MENU" IS '選單菜單';

COMMENT ON COLUMN "DW_LOG_OPERATION_ERROR"."MODULE" IS '模組';

COMMENT ON COLUMN "DW_LOG_OPERATION_ERROR"."URL" IS '接口路徑';

COMMENT ON COLUMN "DW_LOG_OPERATION_ERROR"."INPUT_VALUE" IS '操作接口入参';

COMMENT ON COLUMN "DW_LOG_OPERATION_ERROR"."CLIENT_IP" IS '客户端ip';

COMMENT ON COLUMN "DW_LOG_OPERATION_ERROR"."TIME_CONSUME" IS '本次操作耗時(ms)';

COMMENT ON COLUMN "DW_LOG_OPERATION_ERROR"."CREATE_NAME" IS '創建人';

COMMENT ON COLUMN "DW_LOG_OPERATION_ERROR"."CREATE_TIME" IS '創建時間';

COMMENT ON COLUMN "DW_LOG_OPERATION_ERROR"."UPDATE_NAME" IS '更新人';

COMMENT ON COLUMN "DW_LOG_OPERATION_ERROR"."UPDATE_TIME" IS '更新時間';

COMMENT ON COLUMN "DW_LOG_OPERATION_ERROR"."TRACEID" IS '追蹤鍵';

COMMENT ON COLUMN "DW_LOG_OPERATION_ERROR"."PROG_IMPL" IS '代碼方法';

COMMENT ON COLUMN "DW_LOG_OPERATION_ERROR"."TENANTSID" IS '租戶sid';

CREATE UNIQUE INDEX "INDEX2121876202342399"
ON "DW_LOG_OPERATION"("LOG_ID","TENANTSID");

COMMENT ON TABLE "DW_LOG_OPERATION" IS '操作日誌';

COMMENT ON COLUMN "DW_LOG_OPERATION"."LOG_ID" IS '主键';

COMMENT ON COLUMN "DW_LOG_OPERATION"."OPERATE_NO" IS '操作流水號';

COMMENT ON COLUMN "DW_LOG_OPERATION"."OPERATE_TYPE" IS '操作類型(1:pc 2：pda)';

COMMENT ON COLUMN "DW_LOG_OPERATION"."OPERATE_DESC" IS '操作名稱';

COMMENT ON COLUMN "DW_LOG_OPERATION"."MENU" IS '選單菜單';

COMMENT ON COLUMN "DW_LOG_OPERATION"."MODULE" IS '模組';

COMMENT ON COLUMN "DW_LOG_OPERATION"."URL" IS '接口路徑';

COMMENT ON COLUMN "DW_LOG_OPERATION"."INPUT_VALUE" IS '操作接口入参';

COMMENT ON COLUMN "DW_LOG_OPERATION"."RETURN_VALUE" IS '操作接口回參';

COMMENT ON COLUMN "DW_LOG_OPERATION"."CLIENT_IP" IS '客户端ip';

COMMENT ON COLUMN "DW_LOG_OPERATION"."TIME_CONSUME" IS '本次操作耗時(ms)';

COMMENT ON COLUMN "DW_LOG_OPERATION"."STATUS" IS '操作狀態';

COMMENT ON COLUMN "DW_LOG_OPERATION"."REMARK" IS '備註';

COMMENT ON COLUMN "DW_LOG_OPERATION"."CREATE_NAME" IS '創建人';

COMMENT ON COLUMN "DW_LOG_OPERATION"."CREATE_TIME" IS '創建時間';

COMMENT ON COLUMN "DW_LOG_OPERATION"."UPDATE_NAME" IS '更新人';

COMMENT ON COLUMN "DW_LOG_OPERATION"."UPDATE_TIME" IS '更新時間';

COMMENT ON COLUMN "DW_LOG_OPERATION"."TRACEID" IS '追蹤鍵';

COMMENT ON COLUMN "DW_LOG_OPERATION"."TENANTSID" IS '租戶sid';

CREATE UNIQUE INDEX "INDEX2121876297431900"
ON "DW_CUSTOM_COLUMN"("TENANTSID","TABLE_ID","USERID");

COMMENT ON COLUMN "DW_CUSTOM_COLUMN"."TENANTSID" IS '租戶sid';

COMMENT ON COLUMN "DW_CUSTOM_COLUMN"."TABLE_ID" IS '表格id';

COMMENT ON COLUMN "DW_CUSTOM_COLUMN"."USERID" IS '用戶id';

COMMENT ON COLUMN "DW_CUSTOM_COLUMN"."CONFIG" IS '�t�m���e';

CREATE UNIQUE INDEX "INDEX2121876308466199"
ON "DW_APP_UPDATE"("APP_CODE","VERSION");

COMMENT ON TABLE "DW_APP_UPDATE" IS '應用更新版本對應';

COMMENT ON COLUMN "DW_APP_UPDATE"."APP_CODE" IS '應用產品線代碼';

COMMENT ON COLUMN "DW_APP_UPDATE"."VERSION" IS '版號';

COMMENT ON COLUMN "DW_APP_UPDATE"."ALLOW_UPD_VERSION" IS '允許版更的版本列表[分號分隔]';

COMMENT ON COLUMN "DW_APP_UPDATE"."ALLOW_UPD_EXPR" IS '允許版更的版本表達式';

CREATE UNIQUE INDEX "INDEX2121876321599700"
ON "DW_APP_RELEASE"("APP_CODE","VERSION","FILE_SEQ");

COMMENT ON TABLE "DW_APP_RELEASE" IS '應用版本發布與釋出';

COMMENT ON COLUMN "DW_APP_RELEASE"."APP_CODE" IS '應用產品線代碼';

COMMENT ON COLUMN "DW_APP_RELEASE"."VERSION" IS '版號';

COMMENT ON COLUMN "DW_APP_RELEASE"."FILE_SEQ" IS '檔案序號';

COMMENT ON COLUMN "DW_APP_RELEASE"."FILE_ID" IS '放在文檔中心的檔案id';

COMMENT ON COLUMN "DW_APP_RELEASE"."PUBLISHED" IS '正式發布';

COMMENT ON COLUMN "DW_APP_RELEASE"."FILE_NAME" IS '放在文檔中心的檔案名稱';

CREATE UNIQUE INDEX "INDEX2121876338486299"
ON "DW_APP_PROD"("APP_CODE");

COMMENT ON TABLE "DW_APP_PROD" IS '應用產品線';

COMMENT ON COLUMN "DW_APP_PROD"."APP_CODE" IS '應用產品線代碼';

COMMENT ON COLUMN "DW_APP_PROD"."DESCRIPTION" IS '說明資料';

CREATE TABLE "DW_SCHEDULE"
(
 "SCHEDULE_ID" VARCHAR(50) NOT NULL,
 "SCHEDULE_NAME" VARCHAR(50) DEFAULT ''
 NULL,
 "JOB_NAME" VARCHAR(50) NULL,
 "SCHEDULE_TYPE" VARCHAR(1) DEFAULT ''
 NOT NULL,
 "ENABLE_STATUS" VARCHAR(1) DEFAULT 'Y'
 NOT NULL,
 "DESCRIPTION" VARCHAR(100) NULL,
 "EFFECTIVE_TIME" TIMESTAMP(0) NULL,
 "EXPIRE_TIME" TIMESTAMP(0) NULL,
 "MAX_RUNTIME" INT NULL,
 "SCHEDULE_PARAM" TEXT NULL,
 "RECENT_STATUS" VARCHAR(255) DEFAULT ''
 NULL,
 "LAST_SUCCESS_TIME" TIMESTAMP(0) NULL,
 "LAST_PERIOD_TIME" INT NULL,
 "NEXT_EXECUTE_TIME" TIMESTAMP(0) NULL,
 "PROGRAM_CODE" VARCHAR(50) NULL,
 "TENANTSID" BIGINT NOT NULL,
 "MODULE_NAME" VARCHAR(50) NULL
);

ALTER TABLE "DW_SCHEDULE" ADD CONSTRAINT  PRIMARY KEY("SCHEDULE_ID","TENANTSID") ;

CREATE UNIQUE INDEX "INDEX2121875513969900"
ON "DW_SCHEDULE"("SCHEDULE_ID","TENANTSID");

COMMENT ON TABLE "DW_SCHEDULE" IS '排程表';

COMMENT ON COLUMN "DW_SCHEDULE"."SCHEDULE_ID" IS '排程編號';

COMMENT ON COLUMN "DW_SCHEDULE"."SCHEDULE_NAME" IS '排程名稱';

COMMENT ON COLUMN "DW_SCHEDULE"."JOB_NAME" IS '工作名稱';

COMMENT ON COLUMN "DW_SCHEDULE"."SCHEDULE_TYPE" IS '排程類型 1.指定時間背景執行 2.周期執行';

COMMENT ON COLUMN "DW_SCHEDULE"."ENABLE_STATUS" IS '啟用狀態 Y/N';

COMMENT ON COLUMN "DW_SCHEDULE"."DESCRIPTION" IS '描述';

COMMENT ON COLUMN "DW_SCHEDULE"."EFFECTIVE_TIME" IS '排程生效時間';

COMMENT ON COLUMN "DW_SCHEDULE"."EXPIRE_TIME" IS '排程失效時間';

COMMENT ON COLUMN "DW_SCHEDULE"."MAX_RUNTIME" IS '最長執行時間(分鐘)';

COMMENT ON COLUMN "DW_SCHEDULE"."SCHEDULE_PARAM" IS '參數';

COMMENT ON COLUMN "DW_SCHEDULE"."RECENT_STATUS" IS '近期狀態';

COMMENT ON COLUMN "DW_SCHEDULE"."LAST_SUCCESS_TIME" IS '上次成功時間';

COMMENT ON COLUMN "DW_SCHEDULE"."LAST_PERIOD_TIME" IS '上次執行時間';

COMMENT ON COLUMN "DW_SCHEDULE"."NEXT_EXECUTE_TIME" IS '下次執行時間';

COMMENT ON COLUMN "DW_SCHEDULE"."PROGRAM_CODE" IS '作業編號';

COMMENT ON COLUMN "DW_SCHEDULE"."TENANTSID" IS '租戶sid';

COMMENT ON COLUMN "DW_SCHEDULE"."MODULE_NAME" IS '模組名稱';

CREATE TABLE "DW_SCHEDULE_CONTACT"
(
"ID" INT IDENTITY(1, 1) NOT NULL,
"SCHEDULE_ID" VARCHAR(50) DEFAULT '' NOT NULL,
"MAIL_TYPE" VARCHAR(10),
"MAIL_SUBJECT" VARCHAR(255) DEFAULT '',
"MAIL_CONTENT" VARCHAR(255) DEFAULT '',
"RECEIVER_EMAIL" VARCHAR(255) DEFAULT '',
"SEND_CONDITION" VARCHAR(50) DEFAULT '',
"TENANTSID" BIGINT NOT NULL,
NOT CLUSTER PRIMARY KEY("ID")) STORAGE(ON "MAIN", CLUSTERBTR) ;

COMMENT ON TABLE "DW_SCHEDULE_CONTACT" IS '排程寄信通知表';
COMMENT ON COLUMN "DW_SCHEDULE_CONTACT"."ID" IS '編號';
COMMENT ON COLUMN "DW_SCHEDULE_CONTACT"."MAIL_CONTENT" IS '寄件內容';
COMMENT ON COLUMN "DW_SCHEDULE_CONTACT"."MAIL_SUBJECT" IS '寄件主題';
COMMENT ON COLUMN "DW_SCHEDULE_CONTACT"."MAIL_TYPE" IS '寄件形式';
COMMENT ON COLUMN "DW_SCHEDULE_CONTACT"."RECEIVER_EMAIL" IS '收件人email地址';
COMMENT ON COLUMN "DW_SCHEDULE_CONTACT"."SCHEDULE_ID" IS '排程編號';
COMMENT ON COLUMN "DW_SCHEDULE_CONTACT"."SEND_CONDITION" IS '寄信條件';
COMMENT ON COLUMN "DW_SCHEDULE_CONTACT"."TENANTSID" IS '租戶sid';


CREATE UNIQUE  INDEX "INDEX2121875494553400" ON "DW_SCHEDULE_CONTACT"("ID" ASC) STORAGE(ON "MAIN", CLUSTERBTR) ;

CREATE TABLE "DW_UI_METADATA"
(
 "OPERATION_ID" VARCHAR(80) NOT NULL,
 "TABLE_NAME" VARCHAR(45) NOT NULL,
 "FIELD_ID" VARCHAR(45) NOT NULL,
 "LENGTH" INT NULL,
 "NULLABLE" VARCHAR(45) NULL,
 "FORMAT" VARCHAR(80) NULL,
 "ENUM" VARCHAR(80) NULL,
 "RESOURCE" VARCHAR(200) NULL
);

CREATE TABLE "DW_THEME_FILELOG"
(
 "FILEID" VARCHAR(50) NOT NULL,
 "CREATE_TIME" TIMESTAMP(0) DEFAULT current_timestamp()
 NOT NULL,
 "MESSEGE" VARCHAR(500) NULL,
  CLUSTER PRIMARY KEY("FILEID") ENABLE
);

CREATE TABLE "DW_THEME"
(
 "TENANTSID" BIGINT NOT NULL,
 "PROP" VARCHAR(50) NOT NULL,
 "VALUE" VARCHAR(500) NULL,
 "USERID" VARCHAR(50) NULL
);

CREATE TABLE "DW_SCHEDULE_TIME"
(
 "SCHEDULE_ID" VARCHAR(50) NOT NULL,
 "MONTH" VARCHAR(255) DEFAULT ''
 NULL,
 "WEEK_OF_MONTH" VARCHAR(255) DEFAULT ''
 NULL,
 "WEEK" VARCHAR(255) DEFAULT ''
 NULL,
 "DAY_OF_MONTH" VARCHAR(255) NULL,
 "ASSIGN_TIME" VARCHAR(255) DEFAULT ''
 NULL,
 "TIME" VARCHAR(255) NULL,
 "HOLIDAY" VARCHAR(255) NULL,
 "TIME1" VARCHAR(255) DEFAULT ''
 NULL,
 "TIME2" VARCHAR(255) DEFAULT ''
 NULL,
 "TIME3" VARCHAR(255) DEFAULT ''
 NULL,
 "IS_ALLOW_CONCURRENT" VARCHAR(1) DEFAULT ''
 NULL,
 "DAY_RADIO" VARCHAR(1) NULL,
 "MONTH_RADIO" VARCHAR(1) NULL,
 "TIME_RADIO" VARCHAR(1) NULL,
 "WEEK_RADIO" VARCHAR(1) NULL,
 "FREQUENCY" INT NULL,
 "REPEAT_TYPE" INT NULL,
 "START_TIME" TIMESTAMP(0) NULL,
 "END_TIME" TIMESTAMP(0) NULL,
 "REPEAT_COUNT" INT NULL,
 "MINUTELY" INT NULL,
 "HOURLY" INT NULL,
 "DAILY" INT NULL,
 "WEEKLY" INT NULL,
 "BYDAY" VARCHAR(255) NULL,
 "MONTHLY" INT NULL,
 "BYMONTHDAY" VARCHAR(255) NULL,
 "BYWEEKLYDAY" VARCHAR(255) NULL,
 "EXCLUDE_DATE" VARCHAR(255) NULL,
 "EXCLUDE_TIME" VARCHAR(255) NULL,
 "RETRY_AFTER_MISFIRE_SEC" INT NULL,
 "IS_RETRY" VARCHAR(1) DEFAULT 'Y'
 NOT NULL,
 "TENANTSID" BIGINT NOT NULL
);

CREATE TABLE "DW_SCHEDULE_RECORD"
(
 "EXECUTE_ID" VARCHAR(128) NOT NULL,
 "SCHEDULE_ID" VARCHAR(50) NOT NULL,
 "JOB_NAME" VARCHAR(50) DEFAULT ''
 NOT NULL,
 "EXECUTE_STATUS" VARCHAR(10) DEFAULT ''
 NULL,
 "MESSAGE" TEXT NULL,
 "MESSAGE_DETAIL" TEXT NULL,
 "START_TIME" TIMESTAMP(0) NOT NULL,
 "END_TIME" TIMESTAMP(0) NULL,
 "SCHEDULE_PARAM" TEXT NULL,
 "SCHEDULE_TYPE" VARCHAR(1) DEFAULT ''
 NULL,
 "IS_MISFIRE" VARCHAR(1) DEFAULT 'N'
 NULL,
 "PROGRAM_CODE" VARCHAR(50) NULL,
 "SCHEDULE_NAME" VARCHAR(50) NULL,
 "EXECUTOR" VARCHAR(50) NULL,
 "TENANTSID" BIGINT NOT NULL
);

ALTER TABLE "DW_UI_METADATA" ADD CONSTRAINT  PRIMARY KEY("OPERATION_ID","TABLE_NAME","FIELD_ID") ;

ALTER TABLE "DW_THEME" ADD CONSTRAINT  PRIMARY KEY("TENANTSID","PROP") ;

ALTER TABLE "DW_SCHEDULE_TIME" ADD CONSTRAINT  PRIMARY KEY("SCHEDULE_ID","TENANTSID") ;

ALTER TABLE "DW_SCHEDULE_RECORD" ADD CONSTRAINT  PRIMARY KEY("EXECUTE_ID","TENANTSID") ;

CREATE UNIQUE INDEX "INDEX2121875279170300"
ON "DW_UI_METADATA"("OPERATION_ID","TABLE_NAME","FIELD_ID");

COMMENT ON TABLE "DW_UI_METADATA" IS '使用者介面元數據';

COMMENT ON COLUMN "DW_UI_METADATA"."OPERATION_ID" IS 'ui編號';

COMMENT ON COLUMN "DW_UI_METADATA"."TABLE_NAME" IS '表名稱';

COMMENT ON COLUMN "DW_UI_METADATA"."FIELD_ID" IS '字段名稱';

COMMENT ON COLUMN "DW_UI_METADATA"."LENGTH" IS '長度';

COMMENT ON COLUMN "DW_UI_METADATA"."NULLABLE" IS '允許為null';

COMMENT ON COLUMN "DW_UI_METADATA"."FORMAT" IS '格式';

COMMENT ON COLUMN "DW_UI_METADATA"."ENUM" IS '枚舉值';

COMMENT ON COLUMN "DW_UI_METADATA"."RESOURCE" IS '來源';

CREATE UNIQUE INDEX "INDEX2121875301606400"
ON "DW_THEME_FILELOG"("FILEID");

COMMENT ON COLUMN "DW_THEME_FILELOG"."FILEID" IS '文件ID(DMC)';

COMMENT ON COLUMN "DW_THEME_FILELOG"."CREATE_TIME" IS '創建時間';

COMMENT ON COLUMN "DW_THEME_FILELOG"."MESSEGE" IS '描述';

CREATE UNIQUE INDEX "INDEX2121875313643000"
ON "DW_THEME"("TENANTSID","PROP");

COMMENT ON COLUMN "DW_THEME"."TENANTSID" IS '租戶sid';

COMMENT ON COLUMN "DW_THEME"."PROP" IS '屬性key名稱';

COMMENT ON COLUMN "DW_THEME"."VALUE" IS '屬性值';

COMMENT ON COLUMN "DW_THEME"."USERID" IS '用戶id';

CREATE UNIQUE INDEX "INDEX2121875327383299"
ON "DW_SCHEDULE_TIME"("SCHEDULE_ID","TENANTSID");

COMMENT ON TABLE "DW_SCHEDULE_TIME" IS '排程執行時間設定檔';

COMMENT ON COLUMN "DW_SCHEDULE_TIME"."SCHEDULE_ID" IS '執行編號';

COMMENT ON COLUMN "DW_SCHEDULE_TIME"."MONTH" IS '月份';

COMMENT ON COLUMN "DW_SCHEDULE_TIME"."WEEK_OF_MONTH" IS '每個月第幾個星期';

COMMENT ON COLUMN "DW_SCHEDULE_TIME"."WEEK" IS '星期幾';

COMMENT ON COLUMN "DW_SCHEDULE_TIME"."DAY_OF_MONTH" IS '每個月第幾天';

COMMENT ON COLUMN "DW_SCHEDULE_TIME"."ASSIGN_TIME" IS '指定時間';

COMMENT ON COLUMN "DW_SCHEDULE_TIME"."TIME" IS '週期性指定時間';

COMMENT ON COLUMN "DW_SCHEDULE_TIME"."HOLIDAY" IS '假日處理模式';

COMMENT ON COLUMN "DW_SCHEDULE_TIME"."TIME1" IS '時間區間一';

COMMENT ON COLUMN "DW_SCHEDULE_TIME"."TIME2" IS '時間區間二';

COMMENT ON COLUMN "DW_SCHEDULE_TIME"."TIME3" IS '時間區間三';

COMMENT ON COLUMN "DW_SCHEDULE_TIME"."IS_ALLOW_CONCURRENT" IS '是否允許併發 Y/N';

COMMENT ON COLUMN "DW_SCHEDULE_TIME"."DAY_RADIO" IS '日頻次';

COMMENT ON COLUMN "DW_SCHEDULE_TIME"."MONTH_RADIO" IS '月頻次';

COMMENT ON COLUMN "DW_SCHEDULE_TIME"."TIME_RADIO" IS '時間頻次';

COMMENT ON COLUMN "DW_SCHEDULE_TIME"."WEEK_RADIO" IS '周頻次';

COMMENT ON COLUMN "DW_SCHEDULE_TIME"."FREQUENCY" IS '週期頻率';

COMMENT ON COLUMN "DW_SCHEDULE_TIME"."REPEAT_TYPE" IS '區間類型  1.每幾分 2.每幾小時 3.每幾天';

COMMENT ON COLUMN "DW_SCHEDULE_TIME"."START_TIME" IS '開始日期';

COMMENT ON COLUMN "DW_SCHEDULE_TIME"."END_TIME" IS '結束日期';

COMMENT ON COLUMN "DW_SCHEDULE_TIME"."REPEAT_COUNT" IS '執行次數';

COMMENT ON COLUMN "DW_SCHEDULE_TIME"."MINUTELY" IS '每n分';

COMMENT ON COLUMN "DW_SCHEDULE_TIME"."HOURLY" IS '每n時';

COMMENT ON COLUMN "DW_SCHEDULE_TIME"."DAILY" IS '每n天';

COMMENT ON COLUMN "DW_SCHEDULE_TIME"."WEEKLY" IS '每n週';

COMMENT ON COLUMN "DW_SCHEDULE_TIME"."BYDAY" IS '星期n';

COMMENT ON COLUMN "DW_SCHEDULE_TIME"."MONTHLY" IS '每n月';

COMMENT ON COLUMN "DW_SCHEDULE_TIME"."BYMONTHDAY" IS '當月中的第n天';

COMMENT ON COLUMN "DW_SCHEDULE_TIME"."BYWEEKLYDAY" IS '當月中的第n個星期m';

COMMENT ON COLUMN "DW_SCHEDULE_TIME"."EXCLUDE_DATE" IS '例外日期';

COMMENT ON COLUMN "DW_SCHEDULE_TIME"."EXCLUDE_TIME" IS '例外時間';

COMMENT ON COLUMN "DW_SCHEDULE_TIME"."RETRY_AFTER_MISFIRE_SEC" IS 'misfire幾秒後重試';

COMMENT ON COLUMN "DW_SCHEDULE_TIME"."IS_RETRY" IS '是否在misfire後重試';

COMMENT ON COLUMN "DW_SCHEDULE_TIME"."TENANTSID" IS '租戶sid';

CREATE UNIQUE INDEX "INDEX2121875467743700"
ON "DW_SCHEDULE_RECORD"("EXECUTE_ID","TENANTSID");

COMMENT ON TABLE "DW_SCHEDULE_RECORD" IS '排程執行記錄';

COMMENT ON COLUMN "DW_SCHEDULE_RECORD"."EXECUTE_ID" IS '執行編號';

COMMENT ON COLUMN "DW_SCHEDULE_RECORD"."SCHEDULE_ID" IS '排程編號';

COMMENT ON COLUMN "DW_SCHEDULE_RECORD"."JOB_NAME" IS '工作名稱';

COMMENT ON COLUMN "DW_SCHEDULE_RECORD"."EXECUTE_STATUS" IS '執行狀態 ';

COMMENT ON COLUMN "DW_SCHEDULE_RECORD"."MESSAGE" IS '訊息id';

COMMENT ON COLUMN "DW_SCHEDULE_RECORD"."MESSAGE_DETAIL" IS '詳細訊息';

COMMENT ON COLUMN "DW_SCHEDULE_RECORD"."START_TIME" IS '執行開始時間';

COMMENT ON COLUMN "DW_SCHEDULE_RECORD"."END_TIME" IS '執行結束時間';

COMMENT ON COLUMN "DW_SCHEDULE_RECORD"."SCHEDULE_PARAM" IS '執行參數';

COMMENT ON COLUMN "DW_SCHEDULE_RECORD"."SCHEDULE_TYPE" IS '排程類型 1.指定時間背景執行 2.周期執行';

COMMENT ON COLUMN "DW_SCHEDULE_RECORD"."IS_MISFIRE" IS '是否為misfire後重試';

COMMENT ON COLUMN "DW_SCHEDULE_RECORD"."PROGRAM_CODE" IS '作業編號';

COMMENT ON COLUMN "DW_SCHEDULE_RECORD"."SCHEDULE_NAME" IS '排程名稱';

COMMENT ON COLUMN "DW_SCHEDULE_RECORD"."EXECUTOR" IS '執行者';

COMMENT ON COLUMN "DW_SCHEDULE_RECORD"."TENANTSID" IS '租戶sid';

CREATE TABLE "QRTZ_TRIGGERS"
(
 "SCHED_NAME" VARCHAR(120) NOT NULL,
 "TRIGGER_NAME" VARCHAR(200) NOT NULL,
 "TRIGGER_GROUP" VARCHAR(200) NOT NULL,
 "JOB_NAME" VARCHAR(200) NOT NULL,
 "JOB_GROUP" VARCHAR(200) NOT NULL,
 "DESCRIPTION" VARCHAR(250) NULL,
 "NEXT_FIRE_TIME" BIGINT NULL,
 "PREV_FIRE_TIME" BIGINT NULL,
 "PRIORITY" INT NULL,
 "TRIGGER_STATE" VARCHAR(16) NOT NULL,
 "TRIGGER_TYPE" VARCHAR(8) NOT NULL,
 "START_TIME" BIGINT NOT NULL,
 "END_TIME" BIGINT NULL,
 "CALENDAR_NAME" VARCHAR(200) NULL,
 "MISFIRE_INSTR" SMALLINT NULL,
 "JOB_DATA" BLOB NULL
);

CREATE TABLE "QRTZ_SIMPROP_TRIGGERS"
(
 "SCHED_NAME" VARCHAR(120) NOT NULL,
 "TRIGGER_NAME" VARCHAR(200) NOT NULL,
 "TRIGGER_GROUP" VARCHAR(200) NOT NULL,
 "STR_PROP_1" VARCHAR(512) NULL,
 "STR_PROP_2" VARCHAR(512) NULL,
 "STR_PROP_3" VARCHAR(512) NULL,
 "INT_PROP_1" INT NULL,
 "INT_PROP_2" INT NULL,
 "LONG_PROP_1" BIGINT NULL,
 "LONG_PROP_2" BIGINT NULL,
 "DEC_PROP_1" DEC(13,4) NULL,
 "DEC_PROP_2" DEC(13,4) NULL,
 "BOOL_PROP_1" VARCHAR(1) NULL,
 "BOOL_PROP_2" VARCHAR(1) NULL
);

CREATE TABLE "QRTZ_SIMPLE_TRIGGERS"
(
 "SCHED_NAME" VARCHAR(120) NOT NULL,
 "TRIGGER_NAME" VARCHAR(200) NOT NULL,
 "TRIGGER_GROUP" VARCHAR(200) NOT NULL,
 "REPEAT_COUNT" BIGINT NOT NULL,
 "REPEAT_INTERVAL" BIGINT NOT NULL,
 "TIMES_TRIGGERED" BIGINT NOT NULL
);

CREATE TABLE "QRTZ_SCHEDULER_STATE"
(
 "SCHED_NAME" VARCHAR(120) NOT NULL,
 "INSTANCE_NAME" VARCHAR(200) NOT NULL,
 "LAST_CHECKIN_TIME" BIGINT NOT NULL,
 "CHECKIN_INTERVAL" BIGINT NOT NULL
);

CREATE TABLE "QRTZ_PAUSED_TRIGGER_GRPS"
(
 "SCHED_NAME" VARCHAR(120) NOT NULL,
 "TRIGGER_GROUP" VARCHAR(200) NOT NULL
);

CREATE TABLE "QRTZ_LOCKS"
(
 "SCHED_NAME" VARCHAR(120) NOT NULL,
 "LOCK_NAME" VARCHAR(40) NOT NULL
);

CREATE TABLE "QRTZ_JOB_DETAILS"
(
 "SCHED_NAME" VARCHAR(120) NOT NULL,
 "JOB_NAME" VARCHAR(200) NOT NULL,
 "JOB_GROUP" VARCHAR(200) NOT NULL,
 "DESCRIPTION" VARCHAR(250) NULL,
 "JOB_CLASS_NAME" VARCHAR(250) NOT NULL,
 "IS_DURABLE" VARCHAR(1) NOT NULL,
 "IS_NONCONCURRENT" VARCHAR(1) NOT NULL,
 "IS_UPDATE_DATA" VARCHAR(1) NOT NULL,
 "REQUESTS_RECOVERY" VARCHAR(1) NOT NULL,
 "JOB_DATA" BLOB NULL
);

CREATE TABLE "QRTZ_FIRED_TRIGGERS"
(
 "SCHED_NAME" VARCHAR(120) NOT NULL,
 "ENTRY_ID" VARCHAR(95) NOT NULL,
 "TRIGGER_NAME" VARCHAR(200) NOT NULL,
 "TRIGGER_GROUP" VARCHAR(200) NOT NULL,
 "INSTANCE_NAME" VARCHAR(200) NOT NULL,
 "FIRED_TIME" BIGINT NOT NULL,
 "SCHED_TIME" DEC(28,0) NULL,
 "PRIORITY" INT NOT NULL,
 "STATE" VARCHAR(16) NOT NULL,
 "JOB_NAME" VARCHAR(200) NULL,
 "JOB_GROUP" VARCHAR(200) NULL,
 "IS_NONCONCURRENT" VARCHAR(1) NULL,
 "REQUESTS_RECOVERY" VARCHAR(1) NULL
);

CREATE TABLE "QRTZ_CRON_TRIGGERS"
(
 "SCHED_NAME" VARCHAR(120) NOT NULL,
 "TRIGGER_NAME" VARCHAR(200) NOT NULL,
 "TRIGGER_GROUP" VARCHAR(200) NOT NULL,
 "CRON_EXPRESSION" VARCHAR(200) NOT NULL,
 "TIME_ZONE_ID" VARCHAR(80) NULL
);

CREATE TABLE "QRTZ_CALENDARS"
(
 "SCHED_NAME" VARCHAR(120) NOT NULL,
 "CALENDAR_NAME" VARCHAR(200) NOT NULL,
 "CALENDAR" BLOB NOT NULL
);

CREATE TABLE "QRTZ_BLOB_TRIGGERS"
(
 "SCHED_NAME" VARCHAR(120) NOT NULL,
 "TRIGGER_NAME" VARCHAR(200) NOT NULL,
 "TRIGGER_GROUP" VARCHAR(200) NOT NULL,
 "BLOB_DATA" BLOB NULL
);

ALTER TABLE "QRTZ_TRIGGERS" ADD CONSTRAINT  PRIMARY KEY("SCHED_NAME","TRIGGER_NAME","TRIGGER_GROUP") ;

ALTER TABLE "QRTZ_SIMPROP_TRIGGERS" ADD CONSTRAINT  PRIMARY KEY("SCHED_NAME","TRIGGER_NAME","TRIGGER_GROUP") ;

ALTER TABLE "QRTZ_SIMPLE_TRIGGERS" ADD CONSTRAINT  PRIMARY KEY("SCHED_NAME","TRIGGER_NAME","TRIGGER_GROUP") ;

ALTER TABLE "QRTZ_SCHEDULER_STATE" ADD CONSTRAINT  PRIMARY KEY("SCHED_NAME","INSTANCE_NAME") ;

ALTER TABLE "QRTZ_PAUSED_TRIGGER_GRPS" ADD CONSTRAINT  PRIMARY KEY("SCHED_NAME","TRIGGER_GROUP") ;

ALTER TABLE "QRTZ_LOCKS" ADD CONSTRAINT  PRIMARY KEY("SCHED_NAME","LOCK_NAME") ;

ALTER TABLE "QRTZ_JOB_DETAILS" ADD CONSTRAINT  PRIMARY KEY("SCHED_NAME","JOB_NAME","JOB_GROUP") ;

ALTER TABLE "QRTZ_FIRED_TRIGGERS" ADD CONSTRAINT  PRIMARY KEY("SCHED_NAME","ENTRY_ID") ;

ALTER TABLE "QRTZ_CRON_TRIGGERS" ADD CONSTRAINT  PRIMARY KEY("SCHED_NAME","TRIGGER_NAME","TRIGGER_GROUP") ;

ALTER TABLE "QRTZ_CALENDARS" ADD CONSTRAINT  PRIMARY KEY("SCHED_NAME","CALENDAR_NAME") ;

ALTER TABLE "QRTZ_BLOB_TRIGGERS" ADD CONSTRAINT  PRIMARY KEY("SCHED_NAME","TRIGGER_NAME","TRIGGER_GROUP") ;

ALTER TABLE "QRTZ_TRIGGERS" ADD CONSTRAINT "QRTZ_TRIGGERS_IBFK_1" FOREIGN KEY("SCHED_NAME","JOB_NAME","JOB_GROUP") REFERENCES "QRTZ_JOB_DETAILS"("SCHED_NAME","JOB_NAME","JOB_GROUP") ;

ALTER TABLE "QRTZ_SIMPROP_TRIGGERS" ADD CONSTRAINT "QRTZ_SIMPROP_TRIGGERS_IBFK_1" FOREIGN KEY("SCHED_NAME","TRIGGER_NAME","TRIGGER_GROUP") REFERENCES "QRTZ_TRIGGERS"("SCHED_NAME","TRIGGER_NAME","TRIGGER_GROUP") ;

ALTER TABLE "QRTZ_SIMPLE_TRIGGERS" ADD CONSTRAINT "QRTZ_SIMPLE_TRIGGERS_IBFK_1" FOREIGN KEY("SCHED_NAME","TRIGGER_NAME","TRIGGER_GROUP") REFERENCES "QRTZ_TRIGGERS"("SCHED_NAME","TRIGGER_NAME","TRIGGER_GROUP") ;

ALTER TABLE "QRTZ_CRON_TRIGGERS" ADD CONSTRAINT "QRTZ_CRON_TRIGGERS_IBFK_1" FOREIGN KEY("SCHED_NAME","TRIGGER_NAME","TRIGGER_GROUP") REFERENCES "QRTZ_TRIGGERS"("SCHED_NAME","TRIGGER_NAME","TRIGGER_GROUP") ;

ALTER TABLE "QRTZ_BLOB_TRIGGERS" ADD CONSTRAINT "QRTZ_BLOB_TRIGGERS_IBFK_1" FOREIGN KEY("SCHED_NAME","TRIGGER_NAME","TRIGGER_GROUP") REFERENCES "QRTZ_TRIGGERS"("SCHED_NAME","TRIGGER_NAME","TRIGGER_GROUP") ;

CREATE INDEX "SCHED_NAME"
ON "QRTZ_TRIGGERS"("SCHED_NAME","JOB_NAME","JOB_GROUP");

CREATE UNIQUE INDEX "PRIMARY"
ON "QRTZ_TRIGGERS"("SCHED_NAME","TRIGGER_NAME","TRIGGER_GROUP");

COMMENT ON TABLE "QRTZ_TRIGGERS" IS '触发器的基本信息';

COMMENT ON COLUMN "QRTZ_TRIGGERS"."SCHED_NAME" IS '计划名称';

COMMENT ON COLUMN "QRTZ_TRIGGERS"."TRIGGER_NAME" IS '触发器名称';

COMMENT ON COLUMN "QRTZ_TRIGGERS"."TRIGGER_GROUP" IS '触发器组';

COMMENT ON COLUMN "QRTZ_TRIGGERS"."JOB_NAME" IS '作业名称';

COMMENT ON COLUMN "QRTZ_TRIGGERS"."JOB_GROUP" IS '作业组';

COMMENT ON COLUMN "QRTZ_TRIGGERS"."DESCRIPTION" IS '描述';

COMMENT ON COLUMN "QRTZ_TRIGGERS"."NEXT_FIRE_TIME" IS '下次执行时间';

COMMENT ON COLUMN "QRTZ_TRIGGERS"."PREV_FIRE_TIME" IS '前一次执行时间';

COMMENT ON COLUMN "QRTZ_TRIGGERS"."PRIORITY" IS '优先权';

COMMENT ON COLUMN "QRTZ_TRIGGERS"."TRIGGER_STATE" IS '触发器状态';

COMMENT ON COLUMN "QRTZ_TRIGGERS"."TRIGGER_TYPE" IS '触发器类型';

COMMENT ON COLUMN "QRTZ_TRIGGERS"."START_TIME" IS '开始时间';

COMMENT ON COLUMN "QRTZ_TRIGGERS"."END_TIME" IS '结束时间';

COMMENT ON COLUMN "QRTZ_TRIGGERS"."CALENDAR_NAME" IS '日历名称';

COMMENT ON COLUMN "QRTZ_TRIGGERS"."MISFIRE_INSTR" IS '失败次数';

COMMENT ON COLUMN "QRTZ_TRIGGERS"."JOB_DATA" IS '作业数据';

CREATE UNIQUE INDEX "INDEX2121874885935800"
ON "QRTZ_SIMPROP_TRIGGERS"("SCHED_NAME","TRIGGER_NAME","TRIGGER_GROUP");

COMMENT ON TABLE "QRTZ_SIMPROP_TRIGGERS" IS '存储简单的Trigger屬性信息';

COMMENT ON COLUMN "QRTZ_SIMPROP_TRIGGERS"."SCHED_NAME" IS '计划名称';

COMMENT ON COLUMN "QRTZ_SIMPROP_TRIGGERS"."TRIGGER_NAME" IS '触发器名称';

COMMENT ON COLUMN "QRTZ_SIMPROP_TRIGGERS"."TRIGGER_GROUP" IS '触发器组';

COMMENT ON COLUMN "QRTZ_SIMPROP_TRIGGERS"."STR_PROP_1" IS 'String參數1';

COMMENT ON COLUMN "QRTZ_SIMPROP_TRIGGERS"."STR_PROP_2" IS 'String參數2';

COMMENT ON COLUMN "QRTZ_SIMPROP_TRIGGERS"."STR_PROP_3" IS 'String參數3';

COMMENT ON COLUMN "QRTZ_SIMPROP_TRIGGERS"."INT_PROP_1" IS 'Integer參數1';

COMMENT ON COLUMN "QRTZ_SIMPROP_TRIGGERS"."INT_PROP_2" IS 'Integer參數2';

COMMENT ON COLUMN "QRTZ_SIMPROP_TRIGGERS"."LONG_PROP_1" IS 'Long參數1';

COMMENT ON COLUMN "QRTZ_SIMPROP_TRIGGERS"."LONG_PROP_2" IS 'Long參數2';

COMMENT ON COLUMN "QRTZ_SIMPROP_TRIGGERS"."DEC_PROP_1" IS 'Decimal參數1';

COMMENT ON COLUMN "QRTZ_SIMPROP_TRIGGERS"."DEC_PROP_2" IS 'Decimal參數2';

COMMENT ON COLUMN "QRTZ_SIMPROP_TRIGGERS"."BOOL_PROP_1" IS 'Boolean參數1';

COMMENT ON COLUMN "QRTZ_SIMPROP_TRIGGERS"."BOOL_PROP_2" IS 'Boolean參數2';

CREATE UNIQUE INDEX "INDEX2121874914438200"
ON "QRTZ_SIMPLE_TRIGGERS"("SCHED_NAME","TRIGGER_NAME","TRIGGER_GROUP");

COMMENT ON TABLE "QRTZ_SIMPLE_TRIGGERS" IS '存储简单的Trigger，包括重复次数，间隔，以及已触的次数';

COMMENT ON COLUMN "QRTZ_SIMPLE_TRIGGERS"."SCHED_NAME" IS '计划名称';

COMMENT ON COLUMN "QRTZ_SIMPLE_TRIGGERS"."TRIGGER_NAME" IS '触发器名称';

COMMENT ON COLUMN "QRTZ_SIMPLE_TRIGGERS"."TRIGGER_GROUP" IS '触发器组';

COMMENT ON COLUMN "QRTZ_SIMPLE_TRIGGERS"."REPEAT_COUNT" IS '重复次数';

COMMENT ON COLUMN "QRTZ_SIMPLE_TRIGGERS"."REPEAT_INTERVAL" IS '重复间隔';

COMMENT ON COLUMN "QRTZ_SIMPLE_TRIGGERS"."TIMES_TRIGGERED" IS '触发次数';

CREATE UNIQUE INDEX "INDEX2121874980777700"
ON "QRTZ_SCHEDULER_STATE"("SCHED_NAME","INSTANCE_NAME");

COMMENT ON TABLE "QRTZ_SCHEDULER_STATE" IS '存储少量的有关 Scheduler 的状态信息，和别的Scheduler实例';

COMMENT ON COLUMN "QRTZ_SCHEDULER_STATE"."SCHED_NAME" IS '计划名称';

COMMENT ON COLUMN "QRTZ_SCHEDULER_STATE"."INSTANCE_NAME" IS '实例名称';

COMMENT ON COLUMN "QRTZ_SCHEDULER_STATE"."LAST_CHECKIN_TIME" IS '最后的检查时间';

COMMENT ON COLUMN "QRTZ_SCHEDULER_STATE"."CHECKIN_INTERVAL" IS '检查间隔';

CREATE UNIQUE INDEX "INDEX2121874994464300"
ON "QRTZ_PAUSED_TRIGGER_GRPS"("SCHED_NAME","TRIGGER_GROUP");

COMMENT ON TABLE "QRTZ_PAUSED_TRIGGER_GRPS" IS '存放暂停掉的触发器';

COMMENT ON COLUMN "QRTZ_PAUSED_TRIGGER_GRPS"."SCHED_NAME" IS '计划名称';

COMMENT ON COLUMN "QRTZ_PAUSED_TRIGGER_GRPS"."TRIGGER_GROUP" IS '触发器组';

CREATE UNIQUE INDEX "INDEX2121875057833999"
ON "QRTZ_LOCKS"("SCHED_NAME","LOCK_NAME");

COMMENT ON TABLE "QRTZ_LOCKS" IS '存储程序的悲观锁的信息';

COMMENT ON COLUMN "QRTZ_LOCKS"."SCHED_NAME" IS '计划名称';

COMMENT ON COLUMN "QRTZ_LOCKS"."LOCK_NAME" IS '锁名称';

CREATE UNIQUE INDEX "INDEX2121875069364000"
ON "QRTZ_JOB_DETAILS"("SCHED_NAME","JOB_NAME","JOB_GROUP");

COMMENT ON TABLE "QRTZ_JOB_DETAILS" IS 'job詳息信息';

COMMENT ON COLUMN "QRTZ_JOB_DETAILS"."SCHED_NAME" IS '计划名称';

COMMENT ON COLUMN "QRTZ_JOB_DETAILS"."JOB_NAME" IS '作业名称';

COMMENT ON COLUMN "QRTZ_JOB_DETAILS"."JOB_GROUP" IS '作业组';

COMMENT ON COLUMN "QRTZ_JOB_DETAILS"."DESCRIPTION" IS '描述';

COMMENT ON COLUMN "QRTZ_JOB_DETAILS"."JOB_CLASS_NAME" IS '作业程序集名称';

COMMENT ON COLUMN "QRTZ_JOB_DETAILS"."IS_DURABLE" IS '是否持久';

COMMENT ON COLUMN "QRTZ_JOB_DETAILS"."IS_NONCONCURRENT" IS '是否并行';

COMMENT ON COLUMN "QRTZ_JOB_DETAILS"."IS_UPDATE_DATA" IS '是否更新';

COMMENT ON COLUMN "QRTZ_JOB_DETAILS"."REQUESTS_RECOVERY" IS '是否要求唤醒';

COMMENT ON COLUMN "QRTZ_JOB_DETAILS"."JOB_DATA" IS '作业信息';

CREATE UNIQUE INDEX "INDEX2121875176894600"
ON "QRTZ_FIRED_TRIGGERS"("SCHED_NAME","ENTRY_ID");

COMMENT ON TABLE "QRTZ_FIRED_TRIGGERS" IS '保存已经触发的触发器状态信息';

COMMENT ON COLUMN "QRTZ_FIRED_TRIGGERS"."SCHED_NAME" IS '计划名称';

COMMENT ON COLUMN "QRTZ_FIRED_TRIGGERS"."ENTRY_ID" IS '组标识';

COMMENT ON COLUMN "QRTZ_FIRED_TRIGGERS"."TRIGGER_NAME" IS '触发器名称';

COMMENT ON COLUMN "QRTZ_FIRED_TRIGGERS"."TRIGGER_GROUP" IS '触发器组';

COMMENT ON COLUMN "QRTZ_FIRED_TRIGGERS"."INSTANCE_NAME" IS '当前实例的名称';

COMMENT ON COLUMN "QRTZ_FIRED_TRIGGERS"."FIRED_TIME" IS '当前执行时间';

COMMENT ON COLUMN "QRTZ_FIRED_TRIGGERS"."SCHED_TIME" IS '计划时间';

COMMENT ON COLUMN "QRTZ_FIRED_TRIGGERS"."PRIORITY" IS '权重';

COMMENT ON COLUMN "QRTZ_FIRED_TRIGGERS"."STATE" IS '状态';

COMMENT ON COLUMN "QRTZ_FIRED_TRIGGERS"."JOB_NAME" IS '作业名称';

COMMENT ON COLUMN "QRTZ_FIRED_TRIGGERS"."JOB_GROUP" IS '作业组';

COMMENT ON COLUMN "QRTZ_FIRED_TRIGGERS"."IS_NONCONCURRENT" IS '是否并行';

COMMENT ON COLUMN "QRTZ_FIRED_TRIGGERS"."REQUESTS_RECOVERY" IS '是否要求唤醒';

CREATE UNIQUE INDEX "INDEX2121875204429499"
ON "QRTZ_CRON_TRIGGERS"("SCHED_NAME","TRIGGER_NAME","TRIGGER_GROUP");

COMMENT ON TABLE "QRTZ_CRON_TRIGGERS" IS '存储 Cron Trigger，包括Cron表达式和时区信息';

COMMENT ON COLUMN "QRTZ_CRON_TRIGGERS"."SCHED_NAME" IS '计划名称';

COMMENT ON COLUMN "QRTZ_CRON_TRIGGERS"."TRIGGER_NAME" IS '触发器名称';

COMMENT ON COLUMN "QRTZ_CRON_TRIGGERS"."TRIGGER_GROUP" IS '触发器组';

COMMENT ON COLUMN "QRTZ_CRON_TRIGGERS"."CRON_EXPRESSION" IS '时间表达式';

COMMENT ON COLUMN "QRTZ_CRON_TRIGGERS"."TIME_ZONE_ID" IS '时区ID';

CREATE UNIQUE INDEX "INDEX2121875218524700"
ON "QRTZ_CALENDARS"("SCHED_NAME","CALENDAR_NAME");

COMMENT ON TABLE "QRTZ_CALENDARS" IS '日曆資訊';

COMMENT ON COLUMN "QRTZ_CALENDARS"."SCHED_NAME" IS '计划名称';

COMMENT ON COLUMN "QRTZ_CALENDARS"."CALENDAR_NAME" IS '触发器名称';

COMMENT ON COLUMN "QRTZ_CALENDARS"."CALENDAR" IS '日曆信息';

CREATE UNIQUE INDEX "INDEX2121875229041800"
ON "QRTZ_BLOB_TRIGGERS"("SCHED_NAME","TRIGGER_NAME","TRIGGER_GROUP");

COMMENT ON TABLE "QRTZ_BLOB_TRIGGERS" IS '自定义触发器';

COMMENT ON COLUMN "QRTZ_BLOB_TRIGGERS"."SCHED_NAME" IS '计划名称';

COMMENT ON COLUMN "QRTZ_BLOB_TRIGGERS"."TRIGGER_NAME" IS '触发器名称';

COMMENT ON COLUMN "QRTZ_BLOB_TRIGGERS"."TRIGGER_GROUP" IS '触发器组';

COMMENT ON COLUMN "QRTZ_BLOB_TRIGGERS"."BLOB_DATA" IS '保存triggers一些信息';
