CREATE TABLE "dw_lcdp_model" (
	"code" VARCHAR(100) NOT NULL  ,
	"description" VARCHAR(255) NOT NULL  ,
	"model_type" VARCHAR(10) NOT NULL DEFAULT 'cus'  ,
	"model_schema" TEXT NULL DEFAULT NULL ,
	"target_tenant_id" VARCHAR(32) NULL DEFAULT NULL ,
	"app_id" VARCHAR(100) NOT NULL ,
	"tenantsid" BIGINT NOT NULL ,
	"create_time" TIMESTAMP(0) NOT NULL DEFAULT current_timestamp ,
	"create_user_sid" BIGINT NULL DEFAULT NULL   ,
	"update_time" TIMESTAMP(0) NULL DEFAULT NULL ,
	"update_user_sid" BIGINT NULL DEFAULT NULL
);

ALTER TABLE "dw_lcdp_model" ADD CONSTRAINT lcdp_md_con_pk_model PRIMARY KEY("code", "tenantsid", "app_id") ;

COMMENT ON TABLE "dw_lcdp_model" IS '模型設計表';

COMMENT ON COLUMN "dw_lcdp_model"."code" IS '模型code';
COMMENT ON COLUMN "dw_lcdp_model"."description" IS '模型名稱';
COMMENT ON COLUMN "dw_lcdp_model"."model_type" IS '模型类型：std-标准，cus-客制';
COMMENT ON COLUMN "dw_lcdp_model"."model_schema" IS '模型数据结构';
COMMENT ON COLUMN "dw_lcdp_model"."target_tenant_id" IS '目标租户ID';
COMMENT ON COLUMN "dw_lcdp_model"."app_id" IS '應用ID';
COMMENT ON COLUMN "dw_lcdp_model"."tenantsid" IS '租户SID';
COMMENT ON COLUMN "dw_lcdp_model"."create_time" IS '创建时间';
COMMENT ON COLUMN "dw_lcdp_model"."create_user_sid" IS '创建人SID';
COMMENT ON COLUMN "dw_lcdp_model"."update_time" IS '更新时间';
COMMENT ON COLUMN "dw_lcdp_model"."update_user_sid" IS '更新人SID';

INSERT INTO "dw_rdbms_tables" ("table_name", "table_display_name", "table_description", "delete_constraint", "hint_field", "insert_default_value", "update_default_value") VALUES ('dw_lcdp_model', '模型設計表', '模型設計表', 'N', NULL, NULL, NULL);

INSERT INTO "dw_rdbms_fields" ("TABLE_NAME", "SEQ", "FIELD_NAME", "IS_KEY", "FIELD_TYPE", "STATUS_CODE", "FIELD_DISPLAY_NAME", "SCALE", "DEFAULT_VALUE", "NULLABLE", "IS_VERSION", "SIZE", "IS_AUTO_INCREMENT") VALUES ('dw_lcdp_model', 1, 'code', 'Y', 'VARCHAR', 'Y', '模型code', '0', NULL, 'N', 'N', '100', 'N');
INSERT INTO "dw_rdbms_fields" ("TABLE_NAME", "SEQ", "FIELD_NAME", "IS_KEY", "FIELD_TYPE", "STATUS_CODE", "FIELD_DISPLAY_NAME", "SCALE", "DEFAULT_VALUE", "NULLABLE", "IS_VERSION", "SIZE", "IS_AUTO_INCREMENT") VALUES ('dw_lcdp_model', 2, 'description', 'N', 'VARCHAR', 'Y', '模型名称', '0', NULL, 'N', 'N', '255', 'N');
INSERT INTO "dw_rdbms_fields" ("TABLE_NAME", "SEQ", "FIELD_NAME", "IS_KEY", "FIELD_TYPE", "STATUS_CODE", "FIELD_DISPLAY_NAME", "SCALE", "DEFAULT_VALUE", "NULLABLE", "IS_VERSION", "SIZE", "IS_AUTO_INCREMENT") VALUES ('dw_lcdp_model', 3, 'model_schema', 'N', 'JSON', 'Y', '模型数据结构', '0', NULL, 'Y', 'N', '65535', 'N');
INSERT INTO "dw_rdbms_fields" ("TABLE_NAME", "SEQ", "FIELD_NAME", "IS_KEY", "FIELD_TYPE", "STATUS_CODE", "FIELD_DISPLAY_NAME", "SCALE", "DEFAULT_VALUE", "NULLABLE", "IS_VERSION", "SIZE", "IS_AUTO_INCREMENT") VALUES ('dw_lcdp_model', 4, 'target_tenant_id', 'N', 'VARCHAR', 'Y', '目标租户ID', '0', NULL, 'N', 'N', '32', 'N');
INSERT INTO "dw_rdbms_fields" ("TABLE_NAME", "SEQ", "FIELD_NAME", "IS_KEY", "FIELD_TYPE", "STATUS_CODE", "FIELD_DISPLAY_NAME", "SCALE", "DEFAULT_VALUE", "NULLABLE", "IS_VERSION", "SIZE", "IS_AUTO_INCREMENT") VALUES ('dw_lcdp_model', 5, 'app_id', 'Y', 'VARCHAR', 'Y', '应用ID', '0', NULL, 'N', 'N', '100', 'N');
INSERT INTO "dw_rdbms_fields" ("TABLE_NAME", "SEQ", "FIELD_NAME", "IS_KEY", "FIELD_TYPE", "STATUS_CODE", "FIELD_DISPLAY_NAME", "SCALE", "DEFAULT_VALUE", "NULLABLE", "IS_VERSION", "SIZE", "IS_AUTO_INCREMENT") VALUES ('dw_lcdp_model', 6, 'tenantsid', 'Y', 'BIGINT', 'Y', '租户SID', '0', NULL, 'N', 'N', '20', 'N');
INSERT INTO "dw_rdbms_fields" ("TABLE_NAME", "SEQ", "FIELD_NAME", "IS_KEY", "FIELD_TYPE", "STATUS_CODE", "FIELD_DISPLAY_NAME", "SCALE", "DEFAULT_VALUE", "NULLABLE", "IS_VERSION", "SIZE", "IS_AUTO_INCREMENT") VALUES ('dw_lcdp_model', 7, 'create_time', 'N', 'DATETIME', 'Y', '创建时间', '0', NULL, 'N', 'N', '19', 'N');
INSERT INTO "dw_rdbms_fields" ("TABLE_NAME", "SEQ", "FIELD_NAME", "IS_KEY", "FIELD_TYPE", "STATUS_CODE", "FIELD_DISPLAY_NAME", "SCALE", "DEFAULT_VALUE", "NULLABLE", "IS_VERSION", "SIZE", "IS_AUTO_INCREMENT") VALUES ('dw_lcdp_model', 8, 'create_user_sid', 'N', 'BIGINT', 'Y', '创建人SID', '0', NULL, 'N', 'N', '20', 'N');
INSERT INTO "dw_rdbms_fields" ("TABLE_NAME", "SEQ", "FIELD_NAME", "IS_KEY", "FIELD_TYPE", "STATUS_CODE", "FIELD_DISPLAY_NAME", "SCALE", "DEFAULT_VALUE", "NULLABLE", "IS_VERSION", "SIZE", "IS_AUTO_INCREMENT") VALUES ('dw_lcdp_model', 9, 'update_time', 'N', 'DATETIME', 'Y', '更新时间', '0', NULL, 'Y', 'N', '19', 'N');
INSERT INTO "dw_rdbms_fields" ("TABLE_NAME", "SEQ", "FIELD_NAME", "IS_KEY", "FIELD_TYPE", "STATUS_CODE", "FIELD_DISPLAY_NAME", "SCALE", "DEFAULT_VALUE", "NULLABLE", "IS_VERSION", "SIZE", "IS_AUTO_INCREMENT") VALUES ('dw_lcdp_model', 10, 'update_user_sid', 'N', 'BIGINT', 'Y', '更新人SID', '0', NULL, 'Y', 'N', '20', 'N');

--
CREATE TABLE "dw_lcdp_model_info" (
	"code" VARCHAR(100) NOT NULL,
	"table_name" VARCHAR(128) NOT NULL ,
	"tenant_id" VARCHAR(32) NOT NULL ,
	"app_id" VARCHAR(100) NOT NULL ,
	"tenantsid" BIGINT NOT NULL ,
	"create_time" TIMESTAMP(0) NOT NULL DEFAULT current_timestamp ,
	"create_user_sid" BIGINT NULL DEFAULT NULL ,
	"update_time" TIMESTAMP(0) NULL DEFAULT NULL ,
	"update_user_sid" BIGINT NULL DEFAULT NULL
	)
;
ALTER TABLE "dw_lcdp_model_info" ADD CONSTRAINT lcdp_md_con_pk_model_info PRIMARY KEY("code", "table_name", "app_id", "tenantsid") ;
	-- UNIQUE INDEX `modelinfo_unqidx2` (`code`, `table_name`) USING BTREE

CREATE UNIQUE INDEX "modelinfo_unqidx2" ON  "dw_lcdp_model_info" ("code","table_name");

COMMENT ON TABLE "dw_lcdp_model_info" IS '模型驅動資訊';

COMMENT ON COLUMN "dw_lcdp_model_info"."code" IS '模型code';
COMMENT ON COLUMN "dw_lcdp_model_info"."table_name" IS '表名';
COMMENT ON COLUMN "dw_lcdp_model_info"."tenant_id" IS '目标租户ID';
COMMENT ON COLUMN "dw_lcdp_model_info"."app_id" IS '應用ID';
COMMENT ON COLUMN "dw_lcdp_model_info"."tenantsid" IS '租户SID';
COMMENT ON COLUMN "dw_lcdp_model_info"."create_time" IS '创建时间';
COMMENT ON COLUMN "dw_lcdp_model_info"."create_user_sid" IS '创建人SID';
COMMENT ON COLUMN "dw_lcdp_model_info"."update_time" IS '更新时间';
COMMENT ON COLUMN "dw_lcdp_model_info"."update_user_sid" IS '更新人SID';

INSERT INTO "dw_rdbms_tables" ("table_name", "table_display_name", "table_description", "delete_constraint", "hint_field", "insert_default_value", "update_default_value") VALUES ('dw_lcdp_model_info', '模型驅動資訊', '模型驅動資訊', 'N', NULL, NULL, NULL);

INSERT INTO "dw_rdbms_fields" ("TABLE_NAME", "SEQ", "FIELD_NAME", "IS_KEY", "FIELD_TYPE", "STATUS_CODE", "FIELD_DISPLAY_NAME", "SCALE", "DEFAULT_VALUE", "NULLABLE", "IS_VERSION", "SIZE", "IS_AUTO_INCREMENT") VALUES ('dw_lcdp_model_info', 1, 'code', 'Y', 'VARCHAR', 'Y', '模型code', '0', NULL, 'N', 'N', '100', 'N');
INSERT INTO "dw_rdbms_fields" ("TABLE_NAME", "SEQ", "FIELD_NAME", "IS_KEY", "FIELD_TYPE", "STATUS_CODE", "FIELD_DISPLAY_NAME", "SCALE", "DEFAULT_VALUE", "NULLABLE", "IS_VERSION", "SIZE", "IS_AUTO_INCREMENT") VALUES ('dw_lcdp_model_info', 2, 'table_name', 'Y', 'VARCHAR', 'Y', '表名', '0', 'cus', 'N', 'N', '10', 'N');
INSERT INTO "dw_rdbms_fields" ("TABLE_NAME", "SEQ", "FIELD_NAME", "IS_KEY", "FIELD_TYPE", "STATUS_CODE", "FIELD_DISPLAY_NAME", "SCALE", "DEFAULT_VALUE", "NULLABLE", "IS_VERSION", "SIZE", "IS_AUTO_INCREMENT") VALUES ('dw_lcdp_model_info', 3, 'tenant_id', 'N', 'VARCHAR', 'Y', '目标租户ID', '0', NULL, 'N', 'N', '32', 'N');
INSERT INTO "dw_rdbms_fields" ("TABLE_NAME", "SEQ", "FIELD_NAME", "IS_KEY", "FIELD_TYPE", "STATUS_CODE", "FIELD_DISPLAY_NAME", "SCALE", "DEFAULT_VALUE", "NULLABLE", "IS_VERSION", "SIZE", "IS_AUTO_INCREMENT") VALUES ('dw_lcdp_model_info', 4, 'app_id', 'Y', 'VARCHAR', 'Y', '应用ID', '0', NULL, 'N', 'N', '100', 'N');
INSERT INTO "dw_rdbms_fields" ("TABLE_NAME", "SEQ", "FIELD_NAME", "IS_KEY", "FIELD_TYPE", "STATUS_CODE", "FIELD_DISPLAY_NAME", "SCALE", "DEFAULT_VALUE", "NULLABLE", "IS_VERSION", "SIZE", "IS_AUTO_INCREMENT") VALUES ('dw_lcdp_model_info', 5, 'tenantsid', 'Y', 'BIGINT', 'Y', '租户SID', '0', NULL, 'N', 'N', '20', 'N');
INSERT INTO "dw_rdbms_fields" ("TABLE_NAME", "SEQ", "FIELD_NAME", "IS_KEY", "FIELD_TYPE", "STATUS_CODE", "FIELD_DISPLAY_NAME", "SCALE", "DEFAULT_VALUE", "NULLABLE", "IS_VERSION", "SIZE", "IS_AUTO_INCREMENT") VALUES ('dw_lcdp_model_info', 6, 'create_time', 'N', 'DATETIME', 'Y', '创建时间', '0', NULL, 'N', 'N', '19', 'N');
INSERT INTO "dw_rdbms_fields" ("TABLE_NAME", "SEQ", "FIELD_NAME", "IS_KEY", "FIELD_TYPE", "STATUS_CODE", "FIELD_DISPLAY_NAME", "SCALE", "DEFAULT_VALUE", "NULLABLE", "IS_VERSION", "SIZE", "IS_AUTO_INCREMENT") VALUES ('dw_lcdp_model_info', 7, 'create_user_sid', 'N', 'BIGINT', 'Y', '创建人SID', '0', NULL, 'N', 'N', '20', 'N');
INSERT INTO "dw_rdbms_fields" ("TABLE_NAME", "SEQ", "FIELD_NAME", "IS_KEY", "FIELD_TYPE", "STATUS_CODE", "FIELD_DISPLAY_NAME", "SCALE", "DEFAULT_VALUE", "NULLABLE", "IS_VERSION", "SIZE", "IS_AUTO_INCREMENT") VALUES ('dw_lcdp_model_info', 8, 'update_time', 'N', 'DATETIME', 'Y', '更新时间', '0', NULL, 'Y', 'N', '19', 'N');
INSERT INTO "dw_rdbms_fields" ("TABLE_NAME", "SEQ", "FIELD_NAME", "IS_KEY", "FIELD_TYPE", "STATUS_CODE", "FIELD_DISPLAY_NAME", "SCALE", "DEFAULT_VALUE", "NULLABLE", "IS_VERSION", "SIZE", "IS_AUTO_INCREMENT") VALUES ('dw_lcdp_model_info', 9, 'update_user_sid', 'N', 'BIGINT', 'Y', '更新人SID', '0', NULL, 'Y', 'N', '20', 'N');

-- dw_service_mapping
CREATE TABLE "dw_service_mapping" (
	"mapping_id" BIGINT NOT NULL AUTO_INCREMENT,
	"table_name" VARCHAR(64) NULL DEFAULT NULL,
	"expose_eai_id" VARCHAR(256) NULL DEFAULT NULL ,
	"expose_callback_eai_id" VARCHAR(256) NULL DEFAULT NULL,
	"target_prod" VARCHAR(100) NULL DEFAULT NULL,
	constraint pk_lcdp_md_service_mapping PRIMARY KEY("mapping_id")
)
;

-- ALTER TABLE "dw_service_mapping" ADD CONSTRAINT uk_table_name_expose_eai_id PRIMARY KEY("mapping_id") ;
CREATE UNIQUE INDEX "uk_table_name_expose_eai_id" ON  "dw_service_mapping" ("table_name", "expose_eai_id");

COMMENT ON COLUMN "dw_service_mapping"."mapping_id" IS '自增 id';
COMMENT ON COLUMN "dw_service_mapping"."table_name" IS '表名';
COMMENT ON COLUMN "dw_service_mapping"."expose_eai_id" IS '暴露接口前綴';
COMMENT ON COLUMN "dw_service_mapping"."expose_callback_eai_id" IS '暴露接口callback前綴';
COMMENT ON COLUMN "dw_service_mapping"."target_prod" IS '數據目標';

INSERT INTO "dw_rdbms_tables" ("table_name", "table_display_name", "table_description", "delete_constraint", "hint_field", "insert_default_value", "update_default_value") VALUES ('dw_service_mapping', '服務轉導對應', '服務轉導對應', 'N', NULL, NULL, NULL);

INSERT INTO "dw_rdbms_fields" ("TABLE_NAME", "SEQ", "FIELD_NAME", "IS_KEY", "FIELD_TYPE", "STATUS_CODE", "FIELD_DISPLAY_NAME", "SCALE", "DEFAULT_VALUE", "NULLABLE", "IS_VERSION", "SIZE", "IS_AUTO_INCREMENT") VALUES ('dw_service_mapping', 1, 'mapping_id', 'Y', 'int', 'N', 'mapping_id', '0', '', 'N', 'N', '20', 'Y');
INSERT INTO "dw_rdbms_fields" ("TABLE_NAME", "SEQ", "FIELD_NAME", "IS_KEY", "FIELD_TYPE", "STATUS_CODE", "FIELD_DISPLAY_NAME", "SCALE", "DEFAULT_VALUE", "NULLABLE", "IS_VERSION", "SIZE", "IS_AUTO_INCREMENT") VALUES ('dw_service_mapping', 2, 'table_name', 'N', 'varchar', 'N', 'table_name', '0', '', 'N', 'N', '64', 'N');
INSERT INTO "dw_rdbms_fields" ("TABLE_NAME", "SEQ", "FIELD_NAME", "IS_KEY", "FIELD_TYPE", "STATUS_CODE", "FIELD_DISPLAY_NAME", "SCALE", "DEFAULT_VALUE", "NULLABLE", "IS_VERSION", "SIZE", "IS_AUTO_INCREMENT") VALUES ('dw_service_mapping', 3, 'expose_eai_id', 'Y', 'varchar', 'N', 'expose_eai_id', '0', '', 'N', 'N', '256', 'N');
INSERT INTO "dw_rdbms_fields" ("TABLE_NAME", "SEQ", "FIELD_NAME", "IS_KEY", "FIELD_TYPE", "STATUS_CODE", "FIELD_DISPLAY_NAME", "SCALE", "DEFAULT_VALUE", "NULLABLE", "IS_VERSION", "SIZE", "IS_AUTO_INCREMENT") VALUES ('dw_service_mapping', 4, 'expose_callback_eai_id', 'N', 'varchar', 'N', 'target_eai_id', '0', '', 'N', 'N', '256', 'N');
INSERT INTO "dw_rdbms_fields" ("TABLE_NAME", "SEQ", "FIELD_NAME", "IS_KEY", "FIELD_TYPE", "STATUS_CODE", "FIELD_DISPLAY_NAME", "SCALE", "DEFAULT_VALUE", "NULLABLE", "IS_VERSION", "SIZE", "IS_AUTO_INCREMENT") VALUES ('dw_service_mapping', 99, 'target_prod', 'N', 'VARCHAR', 'N', '目標數據層', '0', NULL, 'N', 'N', '100', 'N');
