/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.lcdp.modeldriven.aop;

import com.digiwin.lcdp.modeldriven.utils.ExceptionUtils;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Aspect
@Component
public class ModelDrivenSQLExceptionAspect {
    @Autowired
    ExceptionUtils exceptionUtils;

    @Pointcut(value="@annotation(ModelDrivenSQLExceptionSQLInfoCustomize)")
    public void modelDrivenSQLExceptionPointcut() {
    }

    @Around(value="modelDrivenSQLExceptionPointcut()")
    public Object around(ProceedingJoinPoint joinPoint) throws Throwable {
        Object result = null;
        try {
            result = joinPoint.proceed();
        }
        catch (Throwable throwable) {
            throw this.exceptionUtils.filterSQLException(throwable);
        }
        return result;
    }
}

