/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.lcdp.modeldriven.utils;

import com.digiwin.lcdp.modeldriven.utils.ResourceBundleUtils;
import java.lang.reflect.Field;
import java.sql.SQLException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class ExceptionUtils {
    private static final Logger log = LoggerFactory.getLogger(ExceptionUtils.class);

    public Throwable filterSQLException(Throwable e) {
        try {
            this.dealSQLException(e);
            return e;
        }
        catch (Exception ex) {
            log.error("ExceptionUtils.filterSQLException error!", (Throwable)ex);
            return ex;
        }
    }

    public Throwable dealSQLException(Throwable throwable) throws Exception {
        Field superDetailMessage = Throwable.class.getDeclaredField("detailMessage");
        if (throwable != null) {
            if (throwable.getCause() == null) {
                if (throwable instanceof SQLException && ((SQLException)throwable).getNextException() != null) {
                    superDetailMessage.setAccessible(true);
                    superDetailMessage.set(throwable, this.customizeErrorMessage(((SQLException)throwable).getNextException()));
                }
                return throwable;
            }
            Throwable causeExceptions = this.dealSQLException(throwable.getCause());
            if (causeExceptions == null) {
                return throwable;
            }
            if (causeExceptions instanceof SQLException) {
                SQLException cause = (SQLException)causeExceptions;
                superDetailMessage.setAccessible(true);
                superDetailMessage.set(throwable, cause.getMessage());
                return cause;
            }
        }
        return throwable;
    }

    public String customizeErrorMessage(Throwable throwable) {
        String message = throwable.getMessage();
        if (message.indexOf("Duplicate entry") != -1) {
            int startRowValue = message.indexOf("'");
            int endRowValue = message.indexOf("'", startRowValue + 1);
            String rowValue = message.substring(startRowValue + 1, endRowValue);
            int startKeyName = message.indexOf("'", endRowValue + 1);
            int endKeyName = message.indexOf("'", startKeyName + 1);
            String keyName = message.substring(startKeyName + 1, endKeyName);
            StringBuilder builder = new StringBuilder();
            builder.append("errCode:").append("P.LCDP.102.0001").append("  ").append("description:").append(String.format(ResourceBundleUtils.getString("duplicateentry"), rowValue, keyName, message));
            return builder.toString();
        }
        return message;
    }
}

