/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.lcdp.modeldriven.aop;

import com.digiwin.app.service.DWServiceContext;
import com.digiwin.lcdp.modeldriven.aop.DWEAICrudInvocationListener;
import com.digiwin.lcdp.modeldriven.aop.DWEAICrudInvocationListenerRegistry;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.time.StopWatch;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;

public class DWEAICommonCrudInterceptor
implements MethodInterceptor,
DWEAICrudInvocationListenerRegistry {
    private static final String _CLASSTAG = "[" + DWEAICommonCrudInterceptor.class.getSimpleName() + "]";
    @Autowired(required=false)
    @Qualifier(value="modeldriven-customize-bm-crud-adapter")
    private Object serviceAdapter;
    private static Logger logger = LoggerFactory.getLogger(DWEAICommonCrudInterceptor.class);
    Map<String, LinkedList<DWEAICrudInvocationListener>> listeners = new HashMap<String, LinkedList<DWEAICrudInvocationListener>>();

    public Map<String, LinkedList<DWEAICrudInvocationListener>> getListeners() {
        return this.listeners;
    }

    public void setListeners(Map<String, LinkedList<DWEAICrudInvocationListener>> listeners) {
        this.listeners = listeners;
    }

    public Object getServiceAdapter() {
        return this.serviceAdapter;
    }

    public void setServiceAdapter(Object serviceAdapter) {
        this.serviceAdapter = serviceAdapter;
    }

    @Override
    public void register(String eaiId, DWEAICrudInvocationListener listener) {
        logger.debug(_CLASSTAG + " add eaiId({}), listener({})", (Object)eaiId, (Object)listener.getClass().getTypeName());
        LinkedList<DWEAICrudInvocationListener> linkedLists = this.listeners.getOrDefault(eaiId, new LinkedList());
        linkedLists.add(listener);
        this.listeners.put(eaiId, linkedLists);
    }

    public Object invoke(MethodInvocation invocation) throws Throwable {
        Object result;
        block23: {
            block24: {
                Method bmAdapterBeforeInvoke;
                String digiServiceName;
                block22: {
                    StopWatch stopWatch;
                    LinkedList<DWEAICrudInvocationListener> serviceListeners;
                    block21: {
                        digiServiceName = DWServiceContext.getContext().getDigiServiceName();
                        logger.debug(_CLASSTAG + " invoke eaiId({})", (Object)digiServiceName);
                        serviceListeners = this.listeners.get(digiServiceName);
                        result = null;
                        if (!CollectionUtils.isNotEmpty(serviceListeners)) break block22;
                        Object[] objects = invocation.getArguments();
                        Map headers = (Map)objects[0];
                        Map messageBody = (Map)objects[1];
                        stopWatch = StopWatch.createStarted();
                        StringBuffer timeRecord = new StringBuffer();
                        try {
                            timeRecord.append(String.format("beforeInvoke(%d) ", stopWatch.getTime()));
                            logger.debug(timeRecord.toString());
                            for (DWEAICrudInvocationListener targetListener : serviceListeners) {
                                logger.debug(_CLASSTAG + " invoke ({}) , service({}) interceptor({}) beforeInvoke ", (Object)digiServiceName, (Object)targetListener.getClass().getTypeName());
                                targetListener.beforeInvoke(headers, messageBody);
                            }
                            if (this.serviceAdapter != null) {
                                Method bmAdapterBeforeInvoke2 = this.serviceAdapter.getClass().getDeclaredMethod("beforeInvoke", Map.class, Map.class);
                                bmAdapterBeforeInvoke2.invoke(this.serviceAdapter, headers, messageBody);
                            }
                            timeRecord.append(String.format("afterBeforeInvoke(%d) ", stopWatch.getTime()));
                            result = invocation.proceed();
                            timeRecord.append(String.format("invocation.proceed()(%d) ", stopWatch.getTime()));
                            for (DWEAICrudInvocationListener targetListener : serviceListeners) {
                                logger.debug(_CLASSTAG + " invoke ({}) , service({}) interceptor({}) around ", (Object)digiServiceName, (Object)targetListener.getClass().getTypeName());
                                targetListener.around(headers, messageBody);
                            }
                            if (this.serviceAdapter == null) break block21;
                        }
                        catch (Throwable e) {
                            try {
                                timeRecord.append(String.format("before doException(%d) ", stopWatch.getTime()));
                                for (DWEAICrudInvocationListener targetListener : serviceListeners) {
                                    logger.debug(_CLASSTAG + " invoke ({}) , service({}) interceptor({}) doException ", (Object)digiServiceName, (Object)targetListener.getClass().getTypeName());
                                    targetListener.doException(e);
                                }
                                timeRecord.append(String.format("after doException(%d) ", stopWatch.getTime()));
                                if (!stopWatch.isStopped()) {
                                    stopWatch.stop();
                                }
                                throw e;
                            }
                            catch (Throwable throwable) {
                                if (this.serviceAdapter != null) {
                                    Method bmAdapterAfterInvoke = this.serviceAdapter.getClass().getDeclaredMethod("afterInvoke", Map.class, Object.class);
                                    bmAdapterAfterInvoke.invoke(this.serviceAdapter, headers, result);
                                }
                                for (DWEAICrudInvocationListener targetListener : serviceListeners) {
                                    logger.debug(_CLASSTAG + " invoke ({}) , service({}) interceptor({}) afterInvoke ", (Object)digiServiceName, (Object)targetListener.getClass().getTypeName());
                                    targetListener.afterInvoke(invocation, result);
                                }
                                if (!stopWatch.isStopped()) {
                                    stopWatch.stop();
                                }
                                throw throwable;
                            }
                        }
                        Method bmAdapterAfterInvoke = this.serviceAdapter.getClass().getDeclaredMethod("afterInvoke", Map.class, Object.class);
                        bmAdapterAfterInvoke.invoke(this.serviceAdapter, headers, result);
                    }
                    for (DWEAICrudInvocationListener targetListener : serviceListeners) {
                        logger.debug(_CLASSTAG + " invoke ({}) , service({}) interceptor({}) afterInvoke ", (Object)digiServiceName, (Object)targetListener.getClass().getTypeName());
                        targetListener.afterInvoke(invocation, result);
                    }
                    if (!stopWatch.isStopped()) {
                        stopWatch.stop();
                    }
                    break block23;
                }
                if (this.serviceAdapter == null) break block24;
                logger.debug(_CLASSTAG + " invoke ({}) , target interceptor matched none", (Object)digiServiceName);
                Object[] objects = invocation.getArguments();
                Map headers = (Map)objects[0];
                Map messageBody = (Map)objects[1];
                StopWatch stopWatch = StopWatch.createStarted();
                StringBuffer timeRecord = new StringBuffer();
                try {
                    timeRecord.append(String.format("beforeInvoke(%d) ", stopWatch.getTime()));
                    logger.debug(timeRecord.toString());
                    bmAdapterBeforeInvoke = this.serviceAdapter.getClass().getDeclaredMethod("beforeInvoke", Map.class, Map.class);
                    bmAdapterBeforeInvoke.invoke(this.serviceAdapter, headers, messageBody);
                    timeRecord.append(String.format("afterBeforeInvoke(%d) ", stopWatch.getTime()));
                    result = invocation.proceed();
                    timeRecord.append(String.format("invocation.proceed()(%d) ", stopWatch.getTime()));
                }
                catch (Throwable e) {
                    try {
                        timeRecord.append(String.format("catch doException(%d) ", stopWatch.getTime()));
                        if (!stopWatch.isStopped()) {
                            stopWatch.stop();
                        }
                        throw e;
                    }
                    catch (Throwable throwable) {
                        Method bmAdapterBeforeInvoke3 = this.serviceAdapter.getClass().getDeclaredMethod("afterInvoke", Map.class, Object.class);
                        bmAdapterBeforeInvoke3.invoke(this.serviceAdapter, headers, result);
                        if (!stopWatch.isStopped()) {
                            stopWatch.stop();
                        }
                        throw throwable;
                    }
                }
                bmAdapterBeforeInvoke = this.serviceAdapter.getClass().getDeclaredMethod("afterInvoke", Map.class, Object.class);
                bmAdapterBeforeInvoke.invoke(this.serviceAdapter, headers, result);
                if (!stopWatch.isStopped()) {
                    stopWatch.stop();
                }
                logger.debug(_CLASSTAG + " didn't have registered interceptor when invoke eaiId({})", (Object)digiServiceName);
                break block23;
            }
            result = invocation.proceed();
        }
        return result;
    }
}

