/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.lcdp.modeldriven.config;

import com.digiwin.app.autoconfigure.DWEAIRestfulUrlRegisterAutoConfiguration;
import com.digiwin.app.autoconfigure.DWHttpClientAutoConfiguration;
import com.digiwin.app.autoconfigure.DWRestfulCommonsServiceAutoConfiguration;
import com.digiwin.app.dao.DWDao;
import com.digiwin.app.module.DWServiceInfo;
import com.digiwin.app.service.commons.config.DWServiceCommonsProvider;
import com.digiwin.lcdp.modeldriven.aop.DWEAICommonCrudInterceptor;
import com.digiwin.lcdp.modeldriven.aop.DWEAICrudInvocationListenerRegistry;
import com.digiwin.lcdp.modeldriven.customize.BMProperties;
import com.digiwin.lcdp.modeldriven.customize.BMRole;
import com.digiwin.lcdp.modeldriven.customize.constants.CustomizeConstants;
import com.digiwin.lcdp.modeldriven.eoc.EocHttpRequester;
import com.digiwin.lcdp.modeldriven.eoc.EocProperties;
import com.digiwin.lcdp.modeldriven.eoc.ModelDrivenEocService;
import com.digiwin.lcdp.modeldriven.service.impl.ModelDrivenEAIMappingService;
import com.digiwin.lcdp.modeldriven.utils.ModelDrivenCommonsServiceUtil;
import com.digiwin.lcdp.modeldriven.utils.ModelSchemaUtil;
import com.digiwin.lcdp.modeldriven.utils.ModelTableHelperExpress;
import java.util.List;
import java.util.Map;
import org.aopalliance.aop.Advice;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.aop.Advisor;
import org.springframework.aop.Pointcut;
import org.springframework.aop.aspectj.AspectJExpressionPointcut;
import org.springframework.aop.support.DefaultPointcutAdvisor;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.AutoConfigureBefore;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Primary;
import org.springframework.core.env.Environment;

@Configuration
@ComponentScan(basePackages={"com.digiwin.lcdp.modeldriven"})
@ConditionalOnClass(value={DWServiceCommonsProvider.class})
@AutoConfigureBefore(value={DWRestfulCommonsServiceAutoConfiguration.class, DWEAIRestfulUrlRegisterAutoConfiguration.class, DWHttpClientAutoConfiguration.class})
@ConditionalOnProperty(prefix="dap.service.commons.", name={"enabled"}, havingValue="true", matchIfMissing=true)
public class ModelDrivenCommonsAutoConfiguration {
    private static final Logger _log = LoggerFactory.getLogger(ModelDrivenCommonsAutoConfiguration.class);
    private static final String _CLASSTAG = "[" + ModelDrivenCommonsAutoConfiguration.class.getSimpleName() + "]";

    @Bean(name={"dw-modeldriven-service-commons-eai-registry"})
    public DWEAICrudInvocationListenerRegistry getRegistry() {
        DWEAICommonCrudInterceptor interceptor = new DWEAICommonCrudInterceptor();
        _log.info("bean:eai dw-modeldriven-service-commons-eai-registry created!");
        return interceptor;
    }

    @Bean(name={"dw-modeldriven-commons-eai-crud-advisor"})
    @ConditionalOnBean(name={"dw-modeldriven-service-commons-eai-registry"})
    public Advisor dwEAICommonServiceAdvisor(@Qualifier(value="dw-modeldriven-service-commons-eai-registry") DWEAICrudInvocationListenerRegistry registry) {
        DefaultPointcutAdvisor advisor = new DefaultPointcutAdvisor();
        AspectJExpressionPointcut pointcut = new AspectJExpressionPointcut();
        String modeldrivenExpress = "execution(* com.digiwin.lcdp.modeldriven.service.IModelDrivenEAICrudService.*(..))";
        DWEAICommonCrudInterceptor dweaiCommonCrudInterceptor = (DWEAICommonCrudInterceptor)registry;
        BMProperties bmProperties = BMProperties.getProperties();
        if (bmProperties.isEnabled() && bmProperties.getRole() == BMRole.bm) {
            modeldrivenExpress = modeldrivenExpress + " || execution(* " + CustomizeConstants.CUSTOMIZE_COMMON_BM_CRUD_INTERFACE_NAME + ".*(..))";
        }
        pointcut.setExpression(modeldrivenExpress);
        advisor.setPointcut((Pointcut)pointcut);
        advisor.setAdvice((Advice)dweaiCommonCrudInterceptor);
        _log.info(_CLASSTAG + " bean:eai dw-modeldriven-commons-eai-crud-advisor created!");
        return advisor;
    }

    @Bean(name={"dw-modeldriven-commons-eai-mapping-service"})
    public ModelDrivenEAIMappingService eaiMappingService(@Qualifier(value="dw-dao") DWDao dwdao) {
        ModelDrivenEAIMappingService eaiMappingService = new ModelDrivenEAIMappingService();
        _log.info(_CLASSTAG + " bean:eai {} created!", (Object)"dw-modeldriven-commons-eai-mapping-service");
        return eaiMappingService;
    }

    @Primary
    @Bean(value={"dw-service-commons-provider"})
    public DWServiceCommonsProvider getModelDrivenServiceCommonProvider(@Qualifier(value="modeldriven-bm-properties") BMProperties bmProperties) throws Exception {
        Map<String, List<Class<?>>> commonsInterfaces = ModelDrivenCommonsServiceUtil.getCommonsServiceInterfaces();
        Map<String, List<DWServiceInfo>> commonsImplements = ModelDrivenCommonsServiceUtil.getCommonsServiceImplements();
        return new DWServiceCommonsProvider(commonsInterfaces, commonsImplements);
    }

    @Bean(value={"dw-modeldriven-eoc-properties"})
    public EocProperties getProperties(Environment environment) {
        EocProperties properties = new EocProperties();
        properties.setUrl(environment.getProperty("eocUrl"));
        properties.setContentType(environment.getProperty("eocContentType", "application/json; charset=UTF-8"));
        properties.setConnectionRequestTimeout(Integer.parseInt(environment.getProperty("eocHttpConnectionPoolRequestTimeout", "20000")));
        properties.setConnectionTimeout(Integer.parseInt(environment.getProperty("eocHttpConnectionTimeout", "60000")));
        properties.setRequestSocketTimeout(Integer.parseInt(environment.getProperty("eocSoTimeout", "30000")));
        properties.setEncode(environment.getProperty("eocEncode", "UTF-8"));
        properties.setConnectionMaxTotal(Integer.parseInt(environment.getProperty("eocHttpMaxConnections", "100")));
        properties.setKeepAliveTimeout(Long.parseLong(environment.getProperty("eocKeepAliveTimeout", "-1")));
        properties.setApiPathEmpInfo(environment.getProperty("eocUrlEmpInfo", "/api/eoc/v2/emp/info"));
        properties.setApiPathEmpDeptAll(environment.getProperty("eocUrlEmpDeptAll", "/api/eoc/v2/emp/direct/dept/all"));
        EocHttpRequester.setProperties(properties);
        _log.info(_CLASSTAG + " bean:eai {} created!", (Object)"dw-modeldriven-eoc-properties");
        return properties;
    }

    @Bean(value={"dw-modeldriven-eocService"})
    public ModelDrivenEocService getModelDrivenEocService(@Qualifier(value="dw-modeldriven-eoc-properties") EocProperties eocProperties) {
        ModelDrivenEocService modelDrivenEocService = new ModelDrivenEocService();
        _log.info(_CLASSTAG + " bean:eai {} created!", (Object)"dw-modeldriven-eocService");
        return modelDrivenEocService;
    }

    @Bean(value={"dw-modeldriven-modelSchemaUtil"})
    public ModelSchemaUtil getModelSchemaUtil(ModelTableHelperExpress modelTableHelperExpress) {
        ModelSchemaUtil modelSchemaUtil = new ModelSchemaUtil();
        modelSchemaUtil.setModelTableHelperExpress(modelTableHelperExpress);
        _log.info(_CLASSTAG + " bean:eai {} created!", (Object)"dw-modeldriven-modelSchemaUtil");
        return modelSchemaUtil;
    }
}

