/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.lcdp.modeldriven.customize;

import com.digiwin.app.common.DWApplicationConfigUtils;
import com.digiwin.app.json.gson.DWGsonProvider;
import com.digiwin.app.service.DWEAIResult;
import com.digiwin.app.service.DWServiceContext;
import com.digiwin.athena.esp.sdk.Invoker;
import com.digiwin.athena.esp.sdk.enums.InvokeTypeEnum;
import com.digiwin.athena.esp.sdk.model.RequestModel;
import com.digiwin.athena.esp.sdk.model.ResponseModel;
import com.digiwin.lcdp.modeldriven.customize.constants.BMConstants;
import com.digiwin.lcdp.modeldriven.customize.pojo.BMCode;
import com.digiwin.lcdp.modeldriven.model.ModelDTO;
import com.digiwin.lcdp.modeldriven.utils.NacosRegisterUtils;
import com.digiwin.utils.DWTenantUtils;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.time.StopWatch;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Component;

@Component
public class BMDInvoker {
    private static final String _CLASSTAG = "[" + BMDInvoker.class.getSimpleName() + "]";
    private static Logger logger = LoggerFactory.getLogger(BMDInvoker.class);
    @Autowired(required=false)
    @Qualifier(value="bmCodes")
    Map<String, BMCode> bmCodes;
    private static List<String> excludeService = BMConstants.SERVICE_MODEL_PUBLISH;
    private static List<String> serviceWithAppInfo = BMConstants.SERVICE_QUERY_DATA_WITH_APPINFO;

    public Object invoker(Map<String, Object> headers, Map<String, Object> messageBody) {
        Map profile;
        String digiService = (String)headers.get("digi-service");
        String token = (String)headers.get("token");
        JSONObject digiServiceJo = new JSONObject(digiService);
        String serviceName = digiServiceJo.getString("name");
        String targetProd = null;
        if (excludeService.contains(serviceName)) {
            Map modelData = (Map)((Map)((Map)messageBody.get("std_data")).get("parameter")).get("model");
            String modelStr = DWGsonProvider.getGson().toJson((Object)modelData);
            ModelDTO draftModel = (ModelDTO)DWGsonProvider.getGson().fromJson(modelStr, ModelDTO.class);
            targetProd = draftModel.getAppInfo().getTargetProd();
        } else if (serviceWithAppInfo.contains(serviceName)) {
            Map params = (Map)((Map)messageBody.get("std_data")).get("parameter");
            Map appInfo = (Map)params.get("appInfo");
            targetProd = (String)appInfo.get("targetProd");
        } else {
            String bmTargetProds = DWApplicationConfigUtils.getProperty((String)"lcdp.bm.target.prod");
            if (StringUtils.isEmpty((CharSequence)bmTargetProds)) {
                throw new RuntimeException("<<< bmTargetProds properties is not configured");
            }
            List bmTargetProdList = Stream.of(bmTargetProds.split(",")).collect(Collectors.toList());
            if (this.bmCodes.containsKey(serviceName)) {
                BMCode targetBMCode = this.bmCodes.get(serviceName);
                targetProd = targetBMCode.getTargetProd();
            } else {
                targetProd = (String)bmTargetProdList.get(0);
            }
            serviceName = NacosRegisterUtils.generateBMDEaiId(serviceName, targetProd, DWApplicationConfigUtils.getProperty((String)"appId"));
        }
        RequestModel requestModel = new RequestModel();
        requestModel.setServiceProd(targetProd);
        requestModel.setServiceName(serviceName);
        requestModel.setHostProd(targetProd);
        requestModel.setHostVer("1.0.0");
        requestModel.setInvokeType(InvokeTypeEnum.SYNC);
        requestModel.setBodyJsonString(DWGsonProvider.getGson().toJson(messageBody));
        requestModel.setEocMap(new HashMap());
        requestModel.addHeader("digi-middleware-auth-app", MapUtils.getString(headers, (Object)"digi-middleware-auth-app", (String)""));
        requestModel.addHeader("token", token);
        String txId = MapUtils.getString(headers, (Object)"tx-xid");
        String TXID = MapUtils.getString(headers, (Object)"TX_XID");
        if (StringUtils.isNotEmpty((CharSequence)txId)) {
            logger.debug(_CLASSTAG + " ---> bmd({}), service({}),  tx-xid is({})", new Object[]{targetProd, serviceName, txId});
            requestModel.addHeader("tx-xid", txId);
        }
        if (StringUtils.isNotEmpty((CharSequence)TXID)) {
            logger.debug(_CLASSTAG + " ---> bmd({}), service({}),  TX_XID is({})", new Object[]{targetProd, serviceName, TXID});
            requestModel.addHeader("TX_XID", TXID);
        }
        if (MapUtils.isEmpty((Map)(profile = DWServiceContext.getContext().getProfile()))) {
            requestModel.setTenantId("");
        } else {
            requestModel.setTenantId((String)profile.get(DWTenantUtils.getIamTenantIdKey()));
        }
        ResponseModel responseModel = null;
        StopWatch stopWatch = StopWatch.createStarted();
        try {
            logger.debug(_CLASSTAG + " ---> bmd({}), service({}), stage:begin, time({})", new Object[]{targetProd, serviceName, stopWatch.getTime()});
            responseModel = Invoker.invokeRestSync((RequestModel)requestModel);
            logger.debug(_CLASSTAG + " ---> bmd({}), service({}), stage:response, response({}), time({})", new Object[]{targetProd, serviceName, responseModel, stopWatch.getTime()});
        }
        catch (Exception e) {
            logger.warn(_CLASSTAG + " ---> bmd({}), service({}), stage:exception message({}) and cause({}), time({})", new Object[]{"lcdp.bmd.crud.code.get", targetProd, e.getMessage(), e.getCause().getMessage(), stopWatch.getTime()});
            throw new RuntimeException(e);
        }
        finally {
            if (!stopWatch.isStopped()) {
                stopWatch.stop();
            }
        }
        return DWGsonProvider.getGson().fromJson(responseModel.getBodyJsonString(), DWEAIResult.class);
    }

    public DWEAIResult invokeGetBMDCodes(String targetProd) throws Exception {
        String targetServiceName = "lcdp.bmd.crud.code.get";
        RequestModel requestModel = new RequestModel();
        requestModel.setServiceProd(targetProd);
        requestModel.setServiceName(targetServiceName);
        requestModel.setHostProd(targetProd);
        requestModel.setInvokeType(InvokeTypeEnum.SYNC);
        HashMap reqBody = new HashMap();
        HashMap stdData = new HashMap();
        HashMap parameter = new HashMap();
        reqBody.put("std_data", stdData);
        stdData.put("parameter", parameter);
        requestModel.setBodyJsonString(DWGsonProvider.getGson().toJson(reqBody));
        HashMap eocMap = new HashMap();
        requestModel.setEocMap(eocMap);
        ResponseModel responseModel = null;
        requestModel.addHeader("digi-middleware-auth-app", DWApplicationConfigUtils.getProperty((String)"iamApToken"));
        StopWatch stopWatch = StopWatch.createStarted();
        try {
            logger.info(_CLASSTAG + " bmd({}), service({}), stage:begin, time({})", new Object[]{targetProd, targetServiceName, stopWatch.getTime()});
            responseModel = Invoker.invokeRestSync((RequestModel)requestModel);
        }
        catch (Exception e) {
            logger.warn(_CLASSTAG + " bmd({}), service({}), stage:exception message({}) and cause({}), time({})", new Object[]{targetServiceName, targetProd, e.getMessage(), e.getCause().getMessage(), stopWatch.getTime()});
            throw new RuntimeException(e);
        }
        finally {
            if (!stopWatch.isStopped()) {
                stopWatch.stop();
            }
        }
        logger.info(_CLASSTAG + " bmd({}), service({}), stage:finished, time({})", new Object[]{targetProd, targetServiceName, stopWatch.getTime()});
        DWEAIResult eaiResult = (DWEAIResult)DWGsonProvider.getGson().fromJson(responseModel.getBodyJsonString(), DWEAIResult.class);
        return eaiResult;
    }
}

