/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.lcdp.modeldriven.customize.aop;

import com.digiwin.app.service.DWServiceContext;
import com.digiwin.lcdp.modeldriven.aop.DWEAICommonCrudInterceptor;
import com.digiwin.lcdp.modeldriven.aop.DWEAICrudInvocationListener;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import org.aopalliance.intercept.MethodInvocation;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.time.StopWatch;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CustomizeCrudInterceptor
extends DWEAICommonCrudInterceptor {
    private static Logger logger = LoggerFactory.getLogger(CustomizeCrudInterceptor.class);
    private static final String _CLASSTAG = "[" + CustomizeCrudInterceptor.class.getSimpleName() + "]";
    Map<String, LinkedList<DWEAICrudInvocationListener>> listeners = new HashMap<String, LinkedList<DWEAICrudInvocationListener>>();

    @Override
    public Map<String, LinkedList<DWEAICrudInvocationListener>> getListeners() {
        return this.listeners;
    }

    @Override
    public void setListeners(Map<String, LinkedList<DWEAICrudInvocationListener>> listeners) {
        this.listeners = listeners;
    }

    @Override
    public void register(String eaiId, DWEAICrudInvocationListener listener) {
        LinkedList<DWEAICrudInvocationListener> linkedLists = this.listeners.getOrDefault(eaiId, new LinkedList());
        linkedLists.add(listener);
        this.listeners.put(eaiId, linkedLists);
        logger.debug(_CLASSTAG + " add eaiId({}), listener({})", (Object)eaiId, (Object)listener.getClass().getTypeName());
    }

    @Override
    public Object invoke(MethodInvocation invocation) throws Throwable {
        String digiServiceName = DWServiceContext.getContext().getDigiServiceName();
        logger.debug(_CLASSTAG + " invoke eaiId({})", (Object)digiServiceName);
        LinkedList<DWEAICrudInvocationListener> serviceListeners = this.listeners.get(digiServiceName);
        Object result = null;
        if (CollectionUtils.isNotEmpty(serviceListeners)) {
            Object[] objects = invocation.getArguments();
            Map headers = (Map)objects[0];
            Map messageBody = (Map)objects[1];
            StopWatch stopWatch = StopWatch.createStarted();
            StringBuffer timeRecord = new StringBuffer();
            try {
                timeRecord.append(String.format("beforeInvoke(%d) ", stopWatch.getTime()));
                logger.debug(timeRecord.toString());
                for (DWEAICrudInvocationListener targetListener : serviceListeners) {
                    logger.debug(_CLASSTAG + " invoke ({}) , service({}) interceptor({}) beforeInvoke ", (Object)digiServiceName, (Object)targetListener.getClass().getTypeName());
                    targetListener.beforeInvoke(headers, messageBody);
                }
                timeRecord.append(String.format("afterBeforeInvoke(%d) ", stopWatch.getTime()));
                result = invocation.proceed();
                timeRecord.append(String.format("invocation.proceed()(%d) ", stopWatch.getTime()));
                for (DWEAICrudInvocationListener targetListener : serviceListeners) {
                    logger.debug(_CLASSTAG + " invoke ({}) , service({}) interceptor({}) around ", (Object)digiServiceName, (Object)targetListener.getClass().getTypeName());
                    targetListener.around(headers, messageBody);
                }
            }
            catch (Throwable e) {
                timeRecord.append(String.format("before doException(%d) ", stopWatch.getTime()));
                for (DWEAICrudInvocationListener targetListener : serviceListeners) {
                    logger.debug(_CLASSTAG + " invoke ({}) , service({}) interceptor({}) doException ", (Object)digiServiceName, (Object)targetListener.getClass().getTypeName());
                    targetListener.doException(e);
                }
                timeRecord.append(String.format("after doException(%d) ", stopWatch.getTime()));
                if (!stopWatch.isStopped()) {
                    stopWatch.stop();
                }
                throw e;
            }
            finally {
                for (DWEAICrudInvocationListener targetListener : serviceListeners) {
                    logger.debug(_CLASSTAG + " invoke ({}) , service({}) interceptor({}) afterInvoke ", (Object)digiServiceName, (Object)targetListener.getClass().getTypeName());
                    targetListener.afterInvoke(invocation, result);
                }
                if (!stopWatch.isStopped()) {
                    stopWatch.stop();
                }
            }
        } else {
            logger.debug(_CLASSTAG + " didn't have registered interceptor when invoke eaiId({})", (Object)digiServiceName);
            result = invocation.proceed();
        }
        return result;
    }
}

