/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.lcdp.modeldriven.customize.service.impl;

import com.digiwin.app.dao.DWDao;
import com.digiwin.app.dao.DWOnColumn;
import com.digiwin.app.dao.DWQueryCondition;
import com.digiwin.app.dao.DWQueryInfo;
import com.digiwin.app.dao.DWQueryJoinRelation;
import com.digiwin.app.dao.DWQueryJoinTable;
import com.digiwin.app.dao.DWQueryValueOperator;
import com.digiwin.app.data.DWDataSetOperationOption;
import com.digiwin.app.module.spring.SpringContextUtils;
import com.digiwin.lcdp.modeldriven.customize.service.IBMDataEAICrudService;
import com.digiwin.lcdp.modeldriven.pojo.DWServiceMapping;
import com.digiwin.lcdp.modeldriven.service.impl.ModelDrivenEAIMappingService;
import com.digiwin.lcdp.modeldriven.utils.EaiResultUtil;
import com.digiwin.lcdp.modeldriven.utils.ModelDataUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;

@Service
public class BMDataEAICrudService
implements IBMDataEAICrudService {
    private static final Logger log = LoggerFactory.getLogger(BMDataEAICrudService.class);
    private static final String _CLASSTAG = "[" + BMDataEAICrudService.class.getSimpleName() + "]";
    @Autowired
    @Qualifier(value="dw-modeldriven-commons-eai-mapping-service")
    ModelDrivenEAIMappingService eaiMappingService;

    @Override
    public Object getBMCode(Map<String, Object> headers, Map<String, Object> messageBody) throws Exception {
        log.info(_CLASSTAG + "[getBMCode] enter...");
        DWDataSetOperationOption option = ModelDataUtil.getDisabledCommonDataSetOperationOption();
        DWDao dao = (DWDao)SpringContextUtils.getContext().getBean("dw-dao");
        DWQueryInfo queryInfo = new DWQueryInfo();
        queryInfo.setTableName("dw_service_mapping");
        queryInfo.setJoinOnColumn(DWQueryJoinRelation.LeftJoin, new DWQueryJoinTable("dw_lcdp_model_info"), new DWOnColumn[]{new DWOnColumn("table_name", DWQueryValueOperator.Equals, "table_name")});
        queryInfo.addSelectField(new String[]{"dw_lcdp_model_info.code"});
        queryInfo.addSelectField(new String[]{"dw_service_mapping.*"});
        DWQueryCondition queryCondition = new DWQueryCondition();
        queryCondition.addFieldInfo("target_prod", DWQueryValueOperator.NotEquals, null);
        queryInfo.setCondition(queryCondition);
        List serviceMappings = dao.select(DWServiceMapping.class, queryInfo, option);
        List mappingModelInfos = new ArrayList();
        if (serviceMappings.size() > 0) {
            mappingModelInfos = (List)this.eaiMappingService.getChildrenTable();
        }
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("serviceMapping", serviceMappings);
        result.put("mappingModelInfos", mappingModelInfos);
        log.info(_CLASSTAG + "[getBMCode] finished, data({})", result);
        return EaiResultUtil.getDWEAIResult(result);
    }
}

