/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.lcdp.modeldriven.dao;

import com.digiwin.lcdp.modeldriven.model.ModelFieldDTO;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;

public class TableDao {
    public static List<ModelFieldDTO> getColumns(Connection connection, String schema, String tableName) throws SQLException {
        ArrayList<ModelFieldDTO> columns = new ArrayList<ModelFieldDTO>();
        DatabaseMetaData databaseMetadata = connection.getMetaData();
        ResultSet rsPk = databaseMetadata.getPrimaryKeys(null, schema, tableName);
        ArrayList<String> pkColumns = new ArrayList<String>();
        while (rsPk.next()) {
            pkColumns.add(rsPk.getString("COLUMN_NAME").toString());
        }
        ResultSet rsUniqueColumns = databaseMetadata.getIndexInfo(null, schema, tableName, true, true);
        ArrayList<String> uniqueFields = new ArrayList<String>();
        while (rsUniqueColumns.next()) {
            String indexName = rsUniqueColumns.getString("INDEX_NAME");
            String indexType = rsUniqueColumns.getString("TYPE");
            if (indexName.equals("PRIMARY") || !indexType.equals("3")) continue;
            uniqueFields.add(rsUniqueColumns.getString("COLUMN_NAME"));
        }
        ResultSet rs = databaseMetadata.getColumns(null, schema, tableName, null);
        while (rs.next()) {
            ModelFieldDTO column = new ModelFieldDTO();
            String columnName = rs.getString("COLUMN_NAME");
            column.setFieldId(columnName);
            String columnDef = rs.getString("COLUMN_DEF");
            String typeName = rs.getString("TYPE_NAME");
            if (typeName.toString().toLowerCase().startsWith("int") && typeName.toString().toLowerCase().equals("int unsigned")) {
                typeName = typeName.substring(0, 3);
            }
            column.setFieldType(typeName);
            if (typeName.toString().toLowerCase().equals("bit") && columnDef != null && columnDef.startsWith("b'") && columnDef.endsWith("'")) {
                columnDef = columnDef.substring(2, columnDef.length() - 1);
            }
            if (columnDef != null && columnDef.startsWith("'") && columnDef.endsWith("'")) {
                columnDef = columnDef.substring(1, columnDef.length() - 1);
            }
            column.setDefaultValue(columnDef);
            String isAutoincrement = rs.getString("is_autoincrement");
            if (isAutoincrement.equalsIgnoreCase("yes")) {
                column.setAutoIncrement(true);
            } else {
                column.setAutoIncrement(false);
            }
            String isNullable = rs.getString("IS_NULLABLE");
            if (isNullable.toLowerCase().equals("yes")) {
                column.setNotNull(false);
            }
            if (isNullable.toLowerCase().equals("no")) {
                column.setNotNull(true);
            }
            if (typeName.toString().toLowerCase().equals("bigint")) {
                column.setSize(String.valueOf(rs.getInt("COLUMN_SIZE") + 1));
            } else {
                column.setSize(String.valueOf(rs.getInt("COLUMN_SIZE")));
            }
            column.setScale(String.valueOf(rs.getInt("DECIMAL_DIGITS")));
            if (pkColumns.contains(columnName)) {
                column.setPk(true);
            }
            if (uniqueFields.contains(columnName)) {
                column.setUnique(true);
            }
            column.setFieldName(rs.getString("REMARKS"));
            columns.add(column);
        }
        return columns;
    }
}

