/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.lcdp.modeldriven.eventcenter.config;

import com.digiwin.lcdp.modeldriven.eventcenter.config.EventCenterProperties;
import com.digiwin.lcdp.modeldriven.eventcenter.config.EventCenterThreadProperties;
import com.digiwin.lcdp.modeldriven.eventcenter.constant.EventCenterProtocolEnum;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.env.Environment;
import org.springframework.scheduling.concurrent.ThreadPoolTaskExecutor;

@Configuration
public class EventCenterConfiguration {
    @Bean(value={"eventTaskExecutor"})
    ThreadPoolTaskExecutor getEventCenterEventExecutor(@Qualifier(value="eventCenterThreadProperties") EventCenterThreadProperties eventCenterThreadProperties) {
        ThreadPoolTaskExecutor executor = new ThreadPoolTaskExecutor();
        executor.setThreadNamePrefix("lcdp-event-center-event-");
        executor.setCorePoolSize(eventCenterThreadProperties.getCorePoolSize());
        executor.setMaxPoolSize(eventCenterThreadProperties.getMaximumPoolSize());
        executor.setQueueCapacity(eventCenterThreadProperties.getWorkQueueSize());
        executor.setKeepAliveSeconds(eventCenterThreadProperties.getKeepAliveTime());
        return executor;
    }

    @Bean(value={"eventCenterProperties"})
    EventCenterProperties getEventCenterProperties(Environment environment) {
        EventCenterProperties properties = new EventCenterProperties();
        properties.setUrl(environment.getProperty("eventCenterUrl"));
        properties.setServiceType(EventCenterProtocolEnum.valueOf(environment.getProperty("eventCenterProtocol", "HTTP").toUpperCase()));
        return properties;
    }
}

