/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.lcdp.modeldriven.exception;

import com.digiwin.lcdp.modeldriven.model.ModelSchemaDTO;

public class PublishModelException
extends Exception {
    private static final long serialVersionUID = 9133935440671227403L;
    private String code;
    private String codeName;
    private String targetTenantId;
    private ModelSchemaDTO draftModelSchema;
    private ModelSchemaDTO publishedModelSchema;
    private String summary;

    public PublishModelException(String formId, String formName, String targetTenantId, ModelSchemaDTO draftFormSchema, ModelSchemaDTO publishedFormSchema, String message, Throwable cause) {
        super(String.format("[%s] %s -> code = %s, modelName = %s, targetTenantId = %s, draftModelSchema = %s, publishedModelSchema = %s", message, cause.getMessage(), formId, formName, targetTenantId, draftFormSchema, publishedFormSchema), cause);
        this.code = formId;
        this.codeName = formName;
        this.targetTenantId = targetTenantId;
        this.draftModelSchema = draftFormSchema;
        this.publishedModelSchema = publishedFormSchema;
        this.summary = String.format("%s, %s", message, cause.getMessage());
    }

    public String getCode() {
        return this.code;
    }

    public String getCodeName() {
        return this.codeName;
    }

    public String getTargetTenantId() {
        return this.targetTenantId;
    }

    public ModelSchemaDTO getDraftModelSchema() {
        return this.draftModelSchema;
    }

    public ModelSchemaDTO getPublishedModelSchema() {
        return this.publishedModelSchema;
    }

    public String getSummary() {
        return this.summary;
    }

    @Override
    public String toString() {
        return "PublishModelException{code='" + this.code + '\'' + ", codeName='" + this.codeName + '\'' + ", targetTenantId='" + this.targetTenantId + '\'' + ", draftModelSchema=" + this.draftModelSchema + ", publishedModelSchema=" + this.publishedModelSchema + ", summary='" + this.summary + '\'' + '}';
    }
}

