/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.lcdp.modeldriven.service.impl;

import com.digiwin.app.dao.DWDao;
import com.digiwin.app.dao.DWOnColumn;
import com.digiwin.app.dao.DWQueryInfo;
import com.digiwin.app.dao.DWQueryJoinRelation;
import com.digiwin.app.dao.DWQueryJoinTable;
import com.digiwin.app.dao.DWQueryValueOperator;
import com.digiwin.app.data.DWDataSetOperationOption;
import com.digiwin.app.data.IDWSQLOptions;
import com.digiwin.lcdp.modeldriven.model.ModelInfoDTO;
import com.digiwin.lcdp.modeldriven.pojo.DWServiceMapping;
import com.digiwin.lcdp.modeldriven.pojo.MappingModelInfo;
import com.digiwin.lcdp.modeldriven.utils.ModelDataUtil;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class ModelDrivenEAIMappingService {
    private static final Logger log = LoggerFactory.getLogger(ModelDrivenEAIMappingService.class);
    @Autowired
    private DWDao dao;
    private final String tableName = "dw_service_mapping";

    public Object getEAIList(DWQueryInfo queryInfo, DWDataSetOperationOption options) {
        queryInfo.setTableName("dw_service_mapping");
        return this.dao.select(DWServiceMapping.class, queryInfo, options);
    }

    public Object getEAIModelInfoList(DWQueryInfo queryInfo, DWDataSetOperationOption options) {
        return this.dao.select(ModelInfoDTO.class, queryInfo, options);
    }

    public Object getEAIModelInfoListExpress(String tableName) {
        log.debug("starting get model_info by tableName {}", (Object)tableName);
        DWDataSetOperationOption option = new DWDataSetOperationOption();
        option.setTenantEnabled(false);
        option.setManagementFieldEnabled(false);
        String joinTableAliasName = "jointbl";
        DWQueryJoinTable joinTbl = new DWQueryJoinTable("dw_lcdp_model_info", joinTableAliasName);
        DWQueryInfo queryInfo = new DWQueryInfo();
        queryInfo.setTableName("dw_lcdp_model_info");
        queryInfo.setJoinOnColumn(DWQueryJoinRelation.Join, joinTbl, new DWQueryJoinTable("dw_lcdp_model_info"), new DWOnColumn[]{new DWOnColumn("code", DWQueryValueOperator.Equals, "code" + String.format(" AND %s.%s != '%s' AND %s.%s = '%s' ", joinTableAliasName, "table_name", tableName, "dw_lcdp_model_info", "table_name", tableName))});
        List queryResult = this.dao.select(ModelInfoDTO.class, queryInfo, option);
        return queryResult;
    }

    public Object getChildrenTable() {
        log.debug("starting get children table");
        DWDataSetOperationOption option = ModelDataUtil.getDisabledCommonDataSetOperationOption();
        String sql = "SELECT model_info_inner.table_name childtbl, mapping.table_name tablename , mapping.expose_eai_id eaiid, model_info_inner.code code ,mapping.target_prod targetProd FROM dw_service_mapping mapping , dw_lcdp_model_info model_info , dw_lcdp_model_info AS model_info_inner  WHERE model_info_inner.code = model_info.code  AND model_info.table_name = mapping.table_name  AND model_info_inner.table_name != mapping.table_name ";
        List queryResult = this.dao.select((IDWSQLOptions)option, MappingModelInfo.class, sql, new Object[0]);
        return queryResult;
    }
}

