/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.lcdp.modeldriven.utils;

import com.digiwin.app.dao.DWBatchCondition;
import com.digiwin.app.dao.DWDao;
import com.digiwin.app.dao.DWQueryCondition;
import com.digiwin.app.dao.DWQueryInfo;
import com.digiwin.app.dao.DWQueryValueOperator;
import com.digiwin.app.dao.DWSQLExecutionResult;
import com.digiwin.app.data.DWDataSet;
import com.digiwin.app.data.DWDataSetOperationOption;
import com.digiwin.app.data.DWDataTable;
import com.digiwin.app.data.IDWSQLOptions;
import com.digiwin.app.eai.exception.DWEaiException;
import com.digiwin.app.service.DWEAIResult;
import com.digiwin.app.service.DWServiceResult;
import com.digiwin.app.service.eai.DWEAIHeader;
import com.digiwin.lcdp.modeldriven.context.ModelDrivenContext;
import com.digiwin.lcdp.modeldriven.customize.BMProperties;
import com.digiwin.lcdp.modeldriven.customize.BMRole;
import com.digiwin.lcdp.modeldriven.customize.model.BMDataEaiMethodRepository;
import com.digiwin.lcdp.modeldriven.enums.ModelCreateTypeEnum;
import com.digiwin.lcdp.modeldriven.enums.PublishStatusEnum;
import com.digiwin.lcdp.modeldriven.model.ModelDTO;
import com.digiwin.lcdp.modeldriven.model.ModelPublishedEspResult;
import com.digiwin.lcdp.modeldriven.model.ModelSchemaDTO;
import com.digiwin.lcdp.modeldriven.model.SqlParam;
import com.digiwin.lcdp.modeldriven.utils.EaiHeaderUtil;
import com.digiwin.lcdp.modeldriven.utils.EaiRegisterUtil;
import com.digiwin.lcdp.modeldriven.utils.EaiResultUtil;
import com.digiwin.lcdp.modeldriven.utils.ModelDataUtil;
import com.digiwin.lcdp.modeldriven.utils.ModelSchemaUtil;
import com.digiwin.lcdp.modeldriven.utils.NacosRegisterUtils;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import net.sf.jsqlparser.parser.CCJSqlParserUtil;
import net.sf.jsqlparser.schema.Table;
import net.sf.jsqlparser.statement.alter.Alter;
import net.sf.jsqlparser.statement.alter.AlterExpression;
import net.sf.jsqlparser.statement.drop.Drop;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.time.StopWatch;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;

@Component
public class DBExecuteHandler {
    private static final Logger log = LoggerFactory.getLogger(DBExecuteHandler.class);
    private static String logTag = "[" + DBExecuteHandler.class.getSimpleName() + "]";
    @Autowired
    @Qualifier(value="dw-dao")
    private DWDao dao;
    @Autowired
    private EaiRegisterUtil eaiRegisterUtil;
    @Autowired
    EaiHeaderUtil eaiHeaderUtil;
    @Autowired(required=false)
    @Qualifier(value="lcdp-bmd-eai-method-repo")
    BMDataEaiMethodRepository bmdEaiMethodRepository;
    @Autowired(required=false)
    private NacosRegisterUtils nacosRegisterUtils;
    private static final String _sql_table_existed = "show TABLES LIKE '%s'";

    @Transactional(propagation=Propagation.REQUIRED, rollbackFor={Exception.class})
    public ModelPublishedEspResult executeCreateTableOfCreateModelDriven(List<SqlParam> sqlParamRdbms, ModelDTO model) {
        boolean logDebugEnabled = log.isDebugEnabled();
        ModelPublishedEspResult publishedEspResult = new ModelPublishedEspResult();
        HashMap<String, Integer> returnValue = new HashMap<String, Integer>();
        String masterTableName = model.getSchema().getName();
        String reportCurrentSql = "dummy";
        String code = model.getCode();
        ModelSchemaDTO modelSchema = model.getSchema();
        boolean isTableCreated = false;
        boolean isModelDesignDataInserted = false;
        int tableExecuteCount = 0;
        try {
            String ddlType = "ddl";
            for (SqlParam sqlParam : sqlParamRdbms) {
                String sql;
                reportCurrentSql = sql = sqlParam.getSql();
                Object[] sqlParams = sqlParam.getParams();
                if (logDebugEnabled) {
                    log.debug(String.format("%d type:%s sql:%s", tableExecuteCount, ddlType, sql.toString()));
                    log.debug(String.format("%d type:%s sqlParam:%s", tableExecuteCount, ddlType, Objects.isNull(sqlParams) ? "null" : Arrays.asList(sqlParams).toString()));
                }
                int createCount = this.dao.getQueryRunner().update(sql, sqlParams);
                ++tableExecuteCount;
                isTableCreated = true;
            }
            returnValue.put("tableExecuteCount", tableExecuteCount);
        }
        catch (Exception e) {
            log.info("code({}) exception 1  executeCreateTable e.getMessage({})", (Object)code, (Object)e.getMessage());
            try {
                if (!Objects.isNull(modelSchema)) {
                    List<String> tableNames = ModelSchemaUtil.getTableNames(modelSchema);
                    Object existedTablesObj = ModelDrivenContext.getContext().getExtraMap().get("existedTables");
                    List existedTables = new ArrayList();
                    boolean isExistedTable = false;
                    if (existedTablesObj != null && CollectionUtils.isNotEmpty((Collection)((List)existedTablesObj))) {
                        existedTables = (List)existedTablesObj;
                        isExistedTable = true;
                        log.debug("[DBExecuteHandler] code({}) app existed tables({})", (Object)code, existedTables);
                    }
                    for (String tableName : tableNames) {
                        if (isExistedTable && existedTables.contains(tableName)) {
                            log.debug("[DBExecuteHandler] code({}) tableName({}) don't need to drop, cause app existed table", (Object)code, (Object)tableName);
                            continue;
                        }
                        Drop dropScript = new Drop();
                        Table dropTable = new Table(tableName);
                        dropScript.setName(dropTable);
                        dropScript.setType("TABLE");
                        dropScript.setIfExists(true);
                        String sql = dropScript.toString();
                        int count = this.dao.getQueryRunner().update(sql);
                        log.info("[DBExecuteHandler] code({}) recovery table count({}) , sql:({})", new Object[]{code, count, sql});
                    }
                }
            }
            catch (Exception exp) {
                log.info("[DBExecuteHandler] code({}) exception 1.1; rollback create table error {}", (Object)exp.getMessage());
            }
            log.info("[DBExecuteHandler] code({}) exception 2 result({})", (Object)code, (Object)e.getMessage());
            publishedEspResult.setPublishStatusEnum(PublishStatusEnum.FAILURE);
            publishedEspResult.setMessage(e.getMessage());
            throw new RuntimeException(String.format("[DBExecuteHandler] code(%s) exception 2", code), e);
        }
        log.info("finished code({}) create table", (Object)code);
        publishedEspResult.setPublishStatusEnum(PublishStatusEnum.SUCCESS);
        return publishedEspResult;
    }

    @Transactional(propagation=Propagation.REQUIRED, rollbackFor={Exception.class})
    public ModelPublishedEspResult executeInsertOfCreateModelDriven(List<SqlParam> sqlParamRdbms, ModelDTO model) {
        ModelPublishedEspResult result = new ModelPublishedEspResult();
        HashMap<String, Integer> returnValue = new HashMap<String, Integer>();
        String masterTableName = model.getSchema().getName();
        String reportCurrentSql = "dummy";
        String code = model.getCode();
        ModelSchemaDTO modelSchema = model.getSchema();
        boolean isTableCreated = false;
        boolean isModelDesignDataInserted = false;
        boolean isModelRdbmsDataInserted = false;
        try {
            DWDataSetOperationOption daoOption = ModelDataUtil.getDisabledCommonDataSetOperationOption();
            int rdbmsExecuteCount = 0;
            String dmlType = "dml";
            ArrayList sqlCommands = new ArrayList();
            for (SqlParam sqlParam : sqlParamRdbms) {
                String sql;
                reportCurrentSql = sql = sqlParam.getSql();
                Object[] sqlParams = sqlParam.getParams();
                if (log.isDebugEnabled()) {
                    log.debug(String.format("%d type:%s sql:%s", rdbmsExecuteCount, dmlType, sql.toString()));
                    log.debug(String.format("%d type:%s sqlParam:%s", rdbmsExecuteCount, dmlType, Objects.isNull(sqlParams) ? "null" : Arrays.asList(sqlParams).toString()));
                }
                int insertRdmsCount = this.dao.update((IDWSQLOptions)daoOption, sql, sqlParams);
                ++rdbmsExecuteCount;
            }
            isModelRdbmsDataInserted = true;
            ModelDrivenContext modelDrivenContext = ModelDrivenContext.getContext();
            ModelCreateTypeEnum useExistedTable = modelDrivenContext.getDraftModel().getUseExistedTable();
            if (!useExistedTable.equals((Object)ModelCreateTypeEnum.EXISTED_TABLE)) {
                Map<String, Object> extraMap = modelDrivenContext.getExtraMap();
                String modelDrivenProdPrefix = (String)extraMap.getOrDefault("modelDrivenProdPrefix", "");
                List<ModelSchemaDTO> allChildrenSchemas = ModelSchemaUtil.getChildrenModelSchema(modelSchema.getChildren());
                List<DWEAIHeader> newEAIHeaders = this.eaiRegisterUtil.refreshEaiService(masterTableName, allChildrenSchemas, modelDrivenProdPrefix, code);
                log.info("code({}) isUseExistedTable({}), starting call register esp/nacos service", (Object)code, (Object)useExistedTable);
                if (BMProperties.getProperties().isEnabled()) {
                    if (BMProperties.getProperties().getRole() == BMRole.bmd) {
                        this.eaiHeaderUtil.addAndUpdateDWEaiHeaders(this.bmdEaiMethodRepository.getEaiHeaders());
                        this.nacosRegisterUtils.nacosServiceRegister(this.bmdEaiMethodRepository.getEaiHeaders().stream().map(DWEAIHeader::getEAIServiceId).collect(Collectors.toList()));
                    }
                } else {
                    Object regResult = this.eaiRegisterUtil.autoRegisterEAI(newEAIHeaders, code);
                    log.info("[DBExecuteHandler] code({}) isUseExistedTable({}), finished call register esp service result({})", new Object[]{code, useExistedTable, regResult});
                }
            } else {
                log.debug("[DBExecuteHandler] code({}) isUseExistedTable({})", (Object)code, (Object)useExistedTable);
            }
            returnValue.put("rdbmsExecuteCount", rdbmsExecuteCount);
            result.setPublishStatusEnum(PublishStatusEnum.SUCCESS);
            result.setServiceResult(new DWServiceResult(true, returnValue));
        }
        catch (Exception e) {
            log.info("[DBExecuteHandler] code({}) exception 2 result({})", (Object)code, (Object)e.getMessage());
            throw new RuntimeException(String.format("code(%s) exception 2", code), e);
        }
        log.info("[DBExecuteHandler] finished code({}) insert data of executeInsertOfCreateTable", (Object)code);
        return result;
    }

    @Transactional(propagation=Propagation.REQUIRED, rollbackFor={Exception.class})
    public DWEAIResult executeAlterTable(Map<String, Object> params, ModelDTO model, Map<String, Object> extraMap) throws Exception {
        DWEAIResult result = new DWEAIResult();
        HashMap<String, Object> returnValue = new HashMap<String, Object>();
        Map modelData = (Map)params.get("model_data");
        String modelAction = (String)modelData.get("model_action");
        if (StringUtils.isEmpty((CharSequence)modelAction) || !"U".equalsIgnoreCase(modelAction)) {
            throw new IllegalArgumentException("action wrong:" + modelAction);
        }
        boolean isTableCreated = false;
        boolean isTableAltered = false;
        boolean isModelDesignDataUpdated = false;
        boolean isModelRdbmsDataUpdated = false;
        String reportCurrentSql = "dummy";
        String code = model.getCode();
        ModelSchemaDTO modelSchemaDTO = model.getSchema();
        int tableExecuteCount = 0;
        String ddlType = "ddl";
        if (params.containsKey(ddlType)) {
            try {
                List paramDDL = (List)params.get(ddlType);
                for (Map sqlMap : paramDDL) {
                    List sqlParamRdbms = (List)sqlMap.get("sqlParamTables");
                    for (SqlParam sqlParam : sqlParamRdbms) {
                        String sql;
                        reportCurrentSql = sql = sqlParam.getSql();
                        Object[] sqlParams = sqlParam.getParams();
                        if (log.isDebugEnabled()) {
                            log.debug(String.format("%d type:%s sql:%s", tableExecuteCount, ddlType, sql.toString()));
                            log.debug(String.format("%d type:%s sqlParam:%s", tableExecuteCount, ddlType, Objects.isNull(sqlParams) ? "null" : Arrays.asList(sqlParams).toString()));
                        }
                        log.debug("current sql:{}", (Object)sql);
                        if (StringUtils.startsWithIgnoreCase((CharSequence)sql, (CharSequence)"CREATE TABLE")) {
                            isTableCreated = true;
                        } else {
                            net.sf.jsqlparser.statement.Statement statement = CCJSqlParserUtil.parse((String)sql);
                            if (statement instanceof Alter) {
                                Alter alterScript = (Alter)statement;
                                Table table = alterScript.getTable();
                                List alterExpress = alterScript.getAlterExpressions();
                                for (AlterExpression alterExpression : alterExpress) {
                                    log.debug("table:({}) alter operation:({}), expression:({})", new Object[]{table.getName(), alterExpression.getOperation().name(), alterExpression.toString()});
                                }
                            }
                        }
                        this.dao.getQueryRunner().update(sql);
                        ++tableExecuteCount;
                    }
                }
            }
            catch (Exception e) {
                throw new RuntimeException(String.format("\u5beb\u5165 \u5931\u6557 (%s) when executing sql (%s)", e.getMessage(), reportCurrentSql), e);
            }
            isTableAltered = true;
        }
        DWDataSetOperationOption daoOption = ModelDataUtil.getDisabledCommonDataSetOperationOption();
        int rdbmsExecuteCount = 0;
        try {
            String dmlType = "dml";
            if (params.containsKey(dmlType)) {
                List paramDML = (List)params.get(dmlType);
                for (Map sqlMap : paramDML) {
                    List sqlParamRdbms = (List)sqlMap.get("sqlParamRdbms");
                    for (SqlParam sqlParam : sqlParamRdbms) {
                        String sql;
                        reportCurrentSql = sql = sqlParam.getSql();
                        Object[] sqlParams = sqlParam.getParams();
                        if (log.isDebugEnabled()) {
                            log.debug(String.format("%d type:%s sql:%s", rdbmsExecuteCount, dmlType, sql.toString()));
                            log.debug(String.format("%d type:%s sqlParam:%s", rdbmsExecuteCount, dmlType, Objects.isNull(sqlParams) ? "null" : Arrays.asList(sqlParams).toString()));
                        }
                        this.dao.update((IDWSQLOptions)daoOption, sql, sqlParams);
                        ++rdbmsExecuteCount;
                    }
                }
            }
            returnValue.put("rdbmsExecuteCount", rdbmsExecuteCount);
            returnValue.put("tableExecuteCount", tableExecuteCount);
            result = EaiResultUtil.getDWEAIResult(returnValue);
            isModelRdbmsDataUpdated = true;
        }
        catch (Exception e) {
            String execCode = "-1";
            String message = e.getMessage();
            if (e instanceof SQLException) {
                SQLException sqle = (SQLException)e;
                execCode = String.valueOf(sqle.getErrorCode());
                message = message + "(" + sqle.getSQLState() + ")";
                result = new DWEAIResult(execCode, sqle.getSQLState(), e.getMessage(), null);
            } else {
                execCode = "-1";
                message = message + " when executing sql(" + reportCurrentSql + ")";
                result = new DWEAIResult(execCode, "-1", message, null);
            }
            log.info("exception 2 code({}) result({})", (Object)code, (Object)result.toString());
            throw new DWEaiException(code, message);
        }
        if (isTableCreated) {
            ModelCreateTypeEnum useExistedTable = ModelDrivenContext.getContext().getDraftModel().getUseExistedTable();
            if (!useExistedTable.equals((Object)ModelCreateTypeEnum.EXISTED_TABLE)) {
                List<ModelSchemaDTO> allChildrenSchemas = ModelSchemaUtil.getChildrenModelSchema(modelSchemaDTO.getChildren());
                String modelDrivenProdPrefix = (String)extraMap.getOrDefault("modelDrivenProdPrefix", "");
                List<DWEAIHeader> newEAIHeaders = this.eaiRegisterUtil.refreshEaiService(modelSchemaDTO.getName(), allChildrenSchemas, modelDrivenProdPrefix, code);
                log.info("code({}) starting call register esp service", (Object)code);
                Object regResult = this.eaiRegisterUtil.autoRegisterEAI(newEAIHeaders, code);
                log.info("code({}) finished call register esp service result({})", (Object)code, regResult);
            } else {
                log.debug("code({}) isUseExistedTable({})", (Object)code, (Object)useExistedTable);
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Transactional(propagation=Propagation.REQUIRED, rollbackFor={Exception.class})
    public DWEAIResult executeDeleteTable(Map<String, Object> params, ModelDTO model) throws Exception {
        DWEAIResult result = new DWEAIResult();
        HashMap<String, Object> returnValue = new HashMap<String, Object>();
        String modelCodeName = model.getCode();
        String masterTableName = model.getSchema().getName();
        DWDataSetOperationOption daoOption = ModelDataUtil.getDisabledCommonDataSetOperationOption();
        int rdbmsExecuteCount = 0;
        String reportCurrentSql = "dummy";
        Assert.hasText((String)masterTableName, (String)"masterTableName must not be null or empty");
        String dmlType = "dml";
        List paramDML = (List)params.get(dmlType);
        log.debug("code({}) deleteTableSchema processing {}...", (Object)model.getCode(), (Object)dmlType);
        if (CollectionUtils.isNotEmpty((Collection)paramDML)) {
            for (Map sqlMap : paramDML) {
                List sqlParamRdbms = (List)sqlMap.get("sqlParamRdbms");
                for (SqlParam sqlParam : sqlParamRdbms) {
                    String sql;
                    reportCurrentSql = sql = sqlParam.getSql();
                    Object[] sqlParams = sqlParam.getParams();
                    if (log.isDebugEnabled()) {
                        log.debug(String.format("%d type:%s sql:%s", rdbmsExecuteCount, dmlType, sql.toString()));
                        log.debug(String.format("%d type:%s sqlParam:%s", rdbmsExecuteCount, dmlType, Objects.isNull(sqlParams) ? "null" : Arrays.asList(sqlParams).toString()));
                    }
                    this.dao.update((IDWSQLOptions)daoOption, sql, sqlParams);
                    ++rdbmsExecuteCount;
                }
            }
        }
        log.debug("processing delete service mapping ({})...", (Object)masterTableName);
        DWDataSetOperationOption optionDeleteServiceMapping = ModelDataUtil.getDisabledCommonDataSetOperationOption();
        optionDeleteServiceMapping.getDeleteOption().enableBatchCondition();
        DWBatchCondition batchCondition = new DWBatchCondition();
        batchCondition.addFieldInfo("table_name", DWQueryValueOperator.Equals, new Object[]{masterTableName});
        DWDataSet deleteMappingDataSet = new DWDataSet();
        deleteMappingDataSet.newTable("dw_service_mapping").delete(batchCondition);
        DWSQLExecutionResult deleteSQLResult = this.dao.execute(deleteMappingDataSet, optionDeleteServiceMapping);
        if (log.isDebugEnabled()) {
            log.debug(String.format("log info delete service mapping of table %s (%s)", masterTableName, deleteSQLResult.getDeleteCount()));
        }
        log.debug("processing delete tables...");
        int tableExecuteCount = 0;
        String ddlType = "ddl";
        List paramDDL = (List)params.get(ddlType);
        for (Map sqlMap : paramDDL) {
            List sqlParamRdbms = (List)sqlMap.get("sqlParamTables");
            for (SqlParam sqlParam : sqlParamRdbms) {
                String sql;
                reportCurrentSql = sql = sqlParam.getSql();
                Object[] sqlParams = sqlParam.getParams();
                if (log.isDebugEnabled()) {
                    log.debug(String.format("%d type:%s sql:%s", rdbmsExecuteCount, ddlType, sql.toString()));
                    log.debug(String.format("%d type:%s sqlParam:%s", rdbmsExecuteCount, ddlType, Objects.isNull(sqlParams) ? "null" : Arrays.asList(sqlParams).toString()));
                }
                try {
                    this.dao.getQueryRunner().update(sql);
                }
                catch (Exception e) {
                    log.debug("code({}) drop model code with something message({})", (Object)modelCodeName, (Object)e.getMessage());
                }
                finally {
                    log.debug("code({}) drop model code finished", (Object)modelCodeName);
                }
                ++tableExecuteCount;
            }
        }
        returnValue.put("rdbmsExecuteCount", rdbmsExecuteCount);
        returnValue.put("tableExecuteCount", tableExecuteCount);
        result = EaiResultUtil.getDWEAIResult(returnValue);
        return result;
    }

    public boolean checkTableExist(String dbTableName) {
        boolean tableExisted = true;
        try {
            DWDataSetOperationOption option = ModelDataUtil.getDisabledCommonDataSetOperationOption();
            List daoQueryResult = this.dao.select((IDWSQLOptions)option, String.format(_sql_table_existed, dbTableName), new Object[0]);
            if (CollectionUtils.isEmpty((Collection)daoQueryResult)) {
                tableExisted = false;
            }
            log.debug("[DBExecuteHandler] realTableName({}) tableExisted={}", (Object)dbTableName, (Object)tableExisted);
        }
        catch (Exception e) {
            StringBuffer message = new StringBuffer();
            tableExisted = false;
            if (e != null && e.getCause() instanceof SQLException) {
                SQLException sqlException = (SQLException)e.getCause();
                message = message.append(String.format("sqlState(%s), sqlErrorCode(%d), sqlMessage(%s)", sqlException.getSQLState(), sqlException.getErrorCode(), sqlException.getMessage()));
            }
            log.warn("[DBExecuteHandler] realTableName({}) is not valid, message:{}", (Object)dbTableName, (Object)message);
        }
        return tableExisted;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List getCreateTableSqlByDBFunc(String dbTableName) {
        List returnValue = new ArrayList();
        try {
            Object option;
            boolean isTableExist = this.checkTableExist(dbTableName);
            if (isTableExist) {
                option = ModelDataUtil.getDisabledCommonDataSetOperationOption();
                returnValue = this.dao.select((IDWSQLOptions)option, "show create table `" + dbTableName + "`", new Object[0]);
                log.debug("[DBExecuteHandler] realTableName({}) create table sql: {}", (Object)dbTableName, returnValue);
            }
            option = returnValue;
            return option;
        }
        catch (Exception e) {
            StringBuffer message = new StringBuffer();
            if (e != null) {
                Throwable throwable = e.getCause();
                if (throwable instanceof SQLException) {
                    SQLException sqlException = (SQLException)throwable;
                    message = message.append(String.format("sqlState(%s), sqlErrorCode(%d), sqlMessage(%s)", sqlException.getSQLState(), sqlException.getErrorCode(), sqlException.getMessage()));
                } else {
                    message = message.append(throwable.getMessage());
                }
            }
            log.warn("[DBExecuteHandler] realTableName({}) is not valid, message:{}", (Object)dbTableName, (Object)message);
        }
        finally {
            return returnValue;
        }
    }

    public List<String> getTableNamesGeneratedByModelDriven(List<String> tableNames) {
        List queryTableNames = tableNames.stream().distinct().collect(Collectors.toList());
        DWDataSetOperationOption option = ModelDataUtil.getDisabledCommonDataSetOperationOption();
        DWQueryInfo queryInfo = new DWQueryInfo();
        queryInfo.setTableName("dw_lcdp_model_info");
        queryInfo.setDistinct(true);
        queryInfo.setSelectFields(new String[]{"table_name"});
        DWQueryCondition condition = new DWQueryCondition();
        condition.addFieldInfo("table_name", DWQueryValueOperator.In, queryTableNames.toArray());
        queryInfo.setCondition(condition);
        DWDataSet daoResult = this.dao.select(queryInfo, option);
        DWDataTable dataTable = daoResult.getTable("dw_lcdp_model_info");
        List<String> distinctTableNames = dataTable.getRows().stream().map(dwDataRow -> (String)dwDataRow.get("table_name")).collect(Collectors.toList());
        return distinctTableNames;
    }

    public static void executeSqlCommands(DWDao dwdao, List<String> sqlCommands) throws SQLException {
        if (CollectionUtils.isNotEmpty(sqlCommands)) {
            StopWatch stopWatch = StopWatch.createStarted();
            try (Connection connection = dwdao.getQueryRunner().getDataSource().getConnection();){
                Statement statement = connection.createStatement();
                AtomicInteger index = new AtomicInteger(1);
                sqlCommands.forEach(sql -> {
                    try {
                        log.debug("{}[executeSqlCommands][{}] add sql to batch({})", new Object[]{logTag, index.getAndIncrement(), sql});
                        statement.addBatch((String)sql);
                    }
                    catch (SQLException e) {
                        throw new RuntimeException(e);
                    }
                });
                log.debug("{} starting execute sqls ...", (Object)logTag);
                statement.executeBatch();
                stopWatch.stop();
                log.info("{} result: finished execute {} sqls(cost:{} ms)", new Object[]{logTag, sqlCommands.size(), stopWatch.getTime()});
            }
            catch (Exception e) {
                stopWatch.stop();
                log.info("{} result: exception when execute {} sqls(cost:{} ms)", new Object[]{logTag, sqlCommands.size(), stopWatch.getTime()});
                e.printStackTrace();
            }
        } else {
            log.warn("{} result: no sqls to be executed", (Object)logTag);
        }
    }
}

