/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.lcdp.modeldriven.utils;

import com.digiwin.app.service.eai.DWEAIHeader;
import com.digiwin.app.service.eai.DWEAIHeaderRepository;
import com.digiwin.app.service.eai.DWEAIServiceDefinitionParser;
import com.digiwin.lcdp.modeldriven.customize.BMProperties;
import com.digiwin.lcdp.modeldriven.customize.BMRole;
import com.digiwin.lcdp.modeldriven.customize.model.BMDataEaiMethodRepository;
import com.digiwin.lcdp.modeldriven.customize.model.BMEaiMethodRepository;
import com.digiwin.lcdp.modeldriven.customize.pojo.BMCode;
import com.digiwin.lcdp.modeldriven.customize.utils.BMCenterUtil;
import com.digiwin.lcdp.modeldriven.model.ModelDrivenEaiMethodRepository;
import com.digiwin.lcdp.modeldriven.pojo.DWServiceMapping;
import com.digiwin.lcdp.modeldriven.pojo.MappingModelInfo;
import com.digiwin.lcdp.modeldriven.pojo.ModelDrivenEaiMethodDTO;
import com.digiwin.lcdp.modeldriven.utils.EaiServiceNameUtil;
import com.digiwin.lcdp.modeldriven.utils.ModelDrivenMethodHelper;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Component;

@Component
public class EaiHeaderUtil {
    private static final Logger log = LoggerFactory.getLogger(EaiHeaderUtil.class);
    @Autowired
    DWEAIHeaderRepository dwEAIHeaderRepository;
    @Autowired
    DWEAIServiceDefinitionParser dwEaiServiceDefinitionParser;
    @Autowired
    @Qualifier(value="dw-modeldriven-eai-repo")
    ModelDrivenEaiMethodRepository modelDrivenEaiMethodRepo;
    @Autowired(required=false)
    @Qualifier(value="lcdp-bm-eai-method-repo")
    BMEaiMethodRepository bmEaiMethodRepository;
    @Autowired(required=false)
    @Qualifier(value="lcdp-bmd-eai-method-repo")
    BMDataEaiMethodRepository bmdEaiMethodRepository;
    @Autowired(required=false)
    @Qualifier(value="bmCodes")
    Map<String, BMCode> bmCodes;

    public List<DWEAIHeader> updateAndGetModelDrivenEaiHeaders(List<DWServiceMapping> serviceMappings, List<MappingModelInfo> mappingModelInfos) throws Exception {
        ArrayList<DWEAIHeader> newEaiHeaders = new ArrayList<DWEAIHeader>();
        Method setMappingMethod = ModelDrivenMethodHelper.getSetMappingMethodAccessibleOfDWEAIHeader();
        Optional<Class<?>> stdEaiCrudClazz = this.modelDrivenEaiMethodRepo.getEaiClazz();
        for (DWServiceMapping eaiService : serviceMappings) {
            String eaiTableName = eaiService.getTableName();
            log.info("[EaiHeaderUtil] enter md master eai service , table_name({})", (Object)eaiTableName);
            String userExposePrefixEaiId = eaiService.getExposeEaiId();
            String eaiProd = EaiServiceNameUtil.getEaiProd(eaiTableName, userExposePrefixEaiId);
            log.debug("[EaiHeaderUtil] serviceMapping: prod({}) eaiService({}) process table_name({}) expose_ea_id({}})", new Object[]{eaiProd, eaiService.toString(), eaiTableName, userExposePrefixEaiId});
            BMProperties bmProperties = BMProperties.getProperties();
            if (bmProperties != null && bmProperties.isEnabled()) {
                if (BMProperties.getProperties().getRole() == BMRole.bm) {
                    List<DWEAIHeader> bmEaiHeaders = this.getBMEaiHeaders(setMappingMethod, eaiService, this.bmEaiMethodRepository);
                    this.bmEaiMethodRepository.addEaiHeaders(bmEaiHeaders);
                    newEaiHeaders.addAll(bmEaiHeaders);
                    continue;
                }
                if (BMProperties.getProperties().getRole() == BMRole.bmd) {
                    String targetProdOfDWServiceMapping = eaiService.getTargetProd();
                    String targetProdOfSite = BMCenterUtil.getProdOfSite();
                    if (StringUtils.isNotBlank((CharSequence)targetProdOfDWServiceMapping) && targetProdOfSite.equalsIgnoreCase(targetProdOfDWServiceMapping)) {
                        List<DWEAIHeader> bmdEaiHeaders = this.getBMDataEaiHeaders(setMappingMethod, eaiService, this.bmdEaiMethodRepository);
                        this.bmdEaiMethodRepository.addEaiHeaders(bmdEaiHeaders);
                        log.debug("[EaiHeaderUtil] targetProd matched, actual({}), expected(site:{})", (Object)targetProdOfDWServiceMapping, (Object)targetProdOfSite);
                        continue;
                    }
                    log.info("[EaiHeaderUtil] targetProd not match, actual({}), expected(site:{})", (Object)targetProdOfDWServiceMapping, (Object)targetProdOfSite);
                    continue;
                }
                log.debug("[EaiHeaderUtil] enter md master eai service");
                continue;
            }
            List<DWEAIHeader> stdEaiHeaders = this.getStdEaiHeaders(setMappingMethod, eaiService, this.modelDrivenEaiMethodRepo);
            newEaiHeaders.addAll(stdEaiHeaders);
        }
        if (mappingModelInfos.size() > 0) {
            List<DWEAIHeader> stdListGetHeaders;
            if (BMProperties.getProperties() != null) {
                if (BMProperties.getProperties().getRole() == BMRole.bm) {
                    Method bmListGetMethod = this.bmEaiMethodRepository.getListGetMethod();
                    Optional<Class<?>> bmEaiCrudClazz = this.bmEaiMethodRepository.getEaiClazz();
                    List<MappingModelInfo> bmMappingModelInfos = mappingModelInfos.stream().filter(mappingModelInfo -> mappingModelInfo.getTargetProd() != null).collect(Collectors.toList());
                    List<DWEAIHeader> bmSubListGetHeaders = this.getBMListGetHeaders(setMappingMethod, bmEaiCrudClazz, bmListGetMethod, bmMappingModelInfos);
                    newEaiHeaders.addAll(bmSubListGetHeaders);
                    List<MappingModelInfo> stdMappingModelInfo = mappingModelInfos.stream().filter(mappingModelInfo -> mappingModelInfo.getTargetProd() == null).collect(Collectors.toList());
                    Method stdListGetMethod = this.modelDrivenEaiMethodRepo.getListGetMethod();
                    List<DWEAIHeader> stdListGetHeaders2 = this.getStdListGetHeaders(setMappingMethod, stdEaiCrudClazz, stdListGetMethod, stdMappingModelInfo);
                    newEaiHeaders.addAll(stdListGetHeaders2);
                } else if (BMProperties.getProperties().getRole() == BMRole.bmd) {
                    Method stdListGetMethod = this.modelDrivenEaiMethodRepo.getListGetMethod();
                    List<MappingModelInfo> bmdMappingModelInfo = mappingModelInfos.stream().filter(mappingModelInfo -> mappingModelInfo.getTargetProd() != null).collect(Collectors.toList());
                    List<DWEAIHeader> bmdListGetHeaders = this.getBMDataListGetHeaders(setMappingMethod, stdEaiCrudClazz, stdListGetMethod, bmdMappingModelInfo);
                    this.bmdEaiMethodRepository.addEaiHeaders(bmdListGetHeaders);
                    List<MappingModelInfo> stdMappingModelInfos = mappingModelInfos.stream().filter(mappingModelInfo -> StringUtils.isBlank((CharSequence)mappingModelInfo.getTargetProd())).collect(Collectors.toList());
                    List<DWEAIHeader> stdListGetHeaders3 = this.getStdListGetHeaders(setMappingMethod, stdEaiCrudClazz, stdListGetMethod, stdMappingModelInfos);
                    newEaiHeaders.addAll(stdListGetHeaders3);
                } else {
                    stdListGetHeaders = this.getStdListGetEAIHeaders(setMappingMethod, stdEaiCrudClazz, mappingModelInfos);
                    newEaiHeaders.addAll(stdListGetHeaders);
                }
            } else {
                stdListGetHeaders = this.getStdListGetEAIHeaders(setMappingMethod, stdEaiCrudClazz, mappingModelInfos);
                newEaiHeaders.addAll(stdListGetHeaders);
            }
        }
        this.addAndUpdateDWEaiHeaders(newEaiHeaders);
        return newEaiHeaders;
    }

    public void addAndUpdateDWEaiHeaders(List<DWEAIHeader> newEaiHeaders) throws Exception {
        if (CollectionUtils.isNotEmpty(newEaiHeaders)) {
            List orgDWHeaders = this.dwEAIHeaderRepository.getHeaders("commons");
            int mdHeaderCount = newEaiHeaders.size();
            int orgHeaderCount = orgDWHeaders.size();
            newEaiHeaders.stream().forEach(tempHeader -> orgDWHeaders.add(tempHeader));
            Method registerHeaderMethod = ModelDrivenMethodHelper.getRegisterHeaderAccessibleOfDWEAIServiceDefinitionParser();
            registerHeaderMethod.invoke((Object)this.dwEaiServiceDefinitionParser, "commons", orgDWHeaders);
            log.info("[{}] refresh DWEAIHeaderRepository size(total({}) = org({}) + modeldriven({}))", new Object[]{"dw-modeldriven-service-commons-mapping-provider", orgDWHeaders.size(), orgHeaderCount, mdHeaderCount});
        } else {
            log.info("[{}] ignored refresh DWEAIHeaderRepository ", (Object)"dw-modeldriven-service-commons-mapping-provider");
        }
    }

    public List<DWEAIHeader> getStdEaiHeaders(Method setMappingMethod, DWServiceMapping eaiService, ModelDrivenEaiMethodRepository mdEaiMethodRepo) throws InvocationTargetException, IllegalAccessException {
        ArrayList<DWEAIHeader> newEaiHeaders = new ArrayList<DWEAIHeader>();
        Map<String, ModelDrivenEaiMethodDTO> mdEaiMethods = mdEaiMethodRepo.getEaiMethodRepo();
        Optional<Class<?>> eaiClazz = mdEaiMethodRepo.getEaiClazz();
        log.info("[EaiHeaderUtil] enter md master eai service");
        String eaiTableName = eaiService.getTableName();
        String userExposePrefixEaiId = eaiService.getExposeEaiId();
        String eaiProd = EaiServiceNameUtil.getEaiProd(eaiTableName, userExposePrefixEaiId);
        log.debug("[EaiHeaderUtil] serviceMapping: prod({}) eaiService({}) process table_name({}) expose_ea_id({}})", new Object[]{eaiProd, eaiService.toString(), eaiTableName, userExposePrefixEaiId});
        for (Map.Entry<String, ModelDrivenEaiMethodDTO> mdEaiMethod : mdEaiMethods.entrySet()) {
            ModelDrivenEaiMethodDTO mdEaiMethodDTO = mdEaiMethod.getValue();
            String eaiServiceIdForServiceMapping = String.join((CharSequence)".", userExposePrefixEaiId, mdEaiMethodDTO.getEaiServicePostfix());
            DWEAIHeader headerV = new DWEAIHeader("commons", eaiServiceIdForServiceMapping, eaiClazz.get());
            setMappingMethod.invoke((Object)headerV, mdEaiMethodDTO.getMethod(), false);
            newEaiHeaders.add(headerV);
            this.bmCodes.put(eaiServiceIdForServiceMapping, new BMCode(eaiService.getCode(), eaiService.getTargetProd()));
            log.debug("[EaiHeaderUtil] serviceMapping: add headerV expose_eai_id({})", (Object)headerV.getEAIServiceId());
        }
        return newEaiHeaders;
    }

    public List<DWEAIHeader> getBMEaiHeaders(Method setMappingMethod, DWServiceMapping eaiService, BMEaiMethodRepository bmEaiMethodRepo) throws InvocationTargetException, IllegalAccessException {
        ArrayList<DWEAIHeader> newEaiHeaders = new ArrayList<DWEAIHeader>();
        Map<String, ModelDrivenEaiMethodDTO> mdEaiMethods = bmEaiMethodRepo.getEaiMethodRepo();
        Optional<Class<?>> eaiClazz = bmEaiMethodRepo.getEaiClazz();
        log.info("[EaiHeaderUtil] enter md master eai service");
        String eaiTableName = eaiService.getTableName();
        String userExposePrefixEaiId = eaiService.getExposeEaiId();
        String eaiProd = EaiServiceNameUtil.getEaiProd(eaiTableName, userExposePrefixEaiId);
        log.debug("[EaiHeaderUtil] serviceMapping: prod({}) eaiService({}) process table_name({}) expose_ea_id({}})", new Object[]{eaiProd, eaiService.toString(), eaiTableName, userExposePrefixEaiId});
        for (Map.Entry<String, ModelDrivenEaiMethodDTO> mdEaiMethod : mdEaiMethods.entrySet()) {
            ModelDrivenEaiMethodDTO mdEaiMethodDTO = mdEaiMethod.getValue();
            String eaiServiceIdForServiceMapping = String.join((CharSequence)".", userExposePrefixEaiId, mdEaiMethodDTO.getEaiServicePostfix());
            DWEAIHeader headerV = new DWEAIHeader("commons", eaiServiceIdForServiceMapping, eaiClazz.get());
            setMappingMethod.invoke((Object)headerV, mdEaiMethodDTO.getMethod(), false);
            newEaiHeaders.add(headerV);
            this.bmCodes.put(eaiServiceIdForServiceMapping, new BMCode(eaiService.getCode(), eaiService.getTargetProd()));
            log.debug("[EaiHeaderUtil] *** BM *** serviceMapping: add headerV expose_eai_id({})", (Object)headerV.getEAIServiceId());
        }
        return newEaiHeaders;
    }

    public List<DWEAIHeader> getBMDataEaiHeaders(Method setMappingMethod, DWServiceMapping eaiService, BMDataEaiMethodRepository bmdEaiMethodRepo) throws InvocationTargetException, IllegalAccessException {
        ArrayList<DWEAIHeader> newEaiHeaders = new ArrayList<DWEAIHeader>();
        String targetProdOfDWServiceMapping = eaiService.getTargetProd();
        String targetProdOfCode = BMCenterUtil.getEaiServicePrefix(targetProdOfDWServiceMapping);
        Map<String, ModelDrivenEaiMethodDTO> mdEaiMethods = bmdEaiMethodRepo.getEaiMethodRepo();
        log.info("[EaiHeaderUtil] enter BMD master eai service");
        String eaiTableName = eaiService.getTableName();
        String bmdEaiId = EaiServiceNameUtil.covertToServiceName(eaiTableName);
        String bmdPrefixExposeEaiId = String.join((CharSequence)".", targetProdOfCode, bmdEaiId);
        log.debug("[EaiHeaderUtil] *** BMD *** serviceMapping: expose_eai_id prefix({}) from target prod ({}->{}), table_name({})", new Object[]{bmdPrefixExposeEaiId, targetProdOfDWServiceMapping, targetProdOfCode, eaiTableName});
        for (Map.Entry<String, ModelDrivenEaiMethodDTO> mdEaiMethod : mdEaiMethods.entrySet()) {
            ModelDrivenEaiMethodDTO mdEaiMethodDTO = mdEaiMethod.getValue();
            Optional<Class<?>> eaiClazz = Optional.of(mdEaiMethodDTO.getMethod().getDeclaringClass());
            String eaiServiceIdForServiceMapping = String.join((CharSequence)".", bmdPrefixExposeEaiId, mdEaiMethodDTO.getEaiServicePostfix());
            DWEAIHeader headerV = new DWEAIHeader("commons", eaiServiceIdForServiceMapping, eaiClazz.get());
            setMappingMethod.invoke((Object)headerV, mdEaiMethodDTO.getMethod(), false);
            newEaiHeaders.add(headerV);
            log.debug("[EaiHeaderUtil] serviceMapping: add headerV expose_eai_id({})", (Object)headerV.getEAIServiceId());
        }
        return newEaiHeaders;
    }

    public List<DWEAIHeader> getStdListGetHeaders(Method setMappingMethod, Optional<Class<?>> eaiClazz, Method listGetMethod, List<MappingModelInfo> mappingModelInfos) throws InvocationTargetException, IllegalAccessException {
        ArrayList<DWEAIHeader> childTableListGetHeaders = new ArrayList<DWEAIHeader>();
        if (mappingModelInfos.size() > 0 && listGetMethod != null) {
            log.info("[EaiHeaderUtil][getStdListGetHeaders] enter children .list.get");
            int modelinfoCount = 1;
            for (MappingModelInfo mappingModelInfo : mappingModelInfos) {
                String childTableName = mappingModelInfo.getChildtbl();
                String eaiTableName = mappingModelInfo.getTablename();
                String userExposePrefixEaiId = mappingModelInfo.getEaiid();
                String eaiProd = EaiServiceNameUtil.getEaiProd(eaiTableName, userExposePrefixEaiId);
                if (log.isDebugEnabled()) {
                    log.debug("[EaiHeaderUtil][getStdListGetHeaders] [{}] serviceMapping-child: prod({}), child table({}), tableName({}), code({})", new Object[]{modelinfoCount++, eaiProd, childTableName, eaiTableName, mappingModelInfo.getCode()});
                }
                if (!StringUtils.equals((CharSequence)childTableName, (CharSequence)eaiTableName)) {
                    String childEaiServiceIdForServiceMapping = EaiServiceNameUtil.getChildListGetEaiServiceId(eaiProd, childTableName);
                    DWEAIHeader headerV = new DWEAIHeader("commons", childEaiServiceIdForServiceMapping, eaiClazz.get());
                    setMappingMethod.invoke((Object)headerV, listGetMethod, false);
                    childTableListGetHeaders.add(headerV);
                    if (log.isDebugEnabled()) {
                        log.debug("     --->> add eai service id:({}) by code [{}] ", (Object)headerV.getEAIServiceId(), (Object)mappingModelInfo.getCode());
                    }
                    if (BMProperties.getProperties() == null || BMProperties.getProperties().getRole() != BMRole.bm) continue;
                    this.bmCodes.put(childEaiServiceIdForServiceMapping, new BMCode(mappingModelInfo.getCode(), mappingModelInfo.getTargetProd()));
                    continue;
                }
                log.debug("     --->> ignored add eai service id: cause childTableName({}) equals eaiTableName ({})", (Object)childTableName, (Object)eaiTableName);
            }
            log.info("[EaiHeaderUtil][getStdListGetHeaders] serviceMapping: children table .list.get count:{}", (Object)childTableListGetHeaders.size());
        } else {
            log.warn("[EaiHeaderUtil][getStdListGetHeaders] serviceMapping: ignored to generate children .list.get service(serviceMapping size({}), listGetMethod({})", (Object)0, (Object)listGetMethod);
        }
        return childTableListGetHeaders;
    }

    public List<DWEAIHeader> getBMListGetHeaders(Method setMappingMethod, Optional<Class<?>> eaiClazz, Method listGetMethod, List<MappingModelInfo> mappingModelInfos) throws InvocationTargetException, IllegalAccessException {
        ArrayList<DWEAIHeader> childTableListGetHeaders = new ArrayList<DWEAIHeader>();
        if (mappingModelInfos.size() > 0 && listGetMethod != null) {
            log.info("[EaiHeaderUtil][getBMListGetHeaders] enter children .list.get");
            int modelinfoCount = 1;
            for (MappingModelInfo mappingModelInfo : mappingModelInfos) {
                String childTableName = mappingModelInfo.getChildtbl();
                String eaiTableName = mappingModelInfo.getTablename();
                String userExposePrefixEaiId = mappingModelInfo.getEaiid();
                String eaiProd = EaiServiceNameUtil.getEaiProd(eaiTableName, userExposePrefixEaiId);
                if (log.isDebugEnabled()) {
                    log.debug("[EaiHeaderUtil] [{}] *** BM *** code({}), serviceMapping-child: prod({}), child table({}), tableName({})", new Object[]{mappingModelInfo.getCode(), modelinfoCount++, eaiProd, childTableName, eaiTableName});
                }
                if (!StringUtils.equals((CharSequence)childTableName, (CharSequence)eaiTableName)) {
                    String childEaiServiceIdForServiceMapping = EaiServiceNameUtil.getChildListGetEaiServiceId(eaiProd, childTableName);
                    DWEAIHeader headerV = new DWEAIHeader("commons", childEaiServiceIdForServiceMapping, eaiClazz.get());
                    setMappingMethod.invoke((Object)headerV, listGetMethod, false);
                    childTableListGetHeaders.add(headerV);
                    if (log.isDebugEnabled()) {
                        log.debug("     --->> add eai service id:({}) by code [{}] ", (Object)headerV.getEAIServiceId(), (Object)mappingModelInfo.getCode());
                    }
                    this.bmCodes.put(childEaiServiceIdForServiceMapping, new BMCode(mappingModelInfo.getCode(), mappingModelInfo.getTargetProd()));
                    continue;
                }
                log.debug("     --->> ignored add eai service id: cause childTableName({}) equals eaiTableName ({})", (Object)childTableName, (Object)eaiTableName);
            }
            log.info("[EaiHeaderUtil] serviceMapping: children table .list.get count:{}", (Object)childTableListGetHeaders.size());
        } else {
            log.warn("[EaiHeaderUtil] serviceMapping: ignored to generate children .list.get service(serviceMapping size({}), listGetMethod({})", (Object)0, (Object)listGetMethod);
        }
        return childTableListGetHeaders;
    }

    public List<DWEAIHeader> getBMDataListGetHeaders(Method setMappingMethod, Optional<Class<?>> eaiClazz, Method listGetMethod, List<MappingModelInfo> mappingModelInfos) throws InvocationTargetException, IllegalAccessException {
        ArrayList<DWEAIHeader> childTableListGetHeaders = new ArrayList<DWEAIHeader>();
        if (mappingModelInfos.size() > 0 && listGetMethod != null) {
            log.info("[EaiHeaderUtil] EaiServiceUtil] enter children .list.get");
            int modelinfoCount = 1;
            for (MappingModelInfo mappingModelInfo : mappingModelInfos) {
                String childTableName = mappingModelInfo.getChildtbl();
                String eaiTableName = mappingModelInfo.getTablename();
                String targetProdOfDWServiceMapping = mappingModelInfo.getTargetProd();
                String targetProdOfCode = BMCenterUtil.getEaiServicePrefix(targetProdOfDWServiceMapping);
                if (log.isDebugEnabled()) {
                    log.debug("[EaiHeaderUtil] [{}] code({}) serviceMapping-child: target_prod({}), child table({}), tableName({})", new Object[]{modelinfoCount++, mappingModelInfo.getCode(), targetProdOfCode, childTableName, eaiTableName});
                }
                if (!StringUtils.equals((CharSequence)childTableName, (CharSequence)eaiTableName)) {
                    String bmdEaiId = EaiServiceNameUtil.covertToServiceName(childTableName);
                    String childEaiServiceIdForServiceMapping = String.join((CharSequence)".", targetProdOfCode, bmdEaiId, "get");
                    log.info("[EaiHeaderUtil] *** BMD *** code({}), serviceMapping-child: childEaiServiceIdForServiceMapping({})", (Object)mappingModelInfo.getCode(), (Object)childEaiServiceIdForServiceMapping);
                    DWEAIHeader headerV = new DWEAIHeader("commons", childEaiServiceIdForServiceMapping, eaiClazz.get());
                    setMappingMethod.invoke((Object)headerV, listGetMethod, false);
                    childTableListGetHeaders.add(headerV);
                    if (!log.isDebugEnabled()) continue;
                    log.debug("     --->> add eai service id:({}) by code [{}] ", (Object)headerV.getEAIServiceId(), (Object)mappingModelInfo.getCode());
                    continue;
                }
                log.debug("     --->> ignored add eai service id: cause childTableName({}) equals eaiTableName ({})", (Object)childTableName, (Object)eaiTableName);
            }
            log.info("[EaiHeaderUtil][getBMDataListGetHeaders] serviceMapping: children table .list.get count:{}", (Object)childTableListGetHeaders.size());
        } else {
            log.warn("[EaiHeaderUtil][getBMDataListGetHeaders] serviceMapping: ignored to generate children .list.get service(serviceMapping size({}), listGetMethod({})", (Object)0, (Object)listGetMethod);
        }
        return childTableListGetHeaders;
    }

    public List<DWEAIHeader> getStdListGetEAIHeaders(Method setMappingMethod, Optional<Class<?>> eaiClazz, List<MappingModelInfo> mappingModelInfos) throws InvocationTargetException, IllegalAccessException {
        Method stdListGetMethod = this.modelDrivenEaiMethodRepo.getListGetMethod();
        List<DWEAIHeader> stdListGetHeaders = this.getStdListGetHeaders(setMappingMethod, eaiClazz, stdListGetMethod, mappingModelInfos);
        return stdListGetHeaders;
    }
}

