/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.lcdp.modeldriven.utils;

import com.digiwin.lcdp.modeldriven.utils.DBTableUtil;
import java.util.List;
import net.sf.jsqlparser.statement.create.table.ColDataType;
import net.sf.jsqlparser.statement.create.table.ColumnDefinition;
import net.sf.jsqlparser.statement.create.table.CreateTable;
import net.sf.jsqlparser.statement.select.PlainSelect;
import org.apache.commons.lang3.StringUtils;

public class ModelDrivenCCJParserUtil {
    public static String getColumn(ColumnDefinition columnDefinition) {
        String columnName = columnDefinition.getColumnName();
        ColDataType colDataType = columnDefinition.getColDataType();
        String dataType = colDataType.getDataType();
        String argStr = PlainSelect.getStringList((List)colDataType.getArgumentsStringList(), (boolean)false, (boolean)false);
        String columnStr = String.join((CharSequence)" ", columnName, dataType, argStr);
        return columnStr;
    }

    public static String getArgs(ColumnDefinition columnDefinition) {
        ColDataType colDataType = columnDefinition.getColDataType();
        String argStr = PlainSelect.getStringList((List)colDataType.getArgumentsStringList(), (boolean)true, (boolean)true);
        return argStr;
    }

    public static String getComment(ColumnDefinition columnDefinition) {
        ColDataType colDataType = columnDefinition.getColDataType();
        List columnSpecStrings = columnDefinition.getColumnSpecs();
        String comment = ModelDrivenCCJParserUtil.getComment(columnSpecStrings);
        return comment;
    }

    private static String getComment(List<String> columnSpecStrings) {
        int commentIndex = ModelDrivenCCJParserUtil.getCommentIndex(columnSpecStrings);
        String commentString = "";
        if (commentIndex != -1) {
            int commentStringIndex = commentIndex + 1;
            commentString = columnSpecStrings.get(commentStringIndex);
        }
        if (StringUtils.isNotBlank((CharSequence)commentString)) {
            commentString = DBTableUtil.removeApostropheSymbol(commentString);
        }
        return commentString;
    }

    private static int getCommentIndex(List<String> columnSpecStrings) {
        for (int i = 0; i < columnSpecStrings.size(); ++i) {
            if (!"COMMENT".equalsIgnoreCase(columnSpecStrings.get(i))) continue;
            return i;
        }
        return -1;
    }

    public static String getTableComment(CreateTable createTable) {
        String tableName = createTable.getTable().getName();
        List tableOptions = createTable.getTableOptionsStrings();
        String tableCommentSql = null;
        int commentIndex = tableOptions.indexOf("COMMENT");
        if (commentIndex != -1) {
            tableCommentSql = String.format("COMMENT ON TABLE %s IS %s;", tableName, tableOptions.get(commentIndex + 2));
        }
        return tableCommentSql;
    }
}

