/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.lcdp.modeldriven.utils;

import com.digiwin.app.container.exceptions.DWBusinessException;
import com.digiwin.app.resource.DWApplicationMessageResourceBundleUtils;
import com.digiwin.lcdp.modeldriven.context.ModelDrivenContext;
import com.digiwin.lcdp.modeldriven.enums.AlterColumnEnum;
import com.digiwin.lcdp.modeldriven.enums.AlterIndexEnum;
import com.digiwin.lcdp.modeldriven.enums.PublishStatusEnum;
import com.digiwin.lcdp.modeldriven.model.ModelIndexDTO;
import com.digiwin.lcdp.modeldriven.model.ModelSchemaDTO;
import com.digiwin.lcdp.modeldriven.model.ModelTable;
import com.digiwin.lcdp.modeldriven.model.ModelTableSchemaCache;
import com.digiwin.lcdp.modeldriven.model.SqlParam;
import com.digiwin.lcdp.modeldriven.model.TableColumn;
import com.digiwin.lcdp.modeldriven.model.TableIndex;
import com.digiwin.lcdp.modeldriven.utils.ModelDataUtil;
import com.digiwin.lcdp.modeldriven.utils.ModelIndexUtil;
import com.digiwin.lcdp.modeldriven.utils.ModelSchemaUtil;
import com.digiwin.lcdp.modeldriven.utils.ModelSqlGenerator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ModelTableSqlGenerator {
    private static final Logger log = LoggerFactory.getLogger(ModelTableSqlGenerator.class);

    public static Map<String, LinkedHashMap<String, List<SqlParam>>> filterAlterTableCommand(ModelSchemaDTO draftModelSchema, ModelSchemaDTO publishedModelSchema) throws Exception {
        ModelSchemaUtil.checkModelSchema(draftModelSchema, false);
        ModelSchemaUtil.checkModelSchema(publishedModelSchema, false);
        String masterTableName = draftModelSchema.getName();
        HashMap<String, LinkedHashMap<String, List<SqlParam>>> returnValue = new HashMap<String, LinkedHashMap<String, List<SqlParam>>>();
        log.debug("=============== express alterTable ====== {} =========", (Object)masterTableName);
        List<String> childrenTableNames = ModelDataUtil.getChildrenName(draftModelSchema);
        log.debug("alterTable starting....masterTableName({}) childrenTableNames({}) ", (Object)masterTableName, childrenTableNames);
        AtomicReference<PublishStatusEnum> alterStatus = new AtomicReference<PublishStatusEnum>(PublishStatusEnum.UNCHANGED);
        if (!Objects.equals(draftModelSchema.getName(), publishedModelSchema.getName())) {
            throw new DWBusinessException("published_notsupport_tablename_rename");
        }
        LinkedHashMap alterMap = new LinkedHashMap();
        LinkedList<SqlParam> alterDMLSqlParam = new LinkedList<SqlParam>();
        LinkedList<SqlParam> alterDDLSqlParam = new LinkedList<SqlParam>();
        ModelTable masterDraftSimpleModelTable = ModelSchemaUtil.getCurrentLevelModelTable(draftModelSchema);
        ModelTable masterPublishedSimpleModelTable = ModelSchemaUtil.getCurrentLevelModelTable(publishedModelSchema);
        List<String> publishedRemainPks = ModelSchemaUtil.getPrimaryKeys(masterPublishedSimpleModelTable.getColumns());
        List<ModelIndexDTO> publishedTableIndexes = ModelIndexUtil.getModelTableAllIndexes(publishedModelSchema);
        Map<String, Object> publishedRemainIndexes = ModelIndexUtil.getIndexes(publishedTableIndexes);
        Map<String, ModelTableSchemaCache> publishedTableCache = ModelDrivenContext.getContext().getPublishedTableCache();
        ModelTableSchemaCache publishedTableSchemaCache = new ModelTableSchemaCache();
        publishedTableSchemaCache.setPublishedRemainIndexes(publishedRemainIndexes);
        publishedTableSchemaCache.setTableName(masterTableName);
        publishedTableCache.put(masterTableName, publishedTableSchemaCache);
        if (!Objects.equals(draftModelSchema.getComment(), publishedModelSchema.getComment())) {
            ModelTable modelTable = new ModelTable();
            modelTable.setName(draftModelSchema.getName());
            modelTable.setComment(draftModelSchema.getComment());
            LinkedHashMap<String, List<SqlParam>> alterComment = ModelSqlGenerator.getAlterTableInfo(modelTable);
            alterDMLSqlParam.addAll((Collection)alterComment.get("dml"));
            alterDDLSqlParam.addAll((Collection)alterComment.get("ddl"));
            alterStatus.set(PublishStatusEnum.CHANGED);
        }
        Map<AlterIndexEnum, List<TableIndex>> alterIndexesMap = ModelSqlGenerator.getAlterIndexesMap(draftModelSchema, publishedModelSchema);
        Map<AlterColumnEnum, List<TableColumn>> alterColumnsMap = ModelSchemaUtil.getAlterColumnsMap(draftModelSchema, publishedModelSchema, masterDraftSimpleModelTable, masterPublishedSimpleModelTable);
        if (MapUtils.isNotEmpty(alterColumnsMap) && alterColumnsMap.get((Object)AlterColumnEnum.DROP_COLUMN).size() > 0) {
            List<TableColumn> dropTableColumns = alterColumnsMap.get((Object)AlterColumnEnum.DROP_COLUMN);
            List<TableColumn> dropPKTableColumns = dropTableColumns.stream().filter(dropTableColumn -> dropTableColumn.isPK()).collect(Collectors.toList());
            if (CollectionUtils.isNotEmpty(dropPKTableColumns)) {
                List<String> dropPks = ModelSchemaUtil.getPrimaryKeys(dropPKTableColumns);
                dropPks.stream().forEach(dropPk -> publishedRemainPks.remove(dropPk));
                alterDDLSqlParam.addAll(ModelSqlGenerator.genDropOrAddPrimaryKey(masterPublishedSimpleModelTable.getName(), publishedRemainPks, true));
            }
            for (ModelIndexDTO publishedModelIndexDTO : publishedTableIndexes) {
                if (!CollectionUtils.isNotEmpty(publishedModelIndexDTO.getMember()) || publishedModelIndexDTO.getMember().size() <= 1) continue;
                log.debug("[ModelPublishService] process published {} ({}) ", (Object)publishedModelIndexDTO.getType(), (Object)publishedModelIndexDTO);
                ArrayList<String> droppedIndexMember = new ArrayList<String>();
                List<String> modelIndexMember = publishedModelIndexDTO.getMember();
                for (TableColumn dropTableColumn2 : dropTableColumns) {
                    if (!modelIndexMember.contains(dropTableColumn2.getColumnName())) continue;
                    droppedIndexMember.add(dropTableColumn2.getColumnName());
                }
                if (!CollectionUtils.isNotEmpty(droppedIndexMember)) continue;
                modelIndexMember.removeAll(droppedIndexMember);
                LinkedList<SqlParam> tempSqlParams = ModelSqlGenerator.genAlterTableUniqueIndex(masterPublishedSimpleModelTable, modelIndexMember, publishedModelIndexDTO);
                alterDDLSqlParam.addAll(tempSqlParams);
            }
        }
        if (MapUtils.isNotEmpty(alterColumnsMap)) {
            alterColumnsMap.forEach((alterColumnEnum, tableColumns) -> {
                if (!CollectionUtils.isEmpty((Collection)tableColumns)) {
                    ModelSqlGenerator.updateAlterColumnsInfoOnly(publishedModelSchema.getName(), alterColumnEnum, tableColumns, alterDDLSqlParam, alterDMLSqlParam);
                    alterStatus.set(PublishStatusEnum.CHANGED);
                }
            });
        }
        List<SqlParam> insertOrUpdateRdbmsFieldsParam = ModelSqlGenerator.generateInsertOrUpdateRdbmsFieldSql(masterDraftSimpleModelTable);
        alterDMLSqlParam.addAll(insertOrUpdateRdbmsFieldsParam);
        if (MapUtils.isNotEmpty(alterIndexesMap)) {
            alterIndexesMap.forEach((alterIndexEnum, tableColumns) -> {
                if (!CollectionUtils.isEmpty((Collection)tableColumns)) {
                    ModelSqlGenerator.getAlterIndexesInfo(publishedModelSchema.getName(), alterIndexEnum, tableColumns, alterDDLSqlParam);
                    alterStatus.set(PublishStatusEnum.CHANGED);
                }
            });
        }
        List<String> draftPks = ModelSchemaUtil.getPrimaryKeys(masterDraftSimpleModelTable.getColumns());
        log.debug("[ModelPublishService] draftPks({}), publishedRemainPks({}) ", draftPks, publishedRemainPks);
        if (CollectionUtils.isNotEmpty(publishedRemainPks)) {
            if (!CollectionUtils.isEqualCollection(draftPks, publishedRemainPks)) {
                alterDDLSqlParam.addAll(ModelSqlGenerator.genDropOrAddPrimaryKey(masterPublishedSimpleModelTable.getName(), draftPks, true));
            }
            log.debug("[ModelPublishService] ignored to modify pks, cause draftPks({}), publishedRemainPks({}) no changed.", draftPks, publishedRemainPks);
        } else {
            alterDDLSqlParam.addAll(ModelSqlGenerator.genDropOrAddPrimaryKey(masterPublishedSimpleModelTable.getName(), draftPks, false));
        }
        if (alterStatus.get() == PublishStatusEnum.CHANGED) {
            alterDDLSqlParam.addAll(ModelSqlGenerator.getAlterAutoIncrementSql(masterDraftSimpleModelTable));
        }
        if (!CollectionUtils.isEmpty(alterDMLSqlParam) || !CollectionUtils.isEmpty(alterDDLSqlParam)) {
            alterMap.put("ddl", alterDDLSqlParam);
            alterMap.put("dml", alterDMLSqlParam);
            returnValue.put(publishedModelSchema.getName(), alterMap);
        }
        return returnValue;
    }

    public static Map<String, LinkedHashMap<String, List<SqlParam>>> compareAndGetChildrenAlterData(List<ModelSchemaDTO> draftChildrenSchemas, List<ModelSchemaDTO> publishedChildrenSchemas) throws Exception {
        Map<String, LinkedHashMap<String, List<SqlParam>>> createChildrenTableCommandData;
        HashMap<String, LinkedHashMap<String, List<SqlParam>>> returnValue = new HashMap<String, LinkedHashMap<String, List<SqlParam>>>();
        if (CollectionUtils.isEmpty(draftChildrenSchemas) && CollectionUtils.isEmpty(publishedChildrenSchemas)) {
            return returnValue;
        }
        LinkedHashMap tempDDLDML = new LinkedHashMap();
        AtomicReference<PublishStatusEnum> alterStatus = new AtomicReference<PublishStatusEnum>(PublishStatusEnum.UNCHANGED);
        ArrayList dmlSqlParams = new ArrayList();
        ArrayList ddlSqlParams = new ArrayList();
        tempDDLDML.put("dml", dmlSqlParams);
        tempDDLDML.put("ddl", ddlSqlParams);
        boolean draftChildrenEmpty = CollectionUtils.isEmpty(draftChildrenSchemas);
        boolean publishedChildrenEmpty = CollectionUtils.isEmpty(publishedChildrenSchemas);
        if (draftChildrenEmpty && !publishedChildrenEmpty) {
            List<ModelTable> dropChildTableNames = publishedChildrenSchemas.stream().map(modelSchemaDTO -> ModelSchemaUtil.convertToSimpleModelTable(modelSchemaDTO)).collect(Collectors.toList());
            Map<String, LinkedHashMap<String, List<SqlParam>>> dropChildTableCommandData = ModelSqlGenerator.getDropChildTables(dropChildTableNames);
            returnValue.putAll(dropChildTableCommandData);
            alterStatus.set(PublishStatusEnum.CHANGED);
        }
        if (!draftChildrenEmpty && publishedChildrenEmpty && MapUtils.isNotEmpty(createChildrenTableCommandData = ModelSchemaUtil.getCreateChildTables(draftChildrenSchemas))) {
            returnValue.putAll(createChildrenTableCommandData);
            alterStatus.set(PublishStatusEnum.CHANGED);
        }
        if (!draftChildrenEmpty && !publishedChildrenEmpty) {
            List dropChildren;
            List<ModelSchemaDTO> newChildren = draftChildrenSchemas.stream().filter(draftChildModelSchema -> publishedChildrenSchemas.stream().noneMatch(publishedChildModelSchema -> Objects.equals(draftChildModelSchema.getName(), publishedChildModelSchema.getName()))).collect(Collectors.toList());
            if (CollectionUtils.isNotEmpty(newChildren)) {
                Map<String, LinkedHashMap<String, List<SqlParam>>> createChildrenTableCommandData2 = ModelSchemaUtil.getCreateChildTables(newChildren);
                returnValue.putAll(createChildrenTableCommandData2);
                alterStatus.set(PublishStatusEnum.CHANGED);
            }
            if (CollectionUtils.isNotEmpty(dropChildren = publishedChildrenSchemas.stream().filter(draftChildFModelSchema -> draftChildrenSchemas.stream().noneMatch(publishedChildFormSchema -> Objects.equals(draftChildFModelSchema.getName(), publishedChildFormSchema.getName()))).collect(Collectors.toList()))) {
                List<ModelTable> dropChildTableNames = dropChildren.stream().map(modelSchemaDTO -> ModelSchemaUtil.convertToSimpleModelTable(modelSchemaDTO)).collect(Collectors.toList());
                Map<String, LinkedHashMap<String, List<SqlParam>>> dropChildrenTableCommandData = ModelSqlGenerator.getDropChildTables(dropChildTableNames);
                returnValue.putAll(dropChildrenTableCommandData);
                alterStatus.set(PublishStatusEnum.CHANGED);
            }
        }
        draftChildrenSchemas.forEach(draftChildModelSchema -> publishedChildrenSchemas.stream().filter(publishedChildFormSchema -> Objects.equals(draftChildModelSchema.getName(), publishedChildFormSchema.getName())).findFirst().ifPresent(publishedChildFormSchema -> {
            try {
                Map<String, LinkedHashMap<String, List<SqlParam>>> childrenAlterData = ModelTableSqlGenerator.filterAlterTableCommand(draftChildModelSchema, publishedChildFormSchema);
                returnValue.putAll(childrenAlterData);
            }
            catch (Exception e) {
                String i18nMesg = DWApplicationMessageResourceBundleUtils.getString((String)"published_alter_table_detail_failed", (Object[])new Object[0]);
                log.error(i18nMesg + " -> draftChildModelSchema = {}, publishedChildModelSchema = {}", new Object[]{draftChildModelSchema, publishedChildFormSchema, e});
                throw new RuntimeException(i18nMesg, e);
            }
        }));
        return returnValue;
    }

    public static Map<String, LinkedHashMap<String, List<SqlParam>>> getChildrenFullLevelAlterTableCommands(String tableName, List<ModelSchemaDTO> draftChildrenSchemas, List<ModelSchemaDTO> publishedChildrenSchemas) throws Exception {
        Map<String, LinkedHashMap<String, List<SqlParam>>> returnValue = ModelTableSqlGenerator.getRecursiveAlterChildTableCommand(tableName, draftChildrenSchemas, publishedChildrenSchemas, 1);
        return returnValue;
    }

    public static Map<String, LinkedHashMap<String, List<SqlParam>>> getRecursiveAlterChildTableCommand(String tableName, List<ModelSchemaDTO> draftChildrenSchemas, List<ModelSchemaDTO> publishedChildrenSchemas, int level) throws Exception {
        HashMap<String, LinkedHashMap<String, List<SqlParam>>> returnValue = new HashMap<String, LinkedHashMap<String, List<SqlParam>>>();
        log.debug("process level({}), draftChildren size({})", (Object)level, (Object)draftChildrenSchemas.size());
        if (level <= 3) {
            log.debug("process childModelSchema({})", (Object)tableName);
            Map<String, LinkedHashMap<String, List<SqlParam>>> childrenAlterData = ModelTableSqlGenerator.compareAndGetChildrenAlterData(draftChildrenSchemas, publishedChildrenSchemas);
            returnValue.putAll(childrenAlterData);
            for (ModelSchemaDTO subDraftChildSchema : draftChildrenSchemas) {
                Map<String, LinkedHashMap<String, List<SqlParam>>> modelSchemaDTOList;
                String draftChildSchemaName = subDraftChildSchema.getName();
                log.debug("process sub Model Schema of childModelSchema({})", (Object)draftChildSchemaName);
                List matchPublishSchemas = publishedChildrenSchemas.stream().filter(modelSchemaDTO -> modelSchemaDTO.getName().equals(draftChildSchemaName)).collect(Collectors.toList());
                if (CollectionUtils.isNotEmpty(matchPublishSchemas)) {
                    modelSchemaDTOList = ModelTableSqlGenerator.getRecursiveAlterChildTableCommand(draftChildSchemaName, subDraftChildSchema.getChildren(), ((ModelSchemaDTO)matchPublishSchemas.get(0)).getChildren(), level + 1);
                    returnValue.putAll(modelSchemaDTOList);
                    continue;
                }
                modelSchemaDTOList = ModelTableSqlGenerator.getRecursiveAlterChildTableCommand(tableName, subDraftChildSchema.getChildren(), new ArrayList<ModelSchemaDTO>(), level + 1);
                returnValue.putAll(modelSchemaDTOList);
            }
        }
        return returnValue;
    }
}

