/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.lcdp.modeldriven.config;

import com.digiwin.app.json.gson.DWGsonProvider;
import com.digiwin.lcdp.modeldriven.config.condition.DWCustomizeSerializerCondition;
import com.google.gson.Gson;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSerializer;
import java.sql.Date;
import java.sql.Time;
import java.time.format.DateTimeFormatter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Conditional;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.env.Environment;

@Configuration
public class ModelDrivenCustomizeSerializerAutoConfiguration {
    private static final Logger log = LoggerFactory.getLogger(ModelDrivenCustomizeSerializerAutoConfiguration.class);

    @Bean
    @Conditional(value={DWCustomizeSerializerCondition.class})
    public Gson customizeTimeSerializer(Environment environment) {
        String customizeTimeSerializerFormat = environment.getProperty("lcdp.modeldriven.serializer.timeFormat", "HH:mm:ss");
        DWGsonProvider.registerTypeAdapter(Time.class, (Object)this.getTimeSerializer(customizeTimeSerializerFormat));
        String customizeDateSerializerFormat = environment.getProperty("lcdp.modeldriven.serializer.dateFormat", "yyyy-MM-dd");
        DWGsonProvider.registerTypeAdapter(Date.class, (Object)this.getDateOnlySerializer(customizeDateSerializerFormat));
        return DWGsonProvider.getGson();
    }

    JsonSerializer getTimeSerializer(String timeFormat) {
        JsonSerializer jsonSerializer = (time, var2, var3) -> new JsonPrimitive(((Time)time).toLocalTime().format(DateTimeFormatter.ofPattern(timeFormat)));
        log.info("ModelDrivenCustomizeSerializerAutoConfiguration: timeFormat ({})", (Object)timeFormat);
        return jsonSerializer;
    }

    JsonSerializer getDateOnlySerializer(String dateFormat) {
        JsonSerializer jsonSerializer = (time, var2, var3) -> new JsonPrimitive(((Date)time).toLocalDate().format(DateTimeFormatter.ofPattern(dateFormat)));
        log.info("ModelDrivenCustomizeSerializerAutoConfiguration: dateFormat ({})", (Object)dateFormat);
        return jsonSerializer;
    }
}

