/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.lcdp.modeldriven.customize.aop;

import com.digiwin.app.json.gson.DWGsonProvider;
import com.digiwin.app.service.DWServiceContext;
import com.digiwin.lcdp.modeldriven.utils.EaiRegisterUtil;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class BMCRUDDigiServiceNameInterceptor
implements MethodInterceptor {
    private static final String _CLASSTAG = "[" + BMCRUDDigiServiceNameInterceptor.class.getSimpleName() + "]";
    private static Logger logger = LoggerFactory.getLogger(BMCRUDDigiServiceNameInterceptor.class);
    private static final List<String> methodName = Stream.of("getList", "get", "put", "putValid", "putInvalid", "delete", "post").collect(Collectors.toList());

    public Object invoke(MethodInvocation invocation) throws Throwable {
        Object[] objects = invocation.getArguments();
        Map headers = (Map)objects[0];
        String digiService = (String)headers.get("digi-service");
        Map digiServiceMap = (Map)DWGsonProvider.getGson().fromJson(digiService, Map.class);
        String prod = (String)digiServiceMap.get("prod");
        String modelDrivenProdPrefix = EaiRegisterUtil.getEaiServicePrefixOfProd(prod) + ".";
        String name = (String)digiServiceMap.get("name");
        String digiServiceName = DWServiceContext.getContext().getDigiServiceName();
        String methodName = invocation.getMethod().getName();
        String[] split = name.split("\\.");
        switch (methodName) {
            case "getList": {
                String getListName = modelDrivenProdPrefix + String.join((CharSequence)".", Arrays.copyOfRange(split, 2, split.length - 1)) + ".list.get";
                digiServiceMap.put("name", getListName);
                break;
            }
            case "get": {
                String getName = modelDrivenProdPrefix + String.join((CharSequence)".", Arrays.copyOfRange(split, 2, split.length - 1)) + ".detail.get";
                digiServiceMap.put("name", getName);
                break;
            }
            case "putValid": {
                String putValidName = modelDrivenProdPrefix + String.join((CharSequence)".", Arrays.copyOfRange(split, 2, split.length - 1)) + ".valid";
                digiServiceMap.put("name", putValidName);
                break;
            }
            case "putInvalid": {
                String putInvalidName = modelDrivenProdPrefix + String.join((CharSequence)".", Arrays.copyOfRange(split, 2, split.length - 1)) + ".invalid";
                digiServiceMap.put("name", putInvalidName);
                break;
            }
            case "put": {
                String putName = modelDrivenProdPrefix + String.join((CharSequence)".", Arrays.copyOfRange(split, 2, split.length - 1)) + ".update";
                digiServiceMap.put("name", putName);
                break;
            }
            case "post": {
                String postName = modelDrivenProdPrefix + String.join((CharSequence)".", Arrays.copyOfRange(split, 2, split.length - 1)) + ".create";
                digiServiceMap.put("name", postName);
                break;
            }
            case "delete": {
                String deleteName = modelDrivenProdPrefix + String.join((CharSequence)".", Arrays.copyOfRange(split, 2, split.length - 1)) + ".delete";
                digiServiceMap.put("name", deleteName);
                break;
            }
        }
        headers.put("digi-service", DWGsonProvider.getGson().toJson((Object)digiServiceMap));
        logger.debug(_CLASSTAG + " origin eaiId({}) change to new eaiId({})", (Object)digiServiceName, digiServiceMap.get("name"));
        return invocation.proceed();
    }
}

