/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.lcdp.modeldriven.customize.config;

import com.digiwin.app.common.DWApplicationConfigUtils;
import com.digiwin.app.container.DWHeader;
import com.digiwin.app.json.gson.DWGsonProvider;
import com.digiwin.app.service.DWEAIResult;
import com.digiwin.app.service.eai.DWEAIHeader;
import com.digiwin.app.service.eai.DWEAIHeaderRepository;
import com.digiwin.athena.esp.sdk.init.EspSdkInitialize;
import com.digiwin.dap.middleware.lmc.util.JsonUtils;
import com.digiwin.lcdp.modeldriven.customize.BMDInvoker;
import com.digiwin.lcdp.modeldriven.customize.BMProperties;
import com.digiwin.lcdp.modeldriven.customize.BMRole;
import com.digiwin.lcdp.modeldriven.customize.config.NacosServiceRegisterEvent;
import com.digiwin.lcdp.modeldriven.customize.model.BMDataEaiMethodRepository;
import com.digiwin.lcdp.modeldriven.customize.model.BMEaiMethodRepository;
import com.digiwin.lcdp.modeldriven.customize.service.impl.BMDataEAICrudService;
import com.digiwin.lcdp.modeldriven.pojo.DWServiceMapping;
import com.digiwin.lcdp.modeldriven.pojo.MappingModelInfo;
import com.digiwin.lcdp.modeldriven.utils.EaiHeaderUtil;
import com.digiwin.lcdp.modeldriven.utils.EaiRegisterUtil;
import com.digiwin.lcdp.modeldriven.utils.NacosRegisterUtils;
import com.fasterxml.jackson.core.type.TypeReference;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.cloud.client.discovery.event.InstanceRegisteredEvent;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationListener;
import org.springframework.scheduling.annotation.Async;

public class BMNacosRigestionApplicationListener
implements ApplicationListener {
    private static Logger log = LoggerFactory.getLogger(BMNacosRigestionApplicationListener.class);
    @Autowired
    NacosRegisterUtils nacosRegisterUtils;
    @Autowired
    EaiHeaderUtil eaiHeaderUtil;
    @Autowired
    BMDataEAICrudService bmDataEAICrudService;
    @Autowired(required=false)
    @Qualifier(value="lcdp-bmd-eai-method-repo")
    BMDataEaiMethodRepository bmdEaiMethodRepository;
    @Autowired(required=false)
    @Qualifier(value="lcdp-bm-eai-method-repo")
    BMEaiMethodRepository bmMethodRepository;
    @Autowired
    BMDInvoker bmdInvoker;
    @Autowired
    EaiRegisterUtil eaiRegisterUtil;
    @Autowired
    private DWEAIHeaderRepository eaiHeaderRepository;

    /*
     * Unable to fully structure code
     */
    @Async
    public void onApplicationEvent(ApplicationEvent event) {
        if (event instanceof InstanceRegisteredEvent) {
            newEaiHeaders = new ArrayList<DWEAIHeader>();
            serviceMapping = new ArrayList<E>();
            mappingModelInfos = new ArrayList<E>();
            if (BMProperties.getProperties().getRole() != null && BMProperties.getProperties().getRole() == BMRole.bm) {
                this.initEspSdkInvoker();
                bmTargetProds = DWApplicationConfigUtils.getProperty((String)"lcdp.bm.target.prod");
                if (StringUtils.isEmpty((CharSequence)bmTargetProds)) {
                    throw new RuntimeException("<<< bmTargetProds properties is not configured");
                }
                bmTargetProdList = Stream.of(bmTargetProds.split(",")).collect(Collectors.toList());
                queue = new LinkedBlockingDeque<E>();
                queue.addAll(bmTargetProdList);
                targetProd = null;
                result = null;
                while ((targetProd = (String)queue.poll()) != null) {
                    try {
                        result = this.bmdInvoker.invokeGetBMDCodes(targetProd);
                        if ("0".equals(result.getCode())) break;
                        BMNacosRigestionApplicationListener.log.error("<<< get codes failed from target prod:{},caused by :{} ,it'll be try another target prod", (Object)targetProd, (Object)result.getDescription());
                        queue.add(targetProd);
                        try {
                            Thread.sleep(3000L);
                        }
                        catch (InterruptedException var10_15) {
                        }
                    }
                    catch (Exception e) {
                        BMNacosRigestionApplicationListener.log.error("<<< get codes failed from target prod:{},it'll be try another target prod", (Object)targetProd, (Object)e);
                        queue.add(targetProd);
                        try {
                            Thread.sleep(3000L);
                        }
                        catch (InterruptedException var11_17) {}
                    }
                }
                params = result.getParameter();
                serviceMapping = (List)JsonUtils.readValue((String)DWGsonProvider.getGson().toJson(params.get("serviceMapping")), (TypeReference)new TypeReference<List<DWServiceMapping>>(){});
                mappingModelInfos = (List)JsonUtils.readValue((String)DWGsonProvider.getGson().toJson(params.get("mappingModelInfos")), (TypeReference)new TypeReference<List<MappingModelInfo>>(){});
                BMNacosRigestionApplicationListener.log.debug("<<< get codes successfully from target prod:{}", serviceMapping);
                try {
                    if (!CollectionUtils.isNotEmpty(serviceMapping)) ** GOTO lbl65
                    bmEaiHeaders = this.eaiHeaderUtil.updateAndGetModelDrivenEaiHeaders(serviceMapping, mappingModelInfos);
                    newEaiHeaders.addAll(bmEaiHeaders);
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            } else if (BMProperties.getProperties().getRole() != null && BMProperties.getProperties().getRole() == BMRole.bmd) {
                try {
                    bmCode = (DWEAIResult)this.bmDataEAICrudService.getBMCode(null, null);
                    serviceMapping = (List)bmCode.getParameter().get("serviceMapping");
                    mappingModelInfos = (List)bmCode.getParameter().get("mappingModelInfos");
                    this.eaiHeaderUtil.updateAndGetModelDrivenEaiHeaders(serviceMapping, mappingModelInfos);
                    newEaiHeaders.addAll(this.bmdEaiMethodRepository.getEaiHeaders());
                    bmDataDWEaiHeaders = this.bmdEaiMethodRepository.getEaiHeaders();
                    if (CollectionUtils.isNotEmpty(bmDataDWEaiHeaders)) {
                        this.eaiHeaderUtil.addAndUpdateDWEaiHeaders(bmDataDWEaiHeaders);
                    }
                }
                catch (Exception e) {
                    BMNacosRigestionApplicationListener.log.error("<<< get codes failed", (Throwable)e);
                    throw new RuntimeException("get codes failed ", e);
                }
            }
lbl65:
            // 5 sources

            allHeader = this.eaiHeaderRepository.getAllHeader();
            allEaiHeaders = new ArrayList<DWEAIHeader>();
            for (DWHeader header : allHeader) {
                if (!(header instanceof DWEAIHeader)) continue;
                allEaiHeaders.add((DWEAIHeader)header);
            }
            eaiServiceIdList = this.eaiHeaderRepository.getEaiServiceIdList();
            if (BMProperties.getProperties().getRole() != null && BMProperties.getProperties().getRole() == BMRole.bmd) {
                BMNacosRigestionApplicationListener.log.debug("<<< bmd ignored eai(esp) service register");
            } else {
                BMNacosRigestionApplicationListener.log.info("<<< eai service start register,ids:{}", (Object)eaiServiceIdList);
                try {
                    this.eaiRegisterUtil.autoRegisterEAI(allEaiHeaders);
                    BMNacosRigestionApplicationListener.log.info("<<< eai service registered register,ids:{}", (Object)eaiServiceIdList);
                }
                catch (Exception e) {
                    BMNacosRigestionApplicationListener.log.error("<<< eai service register failed :{}", (Object)eaiServiceIdList, (Object)e);
                    throw new RuntimeException("eai service register failed", e);
                }
            }
            try {
                Thread.sleep(2000L);
                BMNacosRigestionApplicationListener.log.info("<<< nacos service start register,ids:{}", (Object)eaiServiceIdList);
                this.nacosRegisterUtils.autoRegisterNacos(allEaiHeaders);
                BMNacosRigestionApplicationListener.log.info("<<< nacos service registered succesfully,ids:{}", (Object)eaiServiceIdList);
            }
            catch (Exception e) {
                BMNacosRigestionApplicationListener.log.error("<<< nacos service register failed :{}", (Object)eaiServiceIdList, (Object)e);
                throw new RuntimeException("nacos service register failed", e);
            }
        }
        if (event instanceof NacosServiceRegisterEvent) {
            try {
                this.nacosRegisterUtils.nacosServiceRegister((List)event.getSource());
            }
            catch (Exception e) {
                BMNacosRigestionApplicationListener.log.error("<<< nacos service register failed :{}", event.getSource(), (Object)e);
                throw new RuntimeException("nacos service register failed", e);
            }
        }
    }

    private void initEspSdkInvoker() {
        String espDomain = DWApplicationConfigUtils.getProperty((String)"esp.domain");
        String mdcDomain = DWApplicationConfigUtils.getProperty((String)"mdc.domain");
        String tmDomain = DWApplicationConfigUtils.getProperty((String)"tm.domain");
        String eocDomain = DWApplicationConfigUtils.getProperty((String)"eoc.domain");
        String lmcDomain = DWApplicationConfigUtils.getProperty((String)"lmcUrl");
        EspSdkInitialize.initConfig((String)espDomain, (String)mdcDomain, (String)tmDomain, (String)eocDomain);
        EspSdkInitialize.initLmcConfig((String)lmcDomain);
    }
}

