/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.lcdp.modeldriven.customize.utils;

import com.digiwin.lcdp.modeldriven.context.ModelDrivenContext;
import com.digiwin.lcdp.modeldriven.customize.BMProperties;
import com.digiwin.lcdp.modeldriven.model.ModelAppInfoDTO;
import com.digiwin.lcdp.modeldriven.model.ModelDTO;
import com.digiwin.lcdp.modeldriven.pojo.DWServiceMapping;
import com.digiwin.lcdp.modeldriven.pojo.MappingModelInfo;
import com.digiwin.lcdp.modeldriven.utils.ApTokenUtil;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;

public class BMCenterUtil {
    public static String getProdOfSite() {
        String appIdOfProperties = ApTokenUtil.getAppIdByApplicationConfig();
        return appIdOfProperties;
    }

    public static String getEaiServicePrefix(String targetProdOfDWServiceMapping) {
        String[] appIdToken = targetProdOfDWServiceMapping.toLowerCase().split("-");
        List appIdTokens = Stream.of(appIdToken).collect(Collectors.toList());
        if (appIdTokens.size() >= 2) {
            appIdTokens.remove(appIdTokens.size() - 1);
        }
        String validStr = StringUtils.join(appIdTokens, (String)".");
        return validStr;
    }

    public static String getTargetProdForServiceMapping(String targetProd) {
        targetProd = targetProd.toLowerCase().replaceAll("-", "_");
        return targetProd;
    }

    public static void modifyServiceMapping(DWServiceMapping serviceMapping, String targetProd) {
        serviceMapping.setTargetProd(targetProd);
    }

    public static void modifyServiceMapping(List<DWServiceMapping> serviceMappings) {
        ModelDTO modelDTO = ModelDrivenContext.getContext().getDraftModel();
        ModelAppInfoDTO modelAppInfo = modelDTO.getAppInfo();
        String targetProd = modelAppInfo.getTargetProd();
        BMCenterUtil.modifyServiceMapping(serviceMappings, targetProd);
    }

    public static void modifyServiceMapping(List<DWServiceMapping> serviceMappings, String targetProd) {
        BMProperties bmProperties = BMProperties.getProperties();
        if (bmProperties != null && bmProperties.isEnabled()) {
            ModelDTO modelDTO = ModelDrivenContext.getContext().getDraftModel();
            serviceMappings.stream().forEach(dwServiceMapping -> BMCenterUtil.modifyServiceMapping(dwServiceMapping, targetProd));
        }
    }

    public static void modifyMappingModelInfo(List<MappingModelInfo> mappingModelInfos) {
        ModelDTO modelDTO = ModelDrivenContext.getContext().getDraftModel();
        ModelAppInfoDTO modelAppInfo = modelDTO.getAppInfo();
        String targetProd = modelAppInfo.getTargetProd();
        mappingModelInfos.stream().forEach(mappingModelInfo -> BMCenterUtil.modifyMappingModelInfo(mappingModelInfo, targetProd));
    }

    public static void modifyMappingModelInfo(MappingModelInfo mappingModelInfo, String targetProd) {
        mappingModelInfo.setTargetProd(targetProd);
    }
}

