/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.lcdp.modeldriven.dataview.impl;

import com.digiwin.app.dao.DWDao;
import com.digiwin.app.dao.DWOnColumn;
import com.digiwin.app.dao.DWPagableQueryInfo;
import com.digiwin.app.dao.DWPaginationQueryResult;
import com.digiwin.app.dao.DWQueryCondition;
import com.digiwin.app.dao.DWQueryField;
import com.digiwin.app.dao.DWQueryInfo;
import com.digiwin.app.dao.DWQueryJoinRelation;
import com.digiwin.app.dao.DWQueryJoinTable;
import com.digiwin.app.dao.DWQueryValueOperator;
import com.digiwin.app.dao.DWSqlInfo;
import com.digiwin.app.dao.DWSubQueryInfo;
import com.digiwin.app.data.DWDataRow;
import com.digiwin.app.data.DWDataSet;
import com.digiwin.app.data.DWDataSetOperationOption;
import com.digiwin.app.data.DWDataTable;
import com.digiwin.app.data.IDWSQLOptions;
import com.digiwin.app.ddl.util.MetadataSqlGenerator;
import com.digiwin.data.permission.DWRowPermissionDefaultMatchOption;
import com.digiwin.data.permission.DWRowPermissionElement;
import com.digiwin.data.permission.DWRowPermissionEmpty;
import com.digiwin.data.permission.DWRowPermissionMatchOption;
import com.digiwin.data.permission.DWUserPermission;
import com.digiwin.lcdp.modeldriven.dataview.dto.DataViewDTO;
import com.digiwin.lcdp.modeldriven.dataview.dto.DataViewInfoDTO;
import com.digiwin.lcdp.modeldriven.dataview.dto.DataViewInfoOrderConditionDTO;
import com.digiwin.lcdp.modeldriven.dataview.dto.DataViewInfoReturnFieldDTO;
import com.digiwin.lcdp.modeldriven.dataview.dto.DataViewInfoReturnFieldsDTO;
import com.digiwin.lcdp.modeldriven.dataview.dto.DataViewInfoSecondlyQueryConditionDTO;
import com.digiwin.lcdp.modeldriven.dataview.dto.DataViewInfoSecondlySortConditionDTO;
import com.digiwin.lcdp.modeldriven.dataview.dto.DataViewInfoTableDTO;
import com.digiwin.lcdp.modeldriven.model.ModelDTO;
import com.digiwin.lcdp.modeldriven.model.ModelSchemaDTO;
import com.digiwin.lcdp.modeldriven.model.ModelSwitchCfg;
import com.digiwin.lcdp.modeldriven.model.SqlParam;
import com.digiwin.lcdp.modeldriven.permission.ModelDrivenDataPermission;
import com.digiwin.lcdp.modeldriven.pojo.QueryConditionDTO;
import com.digiwin.lcdp.modeldriven.service.impl.ModelDataEntryService;
import com.digiwin.lcdp.modeldriven.utils.DataEntryDataUtil;
import com.digiwin.lcdp.modeldriven.utils.ModelSchemaUtil;
import com.digiwin.lcdp.modeldriven.utils.ModelSqlGenerator;
import com.digiwin.lcdp.modeldriven.utils.QueryConditionUtils;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import net.sf.jsqlparser.parser.CCJSqlParserUtil;
import net.sf.jsqlparser.statement.Statement;
import net.sf.jsqlparser.statement.select.PlainSelect;
import net.sf.jsqlparser.statement.select.Select;
import net.sf.jsqlparser.statement.select.SubSelect;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;
import org.springframework.util.ObjectUtils;

@Service
public class ModelDrivenDataViewService {
    private static final Logger log = LoggerFactory.getLogger(ModelDrivenDataViewService.class);
    @Autowired
    @Qualifier(value="dw-dao")
    private DWDao dao;
    @Autowired
    private ModelDataEntryService modelDataEntryService;
    @Autowired
    QueryConditionUtils queryConditionUtils;

    public Object dataviewGet(DataViewDTO viewParams) throws Exception {
        String actionId;
        String moduleId;
        DWUserPermission dataPermData;
        DWQueryInfo queryInfo;
        HashMap<String, Object> returnValue = new HashMap<String, Object>();
        DWSubQueryInfo dwSubQueryInfo = new DWSubQueryInfo("", "dataviewAlias");
        DWDataSetOperationOption option = new DWDataSetOperationOption();
        DataViewInfoDTO viewInfo = viewParams.getView_info();
        List<DataViewInfoSecondlyQueryConditionDTO> secondlyQueryParams = viewParams.getSearch_info();
        List<DataViewInfoSecondlySortConditionDTO> secondlySortParams = viewParams.getSort_info();
        Boolean useHasNext = viewParams.getUse_has_next() == null ? false : viewParams.getUse_has_next();
        DataViewInfoTableDTO mainTable = viewParams.getView_info().getTables().stream().filter(table -> table.getMain()).findFirst().orElseThrow(() -> new RuntimeException("main table of module is missing"));
        List<Map> customizedConditionValues = viewParams.getQueryConditionValues();
        ModelDTO model = this.getModel(mainTable.getTable());
        ModelSchemaDTO modelSchema = model.getSchema();
        if (useHasNext.booleanValue()) {
            int pageSize = viewParams.getPage_size();
            int pageNumber = viewParams.getPage_no();
            queryInfo = new DWPagableQueryInfo();
            ((DWPagableQueryInfo)queryInfo).setPageSize(pageSize);
            ((DWPagableQueryInfo)queryInfo).setPageNumber(pageNumber);
        } else {
            queryInfo = new DWQueryInfo();
        }
        if (!ObjectUtils.isEmpty((Object)viewInfo) && CollectionUtils.isNotEmpty(viewInfo.getTables())) {
            viewInfo.getTables().forEach(table -> this.dealDataViewTables((DWQueryInfo)dwSubQueryInfo, (DataViewInfoTableDTO)table));
        }
        if (!ObjectUtils.isEmpty((Object)viewInfo.getReturnFields())) {
            this.dealDataViewReturnFields((DWQueryInfo)dwSubQueryInfo, viewInfo.getReturnFields());
        }
        if (CollectionUtils.isNotEmpty(viewInfo.getQueryConditions())) {
            this.dealDataViewSearchInfo((DWQueryInfo)dwSubQueryInfo, viewInfo.getQueryConditions(), customizedConditionValues);
            this.dealDataViewSecondSearchInfo((DWQueryInfo)dwSubQueryInfo, secondlyQueryParams);
        }
        if (CollectionUtils.isNotEmpty(viewInfo.getOrderList())) {
            this.dealDataViewOrderInfo((DWQueryInfo)dwSubQueryInfo, viewInfo.getOrderList());
            this.dealDataViewSecondlySortInfo((DWQueryInfo)dwSubQueryInfo, secondlySortParams);
        }
        if (!ObjectUtils.isEmpty((Object)modelSchema) && !"returnSql".equals(viewInfo.getExecuteType()) && this.enablePermission(modelSchema) && (dataPermData = (DWUserPermission)ModelDrivenDataPermission.getDataPermission(moduleId = "basicDataEntry", actionId = Optional.ofNullable(viewParams.getActivityId()).orElseThrow(() -> new RuntimeException("actionId of view_info can not be null")), model.getAppId())) != null) {
            DWUserPermission userPermission = dataPermData;
            Field rowPermissionField = DWUserPermission.class.getDeclaredField("rowPermission");
            rowPermissionField.setAccessible(true);
            DWRowPermissionElement rowPermission = (DWRowPermissionElement)rowPermissionField.get(userPermission);
            if (!userPermission.isSuperadmin() && (rowPermission instanceof DWRowPermissionEmpty || rowPermission == null)) {
                returnValue.put(viewParams.getView_info().getCode(), new ArrayList());
                return returnValue;
            }
            log.debug(String.format("[dataview permission] %s permission : {}", viewParams.getView_info().getCode()), rowPermissionField.get(userPermission));
            DWRowPermissionDefaultMatchOption rowPermissionOption = new DWRowPermissionDefaultMatchOption();
            DWQueryCondition queryCondition = dataPermData.getRowPermission().getQueryCondition((DWRowPermissionMatchOption)rowPermissionOption);
            dwSubQueryInfo.setCondition(queryCondition);
        }
        queryInfo.from(dwSubQueryInfo);
        queryInfo.setTableName(dwSubQueryInfo.getTableName());
        if ("returnSql".equals(viewInfo.getExecuteType())) {
            PlainSelect selectBody;
            Statement selectSql;
            String sql = null;
            DWSqlInfo sqlInfo = this.dao.getDialect().parse(option, queryInfo, sql);
            sql = sqlInfo.getSql();
            if (StringUtils.isNotEmpty((CharSequence)sql) && (selectSql = CCJSqlParserUtil.parse((String)sql, null)) instanceof Select && (selectBody = (PlainSelect)((Select)selectSql).getSelectBody()).getFromItem() != null) {
                sql = ((SubSelect)selectBody.getFromItem()).getSelectBody().toString();
            }
            if (sql != null) {
                SqlParam sqlparam = new SqlParam();
                sqlparam.setSql(sql);
                sqlparam.setParams(sqlInfo.getParameters());
                sql = ModelSqlGenerator.getCombinedSql(sqlparam);
            }
            returnValue.put("returnSql", sql);
            return returnValue;
        }
        if (useHasNext.booleanValue()) {
            DWPaginationQueryResult queryResult = this.dao.selectWithPage((DWPagableQueryInfo)queryInfo, option);
            DWDataSet dataset = queryResult.getDataSet();
            long totalRowCount = queryResult.getRowCount();
            long totalPageCount = queryResult.getPageCount();
            returnValue.put("total_results", totalRowCount);
            returnValue.put("has_next", (long)((DWPagableQueryInfo)queryInfo).getPageNumber() < totalPageCount);
            List<Map<String, Object>> datas = DataEntryDataUtil.convertFromJson(dataset.getTable(dwSubQueryInfo.getTableName()));
            returnValue.put(viewParams.getView_info().getCode(), datas);
        } else {
            DWDataSet dataset = this.dao.select(queryInfo, option);
            List<Map<String, Object>> datas = DataEntryDataUtil.convertFromJson(dataset.getTable(dwSubQueryInfo.getTableName()));
            returnValue.put(viewParams.getView_info().getCode(), datas);
        }
        return returnValue;
    }

    private void dealDataViewTables(DWQueryInfo queryInfo, DataViewInfoTableDTO table) {
        if (!ObjectUtils.isEmpty((Object)table)) {
            if (table.getMain().booleanValue()) {
                queryInfo.setTableName(table.getTable());
                String tablePath = Optional.ofNullable(table.getPath()).orElseThrow(() -> new RuntimeException("'path' of table '%s' can not be null"));
                String tableName = Optional.ofNullable(table.getTable()).orElseThrow(() -> new RuntimeException("'table' of table '%s' can not be null"));
                try {
                    List<String> primaryKeys = this.getPrimaryKeys(this.dao, table.getTable());
                    if (CollectionUtils.isNotEmpty(primaryKeys)) {
                        ArrayList conditions = new ArrayList();
                        primaryKeys.forEach(primaryKey -> {
                            DWOnColumn onColumn = new DWOnColumn(tableName + "." + primaryKey, DWQueryValueOperator.Equals, tablePath + "." + primaryKey);
                            conditions.add(onColumn);
                        });
                        queryInfo.setJoinOnColumn(DWQueryJoinRelation.InnerJoin, new DWQueryJoinTable(tableName, tablePath), conditions.toArray(new DWOnColumn[conditions.size()]));
                    }
                }
                catch (Exception e) {
                    log.error("get primary key of table '%s' error", (Throwable)e);
                }
                if (CollectionUtils.isNotEmpty(table.getJoin())) {
                    table.getJoin().forEach(joinTable -> {
                        ArrayList conditions = new ArrayList();
                        if (CollectionUtils.isNotEmpty(joinTable.getAssociatedFields())) {
                            joinTable.getAssociatedFields().forEach(associatedFields -> {
                                DWOnColumn onColumn = new DWOnColumn(associatedFields.getRight(), DWQueryValueOperator.Equals, associatedFields.getLeft());
                                conditions.add(onColumn);
                            });
                            queryInfo.setJoinOnColumn(DWQueryJoinRelation.LeftJoin, new DWQueryJoinTable(joinTable.getTable(), joinTable.getPath()), conditions.toArray(new DWOnColumn[conditions.size()]));
                        }
                        if (CollectionUtils.isNotEmpty(joinTable.getJoin())) {
                            this.dealDataViewTables(queryInfo, (DataViewInfoTableDTO)joinTable);
                        }
                    });
                }
            } else if (CollectionUtils.isNotEmpty(table.getJoin())) {
                table.getJoin().forEach(joinTable -> {
                    ArrayList conditions = new ArrayList();
                    if (CollectionUtils.isNotEmpty(joinTable.getAssociatedFields())) {
                        joinTable.getAssociatedFields().forEach(associatedFields -> {
                            DWOnColumn onColumn = new DWOnColumn(associatedFields.getRight(), DWQueryValueOperator.Equals, associatedFields.getLeft());
                            conditions.add(onColumn);
                        });
                        queryInfo.setJoinOnColumn(DWQueryJoinRelation.LeftJoin, new DWQueryJoinTable(joinTable.getTable(), joinTable.getPath()), conditions.toArray(new DWOnColumn[conditions.size()]));
                    }
                    if (CollectionUtils.isNotEmpty(joinTable.getJoin())) {
                        this.dealDataViewTables(queryInfo, (DataViewInfoTableDTO)joinTable);
                    }
                });
            }
        }
    }

    private void dealDataViewReturnFields(DWQueryInfo queryInfo, DataViewInfoReturnFieldsDTO returnFields) {
        if (!ObjectUtils.isEmpty((Object)returnFields)) {
            String mainTableName = returnFields.getTable();
            List<DataViewInfoReturnFieldDTO> fields = returnFields.getFields();
            if (CollectionUtils.isNotEmpty(fields)) {
                List simpleFields = fields.stream().filter(field -> "SIMPLE".equals(Optional.ofNullable(field.getType()).orElseThrow(() -> new RuntimeException(String.format("the type of field '%s' can not be null", field.getFieldId()))))).collect(Collectors.toList());
                List quoteQueryFields = fields.stream().filter(field -> "QUOTE_QUERY".equals(Optional.ofNullable(field.getType()).orElseThrow(() -> new RuntimeException(String.format("the type of field '%s' can not be null", field.getFieldId()))))).collect(Collectors.toList());
                List collectionFields = fields.stream().filter(field -> "COLLECTION".equals(Optional.ofNullable(field.getType()).orElseThrow(() -> new RuntimeException(String.format("the type of field '%s' can not be null", field.getFieldId()))))).collect(Collectors.toList());
                simpleFields.stream().forEach(field -> queryInfo.addSelectField(new String[]{field.getShortPath() + " as `" + field.getFullPath() + "`"}));
                quoteQueryFields.stream().forEach(field -> {
                    List<DataViewInfoReturnFieldDTO> quoteFields = field.getFields();
                    if (CollectionUtils.isNotEmpty(quoteFields)) {
                        quoteFields.forEach(quoteField -> queryInfo.addSelectField(new String[]{quoteField.getShortPath() + " as `" + quoteField.getFullPath() + "`"}));
                    }
                });
                collectionFields.stream().forEach(field -> {
                    List<DataViewInfoReturnFieldDTO> quoteFields = field.getFields();
                    if (CollectionUtils.isNotEmpty(quoteFields)) {
                        quoteFields.forEach(quoteField -> queryInfo.addSelectField(new String[]{quoteField.getShortPath() + " as `" + quoteField.getFullPath() + "`"}));
                    }
                });
            }
        }
    }

    private void dealDataViewSearchInfo(DWQueryInfo queryInfo, List<QueryConditionDTO> searchInfos, List<Map> customizedConditionValues) {
        if (CollectionUtils.isNotEmpty(searchInfos)) {
            Collections.sort(searchInfos, Comparator.comparingDouble(item -> Double.parseDouble(item.getOrder().toString())));
            DWQueryCondition condition = new DWQueryCondition();
            this.queryConditionUtils.generateCondition(searchInfos.iterator(), condition, customizedConditionValues);
            queryInfo.setCondition(condition);
        }
    }

    private void dealDataViewSecondSearchInfo(DWQueryInfo queryInfo, List<DataViewInfoSecondlyQueryConditionDTO> mainQueryInfoParams) {
        if (CollectionUtils.isNotEmpty(mainQueryInfoParams)) {
            DWQueryCondition condition = new DWQueryCondition();
            mainQueryInfoParams.forEach(param -> {
                DWQueryField dwQueryField = this.queryConditionUtils.generateQueryFields((QueryConditionDTO)param);
                condition.addFieldInfo(dwQueryField.getName(), dwQueryField.getOperator(), dwQueryField.getValues());
                queryInfo.getCondition().addCondition(condition);
            });
        }
    }

    private void dealDataViewOrderInfo(DWQueryInfo queryInfo, List<DataViewInfoOrderConditionDTO> orderInfos) {
        if (CollectionUtils.isNotEmpty(orderInfos)) {
            Collections.sort(orderInfos, Comparator.comparingDouble(item -> Double.parseDouble(item.getOrder())));
            orderInfos.forEach(orderInfo -> {
                String orderField = StringUtils.isNotEmpty((CharSequence)orderInfo.getTable_path()) ? orderInfo.getTable_path() + "." + orderInfo.getSchema() : orderInfo.getSchema();
                switch (orderInfo.getOrderType()) {
                    case "asc": {
                        queryInfo.addOrderBy(orderField, true);
                        break;
                    }
                    case "desc": {
                        queryInfo.addOrderBy(orderField, false);
                        break;
                    }
                }
            });
        }
    }

    private void dealDataViewSecondlySortInfo(DWQueryInfo queryInfo, List<DataViewInfoSecondlySortConditionDTO> orderInfos) {
        if (CollectionUtils.isNotEmpty(orderInfos)) {
            orderInfos.forEach(orderInfo -> {
                String orderField = StringUtils.isNotEmpty((CharSequence)orderInfo.getTable_path()) ? orderInfo.getTable_path() + "." + orderInfo.getSort_field() : orderInfo.getSort_field();
                switch (orderInfo.getSort_type()) {
                    case "asc": {
                        queryInfo.addOrderBy(orderField, true);
                        break;
                    }
                    case "desc": {
                        queryInfo.addOrderBy(orderField, false);
                        break;
                    }
                }
            });
        }
    }

    List<String> getPrimaryKeys(DWDao dao, String tableName) throws Exception {
        String sql = MetadataSqlGenerator.getPrimaryKey((String)tableName);
        DWDataSetOperationOption option = new DWDataSetOperationOption();
        option.setTenantEnabled(false);
        ArrayList<String> pks = new ArrayList<String>();
        List result = dao.select((IDWSQLOptions)option, sql, new Object[0]);
        for (Map map : result) {
            Object pk = map.get("pk");
            if (!Objects.nonNull(pk)) continue;
            pks.add(Objects.toString(pk));
        }
        return pks;
    }

    public ModelDTO getModel(String mainTableName) {
        if (StringUtils.isNotEmpty((CharSequence)mainTableName)) {
            String modelCode = mainTableName;
            DWQueryInfo queryInfo = new DWQueryInfo("dw_lcdp_model");
            queryInfo.addEqualInfo("code", (Object)modelCode);
            DWDataSetOperationOption option = new DWDataSetOperationOption();
            option.setTenantEnabled(false);
            option.setManagementFieldEnabled(false);
            DWDataSet modelTables = this.dao.select(queryInfo, option);
            DWDataTable table = modelTables.getTable("dw_lcdp_model");
            if (table.getRows().size() <= 0) {
                return null;
            }
            DWDataRow row = table.getRow(0);
            return ModelSchemaUtil.getModel(row);
        }
        throw new RuntimeException(String.format("tableName '%s' is missing", mainTableName));
    }

    private boolean enablePermission(ModelSchemaDTO model) {
        return "Y".equals(Optional.ofNullable(model.getSwitchCfg()).orElse(new ModelSwitchCfg()).getDataPermission());
    }
}

