/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.lcdp.modeldriven.enums;

public enum DatabaseOperationType {
    INSERT("insert"),
    UPDATE("update"),
    REPLACE("replace"),
    DELETE("delete"),
    INVALIDATE("invalidate");

    private final String value;

    private DatabaseOperationType(String operationTypeName) {
        this.value = operationTypeName;
    }

    public String getValue() {
        return this.value;
    }

    public static DatabaseOperationType fromString(String operationTypeName) {
        if (operationTypeName != null) {
            for (DatabaseOperationType operationType : DatabaseOperationType.values()) {
                if (!operationTypeName.equals(operationType.value)) continue;
                return operationType;
            }
        }
        throw new IllegalArgumentException(String.format("'%s' is not a valid OperationType", operationTypeName));
    }

    public String toString() {
        return "OperationType{value='" + this.value + "'" + "}";
    }
}

