/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.lcdp.modeldriven.listener;

import com.digiwin.app.eai.DWEAIProperties;
import com.digiwin.app.persistconn.TokenProvider;
import com.digiwin.app.service.eai.DWEAIHeaderRepository;
import com.digiwin.gateway.controller.EaiInfoUtils;
import com.digiwin.http.client.DWHttpClient;
import com.digiwin.http.client.entity.DWJsonEntity;
import com.digiwin.lcdp.modeldriven.utils.EaiRegisterUtil;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationListener;
import org.springframework.context.event.ContextRefreshedEvent;
import org.springframework.core.env.Environment;
import org.springframework.scheduling.annotation.Async;

public class ModelDrivenApplicationListener
implements ApplicationListener {
    private static Logger log = LoggerFactory.getLogger(ModelDrivenApplicationListener.class);
    @Autowired
    private DWEAIHeaderRepository eaiHeaderRepository;
    @Autowired
    DWEAIProperties properties;
    @Autowired
    Environment environment;
    @Autowired
    private DWHttpClient dwHttpClient;
    @Autowired
    EaiRegisterUtil eaiRegisterUtil;

    @Async
    public void onApplicationEvent(ApplicationEvent event) {
        if (event instanceof ContextRefreshedEvent) {
            try {
                HttpResponse response = this.eaiRegisterUtil.tryEaiPath(this.environment.getProperty("lcdp.modeldriven.eai.reg.prod.resturl"), this.dwHttpClient);
                if (response != null && response.getStatusLine().getStatusCode() == 200) {
                    log.info("[" + Thread.currentThread().getName() + "]" + "<<< begin to register esp service after spring context initialize compeleted");
                    Map result = EaiInfoUtils.getSrvRegInfo(() -> ((DWEAIHeaderRepository)this.eaiHeaderRepository).getEaiServiceIdList(), (DWEAIProperties)this.properties);
                    Map hostMap = (Map)result.get("host");
                    hostMap.put("resturl", this.environment.getProperty("lcdp.modeldriven.eai.reg.prod.resturl"));
                    String host = this.properties.getServerUrl();
                    String regSrv = this.environment.getProperty("lcdp.modeldriven.eai.reg.prod.srv.path", "/CROSS/RESTful/regProdApSrv");
                    HttpPost post = new HttpPost(host + regSrv);
                    post.setEntity((HttpEntity)new DWJsonEntity((Object)result));
                    EntityUtils.toString((HttpEntity)post.getEntity(), (Charset)StandardCharsets.UTF_8);
                    post.addHeader("digi-action", "reg");
                    post.addHeader("Content-Type", "application/json; charset=utf-8");
                    String appToken = TokenProvider.getAppToken();
                    post.addHeader("digi-middleware-auth-app", appToken);
                    HttpResponse httpResponse = this.eaiRegisterUtil.retryRegProdApSrv(post, this.dwHttpClient);
                } else if (response == null) {
                    log.error("[" + Thread.currentThread().getName() + "]" + "<<< '{}' is not avaliable", (Object)this.environment.getProperty("lcdp.modeldriven.eai.reg.prod.resturl"));
                } else {
                    log.error("[" + Thread.currentThread().getName() + "]" + "<<< '{}' response status is {}", (Object)this.environment.getProperty("lcdp.modeldriven.eai.reg.prod.resturl"), (Object)response.getStatusLine().getStatusCode());
                }
            }
            catch (Exception e) {
                log.error("[" + Thread.currentThread().getName() + "]" + "<<< register esp service error !! ", (Throwable)e);
            }
        }
    }
}

